/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.apache.spark.sql.hudi.procedure.TestHdfsParquetImportProcedure$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple8;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0001\u0003\u0001=\u0011a\u0004V3ti\"#gm\u001d)beF,X\r^%na>\u0014H\u000f\u0015:pG\u0016$WO]3\u000b\u0005\r!\u0011!\u00039s_\u000e,G-\u001e:f\u0015\t)a!\u0001\u0003ik\u0012L'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\u000fI_>$\u0017.Z*qCJ\\\u0007K]8dK\u0012,(/\u001a+fgR\u0014\u0015m]3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002CA\t\u0001\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003M\u0019'/Z1uK&s7/\u001a:u%\u0016\u001cwN\u001d3t)\tY2\u0006E\u0002\u001dC\rj\u0011!\b\u0006\u0003=}\tA!\u001e;jY*\t\u0001%\u0001\u0003kCZ\f\u0017B\u0001\u0012\u001e\u0005\u0011a\u0015n\u001d;\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013aB4f]\u0016\u0014\u0018n\u0019\u0006\u0003Q)\tA!\u0019<s_&\u0011!&\n\u0002\u000e\u000f\u0016tWM]5d%\u0016\u001cwN\u001d3\t\u000b1B\u0002\u0019A\u0017\u0002\u0013M\u00148MR8mI\u0016\u0014\bC\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\t17O\u0003\u00023\u0015\u00051\u0001.\u00193p_BL!\u0001N\u0018\u0003\tA\u000bG\u000f\u001b\u0015\u00041Y\u0012\u0005cA\u001c;y5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004uQJ|wo\u001d\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f}\t!![8\n\u0005\u0005s$aC%P\u000bb\u001cW\r\u001d;j_:\fDAH\"KGB\u0011Ai\u0012\b\u0003o\u0015K!A\u0012\u001d\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\rb\nTaI&P=B+\"\u0001T'\u0016\u0003\r#QA\u0014\bC\u0002M\u0013\u0011\u0001V\u0005\u0003!F\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$B\u0001*9\u0003\u0019!\bN]8xgF\u0011Ak\u0016\t\u0003oUK!A\u0016\u001d\u0003\u000f9{G\u000f[5oOB\u0011\u0001l\u0017\b\u0003oeK!A\u0017\u001d\u0002\u000fA\f7m[1hK&\u0011A,\u0018\u0002\n)\"\u0014xn^1cY\u0016T!A\u0017\u001d2\u000b\rz\u0006-\u0019*\u000f\u0005]\u0002\u0017B\u0001*9c\u0011\u0011s\u0007\u000f2\u0003\u000bM\u001c\u0017\r\\12\u0005\u0019b\u0004f\u0001\rf]B\u0019qG\u000f4\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017A\u00029beN,'O\u0003\u0002l\r\u0005A1-\u0019;bYf\u001cH/\u0003\u0002nQ\nq\u0001+\u0019:tK\u0016C8-\u001a9uS>t\u0017\u0007\u0002\u0010D_J\fTaI&PaB\u000bTaI0acJ\u000bDAI\u001c9EF\u0012aE\u001a\u0005\u0006i\u0002!\t!^\u0001\u0014GJ,\u0017\r^3VaN,'\u000f\u001e*fG>\u0014Hm\u001d\u000b\u00037YDQ\u0001L:A\u00025B3a\u001d\u001cyc\u0011q2)\u001f?2\u000b\rZuJ\u001f)2\u000b\rz\u0006m\u001f*2\t\t:\u0004HY\u0019\u0003MqB3a]3\u007fc\u0015q2i`A\u0003c\u0019\u00193jTA\u0001!F21e\u00181\u0002\u0004I\u000bDAI\u001c9EF\u0012aE\u001a\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0003A1XM]5gsJ+7/\u001e7u\t\u0006$\u0018\r\u0006\u0005\u0002\u000e\u0005M\u0011qCA\u0010!\r9\u0014qB\u0005\u0004\u0003#A$\u0001B+oSRDq!!\u0006\u0002\b\u0001\u00071$\u0001\u0006fqB,7\r\u001e#bi\u0006Dq\u0001MA\u0004\u0001\u0004\tI\u0002E\u0002/\u00037I1!!\b0\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\b\u0003C\t9\u00011\u0001D\u0003%!\u0018M\u00197f!\u0006$\bN\u0002\u0004\u0002&\u0001\u0001\u0011q\u0005\u0002\u0010\u0011>|G-[3Ue&\u0004Xj\u001c3fYN!\u00111EA\u0015!\r9\u00141F\u0005\u0004\u0003[A$AB!osJ+g\rC\u0006\u00022\u0005\r\"\u00111A\u0005\u0002\u0005M\u0012!\u0003;j[\u0016\u001cH/Y7q+\t\t)\u0004E\u00028\u0003oI1!!\u000f9\u0005\u0011auN\\4\t\u0017\u0005u\u00121\u0005BA\u0002\u0013\u0005\u0011qH\u0001\u000ei&lWm\u001d;b[B|F%Z9\u0015\t\u00055\u0011\u0011\t\u0005\u000b\u0003\u0007\nY$!AA\u0002\u0005U\u0012a\u0001=%c!Y\u0011qIA\u0012\u0005\u0003\u0005\u000b\u0015BA\u001b\u0003)!\u0018.\\3ti\u0006l\u0007\u000f\t\u0005\u000b\u0003\u0017\n\u0019C!a\u0001\n\u0003a\u0015A\u0002:po.+\u0017\u0010C\u0006\u0002P\u0005\r\"\u00111A\u0005\u0002\u0005E\u0013A\u0003:po.+\u0017p\u0018\u0013fcR!\u0011QBA*\u0011%\t\u0019%!\u0014\u0002\u0002\u0003\u00071\t\u0003\u0006\u0002X\u0005\r\"\u0011!Q!\n\r\u000bqA]8x\u0017\u0016L\b\u0005\u0003\u0006\u0002\\\u0005\r\"\u00111A\u0005\u00021\u000bQA]5eKJD1\"a\u0018\u0002$\t\u0005\r\u0011\"\u0001\u0002b\u0005I!/\u001b3fe~#S-\u001d\u000b\u0005\u0003\u001b\t\u0019\u0007C\u0005\u0002D\u0005u\u0013\u0011!a\u0001\u0007\"Q\u0011qMA\u0012\u0005\u0003\u0005\u000b\u0015B\"\u0002\rILG-\u001a:!\u0011)\tY'a\t\u0003\u0002\u0004%\t\u0001T\u0001\u0007IJLg/\u001a:\t\u0017\u0005=\u00141\u0005BA\u0002\u0013\u0005\u0011\u0011O\u0001\u000bIJLg/\u001a:`I\u0015\fH\u0003BA\u0007\u0003gB\u0011\"a\u0011\u0002n\u0005\u0005\t\u0019A\"\t\u0015\u0005]\u00141\u0005B\u0001B\u0003&1)A\u0004ee&4XM\u001d\u0011\t\u0017\u0005m\u00141\u0005BA\u0002\u0013\u0005\u0011QP\u0001\tE\u0016<\u0017N\u001c'biV\u0011\u0011q\u0010\t\u0004o\u0005\u0005\u0015bAABq\t1Ai\\;cY\u0016D1\"a\"\u0002$\t\u0005\r\u0011\"\u0001\u0002\n\u0006a!-Z4j]2\u000bGo\u0018\u0013fcR!\u0011QBAF\u0011)\t\u0019%!\"\u0002\u0002\u0003\u0007\u0011q\u0010\u0005\f\u0003\u001f\u000b\u0019C!A!B\u0013\ty(A\u0005cK\u001eLg\u000eT1uA!Y\u00111SA\u0012\u0005\u0003\u0007I\u0011AA?\u0003!\u0011WmZ5o\u0019>t\u0007bCAL\u0003G\u0011\t\u0019!C\u0001\u00033\u000bABY3hS:duN\\0%KF$B!!\u0004\u0002\u001c\"Q\u00111IAK\u0003\u0003\u0005\r!a \t\u0017\u0005}\u00151\u0005B\u0001B\u0003&\u0011qP\u0001\nE\u0016<\u0017N\u001c'p]\u0002B1\"a)\u0002$\t\u0005\r\u0011\"\u0001\u0002~\u00051QM\u001c3MCRD1\"a*\u0002$\t\u0005\r\u0011\"\u0001\u0002*\u0006QQM\u001c3MCR|F%Z9\u0015\t\u00055\u00111\u0016\u0005\u000b\u0003\u0007\n)+!AA\u0002\u0005}\u0004bCAX\u0003G\u0011\t\u0011)Q\u0005\u0003\u007f\nq!\u001a8e\u0019\u0006$\b\u0005C\u0006\u00024\u0006\r\"\u00111A\u0005\u0002\u0005u\u0014AB3oI2{g\u000eC\u0006\u00028\u0006\r\"\u00111A\u0005\u0002\u0005e\u0016AC3oI2{gn\u0018\u0013fcR!\u0011QBA^\u0011)\t\u0019%!.\u0002\u0002\u0003\u0007\u0011q\u0010\u0005\f\u0003\u007f\u000b\u0019C!A!B\u0013\ty(A\u0004f]\u0012duN\u001c\u0011\t\u000fU\t\u0019\u0003\"\u0001\u0002DR\u0011\u0012QYAe\u0003\u0017\fi-a4\u0002R\u0006M\u0017Q[Al!\u0011\t9-a\t\u000e\u0003\u0001A\u0001\"!\r\u0002B\u0002\u0007\u0011Q\u0007\u0005\b\u0003\u0017\n\t\r1\u0001D\u0011\u001d\tY&!1A\u0002\rCq!a\u001b\u0002B\u0002\u00071\t\u0003\u0005\u0002|\u0005\u0005\u0007\u0019AA@\u0011!\t\u0019*!1A\u0002\u0005}\u0004\u0002CAR\u0003\u0003\u0004\r!a \t\u0011\u0005M\u0016\u0011\u0019a\u0001\u0003\u007fB\u0001\"a7\u0002$\u0011\u0005\u0013Q\\\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005}\u0017Q\u001d\t\u0004o\u0005\u0005\u0018bAArq\t9!i\\8mK\u0006t\u0007\u0002CAt\u00033\u0004\r!!;\u0002\u0003=\u00042aNAv\u0013\r\ti\u000f\u000f\u0002\u0004\u0003:L\b\u0002CAy\u0003G!\t%a=\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!>\u0011\u0007]\n90C\u0002\u0002zb\u00121!\u00138u\u0001")
public class TestHdfsParquetImportProcedure
extends HoodieSparkProcedureTestBase {
    public java.util.List<GenericRecord> createInsertRecords(Path srcFolder) throws ParseException, IOException {
        Path srcFile = new Path(srcFolder.toString(), "file1.parquet");
        long startTime = HoodieActiveTimeline.parseDateFromInstantTime((String)"20170203000000").getTime() / 1000L;
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 96).foreach((Function1)new Serializable(this, startTime, records){
            public static final long serialVersionUID = 0L;
            private final long startTime$1;
            private final java.util.List records$1;

            public final boolean apply(int recordNum) {
                return this.apply$mcZI$sp(recordNum);
            }

            public boolean apply$mcZI$sp(int recordNum) {
                return this.records$1.add(new HoodieTestDataGenerator().generateGenericRecord(((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), "0", new StringBuilder().append((Object)"rider-").append((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), new StringBuilder().append((Object)"driver-").append((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), this.startTime$1 + TimeUnit.HOURS.toSeconds(recordNum)));
            }
            {
                this.startTime$1 = startTime$1;
                this.records$1 = records$1;
            }
        });
        try (ParquetWriter writer = AvroParquetWriter.builder((Path)srcFile).withSchema(HoodieTestDataGenerator.AVRO_SCHEMA).withConf(HoodieTestUtils.getDefaultHadoopConf()).build();){
            JavaConversions$.MODULE$.asScalaBuffer(records).foreach((Function1)new Serializable(this, writer){
                public static final long serialVersionUID = 0L;
                private final ParquetWriter writer$1;

                public final void apply(GenericRecord record) {
                    this.writer$1.write((Object)record);
                }
                {
                    this.writer$1 = writer$1;
                }
            });
            return records;
        }
    }

    public java.util.List<GenericRecord> createUpsertRecords(Path srcFolder) throws ParseException, IOException {
        Path srcFile = new Path(srcFolder.toString(), "file1.parquet");
        long startTime = HoodieActiveTimeline.parseDateFromInstantTime((String)"20170203000000").getTime() / 1000L;
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1)new Serializable(this, startTime, records, dataGen){
            public static final long serialVersionUID = 0L;
            private final long startTime$2;
            private final ArrayList records$2;
            private final HoodieTestDataGenerator dataGen$1;

            public final boolean apply(int recordNum) {
                return this.apply$mcZI$sp(recordNum);
            }

            public boolean apply$mcZI$sp(int recordNum) {
                return this.records$2.add(this.dataGen$1.generateGenericRecord(((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), "0", new StringBuilder().append((Object)"rider-upsert-").append((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), new StringBuilder().append((Object)"driver-upsert").append((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), this.startTime$2 + TimeUnit.HOURS.toSeconds(recordNum)));
            }
            {
                this.startTime$2 = startTime$2;
                this.records$2 = records$2;
                this.dataGen$1 = dataGen$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(96), 100).foreach((Function1)new Serializable(this, startTime, records, dataGen){
            public static final long serialVersionUID = 0L;
            private final long startTime$2;
            private final ArrayList records$2;
            private final HoodieTestDataGenerator dataGen$1;

            public final boolean apply(int recordNum) {
                return this.apply$mcZI$sp(recordNum);
            }

            public boolean apply$mcZI$sp(int recordNum) {
                return this.records$2.add(this.dataGen$1.generateGenericRecord(((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), "0", new StringBuilder().append((Object)"rider-upsert-").append((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), new StringBuilder().append((Object)"driver-upsert").append((Object)BoxesRunTime.boxToInteger((int)recordNum)).toString(), this.startTime$2 + TimeUnit.HOURS.toSeconds(recordNum)));
            }
            {
                this.startTime$2 = startTime$2;
                this.records$2 = records$2;
                this.dataGen$1 = dataGen$1;
            }
        });
        try (ParquetWriter writer = AvroParquetWriter.builder((Path)srcFile).withSchema(HoodieTestDataGenerator.AVRO_SCHEMA).withConf(HoodieTestUtils.getDefaultHadoopConf()).build();){
            JavaConversions$.MODULE$.asScalaBuffer(records).foreach((Function1)new Serializable(this, writer){
                public static final long serialVersionUID = 0L;
                private final ParquetWriter writer$2;

                public final void apply(GenericRecord record) {
                    this.writer$2.write((Object)record);
                }
                {
                    this.writer$2 = writer$2;
                }
            });
            return records;
        }
    }

    public void org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$verifyResultData(java.util.List<GenericRecord> expectData, FileSystem fs, String tablePath) {
        JavaSparkContext jsc = new JavaSparkContext(this.spark().sparkContext());
        Dataset ds = HoodieClientTestUtils.read((JavaSparkContext)jsc, (String)tablePath, (SQLContext)this.spark().sqlContext(), (FileSystem)fs, (String[])new String[]{new StringBuilder().append((Object)tablePath).append((Object)"/*/*/*/*").toString()});
        java.util.List readData = ds.select("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_row_key", "rider", "driver", "begin_lat", "begin_lon", "end_lat", "end_lon"})).collectAsList();
        List result = (List)JavaConversions$.MODULE$.asScalaBuffer(readData).toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHdfsParquetImportProcedure $outer;

            public final HoodieTripModel apply(Row row) {
                return new HoodieTripModel(this.$outer, row.getLong(0), row.getString(1), row.getString(2), row.getString(3), row.getDouble(4), row.getDouble(5), row.getDouble(6), row.getDouble(7));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        List expected = (List)JavaConversions$.MODULE$.asScalaBuffer(expectData).toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHdfsParquetImportProcedure $outer;

            public final HoodieTripModel apply(GenericRecord g) {
                return new HoodieTripModel(this.$outer, BoxesRunTime.unboxToLong((Object)g.get("timestamp")), g.get("_row_key").toString(), g.get("rider").toString(), g.get("driver").toString(), new StringOps(Predef$.MODULE$.augmentString(g.get("begin_lat").toString())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(g.get("begin_lon").toString())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(g.get("end_lat").toString())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(g.get("end_lon").toString())).toDouble());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        Assertions.assertTrue((expected.size() == result.size() || JavaConversions$.MODULE$.seqAsJavaList((Seq)result).containsAll(JavaConversions$.MODULE$.seqAsJavaList((Seq)expected)) && JavaConversions$.MODULE$.seqAsJavaList((Seq)expected).containsAll(JavaConversions$.MODULE$.seqAsJavaList((Seq)result)) ? 1 : 0) != 0);
    }

    public TestHdfsParquetImportProcedure() {
        this.test("Test Call hdfs_parquet_import Procedure with insert operation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHdfsParquetImportProcedure $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    /*
                     * WARNING - void declaration
                     */
                    public final void apply(File tmp) {
                        String schemaFile;
                        Path targetPath;
                        Path sourcePath;
                        String tablePath;
                        String tableName;
                        FileSystem fs;
                        block3: {
                            fs = FSUtils.getFs((String)tmp.getCanonicalPath(), (Configuration)this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().spark().sparkContext().hadoopConfiguration());
                            tableName = this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().generateTableName();
                            tablePath = new StringBuilder().append((Object)tmp.getCanonicalPath()).append((Object)"/").append((Object)tableName).toString();
                            sourcePath = new Path(tmp.getCanonicalPath(), "source");
                            targetPath = new Path(tablePath);
                            schemaFile = new Path(tmp.getCanonicalPath(), "file.schema").toString();
                            FSDataOutputStream schemaFileOS = fs.create(new Path(schemaFile));
                            try {
                                schemaFileOS.write("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}".getBytes());
                                if (schemaFileOS == null) break block3;
                            }
                            catch (Throwable throwable) {
                                void var8_8;
                                if (var8_8 != null) {
                                    var8_8.close();
                                }
                                throw throwable;
                            }
                            schemaFileOS.close();
                        }
                        java.util.List<GenericRecord> insertData = this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().createInsertRecords(sourcePath);
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().checkExceptionContain(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call hdfs_parquet_import(table_type => 'mor')"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Argument: table is required"})).s((Seq)Nil$.MODULE$));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().checkAnswer(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call hdfs_parquet_import(\n           |table => '", "', table_type => '", "',\n           |src_path => '", "', target_path => '", "',\n           |row_key => '_row_key', partition_key => 'timestamp',\n           |schema_file_path => '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, HoodieTableType.COPY_ON_WRITE.name(), sourcePath, targetPath, schemaFile})))).stripMargin(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$verifyResultData(insertData, fs, tablePath);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestHdfsParquetImportProcedure org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestHdfsParquetImportProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("Test Call hdfs_parquet_import Procedure with upsert operation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestHdfsParquetImportProcedure $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    /*
                     * WARNING - void declaration
                     */
                    public final void apply(File tmp) {
                        String schemaFile;
                        Path targetPath;
                        Path sourcePath;
                        String tablePath;
                        String tableName;
                        FileSystem fs;
                        block3: {
                            fs = FSUtils.getFs((String)tmp.getCanonicalPath(), (Configuration)this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().spark().sparkContext().hadoopConfiguration());
                            tableName = this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().generateTableName();
                            tablePath = new StringBuilder().append((Object)tmp.getCanonicalPath()).append((Object)"/").append((Object)tableName).toString();
                            sourcePath = new Path(tmp.getCanonicalPath(), "source");
                            targetPath = new Path(tablePath);
                            schemaFile = new Path(tmp.getCanonicalPath(), "file.schema").toString();
                            FSDataOutputStream schemaFileOS = fs.create(new Path(schemaFile));
                            try {
                                schemaFileOS.write("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}".getBytes());
                                if (schemaFileOS == null) break block3;
                            }
                            catch (Throwable throwable) {
                                void var8_8;
                                if (var8_8 != null) {
                                    var8_8.close();
                                }
                                throw throwable;
                            }
                            schemaFileOS.close();
                        }
                        java.util.List<GenericRecord> insertData = this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().createUpsertRecords(sourcePath);
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().checkExceptionContain(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call hdfs_parquet_import(table_type => 'mor')"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Argument: table is required"})).s((Seq)Nil$.MODULE$));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().checkAnswer(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call hdfs_parquet_import(\n           |table => '", "', table_type => '", "',\n           |src_path => '", "', target_path => '", "',\n           |row_key => '_row_key', partition_key => 'timestamp',\n           |schema_file_path => '", "', command => 'upsert')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, HoodieTableType.COPY_ON_WRITE.name(), sourcePath, targetPath, schemaFile})))).stripMargin(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$verifyResultData(insertData, fs, tablePath);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestHdfsParquetImportProcedure org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestHdfsParquetImportProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }

    public class HoodieTripModel {
        private long timestamp;
        private String rowKey;
        private String rider;
        private String driver;
        private double beginLat;
        private double beginLon;
        private double endLat;
        private double endLon;
        public final /* synthetic */ TestHdfsParquetImportProcedure $outer;

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public String rowKey() {
            return this.rowKey;
        }

        public void rowKey_$eq(String x$1) {
            this.rowKey = x$1;
        }

        public String rider() {
            return this.rider;
        }

        public void rider_$eq(String x$1) {
            this.rider = x$1;
        }

        public String driver() {
            return this.driver;
        }

        public void driver_$eq(String x$1) {
            this.driver = x$1;
        }

        public double beginLat() {
            return this.beginLat;
        }

        public void beginLat_$eq(double x$1) {
            this.beginLat = x$1;
        }

        public double beginLon() {
            return this.beginLon;
        }

        public void beginLon_$eq(double x$1) {
            this.beginLon = x$1;
        }

        public double endLat() {
            return this.endLat;
        }

        public void endLat_$eq(double x$1) {
            this.endLat = x$1;
        }

        public double endLon() {
            return this.endLon;
        }

        public void endLon_$eq(double x$1) {
            this.endLon = x$1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            HoodieTripModel hoodieTripModel = this;
            Object object = o;
            if (hoodieTripModel == null) {
                if (object == null) return true;
            } else if (((Object)hoodieTripModel).equals(object)) {
                return true;
            }
            if (o == null) return false;
            if (this.getClass() != o.getClass()) {
                return false;
            }
            HoodieTripModel other = (HoodieTripModel)o;
            if (this.timestamp() != other.timestamp()) return false;
            String string = this.rowKey();
            String string2 = other.rowKey();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.rider();
            String string4 = other.rider();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.driver();
            String string6 = other.driver();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (this.beginLat() != other.beginLat()) return false;
            if (this.beginLon() != other.beginLon()) return false;
            if (this.endLat() != other.endLat()) return false;
            if (this.endLon() != other.endLon()) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hashCode(new Tuple8((Object)BoxesRunTime.boxToLong((long)this.timestamp()), (Object)this.rowKey(), (Object)this.rider(), (Object)this.driver(), (Object)BoxesRunTime.boxToDouble((double)this.beginLat()), (Object)BoxesRunTime.boxToDouble((double)this.beginLon()), (Object)BoxesRunTime.boxToDouble((double)this.endLat()), (Object)BoxesRunTime.boxToDouble((double)this.endLon())));
        }

        public /* synthetic */ TestHdfsParquetImportProcedure org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$HoodieTripModel$$$outer() {
            return this.$outer;
        }

        public HoodieTripModel(TestHdfsParquetImportProcedure $outer, long timestamp, String rowKey, String rider, String driver, double beginLat, double beginLon, double endLat, double endLon) {
            this.timestamp = timestamp;
            this.rowKey = rowKey;
            this.rider = rider;
            this.driver = driver;
            this.beginLat = beginLat;
            this.beginLon = beginLon;
            this.endLat = endLat;
            this.endLon = endLon;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

