/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.testutils.HoodieSparkWriteableTestTable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.apache.spark.sql.hudi.procedure.TestRepairsProcedure$;
import org.apache.spark.sql.hudi.procedure.TestRepairsProcedure$$anonfun$3$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001=\u0011A\u0003V3tiJ+\u0007/Y5sgB\u0013xnY3ekJ,'BA\u0002\u0005\u0003%\u0001(o\\2fIV\u0014XM\u0003\u0002\u0006\r\u0005!\u0001.\u001e3j\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\ta\u0002j\\8eS\u0016\u001c\u0006/\u0019:l!J|7-\u001a3ve\u0016$Vm\u001d;CCN,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\t\t\u0002\u0001C\u0004\u001a\u0001\u0001\u0007I\u0011\u0002\u000e\u0002/\u0011,\b\u000f\\5dCR,G\rU1si&$\u0018n\u001c8QCRDW#A\u000e\u0011\u0005q\u0011cBA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\u0012A\u0002)sK\u0012,g-\u0003\u0002$I\t11\u000b\u001e:j]\u001eT!!\t\u0010\t\u000f\u0019\u0002\u0001\u0019!C\u0005O\u0005YB-\u001e9mS\u000e\fG/\u001a3QCJ$\u0018\u000e^5p]B\u000bG\u000f[0%KF$\"\u0001K\u0016\u0011\u0005uI\u0013B\u0001\u0016\u001f\u0005\u0011)f.\u001b;\t\u000f1*\u0013\u0011!a\u00017\u0005\u0019\u0001\u0010J\u0019\t\r9\u0002\u0001\u0015)\u0003\u001c\u0003a!W\u000f\u001d7jG\u0006$X\r\u001a)beRLG/[8o!\u0006$\b\u000e\t\u0005\ba\u0001\u0001\r\u0011\"\u0003\u001b\u0003\t\"W\u000f\u001d7jG\u0006$X\r\u001a)beRLG/[8o!\u0006$\bnV5uQV\u0003H-\u0019;fg\"9!\u0007\u0001a\u0001\n\u0013\u0019\u0014A\n3va2L7-\u0019;fIB\u000b'\u000f^5uS>t\u0007+\u0019;i/&$\b.\u00169eCR,7o\u0018\u0013fcR\u0011\u0001\u0006\u000e\u0005\bYE\n\t\u00111\u0001\u001c\u0011\u00191\u0004\u0001)Q\u00057\u0005\u0019C-\u001e9mS\u000e\fG/\u001a3QCJ$\u0018\u000e^5p]B\u000bG\u000f[,ji\",\u0006\u000fZ1uKN\u0004\u0003b\u0002\u001d\u0001\u0001\u0004%IAG\u0001#IV\u0004H.[2bi\u0016$\u0007+\u0019:uSRLwN\u001c)bi\"<\u0016\u000e\u001e5VaN,'\u000f^:\t\u000fi\u0002\u0001\u0019!C\u0005w\u00051C-\u001e9mS\u000e\fG/\u001a3QCJ$\u0018\u000e^5p]B\u000bG\u000f[,ji\",\u0006o]3siN|F%Z9\u0015\u0005!b\u0004b\u0002\u0017:\u0003\u0003\u0005\ra\u0007\u0005\u0007}\u0001\u0001\u000b\u0015B\u000e\u0002G\u0011,\b\u000f\\5dCR,G\rU1si&$\u0018n\u001c8QCRDw+\u001b;i+B\u001cXM\u001d;tA!9\u0001\t\u0001a\u0001\n\u0013Q\u0012A\u0005:fa\u0006L'/\u001a3PkR\u0004X\u000f\u001e)bi\"DqA\u0011\u0001A\u0002\u0013%1)\u0001\fsKB\f\u0017N]3e\u001fV$\b/\u001e;QCRDw\fJ3r)\tAC\tC\u0004-\u0003\u0006\u0005\t\u0019A\u000e\t\r\u0019\u0003\u0001\u0015)\u0003\u001c\u0003M\u0011X\r]1je\u0016$w*\u001e;qkR\u0004\u0016\r\u001e5!\u0011\u001dA\u0005\u00011A\u0005\n%\u000b!BZ5mK\u001a{'/\\1u+\u0005Q\u0005CA&R\u001b\u0005a%BA'O\u0003\u0015iw\u000eZ3m\u0015\ty\u0005+\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b)I!A\u0015'\u0003!!{w\u000eZ5f\r&dWMR8s[\u0006$\bb\u0002+\u0001\u0001\u0004%I!V\u0001\u000fM&dWMR8s[\u0006$x\fJ3r)\tAc\u000bC\u0004-'\u0006\u0005\t\u0019\u0001&\t\ra\u0003\u0001\u0015)\u0003K\u0003-1\u0017\u000e\\3G_Jl\u0017\r\u001e\u0011\t\u000bi\u0003A\u0011B.\u0002\u001f\u001d,g.\u001a:bi\u0016\u0014VmY8sIN$B\u0001\u000b/_A\")Q,\u0017a\u00017\u0005IA/\u00192mKB\u000bG\u000f\u001b\u0005\u0006?f\u0003\raG\u0001\tE\u0006\u001c\b\u000e]1uQ\")\u0011-\u0017a\u0001E\u0006QQ.\u001a;b\u00072LWM\u001c;\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015t\u0015!\u0002;bE2,\u0017BA4e\u0005UAun\u001c3jKR\u000b'\r\\3NKR\f7\t\\5f]RDQ!\u001b\u0001\u0005\n)\fabZ3u%\u0016\u001cwN\u001d3D_VtG\u000f\u0006\u0002l]B\u0011Q\u0004\\\u0005\u0003[z\u0011A\u0001T8oO\")q\u000e\u001ba\u0001a\u0006)a-\u001b7fgB\u0019Q$]\u000e\n\u0005It\"!B!se\u0006L\b\"\u0002;\u0001\t\u0003)\u0018!H2sK\u0006$X-R7qif\u001cE.Z1o%\u0016\fX/Z:uK\u00124\u0015\u000e\\3\u0015\t!2\bP\u001f\u0005\u0006oN\u0004\raG\u0001\tE\u0006\u001cX\rU1uQ\")\u0011p\u001da\u00017\u0005Y\u0011N\\:uC:$H+[7f\u0011\u0015Y8\u000f1\u0001}\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003\u0011\u0019wN\u001c4\u000b\u0007\u0005\r!\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0004\u0003\u000fq(!D\"p]\u001aLw-\u001e:bi&|g\u000eK\u0003t\u0003\u0017\t\t\u0003E\u0003\u001e\u0003\u001b\t\t\"C\u0002\u0002\u0010y\u0011a\u0001\u001e5s_^\u001c\b\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0003S>T!!a\u0007\u0002\t)\fg/Y\u0005\u0005\u0003?\t)BA\u0006J\u001f\u0016C8-\u001a9uS>t\u0017G\u0002\u0010\u001c\u0003G\t\u0019&M\u0005$\u0003K\tY#!\u0013\u0002.U\u0019!$a\n\u0005\u000f\u0005%bB1\u0001\u00024\t\tA+\u0003\u0003\u0002.\u0005=\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u00022y\ta\u0001\u001e5s_^\u001c\u0018\u0003BA\u001b\u0003w\u00012!HA\u001c\u0013\r\tID\b\u0002\b\u001d>$\b.\u001b8h!\u0011\ti$a\u0011\u000f\u0007u\ty$C\u0002\u0002By\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002F\u0005\u001d#!\u0003+ie><\u0018M\u00197f\u0015\r\t\tEH\u0019\nG\u0005-\u0013QJA(\u0003cq1!HA'\u0013\r\t\tDH\u0019\u0006Euq\u0012\u0011\u000b\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005E\u0001")
public class TestRepairsProcedure
extends HoodieSparkProcedureTestBase {
    private String org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPath;
    private String org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpdates;
    private String org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpserts;
    private String org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath;
    private HoodieFileFormat org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$fileFormat;

    public String org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPath() {
        return this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPath;
    }

    private void org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPath_$eq(String x$1) {
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPath = x$1;
    }

    public String org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpdates() {
        return this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpdates;
    }

    private void org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpdates_$eq(String x$1) {
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpdates = x$1;
    }

    public String org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpserts() {
        return this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpserts;
    }

    private void org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpserts_$eq(String x$1) {
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpserts = x$1;
    }

    public String org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath() {
        return this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath;
    }

    private void org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath_$eq(String x$1) {
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath = x$1;
    }

    public HoodieFileFormat org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$fileFormat() {
        return this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$fileFormat;
    }

    private void org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$fileFormat_$eq(HoodieFileFormat x$1) {
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$fileFormat = x$1;
    }

    public void org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$generateRecords(String tablePath, String bashpath, HoodieTableMetaClient metaClient) {
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPath_$eq(((Object)Paths.get(tablePath, "2016/03/15")).toString());
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpdates_$eq(((Object)Paths.get(tablePath, "2015/03/16")).toString());
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpserts_$eq(((Object)Paths.get(tablePath, "2015/03/17")).toString());
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath_$eq(((Object)Paths.get(bashpath, "tmp")).toString());
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of((HoodieTableMetaClient)metaClient, (Schema)schema);
        java.util.List hoodieRecords1 = SchemaTestUtil.generateHoodieTestRecords((int)0, (int)100, (Schema)schema);
        java.util.List hoodieRecords2 = SchemaTestUtil.generateHoodieTestRecords((int)100, (int)100, (Schema)schema);
        testTable.addCommit("20160401010101").withInserts("2016/03/15", "1", hoodieRecords1);
        testTable.withInserts("2016/03/15", "2", hoodieRecords2);
        testTable.getFileIdWithLogFile("2016/03/15");
        testTable.withInserts("2015/03/16", "4", hoodieRecords1);
        testTable.withInserts("2015/03/17", "6", hoodieRecords1);
        java.util.List dupRecords = hoodieRecords1.subList(0, 10);
        testTable.withInserts("2015/03/16", "5", dupRecords);
        testTable.addCommit("20160401010202").withInserts("2016/03/15", "3", dupRecords);
        testTable.withInserts("2015/03/17", "7", dupRecords);
        testTable.withInserts("2015/03/17", "8", dupRecords);
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$fileFormat_$eq(metaClient.getTableConfig().getBaseFileFormat());
    }

    public long org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$getRecordCount(String[] files) {
        LongRef recordCount = LongRef.create((long)0L);
        Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(this, recordCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestRepairsProcedure $outer;
            private final LongRef recordCount$1;

            public final void apply(String file) {
                block4: {
                    block3: {
                        block2: {
                            if (!HoodieFileFormat.PARQUET.equals(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$fileFormat())) break block2;
                            this.recordCount$1.elem += this.$outer.spark().sqlContext().read().parquet(file).count();
                            break block3;
                        }
                        if (!HoodieFileFormat.ORC.equals(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$fileFormat())) break block4;
                        this.recordCount$1.elem += this.$outer.spark().sqlContext().read().orc(file).count();
                    }
                    return;
                }
                throw new UnsupportedOperationException(new StringBuilder().append((Object)this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$fileFormat().name()).append((Object)" format not supported yet.").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.recordCount$1 = recordCount$1;
            }
        });
        return recordCount.elem;
    }

    public void createEmptyCleanRequestedFile(String basePath, String instantTime, Configuration configuration) throws IOException {
        Path commitFilePath = new Path(new StringBuilder().append((Object)basePath).append((Object)"/").append((Object)".hoodie").append((Object)"/").append((Object)HoodieTimeline.makeRequestedCleanerFileName((String)instantTime)).toString());
        FileSystem fs = FSUtils.getFs((String)basePath, (Configuration)configuration);
        FSDataOutputStream os = fs.create(commitFilePath, true);
        os.close();
    }

    public TestRepairsProcedure() {
        this.test("Test Call repair_add_partition_meta Procedure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestRepairsProcedure $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().generateTableName();
                        String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmp.getCanonicalPath(), tableName}));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '", "'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                        Files.createFile(Paths.get(tablePath, ".hoodie", "100.commit"), new FileAttribute[0]);
                        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new JavaSparkContext(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build();
                        String partition1 = ((Object)Paths.get(tablePath, "2016/03/15")).toString();
                        String partition2 = ((Object)Paths.get(tablePath, "2015/03/16")).toString();
                        String partition3 = ((Object)Paths.get(tablePath, "2015/03/17")).toString();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToBoolean((boolean)metaClient.getFs().mkdirs(new Path(partition1))), BoxesRunTime.boxToBoolean((boolean)true), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToBoolean((boolean)metaClient.getFs().mkdirs(new Path(partition2))), BoxesRunTime.boxToBoolean((boolean)true), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToBoolean((boolean)metaClient.getFs().mkdirs(new Path(partition3))), BoxesRunTime.boxToBoolean((boolean)true), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
                        Row[] dryResult = (Row[])this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call repair_add_partition_meta(table => '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)dryResult.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
                        Row[] realRunResult = (Row[])this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call repair_add_partition_meta(table => '", "', dry_run => false)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)realRunResult.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestRepairsProcedure org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("Test Call repair_overwrite_hoodie_props Procedure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestRepairsProcedure $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().generateTableName();
                        String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmp.getCanonicalPath(), tableName}));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '", "'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                        URL newProps = ((Object)((Object)this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer())).getClass().getClassLoader().getResource("table-config.properties");
                        String expectedOutput = new StringOps(Predef$.MODULE$.augmentString("\n          |[hoodie.archivelog.folder,archived,archive]\n          |[hoodie.database.name,default,null]\n          |[hoodie.datasource.write.drop.partition.columns,false,false]\n          |[hoodie.datasource.write.hive_style_partitioning,true,null]\n          |[hoodie.datasource.write.partitionpath.urlencode,false,null]\n          |[hoodie.table.checksum,,]\n          |[hoodie.table.create.schema,,]\n          |[hoodie.table.keygenerator.class,org.apache.hudi.keygen.NonpartitionedKeyGenerator,null]\n          |[hoodie.table.name,,]\n          |[hoodie.table.precombine.field,ts,null]\n          |[hoodie.table.recordkey.fields,id,null]\n          |[hoodie.table.type,COPY_ON_WRITE,COPY_ON_WRITE]\n          |[hoodie.table.version,,]\n          |[hoodie.timeline.layout.version,,]")).stripMargin().trim();
                        String actual = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call repair_overwrite_hoodie_props(table => '", "', new_props_file_path => '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, newProps.getPath()}))).collect()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Row x0$1) {
                                Row row = x0$1;
                                String string = row.getString(0).equals("hoodie.table.checksum") ? "[hoodie.table.checksum,,]" : (row.getString(0).equals("hoodie.table.create.schema") ? "[hoodie.table.create.schema,,]" : (row.getString(0).equals("hoodie.table.name") ? "[hoodie.table.name,,]" : (row.getString(0).equals("hoodie.table.version") ? "[hoodie.table.version,,]" : (row.getString(0).equals("hoodie.timeline.layout.version") ? "[hoodie.timeline.layout.version,,]" : row.toString()))));
                                return string;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n");
                        Assertions.assertEquals((Object)expectedOutput, (Object)actual);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestRepairsProcedure org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("Test Call repair_corrupted_clean_files Procedure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestRepairsProcedure $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().generateTableName();
                        String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmp.getCanonicalPath(), tableName}));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '", "'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                        ObjectRef metaClient = ObjectRef.create((Object)HoodieTableMetaClient.builder().setConf(new JavaSparkContext(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build());
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(100), 104).foreach$mVc$sp((Function1)new Serializable(this, tablePath, metaClient){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3 $outer;
                            private final String tablePath$1;
                            private final ObjectRef metaClient$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                String timestamp = String.valueOf(i);
                                this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().createEmptyCleanRequestedFile(this.tablePath$1, timestamp, ((HoodieTableMetaClient)this.metaClient$1.elem).getHadoopConf());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tablePath$1 = tablePath$1;
                                this.metaClient$1 = metaClient$1;
                            }
                        });
                        metaClient.elem = HoodieTableMetaClient.reload((HoodieTableMetaClient)((HoodieTableMetaClient)metaClient.elem));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToLong((long)((HoodieTableMetaClient)metaClient.elem).getActiveTimeline().filterInflightsAndRequested().getInstants().count()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().checkAnswer(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call repair_corrupted_clean_files(table => '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true}))}));
                        metaClient.elem = HoodieTableMetaClient.reload((HoodieTableMetaClient)((HoodieTableMetaClient)metaClient.elem));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)((HoodieTableMetaClient)metaClient.elem).getActiveTimeline().filterInflightsAndRequested().getInstants().count()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
                    }

                    public /* synthetic */ $anonfun$3 org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestRepairsProcedure org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPath = null;
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpdates = null;
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpserts = null;
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath = null;
        this.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$fileFormat = null;
        this.test("Test Call repair_deduplicate Procedure with insert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestRepairsProcedure $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().generateTableName();
                        String bashPath = tmp.getCanonicalPath();
                        String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bashPath, tableName}));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  name string,\n           |  favorite_number int,\n           |  favorite_color string\n           |) using hudi\n           | location '", "'\n           | tblproperties (\n           |  primaryKey = 'name',\n           |  type = 'cow'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new JavaSparkContext(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$generateRecords(tablePath, bashPath, metaClient);
                        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
                        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), metaClient.getFs().listStatus(new Path(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPath())));
                        List filteredStatuses = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestBaseFiles().iterator()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(HoodieBaseFile value) {
                                return value.getPath();
                            }
                        }).toList();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)filteredStatuses.size()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
                        String[] files = (String[])filteredStatuses.toArray(ClassTag$.MODULE$.apply(String.class));
                        long recordCount = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$getRecordCount(files);
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)210), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
                        String partitionPath = "2016/03/15";
                        Row[] result = (Row[])this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call repair_deduplicate(table => '", "',\n           | duplicated_partition_path => '", "',\n           | repaired_output_path => '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, partitionPath, this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath()})))).stripMargin()).collect();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
                        FileStatus[] fileStatus = metaClient.getFs().listStatus(new Path(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath()));
                        files = (String[])Predef$.MODULE$.refArrayOps((Object[])fileStatus).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(FileStatus status) {
                                return status.getPath().toString();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        recordCount = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$getRecordCount(files);
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)200), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestRepairsProcedure org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("Test Call repair_deduplicate Procedure with update", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestRepairsProcedure $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().generateTableName();
                        String bashPath = tmp.getCanonicalPath();
                        String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bashPath, tableName}));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  name string,\n           |  favorite_number int,\n           |  favorite_color string\n           |) using hudi\n           | location '", "'\n           | tblproperties (\n           |  primaryKey = 'name',\n           |  type = 'cow'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new JavaSparkContext(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$generateRecords(tablePath, bashPath, metaClient);
                        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
                        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), metaClient.getFs().listStatus(new Path(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpdates())));
                        List filteredStatuses = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestBaseFiles().iterator()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(HoodieBaseFile value) {
                                return value.getPath();
                            }
                        }).toList();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)filteredStatuses.size()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
                        String[] files = (String[])filteredStatuses.toArray(ClassTag$.MODULE$.apply(String.class));
                        long recordCount = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$getRecordCount(files);
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)110), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
                        String partitionPath = "2015/03/16";
                        Row[] result = (Row[])this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call repair_deduplicate(table => '", "',\n           | duplicated_partition_path => '", "',\n           | repaired_output_path => '", "',\n           | dedupe_type => 'update_type')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, partitionPath, this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath()})))).stripMargin()).collect();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
                        FileStatus[] fileStatus = metaClient.getFs().listStatus(new Path(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath()));
                        files = (String[])Predef$.MODULE$.refArrayOps((Object[])fileStatus).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(FileStatus status) {
                                return status.getPath().toString();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        recordCount = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$getRecordCount(files);
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)100), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestRepairsProcedure org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        this.test("Test Call repair_deduplicate Procedure with upsert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestRepairsProcedure $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().generateTableName();
                        String bashPath = tmp.getCanonicalPath();
                        String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bashPath, tableName}));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  name string,\n           |  favorite_number int,\n           |  favorite_color string\n           |) using hudi\n           | location '", "'\n           | tblproperties (\n           |  primaryKey = 'name',\n           |  type = 'cow'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new JavaSparkContext(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$generateRecords(tablePath, bashPath, metaClient);
                        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
                        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), metaClient.getFs().listStatus(new Path(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPathWithUpserts())));
                        List filteredStatuses = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestBaseFiles().iterator()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(HoodieBaseFile value) {
                                return value.getPath();
                            }
                        }).toList();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)filteredStatuses.size()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
                        String[] files = (String[])filteredStatuses.toArray(ClassTag$.MODULE$.apply(String.class));
                        long recordCount = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$getRecordCount(files);
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)120), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
                        String partitionPath = "2015/03/17";
                        Row[] result = (Row[])this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call repair_deduplicate(table => '", "',\n           | duplicated_partition_path => '", "',\n           | repaired_output_path => '", "',\n           | dedupe_type => 'upsert_type')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, partitionPath, this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath()})))).stripMargin()).collect();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
                        FileStatus[] fileStatus = metaClient.getFs().listStatus(new Path(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath()));
                        files = (String[])Predef$.MODULE$.refArrayOps((Object[])fileStatus).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(FileStatus status) {
                                return status.getPath().toString();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        recordCount = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$getRecordCount(files);
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)100), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestRepairsProcedure org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("Test Call repair_deduplicate Procedure with real", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestRepairsProcedure $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().generateTableName();
                        String bashPath = tmp.getCanonicalPath();
                        String tablePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bashPath, tableName}));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  name string,\n           |  favorite_number int,\n           |  favorite_color string\n           |) using hudi\n           | location '", "'\n           | tblproperties (\n           |  primaryKey = 'name',\n           |  type = 'cow'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tablePath})))).stripMargin());
                        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new JavaSparkContext(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sparkContext()).hadoopConfiguration()).setBasePath(tablePath).build();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$generateRecords(tablePath, bashPath, metaClient);
                        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
                        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), metaClient.getFs().listStatus(new Path(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPath())));
                        List filteredStatuses = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestBaseFiles().iterator()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(HoodieBaseFile value) {
                                return value.getPath();
                            }
                        }).toList();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)filteredStatuses.size()), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
                        String[] files = (String[])filteredStatuses.toArray(ClassTag$.MODULE$.apply(String.class));
                        long recordCount = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$getRecordCount(files);
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)210), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
                        String partitionPath = "2016/03/15";
                        Row[] result = (Row[])this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call repair_deduplicate(table => '", "',\n           | duplicated_partition_path => '", "',\n           | repaired_output_path => '", "',\n           | dry_run => false)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, partitionPath, this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$repairedOutputPath()})))).stripMargin()).collect();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
                        FileStatus[] fileStatus = metaClient.getFs().listStatus(new Path(this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$duplicatedPartitionPath()));
                        files = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fileStatus).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(FileStatus status) {
                                return status.getPath().toString();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String p) {
                                return p.endsWith(".parquet");
                            }
                        });
                        recordCount = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$getRecordCount(files);
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)200), BoxesRunTime.boxToLong((long)recordCount), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestRepairsProcedure org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        this.test("Test Call repair_migrate_partition_meta Procedure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestRepairsProcedure $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(File tmp) {
                        String tableName = this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().generateTableName();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |create table ", " (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '", "/", "'\n           | partitioned by (ts)\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tmp.getCanonicalPath(), tableName})))).stripMargin());
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " select 1, 'a1', 10, 1000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " select 2, 'a2', 20, 1500"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
                        Row[] result = (Row[])this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call repair_migrate_partition_meta(table => '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
                        result = (Row[])this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().spark().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call repair_migrate_partition_meta(table => '", "', dry_run => false)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).collect();
                        this.$outer.org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TestRepairsProcedure org$apache$spark$sql$hudi$procedure$TestRepairsProcedure$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestRepairsProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
    }
}

