/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.payload;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.sql.IExpressionEvaluator;
import org.apache.spark.sql.avro.AvroSerializer;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.hudi.SerDeUtils$;
import org.apache.spark.sql.hudi.command.payload.ExpressionCodeGen$;
import org.apache.spark.sql.hudi.command.payload.ExpressionPayload;
import org.apache.spark.sql.hudi.command.payload.ExpressionPayload$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.StringBuilder;

public final class ExpressionPayload$
implements Serializable {
    public static final ExpressionPayload$ MODULE$;
    private final String PAYLOAD_DELETE_CONDITION;
    private final String PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS;
    private final String PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS;
    private final Cache<String, Map<IExpressionEvaluator, IExpressionEvaluator>> cache;
    private final Cache<String, Schema> writeSchemaCache;
    private final Cache<ExpressionPayload.TupleSchema, Schema> mergedSchemaCache;

    static {
        new ExpressionPayload$();
    }

    public String PAYLOAD_DELETE_CONDITION() {
        return this.PAYLOAD_DELETE_CONDITION;
    }

    public String PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS() {
        return this.PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS;
    }

    public String PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS() {
        return this.PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS;
    }

    private Cache<String, Map<IExpressionEvaluator, IExpressionEvaluator>> cache() {
        return this.cache;
    }

    private Cache<String, Schema> writeSchemaCache() {
        return this.writeSchemaCache;
    }

    public Schema setWriteSchema(Properties properties) {
        ValidationUtils.checkArgument((boolean)properties.containsKey(HoodieWriteConfig.WRITE_SCHEMA.key()), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieWriteConfig.WRITE_SCHEMA.key()})));
        return (Schema)this.writeSchemaCache().get((Object)properties.getProperty(HoodieWriteConfig.WRITE_SCHEMA.key()), (Function)new Function<String, Schema>(){

            public Schema apply(String t) {
                return new Schema.Parser().parse(t);
            }
        });
    }

    public Map<IExpressionEvaluator, IExpressionEvaluator> getEvaluator(String serializedConditionAssignments, Schema writeSchema) {
        return (Map)this.cache().get((Object)serializedConditionAssignments, (Function)new Function<String, Map<IExpressionEvaluator, IExpressionEvaluator>>(writeSchema){
            public final Schema writeSchema$1;

            public Map<IExpressionEvaluator, IExpressionEvaluator> apply(String t) {
                byte[] serializedBytes = Base64.getDecoder().decode(t);
                Map conditionAssignments = (Map)SerDeUtils$.MODULE$.toObject(serializedBytes);
                return (Map)conditionAssignments.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.2 $outer;

                    public final Tuple2<IExpressionEvaluator, IExpressionEvaluator> apply(Tuple2<Expression, Seq<Expression>> x0$1) {
                        Tuple2<Expression, Seq<Expression>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Expression condition = (Expression)tuple2._1();
                            Seq assignments = (Seq)tuple2._2();
                            StructType conditionType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("_col0", condition.dataType(), true, StructField$.MODULE$.apply$default$4())})));
                            AvroSerializer conditionSerializer = new AvroSerializer((DataType)conditionType, SchemaConverters$.MODULE$.toAvroType((DataType)conditionType, SchemaConverters$.MODULE$.toAvroType$default$2(), SchemaConverters$.MODULE$.toAvroType$default$3(), SchemaConverters$.MODULE$.toAvroType$default$4()), false);
                            IExpressionEvaluator conditionEvaluator = ExpressionCodeGen$.MODULE$.doCodeGen((Seq<Expression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{condition}))), conditionSerializer);
                            StructType assignSqlType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(this.$outer.writeSchema$1);
                            AvroSerializer assignSerializer = new AvroSerializer((DataType)assignSqlType, this.$outer.writeSchema$1, false);
                            IExpressionEvaluator assignmentEvaluator = ExpressionCodeGen$.MODULE$.doCodeGen((Seq<Expression>)assignments, assignSerializer);
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)conditionEvaluator), (Object)assignmentEvaluator);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            {
                this.writeSchema$1 = writeSchema$1;
            }
        });
    }

    private Cache<ExpressionPayload.TupleSchema, Schema> mergedSchemaCache() {
        return this.mergedSchemaCache;
    }

    public Schema getMergedSchema(Schema source, Schema target) {
        return (Schema)this.mergedSchemaCache().get((Object)new ExpressionPayload.TupleSchema(source, target), (Function)new Function<ExpressionPayload.TupleSchema, Schema>(){

            public Schema apply(ExpressionPayload.TupleSchema t) {
                Schema rightSchema = HoodieAvroUtils.removeMetadataFields((Schema)t.second());
                return ExpressionPayload$.MODULE$.mergeSchema(t.first(), rightSchema);
            }
        });
    }

    public Schema mergeSchema(Schema a, Schema b) {
        Buffer mergedFields = ((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(a.getFields()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Schema.Field apply(Schema.Field field) {
                return new Schema.Field(new StringBuilder().append((Object)"a_").append((Object)field.name()).toString(), field.schema(), field.doc(), field.defaultVal(), field.order());
            }
        }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(b.getFields()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Schema.Field apply(Schema.Field field) {
                return new Schema.Field(new StringBuilder().append((Object)"b_").append((Object)field.name()).toString(), field.schema(), field.doc(), field.defaultVal(), field.order());
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        return Schema.createRecord((String)a.getName(), (String)a.getDoc(), (String)a.getNamespace(), (boolean)a.isError(), (List)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(mergedFields).asJava()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ExpressionPayload$() {
        MODULE$ = this;
        this.PAYLOAD_DELETE_CONDITION = "hoodie.payload.delete.condition";
        this.PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS = "hoodie.payload.update.condition.assignments";
        this.PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS = "hoodie.payload.insert.condition.assignments";
        this.cache = Caffeine.newBuilder().maximumSize(1024L).build();
        this.writeSchemaCache = Caffeine.newBuilder().maximumSize(16L).build();
        this.mergedSchemaCache = Caffeine.newBuilder().maximumSize(16L).build();
    }
}

