/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.CommitsCompareProcedure$;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001#\t92i\\7nSR\u001c8i\\7qCJ,\u0007K]8dK\u0012,(/\u001a\u0006\u0003\u0007\u0011\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t)a!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u001dA\u0011\u0001\u00025vI&T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003']I!\u0001\u0007\u0002\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\b\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\t\u0019\u0002\u0001C\u0004\u001f\u0001\t\u0007I\u0011B\u0010\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u0001!!\r\tCEJ\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t)\u0011I\u001d:bsB\u00111cJ\u0005\u0003Q\t\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\"1!\u0006\u0001Q\u0001\n\u0001\n1\u0002U!S\u00036+E+\u0012*TA!9A\u0006\u0001b\u0001\n\u0013i\u0013aC(V)B+Fk\u0018+Z!\u0016+\u0012A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0003c!\tQ\u0001^=qKNL!a\r\u0019\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u00046\u0001\u0001\u0006IAL\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\t\t\u0005\u0006o\u0001!\taH\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\"B\u001d\u0001\t\u0003i\u0013AC8viB,H\u000fV=qK\")1\b\u0001C!y\u0005!1-\u00197m)\tiT\nE\u0002?\r&s!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\t\u0003\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\t)%%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%aA*fc*\u0011QI\t\t\u0003\u0015.k\u0011\u0001C\u0005\u0003\u0019\"\u00111AU8x\u0011\u0015q%\b1\u0001P\u0003\u0011\t'oZ:\u0011\u0005M\u0001\u0016BA)\u0003\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\")1\u000b\u0001C!)\u0006)!-^5mIV\tQ\u000b\u0005\u0002\u0014-&\u0011qK\u0001\u0002\n!J|7-\u001a3ve\u0016<Q!\u0017\u0002\t\u0002i\u000bqcQ8n[&$8oQ8na\u0006\u0014X\r\u0015:pG\u0016$WO]3\u0011\u0005MYf!B\u0001\u0003\u0011\u0003a6CA.^!\t\tc,\u0003\u0002`E\t1\u0011I\\=SK\u001aDQAG.\u0005\u0002\u0005$\u0012A\u0017\u0005\bGn\u0013\r\u0011\"\u0001e\u0003\u0011q\u0015)T#\u0016\u0003\u0015\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\t1\fgn\u001a\u0006\u0002U\u0006!!.\u0019<b\u0013\tawM\u0001\u0004TiJLgn\u001a\u0005\u0007]n\u0003\u000b\u0011B3\u0002\u000b9\u000bU*\u0012\u0011\t\u000bA\\F\u0011A9\u0002\u000f\t,\u0018\u000e\u001c3feV\t!\u000fE\u0002tqZi\u0011\u0001\u001e\u0006\u0003kZ\f\u0001BZ;oGRLwN\u001c\u0006\u0003o&\fA!\u001e;jY&\u0011\u0011\u0010\u001e\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class CommitsCompareProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "path", DataTypes.StringType, None$.MODULE$)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("compare_detail", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return CommitsCompareProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return CommitsCompareProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Seq seq;
        String sourceLatestCommit;
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        String path = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient source = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieTableMetaClient target = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(path).build();
        HoodieTimeline sourceTimeline = source.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        HoodieTimeline targetTimeline = target.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        String targetLatestCommit = targetTimeline.getInstants().iterator().hasNext() ? ((HoodieInstant)targetTimeline.lastInstant().get()).getTimestamp() : "0";
        String string = sourceLatestCommit = sourceTimeline.getInstants().iterator().hasNext() ? ((HoodieInstant)sourceTimeline.lastInstant().get()).getTimestamp() : "0";
        if (sourceLatestCommit != null && HoodieTimeline.compareTimestamps((String)targetLatestCommit, (BiPredicate)HoodieTimeline.GREATER_THAN, (String)sourceLatestCommit)) {
            List commitsToCatchup = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(targetTimeline.findInstantsAfter(sourceLatestCommit, Integer.MAX_VALUE).getInstants().iterator()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(HoodieInstant instant) {
                    return instant.getTimestamp();
                }
            }).toList()).asJava();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder().append((Object)"Source ").append((Object)source.getTableConfig().getTableName()).append((Object)" is behind by ").append((Object)BoxesRunTime.boxToInteger((int)commitsToCatchup.size())).append((Object)" commits. Commits to catch up - ").append((Object)commitsToCatchup).toString()}))}));
        } else {
            List commitsToCatchup = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(sourceTimeline.findInstantsAfter(targetLatestCommit, Integer.MAX_VALUE).getInstants().iterator()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(HoodieInstant instant) {
                    return instant.getTimestamp();
                }
            }).toList()).asJava();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder().append((Object)"Source ").append((Object)source.getTableConfig().getTableName()).append((Object)" is ahead by ").append((Object)BoxesRunTime.boxToInteger((int)commitsToCatchup.size())).append((Object)" commits. Commits to catch up - ").append((Object)commitsToCatchup).toString()}))}));
        }
        return seq;
    }

    @Override
    public Procedure build() {
        return new CommitsCompareProcedure();
    }
}

