/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.FileNotFoundException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.CreateMetadataTableProcedure$;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001E\u0011Ad\u0011:fCR,W*\u001a;bI\u0006$\u0018\rV1cY\u0016\u0004&o\\2fIV\u0014XM\u0003\u0002\u0004\t\u0005Q\u0001O]8dK\u0012,(/Z:\u000b\u0005\u00151\u0011aB2p[6\fg\u000e\u001a\u0006\u0003\u000f!\tA\u0001[;eS*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\f\u001a!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003']I!\u0001\u0007\u0002\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\bC\u0001\u000e\u001d\u001b\u0005Y\"BA\u0004\r\u0013\ti2DA\nTa\u0006\u00148.\u00113baR,'oU;qa>\u0014H\u000fC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u00111\u0003\u0001\u0005\bG\u0001\u0011\r\u0011\"\u0003%\u0003)\u0001\u0016IU!N\u000bR+%kU\u000b\u0002KA\u0019a%K\u0016\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012Q!\u0011:sCf\u0004\"a\u0005\u0017\n\u00055\u0012!A\u0005)s_\u000e,G-\u001e:f!\u0006\u0014\u0018-\\3uKJDaa\f\u0001!\u0002\u0013)\u0013a\u0003)B%\u0006kU\tV#S'\u0002Bq!\r\u0001C\u0002\u0013%!'A\u0006P+R\u0003V\u000bV0U3B+U#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005YB\u0011!\u0002;za\u0016\u001c\u0018B\u0001\u001d6\u0005)\u0019FO];diRK\b/\u001a\u0005\u0007u\u0001\u0001\u000b\u0011B\u001a\u0002\u0019=+F\u000bU+U?RK\u0006+\u0012\u0011\t\u000bq\u0002A\u0011\u0001\u0013\u0002\u0015A\f'/Y7fi\u0016\u00148\u000fC\u0003?\u0001\u0011\u0005!'\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016DQ\u0001\u0011\u0001\u0005B\u0005\u000bAaY1mYR\u0011!I\u0015\t\u0004\u0007.seB\u0001#J\u001d\t)\u0005*D\u0001G\u0015\t9\u0005#\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011!jJ\u0001\ba\u0006\u001c7.Y4f\u0013\taUJA\u0002TKFT!AS\u0014\u0011\u0005=\u0003V\"\u0001\u0005\n\u0005EC!a\u0001*po\")1k\u0010a\u0001)\u0006!\u0011M]4t!\t\u0019R+\u0003\u0002W\u0005\ti\u0001K]8dK\u0012,(/Z!sONDQ\u0001\u0017\u0001\u0005Be\u000bQAY;jY\u0012,\u0012!I\u0004\u00067\nA\t\u0001X\u0001\u001d\u0007J,\u0017\r^3NKR\fG-\u0019;b)\u0006\u0014G.\u001a)s_\u000e,G-\u001e:f!\t\u0019RLB\u0003\u0002\u0005!\u0005al\u0005\u0002^?B\u0011a\u0005Y\u0005\u0003C\u001e\u0012a!\u00118z%\u00164\u0007\"B\u0010^\t\u0003\u0019G#\u0001/\t\u000f\u0015l&\u0019!C\u0001M\u0006!a*Q'F+\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0011a\u0017M\\4\u000b\u00031\fAA[1wC&\u0011a.\u001b\u0002\u0007'R\u0014\u0018N\\4\t\rAl\u0006\u0015!\u0003h\u0003\u0015q\u0015)T#!\u0011\u001d\u0011X\f1A\u0005\u0002M\fQ#\\3uC\u0012\fG/\u0019\"bg\u0016$\u0015N]3di>\u0014\u00180F\u0001u!\r1So^\u0005\u0003m\u001e\u0012aa\u00149uS>t\u0007C\u0001=|\u001d\t1\u00130\u0003\u0002{O\u00051\u0001K]3eK\u001aL!A\u001c?\u000b\u0005i<\u0003b\u0002@^\u0001\u0004%\ta`\u0001\u001a[\u0016$\u0018\rZ1uC\n\u000b7/\u001a#je\u0016\u001cGo\u001c:z?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005\u001d\u0001c\u0001\u0014\u0002\u0004%\u0019\u0011QA\u0014\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0013i\u0018\u0011!a\u0001i\u0006\u0019\u0001\u0010J\u0019\t\u000f\u00055Q\f)Q\u0005i\u00061R.\u001a;bI\u0006$\u0018MQ1tK\u0012K'/Z2u_JL\b\u0005C\u0004\u0002\u0012u#\t!a\u0005\u0002\u000f\t,\u0018\u000e\u001c3feV\u0011\u0011Q\u0003\t\u0006\u0003/\t\tCF\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005Aa-\u001e8di&|gNC\u0002\u0002 -\fA!\u001e;jY&!\u00111EA\r\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\b")
public class CreateMetadataTableProcedure
extends BaseProcedure
implements ProcedureBuilder,
SparkAdapterSupport {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private final SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static Supplier<ProcedureBuilder> builder() {
        return CreateMetadataTableProcedure$.MODULE$.builder();
    }

    public static void metadataBaseDirectory_$eq(Option<String> option) {
        CreateMetadataTableProcedure$.MODULE$.metadataBaseDirectory_$eq(option);
    }

    public static Option<String> metadataBaseDirectory() {
        return CreateMetadataTableProcedure$.MODULE$.metadataBaseDirectory();
    }

    public static String NAME() {
        return CreateMetadataTableProcedure$.MODULE$.NAME();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        CreateMetadataTableProcedure createMetadataTableProcedure = this;
        synchronized (createMetadataTableProcedure) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.class.sparkAdapter((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
            return this.sparkAdapter;
        }
    }

    public SparkAdapter sparkAdapter() {
        return this.bitmap$0 ? this.sparkAdapter : this.sparkAdapter$lzycompute();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Boolean bl;
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        Path metadataPath = new Path(HoodieTableMetadata.getMetadataTableBasePath((String)basePath));
        try {
            FileStatus[] statuses = metaClient.getFs().listStatus(metadataPath);
            if (Predef$.MODULE$.refArrayOps((Object[])statuses).nonEmpty()) {
                throw new RuntimeException(new StringBuilder().append((Object)"Metadata directory (").append((Object)metadataPath.toString()).append((Object)") not empty.").toString());
            }
            bl = BoxedUnit.UNIT;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = BoxesRunTime.boxToBoolean((boolean)metaClient.getFs().mkdirs(metadataPath));
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        HoodieWriteConfig writeConfig = this.getWriteConfig(basePath);
        SparkHoodieBackedTableMetadataWriter.create((Configuration)metaClient.getHadoopConf(), (HoodieWriteConfig)writeConfig, (HoodieEngineContext)new HoodieSparkEngineContext(this.jsc()));
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder().append((Object)"Created Metadata Table in ").append((Object)metadataPath).append((Object)" (duration=").append((Object)BoxesRunTime.boxToDouble((double)((double)timer.endTimer() / 1000.0))).append((Object)"secs)").toString()}))}));
    }

    @Override
    public CreateMetadataTableProcedure build() {
        return new CreateMetadataTableProcedure();
    }

    public CreateMetadataTableProcedure() {
        SparkAdapterSupport.class.$init$((SparkAdapterSupport)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

