/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RollbackToInstantTimeProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.None$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001#\tq\"k\u001c7mE\u0006\u001c7\u000eV8J]N$\u0018M\u001c;US6,\u0007K]8dK\u0012,(/\u001a\u0006\u0003\u0007\u0011\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t)a!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u001dA\u0011\u0001\u00025vI&T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003']I!\u0001\u0007\u0002\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\b\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\t\u0019\u0002\u0001C\u0004\u001f\u0001\t\u0007I\u0011B\u0010\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u0001!!\r\tCEJ\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t)\u0011I\u001d:bsB\u00111cJ\u0005\u0003Q\t\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\"1!\u0006\u0001Q\u0001\n\u0001\n1\u0002U!S\u00036+E+\u0012*TA!9A\u0006\u0001b\u0001\n\u0013i\u0013aC(V)B+Fk\u0018+Z!\u0016+\u0012A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0003c!\tQ\u0001^=qKNL!a\r\u0019\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u00046\u0001\u0001\u0006IAL\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\t\t\u0005\u0006o\u0001!\taH\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\"B\u001d\u0001\t\u0003i\u0013AC8viB,H\u000fV=qK\")1\b\u0001C!y\u0005!1-\u00197m)\tiT\nE\u0002?\r&s!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\t\u0003\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\t)%%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%aA*fc*\u0011QI\t\t\u0003\u0015.k\u0011\u0001C\u0005\u0003\u0019\"\u00111AU8x\u0011\u0015q%\b1\u0001P\u0003\u0011\t'oZ:\u0011\u0005M\u0001\u0016BA)\u0003\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\")1\u000b\u0001C!)\u0006)!-^5mIV\tQ\u000b\u0005\u0002\u0014-&\u0011qK\u0001\u0002\n!J|7-\u001a3ve\u0016<Q!\u0017\u0002\t\u0002i\u000baDU8mY\n\f7m\u001b+p\u0013:\u001cH/\u00198u)&lW\r\u0015:pG\u0016$WO]3\u0011\u0005MYf!B\u0001\u0003\u0011\u0003a6CA.^!\t\tc,\u0003\u0002`E\t1\u0011I\\=SK\u001aDQAG.\u0005\u0002\u0005$\u0012A\u0017\u0005\bGn\u0013\r\u0011\"\u0001e\u0003\u0011q\u0015)T#\u0016\u0003\u0015\u0004\"AZ5\u000f\u0005\u0005:\u0017B\u00015#\u0003\u0019\u0001&/\u001a3fM&\u0011!n\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!\u0014\u0003BB7\\A\u0003%Q-A\u0003O\u00036+\u0005\u0005C\u0003p7\u0012\u0005\u0001/A\u0004ck&dG-\u001a:\u0016\u0003E\u00042A]=\u0017\u001b\u0005\u0019(B\u0001;v\u0003!1WO\\2uS>t'B\u0001<x\u0003\u0011)H/\u001b7\u000b\u0003a\fAA[1wC&\u0011!p\u001d\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class RollbackToInstantTimeProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "instant_time", DataTypes.StringType, None$.MODULE$)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("rollback_result", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return RollbackToInstantTimeProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RollbackToInstantTimeProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Row> call(ProcedureArgs args) {
        void var10_10;
        void var3_3;
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        String instantTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        SparkRDDWriteClient<? extends HoodieRecordPayload<?>> client = this.createHoodieClient(this.jsc(), basePath);
        client.getConfig().setValue(HoodieWriteConfig.ROLLBACK_USING_MARKERS_ENABLE, "false");
        HoodieWriteConfig config = this.getWriteConfig(basePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(config.getBasePath()).setLoadActiveTimelineOnLoad(false).setConsistencyGuardConfig(config.getConsistencyGuardConfig()).setLayoutVersion(Option.of((Object)new TimelineLayoutVersion(config.getTimelineLayoutVersion()))).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline completedTimeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        boolean filteredTimeline = completedTimeline.containsInstant(instantTime);
        if (filteredTimeline) {
            boolean result = client.rollback(instantTime);
            Row outputRow = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result)}));
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{outputRow}));
        }
        throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Commit ", " not found in Commits ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3, var10_10})));
    }

    @Override
    public Procedure build() {
        return new RollbackToInstantTimeProcedure();
    }
}

