/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.cli.BootstrapExecutorUtils;
import org.apache.hudi.cli.HDFSParquetImporterUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RunBootstrapProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001#\t)\"+\u001e8C_>$8\u000f\u001e:baB\u0013xnY3ekJ,'BA\u0002\u0005\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003\u000b\u0019\tqaY8n[\u0006tGM\u0003\u0002\b\u0011\u0005!\u0001.\u001e3j\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\u0011\u0001!CF\r\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!\u0004\"bg\u0016\u0004&o\\2fIV\u0014X\r\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u0011!J|7-\u001a3ve\u0016\u0014U/\u001b7eKJ\u0004\"AG\u000f\u000e\u0003mQ!\u0001\b\u0006\u0002\u0011%tG/\u001a:oC2L!AH\u000e\u0003\u000f1{wmZ5oO\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003'\u0001Aq\u0001\n\u0001C\u0002\u0013%Q%\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012A\n\t\u0004O)bS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Mi\u0013B\u0001\u0018\u0003\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\t\rA\u0002\u0001\u0015!\u0003'\u0003-\u0001\u0016IU!N\u000bR+%k\u0015\u0011\t\u000fI\u0002!\u0019!C\u0005g\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005!\u0004CA\u001b9\u001b\u00051$BA\u001c\t\u0003\u0015!\u0018\u0010]3t\u0013\tIdG\u0001\u0006TiJ,8\r\u001e+za\u0016Daa\u000f\u0001!\u0002\u0013!\u0014\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0003\"B\u001f\u0001\t\u0003)\u0013A\u00039be\u0006lW\r^3sg\")q\b\u0001C\u0001g\u0005Qq.\u001e;qkR$\u0016\u0010]3\t\u000b\u0005\u0003A\u0011\t\"\u0002\t\r\fG\u000e\u001c\u000b\u0003\u0007N\u00032\u0001\u0012'P\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002I!\u00051AH]8pizJ\u0011!K\u0005\u0003\u0017\"\nq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\n\u00191+Z9\u000b\u0005-C\u0003C\u0001)R\u001b\u0005A\u0011B\u0001*\t\u0005\r\u0011vn\u001e\u0005\u0006)\u0002\u0003\r!V\u0001\u0005CJ<7\u000f\u0005\u0002\u0014-&\u0011qK\u0001\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\t\u000be\u0003A\u0011\t.\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0003\t:Q\u0001\u0018\u0002\t\u0002u\u000bQCU;o\u0005>|Go\u001d;sCB\u0004&o\\2fIV\u0014X\r\u0005\u0002\u0014=\u001a)\u0011A\u0001E\u0001?N\u0011a\f\u0019\t\u0003O\u0005L!A\u0019\u0015\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0001c\f\"\u0001e)\u0005i\u0006b\u00024_\u0005\u0004%\taZ\u0001\u0005\u001d\u0006kU)F\u0001i!\tIg.D\u0001k\u0015\tYG.\u0001\u0003mC:<'\"A7\u0002\t)\fg/Y\u0005\u0003_*\u0014aa\u0015;sS:<\u0007BB9_A\u0003%\u0001.A\u0003O\u00036+\u0005\u0005C\u0003t=\u0012\u0005A/A\u0004ck&dG-\u001a:\u0016\u0003U\u00042A^>\u0017\u001b\u00059(B\u0001=z\u0003!1WO\\2uS>t'B\u0001>m\u0003\u0011)H/\u001b7\n\u0005q<(\u0001C*vaBd\u0017.\u001a:")
public class RunBootstrapProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RunBootstrapProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RunBootstrapProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        BoxedUnit boxedUnit;
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        String tableType = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        String bootstrapPath = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        String basePath = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).get();
        String rowKeyField = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[4]).get();
        String baseFileFormat = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[5]).get();
        String partitionPathField = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[6]).get();
        String bootstrapIndexClass = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[7]).get();
        String selectorClass = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[8]).get();
        String keyGeneratorClass = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[9]).get();
        String fullBootstrapInputProvider = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[10]).get();
        String schemaProviderClass = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[11]).get();
        String payloadClass = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[12]).get();
        int parallelism = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[13]).get());
        boolean enableHiveSync = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[14]).get());
        String propsFilePath = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[15]).get();
        boolean bootstrapOverwrite = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[16]).get());
        ArrayList<String> configs = new ArrayList<String>();
        TypedProperties properties = propsFilePath == null || propsFilePath.isEmpty() ? HDFSParquetImporterUtils.buildProperties(configs) : HDFSParquetImporterUtils.readConfig(this.jsc().hadoopConfiguration(), new Path(propsFilePath), configs).getProps(true);
        properties.setProperty(HoodieBootstrapConfig.BASE_PATH.key(), bootstrapPath);
        Object object = !StringUtils.isNullOrEmpty((String)keyGeneratorClass) && KeyGeneratorType.getNames().contains(keyGeneratorClass.toUpperCase(Locale.ROOT)) ? properties.setProperty(HoodieBootstrapConfig.KEYGEN_TYPE.key(), keyGeneratorClass.toUpperCase(Locale.ROOT)) : properties.setProperty(HoodieBootstrapConfig.KEYGEN_CLASS_NAME.key(), keyGeneratorClass);
        properties.setProperty(HoodieBootstrapConfig.FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME.key(), fullBootstrapInputProvider);
        properties.setProperty(HoodieBootstrapConfig.PARALLELISM_VALUE.key(), ((Object)BoxesRunTime.boxToInteger((int)parallelism)).toString());
        properties.setProperty(HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.key(), selectorClass);
        properties.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), rowKeyField);
        properties.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), partitionPathField);
        FileSystem fs = FSUtils.getFs((String)basePath, (Configuration)this.jsc().hadoopConfiguration());
        BootstrapExecutorUtils.Config cfg = new BootstrapExecutorUtils.Config();
        cfg.setTableName((String)tableName.get());
        cfg.setTableType(tableType);
        cfg.setBasePath(basePath);
        cfg.setBaseFileFormat(baseFileFormat);
        cfg.setBootstrapIndexClass(bootstrapIndexClass);
        cfg.setSchemaProviderClass(schemaProviderClass);
        cfg.setPayloadClass(payloadClass);
        cfg.setEnableHiveSync(Predef$.MODULE$.boolean2Boolean(enableHiveSync));
        cfg.setBootstrapOverwrite(Predef$.MODULE$.boolean2Boolean(bootstrapOverwrite));
        try {
            new BootstrapExecutorUtils(cfg, this.jsc(), fs, this.jsc().hadoopConfiguration(), properties).execute();
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Run bootstrap failed due to"})).s((Seq)Nil$.MODULE$);
                }
            }, exception);
            boxedUnit = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-1)}))}));
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))}));
    }

    @Override
    public RunBootstrapProcedure build() {
        return new RunBootstrapProcedure();
    }

    public RunBootstrapProcedure() {
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "table_type", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(2, "bootstrap_path", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(3, "base_path", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(4, "rowKey_field", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(5, "base_file_format", DataTypes.StringType, "PARQUET"), ProcedureParameter$.MODULE$.optional(6, "partition_path_field", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(7, "bootstrap_index_class", DataTypes.StringType, "org.apache.hudi.common.bootstrap.index.HFileBootstrapIndex"), ProcedureParameter$.MODULE$.optional(8, "selector_class", DataTypes.StringType, "org.apache.hudi.client.bootstrap.selector.MetadataOnlyBootstrapModeSelector"), ProcedureParameter$.MODULE$.optional(9, "key_generator_glass", DataTypes.StringType, "org.apache.hudi.keygen.SimpleKeyGenerator"), ProcedureParameter$.MODULE$.optional(10, "full_bootstrap_input_provider", DataTypes.StringType, "org.apache.hudi.bootstrap.SparkParquetBootstrapDataProvider"), ProcedureParameter$.MODULE$.optional(11, "schema_provider_class", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(12, "payload_class", DataTypes.StringType, "org.apache.hudi.common.model.OverwriteWithLatestAvroPayload"), ProcedureParameter$.MODULE$.optional(13, "parallelism", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)1500)), ProcedureParameter$.MODULE$.optional(14, "enable_hive_sync", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(15, "props_file_path", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(16, "bootstrap_overwrite", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("status", DataTypes.IntegerType, true, Metadata$.MODULE$.empty())}));
    }
}

