/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowBootstrapMappingProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001E\u0011Qd\u00155po\n{w\u000e^:ue\u0006\u0004X*\u00199qS:<\u0007K]8dK\u0012,(/\u001a\u0006\u0003\u0007\u0011\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t)a!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u001dA\u0011\u0001\u00025vI&T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003']I!\u0001\u0007\u0002\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\b\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\t\u0019\u0002\u0001C\u0004\u001f\u0001\t\u0007I\u0011B\u0010\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u0001!!\r\tCEJ\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t)\u0011I\u001d:bsB\u00111cJ\u0005\u0003Q\t\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\"1!\u0006\u0001Q\u0001\n\u0001\n1\u0002U!S\u00036+E+\u0012*TA!9A\u0006\u0001b\u0001\n\u0013i\u0013aC(V)B+Fk\u0018+Z!\u0016+\u0012A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0003c!\tQ\u0001^=qKNL!a\r\u0019\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u00046\u0001\u0001\u0006IAL\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\t\t\u0005\u0006o\u0001!\taH\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\"B\u001d\u0001\t\u0003i\u0013AC8viB,H\u000fV=qK\")1\b\u0001C!y\u0005!1-\u00197m)\tiT\nE\u0002?\r&s!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\t\u0003\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\t)%%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%aA*fc*\u0011QI\t\t\u0003\u0015.k\u0011\u0001C\u0005\u0003\u0019\"\u00111AU8x\u0011\u0015q%\b1\u0001P\u0003\u0011\t'oZ:\u0011\u0005M\u0001\u0016BA)\u0003\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\")1\u000b\u0001C\u0005)\u0006Q2M]3bi\u0016\u0014un\u001c;tiJ\f\u0007/\u00138eKb\u0014V-\u00193feR\u0011QK\u0019\t\u0003-\u0002l\u0011a\u0016\u0006\u00031f\u000baBQ8piN$(/\u00199J]\u0012,\u0007P\u0003\u0002[7\u0006)\u0011N\u001c3fq*\u0011A,X\u0001\nE>|Go\u001d;sCBT!AX0\u0002\r\r|W.\\8o\u0015\t9A\"\u0003\u0002b/\nY\u0011J\u001c3fqJ+\u0017\rZ3s\u0011\u0015\u0019'\u000b1\u0001e\u0003)iW\r^1DY&,g\u000e\u001e\t\u0003K\"l\u0011A\u001a\u0006\u0003Ov\u000bQ\u0001^1cY\u0016L!!\u001b4\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\")1\u000e\u0001C!Y\u0006)!-^5mIV\tQ\u000e\u0005\u0002\u0014]&\u0011qN\u0001\u0002\n!J|7-\u001a3ve\u0016<Q!\u001d\u0002\t\u0002I\fQd\u00155po\n{w\u000e^:ue\u0006\u0004X*\u00199qS:<\u0007K]8dK\u0012,(/\u001a\t\u0003'M4Q!\u0001\u0002\t\u0002Q\u001c\"a];\u0011\u0005\u00052\u0018BA<#\u0005\u0019\te.\u001f*fM\")!d\u001dC\u0001sR\t!\u000fC\u0004|g\n\u0007I\u0011\u0001?\u0002\t9\u000bU*R\u000b\u0002{B\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005!A.\u00198h\u0015\t\t)!\u0001\u0003kCZ\f\u0017bAA\u0005\u007f\n11\u000b\u001e:j]\u001eDq!!\u0004tA\u0003%Q0A\u0003O\u00036+\u0005\u0005C\u0004\u0002\u0012M$\t!a\u0005\u0002\u000f\t,\u0018\u000e\u001c3feV\u0011\u0011Q\u0003\t\u0006\u0003/\t\tCF\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005Aa-\u001e8di&|gN\u0003\u0003\u0002 \u0005\r\u0011\u0001B;uS2LA!a\t\u0002\u001a\tA1+\u001e9qY&,'\u000f")
public class ShowBootstrapMappingProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "partition_path", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(2, "file_ids", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(3, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.optional(4, "sort_by", DataTypes.StringType, "partition"), ProcedureParameter$.MODULE$.optional(5, "desc", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false))});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("source_base_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("source_partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("source_file", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowBootstrapMappingProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowBootstrapMappingProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Boolean bl;
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        String partitionPath = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        String fileIds = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).get());
        String sortBy = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[4]).get();
        boolean desc = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[5]).get());
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        if (partitionPath.isEmpty() && new StringOps(Predef$.MODULE$.augmentString(fileIds)).nonEmpty()) {
            throw new IllegalStateException("PartitionPath is mandatory when passing fileIds.");
        }
        BootstrapIndex.IndexReader indexReader = this.createBootstrapIndexReader(metaClient);
        List indexedPartitions = indexReader.getIndexedPartitionPaths();
        Object object = new StringOps(Predef$.MODULE$.augmentString(partitionPath)).nonEmpty() && !indexedPartitions.contains(partitionPath) ? new HoodieException(new StringBuilder().append((Object)partitionPath).append((Object)" is not an valid indexed partition").toString()) : BoxedUnit.UNIT;
        ArrayList mappingList = new ArrayList();
        if (new StringOps(Predef$.MODULE$.augmentString(fileIds)).nonEmpty()) {
            List fileGroupIds = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])fileIds.split(",")).toList().map((Function1)new Serializable(this, partitionPath){
                public static final long serialVersionUID = 0L;
                private final String partitionPath$1;

                public final HoodieFileGroupId apply(String fileId) {
                    return new HoodieFileGroupId(this.partitionPath$1, fileId);
                }
                {
                    this.partitionPath$1 = partitionPath$1;
                }
            }, List$.MODULE$.canBuildFrom())).asJava();
            bl = BoxesRunTime.boxToBoolean((boolean)mappingList.addAll(indexReader.getSourceFileMappingForFileIds(fileGroupIds).values()));
        } else if (new StringOps(Predef$.MODULE$.augmentString(partitionPath)).nonEmpty()) {
            bl = BoxesRunTime.boxToBoolean((boolean)mappingList.addAll(indexReader.getSourceFileMappingForPartition(partitionPath)));
        } else {
            JavaConversions$.MODULE$.asScalaBuffer(indexedPartitions).foreach((Function1)new Serializable(this, indexReader, mappingList){
                public static final long serialVersionUID = 0L;
                private final BootstrapIndex.IndexReader indexReader$1;
                private final ArrayList mappingList$1;

                public final boolean apply(String part) {
                    return this.mappingList$1.addAll(this.indexReader$1.getSourceFileMappingForPartition(part));
                }
                {
                    this.indexReader$1 = indexReader$1;
                    this.mappingList$1 = mappingList$1;
                }
            });
            bl = BoxedUnit.UNIT;
        }
        List rows = JavaConversions$.MODULE$.seqAsJavaList((Seq)((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(mappingList).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(BootstrapFileMapping mapping) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapping.getPartitionPath(), mapping.getFileId(), mapping.getBootstrapBasePath(), mapping.getBootstrapPartitionPath(), mapping.getBootstrapFileStatus().getPath().getUri()}));
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList());
        Dataset df = this.spark().createDataFrame(rows, this.OUTPUT_TYPE());
        return desc ? Predef$.MODULE$.wrapRefArray((Object[])df.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply(sortBy).desc()})).limit(limit).collect()) : Predef$.MODULE$.wrapRefArray((Object[])df.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply(sortBy).asc()})).limit(limit).collect());
    }

    private BootstrapIndex.IndexReader createBootstrapIndexReader(HoodieTableMetaClient metaClient) {
        BootstrapIndex index = BootstrapIndex.getBootstrapIndex((HoodieTableMetaClient)metaClient);
        if (index.useIndex()) {
            return index.createReader();
        }
        throw new HoodieException("This is not a bootstrapped Hudi table. Don't have any index info");
    }

    @Override
    public Procedure build() {
        return new ShowBootstrapMappingProcedure();
    }
}

