/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.StatsFileSizeProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001E\u0011ac\u0015;biN4\u0015\u000e\\3TSj,\u0007K]8dK\u0012,(/\u001a\u0006\u0003\u0007\u0011\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t)a!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u001dA\u0011\u0001\u00025vI&T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003']I!\u0001\u0007\u0002\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\b\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\t\u0019\u0002\u0001C\u0003\u001f\u0001\u0011\u0005s$\u0001\u0006qCJ\fW.\u001a;feN,\u0012\u0001\t\t\u0004C\u00112S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005M9\u0013B\u0001\u0015\u0003\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\t\u000b)\u0002A\u0011I\u0016\u0002\u0015=,H\u000f];u)f\u0004X-F\u0001-!\ti\u0003'D\u0001/\u0015\ty\u0003\"A\u0003usB,7/\u0003\u00022]\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bM\u0002A\u0011\t\u001b\u0002\t\r\fG\u000e\u001c\u000b\u0003k\u0015\u00032A\u000e B\u001d\t9DH\u0004\u00029w5\t\u0011H\u0003\u0002;!\u00051AH]8pizJ\u0011aI\u0005\u0003{\t\nq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\n\u00191+Z9\u000b\u0005u\u0012\u0003C\u0001\"D\u001b\u0005A\u0011B\u0001#\t\u0005\r\u0011vn\u001e\u0005\u0006\rJ\u0002\raR\u0001\u0005CJ<7\u000f\u0005\u0002\u0014\u0011&\u0011\u0011J\u0001\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\t\u000b-\u0003A\u0011\u0001'\u0002-A\u0014\u0018N\u001c;GS2,7+\u001b>f\u0011&\u001cHo\\4sC6$2!Q'W\u0011\u0015q%\n1\u0001P\u0003-Ign\u001d;b]R$\u0016.\\3\u0011\u0005A\u001bfBA\u0011R\u0013\t\u0011&%\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*#\u0011\u00159&\n1\u0001Y\u0003!\u0019h.\u00199tQ>$\bCA-a\u001b\u0005Q&BA.]\u0003\u001diW\r\u001e:jGNT!!\u00180\u0002\u0011\r|G-\u00195bY\u0016T\u0011aX\u0001\u0004G>l\u0017BA1[\u0005!\u0019f.\u00199tQ>$\b\"B2\u0001\t\u0003\"\u0017!\u00022vS2$W#A3\u0011\u0005M1\u0017BA4\u0003\u0005%\u0001&o\\2fIV\u0014XmB\u0003j\u0005!\u0005!.\u0001\fTi\u0006$8OR5mKNK'0\u001a)s_\u000e,G-\u001e:f!\t\u00192NB\u0003\u0002\u0005!\u0005An\u0005\u0002l[B\u0011\u0011E\\\u0005\u0003_\n\u0012a!\u00118z%\u00164\u0007\"\u0002\u000el\t\u0003\tH#\u00016\t\u000fM\\'\u0019!C\u0001i\u0006IQ*\u0011-`\r&cUiU\u000b\u0002kB\u0011\u0011E^\u0005\u0003o\n\u00121!\u00138u\u0011\u0019I8\u000e)A\u0005k\u0006QQ*\u0011-`\r&cUi\u0015\u0011\t\u000fm\\'\u0019!C\u0001y\u0006!a*Q'F+\u0005i\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00027b]\u001eT!!!\u0002\u0002\t)\fg/Y\u0005\u0003)~Dq!a\u0003lA\u0003%Q0A\u0003O\u00036+\u0005\u0005C\u0004\u0002\u0010-$\t!!\u0005\u0002\u000f\t,\u0018\u000e\u001c3feV\u0011\u00111\u0003\t\u0006\u0003+\tyBF\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005Aa-\u001e8di&|gN\u0003\u0003\u0002\u001e\u0005\r\u0011\u0001B;uS2LA!!\t\u0002\u0018\tA1+\u001e9qY&,'\u000f")
public class StatsFileSizeProcedure
extends BaseProcedure
implements ProcedureBuilder {
    public static Supplier<ProcedureBuilder> builder() {
        return StatsFileSizeProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return StatsFileSizeProcedure$.MODULE$.NAME();
    }

    public static int MAX_FILES() {
        return StatsFileSizeProcedure$.MODULE$.MAX_FILES();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "partition_path", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(2, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
    }

    @Override
    public StructType outputType() {
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("min", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("10th", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("50th", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("avg", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("95th", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("max", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_files", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("std_dev", DataTypes.DoubleType, true, Metadata$.MODULE$.empty())}));
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        this.checkArgs(this.parameters(), args);
        Option<Object> table = this.getArgValueOrDefault(args, this.parameters()[0]);
        String globRegex = (String)this.getArgValueOrDefault(args, this.parameters()[1]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.parameters()[2]).get());
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieWrapperFileSystem fs = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build().getFs();
        String globPath = String.format("%s/%s/*", basePath, globRegex);
        List statuses = FSUtils.getGlobStatusExcludingMetaFolder((FileSystem)fs, (Path)new Path(globPath));
        Histogram globalHistogram = new Histogram((Reservoir)new UniformReservoir(StatsFileSizeProcedure$.MODULE$.MAX_FILES()));
        HashMap commitHistogramMap = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(statuses).asScala()).foreach((Function1)new Serializable(this, globalHistogram, commitHistogramMap){
            public static final long serialVersionUID = 0L;
            private final Histogram globalHistogram$1;
            private final HashMap commitHistogramMap$1;

            public final void apply(FileStatus status) {
                String instantTime = FSUtils.getCommitTime((String)status.getPath().getName());
                long len = status.getLen();
                this.commitHistogramMap$1.putIfAbsent(instantTime, new Histogram((Reservoir)new UniformReservoir(StatsFileSizeProcedure$.MODULE$.MAX_FILES())));
                ((Histogram)this.commitHistogramMap$1.get(instantTime)).update(len);
                this.globalHistogram$1.update(len);
            }
            {
                this.globalHistogram$1 = globalHistogram$1;
                this.commitHistogramMap$1 = commitHistogramMap$1;
            }
        });
        ArrayList<Row> rows = new ArrayList<Row>();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(commitHistogramMap).asScala()).foreach((Function1)new Serializable(this, rows){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsFileSizeProcedure $outer;
            private final List rows$1;

            public final boolean apply(Tuple2<String, Histogram> x0$1) {
                Tuple2<String, Histogram> tuple2 = x0$1;
                if (tuple2 != null) {
                    String instantTime = (String)tuple2._1();
                    Histogram histogram = (Histogram)tuple2._2();
                    Snapshot snapshot = histogram.getSnapshot();
                    boolean bl = this.rows$1.add(this.$outer.printFileSizeHistogram(instantTime, snapshot));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rows$1 = rows$1;
            }
        });
        Snapshot snapshot = globalHistogram.getSnapshot();
        rows.add(this.printFileSizeHistogram("ALL", snapshot));
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Object r) {
                return (Row)r;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
    }

    public Row printFileSizeHistogram(String instantTime, Snapshot snapshot) {
        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instantTime, BoxesRunTime.boxToLong((long)snapshot.getMin()), BoxesRunTime.boxToDouble((double)snapshot.getValue(0.1)), BoxesRunTime.boxToDouble((double)snapshot.getMedian()), BoxesRunTime.boxToDouble((double)snapshot.getMean()), BoxesRunTime.boxToDouble((double)snapshot.get95thPercentile()), BoxesRunTime.boxToLong((long)snapshot.getMax()), BoxesRunTime.boxToInteger((int)snapshot.size()), BoxesRunTime.boxToDouble((double)snapshot.getStdDev())}));
    }

    @Override
    public Procedure build() {
        return new StatsFileSizeProcedure();
    }
}

