/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.StatsWriteAmplificationProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001#\t\u00013\u000b^1ug^\u0013\u0018\u000e^3B[Bd\u0017NZ5dCRLwN\u001c)s_\u000e,G-\u001e:f\u0015\t\u0019A!\u0001\u0006qe>\u001cW\rZ;sKNT!!\u0002\u0004\u0002\u000f\r|W.\\1oI*\u0011q\u0001C\u0001\u0005QV$\u0017N\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t\u0019r#\u0003\u0002\u0019\u0005\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM\u001d\u0005\u00065\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"a\u0005\u0001\t\u000by\u0001A\u0011I\u0010\u0002\u0015A\f'/Y7fi\u0016\u00148/F\u0001!!\r\tCEJ\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t)\u0011I\u001d:bsB\u00111cJ\u0005\u0003Q\t\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\")!\u0006\u0001C!W\u0005Qq.\u001e;qkR$\u0016\u0010]3\u0016\u00031\u0002\"!\f\u0019\u000e\u00039R!a\f\u0005\u0002\u000bQL\b/Z:\n\u0005Er#AC*ueV\u001cG\u000fV=qK\")1\u0007\u0001C!i\u0005!1-\u00197m)\t)T\tE\u00027}\u0005s!a\u000e\u001f\u000f\u0005aZT\"A\u001d\u000b\u0005i\u0002\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\ti$%A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0002%aA*fc*\u0011QH\t\t\u0003\u0005\u000ek\u0011\u0001C\u0005\u0003\t\"\u00111AU8x\u0011\u00151%\u00071\u0001H\u0003\u0011\t'oZ:\u0011\u0005MA\u0015BA%\u0003\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\")1\n\u0001C!\u0019\u0006)!-^5mIV\tQ\n\u0005\u0002\u0014\u001d&\u0011qJ\u0001\u0002\n!J|7-\u001a3ve\u0016<Q!\u0015\u0002\t\u0002I\u000b\u0001e\u0015;biN<&/\u001b;f\u00036\u0004H.\u001b4jG\u0006$\u0018n\u001c8Qe>\u001cW\rZ;sKB\u00111c\u0015\u0004\u0006\u0003\tA\t\u0001V\n\u0003'V\u0003\"!\t,\n\u0005]\u0013#AB!osJ+g\rC\u0003\u001b'\u0012\u0005\u0011\fF\u0001S\u0011\u001dY6K1A\u0005\u0002q\u000bAAT!N\u000bV\tQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006!A.\u00198h\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\rM#(/\u001b8h\u0011\u001917\u000b)A\u0005;\u0006)a*Q'FA!)\u0001n\u0015C\u0001S\u00069!-^5mI\u0016\u0014X#\u00016\u0011\u0007-\u0004h#D\u0001m\u0015\tig.\u0001\u0005gk:\u001cG/[8o\u0015\ty\u0017-\u0001\u0003vi&d\u0017BA9m\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\b")
public class StatsWriteAmplificationProcedure
extends BaseProcedure
implements ProcedureBuilder {
    public static Supplier<ProcedureBuilder> builder() {
        return StatsWriteAmplificationProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return StatsWriteAmplificationProcedure$.MODULE$.NAME();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
    }

    @Override
    public StructType outputType() {
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_upserted", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("write_amplification_factor", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        this.checkArgs(this.parameters(), args);
        Option<Object> table = this.getArgValueOrDefault(args, this.parameters()[0]);
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.parameters()[1]).get());
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieTableMetaClient client = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = client.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitTimeline().filterCompletedInstants();
        ArrayList<Row> rows = new ArrayList<Row>();
        DecimalFormat df = new DecimalFormat("#.00");
        LongRef totalRecordsUpserted = LongRef.create((long)0L);
        LongRef totalRecordsWritten = LongRef.create((long)0L);
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(timeline.getInstants().iterator()).asScala()).foreach((Function1)new Serializable(this, activeTimeline, rows, df, totalRecordsUpserted, totalRecordsWritten){
            public static final long serialVersionUID = 0L;
            private final HoodieActiveTimeline activeTimeline$1;
            private final ArrayList rows$1;
            private final DecimalFormat df$1;
            private final LongRef totalRecordsUpserted$1;
            private final LongRef totalRecordsWritten$1;

            public final void apply(HoodieInstant instantTime) {
                String waf = "0";
                HoodieCommitMetadata commit = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])this.activeTimeline$1.getInstantDetails(instantTime).get()), HoodieCommitMetadata.class);
                if (commit.fetchTotalUpdateRecordsWritten() > 0L) {
                    waf = this.df$1.format((float)commit.fetchTotalRecordsWritten() / (float)commit.fetchTotalUpdateRecordsWritten());
                }
                this.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instantTime.getTimestamp(), BoxesRunTime.boxToLong((long)commit.fetchTotalUpdateRecordsWritten()), BoxesRunTime.boxToLong((long)commit.fetchTotalRecordsWritten()), waf})));
                this.totalRecordsUpserted$1.elem += commit.fetchTotalUpdateRecordsWritten();
                this.totalRecordsWritten$1.elem += commit.fetchTotalRecordsWritten();
            }
            {
                this.activeTimeline$1 = activeTimeline$1;
                this.rows$1 = rows$1;
                this.df$1 = df$1;
                this.totalRecordsUpserted$1 = totalRecordsUpserted$1;
                this.totalRecordsWritten$1 = totalRecordsWritten$1;
            }
        });
        String waf = "0";
        if (totalRecordsUpserted.elem > 0L) {
            waf = df.format((float)totalRecordsWritten.elem / (float)totalRecordsUpserted.elem);
        }
        rows.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Total", BoxesRunTime.boxToLong((long)totalRecordsUpserted.elem), BoxesRunTime.boxToLong((long)totalRecordsWritten.elem), waf})));
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Object r) {
                return (Row)r;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
    }

    @Override
    public Procedure build() {
        return new StatsWriteAmplificationProcedure();
    }
}

