/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.admin.AdminClient$;
import kafka.admin.AdminClient$ConsumerSummary$;
import kafka.common.KafkaException;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.MemberSummary;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.GroupCoordinatorRequest;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rmd\u0001B\u0001\u0003\u0001\u001d\u00111\"\u00113nS:\u001cE.[3oi*\u00111\u0001B\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t+\u0001\u0011)\u0019!C\u0001-\u0005!A/[7f+\u00059\u0002C\u0001\r\"\u001b\u0005I\"BA\t\u001b\u0015\tYB$\u0001\u0004d_6lwN\u001c\u0006\u0003\u000buQ!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO&\u0011!%\u0007\u0002\u0005)&lW\r\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u0018\u0003\u0015!\u0018.\\3!\u0011!1\u0003A!b\u0001\n\u00039\u0013\u0001\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'t+\u0005A\u0003CA\u0005*\u0013\tQ#BA\u0002J]RD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0012e\u0016\fX/Z:u)&lWm\\;u\u001bN\u0004\u0003\u0002\u0003\u0018\u0001\u0005\u000b\u0007I\u0011A\u0018\u0002\r\rd\u0017.\u001a8u+\u0005\u0001\u0004CA\u00199\u001b\u0005\u0011$BA\u001a5\u0003%Ig\u000e^3s]\u0006d7O\u0003\u00026m\u0005A1m\u001c8tk6,'O\u0003\u000289\u000591\r\\5f]R\u001c\u0018BA\u001d3\u0005U\u0019uN\\:v[\u0016\u0014h*\u001a;x_J\\7\t\\5f]RD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\bG2LWM\u001c;!\u0011!i\u0004A!b\u0001\n\u0003q\u0014\u0001\u00052p_R\u001cHO]1q\u0005J|7.\u001a:t+\u0005y\u0004c\u0001!I\u0017:\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005\u001dS\u0011a\u00029bG.\fw-Z\u0005\u0003\u0013*\u0013A\u0001T5ti*\u0011qI\u0003\t\u0003\u00196k\u0011AG\u0005\u0003\u001dj\u0011AAT8eK\"A\u0001\u000b\u0001B\u0001B\u0003%q(A\tc_>$8\u000f\u001e:ba\n\u0013xn[3sg\u0002BQA\u0015\u0001\u0005\u0002M\u000ba\u0001P5oSRtD#\u0002+W/bK\u0006CA+\u0001\u001b\u0005\u0011\u0001\"B\u000bR\u0001\u00049\u0002\"\u0002\u0014R\u0001\u0004A\u0003\"\u0002\u0018R\u0001\u0004\u0001\u0004\"B\u001fR\u0001\u0004y\u0004\"B.\u0001\t\u0013a\u0016\u0001B:f]\u0012$B!X3h[B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0006if\u0004Xm\u001d\u0006\u0003Ej\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003I~\u0013aa\u0015;sk\u000e$\b\"\u00024[\u0001\u0004Y\u0015A\u0002;be\u001e,G\u000fC\u0003i5\u0002\u0007\u0011.A\u0002ba&\u0004\"A[6\u000e\u0003\u0005L!\u0001\\1\u0003\u000f\u0005\u0003\u0018nS3zg\")aN\u0017a\u0001_\u00069!/Z9vKN$\bC\u00019t\u001b\u0005\t(B\u0001:\u001b\u0003!\u0011X-];fgR\u001c\u0018B\u0001;r\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\"\u0002<\u0001\t\u00139\u0018aC:f]\u0012\fe.\u001f(pI\u0016$2!\u0018=z\u0011\u0015AW\u000f1\u0001j\u0011\u0015qW\u000f1\u0001p\u0011\u0015Y\b\u0001\"\u0003}\u0003=1\u0017N\u001c3D_>\u0014H-\u001b8bi>\u0014HCA&~\u0011\u0015q(\u00101\u0001\u0000\u0003\u001d9'o\\;q\u0013\u0012\u0004B!!\u0001\u0002\n9!\u00111AA\u0003!\t\u0011%\"C\u0002\u0002\b)\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u0004\u0015!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0011A\u00037jgR<%o\\;qgR!\u0011QCA\u0012!\u0011\u0001\u0005*a\u0006\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b\u0005\u0003-\u0019wn\u001c:eS:\fGo\u001c:\n\t\u0005\u0005\u00121\u0004\u0002\u000e\u000fJ|W\u000f](wKJ4\u0018.Z<\t\u000f\u0005\u0015\u0012q\u0002a\u0001\u0017\u0006!an\u001c3f\u0011\u001d\tI\u0003\u0001C\u0005\u0003W\taBZ5oI\u0006cGN\u0011:pW\u0016\u00148\u000fF\u0001@\u0011\u001d\ty\u0003\u0001C\u0001\u0003c\tQ\u0002\\5ti\u0006cGn\u0012:pkB\u001cHCAA\u001a!\u001d\t\t!!\u000eL\u0003+IA!a\u000e\u0002\u000e\t\u0019Q*\u00199\t\u000f\u0005m\u0002\u0001\"\u0001\u00022\u0005)B.[:u\u00032d7i\u001c8tk6,'o\u0012:pkB\u001c\bbBA \u0001\u0011\u0005\u0011\u0011I\u0001\u0017Y&\u001cH/\u00117m\u000fJ|W\u000f]:GY\u0006$H/\u001a8fIR\u0011\u0011Q\u0003\u0005\b\u0003\u000b\u0002A\u0011AA!\u0003ya\u0017n\u001d;BY2\u001cuN\\:v[\u0016\u0014xI]8vaN4E.\u0019;uK:,G\rC\u0004\u0002J\u0001!\t!a\u0013\u0002\u001b\u0011,7o\u0019:jE\u0016<%o\\;q)\u0011\ti%a\u0015\u0011\t\u0005e\u0011qJ\u0005\u0005\u0003#\nYB\u0001\u0007He>,\boU;n[\u0006\u0014\u0018\u0010\u0003\u0004\u007f\u0003\u000f\u0002\ra \u0004\u0007\u0003/\u0002\u0001)!\u0017\u0003\u001f\r{gn];nKJ\u001cV/\\7bef\u001cr!!\u0016\t\u00037\n\t\u0007E\u0002\n\u0003;J1!a\u0018\u000b\u0005\u001d\u0001&o\u001c3vGR\u00042!CA2\u0013\r\t)G\u0003\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\f\u0003S\n)F!f\u0001\n\u0003\tY'\u0001\u0005nK6\u0014WM]%e+\u0005y\bBCA8\u0003+\u0012\t\u0012)A\u0005\u007f\u0006IQ.Z7cKJLE\r\t\u0005\f\u0003g\n)F!f\u0001\n\u0003\tY'\u0001\u0005dY&,g\u000e^%e\u0011)\t9(!\u0016\u0003\u0012\u0003\u0006Ia`\u0001\nG2LWM\u001c;JI\u0002B1\"a\u001f\u0002V\tU\r\u0011\"\u0001\u0002l\u0005Q1\r\\5f]RDun\u001d;\t\u0015\u0005}\u0014Q\u000bB\tB\u0003%q0A\u0006dY&,g\u000e\u001e%pgR\u0004\u0003bCAB\u0003+\u0012)\u001a!C\u0001\u0003\u000b\u000b!\"Y:tS\u001etW.\u001a8u+\t\t9\t\u0005\u0003A\u0011\u0006%\u0005c\u0001'\u0002\f&\u0019\u0011Q\u0012\u000e\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"Y\u0011\u0011SA+\u0005#\u0005\u000b\u0011BAD\u0003-\t7o]5h]6,g\u000e\u001e\u0011\t\u000fI\u000b)\u0006\"\u0001\u0002\u0016RQ\u0011qSAN\u0003;\u000by*!)\u0011\t\u0005e\u0015QK\u0007\u0002\u0001!9\u0011\u0011NAJ\u0001\u0004y\bbBA:\u0003'\u0003\ra \u0005\b\u0003w\n\u0019\n1\u0001\u0000\u0011!\t\u0019)a%A\u0002\u0005\u001d\u0005BCAS\u0003+\n\t\u0011\"\u0001\u0002(\u0006!1m\u001c9z))\t9*!+\u0002,\u00065\u0016q\u0016\u0005\n\u0003S\n\u0019\u000b%AA\u0002}D\u0011\"a\u001d\u0002$B\u0005\t\u0019A@\t\u0013\u0005m\u00141\u0015I\u0001\u0002\u0004y\bBCAB\u0003G\u0003\n\u00111\u0001\u0002\b\"Q\u00111WA+#\u0003%\t!!.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0017\u0016\u0004\u007f\u0006e6FAA^!\u0011\ti,a2\u000e\u0005\u0005}&\u0002BAa\u0003\u0007\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015'\"\u0001\u0006b]:|G/\u0019;j_:LA!!3\u0002@\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u00055\u0017QKI\u0001\n\u0003\t),\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0015\u0005E\u0017QKI\u0001\n\u0003\t),\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u0015\u0005U\u0017QKI\u0001\n\u0003\t9.\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005e'\u0006BAD\u0003sC!\"!8\u0002V\u0005\u0005I\u0011IAp\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u001d\t\u0005\u0003G\fi/\u0004\u0002\u0002f*!\u0011q]Au\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0018\u0001\u00026bm\u0006LA!a\u0003\u0002f\"I\u0011\u0011_A+\u0003\u0003%\taJ\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0003k\f)&!A\u0005\u0002\u0005]\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003s\fy\u0010E\u0002\n\u0003wL1!!@\u000b\u0005\r\te.\u001f\u0005\n\u0005\u0003\t\u00190!AA\u0002!\n1\u0001\u001f\u00132\u0011)\u0011)!!\u0016\u0002\u0002\u0013\u0005#qA\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0002\t\u0007\u0005\u0017\u0011\t\"!?\u000e\u0005\t5!b\u0001B\b\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tM!Q\u0002\u0002\t\u0013R,'/\u0019;pe\"Q!qCA+\u0003\u0003%\tA!\u0007\u0002\u0011\r\fg.R9vC2$BAa\u0007\u0003\"A\u0019\u0011B!\b\n\u0007\t}!BA\u0004C_>dW-\u00198\t\u0015\t\u0005!QCA\u0001\u0002\u0004\tI\u0010\u0003\u0006\u0003&\u0005U\u0013\u0011!C!\u0005O\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002Q!Q!1FA+\u0003\u0003%\tE!\f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!9\t\u0015\tE\u0012QKA\u0001\n\u0003\u0012\u0019$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00057\u0011)\u0004\u0003\u0006\u0003\u0002\t=\u0012\u0011!a\u0001\u0003s<\u0011B!\u000f\u0001\u0003\u0003E\tAa\u000f\u0002\u001f\r{gn];nKJ\u001cV/\\7bef\u0004B!!'\u0003>\u0019I\u0011q\u000b\u0001\u0002\u0002#\u0005!qH\n\u0007\u0005{\u0011\t%!\u0019\u0011\u0017\t\r#\u0011J@\u0000\u007f\u0006\u001d\u0015qS\u0007\u0003\u0005\u000bR1Aa\u0012\u000b\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0013\u0003F\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\t\u000fI\u0013i\u0004\"\u0001\u0003PQ\u0011!1\b\u0005\u000b\u0005W\u0011i$!A\u0005F\t5\u0002B\u0003B+\u0005{\t\t\u0011\"!\u0003X\u0005)\u0011\r\u001d9msRQ\u0011q\u0013B-\u00057\u0012iFa\u0018\t\u000f\u0005%$1\u000ba\u0001\u007f\"9\u00111\u000fB*\u0001\u0004y\bbBA>\u0005'\u0002\ra \u0005\t\u0003\u0007\u0013\u0019\u00061\u0001\u0002\b\"Q!1\rB\u001f\u0003\u0003%\tI!\u001a\u0002\u000fUt\u0017\r\u001d9msR!!q\rB:!\u0015I!\u0011\u000eB7\u0013\r\u0011YG\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011%\u0011yg`@\u0000\u0003\u000fK1A!\u001d\u000b\u0005\u0019!V\u000f\u001d7fi!Q!Q\u000fB1\u0003\u0003\u0005\r!a&\u0002\u0007a$\u0003\u0007C\u0004\u0003z\u0001!\tAa\u001f\u0002+\u0011,7o\u0019:jE\u0016\u001cuN\\:v[\u0016\u0014xI]8vaR!!Q\u0010BA!\u0015I!\u0011\u000eB@!\u0011\u0001\u0005*a&\t\ry\u00149\b1\u0001\u0000\u0011\u001d\u0011)\t\u0001C\u0001\u0005\u000f\u000bQa\u00197pg\u0016$\"A!#\u0011\u0007%\u0011Y)C\u0002\u0003\u000e*\u0011A!\u00168ji\u001e9!\u0011\u0013\u0002\t\u0002\tM\u0015aC!e[&t7\t\\5f]R\u00042!\u0016BK\r\u0019\t!\u0001#\u0001\u0003\u0018N\u0019!Q\u0013\u0005\t\u000fI\u0013)\n\"\u0001\u0003\u001cR\u0011!1\u0013\u0005\n\u0005?\u0013)J1A\u0005\u0002\u001d\n!\u0004R3gCVdGoQ8o]\u0016\u001cG/[8o\u001b\u0006D\u0018\n\u001a7f\u001bND\u0001Ba)\u0003\u0016\u0002\u0006I\u0001K\u0001\u001c\t\u00164\u0017-\u001e7u\u0007>tg.Z2uS>tW*\u0019=JI2,Wj\u001d\u0011\t\u0013\t\u001d&Q\u0013b\u0001\n\u00039\u0013a\u0006#fM\u0006,H\u000e\u001e*fcV,7\u000f\u001e+j[\u0016|W\u000f^'t\u0011!\u0011YK!&!\u0002\u0013A\u0013\u0001\u0007#fM\u0006,H\u000e\u001e*fcV,7\u000f\u001e+j[\u0016|W\u000f^'tA!I!q\u0016BK\u0005\u0004%\taJ\u0001(\t\u00164\u0017-\u001e7u\u001b\u0006D\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo\u001d)fe\u000e{gN\\3di&|g\u000e\u0003\u0005\u00034\nU\u0005\u0015!\u0003)\u0003!\"UMZ1vYRl\u0015\r_%o\r2Lw\r\u001b;SKF,Xm\u001d;t!\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8!\u0011%\u00119L!&C\u0002\u0013\u0005q%A\rEK\u001a\fW\u000f\u001c;SK\u000e|gN\\3di\n\u000b7m[8gM6\u001b\b\u0002\u0003B^\u0005+\u0003\u000b\u0011\u0002\u0015\u00025\u0011+g-Y;miJ+7m\u001c8oK\u000e$()Y2l_\u001a4Wj\u001d\u0011\t\u0013\t}&Q\u0013b\u0001\n\u00039\u0013A\u0006#fM\u0006,H\u000e^*f]\u0012\u0014UO\u001a4fe\nKH/Z:\t\u0011\t\r'Q\u0013Q\u0001\n!\nq\u0003R3gCVdGoU3oI\n+hMZ3s\u0005f$Xm\u001d\u0011\t\u0013\t\u001d'Q\u0013b\u0001\n\u00039\u0013!\u0007#fM\u0006,H\u000e\u001e*fG\u0016Lg/\u001a\"vM\u001a,'OQ=uKND\u0001Ba3\u0003\u0016\u0002\u0006I\u0001K\u0001\u001b\t\u00164\u0017-\u001e7u%\u0016\u001cW-\u001b<f\u0005V4g-\u001a:CsR,7\u000f\t\u0005\n\u0005\u001f\u0014)J1A\u0005\u0002\u001d\nQ\u0003R3gCVdGOU3uef\u0014\u0015mY6pM\u001al5\u000f\u0003\u0005\u0003T\nU\u0005\u0015!\u0003)\u0003Y!UMZ1vYR\u0014V\r\u001e:z\u0005\u0006\u001c7n\u001c4g\u001bN\u0004\u0003B\u0003Bl\u0005+\u0013\r\u0011\"\u0001\u0003Z\u0006)\u0012\tZ7j]\u000ec\u0017.\u001a8u\u0013\u0012\u001cV-];f]\u000e,WC\u0001Bn!\u0011\u0011iNa;\u000e\u0005\t}'\u0002\u0002Bq\u0005G\fa!\u0019;p[&\u001c'\u0002\u0002Bs\u0005O\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0011I/!;\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005[\u0014yNA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\n\u0005c\u0014)\n)A\u0005\u00057\fa#\u00113nS:\u001cE.[3oi&#7+Z9vK:\u001cW\r\t\u0005\u000b\u0005k\u0014)J1A\u0005\u0002\t]\u0018AD!e[&t7i\u001c8gS\u001e$UMZ\u000b\u0003\u0005s\u0004BAa?\u0004\u00025\u0011!Q \u0006\u0004\u0005\u007fT\u0012AB2p]\u001aLw-\u0003\u0003\u0004\u0004\tu(!C\"p]\u001aLw\rR3g\u0011%\u00199A!&!\u0002\u0013\u0011I0A\bBI6LgnQ8oM&<G)\u001a4!\r\u001d\u0019YA!&\u0001\u0007\u001b\u00111\"\u00113nS:\u001cuN\u001c4jON!1\u0011BB\b!\u0011\u0011Yp!\u0005\n\t\rM!Q \u0002\u000f\u0003\n\u001cHO]1di\u000e{gNZ5h\u0011-\u00199b!\u0003\u0003\u0002\u0003\u0006Ia!\u0007\u0002\u0013=\u0014\u0018nZ5oC2\u001c\bGBB\u000e\u0007C\u0019y\u0003\u0005\u0005\u0002\u0002\u0005U2QDB\u0017!\u0011\u0019yb!\t\r\u0001\u0011a11EB\u000b\u0003\u0003\u0005\tQ!\u0001\u0004&\t\u0019q\fJ\u0019\u0012\t\r\u001d\u0012\u0011 \t\u0004\u0013\r%\u0012bAB\u0016\u0015\t9aj\u001c;iS:<\u0007\u0003BB\u0010\u0007_!Ab!\r\u0004\u0016\u0005\u0005\t\u0011!B\u0001\u0007K\u00111a\u0018\u00133\u0011\u001d\u00116\u0011\u0002C\u0001\u0007k!Baa\u000e\u0004<A!1\u0011HB\u0005\u001b\t\u0011)\n\u0003\u0005\u0004\u0018\rM\u0002\u0019AB\u001fa\u0019\u0019yda\u0011\u0004HAA\u0011\u0011AA\u001b\u0007\u0003\u001a)\u0005\u0005\u0003\u0004 \r\rC\u0001DB\u0012\u0007w\t\t\u0011!A\u0003\u0002\r\u0015\u0002\u0003BB\u0010\u0007\u000f\"Ab!\r\u0004<\u0005\u0005\t\u0011!B\u0001\u0007KA\u0001ba\u0013\u0003\u0016\u0012\u00051QJ\u0001\u0016GJ,\u0017\r^3TS6\u0004H.\u001a)mC&tG/\u001a=u)\r!6q\n\u0005\b\u0007#\u001aI\u00051\u0001\u0000\u0003%\u0011'o\\6feV\u0013H\u000e\u0003\u0005\u0004V\tUE\u0011AB,\u0003\u0019\u0019'/Z1uKR\u0019Ak!\u0017\t\u0011\rm31\u000ba\u0001\u0007;\nQ\u0001\u001d:paN\u0004Baa\u0018\u0004b5\u0011!q]\u0005\u0005\u0007G\u00129O\u0001\u0006Qe>\u0004XM\u001d;jKND\u0001b!\u0016\u0003\u0016\u0012\u00051q\r\u000b\u0004)\u000e%\u0004\u0002CB.\u0007K\u0002\raa\u001b1\t\r54\u0011\u000f\t\b\u0003\u0003\t)d`B8!\u0011\u0019yb!\u001d\u0005\u0019\rM4\u0011NA\u0001\u0002\u0003\u0015\ta!\n\u0003\u0007}#3\u0007\u0003\u0005\u0004V\tUE\u0011AB<)\r!6\u0011\u0010\u0005\t\u0005\u007f\u001c)\b1\u0001\u00048\u0001")
public class AdminClient
implements Logging {
    private volatile AdminClient$ConsumerSummary$ ConsumerSummary$module;
    private final Time time;
    private final int requestTimeoutMs;
    private final ConsumerNetworkClient client;
    private final List<Node> bootstrapBrokers;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static AdminClient create(AdminConfig adminConfig) {
        return AdminClient$.MODULE$.create(adminConfig);
    }

    public static AdminClient create(scala.collection.immutable.Map<String, ?> map) {
        return AdminClient$.MODULE$.create(map);
    }

    public static AdminClient create(Properties properties) {
        return AdminClient$.MODULE$.create(properties);
    }

    public static AdminClient createSimplePlaintext(String string) {
        return AdminClient$.MODULE$.createSimplePlaintext(string);
    }

    public static ConfigDef AdminConfigDef() {
        return AdminClient$.MODULE$.AdminConfigDef();
    }

    public static AtomicInteger AdminClientIdSequence() {
        return AdminClient$.MODULE$.AdminClientIdSequence();
    }

    public static int DefaultRetryBackoffMs() {
        return AdminClient$.MODULE$.DefaultRetryBackoffMs();
    }

    public static int DefaultReceiveBufferBytes() {
        return AdminClient$.MODULE$.DefaultReceiveBufferBytes();
    }

    public static int DefaultSendBufferBytes() {
        return AdminClient$.MODULE$.DefaultSendBufferBytes();
    }

    public static int DefaultReconnectBackoffMs() {
        return AdminClient$.MODULE$.DefaultReconnectBackoffMs();
    }

    public static int DefaultMaxInFlightRequestsPerConnection() {
        return AdminClient$.MODULE$.DefaultMaxInFlightRequestsPerConnection();
    }

    public static int DefaultRequestTimeoutMs() {
        return AdminClient$.MODULE$.DefaultRequestTimeoutMs();
    }

    public static int DefaultConnectionMaxIdleMs() {
        return AdminClient$.MODULE$.DefaultConnectionMaxIdleMs();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public AdminClient$ConsumerSummary$ ConsumerSummary() {
        if (this.ConsumerSummary$module == null) {
            this.ConsumerSummary$lzycompute$1();
        }
        return this.ConsumerSummary$module;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminClient adminClient = this;
        synchronized (adminClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public Time time() {
        return this.time;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public ConsumerNetworkClient client() {
        return this.client;
    }

    public List<Node> bootstrapBrokers() {
        return this.bootstrapBrokers;
    }

    private Struct send(Node target, ApiKeys api, AbstractRequest request) {
        RequestFuture future = null;
        future = this.client().send(target, api, request);
        this.client().poll(future);
        if (!future.succeeded()) {
            throw future.exception();
        }
        return ((ClientResponse)future.value()).responseBody();
    }

    private Struct sendAnyNode(ApiKeys api, AbstractRequest request) {
        Object object = new Object();
        try {
            this.bootstrapBrokers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                AdminClient.$anonfun$sendAnyNode$1(this, api, request, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " failed on brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{api, this.bootstrapBrokers()})));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Struct)ex.value();
        }
    }

    private Node findCoordinator(String groupId) {
        GroupCoordinatorRequest request = new GroupCoordinatorRequest(groupId);
        Struct responseBody = this.sendAnyNode(ApiKeys.GROUP_COORDINATOR, (AbstractRequest)request);
        GroupCoordinatorResponse response = new GroupCoordinatorResponse(responseBody);
        Errors.forCode((short)response.errorCode()).maybeThrow();
        return response.node();
    }

    public List<GroupOverview> listGroups(Node node) {
        Struct responseBody = this.send(node, ApiKeys.LIST_GROUPS, (AbstractRequest)new ListGroupsRequest());
        ListGroupsResponse response = new ListGroupsResponse(responseBody);
        Errors.forCode((short)response.errorCode()).maybeThrow();
        return ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(response.groups()).map((Function1 & Serializable & scala.Serializable)group -> new GroupOverview(group.groupId(), group.protocolType()), Buffer$.MODULE$.canBuildFrom())).toList();
    }

    private List<Node> findAllBrokers() {
        MetadataResponse response;
        block0: {
            MetadataRequest request = new MetadataRequest(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Nil$.MODULE$));
            Struct responseBody = this.sendAnyNode(ApiKeys.METADATA, (AbstractRequest)request);
            response = new MetadataResponse(responseBody);
            Map errors = response.errors();
            if (errors.isEmpty()) break block0;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metadata request contained errors: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errors})));
        }
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(response.cluster().nodes()).asScala()).toList();
    }

    public scala.collection.immutable.Map<Node, List<GroupOverview>> listAllGroups() {
        return ((TraversableOnce)this.findAllBrokers().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Node node = x0$2;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)node), (Object)this.liftedTree1$1(node));
            return tuple2;
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<Node, List<GroupOverview>> listAllConsumerGroups() {
        return this.listAllGroups().mapValues((Function1 & Serializable & scala.Serializable)groups -> (List)groups.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminClient.$anonfun$listAllConsumerGroups$2(x$1))));
    }

    public List<GroupOverview> listAllGroupsFlattened() {
        return ((TraversableOnce)this.listAllGroups().values().flatten((Function1)Predef$.MODULE$.$conforms())).toList();
    }

    public List<GroupOverview> listAllConsumerGroupsFlattened() {
        return (List)this.listAllGroupsFlattened().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AdminClient.$anonfun$listAllConsumerGroupsFlattened$1(x$2)));
    }

    public GroupSummary describeGroup(String groupId) {
        Node coordinator = this.findCoordinator(groupId);
        Struct responseBody = this.send(coordinator, ApiKeys.DESCRIBE_GROUPS, (AbstractRequest)new DescribeGroupsRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{groupId}))).asJava()));
        DescribeGroupsResponse response = new DescribeGroupsResponse(responseBody);
        DescribeGroupsResponse.GroupMetadata metadata = (DescribeGroupsResponse.GroupMetadata)response.groups().get(groupId);
        if (metadata == null) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response from broker contained no metadata for group ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupId})));
        }
        Errors.forCode((short)metadata.errorCode()).maybeThrow();
        List members = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(metadata.members()).map((Function1 & Serializable & scala.Serializable)member -> {
            byte[] metadata = Utils.readBytes((ByteBuffer)member.memberMetadata());
            byte[] assignment = Utils.readBytes((ByteBuffer)member.memberAssignment());
            return new MemberSummary(member.memberId(), member.clientId(), member.clientHost(), metadata, assignment);
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        return new GroupSummary(metadata.state(), metadata.protocolType(), metadata.protocol(), (List<MemberSummary>)members);
    }

    public Option<List<ConsumerSummary>> describeConsumerGroup(String groupId) {
        GroupSummary group = this.describeGroup(groupId);
        String string = group.state();
        String string2 = "Dead";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return None$.MODULE$;
        }
        String string3 = group.protocolType();
        String string4 = "consumer";
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group ", " with protocol type '", "' is not a valid consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupId, group.protocolType()})));
        }
        String string5 = group.state();
        String string6 = "Stable";
        return !(string5 != null ? !string5.equals(string6) : string6 != null) ? new Some(group.members().map((Function1 & Serializable & scala.Serializable)member -> {
            PartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.assignment()));
            return new ConsumerSummary(this, member.memberId(), member.clientId(), member.clientHost(), (List<TopicPartition>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(assignment.partitions()).asScala()).toList());
        }, List$.MODULE$.canBuildFrom())) : new Some((Object)List$.MODULE$.empty());
    }

    public void close() {
        this.client().close();
    }

    private final void ConsumerSummary$lzycompute$1() {
        AdminClient adminClient = this;
        synchronized (adminClient) {
            if (this.ConsumerSummary$module == null) {
                this.ConsumerSummary$module = new AdminClient$ConsumerSummary$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$sendAnyNode$1(AdminClient $this, ApiKeys api$1, AbstractRequest request$1, Object nonLocalReturnKey1$1, Node x0$1) {
        Node node = x0$1;
        try {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)$this.send(node, api$1, request$1));
        }
        catch (Exception e) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " failed against node ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{api$1, node})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
    }

    private final List liftedTree1$1(Node x1$2) {
        Nil$ nil$;
        try {
            nil$ = this.listGroups(x1$2);
        }
        catch (Exception e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find groups from broker ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x1$2})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public static final /* synthetic */ boolean $anonfun$listAllConsumerGroups$2(GroupOverview x$1) {
        String string = x$1.protocolType();
        String string2 = "consumer";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$listAllConsumerGroupsFlattened$1(GroupOverview x$2) {
        String string = x$2.protocolType();
        String string2 = "consumer";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public AdminClient(Time time, int requestTimeoutMs, ConsumerNetworkClient client, List<Node> bootstrapBrokers) {
        this.time = time;
        this.requestTimeoutMs = requestTimeoutMs;
        this.client = client;
        this.bootstrapBrokers = bootstrapBrokers;
        Logging.$init$(this);
    }

    public static class AdminConfig
    extends AbstractConfig {
        public AdminConfig(scala.collection.immutable.Map<?, ?> originals) {
            super(AdminClient$.MODULE$.AdminConfigDef(), JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(originals), false);
        }
    }

    public class ConsumerSummary
    implements Product,
    scala.Serializable {
        private final String memberId;
        private final String clientId;
        private final String clientHost;
        private final List<TopicPartition> assignment;
        public final /* synthetic */ AdminClient $outer;

        public String memberId() {
            return this.memberId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public List<TopicPartition> assignment() {
            return this.assignment;
        }

        public ConsumerSummary copy(String memberId, String clientId, String clientHost, List<TopicPartition> assignment) {
            return new ConsumerSummary(this.kafka$admin$AdminClient$ConsumerSummary$$$outer(), memberId, clientId, clientHost, assignment);
        }

        public String copy$default$1() {
            return this.memberId();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public String copy$default$3() {
            return this.clientHost();
        }

        public List<TopicPartition> copy$default$4() {
            return this.assignment();
        }

        public String productPrefix() {
            return "ConsumerSummary";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            List<TopicPartition> list;
            int n = x$1;
            switch (n) {
                case 0: {
                    list = this.memberId();
                    break;
                }
                case 1: {
                    list = this.clientId();
                    break;
                }
                case 2: {
                    list = this.clientHost();
                    break;
                }
                case 3: {
                    list = this.assignment();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return list;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConsumerSummary;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConsumerSummary)) return false;
            if (((ConsumerSummary)object).kafka$admin$AdminClient$ConsumerSummary$$$outer() != this.kafka$admin$AdminClient$ConsumerSummary$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConsumerSummary consumerSummary = (ConsumerSummary)x$1;
            String string = this.memberId();
            String string2 = consumerSummary.memberId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = consumerSummary.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.clientHost();
            String string6 = consumerSummary.clientHost();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            List<TopicPartition> list = this.assignment();
            List<TopicPartition> list2 = consumerSummary.assignment();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!consumerSummary.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ AdminClient kafka$admin$AdminClient$ConsumerSummary$$$outer() {
            return this.$outer;
        }

        public ConsumerSummary(AdminClient $outer, String memberId, String clientId, String clientHost, List<TopicPartition> assignment) {
            this.memberId = memberId;
            this.clientId = clientId;
            this.clientHost = clientHost;
            this.assignment = assignment;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

