/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtilities;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.Topic$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicAndPartition;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class AdminUtils$
implements Logging,
AdminUtilities {
    public static AdminUtils$ MODULE$;
    private final Random rand;
    private final String AdminClientId;
    private final String EntityConfigChangeZnodePrefix;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new AdminUtils$();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminUtils$ adminUtils$ = this;
        synchronized (adminUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public Random rand() {
        return this.rand;
    }

    public String AdminClientId() {
        return this.AdminClientId;
    }

    public String EntityConfigChangeZnodePrefix() {
        return this.EntityConfigChangeZnodePrefix;
    }

    public Map<Object, Seq<Object>> assignReplicasToBrokers(Seq<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        Map<Object, Seq<Object>> map;
        if (nPartitions <= 0) {
            throw new InvalidPartitionsException("number of partitions must be larger than 0");
        }
        if (replicationFactor <= 0) {
            throw new InvalidReplicationFactorException("replication factor must be larger than 0");
        }
        if (replicationFactor > brokerMetadatas.size()) {
            throw new InvalidReplicationFactorException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replication factor: ", " larger than available brokers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicationFactor), BoxesRunTime.boxToInteger((int)brokerMetadatas.size())})));
        }
        if (brokerMetadatas.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$assignReplicasToBrokers$1(x$1)))) {
            map = this.assignReplicasToBrokersRackUnaware(nPartitions, replicationFactor, (Seq<Object>)((Seq)brokerMetadatas.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom())), fixedStartIndex, startPartitionId);
        } else {
            if (brokerMetadatas.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$assignReplicasToBrokers$3(x$3)))) {
                throw new AdminOperationException("Not all brokers have rack information for replica rack aware assignment");
            }
            map = this.assignReplicasToBrokersRackAware(nPartitions, replicationFactor, brokerMetadatas, fixedStartIndex, startPartitionId);
        }
        return map;
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackUnaware(int nPartitions, int replicationFactor, Seq<Object> brokerList, int fixedStartIndex, int startPartitionId) {
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int[] brokerArray = (int[])brokerList.toArray(ClassTag$.MODULE$.Int());
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            if (currentPartitionId$1.elem > 0 && currentPartitionId$1.elem % brokerArray.length == 0) {
                ++nextReplicaShift$1.elem;
            }
            int firstReplicaIndex = (currentPartitionId$1.elem + startIndex) % brokerArray.length;
            ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerArray[firstReplicaIndex]}));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), replicationFactor - 1).foreach((Function1 & Serializable & scala.Serializable)j -> replicaBuffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)brokerArray[this.replicaIndex(firstReplicaIndex, nextReplicaShift.elem, BoxesRunTime.unboxToInt((Object)j), brokerArray.length)])));
            ret.put((Object)BoxesRunTime.boxToInteger((int)currentPartitionId$1.elem), (Object)replicaBuffer);
            ++currentPartitionId$1.elem;
        });
        return ret;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackAware(int nPartitions, int replicationFactor, Seq<BrokerMetadata> brokerMetadatas, int fixedStartIndex, int startPartitionId) {
        scala.collection.immutable.Map brokerRackMap = ((TraversableOnce)brokerMetadatas.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends BrokerMetadata, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int id = A1.id();
                    Option<String> option = A1.rack();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String rack = (String)some.value();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)rack);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(BrokerMetadata x1) {
                Option<String> option;
                BrokerMetadata brokerMetadata = x1;
                boolean bl = brokerMetadata != null && (option = brokerMetadata.rack()) instanceof Some;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int numRacks = brokerRackMap.values().toSet().size();
        IndexedSeq<Object> arrangedBrokerList = this.getRackAlternatedBrokerList((Map<Object, String>)brokerRackMap);
        int numBrokers = arrangedBrokerList.size();
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size());
        IntRef currentPartitionId = IntRef.create((int)package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create((int)(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size())));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_2 -> {
            if (currentPartitionId$2.elem > 0 && currentPartitionId$2.elem % arrangedBrokerList.size() == 0) {
                ++nextReplicaShift$2.elem;
            }
            int firstReplicaIndex = (currentPartitionId$2.elem + startIndex) % arrangedBrokerList.size();
            int leader = BoxesRunTime.unboxToInt((Object)arrangedBrokerList.apply(firstReplicaIndex));
            ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
            scala.collection.mutable.Set racksWithReplicas = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)brokerRackMap.apply((Object)BoxesRunTime.boxToInteger((int)leader))}));
            scala.collection.mutable.Set brokersWithReplicas = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
            IntRef k = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), replicationFactor - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                boolean done = false;
                while (!done) {
                    int broker = BoxesRunTime.unboxToInt((Object)arrangedBrokerList.apply(this.replicaIndex(firstReplicaIndex, nextReplicaShift$2.elem * numRacks, k$1.elem, arrangedBrokerList.size())));
                    String rack = (String)brokerRackMap.apply((Object)BoxesRunTime.boxToInteger((int)broker));
                    if (!(racksWithReplicas.contains((Object)rack) && racksWithReplicas.size() != numRacks || brokersWithReplicas.contains((Object)BoxesRunTime.boxToInteger((int)broker)) && brokersWithReplicas.size() != numBrokers)) {
                        replicaBuffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                        racksWithReplicas.$plus$eq((Object)rack);
                        brokersWithReplicas.$plus$eq((Object)BoxesRunTime.boxToInteger((int)broker));
                        done = true;
                    }
                    ++k$1.elem;
                }
            });
            ret.put((Object)BoxesRunTime.boxToInteger((int)currentPartitionId$2.elem), (Object)replicaBuffer);
            ++currentPartitionId$2.elem;
        });
        return ret;
    }

    public IndexedSeq<Object> getRackAlternatedBrokerList(Map<Object, String> brokerRackMap) {
        Map brokersIteratorByRack = (Map)this.getInverseMap(brokerRackMap).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rack = (String)tuple2._1();
            Seq brokers = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)rack, (Object)brokers.toIterator());
            return tuple22;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        String[] racks = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokersIteratorByRack.keys().toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$);
        ArrayBuffer result = new ArrayBuffer();
        int rackIndex = 0;
        while (result.size() < brokerRackMap.size()) {
            Iterator rackIterator = (Iterator)brokersIteratorByRack.apply((Object)racks[rackIndex]);
            Object object = rackIterator.hasNext() ? result.$plus$eq(rackIterator.next()) : BoxedUnit.UNIT;
            rackIndex = (rackIndex + 1) % racks.length;
        }
        return result;
    }

    public Map<String, Seq<Object>> getInverseMap(Map<Object, String> brokerRackMap) {
        return (Map)((TraversableLike)brokerRackMap.toSeq().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            String rack = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)rack, (Object)BoxesRunTime.boxToInteger((int)id));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x0$3 -> {
            String rack;
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = rack = (String)tuple2._1();
            return string;
        }).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rack = (String)tuple2._1();
            Seq rackAndIdList = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)rack, ((SeqLike)rackAndIdList.map((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToInteger((int)AdminUtils$.$anonfun$getInverseMap$4(x0$5)), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    public void addPartitions(ZkUtils zkUtils, String topic, int numPartitions, String replicaAssignmentStr, boolean checkBrokerAvailable, RackAwareMode rackAwareMode) {
        existingPartitionsReplicaList = zkUtils.getReplicaAssignmentForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        if (existingPartitionsReplicaList.isEmpty()) {
            throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("The topic %s does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        var10_8 = existingPartitionsReplicaList.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addPartitions$1$adapted(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)());
        if (None$.MODULE$.equals(var10_8)) {
            throw new AdminOperationException("the topic does not have partition with id 0, it should never happen");
        }
        if (!(var10_8 instanceof Some)) {
            throw new MatchError((Object)var10_8);
        }
        var11_9 = (Some)var10_8;
        headPartitionReplica = (Tuple2)var11_9.value();
        var7_11 = (Seq)headPartitionReplica._2();
        existingReplicaListForPartitionZero = var7_11;
        partitionsToAdd = numPartitions - existingPartitionsReplicaList.size();
        if (partitionsToAdd <= 0) {
            throw new AdminOperationException("The number of partitions for a topic can only be increased");
        }
        brokerMetadatas = this.getBrokerMetadatas(zkUtils, rackAwareMode, this.getBrokerMetadatas$default$3());
        if (replicaAssignmentStr == null) ** GOTO lbl-1000
        v0 = replicaAssignmentStr;
        var16_15 = "";
        if (!(v0 != null ? v0.equals(var16_15) == false : var16_15 != null)) lbl-1000:
        // 2 sources

        {
            startIndex = package$.MODULE$.max(0, brokerMetadatas.indexWhere((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addPartitions$2$adapted(scala.collection.Seq kafka.admin.BrokerMetadata ), (Lkafka/admin/BrokerMetadata;)Ljava/lang/Object;)((Seq)existingReplicaListForPartitionZero)));
            v1 = this.assignReplicasToBrokers(brokerMetadatas, partitionsToAdd, existingReplicaListForPartitionZero.size(), startIndex, existingPartitionsReplicaList.size());
        } else {
            v1 = this.getManualReplicaAssignment(replicaAssignmentStr, (Set<Object>)((TraversableOnce)brokerMetadatas.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addPartitions$3$adapted(kafka.admin.BrokerMetadata ), (Lkafka/admin/BrokerMetadata;)Ljava/lang/Object;)(), Seq$.MODULE$.canBuildFrom())).toSet(), existingPartitionsReplicaList.size(), checkBrokerAvailable);
        }
        newPartitionReplicaList = v1;
        unmatchedRepFactorList = (Iterable)newPartitionReplicaList.values().filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addPartitions$4$adapted(scala.collection.Seq scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/Object;)((Seq)existingReplicaListForPartitionZero));
        if (unmatchedRepFactorList.nonEmpty()) {
            throw new AdminOperationException("The replication factor in manual replication assignment  is not equal to the existing replication factor for the topic " + existingReplicaListForPartitionZero.size());
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addPartitions$5(java.lang.String scala.collection.Map ), ()Ljava/lang/String;)((String)topic, newPartitionReplicaList));
        partitionReplicaList = (scala.collection.mutable.Map)existingPartitionsReplicaList.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addPartitions$6(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)(), Map$.MODULE$.canBuildFrom());
        partitionReplicaList.$plus$plus$eq(newPartitionReplicaList);
        x$17 = zkUtils;
        x$18 = topic;
        x$19 = partitionReplicaList;
        x$20 = true;
        x$21 = this.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        this.createOrUpdateTopicPartitionAssignmentPathInZK(x$17, x$18, (Map<Object, Seq<Object>>)x$19, x$21, x$20);
    }

    public int addPartitions$default$3() {
        return 1;
    }

    public String addPartitions$default$4() {
        return "";
    }

    public boolean addPartitions$default$5() {
        return true;
    }

    public RackAwareMode addPartitions$default$6() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Map<Object, List<Object>> getManualReplicaAssignment(String replicaAssignmentList, Set<Object> availableBrokerList, int startPartitionId, boolean checkBrokerAvailable) {
        ObjectRef partitionList = ObjectRef.create((Object)replicaAssignmentList.split(","));
        HashMap ret = new HashMap();
        IntRef partitionId = IntRef.create((int)startPartitionId);
        partitionList.elem = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem))).takeRight(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem))).size() - partitionId.elem);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem))).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int[] brokerList = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList$1.elem)[i].split(":"))).map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)AdminUtils$.$anonfun$getManualReplicaAssignment$2(s)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).isEmpty()) {
                throw new AdminOperationException("replication factor must be larger than 0");
            }
            if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).size() != new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).toSet().size()) {
                throw new AdminOperationException("duplicate brokers in replica assignment: " + brokerList);
            }
            if (checkBrokerAvailable && !new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).toSet().subsetOf((GenSet)availableBrokerList)) {
                throw new AdminOperationException("some specified brokers not available. specified brokers: " + brokerList.toString() + "available broker:" + availableBrokerList.toString());
            }
            ret.put((Object)BoxesRunTime.boxToInteger((int)partitionId$1.elem), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).toList());
            if (((SeqLike)ret.apply((Object)BoxesRunTime.boxToInteger((int)partitionId$1.elem))).size() != ((SeqLike)ret.apply((Object)BoxesRunTime.boxToInteger((int)startPartitionId))).size()) {
                throw new AdminOperationException("partition " + i + " has different replication factor: " + brokerList);
            }
            ++partitionId$1.elem;
        });
        return ret.toMap(Predef$.MODULE$.$conforms());
    }

    public boolean getManualReplicaAssignment$default$4() {
        return true;
    }

    public void deleteTopic(ZkUtils zkUtils, String topic) {
        if (this.topicExists(zkUtils, topic)) {
            try {
                zkUtils.createPersistentPath(ZkUtils$.MODULE$.getDeleteTopicPath(topic), zkUtils.createPersistentPath$default$2(), zkUtils.createPersistentPath$default$3());
            }
            catch (ZkNodeExistsException e1) {
                throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e2) {
                throw new AdminOperationException(e2);
            }
        } else {
            throw new UnknownTopicOrPartitionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic `", "` to delete does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    public boolean isConsumerGroupActive(ZkUtils zkUtils, String group) {
        return zkUtils.getConsumersInGroup(group).nonEmpty();
    }

    public boolean deleteConsumerGroupInZK(ZkUtils zkUtils, String group) {
        boolean bl;
        if (!this.isConsumerGroupActive(zkUtils, group)) {
            ZKGroupDirs dir = new ZKGroupDirs(group);
            zkUtils.deletePathRecursive(dir.consumerGroupDir());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean deleteConsumerGroupInfoForTopicInZK(ZkUtils zkUtils, String group, String topic) {
        boolean bl;
        Seq<String> topics;
        Seq<String> seq = topics = zkUtils.getTopicsByConsumerGroup(group);
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        if (!(seq != null ? !seq.equals((Object)genTraversable) : genTraversable != null)) {
            bl = this.deleteConsumerGroupInZK(zkUtils, group);
        } else if (!this.isConsumerGroupActive(zkUtils, group)) {
            ZKGroupTopicDirs dir = new ZKGroupTopicDirs(group, topic);
            zkUtils.deletePathRecursive(dir.consumerOwnerDir());
            zkUtils.deletePathRecursive(dir.consumerOffsetDir());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void deleteAllConsumerGroupInfoForTopicInZK(ZkUtils zkUtils, String topic) {
        Set<String> groups = zkUtils.getAllConsumerGroupsForTopic(topic);
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> BoxesRunTime.boxToBoolean((boolean)this.deleteConsumerGroupInfoForTopicInZK(zkUtils, group, topic)));
    }

    public boolean topicExists(ZkUtils zkUtils, String topic) {
        return zkUtils.zkClient().exists(ZkUtils$.MODULE$.getTopicPath(topic));
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(ZkUtils zkUtils, RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        RackAwareMode rackAwareMode2;
        Seq<Broker> allBrokers = zkUtils.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable & scala.Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$getBrokerMetadatas$4(x$6)));
        RackAwareMode rackAwareMode3 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode3 != null ? !rackAwareMode3.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode2 = rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode2) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack()), Seq$.MODULE$.canBuildFrom()));
        Seq brokerMetadatas = seq;
        return (Seq)brokerMetadatas.sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$2() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$3() {
        return None$.MODULE$;
    }

    public void createTopic(ZkUtils zkUtils, String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(zkUtils, rackAwareMode, this.getBrokerMetadatas$default$3());
        Map<Object, Seq<Object>> replicaAssignment = this.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, this.assignReplicasToBrokers$default$4(), this.assignReplicasToBrokers$default$5());
        this.createOrUpdateTopicPartitionAssignmentPathInZK(zkUtils, topic, replicaAssignment, topicConfig, this.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
    }

    public Properties createTopic$default$5() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$6() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public void createOrUpdateTopicPartitionAssignmentPathInZK(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update) {
        Topic$.MODULE$.validate(topic);
        String topicPath = ZkUtils$.MODULE$.getTopicPath(topic);
        if (!update) {
            Seq<String> allTopics;
            Seq collidingTopics;
            if (zkUtils.zkClient().exists(topicPath)) {
                throw new TopicExistsException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" already exists.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            if (Topic$.MODULE$.hasCollisionChars(topic) && (collidingTopics = (Seq)(allTopics = zkUtils.getAllTopics()).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)Topic$.MODULE$.hasCollision(topic, t)))).nonEmpty()) {
                throw new InvalidTopicException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" collides with existing topics: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, collidingTopics.mkString(", ")})));
            }
        }
        if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()), Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable & scala.Serializable)reps -> {
            AdminUtils$.$anonfun$createOrUpdateTopicPartitionAssignmentPathInZK$3(partitionReplicaAssignment, reps);
            return BoxedUnit.UNIT;
        });
        if (!update) {
            LogConfig$.MODULE$.validate(config);
            this.writeEntityConfig(zkUtils, ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Topic(), topic), config);
        }
        this.writeTopicPartitionAssignment(zkUtils, topic, partitionReplicaAssignment, update);
    }

    public Properties createOrUpdateTopicPartitionAssignmentPathInZK$default$4() {
        return new Properties();
    }

    public boolean createOrUpdateTopicPartitionAssignmentPathInZK$default$5() {
        return false;
    }

    private void writeTopicPartitionAssignment(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> replicaAssignment, boolean update) {
        try {
            String zkPath = ZkUtils$.MODULE$.getTopicPath(topic);
            String jsonPartitionData = zkUtils.replicaAssignmentZkData((Map<String, Seq<Object>>)((Map)replicaAssignment.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToInteger((int)e._1$mcI$sp())).toString()), e._2()), scala.collection.Map$.MODULE$.canBuildFrom())));
            if (!update) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Topic creation " + jsonPartitionData.toString());
                zkUtils.createPersistentPath(zkPath, jsonPartitionData, zkUtils.createPersistentPath$default$3());
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Topic update " + jsonPartitionData.toString());
                zkUtils.updatePersistentPath(zkPath, jsonPartitionData, zkUtils.updatePersistentPath$default$3());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zkPath, jsonPartitionData})));
        }
        catch (ZkNodeExistsException e2) {
            throw new TopicExistsException(new StringOps(Predef$.MODULE$.augmentString("topic %s already exists")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    @Override
    public void changeClientIdConfig(ZkUtils zkUtils, String clientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(zkUtils, ConfigType$.MODULE$.Client(), clientId, configs);
    }

    @Override
    public void changeUserOrUserClientIdConfig(ZkUtils zkUtils, String sanitizedEntityName, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(zkUtils, ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    @Override
    public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configs) {
        if (!this.topicExists(zkUtils, topic)) {
            throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        LogConfig$.MODULE$.validate(configs);
        this.changeEntityConfig(zkUtils, ConfigType$.MODULE$.Topic(), topic, configs);
    }

    @Override
    public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokers, Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> this.changeEntityConfig(zkUtils, ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)broker)).toString(), configs));
    }

    private void changeEntityConfig(ZkUtils zkUtils, String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = rootEntityType + '/' + fullSanitizedEntityName;
        String entityConfigPath = ZkUtils$.MODULE$.getEntityConfigPath(rootEntityType, fullSanitizedEntityName);
        this.writeEntityConfig(zkUtils, entityConfigPath, configs);
        String seqNode = ZkUtils$.MODULE$.EntityConfigChangesPath() + "/" + this.EntityConfigChangeZnodePrefix();
        String content = Json$.MODULE$.encode(this.getConfigChangeZnodeData(sanitizedEntityPath));
        zkUtils.zkClient().createPersistentSequential(seqNode, (Object)content);
    }

    public Map<String, Object> getConfigChangeZnodeData(String sanitizedEntityPath) {
        return (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_path"), (Object)sanitizedEntityPath)}));
    }

    private void writeEntityConfig(ZkUtils zkUtils, String entityPath, Properties config) {
        scala.collection.mutable.Map configMap = JavaConversions$.MODULE$.deprecated$u0020propertiesAsScalaMap(config);
        Map map = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)configMap)}));
        zkUtils.updatePersistentPath(entityPath, Json$.MODULE$.encode(map), zkUtils.updatePersistentPath$default$3());
    }

    @Override
    public Properties fetchEntityConfig(ZkUtils zkUtils, String rootEntityType, String sanitizedEntityName) {
        String entityConfigPath = ZkUtils$.MODULE$.getEntityConfigPath(rootEntityType, sanitizedEntityName);
        String str = (String)zkUtils.zkClient().readData(entityConfigPath, true);
        Properties props = new Properties();
        if (str != null) {
            Some some;
            Object mapAnon;
            Option<Object> option = Json$.MODULE$.parseFull(str);
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (option instanceof Some && (mapAnon = (some = (Some)option).value()) instanceof Map) {
                Some some2;
                Object config;
                Map map = (Map)mapAnon;
                Map map2 = (Map)map.collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 != null) {
                            Object k = A1._1();
                            Object v = A1._2();
                            if (k instanceof String) {
                                String string = (String)k;
                                if (v instanceof Object) {
                                    Object object2 = v;
                                    object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), object2);
                                    return (B1)object;
                                }
                            }
                        }
                        object = function1.apply(x2);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Tuple2<Object, Object> x2) {
                        Tuple2<Object, Object> tuple2 = x2;
                        if (tuple2 == null) return false;
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        if (!(k instanceof String)) return false;
                        if (!(v instanceof Object)) return false;
                        return true;
                    }
                }, scala.collection.Map$.MODULE$.canBuildFrom());
                Predef$.MODULE$.require(BoxesRunTime.equals((Object)map2.apply((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)));
                Option option2 = map2.get((Object)"config");
                if (!(option2 instanceof Some) || !((config = (some2 = (Some)option2).value()) instanceof Map)) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ", " config: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityConfigPath, str})));
                }
                Map map3 = (Map)config;
                map3.foreach((Function1 & Serializable & scala.Serializable)configTup -> {
                    String string;
                    Object v;
                    block3: {
                        block2: {
                            Tuple2 tuple2 = configTup;
                            if (tuple2 == null) break block2;
                            Object k = tuple2._1();
                            v = tuple2._2();
                            if (!(k instanceof String)) break block2;
                            string = (String)k;
                            if (v instanceof String) break block3;
                        }
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ", " config: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityConfigPath, str})));
                    }
                    String string2 = (String)v;
                    Object object = props.setProperty(string, string2);
                    return object;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected value in config:(", "), entity_config_path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str, entityConfigPath})));
            }
        }
        return props;
    }

    public Map<String, Properties> fetchAllTopicConfigs(ZkUtils zkUtils) {
        return ((TraversableOnce)zkUtils.getAllTopics().map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(zkUtils, ConfigType$.MODULE$.Topic(), (String)topic)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(ZkUtils zkUtils, String entityType) {
        return ((TraversableOnce)zkUtils.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable & scala.Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(zkUtils, entityType, (String)entity)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(ZkUtils zkUtils, String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)AdminUtils$.entityPaths$1(zkUtils, (Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable & scala.Serializable)entity -> AdminUtils$.entityPaths$1(zkUtils, (Option)new Some((Object)(entity + '/' + childEntityType)), rootEntityType), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(zkUtils, rootEntityType, (String)entityPath)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public MetadataResponse.TopicMetadata fetchTopicMetadataFromZk(String topic, ZkUtils zkUtils) {
        return this.fetchTopicMetadataFromZk(topic, zkUtils, (HashMap<Object, Broker>)new HashMap(), this.fetchTopicMetadataFromZk$default$4());
    }

    public Set<MetadataResponse.TopicMetadata> fetchTopicMetadataFromZk(Set<String> topics, ZkUtils zkUtils) {
        return this.fetchTopicMetadataFromZk(topics, zkUtils, SecurityProtocol.PLAINTEXT);
    }

    public Set<MetadataResponse.TopicMetadata> fetchTopicMetadataFromZk(Set<String> topics, ZkUtils zkUtils, SecurityProtocol protocol) {
        HashMap cachedBrokerInfo = new HashMap();
        return (Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> this.fetchTopicMetadataFromZk((String)topic, zkUtils, (HashMap<Object, Broker>)cachedBrokerInfo, protocol), scala.collection.Set$.MODULE$.canBuildFrom());
    }

    private MetadataResponse.TopicMetadata fetchTopicMetadataFromZk(String topic, ZkUtils zkUtils, HashMap<Object, Broker> cachedBrokerInfo, SecurityProtocol protocol) {
        MetadataResponse.TopicMetadata topicMetadata;
        if (zkUtils.pathExists(ZkUtils$.MODULE$.getTopicPath(topic))) {
            Map topicPartitionAssignment = (Map)zkUtils.getPartitionAssignmentForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)topic).get();
            List sortedPartitions = (List)topicPartitionAssignment.toList().sortWith((Function2 & Serializable & scala.Serializable)(m1, m2) -> BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$fetchTopicMetadataFromZk$2(m1, m2)));
            List partitionMetadata = (List)sortedPartitions.map((Function1 & Serializable & scala.Serializable)partitionMap -> {
                MetadataResponse.PartitionMetadata partitionMetadata;
                int partition = partitionMap._1$mcI$sp();
                Seq replicas = (Seq)partitionMap._2();
                Seq<Object> inSyncReplicas = zkUtils.getInSyncReplicasForPartition(topic, partition);
                Option<Object> leader = zkUtils.getLeaderForPartition(topic, partition);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "replicas = " + replicas + ", in sync replicas = " + inSyncReplicas + ", leader = " + leader);
                Node leaderInfo = Node.noNode();
                ObjectRef replicaInfo = ObjectRef.create((Object)Nil$.MODULE$);
                ObjectRef isrInfo = ObjectRef.create((Object)Nil$.MODULE$);
                try {
                    Option<Object> option = leader;
                    if (!(option instanceof Some)) {
                        if (None$.MODULE$.equals(option)) {
                            throw new LeaderNotAvailableException("No leader exists for partition " + partition);
                        }
                        throw new MatchError(option);
                    }
                    Some some = (Some)option;
                    int l = BoxesRunTime.unboxToInt((Object)some.value());
                    Node node = this.liftedTree1$1(topic, zkUtils, cachedBrokerInfo, protocol, partition, l);
                    leaderInfo = node;
                    try {
                        replicaInfo.elem = (Seq)this.getBrokerInfoFromCache(zkUtils, (scala.collection.mutable.Map<Object, Broker>)cachedBrokerInfo, (Seq<Object>)replicas).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getNode(protocol), Seq$.MODULE$.canBuildFrom());
                        isrInfo.elem = (Seq)this.getBrokerInfoFromCache(zkUtils, (scala.collection.mutable.Map<Object, Broker>)cachedBrokerInfo, inSyncReplicas).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getNode(protocol), Seq$.MODULE$.canBuildFrom());
                    }
                    catch (Throwable e) {
                        throw new ReplicaNotAvailableException(e);
                    }
                    if (((Seq)replicaInfo.elem).size() < replicas.size()) {
                        throw new ReplicaNotAvailableException("Replica information not available for following brokers: " + ((TraversableOnce)replicas.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$12 -> ((SeqLike)((Seq)replicaInfo$1.elem).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()), Seq$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)x$12)))).mkString(","));
                    }
                    if (((Seq)isrInfo.elem).size() < inSyncReplicas.size()) {
                        throw new ReplicaNotAvailableException("In Sync Replica information not available for following brokers: " + ((TraversableOnce)inSyncReplicas.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$14 -> ((SeqLike)((Seq)isrInfo$1.elem).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.id()), Seq$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)x$14)))).mkString(","));
                    }
                    partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, partition, leaderInfo, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaInfo.elem).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)isrInfo.elem).asJava());
                }
                catch (Throwable e) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while fetching metadata for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition)})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.forException((Throwable)e), partition, leaderInfo, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaInfo.elem).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)isrInfo.elem).asJava());
                }
                return partitionMetadata;
            }, List$.MODULE$.canBuildFrom());
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic$.MODULE$.isInternal(topic), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionMetadata).asJava());
        } else {
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.UNKNOWN_TOPIC_OR_PARTITION, topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
        }
        return topicMetadata;
    }

    private SecurityProtocol fetchTopicMetadataFromZk$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    private Seq<Broker> getBrokerInfoFromCache(ZkUtils zkUtils, scala.collection.mutable.Map<Object, Broker> cachedBrokerInfo, Seq<Object> brokerIds) {
        ObjectRef failedBrokerIds = ObjectRef.create((Object)new ListBuffer());
        Seq brokerMetadata = (Seq)brokerIds.map((Function1 & Serializable & scala.Serializable)id -> AdminUtils$.$anonfun$getBrokerInfoFromCache$1(zkUtils, cachedBrokerInfo, failedBrokerIds, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)brokerMetadata.filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.isDefined()))).map((Function1 & Serializable & scala.Serializable)x$16 -> (Broker)x$16.get(), Seq$.MODULE$.canBuildFrom());
    }

    private int replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$1(BrokerMetadata x$1) {
        return x$1.rack().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$3(BrokerMetadata x$3) {
        return x$3.rack().isEmpty();
    }

    public static final /* synthetic */ int $anonfun$getInverseMap$4(Tuple2 x0$5) {
        int id;
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = id = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(Tuple2 p) {
        return ((TopicAndPartition)p._1()).partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$2(Seq existingReplicaListForPartitionZero$1, BrokerMetadata x$4) {
        return x$4.id() >= BoxesRunTime.unboxToInt((Object)existingReplicaListForPartitionZero$1.head());
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$4(Seq existingReplicaListForPartitionZero$1, Seq p) {
        return p.size() != existingReplicaListForPartitionZero$1.size();
    }

    public static final /* synthetic */ String $anonfun$addPartitions$5(String topic$1, Map newPartitionReplicaList$1) {
        return new StringOps(Predef$.MODULE$.augmentString("Add partition list for %s is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$1, newPartitionReplicaList$1}));
    }

    public static final /* synthetic */ Tuple2 $anonfun$addPartitions$6(Tuple2 p) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((TopicAndPartition)p._1()).partition())), p._2());
    }

    public static final /* synthetic */ int $anonfun$getManualReplicaAssignment$2(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s.trim())).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$6) {
        return x$6.rack().nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$createOrUpdateTopicPartitionAssignmentPathInZK$3(Map partitionReplicaAssignment$1, Seq reps) {
        if (reps.size() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException("Duplicate replica assignment found: " + partitionReplicaAssignment$1);
        }
    }

    private static final Seq entityPaths$1(ZkUtils zkUtils, Option rootPath, String rootEntityType$1) {
        Seq seq;
        String string;
        Option option = rootPath;
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            string = rootEntityType$1 + '/' + path;
        } else if (None$.MODULE$.equals(option)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)option);
        }
        String root = string;
        Seq entityNames = zkUtils.getAllEntitiesWithConfig(root);
        Option option2 = rootPath;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String path = (String)some.value();
            seq = (Seq)entityNames.map((Function1 & Serializable & scala.Serializable)entityName -> path + '/' + entityName, Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option2)) {
            seq = entityNames;
        } else {
            throw new MatchError((Object)option2);
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$fetchTopicMetadataFromZk$2(Tuple2 m1, Tuple2 m2) {
        return m1._1$mcI$sp() < m2._1$mcI$sp();
    }

    private final Node liftedTree1$1(String topic$4, ZkUtils zkUtils$6, HashMap cachedBrokerInfo$1, SecurityProtocol protocol$1, int partition$1, int l$1) {
        Node node;
        try {
            node = ((Broker)this.getBrokerInfoFromCache(zkUtils$6, (scala.collection.mutable.Map<Object, Broker>)cachedBrokerInfo$1, (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{l$1}))).head()).getNode(protocol$1);
        }
        catch (Throwable e) {
            throw new LeaderNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Leader not available for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$4, BoxesRunTime.boxToInteger((int)partition$1)})), e);
        }
        return node;
    }

    public static final /* synthetic */ Option $anonfun$getBrokerInfoFromCache$1(ZkUtils zkUtils$8, scala.collection.mutable.Map cachedBrokerInfo$3, ObjectRef failedBrokerIds$1, int id) {
        Some some;
        Option optionalBrokerInfo = cachedBrokerInfo$3.get((Object)BoxesRunTime.boxToInteger((int)id));
        Option option = optionalBrokerInfo;
        if (option instanceof Some) {
            Some some2 = (Some)option;
            Broker brokerInfo = (Broker)some2.value();
            some = new Some((Object)brokerInfo);
        } else if (None$.MODULE$.equals(option)) {
            None$ none$;
            Option<Broker> option2 = zkUtils$8.getBrokerInfo(id);
            if (option2 instanceof Some) {
                Some some3 = (Some)option2;
                Broker brokerInfo = (Broker)some3.value();
                cachedBrokerInfo$3.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), (Object)brokerInfo));
                none$ = new Some((Object)brokerInfo);
            } else if (None$.MODULE$.equals(option2)) {
                ((ListBuffer)failedBrokerIds$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)id));
                none$ = None$.MODULE$;
            } else {
                throw new MatchError(option2);
            }
            some = none$;
        } else {
            throw new MatchError((Object)option);
        }
        return some;
    }

    private AdminUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.rand = new Random();
        this.AdminClientId = "__admin_client";
        this.EntityConfigChangeZnodePrefix = "config_change_";
    }

    public static final /* synthetic */ Object $anonfun$addPartitions$1$adapted(Tuple2 p) {
        return BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$addPartitions$1(p));
    }

    public static final /* synthetic */ Object $anonfun$addPartitions$2$adapted(Seq existingReplicaListForPartitionZero$1, BrokerMetadata x$4) {
        return BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$addPartitions$2(existingReplicaListForPartitionZero$1, x$4));
    }

    public static final /* synthetic */ Object $anonfun$addPartitions$3$adapted(BrokerMetadata x$5) {
        return BoxesRunTime.boxToInteger((int)x$5.id());
    }

    public static final /* synthetic */ Object $anonfun$addPartitions$4$adapted(Seq existingReplicaListForPartitionZero$1, Seq p) {
        return BoxesRunTime.boxToBoolean((boolean)AdminUtils$.$anonfun$addPartitions$4(existingReplicaListForPartitionZero$1, p));
    }
}

