/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.AdminUtilities;
import kafka.admin.AdminUtils$;
import kafka.admin.ConfigCommand;
import kafka.common.Config;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.QuotaId$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConfigCommand$
implements Config {
    public static ConfigCommand$ MODULE$;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ConfigCommand$();
    }

    @Override
    public void validateChars(String prop, String value) {
        Config.validateChars$(this, prop, value);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConfigCommand$ configCommand$ = this;
        synchronized (configCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void main(String[] args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Add/Remove entity config for a topic, client, user or broker");
        }
        opts.checkArgs();
        try (ZkUtils zkUtils = ZkUtils$.MODULE$.apply((String)opts.options().valueOf(opts.zkConnectOpt()), 30000, 30000, JaasUtils.isZkSecurityEnabled());){
            try {
                if (opts.options().has((OptionSpec)opts.alterOpt())) {
                    this.alterConfig(zkUtils, opts, this.alterConfig$default$3());
                } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeConfig(zkUtils, opts);
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)("Error while executing config command " + e.getMessage()));
                Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            }
        }
    }

    public void alterConfig(ZkUtils zkUtils, ConfigCommand.ConfigCommandOptions opts, AdminUtilities utils) {
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        Properties configs = utils.fetchEntityConfig(zkUtils, entityType, entityName);
        configs.putAll((Map<?, ?>)configsToBeAdded);
        configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)config -> configs.remove(config));
        String string = entityType;
        String string2 = ConfigType$.MODULE$.Topic();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            utils.changeTopicConfig(zkUtils, entityName, configs);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = ConfigType$.MODULE$.Client();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                utils.changeClientIdConfig(zkUtils, entityName, configs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = ConfigType$.MODULE$.User();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    utils.changeUserOrUserClientIdConfig(zkUtils, entityName, configs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string8 = ConfigType$.MODULE$.Broker();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        utils.changeBrokerConfig(zkUtils, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.parseBroker(entityName)}))), configs);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a known entityType. Should be one of ", ", ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityType, ConfigType$.MODULE$.Topic(), ConfigType$.MODULE$.Client(), ConfigType$.MODULE$.Broker()})));
                    }
                }
            }
        }
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated config for entity: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity})));
    }

    public AdminUtilities alterConfig$default$3() {
        return AdminUtils$.MODULE$;
    }

    private int parseBroker(String broker) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(broker)).toInt();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error parsing broker ", ". The broker's Entity Name must be a single integer value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{broker})));
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private void describeConfig(ZkUtils zkUtils, ConfigCommand.ConfigCommandOptions opts) {
        configEntity = this.parseEntity(opts);
        v0 = configEntity.root().entityType();
        var5_4 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var5_4) == false : var5_4 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        entities = configEntity.getAllEntities(zkUtils);
        entities.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$describeConfig$1$adapted(kafka.utils.ZkUtils boolean kafka.admin.ConfigCommand$ConfigEntity ), (Lkafka/admin/ConfigCommand$ConfigEntity;)Ljava/lang/Object;)((ZkUtils)zkUtils, (boolean)describeAllUsers));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        void var2_2;
        block1: {
            Properties props = new Properties();
            if (!opts.options().has(opts.addConfig())) break block1;
            String[][] configsToBeAdded = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)opts.options().valueOf(opts.addConfig())).split(",(?=[^\\]]*(?:\\[|$))"))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.split("\\s*=\\s*"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded)).forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$parseConfigsToBeAdded$3(config))), (Function0 & Serializable & scala.Serializable)() -> "Invalid entity config: all configs to be added must be in the format \"key=val\".");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded)).foreach((Function1 & Serializable & scala.Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim()));
            if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
                Predef$.MODULE$.println((Object)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: The configuration ", "=", " is specified. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker."})).s((Seq)Nil$.MODULE$)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(opts.options().valuesOf(opts.deleteConfig())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$3 -> propsToBeDeleted.setProperty((String)x$3, ""));
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        ConfigCommand.ConfigEntity configEntity;
        List entityTypes;
        block3: {
            block2: {
                entityTypes = opts.options().valuesOf(opts.entityType());
                Object object = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(entityTypes).head();
                String string = ConfigType$.MODULE$.User();
                if (!(object == null ? string != null : !object.equals(string))) break block2;
                Object object2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(entityTypes).head();
                String string2 = ConfigType$.MODULE$.Client();
                if (object2 != null ? !object2.equals(string2) : string2 != null) break block3;
            }
            configEntity = this.parseQuotaEntity(opts);
            return configEntity;
        }
        None$ name = opts.options().has(opts.entityName()) ? new Some(opts.options().valueOf(opts.entityName())) : None$.MODULE$;
        configEntity = new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(entityTypes).head(), (Option<String>)name), (Option<ConfigCommand.Entity>)None$.MODULE$);
        return configEntity;
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseQuotaEntity(ConfigCommand.ConfigCommandOptions opts) {
        types = opts.options().valuesOf(opts.entityType());
        namesIterator = opts.options().valuesOf(opts.entityName()).iterator();
        names = (Buffer)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(opts.options().specs()).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseQuotaEntity$1$adapted(joptsimple.OptionSpec ), (Ljoptsimple/OptionSpec;)Ljava/lang/Object;)())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseQuotaEntity$2(java.util.Iterator joptsimple.OptionSpec ), (Ljoptsimple/OptionSpec;)Ljava/lang/String;)(namesIterator), Buffer$.MODULE$.canBuildFrom());
        if (opts.options().has((OptionSpec)opts.alterOpt()) && names.size() != types.size()) {
            throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
        }
        if (types.size() != 2) ** GOTO lbl-1000
        v0 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(types).apply(0);
        var6_5 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(types).reverse() : JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(types).toBuffer();
        sortedNames = ((IterableLike)(reverse != false && names.length() == 2 ? names.reverse() : names)).iterator();
        entities = (Buffer)entityTypes.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseQuotaEntity$3(kafka.admin.ConfigCommand$ scala.collection.Iterator java.lang.String ), (Ljava/lang/String;)Lkafka/admin/ConfigCommand$Entity;)((ConfigCommand$)this, (Iterator)sortedNames), Buffer$.MODULE$.canBuildFrom());
        return new ConfigCommand.ConfigEntity((ConfigCommand.Entity)entities.head(), (Option<ConfigCommand.Entity>)(entities.size() > 1 ? new Some(entities.apply(1)) : None$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$describeConfig$1(ZkUtils zkUtils$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        block0: {
            Properties configs = AdminUtils$.MODULE$.fetchEntityConfig(zkUtils$1, entity.root().entityType(), entity.fullSanitizedName());
            if (configs.isEmpty() && describeAllUsers$1) break block0;
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Configs for %s are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020propertiesAsScalaMap(configs).map((Function1 & Serializable & scala.Serializable)kv -> (String)kv._1() + "=" + kv._2(), Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigsToBeAdded$3(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ boolean $anonfun$parseQuotaEntity$1(OptionSpec spec) {
        return spec.options().contains("entity-name") || spec.options().contains("entity-default");
    }

    public static final /* synthetic */ String $anonfun$parseQuotaEntity$2(java.util.Iterator namesIterator$1, OptionSpec spec) {
        return spec.options().contains("entity-name") ? (String)namesIterator$1.next() : "";
    }

    private final String sanitizeName$1(String entityType, String name) {
        String string;
        if (name.isEmpty()) {
            string = ConfigEntityName$.MODULE$.Default();
        } else {
            String string2;
            String string3 = entityType;
            String string4 = ConfigType$.MODULE$.User();
            String string5 = string3;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                string2 = QuotaId$.MODULE$.sanitize(name);
            } else {
                String string6 = ConfigType$.MODULE$.Client();
                String string7 = string3;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    this.validateChars("Client-id", name);
                    string2 = name;
                } else {
                    throw new IllegalArgumentException("Invalid entity type " + entityType);
                }
            }
            string = string2;
        }
        return string;
    }

    public static final /* synthetic */ ConfigCommand.Entity $anonfun$parseQuotaEntity$3(ConfigCommand$ $this, Iterator sortedNames$1, String t) {
        return new ConfigCommand.Entity(t, (Option<String>)(sortedNames$1.hasNext() ? new Some((Object)$this.sanitizeName$1(t, (String)sortedNames$1.next())) : None$.MODULE$));
    }

    private ConfigCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        Config.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$describeConfig$1$adapted(ZkUtils zkUtils$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        ConfigCommand$.$anonfun$describeConfig$1(zkUtils$1, describeAllUsers$1, entity);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$parseQuotaEntity$1$adapted(OptionSpec spec) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$parseQuotaEntity$1(spec));
    }
}

