/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminUtilities;
import kafka.admin.AdminUtils$;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tut!B\u0001\u0003\u0011\u00039\u0011!\u0007*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]N\u001cu.\\7b]\u0012T!a\u0001\u0003\u0002\u000b\u0005$W.\u001b8\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051BA\rSK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:\u001c8i\\7nC:$7cA\u0005\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"a\u0002'pO\u001eLgn\u001a\u0005\u00063%!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAQ\u0001H\u0005\u0005\u0002u\tA!\\1j]R\u0011a$\t\t\u0003\u001b}I!\u0001\t\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Em\u0001\raI\u0001\u0005CJ<7\u000fE\u0002\u000eI\u0019J!!\n\b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u001drcB\u0001\u0015-!\tIc\"D\u0001+\u0015\tYc!\u0001\u0004=e>|GOP\u0005\u0003[9\ta\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011QF\u0004\u0005\u0006e%!\taM\u0001\u0011m\u0016\u0014\u0018NZ=BgNLwM\\7f]R$2A\b\u001b:\u0011\u0015)\u0014\u00071\u00017\u0003\u001dQ8.\u0016;jYN\u0004\"aE\u001c\n\u0005a\"\"a\u0002.l+RLGn\u001d\u0005\u0006uE\u0002\raO\u0001\u0005_B$8\u000f\u0005\u0002={5\t\u0011B\u0002\u0003?\u0013\u0001y$\u0001\t*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]N\u001cu.\\7b]\u0012|\u0005\u000f^5p]N\u001c\"!\u0010\u0007\t\u0011\tj$\u0011!Q\u0001\n\rBQ!G\u001f\u0005\u0002\t#\"aO\"\t\u000b\t\n\u0005\u0019A\u0012\t\u000f\u0015k$\u0019!C\u0001\r\u00061\u0001/\u0019:tKJ,\u0012a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006Q!n\u001c9ug&l\u0007\u000f\\3\n\u00051K%\u0001D(qi&|g\u000eU1sg\u0016\u0014\bB\u0002(>A\u0003%q)A\u0004qCJ\u001cXM\u001d\u0011\t\u000fAk$\u0019!C\u0001#\u0006a!p[\"p]:,7\r^(qiV\t!\u000bE\u0002I'\u001aJ!\u0001V%\u00037\u0005\u0013x-^7f]R\f5mY3qi&twm\u00149uS>t7\u000b]3d\u0011\u00191V\b)A\u0005%\u0006i!p[\"p]:,7\r^(qi\u0002Bq\u0001W\u001fC\u0002\u0013\u0005\u0011,A\u0006hK:,'/\u0019;f\u001fB$X#\u0001.\u0011\u0005![\u0016B\u0001/J\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM\u001d\u0005\u0007=v\u0002\u000b\u0011\u0002.\u0002\u0019\u001d,g.\u001a:bi\u0016|\u0005\u000f\u001e\u0011\t\u000f\u0001l$\u0019!C\u00013\u0006QQ\r_3dkR,w\n\u001d;\t\r\tl\u0004\u0015!\u0003[\u0003-)\u00070Z2vi\u0016|\u0005\u000f\u001e\u0011\t\u000f\u0011l$\u0019!C\u00013\u0006Ia/\u001a:jMf|\u0005\u000f\u001e\u0005\u0007Mv\u0002\u000b\u0011\u0002.\u0002\u0015Y,'/\u001b4z\u001fB$\b\u0005C\u0004i{\t\u0007I\u0011A)\u0002/I,\u0017m]:jO:lWM\u001c;Kg>tg)\u001b7f\u001fB$\bB\u00026>A\u0003%!+\u0001\rsK\u0006\u001c8/[4o[\u0016tGOS:p]\u001aKG.Z(qi\u0002Bq\u0001\\\u001fC\u0002\u0013\u0005\u0011+A\fu_BL7m\u001d+p\u001b>4XMS:p]\u001aKG.Z(qi\"1a.\u0010Q\u0001\nI\u000b\u0001\u0004^8qS\u000e\u001cHk\\'pm\u0016T5o\u001c8GS2,w\n\u001d;!\u0011\u001d\u0001XH1A\u0005\u0002E\u000bQB\u0019:pW\u0016\u0014H*[:u\u001fB$\bB\u0002:>A\u0003%!+\u0001\bce>\\WM\u001d'jgR|\u0005\u000f\u001e\u0011\t\u000fQl$\u0019!C\u00013\u0006\u0001B-[:bE2,'+Y2l\u0003^\f'/\u001a\u0005\u0007mv\u0002\u000b\u0011\u0002.\u0002#\u0011L7/\u00192mKJ\u000b7m[!xCJ,\u0007\u0005C\u0004y{\t\u0007I\u0011A=\u0002\u0017QD'o\u001c;uY\u0016|\u0005\u000f^\u000b\u0002uB\u0019\u0001jU>\u0011\u00055a\u0018BA?\u000f\u0005\u0011auN\\4\t\r}l\u0004\u0015!\u0003{\u00031!\bN]8ui2,w\n\u001d;!\u0011%\t\u0019!\u0010b\u0001\n\u0003\t)!A\u0004paRLwN\\:\u0016\u0005\u0005\u001d\u0001c\u0001%\u0002\n%\u0019\u00111B%\u0003\u0013=\u0003H/[8o'\u0016$\b\u0002CA\b{\u0001\u0006I!a\u0002\u0002\u0011=\u0004H/[8og\u0002BaAM\u0005\u0005\u0002\u0005MA#\u0002\u0010\u0002\u0016\u0005]\u0001BB\u001b\u0002\u0012\u0001\u0007a\u0007C\u0004\u0002\u001a\u0005E\u0001\u0019\u0001\u0014\u0002\u0015)\u001cxN\\*ue&tw\rC\u0004\u0002\u001e%!I!a\b\u0002\u001dI,Wn\u001c<f)\"\u0014x\u000e\u001e;mKR9a$!\t\u0002$\u0005-\u0003BB\u001b\u0002\u001c\u0001\u0007a\u0007\u0003\u0005\u0002&\u0005m\u0001\u0019AA\u0014\u0003a\u0001\u0018M\u001d;ji&|gn\u001d+p\u0005\u0016\u0014V-Y:tS\u001etW\r\u001a\t\t\u0003S\ty#a\r\u0002@5\u0011\u00111\u0006\u0006\u0004\u0003[q\u0011AC2pY2,7\r^5p]&!\u0011\u0011GA\u0016\u0005\ri\u0015\r\u001d\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u0003\u0002\r\r|W.\\8o\u0013\u0011\ti$a\u000e\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0004\u0002*\u0005\u0005\u0013QI\u0005\u0005\u0003\u0007\nYCA\u0002TKF\u00042!DA$\u0013\r\tIE\u0004\u0002\u0004\u0013:$\b\u0002CA'\u00037\u0001\r!a\u0014\u00025I,\u0017m]:jO:,G\rU1si&$\u0018n\u001c8t'R\fG/^:\u0011\u0011\u0005%\u0012qFA\u001a\u0003#\u00022\u0001CA*\u0013\r\t)F\u0001\u0002\u0013%\u0016\f7o]5h]6,g\u000e^*uCR,8\u000fC\u0004\u0002Z%!\t!a\u0017\u0002%\u001d,g.\u001a:bi\u0016\f5o]5h]6,g\u000e\u001e\u000b\u0006=\u0005u\u0013q\f\u0005\u0007k\u0005]\u0003\u0019\u0001\u001c\t\ri\n9\u00061\u0001<\u0011\u001d\tI&\u0003C\u0001\u0003G\"\"\"!\u001a\u0002l\u00055\u0014\u0011OA;!\u001di\u0011qMA\u0014\u0003OI1!!\u001b\u000f\u0005\u0019!V\u000f\u001d7fe!1Q'!\u0019A\u0002YB\u0001\"a\u001c\u0002b\u0001\u0007\u0011qH\u0001\u0015EJ|7.\u001a:MSN$Hk\u001c*fCN\u001c\u0018n\u001a8\t\u000f\u0005M\u0014\u0011\ra\u0001M\u00051Bo\u001c9jGN$v.T8wK*\u001bxN\\*ue&tw\rC\u0004u\u0003C\u0002\r!a\u001e\u0011\u00075\tI(C\u0002\u0002|9\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0000%!\t!!!\u0002#\u0015DXmY;uK\u0006\u001b8/[4o[\u0016tG\u000fF\u0003\u001f\u0003\u0007\u000b)\t\u0003\u00046\u0003{\u0002\rA\u000e\u0005\u0007u\u0005u\u0004\u0019A\u001e\t\u000f\u0005}\u0014\u0002\"\u0001\u0002\nR9a$a#\u0002\u000e\u0006E\u0005BB\u001b\u0002\b\u0002\u0007a\u0007C\u0004\u0002\u0010\u0006\u001d\u0005\u0019\u0001\u0014\u0002-I,\u0017m]:jO:lWM\u001c;Kg>t7\u000b\u001e:j]\u001eD\u0011\"a%\u0002\bB\u0005\t\u0019A>\u0002\u0011QD'o\u001c;uY\u0016Dq!a&\n\t\u0003\tI*\u0001\fqe&tGoQ;se\u0016tG/Q:tS\u001etW.\u001a8u)\u0015q\u00121TAO\u0011\u0019)\u0014Q\u0013a\u0001m!A\u0011QEAK\u0001\u0004\ty\n\u0005\u0004\u0002*\u0005\u0005\u0013\u0011\u0015\t\b\u001b\u0005\u001d\u00141GA \u0011\u001d\t)+\u0003C\u0001\u0003O\u000b\u0001\u0003]1sg\u0016\fe\u000e\u001a,bY&$\u0017\r^3\u0015\r\u0005}\u0015\u0011VAV\u0011\u0019)\u00141\u0015a\u0001m!9\u0011qRAR\u0001\u00041\u0003bBAX\u0013\u0011%\u0011\u0011W\u0001\u001dG\",7m[%g%\u0016\f7o]5h]6,g\u000e^*vG\u000e,W\rZ3e)\u0019\ty%a-\u00026\"1Q'!,A\u0002YB\u0001\"!\n\u0002.\u0002\u0007\u0011q\u0005\u0005\b\u0003sKA\u0011AA^\u0003\u0015\u001a\u0007.Z2l\u0013\u001a\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R\u001cVoY2fK\u0012,G\r\u0006\u0006\u0002R\u0005u\u0016qXAb\u0003\u000bDa!NA\\\u0001\u00041\u0004\u0002CAa\u0003o\u0003\r!a\r\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002&\u0005]\u0006\u0019AA\u0014\u0011!\t9-a.A\u0002\u0005\u001d\u0012!\u00079beRLG/[8og\n+\u0017N\\4SK\u0006\u001c8/[4oK\u0012Dq!a3\n\t\u0003\ti-\u0001\u000bwC2LG-\u0019;f\u0003:$\u0007+\u0019:tK\u0006\u0013xm\u001d\u000b\u0004w\u0005=\u0007B\u0002\u0012\u0002J\u0002\u00071\u0005C\u0005\u0002T&\t\n\u0011\"\u0001\u0002V\u0006YR\r_3dkR,\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIM*\"!a6+\u0007m\fIn\u000b\u0002\u0002\\B!\u0011Q\\At\u001b\t\tyN\u0003\u0003\u0002b\u0006\r\u0018!C;oG\",7m[3e\u0015\r\t)OD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAu\u0003?\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\r\u0015Q!\u0001AAw'\u0011\tY\u000f\u0004\n\t\u0013U\nYO!A!\u0002\u00131\u0004bCAz\u0003W\u0014\t\u0011)A\u0005\u0003O\t!\u0003\u001d:pa>\u001cX\rZ!tg&<g.\\3oi\"9\u0011$a;\u0005\u0002\u0005]HCBA}\u0003w\fi\u0010E\u0002\t\u0003WDa!NA{\u0001\u00041\u0004\u0002CAz\u0003k\u0004\r!a\n\t\u0011\t\u0005\u00111\u001eC\u0001\u0005\u0007\t!#\u001a=jgRLgnZ!tg&<g.\\3oiR\u0011\u0011q\u0005\u0005\t\u0005\u000f\tY\u000f\"\u0003\u0003\n\u0005iQ.Y=cKRC'o\u001c;uY\u0016$2A\bB\u0006\u0011\u001d\t\u0019J!\u0002A\u0002mD\u0001Ba\u0004\u0002l\u0012\u0005!\u0011C\u0001\u000b[\u0006L(-\u001a'j[&$Hc\u0001\u0010\u0003\u0014!9\u00111\u0013B\u0007\u0001\u0004Y\b\"\u0003B\f\u0003W$\tA\u0001B\r\u0003]\t7o]5h]RC'o\u001c;uY\u0016$'+\u001a9mS\u000e\f7\u000fF\u0004\u001f\u00057\u0011yBa\t\t\u0011\tu!Q\u0003a\u0001\u0003O\t1\"\u00197m\u000bbL7\u000f^5oO\"A!\u0011\u0005B\u000b\u0001\u0004\t9#A\u0006bY2\u0004&o\u001c9pg\u0016$\u0007\"C\u0002\u0003\u0016A\u0005\t\u0019\u0001B\u0013!\rA!qE\u0005\u0004\u0005S\u0011!AD!e[&tW\u000b^5mSRLWm\u001d\u0005\t\u0005[\tY\u000f\"\u0003\u00030\u0005q\u0002o\\:u%\u0016\u0014\u0017\r\\1oG\u0016\u0014V\r\u001d7jG\u0006\u001cH\u000b[1u\u001b>4X\r\u001a\u000b\u0007\u0003O\u0011\tD!\u000e\t\u0011\tM\"1\u0006a\u0001\u0003O\t\u0001\"\u001a=jgRLgn\u001a\u0005\t\u0005o\u0011Y\u00031\u0001\u0002(\u0005A\u0001O]8q_N,G\r\u0003\u0005\u0003<\u0005-H\u0011\u0002B\u001f\u0003\u0019\u0002(/\u001a*fE\u0006d\u0017M\\2f%\u0016\u0004H.[2b\r>\u0014Xj\u001c<j]\u001e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003O\u0011yD!\u0011\t\u0011\tM\"\u0011\ba\u0001\u0003OA\u0001Ba\u000e\u0003:\u0001\u0007\u0011q\u0005\u0005\t\u0005\u000b\nY\u000f\"\u0001\u0003H\u00051am\u001c:nCR$2A\nB%\u0011!\u0011YEa\u0011A\u0002\u0005\u001d\u0012!B7pm\u0016\u001c\b\u0002\u0003B(\u0003W$\tA!\u0015\u0002\u0011\u0019LG\u000e^3s\u0005f$\u0002\"!\u001a\u0003T\t]#\u0011\f\u0005\b\u0005+\u0012i\u00051\u0001'\u0003\u0015!x\u000e]5d\u0011!\u0011iB!\u0014A\u0002\u0005\u001d\u0002\u0002\u0003B\u0011\u0005\u001b\u0002\r!a\n\t\u0011\tu\u00131\u001eC\u0001\u0005?\n!C]3bgNLwM\u001c)beRLG/[8ogR!\u0011q\u000fB1\u0011%\t\u0019Ja\u0017\u0011\u0002\u0003\u00071\u0010\u0003\u0005\u0003f\u0005-H\u0011\u0001B4\u0003E1\u0018\r\\5eCR,\u0007+\u0019:uSRLwN\u001c\u000b\t\u0003o\u0012IGa\u001b\u0003n!1QGa\u0019A\u0002YBqA!\u0016\u0003d\u0001\u0007a\u0005\u0003\u0005\u0003p\t\r\u0004\u0019AA#\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0003\u0006\u0003t\u0005-\u0018\u0013!C\u0001\u0003+\fAD]3bgNLwM\u001c)beRLG/[8og\u0012\"WMZ1vYR$\u0013\u0007C\u0006\u0003x\u0005-\u0018\u0013!C\u0001\u0005\te\u0014!I1tg&<g\u000e\u00165s_R$H.\u001a3SKBd\u0017nY1tI\u0011,g-Y;mi\u0012\u001aTC\u0001B>U\u0011\u0011)#!7")
public class ReassignPartitionsCommand
implements Logging {
    private final ZkUtils zkUtils;
    private final Map<TopicAndPartition, Seq<Object>> proposedAssignment;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static long executeAssignment$default$3() {
        return ReassignPartitionsCommand$.MODULE$.executeAssignment$default$3();
    }

    public static ReassignPartitionsCommandOptions validateAndParseArgs(String[] stringArray) {
        return ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(stringArray);
    }

    public static ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkUtils zkUtils, TopicAndPartition topicAndPartition, Map<TopicAndPartition, Seq<Object>> map, Map<TopicAndPartition, Seq<Object>> map2) {
        return ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(zkUtils, topicAndPartition, map, map2);
    }

    public static Seq<Tuple2<TopicAndPartition, Seq<Object>>> parseAndValidate(ZkUtils zkUtils, String string) {
        return ReassignPartitionsCommand$.MODULE$.parseAndValidate(zkUtils, string);
    }

    public static void printCurrentAssignment(ZkUtils zkUtils, Seq<Tuple2<TopicAndPartition, Seq<Object>>> seq) {
        ReassignPartitionsCommand$.MODULE$.printCurrentAssignment(zkUtils, seq);
    }

    public static void executeAssignment(ZkUtils zkUtils, String string, long l) {
        ReassignPartitionsCommand$.MODULE$.executeAssignment(zkUtils, string, l);
    }

    public static void executeAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.executeAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> generateAssignment(ZkUtils zkUtils, Seq<Object> seq, String string, boolean bl) {
        return ReassignPartitionsCommand$.MODULE$.generateAssignment(zkUtils, seq, string, bl);
    }

    public static void generateAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.generateAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static void verifyAssignment(ZkUtils zkUtils, String string) {
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(zkUtils, string);
    }

    public static void verifyAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static void main(String[] stringArray) {
        ReassignPartitionsCommand$.MODULE$.main(stringArray);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand reassignPartitionsCommand = this;
        synchronized (reassignPartitionsCommand) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public Map<TopicAndPartition, Seq<Object>> existingAssignment() {
        Seq proposedTopics = ((SetLike)this.proposedAssignment.keySet().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.topic(), Set$.MODULE$.canBuildFrom())).toSeq();
        return this.zkUtils.getReplicaAssignmentForTopics((Seq<String>)proposedTopics);
    }

    private void maybeThrottle(long throttle) {
        block0: {
            if (throttle < 0L) break block0;
            this.maybeLimit(throttle);
            this.assignThrottledReplicas(this.existingAssignment(), this.proposedAssignment, this.assignThrottledReplicas$default$3());
        }
    }

    public void maybeLimit(long throttle) {
        block0: {
            if (throttle < 0L) break block0;
            Seq existingBrokers = ((TraversableOnce)this.existingAssignment().values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq();
            Seq proposedBrokers = ((TraversableOnce)this.proposedAssignment.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq();
            Seq brokers = (Seq)((SeqLike)existingBrokers.$plus$plus((GenTraversableOnce)proposedBrokers, Seq$.MODULE$.canBuildFrom())).distinct();
            brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> {
                Properties configs = AdminUtils$.MODULE$.fetchEntityConfig($this.zkUtils, ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)id)).toString());
                configs.put(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToLong((long)throttle)).toString());
                configs.put(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToLong((long)throttle)).toString());
                AdminUtils$.MODULE$.changeBrokerConfig($this.zkUtils, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{id}))), configs);
            });
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The throttle limit was set to ", " B/s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)throttle)})));
        }
    }

    public void assignThrottledReplicas(Map<TopicAndPartition, Seq<Object>> allExisting, Map<TopicAndPartition, Seq<Object>> allProposed, AdminUtilities admin) {
        ((SetLike)allProposed.keySet().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.topic(), Set$.MODULE$.canBuildFrom())).toSeq().foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ReassignPartitionsCommand.$anonfun$assignThrottledReplicas$2(this, allExisting, allProposed, admin, topic);
            return BoxedUnit.UNIT;
        });
    }

    public AdminUtilities assignThrottledReplicas$default$3() {
        return AdminUtils$.MODULE$;
    }

    private Map<TopicAndPartition, Seq<Object>> postRebalanceReplicasThatMoved(Map<TopicAndPartition, Seq<Object>> existing, Map<TopicAndPartition, Seq<Object>> proposed) {
        return (Map)existing.map((Function1 & Serializable & scala.Serializable)x0$12 -> {
            Tuple2 tuple2 = x0$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            Seq current = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)((SetLike)((TraversableOnce)proposed.apply((Object)tp)).toSet().$minus$minus((GenTraversableOnce)current)).toSeq());
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    private Map<TopicAndPartition, Seq<Object>> preRebalanceReplicaForMovingPartitions(Map<TopicAndPartition, Seq<Object>> existing, Map<TopicAndPartition, Seq<Object>> proposed) {
        return (Map)existing.filter((Function1 & Serializable & scala.Serializable)x0$13 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand.$anonfun$preRebalanceReplicaForMovingPartitions$1(proposed, x0$13)));
    }

    public String format(Map<TopicAndPartition, Seq<Object>> moves) {
        return ((TraversableOnce)moves.flatMap((Function1 & Serializable & scala.Serializable)x0$14 -> {
            Tuple2 tuple2 = x0$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            Seq moves = (Seq)tuple2._2();
            Seq seq = (Seq)moves.map((Function1 & Serializable & scala.Serializable)replicaId -> ReassignPartitionsCommand.$anonfun$format$2(tp, BoxesRunTime.unboxToInt((Object)replicaId)), Seq$.MODULE$.canBuildFrom());
            return seq;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
    }

    public Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> filterBy(String topic, Map<TopicAndPartition, Seq<Object>> allExisting, Map<TopicAndPartition, Seq<Object>> allProposed) {
        return new Tuple2(allExisting.filter((Function1 & Serializable & scala.Serializable)x0$15 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand.$anonfun$filterBy$1(topic, x0$15))), allProposed.filter((Function1 & Serializable & scala.Serializable)x0$16 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand.$anonfun$filterBy$2(topic, x0$16))));
    }

    public boolean reassignPartitions(long throttle) {
        boolean bl;
        this.maybeThrottle(throttle);
        try {
            Map validPartitions = (Map)this.proposedAssignment.filter((Function1 & Serializable & scala.Serializable)x0$17 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand.$anonfun$reassignPartitions$1(this, x0$17)));
            if (validPartitions.isEmpty()) {
                bl = false;
            } else {
                String jsonReassignmentData = ZkUtils$.MODULE$.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)validPartitions);
                this.zkUtils.createPersistentPath(ZkUtils$.MODULE$.ReassignPartitionsPath(), jsonReassignmentData, this.zkUtils.createPersistentPath$default$3());
                bl = true;
            }
        }
        catch (ZkNodeExistsException ze) {
            Map<TopicAndPartition, ReassignedPartitionsContext> partitionsBeingReassigned = this.zkUtils.getPartitionsBeingReassigned();
            throw new AdminCommandFailedException("Partition reassignment currently in " + new StringOps(Predef$.MODULE$.augmentString("progress for %s. Aborting operation")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsBeingReassigned})));
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Admin command failed", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            bl = false;
        }
        return bl;
    }

    public long reassignPartitions$default$1() {
        return -1L;
    }

    public boolean validatePartition(ZkUtils zkUtils, String topic, int partition) {
        boolean bl;
        Option partitionsOpt = zkUtils.getPartitionsForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)topic);
        Option option = partitionsOpt;
        if (option instanceof Some) {
            boolean bl2;
            Some some = (Some)option;
            Seq partitions = (Seq)some.value();
            if (partitions.contains((Object)BoxesRunTime.boxToInteger((int)partition))) {
                bl2 = true;
            } else {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Skipping reassignment of partition [%s,%d] ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition)})) + "since it doesn't exist");
                bl2 = false;
            }
            bl = bl2;
        } else if (None$.MODULE$.equals(option)) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping reassignment of partition " + new StringOps(Predef$.MODULE$.augmentString("[%s,%d] since topic %s doesn't exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), topic})));
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$assignThrottledReplicas$2(ReassignPartitionsCommand $this, Map allExisting$1, Map allProposed$1, AdminUtilities admin$1, String topic) {
        Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> tuple2 = $this.filterBy(topic, (Map<TopicAndPartition, Seq<Object>>)allExisting$1, (Map<TopicAndPartition, Seq<Object>>)allProposed$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map existing = (Map)tuple2._1();
        Map proposed = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existing, (Object)proposed);
        Tuple2 tuple23 = tuple22;
        Map existing2 = (Map)tuple23._1();
        Map proposed2 = (Map)tuple23._2();
        String leader = $this.format($this.preRebalanceReplicaForMovingPartitions((Map<TopicAndPartition, Seq<Object>>)existing2, (Map<TopicAndPartition, Seq<Object>>)proposed2));
        String follower = $this.format($this.postRebalanceReplicasThatMoved((Map<TopicAndPartition, Seq<Object>>)existing2, (Map<TopicAndPartition, Seq<Object>>)proposed2));
        Properties configs = admin$1.fetchEntityConfig($this.zkUtils, ConfigType$.MODULE$.Topic(), topic);
        configs.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), leader);
        configs.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), follower);
        admin$1.changeTopicConfig($this.zkUtils, topic, configs);
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated leader-throttled replicas for topic ", " with: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, leader})));
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated follower-throttled replicas for topic ", " with: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, follower})));
    }

    public static final /* synthetic */ boolean $anonfun$preRebalanceReplicaForMovingPartitions$1(Map proposed$1, Tuple2 x0$13) {
        Tuple2 tuple2 = x0$13;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition tp = (TopicAndPartition)tuple2._1();
        Seq current = (Seq)tuple2._2();
        boolean bl = ((TraversableOnce)((TraversableOnce)proposed$1.apply((Object)tp)).toSet().$minus$minus((GenTraversableOnce)current)).nonEmpty();
        return bl;
    }

    public static final /* synthetic */ String $anonfun$format$2(TopicAndPartition tp$1, int replicaId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tp$1.partition()), BoxesRunTime.boxToInteger((int)replicaId)}));
    }

    public static final /* synthetic */ boolean $anonfun$filterBy$1(String topic$2, Tuple2 x0$15) {
        Tuple2 tuple2 = x0$15;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition tp = (TopicAndPartition)tuple2._1();
        String string = tp.topic();
        String string2 = topic$2;
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterBy$2(String topic$2, Tuple2 x0$16) {
        Tuple2 tuple2 = x0$16;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition tp = (TopicAndPartition)tuple2._1();
        String string = tp.topic();
        String string2 = topic$2;
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$reassignPartitions$1(ReassignPartitionsCommand $this, Tuple2 x0$17) {
        Tuple2 tuple2 = x0$17;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition p = (TopicAndPartition)tuple2._1();
        boolean bl = $this.validatePartition($this.zkUtils, p.topic(), p.partition());
        return bl;
    }

    public ReassignPartitionsCommand(ZkUtils zkUtils, Map<TopicAndPartition, Seq<Object>> proposedAssignment) {
        this.zkUtils = zkUtils;
        this.proposedAssignment = proposedAssignment;
        Logging.$init$(this);
    }

    public static class ReassignPartitionsCommandOptions {
        private final OptionParser parser = new OptionParser();
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final OptionSpecBuilder generateOpt = this.parser().accepts("generate", "Generate a candidate partition reassignment configuration. Note that this only generates a candidate assignment, it does not execute it.");
        private final OptionSpecBuilder executeOpt = this.parser().accepts("execute", "Kick off the reassignment as specified by the --reassignment-json-file option.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify", "Verify if the reassignment completed as specified by the --reassignment-json-file option. If there is a throttle engaged for the replicas specified, and the rebalance has completed, the throttle will be removed");
        private final ArgumentAcceptingOptionSpec<String> reassignmentJsonFileOpt = this.parser().accepts("reassignment-json-file", "The JSON file with the partition reassignment configurationThe format to use is - \n{\"partitions\":\n\t[{\"topic\": \"foo\",\n\t  \"partition\": 1,\n\t  \"replicas\": [1,2,3] }],\n\"version\":1\n}").withRequiredArg().describedAs("manual assignment json file path").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicsToMoveJsonFileOpt = this.parser().accepts("topics-to-move-json-file", "Generate a reassignment configuration to move the partitions of the specified topics to the list of brokers specified by the --broker-list option. The format to use is - \n{\"topics\":\n\t[{\"topic\": \"foo\"},{\"topic\": \"foo1\"}],\n\"version\":1\n}").withRequiredArg().describedAs("topics to reassign json file path").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> brokerListOpt = this.parser().accepts("broker-list", "The list of brokers to which the partitions need to be reassigned in the form \"0,1,2\". This is required if --topics-to-move-json-file is used to generate reassignment configuration").withRequiredArg().describedAs("brokerlist").ofType(String.class);
        private final OptionSpecBuilder disableRackAware = this.parser().accepts("disable-rack-aware", "Disable rack aware replica assignment");
        private final ArgumentAcceptingOptionSpec<Object> throttleOpt = this.parser().accepts("throttle", "The movement of partitions will be throttled to this value (bytes/sec). Rerunning with this option, whilst a rebalance is in progress, will alter the throttle value. The throttle rate should be at least 1 KB/s.").withRequiredArg().describedAs("throttle").defaultsTo((Object)"-1", (Object[])new String[0]).ofType(Long.TYPE);
        private final OptionSet options;

        public OptionParser parser() {
            return this.parser;
        }

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public OptionSpecBuilder generateOpt() {
            return this.generateOpt;
        }

        public OptionSpecBuilder executeOpt() {
            return this.executeOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> reassignmentJsonFileOpt() {
            return this.reassignmentJsonFileOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicsToMoveJsonFileOpt() {
            return this.topicsToMoveJsonFileOpt;
        }

        public ArgumentAcceptingOptionSpec<String> brokerListOpt() {
            return this.brokerListOpt;
        }

        public OptionSpecBuilder disableRackAware() {
            return this.disableRackAware;
        }

        public ArgumentAcceptingOptionSpec<Object> throttleOpt() {
            return this.throttleOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public ReassignPartitionsCommandOptions(String[] args) {
            this.options = this.parser().parse(args);
        }
    }
}

