/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.List;
import kafka.api.ApiUtils$;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.api.TopicData;
import kafka.api.TopicDataSend;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.MultiSend;
import org.apache.kafka.common.network.Send;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001\u001d\u0011\u0011CR3uG\"\u0014Vm\u001d9p]N,7+\u001a8e\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001\u0002\u0005\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011cG\u0007\u0002%)\u00111\u0003F\u0001\b]\u0016$xo\u001c:l\u0015\t)b#\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b]Q!\u0001G\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0012aA8sO&\u0011AD\u0005\u0002\u0005'\u0016tG\r\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0001 \u0003\u0011!Wm\u001d;\u0016\u0003\u0001\u0002\"!\t\u0016\u000f\u0005\tB\u0003CA\u0012'\u001b\u0005!#BA\u0013\u0007\u0003\u0019a$o\\8u})\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tIc\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003!\u0003\u0015!Wm\u001d;!\u0011!\u0001\u0004A!b\u0001\n\u0003\t\u0014!\u00044fi\u000eD'+Z:q_:\u001cX-F\u00013!\t\u0019D'D\u0001\u0003\u0013\t)$AA\u0007GKR\u001c\u0007NU3ta>t7/\u001a\u0005\to\u0001\u0011\t\u0011)A\u0005e\u0005qa-\u001a;dQJ+7\u000f]8og\u0016\u0004\u0003\"B\u001d\u0001\t\u0003Q\u0014A\u0002\u001fj]&$h\bF\u0002<yu\u0002\"a\r\u0001\t\u000byA\u0004\u0019\u0001\u0011\t\u000bAB\u0004\u0019\u0001\u001a\t\u000f}\u0002!\u0019!C\u0005\u0001\u0006YQ-\u001c9us\n+hMZ3s+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#\r\u0003\rq\u0017n\\\u0005\u0003\r\u000e\u0013!BQ=uK\n+hMZ3s\u0011\u0019A\u0005\u0001)A\u0005\u0003\u0006aQ-\u001c9us\n+hMZ3sA!9!\n\u0001b\u0001\n\u0013Y\u0015a\u00039bs2|\u0017\rZ*ju\u0016,\u0012\u0001\u0014\t\u0003\u001b:k\u0011AJ\u0005\u0003\u001f\u001a\u00121!\u00138u\u0011\u0019\t\u0006\u0001)A\u0005\u0019\u0006a\u0001/Y=m_\u0006$7+\u001b>fA!91\u000b\u0001a\u0001\n\u0013!\u0016\u0001B:f]R,\u0012!\u0016\t\u0003\u001bZK!a\u0016\u0014\u0003\t1{gn\u001a\u0005\b3\u0002\u0001\r\u0011\"\u0003[\u0003!\u0019XM\u001c;`I\u0015\fHCA._!\tiE,\u0003\u0002^M\t!QK\\5u\u0011\u001dy\u0006,!AA\u0002U\u000b1\u0001\u001f\u00132\u0011\u0019\t\u0007\u0001)Q\u0005+\u0006)1/\u001a8uA!91\r\u0001a\u0001\n\u0013!\u0017a\u00029f]\u0012LgnZ\u000b\u0002KB\u0011QJZ\u0005\u0003O\u001a\u0012qAQ8pY\u0016\fg\u000eC\u0004j\u0001\u0001\u0007I\u0011\u00026\u0002\u0017A,g\u000eZ5oO~#S-\u001d\u000b\u00037.Dqa\u00185\u0002\u0002\u0003\u0007Q\r\u0003\u0004n\u0001\u0001\u0006K!Z\u0001\ta\u0016tG-\u001b8hA!)q\u000e\u0001C!a\u0006!1/\u001b>f)\u0005)\u0006\"\u0002:\u0001\t\u0003\u001a\u0018!C2p[BdW\r^3e)\u0005)\u0007\"B;\u0001\t\u00032\u0018a\u00033fgRLg.\u0019;j_:$\u0012\u0001\t\u0005\bq\u0002\u0011\r\u0011\"\u0003A\u0003\u0019\u0011WO\u001a4fe\"1!\u0010\u0001Q\u0001\n\u0005\u000bqAY;gM\u0016\u0014\b\u0005C\u0004}\u0001\t\u0007I\u0011B?\u0002\u000bM,g\u000eZ:\u0016\u0003y\u0004\"!E@\n\u0007\u0005\u0005!CA\u0005Nk2$\u0018nU3oI\"9\u0011Q\u0001\u0001!\u0002\u0013q\u0018AB:f]\u0012\u001c\b\u0005C\u0004\u0002\n\u0001!\t%a\u0003\u0002\u000f]\u0014\u0018\u000e^3U_R\u0019Q+!\u0004\t\u0011\u0005=\u0011q\u0001a\u0001\u0003#\tqa\u00195b]:,G\u000e\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9bQ\u0001\tG\"\fgN\\3mg&!\u00111DA\u000b\u0005Q9\u0015\r\u001e5fe&twMQ=uK\u000eC\u0017M\u001c8fY\u0002")
public class FetchResponseSend
implements Send {
    private final String dest;
    private final FetchResponse fetchResponse;
    private final ByteBuffer emptyBuffer;
    private final int payloadSize;
    private long sent;
    private boolean pending;
    private final ByteBuffer buffer;
    private final MultiSend sends;

    public String dest() {
        return this.dest;
    }

    public FetchResponse fetchResponse() {
        return this.fetchResponse;
    }

    private ByteBuffer emptyBuffer() {
        return this.emptyBuffer;
    }

    private int payloadSize() {
        return this.payloadSize;
    }

    private long sent() {
        return this.sent;
    }

    private void sent_$eq(long x$1) {
        this.sent = x$1;
    }

    private boolean pending() {
        return this.pending;
    }

    private void pending_$eq(boolean x$1) {
        this.pending = x$1;
    }

    public long size() {
        return 4 + this.payloadSize();
    }

    public boolean completed() {
        return this.sent() >= this.size() && !this.pending();
    }

    public String destination() {
        return this.dest();
    }

    private ByteBuffer buffer() {
        return this.buffer;
    }

    private MultiSend sends() {
        return this.sends;
    }

    /*
     * WARNING - void declaration
     */
    public long writeTo(GatheringByteChannel channel) {
        void var2_2;
        if (this.completed()) {
            throw new KafkaException("This operation cannot be completed on a complete request.");
        }
        long written = 0L;
        if (this.buffer().hasRemaining()) {
            written += (long)channel.write(this.buffer());
        }
        if (!this.buffer().hasRemaining()) {
            if (!this.sends().completed()) {
                written += this.sends().writeTo(channel);
            }
            if (this.sends().completed() && ApiUtils$.MODULE$.hasPendingWrites(channel)) {
                written += (long)channel.write(this.emptyBuffer());
            }
        }
        this.sent_$eq(this.sent() + written);
        this.pending_$eq(ApiUtils$.MODULE$.hasPendingWrites(channel));
        return (long)var2_2;
    }

    public FetchResponseSend(String dest, FetchResponse fetchResponse) {
        this.dest = dest;
        this.fetchResponse = fetchResponse;
        this.emptyBuffer = ByteBuffer.allocate(0);
        this.payloadSize = fetchResponse.sizeInBytes();
        this.sent = 0L;
        this.pending = false;
        this.buffer = ByteBuffer.allocate(4 + fetchResponse.headerSizeInBytes());
        fetchResponse.writeHeaderTo(this.buffer());
        this.buffer().rewind();
        this.sends = new MultiSend(dest, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)fetchResponse.dataGroupedByTopic().map((Function1 & java.io.Serializable & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            Seq data = (Seq)tuple2._2();
            TopicDataSend topicDataSend = new TopicDataSend(this.dest(), new TopicData(topic, (Seq<Tuple2<Object, FetchResponsePartitionData>>)data));
            return topicDataSend;
        }, Seq$.MODULE$.canBuildFrom())).asJava());
    }
}

