/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.common.BrokerNotAvailableException;
import kafka.common.KafkaException;
import kafka.utils.Json$;
import org.apache.kafka.common.protocol.SecurityProtocol;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;

public final class Broker$
implements scala.Serializable {
    public static Broker$ MODULE$;

    static {
        new Broker$();
    }

    public Broker createBroker(int id, String brokerInfoString) {
        Broker broker;
        if (brokerInfoString == null) {
            throw new BrokerNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
        }
        try {
            scala.collection.immutable.Map map;
            scala.collection.immutable.Map brokerInfo;
            Option<Object> option = Json$.MODULE$.parseFull(brokerInfoString);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object m = some.value();
                brokerInfo = (scala.collection.immutable.Map)m;
                int version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply((Object)"version"));
                if (version < 1) {
                    throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported version of broker registration: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerInfoString})));
                }
                if (version == 1) {
                    String host = (String)brokerInfo.apply((Object)"host");
                    int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply((Object)"port"));
                    map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)new EndPoint(host, port, SecurityProtocol.PLAINTEXT))}));
                } else {
                    List listeners = (List)brokerInfo.apply((Object)"endpoints");
                    map = ((TraversableOnce)listeners.map((Function1 & Serializable & scala.Serializable)listener -> {
                        EndPoint ep = EndPoint$.MODULE$.createEndPoint((String)listener);
                        return new Tuple2((Object)ep.protocolType(), (Object)ep);
                    }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new BrokerNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
                }
                throw new MatchError(option);
            }
            scala.collection.immutable.Map endpoints = map;
            Option rack = brokerInfo.get((Object)"rack").filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Broker$.$anonfun$createBroker$2(x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2);
            Broker broker2 = new Broker(id, (Map<SecurityProtocol, EndPoint>)endpoints, (Option<String>)rack);
            broker = broker2;
        }
        catch (Throwable t) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse the broker info from zookeeper: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerInfoString})), t);
        }
        return broker;
    }

    public Broker apply(int id, Map<SecurityProtocol, EndPoint> endPoints, Option<String> rack) {
        return new Broker(id, endPoints, rack);
    }

    public Option<Tuple3<Object, Map<SecurityProtocol, EndPoint>, Option<String>>> unapply(Broker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.id()), x$0.endPoints(), x$0.rack()));
    }

    public SecurityProtocol $lessinit$greater$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$createBroker$2(Object x$1) {
        return x$1 != null;
    }

    private Broker$() {
        MODULE$ = this;
    }
}

