/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.NotAssignedReplicaException;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigType$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaManager;
import kafka.server.TopicPartitionOperationKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.ReplicationUtils$;
import kafka.utils.Time;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\rh\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002U1si&$\u0018n\u001c8\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t\u001dQ\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011aB7fiJL7m]\u0005\u00033Y\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!Y\u0002A!b\u0001\n\u0003a\u0012!\u0002;pa&\u001cW#A\u000f\u0011\u0005y)cBA\u0010$!\t\u0001#\"D\u0001\"\u0015\t\u0011c!\u0001\u0004=e>|GOP\u0005\u0003I)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0014(\u0005\u0019\u0019FO]5oO*\u0011AE\u0003\u0005\tS\u0001\u0011\t\u0011)A\u0005;\u00051Ao\u001c9jG\u0002B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001L\u0001\fa\u0006\u0014H/\u001b;j_:LE-F\u0001.!\tIa&\u0003\u00020\u0015\t\u0019\u0011J\u001c;\t\u0011E\u0002!\u0011!Q\u0001\n5\nA\u0002]1si&$\u0018n\u001c8JI\u0002B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\u0005i&lW\r\u0005\u0002\u0010k%\u0011a\u0007\u0005\u0002\u0005)&lW\r\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0003\u0002\rM,'O^3s\u0013\tq4H\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000b\u0001\u0003A\u0011A!\u0002\rqJg.\u001b;?)\u0015\u0011E)\u0012$H!\t\u0019\u0005!D\u0001\u0003\u0011\u0015Yr\b1\u0001\u001e\u0011\u0015Ys\b1\u0001.\u0011\u0015\u0019t\b1\u00015\u0011\u0015At\b1\u0001:\u0011\u001dI\u0005A1A\u0005\n1\nQ\u0002\\8dC2\u0014%o\\6fe&#\u0007BB&\u0001A\u0003%Q&\u0001\bm_\u000e\fGN\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\t\u000f5\u0003!\u0019!C\u0005\u001d\u0006QAn\\4NC:\fw-\u001a:\u0016\u0003=\u0003\"\u0001U*\u000e\u0003ES!A\u0015\u0003\u0002\u00071|w-\u0003\u0002U#\nQAj\\4NC:\fw-\u001a:\t\rY\u0003\u0001\u0015!\u0003P\u0003-awnZ'b]\u0006<WM\u001d\u0011\t\u000fa\u0003!\u0019!C\u00053\u00069!p[+uS2\u001cX#\u0001.\u0011\u0005=Y\u0016B\u0001/\u0011\u0005\u001dQ6.\u0016;jYNDaA\u0018\u0001!\u0002\u0013Q\u0016\u0001\u0003>l+RLGn\u001d\u0011\t\u000f\u0001\u0004!\u0019!C\u0005C\u0006\u0011\u0012m]:jO:,GMU3qY&\u001c\u0017-T1q+\u0005\u0011\u0007\u0003B\bd[\u0015L!\u0001\u001a\t\u0003\tA{w\u000e\u001c\t\u0003\u0007\u001aL!a\u001a\u0002\u0003\u000fI+\u0007\u000f\\5dC\"1\u0011\u000e\u0001Q\u0001\n\t\f1#Y:tS\u001etW\r\u001a*fa2L7-Y'ba\u0002Bqa\u001b\u0001C\u0002\u0013%A.A\nmK\u0006$WM]%teV\u0003H-\u0019;f\u0019>\u001c7.F\u0001n!\tqw/D\u0001p\u0015\t\u0001\u0018/A\u0003m_\u000e\\7O\u0003\u0002sg\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Q,\u0018\u0001B;uS2T\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002y_\n1\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7\u000e\u0003\u0004{\u0001\u0001\u0006I!\\\u0001\u0015Y\u0016\fG-\u001a:JgJ,\u0006\u000fZ1uK2{7m\u001b\u0011\t\u000fq\u0004\u0001\u0019!C\u0005Y\u0005I!p\u001b,feNLwN\u001c\u0005\b}\u0002\u0001\r\u0011\"\u0003\u0000\u00035Q8NV3sg&|gn\u0018\u0013fcR!\u0011\u0011AA\u0004!\rI\u00111A\u0005\u0004\u0003\u000bQ!\u0001B+oSRD\u0001\"!\u0003~\u0003\u0003\u0005\r!L\u0001\u0004q\u0012\n\u0004bBA\u0007\u0001\u0001\u0006K!L\u0001\u000bu.4VM]:j_:\u0004\u0003\u0002CA\t\u0001\u0001\u0007I\u0011\u0002\u0017\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\n\u0003+\u0001\u0001\u0019!C\u0005\u0003/\tq\u0002\\3bI\u0016\u0014X\t]8dQ~#S-\u001d\u000b\u0005\u0003\u0003\tI\u0002C\u0005\u0002\n\u0005M\u0011\u0011!a\u0001[!9\u0011Q\u0004\u0001!B\u0013i\u0013\u0001\u00047fC\u0012,'/\u00129pG\"\u0004\u0003\u0006BA\u000e\u0003C\u00012!CA\u0012\u0013\r\t)C\u0003\u0002\tm>d\u0017\r^5mK\"I\u0011\u0011\u0006\u0001A\u0002\u0013\u0005\u00111F\u0001\u0013Y\u0016\fG-\u001a:SKBd\u0017nY1JI>\u0003H/\u0006\u0002\u0002.A!\u0011\"a\f.\u0013\r\t\tD\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005U\u0002\u00011A\u0005\u0002\u0005]\u0012A\u00067fC\u0012,'OU3qY&\u001c\u0017-\u00133PaR|F%Z9\u0015\t\u0005\u0005\u0011\u0011\b\u0005\u000b\u0003\u0013\t\u0019$!AA\u0002\u00055\u0002\u0002CA\u001f\u0001\u0001\u0006K!!\f\u0002'1,\u0017\rZ3s%\u0016\u0004H.[2b\u0013\u0012|\u0005\u000f\u001e\u0011)\t\u0005m\u0012\u0011\u0005\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0001\u0003\u000b\na\"\u001b8Ts:\u001c'+\u001a9mS\u000e\f7/\u0006\u0002\u0002HA!a$!\u0013f\u0013\r\tYe\n\u0002\u0004'\u0016$\b\"CA(\u0001\u0001\u0007I\u0011AA)\u0003IIgnU=oGJ+\u0007\u000f\\5dCN|F%Z9\u0015\t\u0005\u0005\u00111\u000b\u0005\u000b\u0003\u0013\ti%!AA\u0002\u0005\u001d\u0003\u0002CA,\u0001\u0001\u0006K!a\u0012\u0002\u001f%t7+\u001f8d%\u0016\u0004H.[2bg\u0002BC!!\u0016\u0002\"!A\u0011Q\f\u0001A\u0002\u0013%A&A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0011%\t\t\u0007\u0001a\u0001\n\u0013\t\u0019'A\nd_:$(o\u001c7mKJ,\u0005o\\2i?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005\u0015\u0004\"CA\u0005\u0003?\n\t\u00111\u0001.\u0011\u001d\tI\u0007\u0001Q!\n5\n\u0001cY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0011\t\u000f\u00055\u0004\u0001\"\u0003\u0002p\u0005q\u0011n\u001d*fa2L7-\u0019'pG\u0006dG\u0003BA9\u0003o\u00022!CA:\u0013\r\t)H\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\tI(a\u001bA\u00025\n\u0011B]3qY&\u001c\u0017-\u00133\t\u0013\u0005u\u0004A1A\u0005\u0002\u0005}\u0014\u0001\u0002;bON,\"!!!\u0011\u0011\u0005\r\u0015QRAI\u0003#k!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\nS6lW\u000f^1cY\u0016T1!a#\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\u000b)IA\u0002NCB\u0004B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0004\u0003/+\u0018\u0001\u00027b]\u001eL1AJAK\u0011!\ti\n\u0001Q\u0001\n\u0005\u0005\u0015!\u0002;bON\u0004\u0003bBAQ\u0001\u0011\u0005\u00111U\u0001\u0012SN,f\u000eZ3s%\u0016\u0004H.[2bi\u0016$GCAA9\u0011\u001d\t9\u000b\u0001C\u0001\u0003S\u000b!cZ3u\u001fJ\u001c%/Z1uKJ+\u0007\u000f\\5dCR\u0019Q-a+\t\u0013\u0005e\u0014Q\u0015I\u0001\u0002\u0004i\u0003bBAX\u0001\u0011\u0005\u0011\u0011W\u0001\u000bO\u0016$(+\u001a9mS\u000e\fG\u0003BAZ\u0003k\u0003B!CA\u0018K\"I\u0011\u0011PAW!\u0003\u0005\r!\f\u0005\b\u0003s\u0003A\u0011AA^\u0003QaW-\u00193feJ+\u0007\u000f\\5dC&3Gj\\2bYR\u0011\u00111\u0017\u0005\b\u0003\u007f\u0003A\u0011AAa\u0003U\tG\r\u001a*fa2L7-Y%g\u001d>$X\t_5tiN$2!ZAb\u0011\u001d\t)-!0A\u0002\u0015\fqA]3qY&\u001c\u0017\rC\u0004\u0002J\u0002!\t!a3\u0002!\u0005\u001c8/[4oK\u0012\u0014V\r\u001d7jG\u0006\u001cHCAA$\u0011\u001d\ty\r\u0001C\u0001\u0003#\fQB]3n_Z,'+\u001a9mS\u000e\fG\u0003BA\u0001\u0003'Dq!!\u001f\u0002N\u0002\u0007Q\u0006C\u0004\u0002X\u0002!\t!!7\u0002\r\u0011,G.\u001a;f)\t\t\t\u0001C\u0004\u0002^\u0002!\t!a8\u0002\u001d\u001d,G\u000fT3bI\u0016\u0014X\t]8dQR\tQ\u0006C\u0004\u0002d\u0002!\t!!:\u0002\u00155\f7.\u001a'fC\u0012,'\u000f\u0006\u0005\u0002r\u0005\u001d\u00181\u001eB\u0005\u0011\u001d\tI/!9A\u00025\nAbY8oiJ|G\u000e\\3s\u0013\u0012D\u0001\"!<\u0002b\u0002\u0007\u0011q^\u0001\u0013a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0013:4w\u000e\u0005\u0003\u0002r\n\u0015QBAAz\u0015\u0011\t)0a>\u0002\u0011I,\u0017/^3tiNTA!!?\u0002|\u000611m\\7n_:T1!BA\u007f\u0015\u0011\tyP!\u0001\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0011\u0019!A\u0002pe\u001eLAAa\u0002\u0002t\nq\u0001+\u0019:uSRLwN\\*uCR,\u0007b\u0002B\u0006\u0003C\u0004\r!L\u0001\u000eG>\u0014(/\u001a7bi&|g.\u00133\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012\u0005aQ.Y6f\r>dGn\\<feRA\u0011\u0011\u000fB\n\u0005+\u00119\u0002C\u0004\u0002j\n5\u0001\u0019A\u0017\t\u0011\u00055(Q\u0002a\u0001\u0003_DqAa\u0003\u0003\u000e\u0001\u0007Q\u0006C\u0004\u0003\u001c\u0001!\tA!\b\u00025U\u0004H-\u0019;f%\u0016\u0004H.[2b\u0019><'+Z1e%\u0016\u001cX\u000f\u001c;\u0015\r\u0005\u0005!q\u0004B\u0011\u0011\u001d\tIH!\u0007A\u00025B\u0001Ba\t\u0003\u001a\u0001\u0007!QE\u0001\u000eY><'+Z1e%\u0016\u001cX\u000f\u001c;\u0011\u0007i\u00129#C\u0002\u0003*m\u0012Q\u0002T8h%\u0016\fGMU3tk2$\bb\u0002B\u0017\u0001\u0011\u0005!qF\u0001\u000f[\u0006L(-Z#ya\u0006tG-S:s)\u0011\t\tA!\r\t\u000f\u0005e$1\u0006a\u0001[!9!Q\u0007\u0001\u0005\u0002\t]\u0012AH2iK\u000e\\WI\\8vO\"\u0014V\r\u001d7jG\u0006\u001c(+Z1dQ>3gm]3u)\u0011\u0011IDa\u0013\u0011\u000f%\u0011Y$!\u001d\u0003@%\u0019!Q\b\u0006\u0003\rQ+\b\u000f\\33!\u0011\u0011\tEa\u0012\u000e\u0005\t\r#\u0002\u0002B#\u0003o\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005\u0013\u0012\u0019E\u0001\u0004FeJ|'o\u001d\u0005\t\u0005\u001b\u0012\u0019\u00041\u0001\u0003P\u0005q!/Z9vSJ,Gm\u00144gg\u0016$\bcA\u0005\u0003R%\u0019!1\u000b\u0006\u0003\t1{gn\u001a\u0005\b\u0005/\u0002A\u0011\u0002B-\u0003Yi\u0017-\u001f2f\u0013:\u001c'/Z7f]RdU-\u00193fe\";F\u0003BA9\u00057BqA!\u0018\u0003V\u0001\u0007Q-A\u0007mK\u0006$WM\u001d*fa2L7-\u0019\u0005\b\u0005C\u0002A\u0011BAm\u0003i!(/_\"p[BdW\r^3EK2\f\u00170\u001a3SKF,Xm\u001d;t\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005O\na\"\\1zE\u0016\u001c\u0006N]5oW&\u001b(\u000f\u0006\u0003\u0002\u0002\t%\u0004\u0002\u0003B6\u0005G\u0002\rAa\u0014\u0002'I,\u0007\u000f\\5dC6\u000b\u0007\u0010T1h)&lW-T:\t\u000f\t=\u0004\u0001\"\u0001\u0003r\u0005!r-\u001a;PkR|emU=oGJ+\u0007\u000f\\5dCN$b!a\u0012\u0003t\tU\u0004b\u0002B/\u0005[\u0002\r!\u001a\u0005\t\u0005o\u0012i\u00071\u0001\u0003P\u0005AQ.\u0019=MC\u001el5\u000fC\u0004\u0003|\u0001!\tA! \u0002-\u0005\u0004\b/\u001a8e\u001b\u0016\u001c8/Y4fgR{G*Z1eKJ$bAa \u0003\u0006\nU\u0005c\u0001)\u0003\u0002&\u0019!1Q)\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011!\u00119I!\u001fA\u0002\t%\u0015\u0001C7fgN\fw-Z:\u0011\t\t-%\u0011S\u0007\u0003\u0005\u001bS1Aa$\u0005\u0003\u001diWm]:bO\u0016LAAa%\u0003\u000e\n!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKRD\u0011Ba&\u0003zA\u0005\t\u0019A\u0017\u0002\u0019I,\u0017/^5sK\u0012\f5m[:\t\u000f\tm\u0005\u0001\"\u0003\u0003\u001e\u0006IQ\u000f\u001d3bi\u0016L5O\u001d\u000b\u0005\u0003\u0003\u0011y\n\u0003\u0005\u0003\"\ne\u0005\u0019AA$\u0003\u0019qWm^%te\"9!Q\u0015\u0001\u0005\n\u0005e\u0017A\u0006:f[>4X\rU1si&$\u0018n\u001c8NKR\u0014\u0018nY:\t\u000f\t%\u0006\u0001\"\u0011\u0003,\u00061Q-];bYN$B!!\u001d\u0003.\"A!q\u0016BT\u0001\u0004\u0011\t,\u0001\u0003uQ\u0006$\bcA\u0005\u00034&\u0019!Q\u0017\u0006\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003:\u0002!\t%a8\u0002\u0011!\f7\u000f[\"pI\u0016DqA!0\u0001\t\u0003\u0012y,\u0001\u0005u_N#(/\u001b8h)\u0005i\u0002\"\u0003Bb\u0001E\u0005I\u0011\u0001Bc\u0003q9W\r^(s\u0007J,\u0017\r^3SKBd\u0017nY1%I\u00164\u0017-\u001e7uIE*\"Aa2+\u00075\u0012Im\u000b\u0002\u0003LB!!Q\u001aBl\u001b\t\u0011yM\u0003\u0003\u0003R\nM\u0017!C;oG\",7m[3e\u0015\r\u0011)NC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bm\u0005\u001f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011i\u000eAI\u0001\n\u0003\u0011)-\u0001\u000bhKR\u0014V\r\u001d7jG\u0006$C-\u001a4bk2$H%\r\u0005\n\u0005C\u0004\u0011\u0013!C\u0001\u0005\u000b\f\u0001%\u00199qK:$W*Z:tC\u001e,7\u000fV8MK\u0006$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0001")
public class Partition
implements KafkaMetricsGroup {
    private final String topic;
    private final int partitionId;
    private final Time time;
    private final ReplicaManager replicaManager;
    private final int localBrokerId;
    private final LogManager logManager;
    private final ZkUtils zkUtils;
    private final Pool<Object, Replica> assignedReplicaMap;
    private final ReentrantReadWriteLock leaderIsrUpdateLock;
    private int zkVersion;
    private volatile int leaderEpoch;
    private volatile Option<Object> leaderReplicaIdOpt;
    private volatile scala.collection.immutable.Set<Replica> inSyncReplicas;
    private int controllerEpoch;
    private final scala.collection.immutable.Map<String, String> tags;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Partition partition = this;
        synchronized (partition) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    private int localBrokerId() {
        return this.localBrokerId;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private Pool<Object, Replica> assignedReplicaMap() {
        return this.assignedReplicaMap;
    }

    private ReentrantReadWriteLock leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    private int zkVersion() {
        return this.zkVersion;
    }

    private void zkVersion_$eq(int x$1) {
        this.zkVersion = x$1;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private void leaderEpoch_$eq(int x$1) {
        this.leaderEpoch = x$1;
    }

    public Option<Object> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Object> x$1) {
        this.leaderReplicaIdOpt = x$1;
    }

    public scala.collection.immutable.Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(scala.collection.immutable.Set<Replica> x$1) {
        this.inSyncReplicas = x$1;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    private boolean isReplicaLocal(int replicaId) {
        return replicaId == this.localBrokerId();
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    public boolean isUnderReplicated() {
        boolean bl;
        Option<Replica> option = this.leaderReplicaIfLocal();
        if (option instanceof Some) {
            bl = this.inSyncReplicas().size() < this.assignedReplicas().size();
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public Replica getOrCreateReplica(int replicaId) {
        Replica replica;
        Option<Replica> replicaOpt = this.getReplica(replicaId);
        Option<Replica> option = replicaOpt;
        if (option instanceof Some) {
            Replica replica2;
            Some some = (Some)option;
            replica = replica2 = (Replica)some.value();
        } else if (None$.MODULE$.equals(option)) {
            Replica replica3;
            if (this.isReplicaLocal(replicaId)) {
                LogConfig config = LogConfig$.MODULE$.fromProps(this.logManager().defaultConfig().originals(), AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils(), ConfigType$.MODULE$.Topic(), this.topic()));
                Log log = this.logManager().createLog(new TopicAndPartition(this.topic(), this.partitionId()), config);
                OffsetCheckpoint checkpoint = (OffsetCheckpoint)this.replicaManager.highWatermarkCheckpoints().apply((Object)log.dir().getParentFile().getAbsolutePath());
                Map<TopicAndPartition, Object> offsetMap = checkpoint.read();
                if (!offsetMap.contains((Object)new TopicAndPartition(this.topic(), this.partitionId()))) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("No checkpointed highwatermark is found for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId())})));
                }
                long offset = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse((Object)new TopicAndPartition(this.topic(), this.partitionId()), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L))), log.logEndOffset());
                Replica localReplica = new Replica(replicaId, this, this.time, offset, (Option<Log>)new Some((Object)log));
                replica3 = this.addReplicaIfNotExists(localReplica);
            } else {
                Replica remoteReplica = new Replica(replicaId, this, this.time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
                replica3 = this.addReplicaIfNotExists(remoteReplica);
            }
            replica = (Replica)this.getReplica(replicaId).get();
        } else {
            throw new MatchError(option);
        }
        return replica;
    }

    public int getOrCreateReplica$default$1() {
        return this.localBrokerId();
    }

    public Option<Replica> getReplica(int replicaId) {
        Replica replica = this.assignedReplicaMap().get(BoxesRunTime.boxToInteger((int)replicaId));
        return replica == null ? None$.MODULE$ : new Some((Object)replica);
    }

    public int getReplica$default$1() {
        return this.localBrokerId();
    }

    public Option<Replica> leaderReplicaIfLocal() {
        None$ none$;
        Option<Object> option = this.leaderReplicaIdOpt();
        if (option instanceof Some) {
            Some some = (Some)option;
            int leaderReplicaId = BoxesRunTime.unboxToInt((Object)some.value());
            none$ = leaderReplicaId == this.localBrokerId() ? this.getReplica(this.localBrokerId()) : None$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.assignedReplicaMap().putIfNotExists(BoxesRunTime.boxToInteger((int)replica.brokerId()), replica);
    }

    public scala.collection.immutable.Set<Replica> assignedReplicas() {
        return this.assignedReplicaMap().values().toSet();
    }

    public void removeReplica(int replicaId) {
        this.assignedReplicaMap().remove(BoxesRunTime.boxToInteger((int)replicaId));
    }

    public void delete() {
        CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assignedReplicaMap().clear();
            this.inSyncReplicas_$eq((scala.collection.immutable.Set<Replica>)Predef$.MODULE$.Set().empty());
            this.leaderReplicaIdOpt_$eq((Option<Object>)None$.MODULE$);
            try {
                this.logManager().deleteLog(new TopicAndPartition(this.topic(), this.partitionId()));
                this.removePartitionMetrics();
            }
            catch (IOException e) {
                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error deleting the log for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId())})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                Runtime.getRuntime().halt(1);
            }
        });
    }

    public int getLeaderEpoch() {
        return this.leaderEpoch();
    }

    public boolean makeLeader(int controllerId, PartitionState partitionStateInfo, int correlationId) {
        boolean isNewLeader;
        block1: {
            Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
                boolean bl;
                Set allReplicas = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitionStateInfo$1.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1)), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
                this.controllerEpoch_$eq(partitionStateInfo$1.controllerEpoch);
                allReplicas.foreach((Function1 & Serializable & scala.Serializable)replica -> this.getOrCreateReplica(BoxesRunTime.unboxToInt((Object)replica)));
                scala.collection.immutable.Set newInSyncReplicas = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$1.isr).asScala()).map((Function1 & Serializable & scala.Serializable)r -> this.getOrCreateReplica(Predef$.MODULE$.Integer2int(r)), Buffer$.MODULE$.canBuildFrom())).toSet();
                ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.brokerId()), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)allReplicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> this.removeReplica(x$3));
                this.inSyncReplicas_$eq((scala.collection.immutable.Set<Replica>)newInSyncReplicas);
                this.leaderEpoch_$eq(partitionStateInfo$1.leaderEpoch);
                this.zkVersion_$eq(partitionStateInfo$1.zkVersion);
                if (this.leaderReplicaIdOpt().isDefined() && BoxesRunTime.unboxToInt((Object)this.leaderReplicaIdOpt().get()) == this.localBrokerId()) {
                    bl = false;
                } else {
                    this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.localBrokerId())));
                    bl = true;
                }
                boolean isNewLeader = bl;
                Replica leaderReplica = (Replica)this.getReplica(this.getReplica$default$1()).get();
                if (isNewLeader) {
                    leaderReplica.convertHWToLocalOffsetMetadata();
                    ((IterableLike)this.assignedReplicas().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$makeLeader$7(this, x$4)))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                        x$5.updateLogReadResult(LogReadResult$.MODULE$.UnknownLogReadResult());
                        return BoxedUnit.UNIT;
                    });
                }
                return new Tuple2.mcZZ.sp(this.maybeIncrementLeaderHW(leaderReplica), isNewLeader);
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean leaderHWIncremented = tuple2._1$mcZ$sp();
            boolean isNewLeader2 = tuple2._2$mcZ$sp();
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(leaderHWIncremented, isNewLeader2);
            Tuple2.mcZZ.sp sp3 = sp2;
            boolean leaderHWIncremented2 = sp3._1$mcZ$sp();
            isNewLeader = sp3._2$mcZ$sp();
            if (!leaderHWIncremented2) break block1;
            this.tryCompleteDelayedRequests();
        }
        return isNewLeader;
    }

    public boolean makeFollower(int controllerId, PartitionState partitionStateInfo, int correlationId) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Set allReplicas = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitionStateInfo$2.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$7)), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
            int newLeaderBrokerId = partitionStateInfo$2.leader;
            this.controllerEpoch_$eq(partitionStateInfo$2.controllerEpoch);
            allReplicas.foreach((Function1 & Serializable & scala.Serializable)r -> this.getOrCreateReplica(BoxesRunTime.unboxToInt((Object)r)));
            ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId()), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)allReplicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> this.removeReplica(x$9));
            this.inSyncReplicas_$eq((scala.collection.immutable.Set<Replica>)Predef$.MODULE$.Set().empty());
            this.leaderEpoch_$eq(partitionStateInfo$2.leaderEpoch);
            this.zkVersion_$eq(partitionStateInfo$2.zkVersion);
            if (this.leaderReplicaIdOpt().isDefined() && BoxesRunTime.unboxToInt((Object)this.leaderReplicaIdOpt().get()) == newLeaderBrokerId) {
                bl = false;
            } else {
                this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)newLeaderBrokerId)));
                bl = true;
            }
            return bl;
        }));
    }

    public void updateReplicaLogReadResult(int replicaId, LogReadResult logReadResult) {
        Option<Replica> option = this.getReplica(replicaId);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NotAssignedReplicaException(new StringOps(Predef$.MODULE$.augmentString("Leader %d failed to record follower %d's position %d since the replica is not recognized to be one of the assigned replicas %s for partition %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.localBrokerId()), BoxesRunTime.boxToInteger((int)replicaId), BoxesRunTime.boxToLong((long)logReadResult.info().fetchOffsetMetadata().messageOffset()), ((TraversableOnce)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","), new TopicAndPartition(this.topic(), this.partitionId())})));
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Replica replica = (Replica)some.value();
        replica.updateLogReadResult(logReadResult);
        this.maybeExpandIsr(replicaId);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Recorded replica %d log end offset (LEO) position %d for partition %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), BoxesRunTime.boxToLong((long)logReadResult.info().fetchOffsetMetadata().messageOffset()), new TopicAndPartition(this.topic(), this.partitionId())})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void maybeExpandIsr(int replicaId) {
        block0: {
            boolean leaderHWIncremented = BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                Option<Replica> option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Replica leaderReplica = (Replica)some.value();
                    Replica replica = (Replica)this.getReplica(replicaId).get();
                    LogOffsetMetadata leaderHW = leaderReplica.highWatermark();
                    if (!this.inSyncReplicas().contains((Object)replica) && ((SetLike)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.brokerId()), Set$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) && replica.logEndOffset().offsetDiff(leaderHW) >= 0L) {
                        scala.collection.immutable.Set newInSyncReplicas = (scala.collection.immutable.Set)this.inSyncReplicas().$plus((Object)replica);
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Expanding ISR for partition [%s,%d] from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), ((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)newInSyncReplicas.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
                        this.updateIsr((scala.collection.immutable.Set<Replica>)newInSyncReplicas);
                        $this.replicaManager.isrExpandRate().mark();
                    }
                    bl = this.maybeIncrementLeaderHW(leaderReplica);
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError(option);
                }
                return bl;
            }));
            if (!leaderHWIncremented) break block0;
            this.tryCompleteDelayedRequests();
        }
    }

    public Tuple2<Object, Errors> checkEnoughReplicasReachOffset(long requiredOffset) {
        Tuple2 tuple2;
        Option<Replica> option = this.leaderReplicaIfLocal();
        if (option instanceof Some) {
            Some some = (Some)option;
            Replica leaderReplica = (Replica)some.value();
            scala.collection.immutable.Set<Replica> curInSyncReplicas = this.inSyncReplicas();
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " acks satisfied for ", "-", " with acks = -1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numAcks$1(requiredOffset, curInSyncReplicas)), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId())})));
            Integer minIsr = ((Log)leaderReplica.log().get()).config().minInSyncReplicas();
            tuple2 = leaderReplica.highWatermark().messageOffset() >= requiredOffset ? (Predef$.MODULE$.Integer2int(minIsr) <= curInSyncReplicas.size() ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Errors.NONE) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND)) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NONE);
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NOT_LEADER_FOR_PARTITION);
        } else {
            throw new MatchError(option);
        }
        return tuple2;
    }

    private boolean maybeIncrementLeaderHW(Replica leaderReplica) {
        boolean bl;
        scala.collection.immutable.Set allLogEndOffsets = (scala.collection.immutable.Set)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.logEndOffset(), Set$.MODULE$.canBuildFrom());
        LogOffsetMetadata newHighWatermark = (LogOffsetMetadata)allLogEndOffsets.min((Ordering)new LogOffsetMetadata.OffsetOrdering());
        LogOffsetMetadata oldHighWatermark = leaderReplica.highWatermark();
        if (oldHighWatermark.messageOffset() < newHighWatermark.messageOffset() || oldHighWatermark.onOlderSegment(newHighWatermark)) {
            leaderReplica.highWatermark_$eq(newHighWatermark);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("High watermark for partition [%s,%d] updated to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), newHighWatermark})));
            bl = true;
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Skipping update high watermark since Old hw %s is larger than new hw %s for partition [%s,%d]. All leo's are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldHighWatermark, newHighWatermark, this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), allLogEndOffsets.mkString(",")})));
            bl = false;
        }
        return bl;
    }

    private void tryCompleteDelayedRequests() {
        TopicPartitionOperationKey requestKey = new TopicPartitionOperationKey(this.topic(), this.partitionId());
        this.replicaManager.tryCompleteDelayedFetch(requestKey);
        this.replicaManager.tryCompleteDelayedProduce(requestKey);
    }

    public void maybeShrinkIsr(long replicaMaxLagTimeMs) {
        block0: {
            boolean leaderHWIncremented = BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                Option<Replica> option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    boolean bl2;
                    Some some = (Some)option;
                    Replica leaderReplica = (Replica)some.value();
                    scala.collection.immutable.Set<Replica> outOfSyncReplicas = this.getOutOfSyncReplicas(leaderReplica, replicaMaxLagTimeMs);
                    if (outOfSyncReplicas.nonEmpty()) {
                        scala.collection.immutable.Set newInSyncReplicas = (scala.collection.immutable.Set)this.inSyncReplicas().$minus$minus(outOfSyncReplicas);
                        Predef$.MODULE$.assert(newInSyncReplicas.nonEmpty());
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Shrinking ISR for partition [%s,%d] from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), ((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)newInSyncReplicas.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
                        this.updateIsr((scala.collection.immutable.Set<Replica>)newInSyncReplicas);
                        $this.replicaManager.isrShrinkRate().mark();
                        bl2 = this.maybeIncrementLeaderHW(leaderReplica);
                    } else {
                        bl2 = false;
                    }
                    bl = bl2;
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError(option);
                }
                return bl;
            }));
            if (!leaderHWIncremented) break block0;
            this.tryCompleteDelayedRequests();
        }
    }

    public scala.collection.immutable.Set<Replica> getOutOfSyncReplicas(Replica leaderReplica, long maxLagMs) {
        scala.collection.immutable.Set laggingReplicas;
        block0: {
            LogOffsetMetadata leaderLogEndOffset = leaderReplica.logEndOffset();
            scala.collection.immutable.Set candidateReplicas = (scala.collection.immutable.Set)this.inSyncReplicas().$minus((Object)leaderReplica);
            laggingReplicas = (scala.collection.immutable.Set)candidateReplicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$getOutOfSyncReplicas$1(this, maxLagMs, r)));
            if (!laggingReplicas.nonEmpty()) break block0;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Lagging replicas for partition %s are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new TopicAndPartition(this.topic(), this.partitionId()), ((TraversableOnce)laggingReplicas.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
        }
        return laggingReplicas;
    }

    public LogAppendInfo appendMessagesToLeader(ByteBufferMessageSet messages, int requiredAcks) {
        LogAppendInfo info;
        block1: {
            Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
                Log log;
                Replica leaderReplica;
                Option<Replica> leaderReplicaOpt = this.leaderReplicaIfLocal();
                Option<Replica> option = leaderReplicaOpt;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    leaderReplica = (Replica)some.value();
                    log = (Log)leaderReplica.log().get();
                    Integer minIsr = log.config().minInSyncReplicas();
                    int inSyncSize = this.inSyncReplicas().size();
                    if (inSyncSize < Predef$.MODULE$.Integer2int(minIsr) && requiredAcks == -1) {
                        throw new NotEnoughReplicasException(new StringOps(Predef$.MODULE$.augmentString("Number of insync replicas for partition [%s,%d] is [%d], below required minimum [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)inSyncSize), minIsr})));
                    }
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
                    }
                    throw new MatchError(option);
                }
                LogAppendInfo info = log.append(messages, true);
                $this.replicaManager.tryCompleteDelayedFetch(new TopicPartitionOperationKey(this.topic(), this.partitionId()));
                Tuple2 tuple2 = new Tuple2((Object)info, (Object)BoxesRunTime.boxToBoolean((boolean)this.maybeIncrementLeaderHW(leaderReplica)));
                return tuple2;
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            LogAppendInfo info2 = (LogAppendInfo)tuple2._1();
            boolean leaderHWIncremented = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)info2, (Object)BoxesRunTime.boxToBoolean((boolean)leaderHWIncremented));
            Tuple2 tuple23 = tuple22;
            info = (LogAppendInfo)tuple23._1();
            boolean leaderHWIncremented2 = tuple23._2$mcZ$sp();
            if (!leaderHWIncremented2) break block1;
            this.tryCompleteDelayedRequests();
        }
        return info;
    }

    public int appendMessagesToLeader$default$2() {
        return 0;
    }

    private void updateIsr(scala.collection.immutable.Set<Replica> newIsr) {
        LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(this.localBrokerId(), this.leaderEpoch(), (List<Object>)((TraversableOnce)newIsr.map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)r.brokerId()), Set$.MODULE$.canBuildFrom())).toList(), this.zkVersion());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), this.topic(), this.partitionId(), newLeaderAndIsr, this.controllerEpoch(), this.zkVersion());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean updateSucceeded = tuple2._1$mcZ$sp();
        int newVersion = tuple2._2$mcI$sp();
        Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
        Tuple2.mcZI.sp sp3 = sp2;
        boolean updateSucceeded2 = sp3._1$mcZ$sp();
        int newVersion2 = sp3._2$mcI$sp();
        if (updateSucceeded2) {
            this.replicaManager.recordIsrChange(new TopicAndPartition(this.topic(), this.partitionId()));
            this.inSyncReplicas_$eq(newIsr);
            this.zkVersion_$eq(newVersion2);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("ISR updated to [%s] and zkVersion updated to [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newIsr.mkString(","), BoxesRunTime.boxToInteger((int)this.zkVersion())})));
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cached zkVersion [%d] not equal to that in zookeeper, skip updating ISR")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.zkVersion())})));
        }
    }

    private void removePartitionMetrics() {
        this.removeMetric("UnderReplicated", (Map<String, String>)this.tags());
    }

    public boolean equals(Object that) {
        if (!(that instanceof Partition)) {
            return false;
        }
        Partition other = (Partition)that;
        return this.topic().equals(other.topic()) && this.partitionId() == other.partitionId();
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId();
    }

    public String toString() {
        StringBuilder partitionString = new StringBuilder();
        partitionString.append("Topic: " + this.topic());
        partitionString.append("; Partition: " + this.partitionId());
        partitionString.append("; Leader: " + this.leaderReplicaIdOpt());
        partitionString.append("; AssignedReplicas: " + this.assignedReplicaMap().keys().mkString(","));
        partitionString.append("; InSyncReplicas: " + ((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","));
        return partitionString.toString();
    }

    public static final /* synthetic */ boolean $anonfun$makeLeader$7(Partition $this, Replica x$4) {
        return x$4.brokerId() != $this.localBrokerId();
    }

    public static final /* synthetic */ boolean $anonfun$checkEnoughReplicasReachOffset$1(Partition $this, long requiredOffset$1, Replica r) {
        boolean bl;
        if (!r.isLocal()) {
            if (r.logEndOffset().messageOffset() >= requiredOffset$1) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica ", " of ", "-", " received offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)r.brokerId()), $this.topic(), BoxesRunTime.boxToInteger((int)$this.partitionId()), BoxesRunTime.boxToLong((long)requiredOffset$1)})));
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private final int numAcks$1(long requiredOffset$1, scala.collection.immutable.Set curInSyncReplicas$1) {
        return curInSyncReplicas$1.count((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$checkEnoughReplicasReachOffset$1(this, requiredOffset$1, r)));
    }

    public static final /* synthetic */ boolean $anonfun$getOutOfSyncReplicas$1(Partition $this, long maxLagMs$1, Replica r) {
        return $this.time.milliseconds() - r.lastCaughtUpTimeMs() > maxLagMs$1;
    }

    public Partition(String topic, int partitionId, Time time, ReplicaManager replicaManager) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.time = time;
        this.replicaManager = replicaManager;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.localBrokerId = replicaManager.config().brokerId();
        this.logManager = replicaManager.logManager();
        this.zkUtils = replicaManager.zkUtils();
        this.assignedReplicaMap = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.leaderIsrUpdateLock = new ReentrantReadWriteLock();
        this.zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Predef$.MODULE$.Set().empty();
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] on broker %d: ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
        this.tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString())}));
        this.newGauge("UnderReplicated", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Partition $outer;

            public int value() {
                return this.$outer.isUnderReplicated() ? 1 : 0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
    }
}

