/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.cluster.Replica$;
import kafka.common.KafkaException;
import kafka.log.Log;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0006\t\u0003\u0013aI!!\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001 !\t\u0001\u0013%D\u0001\u0003\u0013\t\u0011#AA\u0005QCJ$\u0018\u000e^5p]\"AA\u0005\u0001B\u0001B\u0003%q$\u0001\u0006qCJ$\u0018\u000e^5p]\u0002B\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0005i&lW\r\u0005\u0002\u0010Q%\u0011\u0011\u0006\u0005\u0002\u0005)&lW\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003eIg.\u001b;jC2D\u0015n\u001a5XCR,'/\\1sWZ\u000bG.^3\u0011\u0005%i\u0013B\u0001\u0018\u000b\u0005\u0011auN\\4\t\u0011A\u0002!Q1A\u0005\u0002E\n1\u0001\\8h+\u0005\u0011\u0004cA\u00054k%\u0011AG\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005YBT\"A\u001c\u000b\u0005A\"\u0011BA\u001d8\u0005\raun\u001a\u0005\tw\u0001\u0011\t\u0011)A\u0005e\u0005!An\\4!\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q1q\bQ!C\u0007\u0012\u0003\"\u0001\t\u0001\t\u000bUa\u0004\u0019A\f\t\u000bua\u0004\u0019A\u0010\t\u000f\u0019b\u0004\u0013!a\u0001O!91\u0006\u0010I\u0001\u0002\u0004a\u0003b\u0002\u0019=!\u0003\u0005\rA\r\u0005\u0007\r\u0002\u0001\u000b\u0015B$\u0002+!Lw\r[,bi\u0016\u0014X.\u0019:l\u001b\u0016$\u0018\rZ1uCB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nB\u0001\u0007g\u0016\u0014h/\u001a:\n\u00051K%!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\"\u0012QI\u0014\t\u0003\u0013=K!\u0001\u0015\u0006\u0003\u0011Y|G.\u0019;jY\u0016DaA\u0015\u0001!B\u00139\u0015\u0001\u00067pO\u0016sGm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\r\u000b\u0002R\u001d\"9Q\u000b\u0001b\u0001\n\u00031\u0016!\u0002;pa&\u001cW#A,\u0011\u0005a{fBA-^!\tQ&\"D\u0001\\\u0015\taf!\u0001\u0004=e>|GOP\u0005\u0003=*\ta\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011aL\u0003\u0005\u0007G\u0002\u0001\u000b\u0011B,\u0002\rQ|\u0007/[2!\u0011\u001d)\u0007A1A\u0005\u0002Y\t1\u0002]1si&$\u0018n\u001c8JI\"1q\r\u0001Q\u0001\n]\tA\u0002]1si&$\u0018n\u001c8JI\u0002BQ!\u001b\u0001\u0005\u0002)\fq![:M_\u000e\fG.F\u0001l!\tIA.\u0003\u0002n\u0015\t9!i\\8mK\u0006t\u0007BB8\u0001A\u0003%\u0001/\u0001\u000fmCN$8)Y;hQR,\u0006\u000fV5nK6\u001bXK\u001c3fe2L\u0018N\\4\u0011\u0005ETX\"\u0001:\u000b\u0005M$\u0018AB1u_6L7M\u0003\u0002vm\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005]D\u0018\u0001B;uS2T\u0011!_\u0001\u0005U\u00064\u0018-\u0003\u0002|e\nQ\u0011\t^8nS\u000eduN\\4\t\u000bu\u0004A\u0011\u0001@\u0002%1\f7\u000f^\"bk\u001eDG/\u00169US6,Wj]\u000b\u0002Y!9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0011aE;qI\u0006$X\rT8h%\u0016\fGMU3tk2$H\u0003BA\u0003\u0003\u0017\u00012!CA\u0004\u0013\r\tIA\u0003\u0002\u0005+:LG\u000fC\u0004\u0002\u000e}\u0004\r!a\u0004\u0002\u001b1|wMU3bIJ+7/\u001e7u!\rA\u0015\u0011C\u0005\u0004\u0003'I%!\u0004'pOJ+\u0017\r\u001a*fgVdG\u000fC\u0004\u0002\u0018\u0001!I!!\u0007\u0002!1|w-\u00128e\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u0003\u00037Aq!!\b\u0002\u0016\u0001\u0007q)A\boK^dunZ#oI>3gm]3u\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\tA\u0002\\8h\u000b:$wJ\u001a4tKR,\u0012a\u0012\u0005\b\u0003O\u0001A\u0011AA\u0015\u0003EA\u0017n\u001a5XCR,'/\\1sW~#S-\u001d\u000b\u0005\u0003\u000b\tY\u0003C\u0004\u0002.\u0005\u0015\u0002\u0019A$\u0002!9,w\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007bBA\u0019\u0001\u0011\u0005\u00111E\u0001\u000eQ&<\u0007nV1uKJl\u0017M]6\t\u000f\u0005U\u0002\u0001\"\u0001\u00028\u0005q2m\u001c8wKJ$\bj\u0016+p\u0019>\u001c\u0017\r\\(gMN,G/T3uC\u0012\fG/\u0019\u000b\u0003\u0003\u000bAq!a\u000f\u0001\t\u0003\ni$\u0001\u0004fcV\fGn\u001d\u000b\u0004W\u0006}\u0002\u0002CA!\u0003s\u0001\r!a\u0011\u0002\tQD\u0017\r\u001e\t\u0004\u0013\u0005\u0015\u0013bAA$\u0015\t\u0019\u0011I\\=\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N\u0005A\u0001.Y:i\u0007>$W\rF\u0001\u0018\u0011\u001d\t\t\u0006\u0001C!\u0003'\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002/\u001eI\u0011q\u000b\u0002\u0002\u0002#\u0005\u0011\u0011L\u0001\b%\u0016\u0004H.[2b!\r\u0001\u00131\f\u0004\t\u0003\t\t\t\u0011#\u0001\u0002^M\u0019\u00111\f\u0005\t\u000fu\nY\u0006\"\u0001\u0002bQ\u0011\u0011\u0011\f\u0005\u000b\u0003K\nY&%A\u0005\u0002\u0005\u001d\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002j)\u001aq%a\u001b,\u0005\u00055\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001e\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\n\tHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a \u0002\\E\u0005I\u0011AAA\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0011\u0016\u0004Y\u0005-\u0004BCAD\u00037\n\n\u0011\"\u0001\u0002\n\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!a#+\u0007I\nY\u0007")
public class Replica
implements Logging {
    private final int brokerId;
    private final Partition partition;
    private final Time time;
    private final Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    private volatile LogOffsetMetadata logEndOffsetMetadata;
    private final String topic;
    private final int partitionId;
    private final AtomicLong lastCaughtUpTimeMsUnderlying;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Option<Log> $lessinit$greater$default$5() {
        return Replica$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$4() {
        return Replica$.MODULE$.$lessinit$greater$default$4();
    }

    public static Time $lessinit$greater$default$3() {
        return Replica$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Partition partition() {
        return this.partition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public boolean isLocal() {
        boolean bl;
        Option<Log> option = this.log();
        if (option instanceof Some) {
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public long lastCaughtUpTimeMs() {
        return this.lastCaughtUpTimeMsUnderlying.get();
    }

    public void updateLogReadResult(LogReadResult logReadResult) {
        block0: {
            this.logEndOffset_$eq(logReadResult.info().fetchOffsetMetadata());
            if (!logReadResult.isReadFromLogEnd()) break block0;
            this.lastCaughtUpTimeMsUnderlying.set(this.time.milliseconds());
        }
    }

    private void logEndOffset_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Should not set log end offset on partition [%s,%d]'s local replica %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.logEndOffsetMetadata = newLogEndOffset;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Setting log end offset for replica %d for partition [%s,%d] to [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId()), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), $this.logEndOffsetMetadata})));
    }

    public LogOffsetMetadata logEndOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logEndOffsetMetadata() : this.logEndOffsetMetadata;
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark) {
        if (!this.isLocal()) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Should not set high watermark on partition [%s,%d]'s non-local replica %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.highWatermarkMetadata = newHighWatermark;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Setting high watermark for replica %d partition [%s,%d] on broker %d to [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId()), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.brokerId()), newHighWatermark})));
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public void convertHWToLocalOffsetMetadata() {
        if (!this.isLocal()) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Should not construct complete high watermark on partition [%s,%d]'s non-local replica %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.highWatermarkMetadata = ((Log)this.log().get()).convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset());
    }

    public boolean equals(Object that) {
        if (!(that instanceof Replica)) {
            return false;
        }
        Replica other = (Replica)that;
        return this.topic().equals(other.topic()) && this.brokerId() == other.brokerId() && this.partition().equals(other.partition());
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.brokerId() + this.partition().hashCode();
    }

    public String toString() {
        StringBuilder replicaString = new StringBuilder();
        replicaString.append("ReplicaId: " + this.brokerId());
        replicaString.append("; Topic: " + this.topic());
        replicaString.append("; Partition: " + this.partition().partitionId());
        replicaString.append("; isLocal: " + this.isLocal());
        Object object = this.isLocal() ? replicaString.append("; Highwatermark: " + this.highWatermark()) : BoxedUnit.UNIT;
        return replicaString.toString();
    }

    public Replica(int brokerId, Partition partition, Time time, long initialHighWatermarkValue, Option<Log> log) {
        this.brokerId = brokerId;
        this.partition = partition;
        this.time = time;
        this.log = log;
        Logging.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
        this.logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this.topic = partition.topic();
        this.partitionId = partition.partitionId();
        this.lastCaughtUpTimeMsUnderlying = new AtomicLong(time.milliseconds());
    }
}

