/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5g\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0001!\u0011!Q\u0001\nU\u0001\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJDQA\u0007\u0001\u0005\u0002m\ta\u0001P5oSRtDC\u0001\u000f\u001e!\t1\u0002\u0001C\u0003\u00043\u0001\u0007Q\u0003C\u0004 \u0001\t\u0007I\u0011\u0002\u0011\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001\"!\t1\"%\u0003\u0002$\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r\u0015\u0002\u0001\u0015!\u0003\"\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005a1m\u001c8ue>dG.\u001a:JIV\t\u0011\u0006\u0005\u0002\nU%\u00111F\u0003\u0002\u0004\u0013:$\bBB\u0017\u0001A\u0003%\u0011&A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0003\u001dQ8.\u0016;jYN,\u0012!\r\t\u0003\u001fIJ!a\r\t\u0003\u000fi[W\u000b^5mg\"1Q\u0007\u0001Q\u0001\nE\n\u0001B_6Vi&d7\u000f\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016,\u0012!\u000f\t\u0005u}\nu)D\u0001<\u0015\taT(A\u0004nkR\f'\r\\3\u000b\u0005yR\u0011AC2pY2,7\r^5p]&\u0011\u0001i\u000f\u0002\u0004\u001b\u0006\u0004\bC\u0001\"F\u001b\u0005\u0019%B\u0001#\u0005\u0003\u0019\u0019w.\\7p]&\u0011ai\u0011\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007C\u0001\fI\u0013\tI%A\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\r-\u0003\u0001\u0015!\u0003:\u0003=\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0003bB'\u0001\u0005\u0004%IAT\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.F\u0001P!\t1\u0002+\u0003\u0002R\u0005\ta2i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007BB*\u0001A\u0003%q*A\nce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007\u0005C\u0004V\u0001\t\u0007I\u0011\u0002,\u0002\u0015!\f7o\u0015;beR,G-F\u0001X!\tA\u0016-D\u0001Z\u0015\tQ6,\u0001\u0004bi>l\u0017n\u0019\u0006\u00039v\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003Ef\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007B\u00023\u0001A\u0003%q+A\u0006iCN\u001cF/\u0019:uK\u0012\u0004\u0003b\u00024\u0001\u0005\u0004%IaZ\u0001\u001c]>|\u0005\u000fU1si&$\u0018n\u001c8MK\u0006$WM]*fY\u0016\u001cGo\u001c:\u0016\u0003!\u0004\"AF5\n\u0005)\u0014!A\u0005(p\u001fBdU-\u00193feN+G.Z2u_JDa\u0001\u001c\u0001!\u0002\u0013A\u0017\u0001\b8p\u001fB\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'\u000f\t\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0003M!x\u000e]5d\u0007\"\fgnZ3MSN$XM\\3s+\u0005\u0001\bCA9s\u001b\u0005\u0001a\u0001B:\u0001\u0001Q\u00141\u0003V8qS\u000e\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u001cBA];|\u001dA\u0011a/_\u0007\u0002o*\u0011\u0001pX\u0001\u0005Y\u0006tw-\u0003\u0002{o\n1qJ\u00196fGR\u00042\u0001`A\u0004\u001b\u0005i(B\u0001@\u0000\u0003!Q8n\u00197jK:$(\u0002BA\u0001\u0003\u0007\ta!\u0013\u0019Ji\u0016\u001c'BAA\u0003\u0003\ry'oZ\u0005\u0004\u0003\u0013i(\u0001E%[W\u000eC\u0017\u000e\u001c3MSN$XM\\3s\u0011\u0019Q\"\u000f\"\u0001\u0002\u000eQ\t\u0001\u000fC\u0004\u0002\u0012I$\t!a\u0005\u0002#!\fg\u000e\u001a7f\u0007\"LG\u000eZ\"iC:<W\r\u0006\u0004\u0002\u0016\u0005m\u0011Q\u0007\t\u0004\u0013\u0005]\u0011bAA\r\u0015\t!QK\\5u\u0011!\ti\"a\u0004A\u0002\u0005}\u0011A\u00039be\u0016tG\u000fU1uQB!\u0011\u0011EA\u0018\u001d\u0011\t\u0019#a\u000b\u0011\u0007\u0005\u0015\"\"\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\u0004\u0002\rq\u0012xn\u001c;?\u0013\r\tiCC\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00121\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055\"\u0002\u0003\u0005\u00028\u0005=\u0001\u0019AA\u001d\u0003!\u0019\u0007.\u001b7ee\u0016t\u0007CBA\u001e\u0003{\ty\"D\u0001^\u0013\r\ty$\u0018\u0002\u0005\u0019&\u001cH\u000f\u000b\u0004\u0002\u0010\u0005\r\u00131\f\t\u0006\u0013\u0005\u0015\u0013\u0011J\u0005\u0004\u0003\u000fR!A\u0002;ie><8\u000f\u0005\u0003\u0002L\u0005Uc\u0002BA'\u0003#rA!!\n\u0002P%\t1\"C\u0002\u0002T)\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002X\u0005e#!C#yG\u0016\u0004H/[8o\u0015\r\t\u0019FC\u0012\u0003\u0003\u0013Bq!a\u0018\u0001A\u0003%\u0001/\u0001\u000bu_BL7m\u00115b]\u001e,G*[:uK:,'\u000f\t\u0005\n\u0003G\u0002!\u0019!C\u0005\u0003K\nA\u0003Z3mKR,Gk\u001c9jGNd\u0015n\u001d;f]\u0016\u0014XCAA4!\r\t\u0018\u0011\u000e\u0004\u0007\u0003W\u0002\u0001!!\u001c\u0003)\u0011+G.\u001a;f)>\u0004\u0018nY:MSN$XM\\3s'\u0015\tI'^>\u000f\u0011\u001dQ\u0012\u0011\u000eC\u0001\u0003c\"\"!a\u001a\t\u0011=\nIG1A\u0005\u0002ABq!NA5A\u0003%\u0011\u0007\u0003\u0005\u0002\u0012\u0005%D\u0011AA=)\u0019\t)\"a\u001f\u0002~!A\u0011QDA<\u0001\u0004\ty\u0002\u0003\u0005\u00028\u0005]\u0004\u0019AA\u001dQ\u0019\t9(a\u0011\u0002\\!A\u00111QA5\t\u0003\t))A\tiC:$G.\u001a#bi\u0006$U\r\\3uK\u0012$B!!\u0006\u0002\b\"A\u0011\u0011RAA\u0001\u0004\ty\"\u0001\u0005eCR\f\u0007+\u0019;iQ\u0019\t\t)a\u0011\u0002\\!A\u0011q\u0012\u0001!\u0002\u0013\t9'A\u000beK2,G/\u001a+pa&\u001c7\u000fT5ti\u0016tWM\u001d\u0011\t\u0013\u0005M\u0005A1A\u0005\n\u0005U\u0015a\b9beRLG/[8o\u001b>$\u0017NZ5dCRLwN\\:MSN$XM\\3sgV\u0011\u0011q\u0013\t\u0007u}\ny\"!'\u0011\u0007E\fYJ\u0002\u0004\u0002\u001e\u0002\u0001\u0011q\u0014\u0002\u001f!\u0006\u0014H/\u001b;j_:lu\u000eZ5gS\u000e\fG/[8og2K7\u000f^3oKJ\u001cb!a'v\u0003Cs\u0001c\u0001?\u0002$&\u0019\u0011QU?\u0003\u001f%S6\u000eR1uC2K7\u000f^3oKJD1\"!+\u0002\u001c\n\u0005\t\u0015!\u0003\u0002 \u0005)Ao\u001c9jG\"9!$a'\u0005\u0002\u00055F\u0003BAM\u0003_C\u0001\"!+\u0002,\u0002\u0007\u0011q\u0004\u0005\t\u0003g\u000bY\n\"\u0001\u00026\u0006\u0001\u0002.\u00198eY\u0016$\u0015\r^1DQ\u0006tw-\u001a\u000b\u0007\u0003+\t9,!/\t\u0011\u0005%\u0015\u0011\u0017a\u0001\u0003?Aq!a/\u00022\u0002\u0007Q/\u0001\u0003eCR\f\u0007FBAY\u0003\u0007\nY\u0006\u0003\u0005\u0002\u0004\u0006mE\u0011AAa)\u0011\t)\"a1\t\u0011\u0005u\u0011q\u0018a\u0001\u0003?Ac!a0\u0002D\u0005m\u0003\u0002CAe\u0001\u0001\u0006I!a&\u0002AA\f'\u000f^5uS>tWj\u001c3jM&\u001c\u0017\r^5p]Nd\u0015n\u001d;f]\u0016\u00148\u000f\t\u0005\n\u0003\u001b\u0004!\u0019!C\u0005\u0003\u001f\f\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s+\t\t\t\u000e\u0005\u0003\u0002T\u0006egb\u0001\f\u0002V&\u0019\u0011q\u001b\u0002\u0002\u001f-\u000bgm[1D_:$(o\u001c7mKJLA!a7\u0002^\n\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u000b\u0007\u0005]'\u0001\u0003\u0005\u0002b\u0002\u0001\u000b\u0011BAi\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\u000691\u000f^1siV\u0004HCAA\u000b\u0011\u001d\tY\u000f\u0001C\u0001\u0003O\f\u0011C]3hSN$XM\u001d'jgR,g.\u001a:t\u0011\u001d\ty\u000f\u0001C\u0001\u0003O\f1\u0003Z3sK\u001eL7\u000f^3s\u0019&\u001cH/\u001a8feNDq!a=\u0001\t\u0003\t9/\u0001\u0005tQV$Hm\\<o\u0011\u001d\t9\u0010\u0001C\u0001\u0003O\f\u0011\u0005\u001e:jO\u001e,'o\u00148mS:,\u0007+\u0019:uSRLwN\\*uCR,7\t[1oO\u0016Dq!a?\u0001\t\u0003\ti0A\tqCJ$\u0018\u000e^5p]NLen\u0015;bi\u0016$B!a@\u0003\bA)!\u0011\u0001B\u0002\u00036\tQ(C\u0002\u0003\u0006u\u00121aU3u\u0011\u001d\u0011I!!?A\u0002\u001d\u000bQa\u001d;bi\u0016DqA!\u0004\u0001\t\u0003\u0011y!\u0001\niC:$G.Z*uCR,7\t[1oO\u0016\u001cHCCA\u000b\u0005#\u0011)B!\u0007\u0003$!A!1\u0003B\u0006\u0001\u0004\ty0\u0001\u0006qCJ$\u0018\u000e^5p]NDqAa\u0006\u0003\f\u0001\u0007q)A\u0006uCJ<W\r^*uCR,\u0007B\u0003B\u000e\u0005\u0017\u0001\n\u00111\u0001\u0003\u001e\u0005qA.Z1eKJ\u001cV\r\\3di>\u0014\bc\u0001\f\u0003 %\u0019!\u0011\u0005\u0002\u0003/A\u000b'\u000f^5uS>tG*Z1eKJ\u001cV\r\\3di>\u0014\bB\u0003B\u0013\u0005\u0017\u0001\n\u00111\u0001\u0003(\u0005I1-\u00197mE\u0006\u001c7n\u001d\t\u0004-\t%\u0012b\u0001B\u0016\u0005\tI1)\u00197mE\u0006\u001c7n\u001d\u0005\b\u0005_\u0001A\u0011\u0002B\u0019\u0003EA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-\u001a\u000b\r\u0003+\u0011\u0019D!\u000e\u0003:\tm\"Q\b\u0005\t\u0003S\u0013i\u00031\u0001\u0002 !9!q\u0007B\u0017\u0001\u0004I\u0013!\u00039beRLG/[8o\u0011\u001d\u00119B!\fA\u0002\u001dC\u0001Ba\u0007\u0003.\u0001\u0007!Q\u0004\u0005\t\u0005K\u0011i\u00031\u0001\u0003(!9!\u0011\t\u0001\u0005\n\u0005\u001d\u0018\u0001G5oSRL\u0017\r\\5{KB\u000b'\u000f^5uS>t7\u000b^1uK\"9!Q\t\u0001\u0005\n\t\u001d\u0013!G1tg\u0016\u0014HOV1mS\u0012\u0004&/\u001a<j_V\u001c8\u000b^1uKN$\u0002\"!\u0006\u0003J\t5#q\u000b\u0005\b\u0005\u0017\u0012\u0019\u00051\u0001B\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\t\u0005\u001f\u0012\u0019\u00051\u0001\u0003R\u0005QaM]8n'R\fG/Z:\u0011\u000b\t\u0005!1K$\n\u0007\tUSHA\u0002TKFDqAa\u0006\u0003D\u0001\u0007q\tC\u0004\u0003\\\u0001!IA!\u0018\u0002E%t\u0017\u000e^5bY&TX\rT3bI\u0016\u0014\u0018I\u001c3JgJ4uN\u001d)beRLG/[8o)\u0011\t)Ba\u0018\t\u000f\t-#\u0011\fa\u0001\u0003\"9!1\r\u0001\u0005\u0002\t\u0015\u0014aF3mK\u000e$H*Z1eKJ4uN\u001d)beRLG/[8o)!\t)Ba\u001a\u0003j\t-\u0004\u0002CAU\u0005C\u0002\r!a\b\t\u000f\t]\"\u0011\ra\u0001S!A!1\u0004B1\u0001\u0004\u0011i\u0002C\u0004\u0003p\u0001!IA!\u001d\u00027I,w-[:uKJ$v\u000e]5d\u0007\"\fgnZ3MSN$XM\\3s)\t\u0011\u0019\b\u0005\u0004\u0002<\u0005u\"Q\u000f\t\u0004m\n]\u0014bAA\u0019o\"9!1\u0010\u0001\u0005\n\u0005\u001d\u0018!\b3fe\u0016<\u0017n\u001d;feR{\u0007/[2DQ\u0006tw-\u001a'jgR,g.\u001a:\t\u000f\t}\u0004\u0001\"\u0001\u0003\u0002\u0006y\"/Z4jgR,'\u000fU1si&$\u0018n\u001c8DQ\u0006tw-\u001a'jgR,g.\u001a:\u0015\t\u0005U!1\u0011\u0005\t\u0003S\u0013i\b1\u0001\u0002 !9!q\u0011\u0001\u0005\u0002\t%\u0015!\t3fe\u0016<\u0017n\u001d;feB\u000b'\u000f^5uS>t7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014H\u0003\u0002BF\u0005#\u0003R!\u0003BG\u00033K1Aa$\u000b\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011\u0016BC\u0001\u0004\ty\u0002C\u0004\u0003\u0016\u0002!IA!\u001d\u00027I,w-[:uKJ$U\r\\3uKR{\u0007/[2MSN$XM\\3s\u0011\u001d\u0011I\n\u0001C\u0005\u0003O\fQ\u0004Z3sK\u001eL7\u000f^3s\t\u0016dW\r^3U_BL7\rT5ti\u0016tWM\u001d\u0005\b\u0005;\u0003A\u0011\u0002BP\u0003\u0011:W\r\u001e'fC\u0012,'/S:s\u0003:$W\t]8dQ>\u0013H\u000b\u001b:po\u0016C8-\u001a9uS>tGC\u0002BQ\u0005O\u0013I\u000bE\u0002\u0017\u0005GK1A!*\u0003\u0005maU-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"A\u0011\u0011\u0016BN\u0001\u0004\ty\u0002C\u0004\u00038\tm\u0005\u0019A\u0015\t\u0013\t5\u0006!%A\u0005\u0002\t=\u0016\u0001\b5b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$C-\u001a4bk2$HeM\u000b\u0003\u0005cSCA!\b\u00034.\u0012!Q\u0017\t\u0005\u0005o\u0013\t-\u0004\u0002\u0003:*!!1\u0018B_\u0003%)hn\u00195fG.,GMC\u0002\u0003@*\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019M!/\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003H\u0002\t\n\u0011\"\u0001\u0003J\u0006a\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3tI\u0011,g-Y;mi\u0012\"TC\u0001BfU\u0011\u00119Ca-")
public class PartitionStateMachine
implements Logging {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkUtils kafka$controller$PartitionStateMachine$$zkUtils;
    private final Map<TopicAndPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final TopicChangeListener topicChangeListener;
    private final DeleteTopicsListener deleteTopicsListener;
    private final Map<String, PartitionModificationsListener> partitionModificationsListeners;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public ZkUtils kafka$controller$PartitionStateMachine$$zkUtils() {
        return this.kafka$controller$PartitionStateMachine$$zkUtils;
    }

    private Map<TopicAndPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted() {
        return this.kafka$controller$PartitionStateMachine$$hasStarted;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private TopicChangeListener topicChangeListener() {
        return this.topicChangeListener;
    }

    private DeleteTopicsListener deleteTopicsListener() {
        return this.deleteTopicsListener;
    }

    private Map<String, PartitionModificationsListener> partitionModificationsListeners() {
        return this.partitionModificationsListeners;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializePartitionState();
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(true);
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started partition state machine with initial state -> " + this.partitionState().toString());
    }

    public void registerListeners() {
        block0: {
            this.registerTopicChangeListener();
            if (!Predef$.MODULE$.Boolean2boolean(this.kafka$controller$PartitionStateMachine$$controller.config().deleteTopicEnable())) break block0;
            this.registerDeleteTopicListener();
        }
    }

    public void deregisterListeners() {
        block0: {
            this.deregisterTopicChangeListener();
            this.partitionModificationsListeners().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PartitionStateMachine.$anonfun$deregisterListeners$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            this.partitionModificationsListeners().clear();
            if (!Predef$.MODULE$.Boolean2boolean(this.kafka$controller$PartitionStateMachine$$controller.config().deleteTopicEnable())) break block0;
            this.deregisterDeleteTopicListener();
        }
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(false);
        this.partitionState().clear();
        this.deregisterListeners();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped partition state machine");
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.partitionState().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$2(this, x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$3(this, x$2);
                return BoxedUnit.UNIT;
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch());
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while moving some partitions to the online state", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.partitionState().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$partitionsInState$1(state, p)))).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState, partitions.mkString(",")})));
        try {
            this.brokerRequestBatch().newBatch();
            partitions.foreach((Function1 & Serializable & scala.Serializable)topicAndPartition -> {
                this.handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), targetState, leaderSelector, callbacks);
                return BoxedUnit.UNIT;
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch());
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while moving some partitions to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private void handleStateChange(String topic, int partition, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        block13: {
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
            if (!this.kafka$controller$PartitionStateMachine$$hasStarted().get()) {
                throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s to %s failed because the partition state machine has not started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, targetState})));
            }
            PartitionState currState = (PartitionState)this.partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0 & Serializable & scala.Serializable)() -> NonExistentPartition$.MODULE$);
            try {
                PartitionState partitionState = targetState;
                if (NewPartition$.MODULE$.equals(partitionState)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentPartition$[]{NonExistentPartition$.MODULE$})), NewPartition$.MODULE$);
                    this.partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                    String assignedReplicas = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s with assigned replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState, assignedReplicas})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block13;
                }
                if (OnlinePartition$.MODULE$.equals(partitionState)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OnlinePartition$.MODULE$);
                    PartitionState partitionState2 = (PartitionState)this.partitionState().apply((Object)topicAndPartition);
                    if (NewPartition$.MODULE$.equals(partitionState2)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OfflinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OnlinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                    int leader = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to %s with leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState, BoxesRunTime.boxToInteger((int)leader)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block13;
                }
                if (OfflinePartition$.MODULE$.equals(partitionState)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OfflinePartition$.MODULE$);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState})));
                    this.partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block13;
                }
                if (NonExistentPartition$.MODULE$.equals(partitionState)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflinePartition$[]{OfflinePartition$.MODULE$})), NonExistentPartition$.MODULE$);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState})));
                    this.partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block13;
                }
                throw new MatchError((Object)partitionState);
            }
            catch (Throwable t) {
                this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$initializePartitionState$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            Option option;
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
            Option option2 = this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicPartition);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
                option = this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)currentLeaderIsrAndEpoch.leaderAndIsr().leader())) ? this.partitionState().put((Object)topicPartition, (Object)OnlinePartition$.MODULE$) : this.partitionState().put((Object)topicPartition, (Object)OfflinePartition$.MODULE$);
                return option;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                option = this.partitionState().put((Object)topicPartition, (Object)NewPartition$.MODULE$);
            }
            return option;
        });
    }

    private void assertValidPreviousStates(TopicAndPartition topicAndPartition, Seq<PartitionState> fromStates, PartitionState targetState) {
        if (!fromStates.contains(this.partitionState().apply((Object)topicAndPartition))) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, fromStates.mkString(","), targetState})) + new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionState().apply((Object)topicAndPartition)})));
        }
    }

    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        Seq replicaAssignment = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
        Seq liveAssignedReplicas = (Seq)replicaAssignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)r -> this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)r)));
        int n = liveAssignedReplicas.size();
        switch (n) {
            case 0: {
                String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error during state change of partition %s from New to Online, assigned replicas are [%s], live brokers are [%s]. No assigned replica is alive.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, replicaAssignment.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}));
                this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$PartitionStateMachine$$controller.epoch())})) + failMsg);
                throw new StateChangeFailedException(failMsg);
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Live assigned replicas for partition %s are: [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, liveAssignedReplicas})));
        int leader = BoxesRunTime.unboxToInt((Object)liveAssignedReplicas.head());
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, (List<Object>)liveAssignedReplicas.toList()), this.kafka$controller$PartitionStateMachine$$controller.epoch());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Initializing leader and isr for partition %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndControllerEpoch})));
        try {
            this.kafka$controller$PartitionStateMachine$$zkUtils().createPersistentPath(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), this.kafka$controller$PartitionStateMachine$$zkUtils().leaderAndIsrZkData(leaderIsrAndControllerEpoch.leaderAndIsr(), this.kafka$controller$PartitionStateMachine$$controller.epoch()), this.kafka$controller$PartitionStateMachine$$zkUtils().createPersistentPath$default$3());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)liveAssignedReplicas, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (ZkNodeExistsException e) {
            LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkUtils(), topicAndPartition.topic(), topicAndPartition.partition()).get();
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error while changing partition %s's state from New to Online since LeaderAndIsr path already exists with value %s and controller epoch %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndEpoch.leaderAndIsr().toString(), BoxesRunTime.boxToInteger((int)leaderIsrAndEpoch.controllerEpoch())}));
            this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$PartitionStateMachine$$controller.epoch())})) + failMsg);
            throw new StateChangeFailedException(failMsg);
        }
    }

    public void electLeaderForPartition(String topic, int partition, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
        try {
            boolean zookeeperPathUpdateSucceeded = false;
            ObjectRef newLeaderAndIsr = ObjectRef.create(null);
            Seq replicasForThisPartition = (Seq)Seq$.MODULE$.empty();
            while (!zookeeperPathUpdateSucceeded) {
                LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition);
                LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                if (controllerEpoch > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                    String failMsg = new StringOps(Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)controllerEpoch)}));
                    this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$PartitionStateMachine$$controller.epoch())})) + failMsg);
                    throw new StateChangeFailedException(failMsg);
                }
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2 = leaderSelector.selectLeader(topicAndPartition, currentLeaderAndIsr);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._1();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)leaderAndIsr, (Object)replicas);
                Tuple2 tuple23 = tuple22;
                LeaderAndIsr leaderAndIsr2 = (LeaderAndIsr)tuple23._1();
                Seq replicas2 = (Seq)tuple23._2();
                Tuple2<Object, Object> tuple24 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.kafka$controller$PartitionStateMachine$$zkUtils(), topic, partition, leaderAndIsr2, this.kafka$controller$PartitionStateMachine$$controller.epoch(), currentLeaderAndIsr.zkVersion());
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                boolean updateSucceeded = tuple24._1$mcZ$sp();
                int newVersion = tuple24._2$mcI$sp();
                Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
                Tuple2.mcZI.sp sp3 = sp2;
                boolean updateSucceeded2 = sp3._1$mcZ$sp();
                int newVersion2 = sp3._2$mcI$sp();
                newLeaderAndIsr.elem = leaderAndIsr2;
                ((LeaderAndIsr)newLeaderAndIsr.elem).zkVersion_$eq(newVersion2);
                zookeeperPathUpdateSucceeded = updateSucceeded2;
                replicasForThisPartition = replicas2;
            }
            LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)newLeaderAndIsr.elem, this.kafka$controller$PartitionStateMachine$$controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(topic, partition), (Object)newLeaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$PartitionStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)((LeaderAndIsr)newLeaderAndIsr$1.elem).leader()), topicAndPartition})));
            Seq replicas = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(topic, partition));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)replicasForThisPartition, topic, partition, newLeaderIsrAndControllerEpoch, (Seq<Object>)replicas, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (LeaderElectionNotNeededException lenne) {
        }
        catch (NoReplicaOnlineException nroe) {
            throw nroe;
        }
        catch (Throwable sce) {
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, sce.getMessage()}));
            this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$PartitionStateMachine$$controller.epoch())})) + failMsg);
            throw new StateChangeFailedException(failMsg, sce);
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("After leader election, leader cache is updated to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().map((Function1 & Serializable & scala.Serializable)l -> new Tuple2(l._1(), l._2()), Map$.MODULE$.canBuildFrom())})));
    }

    private java.util.List<String> registerTopicChangeListener() {
        return this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)this.topicChangeListener());
    }

    private void deregisterTopicChangeListener() {
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)this.topicChangeListener());
    }

    public void registerPartitionChangeListener(String topic) {
        this.partitionModificationsListeners().put((Object)topic, (Object)new PartitionModificationsListener(this, topic));
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().subscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.partitionModificationsListeners().apply((Object)topic));
    }

    public Option<PartitionModificationsListener> deregisterPartitionChangeListener(String topic) {
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.partitionModificationsListeners().apply((Object)topic));
        return this.partitionModificationsListeners().remove((Object)topic);
    }

    private java.util.List<String> registerDeleteTopicListener() {
        return this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().subscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), (IZkChildListener)this.deleteTopicsListener());
    }

    private void deregisterDeleteTopicListener() {
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), (IZkChildListener)this.deleteTopicsListener());
    }

    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition) {
        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        Option<LeaderIsrAndControllerEpoch> option = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkUtils(), topic, partition);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                String failMsg = new StringOps(Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, this.partitionState().apply((Object)topicAndPartition)}));
                throw new StateChangeFailedException(failMsg);
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
        return leaderIsrAndControllerEpoch;
    }

    public static final /* synthetic */ void $anonfun$deregisterListeners$1(PartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String topic = (String)tuple2._1();
        PartitionModificationsListener listener = (PartitionModificationsListener)tuple2._2();
        $this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)listener);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$2(PartitionStateMachine $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
        boolean bl = !$this.kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().isTopicQueuedUpForDeletion(topicAndPartition.topic());
        return bl;
    }

    public static final /* synthetic */ void $anonfun$triggerOnlinePartitionStateChange$3(PartitionStateMachine $this, Tuple2 x$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
            PartitionState partitionState = (PartitionState)tuple2._2();
            if (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$)) {
                $this.handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), OnlinePartition$.MODULE$, $this.kafka$controller$PartitionStateMachine$$controller.offlinePartitionSelector(), new Callbacks.CallbackBuilder().build());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$partitionsInState$1(PartitionState state$1, Tuple2 p) {
        Object object = p._2();
        PartitionState partitionState = state$1;
        return !(object != null ? !object.equals(partitionState) : partitionState != null);
    }

    public static final /* synthetic */ boolean $anonfun$initializePartitionState$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public PartitionStateMachine(KafkaController controller) {
        this.kafka$controller$PartitionStateMachine$$controller = controller;
        Logging.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.kafka$controller$PartitionStateMachine$$zkUtils = this.kafka$controller$PartitionStateMachine$$controllerContext().zkUtils();
        this.partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$PartitionStateMachine$$hasStarted = new AtomicBoolean(false);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.topicChangeListener = new TopicChangeListener();
        this.deleteTopicsListener = new DeleteTopicsListener();
        this.partitionModificationsListeners = Map$.MODULE$.empty();
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.logIdent_$eq("[Partition state machine on Controller " + this.controllerId() + "]: ");
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class DeleteTopicsListener
    implements IZkChildListener,
    Logging {
        private final ZkUtils zkUtils;
        private final String loggerName;
        private Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging.trace$(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging.swallowTrace$(this, action);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging.debug$(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging.swallowDebug$(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging.info$(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging.swallowInfo$(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging.warn$(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging.swallowWarn$(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging.swallow$(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging.error$(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging.swallowError$(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging.fatal$(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            DeleteTopicsListener deleteTopicsListener = this;
            synchronized (deleteTopicsListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        public ZkUtils zkUtils() {
            return this.zkUtils;
        }

        public void handleChildChange(String parentPath, java.util.List<String> children) throws Exception {
            CoreUtils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                block1: {
                    ObjectRef topicsToBeDeleted = ObjectRef.create((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(children).toSet());
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Delete topics listener fired for topics %s to be deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((scala.collection.immutable.Set)topicsToBeDeleted$1.elem).mkString(",")})));
                    scala.collection.immutable.Set nonExistentTopics = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted.elem).$minus$minus(this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics());
                    if (nonExistentTopics.nonEmpty()) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring request to delete non-existing topics " + nonExistentTopics.mkString(","));
                        nonExistentTopics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                            DeleteTopicsListener.$anonfun$handleChildChange$10(this, topic);
                            return BoxedUnit.UNIT;
                        });
                    }
                    topicsToBeDeleted.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted.elem).$minus$minus((GenTraversableOnce)nonExistentTopics);
                    if (!((scala.collection.immutable.Set)topicsToBeDeleted.elem).nonEmpty()) break block1;
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting topic deletion for topics " + ((scala.collection.immutable.Set)topicsToBeDeleted$1.elem).mkString(","));
                    ((scala.collection.immutable.Set)topicsToBeDeleted.elem).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                        DeleteTopicsListener.$anonfun$handleChildChange$12(this, topic);
                        return BoxedUnit.UNIT;
                    });
                    $this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().enqueueTopicsForDeletion((Set<String>)((scala.collection.immutable.Set)topicsToBeDeleted.elem));
                }
            });
        }

        public void handleDataDeleted(String dataPath) throws Exception {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer() {
            return PartitionStateMachine.this;
        }

        public static final /* synthetic */ void $anonfun$handleChildChange$10(DeleteTopicsListener $this, String topic) {
            $this.zkUtils().deletePathRecursive(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        }

        public static final /* synthetic */ void $anonfun$handleChildChange$12(DeleteTopicsListener $this, String topic) {
            block0: {
                boolean preferredReplicaElectionInProgress = ((SetLike)$this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsUndergoingPreferredReplicaElection().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.topic(), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                boolean partitionReassignmentInProgress = ((SetLike)$this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsBeingReassigned().keySet().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.topic(), Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                if (!preferredReplicaElectionInProgress && !partitionReassignmentInProgress) break block0;
                $this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
            }
        }

        public DeleteTopicsListener() {
            if (PartitionStateMachine.this == null) {
                throw null;
            }
            Logging.$init$(this);
            this.logIdent_$eq("[DeleteTopicsListener on " + PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId() + "]: ");
            this.zkUtils = PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controllerContext().zkUtils();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class PartitionModificationsListener
    implements IZkDataListener,
    Logging {
        private final String topic;
        private final String loggerName;
        private Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;
        public final /* synthetic */ PartitionStateMachine $outer;

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging.trace$(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging.swallowTrace$(this, action);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging.debug$(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging.swallowDebug$(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging.info$(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging.swallowInfo$(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging.warn$(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging.swallowWarn$(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging.swallow$(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging.error$(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging.swallowError$(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging.fatal$(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            PartitionModificationsListener partitionModificationsListener = this;
            synchronized (partitionModificationsListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        public void handleDataChange(String dataPath, Object data) throws Exception {
            CoreUtils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                try {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition modification triggered ", " for path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{data, dataPath})));
                    Map<TopicAndPartition, Seq<Object>> partitionReplicaAssignment = this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$zkUtils().getReplicaAssignmentForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.topic})));
                    Map partitionsToBeAdded = (Map)partitionReplicaAssignment.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PartitionModificationsListener.$anonfun$handleDataChange$3(this, p)));
                    if ($this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().isTopicQueuedUpForDeletion($this.topic)) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Skipping adding partitions %s for topic %s since it is currently being deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)partitionsToBeAdded.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)PartitionModificationsListener.$anonfun$handleDataChange$5(x$8)), Iterable$.MODULE$.canBuildFrom())).mkString(","), $this.topic})));
                    } else if (partitionsToBeAdded.nonEmpty()) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("New partitions to be added %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsToBeAdded})));
                        this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq((TraversableOnce)partitionsToBeAdded);
                        $this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewPartitionCreation((Set<TopicAndPartition>)partitionsToBeAdded.keySet().toSet());
                    }
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while handling add partitions for data path " + dataPath, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            });
        }

        public void handleDataDeleted(String parentPath) throws Exception {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$handleDataChange$3(PartitionModificationsListener $this, Tuple2 p) {
            return !$this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().contains(p._1());
        }

        public static final /* synthetic */ int $anonfun$handleDataChange$5(Tuple2 x$8) {
            return ((TopicAndPartition)x$8._1()).partition();
        }

        public PartitionModificationsListener(PartitionStateMachine $outer, String topic) {
            this.topic = topic;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Logging.$init$(this);
            this.logIdent_$eq("[AddPartitionsListener on " + $outer.kafka$controller$PartitionStateMachine$$controller.config().brokerId() + "]: ");
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class TopicChangeListener
    implements IZkChildListener,
    Logging {
        private final String loggerName;
        private Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging.trace$(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging.swallowTrace$(this, action);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging.debug$(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging.swallowDebug$(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging.info$(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging.swallowInfo$(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging.warn$(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging.swallowWarn$(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging.swallow$(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging.error$(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging.swallowError$(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging.fatal$(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            TopicChangeListener topicChangeListener = this;
            synchronized (topicChangeListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        public void handleChildChange(String parentPath, java.util.List<String> children) throws Exception {
            CoreUtils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                block3: {
                    if (!this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$hasStarted().get()) break block3;
                    try {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Topic change listener fired for path %s with children %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentPath, JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(children).mkString(",")})));
                        scala.collection.immutable.Set currentChildren = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(children).toSet();
                        scala.collection.immutable.Set newTopics = (scala.collection.immutable.Set)currentChildren.$minus$minus(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics());
                        Set deletedTopics = (Set)this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().$minus$minus((GenTraversableOnce)currentChildren);
                        this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics_$eq((Set<String>)currentChildren);
                        Map<TopicAndPartition, Seq<Object>> addedPartitionReplicaAssignment = this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$zkUtils().getReplicaAssignmentForTopics((Seq<String>)newTopics.toSeq());
                        this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment_$eq((Map<TopicAndPartition, Seq<Object>>)((Map)this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicChangeListener.$anonfun$handleChildChange$3(deletedTopics, p)))));
                        this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq(addedPartitionReplicaAssignment);
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("New topics: [%s], deleted topics: [%s], new partition replica assignment [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newTopics, deletedTopics, addedPartitionReplicaAssignment})));
                        if (newTopics.nonEmpty()) {
                            $this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewTopicCreation((Set<String>)newTopics, (Set<TopicAndPartition>)addedPartitionReplicaAssignment.keySet().toSet());
                        }
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while handling new topic", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                }
            });
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer() {
            return PartitionStateMachine.this;
        }

        public static final /* synthetic */ boolean $anonfun$handleChildChange$3(Set deletedTopics$1, Tuple2 p) {
            return !deletedTopics$1.contains((Object)((TopicAndPartition)p._1()).topic());
        }

        public TopicChangeListener() {
            if (PartitionStateMachine.this == null) {
                throw null;
            }
            Logging.$init$(this);
            this.logIdent_$eq("[TopicChangeListener on Controller " + PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId() + "]: ");
        }
    }
}

