/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerStats$;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u0001\u0003\u0001\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0004\u0001\t\u0005\t\u0015!\u0003\u0016!\t1r#D\u0001\u0003\u0013\tA\"AA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\u0011A$\b\t\u0003-\u0001AQaA\rA\u0002UAqa\b\u0001C\u0002\u0013%\u0001%A\td_:$(o\u001c7mKJ\u001cuN\u001c;fqR,\u0012!\t\t\u0003-\tJ!a\t\u0002\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0003\u0004&\u0001\u0001\u0006I!I\u0001\u0013G>tGO]8mY\u0016\u00148i\u001c8uKb$\b\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0003%\u0002\"!\u0003\u0016\n\u0005-R!aA%oi\"1Q\u0006\u0001Q\u0001\n%\nQbY8oiJ|G\u000e\\3s\u0013\u0012\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\bu.,F/\u001b7t+\u0005\t\u0004CA\b3\u0013\t\u0019\u0004CA\u0004[WV#\u0018\u000e\\:\t\rU\u0002\u0001\u0015!\u00032\u0003!Q8.\u0016;jYN\u0004\u0003bB\u001c\u0001\u0005\u0004%I\u0001O\u0001\re\u0016\u0004H.[2b'R\fG/Z\u000b\u0002sA!!hP!E\u001b\u0005Y$B\u0001\u001f>\u0003\u001diW\u000f^1cY\u0016T!A\u0010\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002Aw\t\u0019Q*\u00199\u0011\u0005Y\u0011\u0015BA\"\u0003\u0005M\u0001\u0016M\u001d;ji&|g.\u00118e%\u0016\u0004H.[2b!\t1R)\u0003\u0002G\u0005\ta!+\u001a9mS\u000e\f7\u000b^1uK\"1\u0001\n\u0001Q\u0001\ne\nQB]3qY&\u001c\u0017m\u0015;bi\u0016\u0004\u0003b\u0002&\u0001\u0005\u0004%IaS\u0001\u0015EJ|7.\u001a:DQ\u0006tw-\u001a'jgR,g.\u001a:\u0016\u00031\u0003\"!\u0014(\u000e\u0003\u00011Aa\u0014\u0001\u0001!\n!\"I]8lKJ\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u001cBAT)Z\u001dA\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0005Y\u0006twMC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&AB(cU\u0016\u001cG\u000f\u0005\u0002[C6\t1L\u0003\u0002];\u0006A!p[2mS\u0016tGO\u0003\u0002_?\u00061\u0011\nM%uK\u000eT\u0011\u0001Y\u0001\u0004_J<\u0017B\u00012\\\u0005AI%l[\"iS2$G*[:uK:,'\u000fC\u0003\u001b\u001d\u0012\u0005A\rF\u0001M\u0011\u00151g\n\"\u0001h\u0003EA\u0017M\u001c3mK\u000eC\u0017\u000e\u001c3DQ\u0006tw-\u001a\u000b\u0004Q.D\bCA\u0005j\u0013\tQ'B\u0001\u0003V]&$\b\"\u00027f\u0001\u0004i\u0017A\u00039be\u0016tG\u000fU1uQB\u0011a.\u001e\b\u0003_N\u0004\"\u0001\u001d\u0006\u000e\u0003ET!A\u001d\u0004\u0002\rq\u0012xn\u001c;?\u0013\t!(\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003m^\u0014aa\u0015;sS:<'B\u0001;\u000b\u0011\u0015IX\r1\u0001{\u0003E\u0019WO\u001d:f]R\u0014%o\\6fe2K7\u000f\u001e\t\u0004wzlW\"\u0001?\u000b\u0005u,\u0016\u0001B;uS2L!a ?\u0003\t1K7\u000f\u001e\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003M\u0003U\u0011'o\\6fe\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8fe\u0002B\u0011\"a\u0002\u0001\u0005\u0004%I!!\u0003\u0002%\t\u0014xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u000b\u0003\u0003\u0017\u00012AFA\u0007\u0013\r\tyA\u0001\u0002\u001d\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i\u0011!\t\u0019\u0002\u0001Q\u0001\n\u0005-\u0011a\u00052s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\u0003\"CA\f\u0001\t\u0007I\u0011BA\r\u0003)A\u0017m]*uCJ$X\rZ\u000b\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0004bi>l\u0017n\u0019\u0006\u0004\u0003Ka\u0018AC2p]\u000e,(O]3oi&!\u0011\u0011FA\u0010\u00055\tEo\\7jG\n{w\u000e\\3b]\"A\u0011Q\u0006\u0001!\u0002\u0013\tY\"A\u0006iCN\u001cF/\u0019:uK\u0012\u0004\u0003\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0003\u0003k\u0001B!a\u000e\u0002>9\u0019a#!\u000f\n\u0007\u0005m\"!A\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0013\u0011\ty$!\u0011\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'OC\u0002\u0002<\tA\u0001\"!\u0012\u0001A\u0003%\u0011QG\u0001\u0013gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\b\u0005C\u0004\u0002J\u0001!\t!a\u0013\u0002\u000fM$\u0018M\u001d;vaR\t\u0001\u000eC\u0004\u0002P\u0001!\t!a\u0013\u0002#I,w-[:uKJd\u0015n\u001d;f]\u0016\u00148\u000fC\u0004\u0002T\u0001!\t!a\u0013\u0002'\u0011,'/Z4jgR,'\u000fT5ti\u0016tWM]:\t\u000f\u0005]\u0003\u0001\"\u0001\u0002L\u0005A1\u000f[;uI><h\u000eC\u0004\u0002\\\u0001!\t!!\u0018\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\bQ\u0006}\u00131NA8\u0011!\t\t'!\u0017A\u0002\u0005\r\u0014\u0001\u0003:fa2L7-Y:\u0011\u000b\u0005\u0015\u0014qM!\u000e\u0003uJ1!!\u001b>\u0005\r\u0019V\r\u001e\u0005\b\u0003[\nI\u00061\u0001E\u0003-!\u0018M]4fiN#\u0018\r^3\t\u0015\u0005E\u0014\u0011\fI\u0001\u0002\u0004\t\u0019(A\u0005dC2d'-Y2lgB\u0019a#!\u001e\n\u0007\u0005]$AA\u0005DC2d'-Y2lg\"9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014!\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKR9\u0001.a \u0002\u0004\u0006\u0015\u0005bBAA\u0003s\u0002\r!Q\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\u0005\b\u0003[\nI\b1\u0001E\u0011!\t\t(!\u001fA\u0002\u0005M\u0004bBAE\u0001\u0011\u0005\u00111R\u0001\u001eCJ,\u0017\t\u001c7SKBd\u0017nY1t\r>\u0014Hk\u001c9jG\u0012+G.\u001a;fIR!\u0011QRAJ!\rI\u0011qR\u0005\u0004\u0003#S!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003+\u000b9\t1\u0001n\u0003\u0015!x\u000e]5d\u0011\u001d\tI\n\u0001C\u0001\u00037\u000b\u0011&[:Bi2+\u0017m\u001d;P]\u0016\u0014V\r\u001d7jG\u0006Le\u000eR3mKRLwN\\*uCJ$X\rZ*uCR,G\u0003BAG\u0003;Cq!!&\u0002\u0018\u0002\u0007Q\u000eC\u0004\u0002\"\u0002!\t!a)\u0002\u001fI,\u0007\u000f\\5dCNLen\u0015;bi\u0016$b!a\u0019\u0002&\u0006\u001d\u0006bBAK\u0003?\u0003\r!\u001c\u0005\b\u0003S\u000by\n1\u0001E\u0003\u0015\u0019H/\u0019;f\u0011\u001d\ti\u000b\u0001C\u0001\u0003_\u000b1#[:B]f\u0014V\r\u001d7jG\u0006Len\u0015;bi\u0016$b!!$\u00022\u0006M\u0006bBAK\u0003W\u0003\r!\u001c\u0005\b\u0003S\u000bY\u000b1\u0001E\u0011\u001d\t9\f\u0001C\u0001\u0003s\u000b\u0001D]3qY&\u001c\u0017m]%o\t\u0016dW\r^5p]N#\u0018\r^3t)\u0011\t\u0019'a/\t\u000f\u0005U\u0015Q\u0017a\u0001[\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0017!G1tg\u0016\u0014HOV1mS\u0012\u0004&/\u001a<j_V\u001c8\u000b^1uKN$r\u0001[Ab\u0003\u000b\fy\rC\u0004\u0002\u0002\u0006u\u0006\u0019A!\t\u0011\u0005\u001d\u0017Q\u0018a\u0001\u0003\u0013\f!B\u001a:p[N#\u0018\r^3t!\u0015\t)'a3E\u0013\r\ti-\u0010\u0002\u0004'\u0016\f\bbBA7\u0003{\u0003\r\u0001\u0012\u0005\b\u0003'\u0004A\u0011BAk\u0003q\u0011XmZ5ti\u0016\u0014(I]8lKJ\u001c\u0005.\u00198hK2K7\u000f^3oKJ$\"!a6\u0011\tmt\u0018\u0011\u001c\t\u0004%\u0006m\u0017B\u0001<T\u0011\u001d\ty\u000e\u0001C\u0005\u0003\u0017\na\u0004Z3sK\u001eL7\u000f^3s\u0005J|7.\u001a:DQ\u0006tw-\u001a'jgR,g.\u001a:\t\u000f\u0005\r\b\u0001\"\u0003\u0002L\u00051\u0012N\\5uS\u0006d\u0017N_3SKBd\u0017nY1Ti\u0006$X\rC\u0004\u0002h\u0002!\t!!;\u00025A\f'\u000f^5uS>t7/Q:tS\u001etW\r\u001a+p\u0005J|7.\u001a:\u0015\r\u0005-\u0018\u0011`A\u0000!\u0019\t)'a3\u0002nB!\u0011q^A{\u001b\t\t\tPC\u0002\u0002t\u0012\taaY8n[>t\u0017\u0002BA|\u0003c\u0014\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011!\tY0!:A\u0002\u0005u\u0018A\u0002;pa&\u001c7\u000fE\u0003\u0002f\u0005-W\u000eC\u0004\u0003\u0002\u0005\u0015\b\u0019A\u0015\u0002\u0011\t\u0014xn[3s\u0013\u0012D\u0011B!\u0002\u0001#\u0003%\tAa\u0002\u00029!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0002\u0016\u0005\u0003g\u0012Ya\u000b\u0002\u0003\u000eA!!q\u0002B\r\u001b\t\u0011\tB\u0003\u0003\u0003\u0014\tU\u0011!C;oG\",7m[3e\u0015\r\u00119BC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u000e\u0005#\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ReplicaStateMachine
implements Logging {
    public final KafkaController kafka$controller$ReplicaStateMachine$$controller;
    private final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkUtils kafka$controller$ReplicaStateMachine$$zkUtils;
    private final Map<PartitionAndReplica, ReplicaState> replicaState;
    private final BrokerChangeListener brokerChangeListener;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext() {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public ZkUtils kafka$controller$ReplicaStateMachine$$zkUtils() {
        return this.kafka$controller$ReplicaStateMachine$$zkUtils;
    }

    private Map<PartitionAndReplica, ReplicaState> replicaState() {
        return this.replicaState;
    }

    private BrokerChangeListener brokerChangeListener() {
        return this.brokerChangeListener;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted() {
        return this.kafka$controller$ReplicaStateMachine$$hasStarted;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializeReplicaState();
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(true);
        this.handleStateChanges(this.kafka$controller$ReplicaStateMachine$$controllerContext().allLiveReplicas(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started replica state machine with initial state -> " + this.replicaState().toString());
    }

    public void registerListeners() {
        this.registerBrokerChangeListener();
    }

    public void deregisterListeners() {
        this.deregisterBrokerChangeListener();
    }

    public void shutdown() {
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(false);
        this.replicaState().clear();
        this.deregisterListeners();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped replica state machine");
    }

    public void handleStateChanges(Set<PartitionAndReplica> replicas, ReplicaState targetState, Callbacks callbacks) {
        block2: {
            if (!replicas.nonEmpty()) break block2;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState, replicas.mkString(",")})));
            try {
                this.brokerRequestBatch().newBatch();
                replicas.foreach((Function1 & Serializable & scala.Serializable)r -> {
                    this.handleStateChange(r, targetState, callbacks);
                    return BoxedUnit.UNIT;
                });
                this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$ReplicaStateMachine$$controller.epoch());
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while moving some replicas to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
    }

    public void handleStateChange(PartitionAndReplica partitionAndReplica, ReplicaState targetState, Callbacks callbacks) {
        block31: {
            String topic = partitionAndReplica.topic();
            int partition = partitionAndReplica.partition();
            int replicaId = partitionAndReplica.replica();
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
            if (!this.kafka$controller$ReplicaStateMachine$$hasStarted().get()) {
                throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition %s to %s failed because replica state machine has not started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, targetState})));
            }
            ReplicaState currState = (ReplicaState)this.replicaState().getOrElseUpdate((Object)partitionAndReplica, (Function0 & Serializable & scala.Serializable)() -> NonExistentReplica$.MODULE$);
            try {
                Seq replicaAssignment = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                ReplicaState replicaState = targetState;
                if (NewReplica$.MODULE$.equals(replicaState)) {
                    Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt;
                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentReplica$[]{NonExistentReplica$.MODULE$})), targetState);
                    Option<LeaderIsrAndControllerEpoch> option = leaderIsrAndControllerEpochOpt = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$ReplicaStateMachine$$zkUtils(), topic, partition);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                        if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId) {
                            throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s cannot be moved to NewReplica")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition})) + "state as it is being requested to become leader");
                        }
                        this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option);
                    }
                    this.replicaState().put((Object)partitionAndReplica, (Object)NewReplica$.MODULE$);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block31;
                }
                if (ReplicaDeletionStarted$.MODULE$.equals(replicaState)) {
                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflineReplica$[]{OfflineReplica$.MODULE$})), targetState);
                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionStarted$.MODULE$);
                    this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, true, callbacks.stopReplicaResponseCallback());
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block31;
                }
                if (ReplicaDeletionIneligible$.MODULE$.equals(replicaState)) {
                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionStarted$[]{ReplicaDeletionStarted$.MODULE$})), targetState);
                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block31;
                }
                if (ReplicaDeletionSuccessful$.MODULE$.equals(replicaState)) {
                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionStarted$[]{ReplicaDeletionStarted$.MODULE$})), targetState);
                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionSuccessful$.MODULE$);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block31;
                }
                if (NonExistentReplica$.MODULE$.equals(replicaState)) {
                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionSuccessful$[]{ReplicaDeletionSuccessful$.MODULE$})), targetState);
                    Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                    this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 == replicaId));
                    this.replicaState().remove((Object)partitionAndReplica);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block31;
                }
                if (OnlineReplica$.MODULE$.equals(replicaState)) {
                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$, ReplicaDeletionIneligible$.MODULE$})), targetState);
                    ReplicaState replicaState2 = (ReplicaState)this.replicaState().apply((Object)partitionAndReplica);
                    if (NewReplica$.MODULE$.equals(replicaState2)) {
                        Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                        Object object = !currentAssignedReplicas.contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) ? this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId), Seq$.MODULE$.canBuildFrom())) : BoxedUnit.UNIT;
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Option option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                            this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                            this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block31;
                }
                if (OfflineReplica$.MODULE$.equals(replicaState)) {
                    boolean bl;
                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$, ReplicaDeletionIneligible$.MODULE$})), targetState);
                    this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, false, this.brokerRequestBatch().addStopReplicaRequestForBrokers$default$5());
                    Option option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                    if (option instanceof Some) {
                        boolean bl2;
                        Option<LeaderIsrAndControllerEpoch> option2 = this.kafka$controller$ReplicaStateMachine$$controller.removeReplicaFromIsr(topic, partition, replicaId);
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                            Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                            if (!this.kafka$controller$ReplicaStateMachine$$controller.deleteTopicManager().isPartitionToBeDeleted(topicAndPartition)) {
                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)currentAssignedReplicas.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 == replicaId)), topic, partition, updatedLeaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                            }
                            this.replicaState().put((Object)partitionAndReplica, (Object)OfflineReplica$.MODULE$);
                            this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                            bl2 = false;
                        } else if (None$.MODULE$.equals(option2)) {
                            bl2 = true;
                        } else {
                            throw new MatchError(option2);
                        }
                        bl = bl2;
                    } else if (None$.MODULE$.equals(option)) {
                        bl = true;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    boolean leaderAndIsrIsEmpty = bl;
                    if (leaderAndIsrIsEmpty && !this.kafka$controller$ReplicaStateMachine$$controller.deleteTopicManager().isPartitionToBeDeleted(topicAndPartition)) {
                        throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Failed to change state of replica %d for partition %s since the leader and isr path in zookeeper is empty")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition})));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block31;
                }
                throw new MatchError((Object)replicaState);
            }
            catch (Throwable t) {
                this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition [%s,%d] from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topic, BoxesRunTime.boxToInteger((int)partition), currState, targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
    }

    public Callbacks handleStateChanges$default$3() {
        return new Callbacks.CallbackBuilder().build();
    }

    public boolean areAllReplicasForTopicDeleted(String topic) {
        Set<PartitionAndReplica> replicasForTopic = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r, this.replicaState().apply(r)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Are all replicas for topic %s deleted %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, replicaStatesForTopic})));
        return replicaStatesForTopic.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$areAllReplicasForTopicDeleted$3(x$3)));
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        Set<PartitionAndReplica> replicasForTopic = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r, this.replicaState().apply(r)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable & scala.Serializable)(deletionState, r) -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$isAtLeastOneReplicaInDeletionStartedState$2(BoxesRunTime.unboxToBoolean((Object)deletionState), r))));
    }

    public Set<PartitionAndReplica> replicasInState(String topic, ReplicaState state) {
        return ((MapLike)this.replicaState().filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$replicasInState$1(topic, state, r)))).keySet();
    }

    public boolean isAnyReplicaInState(String topic, ReplicaState state) {
        return this.replicaState().exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$isAnyReplicaInState$1(topic, state, r)));
    }

    public Set<PartitionAndReplica> replicasInDeletionStates(String topic) {
        Set deletionStates = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{ReplicaDeletionStarted$.MODULE$, ReplicaDeletionSuccessful$.MODULE$, ReplicaDeletionIneligible$.MODULE$}));
        return ((MapLike)this.replicaState().filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$replicasInDeletionStates$1(topic, deletionStates, r)))).keySet();
    }

    private void assertValidPreviousStates(PartitionAndReplica partitionAndReplica, Seq<ReplicaState> fromStates, ReplicaState targetState) {
        Predef$.MODULE$.assert(fromStates.contains(this.replicaState().apply((Object)partitionAndReplica)), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Replica %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionAndReplica, fromStates.mkString(","), targetState})) + new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicaState().apply((Object)partitionAndReplica)})));
    }

    private List<String> registerBrokerChangeListener() {
        return this.kafka$controller$ReplicaStateMachine$$zkUtils().zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerIdsPath(), (IZkChildListener)this.brokerChangeListener());
    }

    private void deregisterBrokerChangeListener() {
        this.kafka$controller$ReplicaStateMachine$$zkUtils().zkClient().unsubscribeChildChanges(ZkUtils$.MODULE$.BrokerIdsPath(), (IZkChildListener)this.brokerChangeListener());
    }

    private void initializeReplicaState() {
        this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$initializeReplicaState$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            ReplicaStateMachine.$anonfun$initializeReplicaState$2(this, x$4);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<TopicAndPartition> partitionsAssignedToBroker(Seq<String> topics, int brokerId) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$partitionsAssignedToBroker$1(brokerId, x$5)))).keySet().toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$areAllReplicasForTopicDeleted$3(Tuple2 x$3) {
        Object object = x$3._2();
        ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
        return !(object != null ? !object.equals(replicaDeletionSuccessful$) : replicaDeletionSuccessful$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isAtLeastOneReplicaInDeletionStartedState$2(boolean deletionState, Tuple2 r) {
        if (deletionState) return true;
        Object object = r._2();
        ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
        if (object != null) {
            if (!object.equals(replicaDeletionStarted$)) return false;
            return true;
        }
        if (replicaDeletionStarted$ == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$replicasInState$1(String topic$3, ReplicaState state$1, Tuple2 r) {
        if (!((PartitionAndReplica)r._1()).topic().equals(topic$3)) return false;
        Object object = r._2();
        ReplicaState replicaState = state$1;
        if (object != null) {
            if (!object.equals(replicaState)) return false;
            return true;
        }
        if (replicaState == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isAnyReplicaInState$1(String topic$4, ReplicaState state$2, Tuple2 r) {
        if (!((PartitionAndReplica)r._1()).topic().equals(topic$4)) return false;
        Object object = r._2();
        ReplicaState replicaState = state$2;
        if (object != null) {
            if (!object.equals(replicaState)) return false;
            return true;
        }
        if (replicaState == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$replicasInDeletionStates$1(String topic$5, Set deletionStates$1, Tuple2 r) {
        return ((PartitionAndReplica)r._1()).topic().equals(topic$5) && JavaConversions$.MODULE$.deprecated$u0020setAsJavaSet(deletionStates$1).contains(r._2());
    }

    public static final /* synthetic */ boolean $anonfun$initializeReplicaState$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Option $anonfun$initializeReplicaState$3(ReplicaStateMachine $this, String topic$6, int partition$2, int replicaId) {
        PartitionAndReplica partitionAndReplica = new PartitionAndReplica(topic$6, partition$2, replicaId);
        return $this.kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) ? $this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$) : $this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$initializeReplicaState$2(ReplicaStateMachine $this, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
        Seq assignedReplicas = (Seq)tuple2._2();
        String topic = topicPartition.topic();
        int partition = topicPartition.partition();
        assignedReplicas.foreach((Function1 & Serializable & scala.Serializable)replicaId -> ReplicaStateMachine.$anonfun$initializeReplicaState$3($this, topic, partition, BoxesRunTime.unboxToInt((Object)replicaId)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$partitionsAssignedToBroker$1(int brokerId$1, Tuple2 x$5) {
        return ((SeqLike)x$5._2()).contains((Object)BoxesRunTime.boxToInteger((int)brokerId$1));
    }

    public ReplicaStateMachine(KafkaController controller) {
        this.kafka$controller$ReplicaStateMachine$$controller = controller;
        Logging.$init$(this);
        this.kafka$controller$ReplicaStateMachine$$controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.kafka$controller$ReplicaStateMachine$$zkUtils = this.kafka$controller$ReplicaStateMachine$$controllerContext().zkUtils();
        this.replicaState = Map$.MODULE$.empty();
        this.brokerChangeListener = new BrokerChangeListener();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$ReplicaStateMachine$$hasStarted = new AtomicBoolean(false);
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.logIdent_$eq("[Replica state machine on controller " + controller.config().brokerId() + "]: ");
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class BrokerChangeListener
    implements IZkChildListener,
    Logging {
        private final String loggerName;
        private Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging.trace$(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging.swallowTrace$(this, action);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging.debug$(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging.swallowDebug$(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging.info$(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging.swallowInfo$(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging.warn$(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging.swallowWarn$(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging.swallow$(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging.error$(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging.swallowError$(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging.fatal$(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            BrokerChangeListener brokerChangeListener = this;
            synchronized (brokerChangeListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        public void handleChildChange(String parentPath, List<String> currentBrokerList) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Broker change listener fired for path %s with children %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentPath, ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(currentBrokerList).sorted((Ordering)Ordering.String$.MODULE$)).mkString(",")})));
            CoreUtils$.MODULE$.inLock(this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                block0: {
                    if (!this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$hasStarted().get()) break block0;
                    ControllerStats$.MODULE$.leaderElectionTimer().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        try {
                            scala.collection.immutable.Set curBrokers = (scala.collection.immutable.Set)((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(currentBrokerList).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)BrokerChangeListener.$anonfun$handleChildChange$4(x$6)), Buffer$.MODULE$.canBuildFrom())).toSet().flatMap((Function1 & Serializable & scala.Serializable)brokerId -> Option$.MODULE$.option2Iterable(this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$zkUtils().getBrokerInfo(BoxesRunTime.unboxToInt((Object)brokerId))), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                            scala.collection.immutable.Set curBrokerIds = (scala.collection.immutable.Set)curBrokers.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                            Set<Object> liveOrShuttingDownBrokerIds = this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveOrShuttingDownBrokerIds();
                            scala.collection.immutable.Set newBrokerIds = (scala.collection.immutable.Set)curBrokerIds.$minus$minus(liveOrShuttingDownBrokerIds);
                            Set deadBrokerIds = (Set)liveOrShuttingDownBrokerIds.$minus$minus((GenTraversableOnce)curBrokerIds);
                            scala.collection.immutable.Set newBrokers = (scala.collection.immutable.Set)curBrokers.filter((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)newBrokerIds.apply((Object)BoxesRunTime.boxToInteger((int)broker.id()))));
                            this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokers_$eq((Set<Broker>)curBrokers);
                            Seq newBrokerIdsSorted = (Seq)newBrokerIds.toSeq().sorted((Ordering)Ordering.Int$.MODULE$);
                            Seq deadBrokerIdsSorted = (Seq)deadBrokerIds.toSeq().sorted((Ordering)Ordering.Int$.MODULE$);
                            Seq liveBrokerIdsSorted = (Seq)curBrokerIds.toSeq().sorted((Ordering)Ordering.Int$.MODULE$);
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Newly added brokers: %s, deleted brokers: %s, all live brokers: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newBrokerIdsSorted.mkString(","), deadBrokerIdsSorted.mkString(","), liveBrokerIdsSorted.mkString(",")})));
                            ControllerChannelManager controllerChannelManager = this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerChannelManager();
                            newBrokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
                                controllerChannelManager.addBroker(broker);
                                return BoxedUnit.UNIT;
                            });
                            ControllerChannelManager controllerChannelManager2 = this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerChannelManager();
                            deadBrokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> controllerChannelManager2.removeBroker(brokerId));
                            if (newBrokerIds.nonEmpty()) {
                                $this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controller.onBrokerStartup((Seq<Object>)newBrokerIdsSorted);
                            }
                            if (deadBrokerIds.nonEmpty()) {
                                $this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controller.onBrokerFailure((Seq<Object>)deadBrokerIdsSorted);
                            }
                        }
                        catch (Throwable e) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while handling broker changes", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        }
                    });
                }
            });
        }

        public /* synthetic */ ReplicaStateMachine kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer() {
            return ReplicaStateMachine.this;
        }

        public static final /* synthetic */ int $anonfun$handleChildChange$4(String x$6) {
            return new StringOps(Predef$.MODULE$.augmentString(x$6)).toInt();
        }

        public BrokerChangeListener() {
            if (ReplicaStateMachine.this == null) {
                throw null;
            }
            Logging.$init$(this);
            this.logIdent_$eq("[BrokerChangeListener on Controller " + ReplicaStateMachine.this.kafka$controller$ReplicaStateMachine$$controller.config().brokerId() + "]: ");
        }
    }
}

