/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.server.ConfigType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5d\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\rj]&$\u0018.\u00197U_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\u00042\u0001H\u0010\"\u001b\u0005i\"B\u0001\u0010\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Au\u00111aU3u!\t\u0011\u0013F\u0004\u0002$OA\u0011AEC\u0007\u0002K)\u0011aEB\u0001\u0007yI|w\u000e\u001e \n\u0005!R\u0011A\u0002)sK\u0012,g-\u0003\u0002+W\t11\u000b\u001e:j]\u001eT!\u0001\u000b\u0006\t\u00115\u0002!\u0011!Q\u0001\nm\t!%\u001b8ji&\fG\u000eV8qS\u000e\u001c\u0018J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>t\u0007\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\b\u0006\u00032eM\"\u0004C\u0001\f\u0001\u0011\u0015\u0019a\u00061\u0001\u0016\u0011\u001dQb\u0006%AA\u0002mAq!\f\u0018\u0011\u0002\u0003\u00071\u0004C\u00047\u0001\t\u0007I\u0011A\u001c\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u00019!\t1\u0012(\u0003\u0002;\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\rq\u0002\u0001\u0015!\u00039\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000fy\u0002!\u0019!C\u0001\u007f\u0005)\u0002/\u0019:uSRLwN\\*uCR,W*Y2iS:,W#\u0001!\u0011\u0005Y\t\u0015B\u0001\"\u0003\u0005U\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016Da\u0001\u0012\u0001!\u0002\u0013\u0001\u0015A\u00069beRLG/[8o'R\fG/Z'bG\"Lg.\u001a\u0011\t\u000f\u0019\u0003!\u0019!C\u0001\u000f\u0006\u0019\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oKV\t\u0001\n\u0005\u0002\u0017\u0013&\u0011!J\u0001\u0002\u0014%\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.\u001a\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002%\u0002)I,\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3!\u0011\u001dq\u0005A1A\u0005\u0002=\u000b\u0011\u0003^8qS\u000e\u001cHk\u001c\"f\t\u0016dW\r^3e+\u0005\u0001\u0006cA)UC5\t!K\u0003\u0002T;\u00059Q.\u001e;bE2,\u0017B\u0001\u0011S\u0011\u00191\u0006\u0001)A\u0005!\u0006\u0011Bo\u001c9jGN$vNQ3EK2,G/\u001a3!\u0011\u001dA\u0006A1A\u0005\u0002e\u000bQ\u0003]1si&$\u0018n\u001c8t)>\u0014U\rR3mKR,G-F\u0001[!\r\tFk\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=\u0012\taaY8n[>t\u0017B\u00011^\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\u0007E\u0002\u0001\u000b\u0011\u0002.\u0002-A\f'\u000f^5uS>t7\u000fV8CK\u0012+G.\u001a;fI\u0002Bq\u0001\u001a\u0001C\u0002\u0013\u0005Q-\u0001\u0006eK2,G/\u001a'pG.,\u0012A\u001a\t\u0003OBl\u0011\u0001\u001b\u0006\u0003S*\fQ\u0001\\8dWNT!a\u001b7\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002n]\u0006!Q\u000f^5m\u0015\u0005y\u0017\u0001\u00026bm\u0006L!!\u001d5\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019\u0019\b\u0001)A\u0005M\u0006YA-\u001a7fi\u0016dunY6!\u0011\u001d)\bA1A\u0005\u0002=\u000b1\u0004^8qS\u000e\u001c\u0018J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>t\u0007BB<\u0001A\u0003%\u0001+\u0001\u000fu_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0011\t\u000fe\u0004!\u0019!C\u0001u\u0006\u0001B-\u001a7fi\u0016$v\u000e]5dg\u000e{g\u000eZ\u000b\u0002wB\u0011q\r`\u0005\u0003{\"\u0014\u0011bQ8oI&$\u0018n\u001c8\t\r}\u0004\u0001\u0015!\u0003|\u0003E!W\r\\3uKR{\u0007/[2t\u0007>tG\r\t\u0005\n\u0003\u0007\u0001!\u0019!C\u0001\u0003\u000b\tq\u0003Z3mKR,Gk\u001c9jGN#\u0018\r^3DQ\u0006tw-\u001a3\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055!.\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003#\tYAA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\b\u0005AB-\u001a7fi\u0016$v\u000e]5d'R\fG/Z\"iC:<W\r\u001a\u0011\t\u0013\u0005e\u0001\u00011A\u0005\u0002\u0005m\u0011A\u00053fY\u0016$X\rV8qS\u000e\u001cH\u000b\u001b:fC\u0012,\"!!\b\u0011\t\u0005}\u0011\u0011E\u0007\u0002\u0001\u00191\u00111\u0005\u0001\u0001\u0003K\u0011!\u0003R3mKR,Gk\u001c9jGN$\u0006N]3bIN!\u0011\u0011EA\u0014!\ry\u0011\u0011F\u0005\u0004\u0003W\u0001\"AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012DqaLA\u0011\t\u0003\ty\u0003\u0006\u0002\u0002\u001e!Q\u00111GA\u0011\u0005\u0004%\t!!\u000e\u0002\u000fi\\W\u000b^5mgV\u0011\u0011q\u0007\t\u0004\u001f\u0005e\u0012bAA\u001e!\t9!l[+uS2\u001c\b\"CA \u0003C\u0001\u000b\u0011BA\u001c\u0003!Q8.\u0016;jYN\u0004\u0003\u0002CA\"\u0003C!\t%!\u0012\u0002\r\u0011|wk\u001c:l)\t\t9\u0005E\u0002\n\u0003\u0013J1!a\u0013\u000b\u0005\u0011)f.\u001b;\t\u0013\u0005=\u0003\u00011A\u0005\u0002\u0005E\u0013A\u00063fY\u0016$X\rV8qS\u000e\u001cH\u000b\u001b:fC\u0012|F%Z9\u0015\t\u0005\u001d\u00131\u000b\u0005\u000b\u0003+\ni%!AA\u0002\u0005u\u0011a\u0001=%c!A\u0011\u0011\f\u0001!B\u0013\ti\"A\neK2,G/\u001a+pa&\u001c7\u000f\u00165sK\u0006$\u0007\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0001\u0002`\u0005!\u0012n\u001d#fY\u0016$X\rV8qS\u000e,e.\u00192mK\u0012,\"!!\u0019\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001ao\u0003\u0011a\u0017M\\4\n\t\u0005-\u0014Q\r\u0002\b\u0005>|G.Z1o\u0011!\ty\u0007\u0001Q\u0001\n\u0005\u0005\u0014!F5t\t\u0016dW\r^3U_BL7-\u00128bE2,G\r\t\u0005\b\u0003g\u0002A\u0011AA#\u0003\u0015\u0019H/\u0019:u\u0011\u001d\t9\b\u0001C\u0001\u0003\u000b\n\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0003w\u0002A\u0011AA?\u0003a)g.];fk\u0016$v\u000e]5dg\u001a{'\u000fR3mKRLwN\u001c\u000b\u0005\u0003\u000f\ny\bC\u0004\u0002\u0002\u0006e\u0004\u0019A\u000e\u0002\rQ|\u0007/[2t\u0011\u001d\t)\t\u0001C\u0001\u0003\u000f\u000bqC]3tk6,G)\u001a7fi&|gNR8s)>\u0004\u0018nY:\u0015\t\u0005\u001d\u0013\u0011\u0012\u0005\n\u0003\u0003\u000b\u0019\t%AA\u0002mAq!!$\u0001\t\u0003\ty)A\ngC&d'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000e\u0006\u0003\u0002H\u0005E\u0005\u0002CAJ\u0003\u0017\u0003\r!!&\u0002\u0011I,\u0007\u000f\\5dCN\u0004B\u0001H\u0010\u0002\u0018B\u0019a#!'\n\u0007\u0005m%AA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017\rC\u0004\u0002 \u0002!\t!!)\u0002=5\f'o\u001b+pa&\u001c\u0017J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>tG\u0003BA$\u0003GCq!!!\u0002\u001e\u0002\u00071\u0004C\u0004\u0002(\u0002!\t!!+\u00029%\u001cHk\u001c9jG&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]R!\u00111VAX!\rI\u0011QV\u0005\u0004\u0003WR\u0001bBAY\u0003K\u0003\r!I\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003k\u0003A\u0011AA\\\u0003eI7\u000fV8qS\u000e$U\r\\3uS>t\u0017J\u001c)s_\u001e\u0014Xm]:\u0015\t\u0005-\u0016\u0011\u0018\u0005\b\u0003c\u000b\u0019\f1\u0001\"\u0011\u001d\ti\f\u0001C\u0001\u0003\u007f\u000ba#[:QCJ$\u0018\u000e^5p]R{')\u001a#fY\u0016$X\r\u001a\u000b\u0005\u0003W\u000b\t\rC\u0004\u0002D\u0006m\u0006\u0019A.\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002H\u0002!\t!!3\u00025%\u001cHk\u001c9jGF+X-^3e+B4uN\u001d#fY\u0016$\u0018n\u001c8\u0015\t\u0005-\u00161\u001a\u0005\b\u0003c\u000b)\r1\u0001\"\u0011\u001d\ty\r\u0001C\u0005\u0003\u000b\na$Y<bSR$v\u000e]5d\t\u0016dW\r^5p]:{G/\u001b4jG\u0006$\u0018n\u001c8\t\u000f\u0005M\u0007\u0001\"\u0003\u0002F\u0005I\"/Z:v[\u0016$v\u000e]5d\t\u0016dW\r^5p]RC'/Z1e\u0011\u001d\t9\u000e\u0001C\u0005\u00033\fqcY8na2,G/\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8\u0015\t\u0005\u001d\u00131\u001c\u0005\t\u0003'\u000b)\u000e1\u0001\u0002\u0016\"9\u0011q\u001c\u0001\u0005\n\u0005\u0005\u0018AG5t)>\u0004\u0018nY#mS\u001eL'\r\\3G_J$U\r\\3uS>tG\u0003BAV\u0003GDq!!-\u0002^\u0002\u0007\u0011\u0005C\u0004\u0002h\u0002!I!!;\u000235\f'o\u001b+pa&\u001cgi\u001c:EK2,G/[8o%\u0016$(/\u001f\u000b\u0005\u0003\u000f\nY\u000fC\u0004\u00022\u0006\u0015\b\u0019A\u0011\t\u000f\u0005=\b\u0001\"\u0003\u0002r\u0006\u00192m\\7qY\u0016$X\rR3mKR,Gk\u001c9jGR!\u0011qIAz\u0011\u001d\t\t,!<A\u0002\u0005Bq!a>\u0001\t\u0013\tI0A\bp]R{\u0007/[2EK2,G/[8o)\u0011\t9%a?\t\u000f\u0005\u0005\u0015Q\u001fa\u00017!9\u0011q \u0001\u0005\n\t\u0005\u0011\u0001F:uCJ$(+\u001a9mS\u000e\fG)\u001a7fi&|g\u000e\u0006\u0003\u0002H\t\r\u0001\u0002\u0003B\u0003\u0003{\u0004\r!!&\u00029I,\u0007\u000f\\5dCN4uN\u001d+pa&\u001c7\u000fV8CK\u0012+G.\u001a;fI\"9!\u0011\u0002\u0001\u0005\n\t-\u0011aE8o!\u0006\u0014H/\u001b;j_:$U\r\\3uS>tG\u0003BA$\u0005\u001bAq\u0001\u0017B\u0004\u0001\u0004\u0011y\u0001E\u0002\u001d?mCqAa\u0005\u0001\t\u0013\u0011)\"\u0001\u0010eK2,G/\u001a+pa&\u001c7\u000b^8q%\u0016\u0004H.[2b\u0007\u0006dGNY1dWR1\u0011q\tB\f\u0005gA\u0001B!\u0007\u0003\u0012\u0001\u0007!1D\u0001\u0017gR|\u0007OU3qY&\u001c\u0017MU3ta>t7/Z(cUB!!Q\u0004B\u0018\u001b\t\u0011yB\u0003\u0003\u0003\"\t\r\u0012\u0001\u0003:fcV,7\u000f^:\u000b\u0007y\u0013)CC\u0002\u0006\u0005OQAA!\u000b\u0003,\u00051\u0011\r]1dQ\u0016T!A!\f\u0002\u0007=\u0014x-\u0003\u0003\u00032\t}!aF!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;SKN\u0004xN\\:f\u0011!\u0011)D!\u0005A\u0002\t]\u0012!\u0003:fa2L7-Y%e!\rI!\u0011H\u0005\u0004\u0005wQ!aA%oi\"I!q\b\u0001\u0012\u0002\u0013\u0005!\u0011I\u0001\"e\u0016\u001cX/\\3EK2,G/[8o\r>\u0014Hk\u001c9jGN$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0007R3a\u0007B#W\t\u00119\u0005\u0005\u0003\u0003J\tMSB\u0001B&\u0015\u0011\u0011iEa\u0014\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B)\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU#1\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,w!\u0003B-\u0005\u0005\u0005\t\u0012\u0001B.\u0003Q!v\u000e]5d\t\u0016dW\r^5p]6\u000bg.Y4feB\u0019aC!\u0018\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0005?\u001a2A!\u0018\t\u0011\u001dy#Q\fC\u0001\u0005G\"\"Aa\u0017\t\u0015\t\u001d$QLI\u0001\n\u0003\u0011\t%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r\u0005\u000b\u0005W\u0012i&%A\u0005\u0002\t\u0005\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3\u0007")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted;
    private final ReentrantLock deleteLock;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final Condition deleteTopicsCond;
    private final AtomicBoolean deleteTopicStateChanged;
    private DeleteTopicsThread deleteTopicsThread;
    private final Boolean isDeleteTopicEnabled;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Set<String> $lessinit$greater$default$3() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Set<String> $lessinit$greater$default$2() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public ReentrantLock deleteLock() {
        return this.deleteLock;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public Condition deleteTopicsCond() {
        return this.deleteTopicsCond;
    }

    public AtomicBoolean deleteTopicStateChanged() {
        return this.deleteTopicStateChanged;
    }

    public DeleteTopicsThread deleteTopicsThread() {
        return this.deleteTopicsThread;
    }

    public void deleteTopicsThread_$eq(DeleteTopicsThread x$1) {
        this.deleteTopicsThread = x$1;
    }

    public Boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public void start() {
        block1: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block1;
            this.deleteTopicsThread_$eq(new DeleteTopicsThread());
            if (this.topicsToBeDeleted().nonEmpty()) {
                this.deleteTopicStateChanged().set(true);
            }
            this.deleteTopicsThread().start();
        }
    }

    public void shutdown() {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !this.deleteTopicsThread().initiateShutdown()) break block0;
            this.resumeTopicDeletionThread();
            this.deleteTopicsThread().awaitShutdown();
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom()));
            this.resumeTopicDeletionThread();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        block0: {
            Set topicsToResumeDeletion;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) break block0;
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeTopicDeletionThread();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        block0: {
            Set replicasThatFailedToDelete;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())))).nonEmpty()) break block0;
            Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion failed for replicas %s. Halting deletion for topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicasThatFailedToDelete.mkString(","), topics})));
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasThatFailedToDelete, ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeTopicDeletionThread();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        block1: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block1;
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Halted deletion of topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newTopicsToHaltDeletion.mkString(",")})));
            }
        }
    }

    public boolean isTopicIneligibleForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    public boolean isTopicDeletionInProgress(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicAndPartition topicAndPartition) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.partitionsToBeDeleted().contains((Object)topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public void kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification() {
        CoreUtils$.MODULE$.inLock(this.deleteLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            while (this.deleteTopicsThread().isRunning().get() && !this.deleteTopicStateChanged().compareAndSet(true, false)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for signal to start or continue topic deletion");
                this.deleteTopicsCond().await();
            }
        });
    }

    private void resumeTopicDeletionThread() {
        this.deleteTopicStateChanged().set(true);
        CoreUtils$.MODULE$.inLock(this.deleteLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.deleteTopicsCond().signal());
    }

    private void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion successfully completed for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{successfullyDeletedReplicas.mkString(",")})));
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)successfullyDeletedReplicas, ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeTopicDeletionThread();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    public void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Retrying delete topic for topic %s since replicas %s were not successfully deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, failedReplicas.mkString(",")})));
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(failedReplicas, OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.partitionStateMachine().deregisterPartitionChangeListener(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.partitionsToBeDeleted().retain((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$completeDeleteTopic$1(topic, x$2)));
        ZkUtils zkUtils = this.controllerContext().zkUtils();
        zkUtils.zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
        zkUtils.zkClient().deleteRecursive(ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Topic(), topic));
        zkUtils.zkClient().delete(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        this.controllerContext().removeTopic(topic);
    }

    public void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Topic deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topics.mkString(",")})));
        Set partitions = (Set)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicAndPartition>)partitions);
        Map partitionReplicaAssignmentByTopic = this.controllerContext().partitionReplicaAssignment().groupBy((Function1 & Serializable & scala.Serializable)p -> ((TopicAndPartition)p._1()).topic());
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.onPartitionDeletion((Set<TopicAndPartition>)((MapLike)partitionReplicaAssignmentByTopic.apply((Object)topic)).keySet());
            return BoxedUnit.UNIT;
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topic()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TopicDeletionManager.$anonfun$startReplicaDeletion$2(this, replicasForTopicsToBeDeleted, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Partition deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsToBeDeleted.mkString(",")})));
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void deleteTopicStopReplicaCallback(AbstractRequestResponse stopReplicaResponseObj, int replicaId) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)stopReplicaResponseObj;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Delete topic callback invoked for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stopReplicaResponse})));
        scala.collection.mutable.Map responseMap = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(stopReplicaResponse.responses()).asScala();
        Set partitionsInError = stopReplicaResponse.errorCode() != Errors.NONE.code() ? responseMap.keySet() : ((MapLike)responseMap.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$deleteTopicStopReplicaCallback$2(x0$2)))).keySet();
        Set replicasInError = (Set)partitionsInError.map((Function1 & Serializable & scala.Serializable)p -> new PartitionAndReplica(p.topic(), p.partition(), replicaId), Set$.MODULE$.canBuildFrom());
        CoreUtils$.MODULE$.inLock(this.controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                this.failReplicaDeletion((Set<PartitionAndReplica>)replicasInError);
                if (replicasInError.size() == responseMap.size()) break block0;
                Set deletedReplicas = (Set)responseMap.keySet().$minus$minus((GenTraversableOnce)partitionsInError);
                this.completeReplicaDeletion((Set<PartitionAndReplica>)((Set)deletedReplicas.map((Function1 & Serializable & scala.Serializable)p -> new PartitionAndReplica(p.topic(), p.partition(), replicaId), Set$.MODULE$.canBuildFrom())));
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$completeDeleteTopic$1(String topic$2, TopicAndPartition x$2) {
        String string = x$2.topic();
        String string2 = topic$2;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$startReplicaDeletion$3(String topic$3, PartitionAndReplica p) {
        return p.topic().equals(topic$3);
    }

    public static final /* synthetic */ void $anonfun$startReplicaDeletion$2(TopicDeletionManager $this, Set replicasForTopicsToBeDeleted$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String topic = (String)tuple2._1();
            Set aliveReplicasForTopic = (Set)$this.controllerContext().allLiveReplicas().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$startReplicaDeletion$3(topic, p)));
            Set deadReplicasForTopic = (Set)replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
            Set<PartitionAndReplica> successfullyDeletedReplicas = $this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
            $this.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)deadReplicasForTopic, ReplicaDeletionIneligible$.MODULE$, $this.replicaStateMachine().handleStateChanges$default$3());
            $this.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, OfflineReplica$.MODULE$, $this.replicaStateMachine().handleStateChanges$default$3());
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion started for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicasForDeletionRetry.mkString(",")})));
            $this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, new Callbacks.CallbackBuilder().stopReplicaCallback((Function2<AbstractRequestResponse, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(stopReplicaResponseObj, replicaId) -> {
                $this.deleteTopicStopReplicaCallback(stopReplicaResponseObj, BoxesRunTime.unboxToInt((Object)replicaId));
                return BoxedUnit.UNIT;
            }).build());
            if (deadReplicasForTopic.nonEmpty()) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Dead Replicas (%s) found for topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deadReplicasForTopic.mkString(","), topic})));
                $this.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopicStopReplicaCallback$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Short error = (Short)tuple2._2();
        boolean bl = !BoxesRunTime.equalsNumObject((Number)error, (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()));
        return bl;
    }

    public TopicDeletionManager(KafkaController controller, Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        Logging.$init$(this);
        this.logIdent_$eq("[Topic Deletion Manager " + controller.config().brokerId() + "], ");
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus(initialTopicsToBeDeleted);
        this.partitionsToBeDeleted = (scala.collection.mutable.Set)this.topicsToBeDeleted().flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        this.deleteLock = new ReentrantLock();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)initialTopicsIneligibleForDeletion.$amp(initialTopicsToBeDeleted));
        this.deleteTopicsCond = this.deleteLock().newCondition();
        this.deleteTopicStateChanged = new AtomicBoolean(false);
        this.deleteTopicsThread = null;
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
    }

    public class DeleteTopicsThread
    extends ShutdownableThread {
        private final ZkUtils zkUtils;

        public ZkUtils zkUtils() {
            return this.zkUtils;
        }

        @Override
        public void doWork() {
            this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification();
            if (!this.isRunning().get()) {
                return;
            }
            CoreUtils$.MODULE$.inLock(this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().topicsToBeDeleted());
                if (topicsQueuedForDeletion.nonEmpty()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handling deletion for topics " + topicsQueuedForDeletion.mkString(","));
                }
                topicsQueuedForDeletion.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                    DeleteTopicsThread.$anonfun$doWork$3(this, topic);
                    return BoxedUnit.UNIT;
                });
            });
        }

        public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer() {
            return TopicDeletionManager.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$3(DeleteTopicsThread $this, String topic) {
            block6: {
                block5: {
                    if ($this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                        $this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic);
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s successfully completed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    } else if ($this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                        Set<PartitionAndReplica> replicasInDeletionStartedState = $this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                        Set replicaIds = (Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.replica()), Set$.MODULE$.canBuildFrom());
                        Set partitions = (Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)r -> new TopicAndPartition(r.topic(), r.partition()), Set$.MODULE$.canBuildFrom());
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion for replicas %s for partition %s of topic %s in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaIds.mkString(","), partitions.mkString(","), topic})));
                    } else if ($this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                        $this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic);
                    }
                    if (!$this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) break block5;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s (re)started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    $this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                    break block6;
                }
                if (!$this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().isTopicIneligibleForDeletion(topic)) break block6;
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Not retrying deletion of topic %s at this time since it is marked ineligible for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
        }

        public DeleteTopicsThread() {
            if (TopicDeletionManager.this == null) {
                throw null;
            }
            super("delete-topics-thread-" + TopicDeletionManager.this.kafka$controller$TopicDeletionManager$$controller.config().brokerId(), false);
            this.zkUtils = TopicDeletionManager.this.controllerContext().zkUtils();
        }
    }
}

