/*
 * Decompiled with CFR 0.152.
 */
package kafka.javaapi;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest$;
import org.apache.kafka.common.protocol.ApiKeys;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u000f\t!Bk\u001c9jG6+G/\u00193bi\u0006\u0014V-];fgRT!a\u0001\u0003\u0002\u000f)\fg/Y1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\r\t\u0007/[\u0005\u0003\u001b)\u0011\u0011CU3rk\u0016\u001cHo\u0014:SKN\u0004xN\\:f\u0011!y\u0001A!b\u0001\n\u0003\u0001\u0012!\u0003<feNLwN\\%e+\u0005\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"!B*i_J$\b\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\t\u0002\u0015Y,'o]5p]&#\u0007\u0005\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0001\u001c\u00035\u0019wN\u001d:fY\u0006$\u0018n\u001c8JIV\tA\u0004\u0005\u0002\u0013;%\u0011ad\u0005\u0002\u0004\u0013:$\b\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u001d\r|'O]3mCRLwN\\%eA!A!\u0005\u0001BC\u0002\u0013\u00051%\u0001\u0005dY&,g\u000e^%e+\u0005!\u0003CA\u0013-\u001d\t1#\u0006\u0005\u0002('5\t\u0001F\u0003\u0002*\r\u00051AH]8pizJ!aK\n\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003WMA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\nG2LWM\u001c;JI\u0002B\u0001B\r\u0001\u0003\u0006\u0004%\taM\u0001\u0007i>\u0004\u0018nY:\u0016\u0003Q\u00022!\u000e\u001e%\u001b\u00051$BA\u001c9\u0003\u0011)H/\u001b7\u000b\u0003e\nAA[1wC&\u00111H\u000e\u0002\u0005\u0019&\u001cH\u000f\u0003\u0005>\u0001\t\u0005\t\u0015!\u00035\u0003\u001d!x\u000e]5dg\u0002BQa\u0010\u0001\u0005\u0002\u0001\u000ba\u0001P5oSRtD#B!D\t\u00163\u0005C\u0001\"\u0001\u001b\u0005\u0011\u0001\"B\b?\u0001\u0004\t\u0002\"\u0002\u000e?\u0001\u0004a\u0002\"\u0002\u0012?\u0001\u0004!\u0003\"\u0002\u001a?\u0001\u0004!\u0004b\u0002%\u0001\u0005\u0004%\t!S\u0001\u000bk:$WM\u001d7zS:<W#\u0001&\u0011\u0005%Y\u0015BA\u0001\u000b\u0011\u0019i\u0005\u0001)A\u0005\u0015\u0006YQO\u001c3fe2L\u0018N\\4!\u0011\u0015y\u0004\u0001\"\u0001P)\t\t\u0005\u000bC\u00033\u001d\u0002\u0007A\u0007C\u0003@\u0001\u0011\u0005!\u000bF\u0002B'RCQAM)A\u0002QBQAG)A\u0002qAQA\u0016\u0001\u0005\u0002]\u000bqa\u001e:ji\u0016$v\u000e\u0006\u0002Y7B\u0011!#W\u0005\u00035N\u0011A!\u00168ji\")A,\u0016a\u0001;\u00061!-\u001e4gKJ\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u001d\u0002\u00079Lw.\u0003\u0002c?\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000b\u0011\u0004A\u0011A\u000e\u0002\u0017ML'0Z%o\u0005f$Xm\u001d\u0005\u0006M\u0002!\teZ\u0001\ti>\u001cFO]5oOR\tA\u0005C\u0003j\u0001\u0011\u0005#.\u0001\u0005eKN\u001c'/\u001b2f)\t!3\u000eC\u0003mQ\u0002\u0007Q.A\u0004eKR\f\u0017\u000e\\:\u0011\u0005Iq\u0017BA8\u0014\u0005\u001d\u0011un\u001c7fC:\u0004")
public class TopicMetadataRequest
extends RequestOrResponse {
    private final short versionId;
    private final int correlationId;
    private final String clientId;
    private final List<String> topics;
    private final kafka.api.TopicMetadataRequest underlying;

    public short versionId() {
        return this.versionId;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public List<String> topics() {
        return this.topics;
    }

    public kafka.api.TopicMetadataRequest underlying() {
        return this.underlying;
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        this.underlying().writeTo(buffer);
    }

    @Override
    public int sizeInBytes() {
        return this.underlying().sizeInBytes();
    }

    public String toString() {
        return this.describe(true);
    }

    @Override
    public String describe(boolean details) {
        StringBuilder topicMetadataRequest = new StringBuilder();
        topicMetadataRequest.append("Name: " + this.getClass().getSimpleName());
        topicMetadataRequest.append("; Version: " + this.versionId());
        topicMetadataRequest.append("; CorrelationId: " + this.correlationId());
        topicMetadataRequest.append("; ClientId: " + this.clientId());
        if (details) {
            topicMetadataRequest.append("; Topics: ");
            Iterator<String> topicIterator = this.topics().iterator();
            while (topicIterator.hasNext()) {
                String topic = topicIterator.next();
                topicMetadataRequest.append(new StringOps(Predef$.MODULE$.augmentString("%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                Object object = topicIterator.hasNext() ? topicMetadataRequest.append(",") : BoxedUnit.UNIT;
            }
        }
        return topicMetadataRequest.toString();
    }

    public TopicMetadataRequest(short versionId, int correlationId, String clientId, List<String> topics) {
        this.versionId = versionId;
        this.correlationId = correlationId;
        this.clientId = clientId;
        this.topics = topics;
        super((Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)ApiKeys.METADATA.id)));
        this.underlying = new kafka.api.TopicMetadataRequest(versionId, correlationId, clientId, (Seq<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(topics));
    }

    public TopicMetadataRequest(List<String> topics) {
        this(TopicMetadataRequest$.MODULE$.CurrentVersion(), 0, TopicMetadataRequest$.MODULE$.DefaultClientId(), topics);
    }

    public TopicMetadataRequest(List<String> topics, int correlationId) {
        this(TopicMetadataRequest$.MODULE$.CurrentVersion(), correlationId, TopicMetadataRequest$.MODULE$.DefaultClientId(), topics);
    }
}

