/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerStats;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.log.TimeIndex;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.MagicAndTimestamp;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.MessageWriter;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.kafka.common.record.TimestampType;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015a!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011aBN\u0005\u0003o=\u0011A\u0001V5nK\"A\u0011\b\u0001B\u0001B\u0003%!(A\u0005dQ\u0016\u001c7\u000eR8oKB!\u0001bO\u001fD\u0013\ta\u0014BA\u0005Gk:\u001cG/[8ocA\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tB\u0001\u0007G>lWn\u001c8\n\u0005\t{$!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011\u0001\u0002R\u0005\u0003\u000b&\u0011A!\u00168ji\")q\t\u0001C\u0001\u0011\u00061A(\u001b8jiz\"\u0012\"\u0013&L\u00196su\nU)\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bG\u0001\u00049\u0002\"B\u000fG\u0001\u0004y\u0002\"\u0002\u0014G\u0001\u00049\u0002\"\u0002\u0015G\u0001\u00049\u0002\"\u0002\u0016G\u0001\u0004Y\u0003\"B\u0018G\u0001\u0004\u0001\u0004\"\u0002\u001bG\u0001\u0004)\u0004\"B\u001dG\u0001\u0004Q\u0004bB*\u0001\u0005\u0004%\t\u0005V\u0001\u000bY><w-\u001a:OC6,W#A+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016\u0001\u00027b]\u001eT\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n11\u000b\u001e:j]\u001eDaA\u0018\u0001!\u0002\u0013)\u0016a\u00037pO\u001e,'OT1nK\u0002Bq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011-A\bti\u0006$8/\u00168eKJd\u00170\u001b8h+\u0005\u0011\u0007\u0003\u0002\u0005dK\u0016L!\u0001Z\u0005\u0003\rQ+\b\u000f\\33!\t\u0001c-\u0003\u0002h\u0005\ta1\t\\3b]\u0016\u00148\u000b^1ug\"1\u0011\u000e\u0001Q\u0001\n\t\f\u0001c\u001d;biN,f\u000eZ3sYfLgn\u001a\u0011\t\u000b-\u0004A\u0011\u00017\u0002\u000bM$\u0018\r^:\u0016\u0003\u0015DqA\u001c\u0001A\u0002\u0013%q.\u0001\u0006sK\u0006$')\u001e4gKJ,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003gf\u000b1A\\5p\u0013\t)(O\u0001\u0006CsR,')\u001e4gKJDqa\u001e\u0001A\u0002\u0013%\u00010\u0001\bsK\u0006$')\u001e4gKJ|F%Z9\u0015\u0005\rK\bb\u0002>w\u0003\u0003\u0005\r\u0001]\u0001\u0004q\u0012\n\u0004B\u0002?\u0001A\u0003&\u0001/A\u0006sK\u0006$')\u001e4gKJ\u0004\u0003b\u0002@\u0001\u0001\u0004%Ia\\\u0001\foJLG/\u001a\"vM\u001a,'\u000fC\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004\u0005yqO]5uK\n+hMZ3s?\u0012*\u0017\u000fF\u0002D\u0003\u000bAqA_@\u0002\u0002\u0003\u0007\u0001\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0015\u00029\u0002\u0019]\u0014\u0018\u000e^3Ck\u001a4WM\u001d\u0011\t\u0011\u00055\u0001\u0001\"\u0001\u0003\u0003\u001f\tQa\u00197fC:$B!!\u0005\u0002\u0018A\u0019\u0001\"a\u0005\n\u0007\u0005U\u0011B\u0001\u0003M_:<\u0007\u0002CA\r\u0003\u0017\u0001\r!a\u0007\u0002\u0013\rdW-\u00198bE2,\u0007c\u0001\u0011\u0002\u001e%\u0019\u0011q\u0004\u0002\u0003\u00151{w\rV8DY\u0016\fg\u000e\u0003\u0005\u0002$\u0001!\tAAA\u0013\u00035\u0019G.Z1o'\u0016<W.\u001a8ugRI1)a\n\u00020\u0005\u0015\u0013\u0011\n\u0005\b\u0007\u0005\u0005\u0002\u0019AA\u0015!\r\u0001\u00131F\u0005\u0004\u0003[\u0011!a\u0001'pO\"A\u0011\u0011GA\u0011\u0001\u0004\t\u0019$\u0001\u0005tK\u001elWM\u001c;t!\u0019\t)$a\u000f\u0002@5\u0011\u0011q\u0007\u0006\u0004\u0003sI\u0011AC2pY2,7\r^5p]&!\u0011QHA\u001c\u0005\r\u0019V-\u001d\t\u0004A\u0005\u0005\u0013bAA\"\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005\u001d\u0013\u0011\u0005a\u0001?\u0005\u0019Q.\u00199\t\u0011\u0005-\u0013\u0011\u0005a\u0001\u0003#\tq\u0002Z3mKR,\u0007j\u001c:ju>tWj\u001d\u0005\t\u0003\u001f\u0002A\u0011\u0001\u0002\u0002R\u0005I1\r\\3b]&sGo\u001c\u000b\u000e\u0007\u0006M\u0013qKA.\u0003?\n\t'a\u001b\t\u000f\u0005U\u0013Q\na\u0001{\u0005\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005e\u0013Q\na\u0001\u0003\u007f\taa]8ve\u000e,\u0007\u0002CA/\u0003\u001b\u0002\r!a\u0010\u0002\t\u0011,7\u000f\u001e\u0005\b\u0003\u000f\ni\u00051\u0001 \u0011!\t\u0019'!\u0014A\u0002\u0005\u0015\u0014!\u0004:fi\u0006Lg\u000eR3mKR,7\u000fE\u0002\t\u0003OJ1!!\u001b\n\u0005\u001d\u0011un\u001c7fC:Dq!!\u001c\u0002N\u0001\u0007q#A\tnCbdunZ'fgN\fw-Z*ju\u0016Dq!!\u001d\u0001\t\u0013\t\u0019(\u0001\td_6\u0004(/Z:t\u001b\u0016\u001c8/Y4fgR91)!\u001e\u0002z\u0005%\u0005bBA<\u0003_\u0002\r\u0001]\u0001\u0007EV4g-\u001a:\t\u0011\u0005m\u0014q\u000ea\u0001\u0003{\n\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a!\u0005\u0003\u001diWm]:bO\u0016LA!a\"\u0002\u0002\n\u00012i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0005\t\u0003\u0017\u000by\u00071\u0001\u0002\u000e\u0006\tR.Z:tC\u001e,\u0017I\u001c3PM\u001a\u001cX\r^:\u0011\r\u0005U\u00121HAH!\u0011\ty(!%\n\t\u0005M\u0015\u0011\u0011\u0002\u0011\u001b\u0016\u001c8/Y4f\u0003:$wJ\u001a4tKRDq!a&\u0001\t\u0013\tI*A\ntQ>,H\u000e\u001a*fi\u0006Lg.T3tg\u0006<W\r\u0006\u0006\u0002f\u0005m\u0015QTAP\u0003CC\u0001\"!\u0017\u0002\u0016\u0002\u0007\u0011q\b\u0005\b\u0003\u000f\n)\n1\u0001 \u0011!\t\u0019'!&A\u0002\u0005\u0015\u0004\u0002CAR\u0003+\u0003\r!a$\u0002\u000b\u0015tGO]=\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u0006YqM]8x\u0005V4g-\u001a:t)\r\u0019\u00151\u0016\u0005\b\u0003[\n)\u000b1\u0001\u0018\u0011\u001d\ty\u000b\u0001C\u0001\u0003c\u000baB]3ti>\u0014XMQ;gM\u0016\u00148\u000fF\u0001D\u0011!\t)\f\u0001C\u0001\u0005\u0005]\u0016aE4s_V\u00048+Z4nK:$8OQ=TSj,G\u0003CA]\u0003#\fI.!8\u0011\r\u0005m\u00161ZA\u001a\u001d\u0011\ti,a2\u000f\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1\u0016\u0003\u0019a$o\\8u}%\t!\"C\u0002\u0002J&\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002N\u0006='\u0001\u0002'jgRT1!!3\n\u0011!\t\t$a-A\u0002\u0005M\u0007CBA^\u0003+\fy$\u0003\u0003\u0002X\u0006='\u0001C%uKJ\f'\r\\3\t\u000f\u0005m\u00171\u0017a\u0001/\u00059Q.\u0019=TSj,\u0007bBAp\u0003g\u0003\raF\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\t\u0003G\u0004A\u0011\u0001\u0002\u0002f\u0006q!-^5mI>3gm]3u\u001b\u0006\u0004H#C\"\u0002h\u0006%\u0018Q^Ay\u0011\u001d\u0019\u0011\u0011\u001da\u0001\u0003SA\u0001\"a;\u0002b\u0002\u0007\u0011\u0011C\u0001\u0006gR\f'\u000f\u001e\u0005\t\u0003_\f\t\u000f1\u0001\u0002\u0012\u0005\u0019QM\u001c3\t\u000f\u0005\u001d\u0013\u0011\u001da\u0001?!9\u0011Q\u001f\u0001\u0005\n\u0005]\u0018\u0001\u00072vS2$wJ\u001a4tKRl\u0015\r\u001d$peN+w-\\3oiRa\u0011QMA}\u0003w\fyP!\u0001\u0003\u0004!9\u0011QKAz\u0001\u0004i\u0004\u0002CA\u007f\u0003g\u0004\r!a\u0010\u0002\u000fM,w-\\3oi\"9\u0011qIAz\u0001\u0004y\u0002\u0002CAv\u0003g\u0004\r!!\u0005\t\u000f\u00055\u00141\u001fa\u0001/\u0001")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    private final Function1<TopicAndPartition, BoxedUnit> checkDone;
    private final String loggerName;
    private final Tuple2<CleanerStats, CleanerStats> statsUnderlying;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public Tuple2<CleanerStats, CleanerStats> statsUnderlying() {
        return this.statsUnderlying;
    }

    public CleanerStats stats() {
        return (CleanerStats)this.statsUnderlying()._1();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    public long clean(LogToClean cleanable) {
        long l;
        this.stats().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Log log = cleanable.log();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap());
        long endOffset = this.offsetMap().latestOffset() + 1L;
        this.stats().indexDone();
        Option option = log.logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            LogSegment seg = (LogSegment)some.value();
            l = seg.lastModified() - Predef$.MODULE$.Long2long(log.config().deleteRetentionMs());
        } else {
            throw new MatchError((Object)option);
        }
        long deleteHorizonMs = l;
        long cleanableHorizionMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizionMs), new Date(deleteHorizonMs)})));
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize())).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), deleteHorizonMs);
            return BoxedUnit.UNIT;
        });
        this.stats().bufferUtilization_$eq(this.offsetMap().utilization());
        this.stats().allDone();
        return endOffset;
    }

    public void cleanSegments(Log log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs) {
        File logFile = new File(((LogSegment)segments.head()).log().file().getPath() + Log$.MODULE$.CleanedFileSuffix());
        logFile.delete();
        File indexFile = new File(((LogSegment)segments.head()).index().file().getPath() + Log$.MODULE$.CleanedFileSuffix());
        File timeIndexFile = new File(((LogSegment)segments.head()).timeIndex().file().getPath() + Log$.MODULE$.CleanedFileSuffix());
        indexFile.delete();
        timeIndexFile.delete();
        FileMessageSet messages = new FileMessageSet(logFile, false, log.initFileSize(), Predef$.MODULE$.Boolean2boolean(log.config().preallocate()));
        OffsetIndex index = new OffsetIndex(indexFile, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).index().maxIndexSize());
        TimeIndex timeIndex = new TimeIndex(timeIndexFile, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).timeIndex().maxIndexSize());
        LogSegment cleaned = new LogSegment(messages, index, timeIndex, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).indexIntervalBytes(), log.config().randomSegmentJitter(), this.time);
        try {
            segments.foreach((Function1 & Serializable & scala.Serializable)old -> {
                Cleaner.$anonfun$cleanSegments$1(this, log, map, deleteHorizonMs, cleaned, old);
                return BoxedUnit.UNIT;
            });
            index.trimToValidSize();
            cleaned.onBecomeInactiveSegment();
            timeIndex.trimToValidSize();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)cleaned.baseOffset()), ((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.baseOffset()), Seq$.MODULE$.canBuildFrom())).mkString(","), log.name()})));
            log.replaceSegments(cleaned, segments, log.replaceSegments$default$3());
        }
        catch (LogCleaningAbortedException e) {
            cleaned.delete();
            throw e;
        }
    }

    public void cleanInto(TopicAndPartition topicAndPartition, LogSegment source, LogSegment dest, OffsetMap map, boolean retainDeletes, int maxLogMessageSize) {
        int position = 0;
        while (position < source.log().sizeInBytes()) {
            this.checkDone.apply((Object)topicAndPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            LongRef maxTimestamp = LongRef.create((long)Message$.MODULE$.NoTimestamp());
            LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
            ByteBufferMessageSet messages = new ByteBufferMessageSet(source.log().readInto(this.readBuffer(), position));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            IntRef messagesRead = IntRef.create((int)0);
            messages.shallowIterator().foreach((Function1 & Serializable & scala.Serializable)shallowMessageAndOffset -> {
                Cleaner.$anonfun$cleanInto$1(this, source, map, retainDeletes, maxTimestamp, offsetOfMaxTimestamp, messagesRead, shallowMessageAndOffset);
                return BoxedUnit.UNIT;
            });
            position += messages.validBytes();
            if (this.writeBuffer().position() > 0) {
                this.writeBuffer().flip();
                ByteBufferMessageSet retained = new ByteBufferMessageSet(this.writeBuffer());
                dest.append(((MessageAndOffset)retained.head()).offset(), maxTimestamp.elem, offsetOfMaxTimestamp.elem, retained);
                this.throttler.maybeThrottle(this.writeBuffer().limit());
            }
            if (this.readBuffer().limit() <= 0 || messagesRead.elem != 0) continue;
            this.growBuffers(maxLogMessageSize);
        }
        this.restoreBuffers();
    }

    private void compressMessages(ByteBuffer buffer, CompressionCodec compressionCodec, Seq<MessageAndOffset> messageAndOffsets) {
        block0: {
            CompressionCodec compressionCodec2 = compressionCodec;
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            Predef$.MODULE$.require(compressionCodec2 == null ? noCompressionCodec$ != null : !compressionCodec2.equals(noCompressionCodec$), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compressionCodec must not be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{NoCompressionCodec$.MODULE$})));
            if (!messageAndOffsets.nonEmpty()) break block0;
            Seq messages = (Seq)messageAndOffsets.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.message(), Seq$.MODULE$.canBuildFrom());
            MagicAndTimestamp magicAndTimestamp = MessageSet$.MODULE$.magicAndLargestTimestamp((Seq<Message>)messages);
            byte magic = magicAndTimestamp.magic();
            MessageAndOffset firstMessageOffset = (MessageAndOffset)messageAndOffsets.head();
            long firstAbsoluteOffset = firstMessageOffset.offset();
            LongRef offset = LongRef.create((long)-1L);
            TimestampType timestampType = firstMessageOffset.message().timestampType();
            MessageWriter messageWriter = new MessageWriter(package$.MODULE$.min(package$.MODULE$.max(MessageSet$.MODULE$.messageSetSize((Iterable<Message>)messages) / 2, 1024), 65536));
            CompressionCodec x$18 = compressionCodec;
            long x$19 = magicAndTimestamp.timestamp();
            TimestampType x$20 = timestampType;
            byte x$21 = magic;
            byte[] x$22 = messageWriter.write$default$1();
            Function1 & Serializable & scala.Serializable x$23 = (Function1 & Serializable & scala.Serializable)outputStream -> {
                Cleaner.$anonfun$compressMessages$3(compressionCodec, messageAndOffsets, magic, firstAbsoluteOffset, offset, outputStream);
                return BoxedUnit.UNIT;
            };
            messageWriter.write(x$22, x$18, x$19, x$20, x$21, (Function1<OutputStream, BoxedUnit>)x$23);
            ByteBufferMessageSet$.MODULE$.writeMessage(buffer, messageWriter, offset.elem);
            this.stats().recopyMessage(messageWriter.size() + MessageSet$.MODULE$.LogOverhead());
        }
    }

    private boolean shouldRetainMessage(LogSegment source, OffsetMap map, boolean retainDeletes, MessageAndOffset entry) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = entry.offset() > map.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        ByteBuffer key = entry.message().key();
        if (key != null) {
            boolean obsoleteDelete;
            long foundOffset = map.get(key);
            boolean redundant = foundOffset >= 0L && entry.offset() < foundOffset;
            boolean bl3 = obsoleteDelete = !retainDeletes && entry.message().isNull();
            bl = !redundant && !obsoleteDelete;
        } else {
            this.stats().invalidMessage();
            bl = false;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Growing cleaner I/O buffers from " + this.readBuffer().capacity() + "bytes to " + newSize + " bytes.");
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        block1: {
            if (this.readBuffer().capacity() > this.ioBufferSize) {
                this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
            }
            if (this.writeBuffer().capacity() <= this.ioBufferSize) break block1;
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            int indexSize = ((LogSegment)segs.head()).index().sizeInBytes();
            int timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + ((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + ((LogSegment)segs.head()).index().sizeInBytes() <= maxIndexSize && timeIndexSize + ((LogSegment)segs.head()).timeIndex().sizeInBytes() <= maxIndexSize && ((LogSegment)segs.head()).index().lastOffset() - ((LogSegment)group.last()).index().baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += ((LogSegment)segs.head()).size();
                indexSize += ((LogSegment)segs.head()).index().sizeInBytes();
                timeIndexSize += ((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    public void buildOffsetMap(Log log, long start, long end, OffsetMap map) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        BooleanRef full = BooleanRef.create((boolean)false);
        dirty.withFilter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$2(full, segment))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            Cleaner.$anonfun$buildOffsetMap$3(this, log, start, map, dirty, full, segment);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
    }

    private boolean buildOffsetMapForSegment(TopicAndPartition topicAndPartition, LogSegment segment, OffsetMap map, long start, int maxLogMessageSize) {
        Object object = new Object();
        try {
            int position = segment.index().lookup(start).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.checkDone.apply((Object)topicAndPartition);
                this.readBuffer().clear();
                ByteBufferMessageSet messages = new ByteBufferMessageSet(segment.log().readInto(this.readBuffer(), position));
                this.throttler.maybeThrottle(messages.sizeInBytes());
                int startPosition = position;
                messages.foreach((Function1 & Serializable & scala.Serializable)entry -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$1(this, map, start, maxDesiredMapSize, object, entry);
                    return BoxedUnit.UNIT;
                });
                this.stats().indexBytesRead(messages.validBytes());
                if ((position += messages.validBytes()) != startPosition) continue;
                this.growBuffers(maxLogMessageSize);
            }
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return ex.value$mcZ$sp();
        }
    }

    public static final /* synthetic */ void $anonfun$cleanSegments$1(Cleaner $this, Log log$3, OffsetMap map$2, long deleteHorizonMs$2, LogSegment cleaned$1, LogSegment old) {
        boolean retainDeletes = old.lastModified() > deleteHorizonMs$2;
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning segment %s in log %s (largest timestamp %s) into %s, %s deletes.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)old.baseOffset()), log$3.name(), new Date(old.largestTimestamp()), BoxesRunTime.boxToLong((long)cleaned$1.baseOffset()), retainDeletes ? "retaining" : "discarding"})));
        $this.cleanInto(log$3.topicAndPartition(), old, cleaned$1, map$2, retainDeletes, Predef$.MODULE$.Integer2int(log$3.config().maxMessageSize()));
    }

    public static final /* synthetic */ void $anonfun$cleanInto$2(Cleaner $this, LogSegment source$1, OffsetMap map$3, boolean retainDeletes$2, LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, IntRef messagesRead$1, BooleanRef writeOriginalMessageSet$1, ArrayBuffer retainedMessages$1, byte shallowMagic$1, MessageAndOffset deepMessageAndOffset) {
        ++messagesRead$1.elem;
        if ($this.shouldRetainMessage(source$1, map$3, retainDeletes$2, deepMessageAndOffset)) {
            if (shallowMagic$1 != deepMessageAndOffset.message().magic()) {
                writeOriginalMessageSet$1.elem = false;
            }
            retainedMessages$1.$plus$eq((Object)deepMessageAndOffset);
            if (deepMessageAndOffset.message().timestamp() > maxTimestamp$1.elem) {
                maxTimestamp$1.elem = deepMessageAndOffset.message().timestamp();
                offsetOfMaxTimestamp$1.elem = deepMessageAndOffset.offset();
            }
        } else {
            writeOriginalMessageSet$1.elem = false;
        }
    }

    public static final /* synthetic */ void $anonfun$cleanInto$1(Cleaner $this, LogSegment source$1, OffsetMap map$3, boolean retainDeletes$2, LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, IntRef messagesRead$1, MessageAndOffset shallowMessageAndOffset) {
        Message shallowMessage = shallowMessageAndOffset.message();
        long shallowOffset = shallowMessageAndOffset.offset();
        int size = MessageSet$.MODULE$.entrySize(shallowMessageAndOffset.message());
        $this.stats().readMessage(size);
        CompressionCodec compressionCodec = shallowMessage.compressionCodec();
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
            if ($this.shouldRetainMessage(source$1, map$3, retainDeletes$2, shallowMessageAndOffset)) {
                ByteBufferMessageSet$.MODULE$.writeMessage($this.writeBuffer(), shallowMessage, shallowOffset);
                $this.stats().recopyMessage(size);
                if (shallowMessage.timestamp() > maxTimestamp$1.elem) {
                    maxTimestamp$1.elem = shallowMessage.timestamp();
                    offsetOfMaxTimestamp$1.elem = shallowOffset;
                }
            }
            ++messagesRead$1.elem;
        } else {
            BooleanRef writeOriginalMessageSet = BooleanRef.create((boolean)true);
            ArrayBuffer retainedMessages = new ArrayBuffer();
            byte shallowMagic = shallowMessage.magic();
            ByteBufferMessageSet$.MODULE$.deepIterator(shallowMessageAndOffset, ByteBufferMessageSet$.MODULE$.deepIterator$default$2()).foreach((Function1 & Serializable & scala.Serializable)deepMessageAndOffset -> {
                Cleaner.$anonfun$cleanInto$2($this, source$1, map$3, retainDeletes$2, maxTimestamp$1, offsetOfMaxTimestamp$1, messagesRead$1, writeOriginalMessageSet, retainedMessages, shallowMagic, deepMessageAndOffset);
                return BoxedUnit.UNIT;
            });
            if (writeOriginalMessageSet.elem) {
                ByteBufferMessageSet$.MODULE$.writeMessage($this.writeBuffer(), shallowMessage, shallowOffset);
            } else {
                $this.compressMessages($this.writeBuffer(), shallowMessage.compressionCodec(), (Seq<MessageAndOffset>)retainedMessages);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$compressMessages$4(byte magic$1, long firstAbsoluteOffset$1, LongRef offset$2, DataOutputStream output$1, MessageAndOffset messageAndOffset) {
        offset$2.elem = messageAndOffset.offset();
        long innerOffset = magic$1 > Message$.MODULE$.MagicValue_V0() ? messageAndOffset.offset() - firstAbsoluteOffset$1 : offset$2.elem;
        Message message = messageAndOffset.message();
        output$1.writeLong(innerOffset);
        output$1.writeInt(message.size());
        output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
    }

    public static final /* synthetic */ void $anonfun$compressMessages$3(CompressionCodec compressionCodec$1, Seq messageAndOffsets$1, byte magic$1, long firstAbsoluteOffset$1, LongRef offset$2, OutputStream outputStream) {
        try (DataOutputStream output = new DataOutputStream(CompressionFactory$.MODULE$.apply(compressionCodec$1, magic$1, outputStream));){
            messageAndOffsets$1.foreach((Function1 & Serializable & scala.Serializable)messageAndOffset -> {
                Cleaner.$anonfun$compressMessages$4(magic$1, firstAbsoluteOffset$1, offset$2, output, messageAndOffset);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$2(BooleanRef full$1, LogSegment segment) {
        return !full$1.elem;
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$3(Cleaner $this, Log log$2, long start$1, OffsetMap map$1, Buffer dirty$1, BooleanRef full$1, LogSegment segment) {
        block0: {
            $this.checkDone.apply((Object)log$2.topicAndPartition());
            full$1.elem = $this.buildOffsetMapForSegment(log$2.topicAndPartition(), segment, map$1, start$1, Predef$.MODULE$.Integer2int(log$2.config().maxMessageSize()));
            if (!full$1.elem) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirty$1.indexOf((Object)segment)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
        }
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(Cleaner $this, OffsetMap map$4, long start$2, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, MessageAndOffset entry) {
        Message message = entry.message();
        if (message.hasKey() && entry.offset() >= start$2) {
            if (map$4.size() < maxDesiredMapSize$1) {
                map$4.put(message.key(), entry.offset());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        }
        $this.stats().indexMessagesRead(1);
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.checkDone = checkDone;
        Logging.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq("Cleaner " + id + ": ");
        this.statsUnderlying = new Tuple2((Object)new CleanerStats(time), (Object)new CleanerStats(time));
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable & scala.Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

