/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.common.InvalidOffsetException;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.common.LongRef;
import kafka.common.TopicAndPartition;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.message.ValidationAndOffsetAssignResult;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerTopicStats$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.RecordBatchTooLargeException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r\u0015g\u0001B\u0001\u0003\u0001\u001d\u00111\u0001T8h\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u001diW\r\u001e:jGNL!!\u0007\f\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\r!\u0017N]\u000b\u0002;A\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0003S>T\u0011AI\u0001\u0005U\u00064\u0018-\u0003\u0002%?\t!a)\u001b7f\u0011!1\u0003A!A!\u0002\u0013i\u0012\u0001\u00023je\u0002B\u0001\u0002\u000b\u0001\u0003\u0002\u0004%\t!K\u0001\u0007G>tg-[4\u0016\u0003)\u0002\"a\u000b\u0017\u000e\u0003\tI!!\f\u0002\u0003\u00131{wmQ8oM&<\u0007\u0002C\u0018\u0001\u0005\u0003\u0007I\u0011\u0001\u0019\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u00022iA\u0011\u0011BM\u0005\u0003g)\u0011A!\u00168ji\"9QGLA\u0001\u0002\u0004Q\u0013a\u0001=%c!Aq\u0007\u0001B\u0001B\u0003&!&A\u0004d_:4\u0017n\u001a\u0011)\u0005YJ\u0004CA\u0005;\u0013\tY$B\u0001\u0005w_2\fG/\u001b7f\u0011!i\u0004A!a\u0001\n\u0003q\u0014!\u0004:fG>4XM]=Q_&tG/F\u0001@!\tI\u0001)\u0003\u0002B\u0015\t!Aj\u001c8h\u0011!\u0019\u0005A!a\u0001\n\u0003!\u0015!\u0005:fG>4XM]=Q_&tGo\u0018\u0013fcR\u0011\u0011'\u0012\u0005\bk\t\u000b\t\u00111\u0001@\u0011!9\u0005A!A!B\u0013y\u0014A\u0004:fG>4XM]=Q_&tG\u000f\t\u0015\u0003\rfB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IaS\u0001\ng\u000eDW\rZ;mKJ\u0004\"a\u0004'\n\u00055\u0003\"!C*dQ\u0016$W\u000f\\3s\u0011!y\u0005A!A!\u0002\u0013\u0001\u0016\u0001\u0002;j[\u0016\u0004\"aD)\n\u0005I\u0003\"\u0001\u0002+j[\u0016DQ\u0001\u0016\u0001\u0005\u0002U\u000ba\u0001P5oSRtDC\u0002,X1fS6\f\u0005\u0002,\u0001!)1d\u0015a\u0001;!)\u0001f\u0015a\u0001U!9Qh\u0015I\u0001\u0002\u0004y\u0004\"\u0002&T\u0001\u0004Y\u0005bB(T!\u0003\u0005\r\u0001\u0015\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0003\u0011awnY6\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!AY\u0011\u0002\t1\fgnZ\u0005\u0003I\u0006\u0014aa\u00142kK\u000e$\bB\u00024\u0001A\u0003%q,A\u0003m_\u000e\\\u0007\u0005C\u0004i\u0001\t\u0007I\u0011B5\u0002\u001f1\f7\u000f\u001e4mkNDW\r\u001a+j[\u0016,\u0012A\u001b\t\u0003WJl\u0011\u0001\u001c\u0006\u0003[:\fa!\u0019;p[&\u001c'BA8q\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003c\u0006\nA!\u001e;jY&\u00111\u000f\u001c\u0002\u000b\u0003R|W.[2M_:<\u0007BB;\u0001A\u0003%!.\u0001\tmCN$h\r\\;tQ\u0016$G+[7fA!)q\u000f\u0001C\u0001q\u0006a\u0011N\\5u\r&dWmU5{KR\t\u0011\u0010\u0005\u0002\nu&\u00111P\u0003\u0002\u0004\u0013:$\bbB?\u0001\u0005\u0004%\tAP\u0001\u0002i\"1q\u0010\u0001Q\u0001\n}\n!\u0001\u001e\u0011\t\u0013\u0005\r\u0001A1A\u0005\n\u0005\u0015\u0011\u0001C:fO6,g\u000e^:\u0016\u0005\u0005\u001d\u0001\u0003CA\u0005\u0003\u0017\ty!a\u0005\u000e\u00039L1!!\u0004o\u0005Y\u0019uN\\2veJ,g\u000e\u001e(bm&<\u0017M\u00197f\u001b\u0006\u0004\bc\u00011\u0002\u0012%\u0011\u0011)\u0019\t\u0004W\u0005U\u0011bAA\f\u0005\tQAj\\4TK\u001elWM\u001c;\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u000f\t\u0011b]3h[\u0016tGo\u001d\u0011\t\u0013\u0005}\u0001\u00011A\u0005\u0002\u0005\u0005\u0012A\u00058fqR|eMZ:fi6+G/\u00193bi\u0006,\"!a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b\u0005\u0003\u0019\u0019XM\u001d<fe&!\u0011QFA\u0014\u0005EaunZ(gMN,G/T3uC\u0012\fG/\u0019\u0005\n\u0003c\u0001\u0001\u0019!C\u0001\u0003g\taC\\3yi>3gm]3u\u001b\u0016$\u0018\rZ1uC~#S-\u001d\u000b\u0004c\u0005U\u0002\"C\u001b\u00020\u0005\u0005\t\u0019AA\u0012\u0011!\tI\u0004\u0001Q!\n\u0005\r\u0012a\u00058fqR|eMZ:fi6+G/\u00193bi\u0006\u0004\u0003fAA\u001cs!I\u0011q\b\u0001C\u0002\u0013\u0005\u0011\u0011I\u0001\u0012i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>tWCAA\"!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%\t\u000511m\\7n_:LA!!\u0014\u0002H\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u0007\n!\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8oA!I\u0011Q\u000b\u0001C\u0002\u0013\u0005\u0011qK\u0001\u0005i\u0006<7/\u0006\u0002\u0002ZAA\u00111LA3\u0003S\nI'\u0004\u0002\u0002^)!\u0011qLA1\u0003%IW.\\;uC\ndWMC\u0002\u0002d)\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9'!\u0018\u0003\u00075\u000b\u0007\u000fE\u0002a\u0003WJ1!!\u001cb\u0005\u0019\u0019FO]5oO\"A\u0011\u0011\u000f\u0001!\u0002\u0013\tI&A\u0003uC\u001e\u001c\b\u0005C\u0004\u0002v\u0001!\t!a\u001e\u0002\t9\fW.Z\u000b\u0003\u0003SBq!a\u001f\u0001\t\u0013\ti(\u0001\u0007m_\u0006$7+Z4nK:$8\u000fF\u00012\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007\u000b!#\u001e9eCR,Gj\\4F]\u0012|eMZ:fiR\u0019\u0011'!\"\t\u000f\u0005\u001d\u0015q\u0010a\u0001\u007f\u0005iQ.Z:tC\u001e,wJ\u001a4tKRDq!a#\u0001\t\u0013\ti(\u0001\u0006sK\u000e|g/\u001a:M_\u001eDq!a$\u0001\t\u0013\t\t*\u0001\u000biCN\u001cE.Z1o'\",H\u000fZ8x]\u001aKG.\u001a\u000b\u0003\u0003'\u00032!CAK\u0013\r\t9J\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\tY\n\u0001C\u0001\u0003;\u000b\u0001C\\;nE\u0016\u0014xJZ*fO6,g\u000e^:\u0016\u0003eDq!!)\u0001\t\u0003\ti(A\u0003dY>\u001cX\rC\u0004\u0002&\u0002!\t!a*\u0002\r\u0005\u0004\b/\u001a8e)\u0019\tI+a,\u0002@B\u00191&a+\n\u0007\u00055&AA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\t\u0003c\u000b\u0019\u000b1\u0001\u00024\u0006AQ.Z:tC\u001e,7\u000f\u0005\u0003\u00026\u0006mVBAA\\\u0015\r\tI\fB\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\ti,a.\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0011)\t\t-a)\u0011\u0002\u0003\u0007\u00111S\u0001\u000eCN\u001c\u0018n\u001a8PM\u001a\u001cX\r^:\t\u000f\u0005\u0015\u0007\u0001\"\u0003\u0002H\u0006a\u0012M\\1msj,\u0017I\u001c3WC2LG-\u0019;f\u001b\u0016\u001c8/Y4f'\u0016$H\u0003BAU\u0003\u0013D\u0001\"!-\u0002D\u0002\u0007\u00111\u0017\u0005\b\u0003\u001b\u0004A\u0011BAh\u0003A!(/[7J]Z\fG.\u001b3CsR,7\u000f\u0006\u0004\u00024\u0006E\u00171\u001b\u0005\t\u0003c\u000bY\r1\u0001\u00024\"A\u0011Q[Af\u0001\u0004\tI+\u0001\u0003j]\u001a|\u0007bBAm\u0001\u0011\u0005\u00111\\\u0001\u0005e\u0016\fG\r\u0006\u0006\u0002^\u0006\r\u0018q]Av\u0003k\u0004B!!\n\u0002`&!\u0011\u0011]A\u0014\u000551U\r^2i\t\u0006$\u0018-\u00138g_\"9\u0011Q]Al\u0001\u0004y\u0014aC:uCJ$xJ\u001a4tKRDq!!;\u0002X\u0002\u0007\u00110A\u0005nCbdUM\\4uQ\"Q\u0011Q^Al!\u0003\u0005\r!a<\u0002\u00135\f\u0007p\u00144gg\u0016$\b\u0003B\u0005\u0002r~J1!a=\u000b\u0005\u0019y\u0005\u000f^5p]\"Q\u0011q_Al!\u0003\u0005\r!a%\u0002\u001b5Lgn\u00148f\u001b\u0016\u001c8/Y4f\u0011\u001d\tY\u0010\u0001C\u0001\u0003{\fqCZ3uG\"|eMZ:fiN\u0014\u0015\u0010V5nKN$\u0018-\u001c9\u0015\t\u0005}(q\u0001\t\u0006\u0013\u0005E(\u0011\u0001\t\u0004W\t\r\u0011b\u0001B\u0003\u0005\tyA+[7fgR\fW\u000e](gMN,G\u000fC\u0004\u0003\n\u0005e\b\u0019A \u0002\u001fQ\f'oZ3u)&lWm\u001d;b[BDqA!\u0004\u0001\t\u0003\u0011y!A\fd_:4XM\u001d;U_>3gm]3u\u001b\u0016$\u0018\rZ1uCR!\u00111\u0005B\t\u0011\u001d\u0011\u0019Ba\u0003A\u0002}\naa\u001c4gg\u0016$\bb\u0002B\f\u0001\u0011%!\u0011D\u0001\u0012I\u0016dW\r^3PY\u0012\u001cVmZ7f]R\u001cHcA=\u0003\u001c!A!Q\u0004B\u000b\u0001\u0004\u0011y\"A\u0005qe\u0016$\u0017nY1uKB9\u0011B!\t\u0002\u0014\u0005M\u0015b\u0001B\u0012\u0015\tIa)\u001e8di&|g.\r\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0003E!W\r\\3uC\ndWmU3h[\u0016tGo\u001d\u000b\u0005\u0005W\u0011\u0019\u0004\u0005\u0004\u0003.\t=\u00121C\u0007\u0003\u0003CJAA!\r\u0002b\tA\u0011\n^3sC\ndW\r\u0003\u0005\u0003\u001e\t\u0015\u0002\u0019\u0001B\u0010\u0011\u0019\u00119\u0002\u0001C\u0001q\"1!\u0011\b\u0001\u0005\na\f\u0001\u0005Z3mKR,'+\u001a;f]&|g.T:Ce\u0016\f7\r[3e'\u0016<W.\u001a8ug\"1!Q\b\u0001\u0005\na\f1\u0005Z3mKR,'+\u001a;f]RLwN\\*ju\u0016\u0014%/Z1dQ\u0016$7+Z4nK:$8\u000f\u0003\u0004\u0003B\u0001!\tAP\u0001\u0005g&TX\r\u0003\u0004\u0003F\u0001!\tAP\u0001\u000fY><7\u000b^1si>3gm]3u\u0011\u001d\u0011I\u0005\u0001C\u0001\u0003C\tA\u0003\\8h\u000b:$wJ\u001a4tKRlU\r^1eCR\f\u0007B\u0002B'\u0001\u0011\u0005a(\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fC\u0004\u0003R\u0001!IAa\u0015\u0002\u00135\f\u0017PY3S_2dGCBA\n\u0005+\u0012I\u0006C\u0004\u0003X\t=\u0003\u0019A=\u0002\u00195,7o]1hKN\u001c\u0016N_3\t\u000f\tm#q\na\u0001\u007f\u00051R.\u0019=US6,7\u000f^1na&sW*Z:tC\u001e,7\u000fC\u0004\u0003`\u0001!\tA!\u0019\u0002\tI|G\u000e\u001c\u000b\u0003\u0003'AqA!\u001a\u0001\t\u0003\u00119'A\tv]\u001adWo\u001d5fI6+7o]1hKN$\u0012a\u0010\u0005\b\u0005W\u0002A\u0011AA?\u0003\u00151G.^:i\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005_\"2!\rB9\u0011\u001d\u0011\u0019B!\u001cA\u0002}B\u0001B!\u001e\u0001\t\u0003\u0011\u0011QP\u0001\u0007I\u0016dW\r^3\t\u0011\te\u0004\u0001\"\u0001\u0003\u0005w\n!\u0002\u001e:v]\u000e\fG/\u001a+p)\r\t$Q\u0010\u0005\b\u0005\u007f\u00129\b1\u0001@\u00031!\u0018M]4fi>3gm]3u\u0011!\u0011\u0019\t\u0001C\u0001\u0005\t\u0015\u0015a\u0006;sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!u)\r\t$q\u0011\u0005\b\u0005\u0013\u0013\t\t1\u0001@\u0003%qWm^(gMN,G\u000fC\u0004\u0003\u000e\u0002!\tAa\u001a\u0002\u001b1\f7\u000f\u001e$mkNDG+[7f\u0011\u001d\u0011\t\n\u0001C\u0001\u0005'\u000bQ\"Y2uSZ,7+Z4nK:$XCAA\n\u0011\u001d\u00119\n\u0001C\u0001\u00053\u000b1\u0002\\8h'\u0016<W.\u001a8ugV\u0011!1\u0014\t\u0007\u0005;\u0013i+a\u0005\u000f\t\t}%\u0011\u0016\b\u0005\u0005C\u00139+\u0004\u0002\u0003$*\u0019!Q\u0015\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011b\u0001BV\u0015\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0019\u0005_S1Aa+\u000b\u0011\u001d\u00119\n\u0001C\u0001\u0005g#bAa'\u00036\ne\u0006b\u0002B\\\u0005c\u0003\raP\u0001\u0005MJ|W\u000eC\u0004\u0003<\nE\u0006\u0019A \u0002\u0005Q|\u0007b\u0002B`\u0001\u0011\u0005#\u0011Y\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u000e\u0005\b\u0005\u000b\u0004A\u0011\u0002Bd\u00035!W\r\\3uKN+w-\\3oiR\u0019\u0011G!3\t\u0011\t-'1\u0019a\u0001\u0003'\tqa]3h[\u0016tG\u000fC\u0004\u0003P\u0002!IA!5\u0002%\u0005\u001c\u0018P\\2EK2,G/Z*fO6,g\u000e\u001e\u000b\u0004c\tM\u0007\u0002\u0003Bf\u0005\u001b\u0004\r!a\u0005\t\u0011\t]\u0007\u0001\"\u0001\u0003\u00053\fqB]3qY\u0006\u001cWmU3h[\u0016tGo\u001d\u000b\bc\tm'q\u001cBu\u0011!\u0011iN!6A\u0002\u0005M\u0011A\u00038foN+w-\\3oi\"A!\u0011\u001dBk\u0001\u0004\u0011\u0019/A\u0006pY\u0012\u001cVmZ7f]R\u001c\bC\u0002B\u0017\u0005K\f\u0019\"\u0003\u0003\u0003h\u0006\u0005$aA*fc\"Q!1\u001eBk!\u0003\u0005\r!a%\u0002'%\u001c(+Z2pm\u0016\u0014X\rZ*xCB4\u0015\u000e\\3\t\u0011\t=\b\u0001\"\u0001\u0003\u0003{\n\u0001C]3n_Z,Gj\\4NKR\u0014\u0018nY:\t\u000f\tM\b\u0001\"\u0001\u0003v\u0006Q\u0011\r\u001a3TK\u001elWM\u001c;\u0015\t\u0005M!q\u001f\u0005\t\u0005\u0017\u0014\t\u00101\u0001\u0002\u0014!I!1 \u0001\u0012\u0002\u0013\u0005!Q`\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uII*\"Aa@+\t\u0005M5\u0011A\u0016\u0003\u0007\u0007\u0001Ba!\u0002\u0004\u00105\u00111q\u0001\u0006\u0005\u0007\u0013\u0019Y!A\u0005v]\u000eDWmY6fI*\u00191Q\u0002\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u0012\r\u001d!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I1Q\u0003\u0001\u0012\u0002\u0013\u00051qC\u0001\u000fe\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019IB\u000b\u0003\u0002p\u000e\u0005\u0001\"CB\u000f\u0001E\u0005I\u0011\u0001B\u007f\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIQB!b!\t\u0001#\u0003%\tA\u0001B\u007f\u0003e\u0011X\r\u001d7bG\u0016\u001cVmZ7f]R\u001cH\u0005Z3gCVdG\u000fJ\u001a)\u0007\u0001\u0019)\u0003E\u0002\u0010\u0007OI1a!\u000b\u0011\u0005)!\bN]3bIN\fg-Z\u0004\b\u0007[\u0011\u0001\u0012AB\u0018\u0003\raun\u001a\t\u0004W\rEbAB\u0001\u0003\u0011\u0003\u0019\u0019dE\u0002\u00042!Aq\u0001VB\u0019\t\u0003\u00199\u0004\u0006\u0002\u00040!Q11HB\u0019\u0005\u0004%\t!a\u001e\u0002\u001b1{wMR5mKN+hMZ5y\u0011%\u0019yd!\r!\u0002\u0013\tI'\u0001\bM_\u001e4\u0015\u000e\\3Tk\u001a4\u0017\u000e\u001f\u0011\t\u0015\r\r3\u0011\u0007b\u0001\n\u0003\t9(A\bJ]\u0012,\u0007PR5mKN+hMZ5y\u0011%\u00199e!\r!\u0002\u0013\tI'\u0001\tJ]\u0012,\u0007PR5mKN+hMZ5yA!Q11JB\u0019\u0005\u0004%\t!a\u001e\u0002'QKW.Z%oI\u0016Dh)\u001b7f'V4g-\u001b=\t\u0013\r=3\u0011\u0007Q\u0001\n\u0005%\u0014\u0001\u0006+j[\u0016Le\u000eZ3y\r&dWmU;gM&D\b\u0005\u0003\u0006\u0004T\rE\"\u0019!C\u0001\u0003o\n\u0011\u0003R3mKR,GMR5mKN+hMZ5y\u0011%\u00199f!\r!\u0002\u0013\tI'\u0001\nEK2,G/\u001a3GS2,7+\u001e4gSb\u0004\u0003BCB.\u0007c\u0011\r\u0011\"\u0001\u0002x\u0005\t2\t\\3b]\u0016$g)\u001b7f'V4g-\u001b=\t\u0013\r}3\u0011\u0007Q\u0001\n\u0005%\u0014AE\"mK\u0006tW\r\u001a$jY\u0016\u001cVO\u001a4jq\u0002B!ba\u0019\u00042\t\u0007I\u0011AA<\u00039\u0019v/\u00199GS2,7+\u001e4gSbD\u0011ba\u001a\u00042\u0001\u0006I!!\u001b\u0002\u001fM;\u0018\r\u001d$jY\u0016\u001cVO\u001a4jq\u0002B!ba\u001b\u00042\t\u0007I\u0011AA<\u0003E\u0019E.Z1o'\",H\u000fZ8x]\u001aKG.\u001a\u0005\n\u0007_\u001a\t\u0004)A\u0005\u0003S\n!c\u00117fC:\u001c\u0006.\u001e;e_^tg)\u001b7fA!A11OB\u0019\t\u0003\u0019)(\u0001\rgS2,g.Y7f!J,g-\u001b=Ge>lwJ\u001a4tKR$Baa\u001e\u0004\u0006B!1\u0011PBA\u001d\u0011\u0019Yh! \u0011\u0007\t\u0005&\"C\u0002\u0004\u0000)\ta\u0001\u0015:fI\u00164\u0017\u0002BA7\u0007\u0007S1aa \u000b\u0011\u001d\u0011\u0019b!\u001dA\u0002}B\u0001b!#\u00042\u0011\u000511R\u0001\fY><g)\u001b7f]\u0006lW\rF\u0003\u001e\u0007\u001b\u001by\t\u0003\u0004\u001c\u0007\u000f\u0003\r!\b\u0005\b\u0005'\u00199\t1\u0001@\u0011!\u0019\u0019j!\r\u0005\u0002\rU\u0015!D5oI\u0016Dh)\u001b7f]\u0006lW\rF\u0003\u001e\u0007/\u001bI\n\u0003\u0004\u001c\u0007#\u0003\r!\b\u0005\b\u0005'\u0019\t\n1\u0001@\u0011!\u0019ij!\r\u0005\u0002\r}\u0015!\u0005;j[\u0016Le\u000eZ3y\r&dWM\\1nKR)Qd!)\u0004$\"11da'A\u0002uAqAa\u0005\u0004\u001c\u0002\u0007q\b\u0003\u0005\u0004(\u000eEB\u0011ABU\u0003]\u0001\u0018M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lW\r\u0006\u0003\u0002D\r-\u0006BB\u000e\u0004&\u0002\u0007Q\u0004\u0003\u0005\u00040\u000eEB\u0011ABY\u00039!\bN]8x\u000bb\u001cW\r\u001d;j_:$2!MBZ\u0011\u0019Y2Q\u0016a\u0001;!Q1qWB\u0019#\u0003%\ta!/\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019YLK\u0002@\u0007\u0003A!ba0\u00042E\u0005I\u0011ABa\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u001111\u0019\u0016\u0004!\u000e\u0005\u0001")
public class Log
implements KafkaMetricsGroup {
    private final File dir;
    private volatile LogConfig config;
    private volatile long recoveryPoint;
    private final Scheduler scheduler;
    private final Time time;
    private final Object lock;
    private final AtomicLong lastflushedTime;
    private final long t;
    private final ConcurrentNavigableMap<Long, LogSegment> segments;
    private volatile LogOffsetMetadata nextOffsetMetadata;
    private final TopicAndPartition topicAndPartition;
    private final scala.collection.immutable.Map<String, String> tags;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Log$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$3() {
        return Log$.MODULE$.$lessinit$greater$default$3();
    }

    public static void throwException(File file) {
        Log$.MODULE$.throwException(file);
    }

    public static TopicAndPartition parseTopicPartitionName(File file) {
        return Log$.MODULE$.parseTopicPartitionName(file);
    }

    public static File timeIndexFilename(File file, long l) {
        return Log$.MODULE$.timeIndexFilename(file, l);
    }

    public static File indexFilename(File file, long l) {
        return Log$.MODULE$.indexFilename(file, l);
    }

    public static File logFilename(File file, long l) {
        return Log$.MODULE$.logFilename(file, l);
    }

    public static String filenamePrefixFromOffset(long l) {
        return Log$.MODULE$.filenamePrefixFromOffset(l);
    }

    public static String CleanShutdownFile() {
        return Log$.MODULE$.CleanShutdownFile();
    }

    public static String SwapFileSuffix() {
        return Log$.MODULE$.SwapFileSuffix();
    }

    public static String CleanedFileSuffix() {
        return Log$.MODULE$.CleanedFileSuffix();
    }

    public static String DeletedFileSuffix() {
        return Log$.MODULE$.DeletedFileSuffix();
    }

    public static String TimeIndexFileSuffix() {
        return Log$.MODULE$.TimeIndexFileSuffix();
    }

    public static String IndexFileSuffix() {
        return Log$.MODULE$.IndexFileSuffix();
    }

    public static String LogFileSuffix() {
        return Log$.MODULE$.LogFileSuffix();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Log log = this;
        synchronized (log) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public File dir() {
        return this.dir;
    }

    public LogConfig config() {
        return this.config;
    }

    public void config_$eq(LogConfig x$1) {
        this.config = x$1;
    }

    public long recoveryPoint() {
        return this.recoveryPoint;
    }

    public void recoveryPoint_$eq(long x$1) {
        this.recoveryPoint = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private AtomicLong lastflushedTime() {
        return this.lastflushedTime;
    }

    public int initFileSize() {
        return Predef$.MODULE$.Boolean2boolean(this.config().preallocate()) ? Predef$.MODULE$.Integer2int(this.config().segmentSize()) : 0;
    }

    public long t() {
        return this.t;
    }

    private ConcurrentNavigableMap<Long, LogSegment> segments() {
        return this.segments;
    }

    public LogOffsetMetadata nextOffsetMetadata() {
        return this.nextOffsetMetadata;
    }

    public void nextOffsetMetadata_$eq(LogOffsetMetadata x$1) {
        this.nextOffsetMetadata = x$1;
    }

    public TopicAndPartition topicAndPartition() {
        return this.topicAndPartition;
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    public String name() {
        return this.dir().getName();
    }

    private void loadSegments() {
        this.dir().mkdirs();
        ObjectRef swapFiles = ObjectRef.create((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            Boolean bl;
            if (!file.canRead()) {
                throw new IOException("Could not read file " + file);
            }
            String filename = file.getName();
            if (filename.endsWith(Log$.MODULE$.DeletedFileSuffix()) || filename.endsWith(Log$.MODULE$.CleanedFileSuffix())) {
                bl = BoxesRunTime.boxToBoolean((boolean)file.delete());
            } else if (filename.endsWith(Log$.MODULE$.SwapFileSuffix())) {
                File baseName = new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.SwapFileSuffix(), ""));
                if (baseName.getPath().endsWith(Log$.MODULE$.IndexFileSuffix())) {
                    bl = BoxesRunTime.boxToBoolean((boolean)file.delete());
                } else if (baseName.getPath().endsWith(Log$.MODULE$.LogFileSuffix())) {
                    File index = new File(CoreUtils$.MODULE$.replaceSuffix(baseName.getPath(), Log$.MODULE$.LogFileSuffix(), Log$.MODULE$.IndexFileSuffix()));
                    index.delete();
                    swapFiles$1.elem = (Set)((Set)swapFiles$1.elem).$plus(file);
                    bl = BoxedUnit.UNIT;
                } else {
                    bl = BoxedUnit.UNIT;
                }
            } else {
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            Object object;
            String filename = file.getName();
            if (filename.endsWith(Log$.MODULE$.IndexFileSuffix()) || filename.endsWith(Log$.MODULE$.TimeIndexFileSuffix())) {
                File logFile;
                File file2 = logFile = filename.endsWith(Log$.MODULE$.TimeIndexFileSuffix()) ? new File(file.getAbsolutePath().replace(Log$.MODULE$.TimeIndexFileSuffix(), Log$.MODULE$.LogFileSuffix())) : new File(file.getAbsolutePath().replace(Log$.MODULE$.IndexFileSuffix(), Log$.MODULE$.LogFileSuffix()));
                if (!logFile.exists()) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Found an orphaned index file, %s, with no corresponding log file.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                    object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                } else {
                    object = BoxedUnit.UNIT;
                }
            } else if (filename.endsWith(Log$.MODULE$.LogFileSuffix())) {
                Object object2;
                long start = new StringOps(Predef$.MODULE$.augmentString(filename.substring(0, filename.length() - Log$.MODULE$.LogFileSuffix().length()))).toLong();
                File indexFile = Log$.MODULE$.indexFilename(this.dir(), start);
                File timeIndexFile = Log$.MODULE$.timeIndexFilename(this.dir(), start);
                boolean indexFileExists = indexFile.exists();
                LogSegment segment = new LogSegment(this.dir(), start, Predef$.MODULE$.Integer2int(this.config().indexInterval()), Predef$.MODULE$.Integer2int(this.config().maxIndexSize()), this.config().randomSegmentJitter(), $this.time, true, LogSegment$.MODULE$.$lessinit$greater$default$8(), LogSegment$.MODULE$.$lessinit$greater$default$9());
                if (indexFileExists) {
                    try {
                        segment.index().sanityCheck();
                        segment.timeIndex().sanityCheck();
                        object2 = BoxedUnit.UNIT;
                    }
                    catch (IllegalArgumentException e) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a corrupted index file due to ", "}. deleting ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage(), timeIndexFile.getAbsolutePath()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and rebuilding index..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indexFile.getAbsolutePath()})));
                        indexFile.delete();
                        timeIndexFile.delete();
                        object2 = BoxesRunTime.boxToInteger((int)segment.recover(Predef$.MODULE$.Integer2int(this.config().maxMessageSize())));
                    }
                } else {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Could not find index file corresponding to log file %s, rebuilding index...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{segment.log().file().getAbsolutePath()})));
                    object2 = BoxesRunTime.boxToInteger((int)segment.recover(Predef$.MODULE$.Integer2int(this.config().maxMessageSize())));
                }
                object = this.segments().put(Predef$.MODULE$.long2Long(start), segment);
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        ((Set)swapFiles.elem).foreach((Function1 & Serializable & scala.Serializable)swapFile -> {
            Log.$anonfun$loadSegments$8(this, swapFile);
            return BoxedUnit.UNIT;
        });
        if (this.logSegments().isEmpty()) {
            this.segments().put(Predef$.MODULE$.long2Long(0L), new LogSegment(this.dir(), 0L, Predef$.MODULE$.Integer2int(this.config().indexInterval()), Predef$.MODULE$.Integer2int(this.config().maxIndexSize()), this.config().randomSegmentJitter(), this.time, false, this.initFileSize(), Predef$.MODULE$.Boolean2boolean(this.config().preallocate())));
        } else {
            this.recoverLog();
            this.activeSegment().index().resize(Predef$.MODULE$.Integer2int(this.config().maxIndexSize()));
            this.activeSegment().timeIndex().resize(Predef$.MODULE$.Integer2int(this.config().maxIndexSize()));
        }
    }

    private void updateLogEndOffset(long messageOffset) {
        this.nextOffsetMetadata_$eq(new LogOffsetMetadata(messageOffset, this.activeSegment().baseOffset(), (int)this.activeSegment().size()));
    }

    private void recoverLog() {
        if (this.hasCleanShutdownFile()) {
            this.recoveryPoint_$eq(this.activeSegment().nextOffset());
            return;
        }
        Iterator unflushed = this.logSegments(this.recoveryPoint(), Long.MAX_VALUE).iterator();
        while (unflushed.hasNext()) {
            int truncatedBytes;
            int n;
            LogSegment curr = (LogSegment)unflushed.next();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Recovering unflushed segment %d in log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)curr.baseOffset()), this.name()})));
            try {
                n = curr.recover(Predef$.MODULE$.Integer2int(this.config().maxMessageSize()));
            }
            catch (InvalidOffsetException e) {
                long startOffset = curr.baseOffset();
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Found invalid offset during recovery for log " + this.dir().getName() + ". Deleting the corrupt segment and " + "creating an empty one with starting offset " + startOffset);
                n = curr.truncateTo(startOffset);
            }
            if ((truncatedBytes = n) <= 0) continue;
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Corruption found in segment %d of log %s, truncating to offset %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)curr.baseOffset()), this.name(), BoxesRunTime.boxToLong((long)curr.nextOffset())})));
            unflushed.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                this.deleteSegment(segment);
                return BoxedUnit.UNIT;
            });
        }
    }

    private boolean hasCleanShutdownFile() {
        return new File(this.dir().getParentFile(), Log$.MODULE$.CleanShutdownFile()).exists();
    }

    public int numberOfSegments() {
        return this.segments().size();
    }

    public void close() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing log " + this.name());
        Object object = this.lock();
        synchronized (object) {
            this.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
        }
    }

    public LogAppendInfo append(ByteBufferMessageSet messages, boolean assignOffsets) {
        LogAppendInfo logAppendInfo;
        LogAppendInfo appendInfo = this.analyzeAndValidateMessageSet(messages);
        if (appendInfo.shallowCount() == 0) {
            return appendInfo;
        }
        ObjectRef validMessages = ObjectRef.create((Object)this.trimInvalidBytes(messages, appendInfo));
        try {
            Object object = this.lock();
            synchronized (object) {
                if (assignOffsets) {
                    LongRef offset = new LongRef(this.nextOffsetMetadata().messageOffset());
                    appendInfo.firstOffset_$eq(offset.value());
                    long now = this.time.milliseconds();
                    ValidationAndOffsetAssignResult validateAndOffsetAssignResult = this.liftedTree1$1(appendInfo, validMessages, offset, now);
                    validMessages.elem = validateAndOffsetAssignResult.validatedMessages();
                    appendInfo.maxTimestamp_$eq(validateAndOffsetAssignResult.maxTimestamp());
                    appendInfo.offsetOfMaxTimestamp_$eq(validateAndOffsetAssignResult.offsetOfMaxTimestamp());
                    appendInfo.lastOffset_$eq(offset.value() - 1L);
                    TimestampType timestampType = this.config().messageTimestampType();
                    TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
                    if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                        appendInfo.logAppendTime_$eq(now);
                    }
                    if (validateAndOffsetAssignResult.messageSizeMaybeChanged()) {
                        ((ByteBufferMessageSet)validMessages.elem).shallowIterator().foreach((Function1 & Serializable & scala.Serializable)messageAndOffset -> {
                            Log.$anonfun$append$1(this, messages, messageAndOffset);
                            return BoxedUnit.UNIT;
                        });
                    }
                } else if (!appendInfo.offsetsMonotonic() || appendInfo.firstOffset() < this.nextOffsetMetadata().messageOffset()) {
                    throw new IllegalArgumentException("Out of order offsets found in " + messages);
                }
                if (((ByteBufferMessageSet)validMessages.elem).sizeInBytes() > Predef$.MODULE$.Integer2int(this.config().segmentSize())) {
                    throw new RecordBatchTooLargeException(new StringOps(Predef$.MODULE$.augmentString("Message set size is %d bytes which exceeds the maximum configured segment size of %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((ByteBufferMessageSet)validMessages.elem).sizeInBytes()), this.config().segmentSize()})));
                }
                LogSegment segment = this.maybeRoll(((ByteBufferMessageSet)validMessages.elem).sizeInBytes(), appendInfo.maxTimestamp());
                segment.append(appendInfo.firstOffset(), appendInfo.maxTimestamp(), appendInfo.offsetOfMaxTimestamp(), (ByteBufferMessageSet)validMessages.elem);
                this.updateLogEndOffset(appendInfo.lastOffset() + 1L);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Appended message set to log %s with first offset: %d, next offset: %d, and messages: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToLong((long)appendInfo.firstOffset()), BoxesRunTime.boxToLong((long)this.nextOffsetMetadata().messageOffset()), (ByteBufferMessageSet)validMessages$1.elem})));
                if (this.unflushedMessages() >= Predef$.MODULE$.Long2long(this.config().flushInterval())) {
                    this.flush();
                }
                LogAppendInfo logAppendInfo2 = appendInfo;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl37 : MonitorExitStatement: MONITOREXIT : var5_5
                logAppendInfo = logAppendInfo2;
            }
        }
        catch (IOException e) {
            throw new KafkaStorageException(new StringOps(Predef$.MODULE$.augmentString("I/O exception in append to log '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})), e);
        }
        return logAppendInfo;
    }

    public boolean append$default$2() {
        return true;
    }

    private LogAppendInfo analyzeAndValidateMessageSet(ByteBufferMessageSet messages) {
        IntRef shallowMessageCount = IntRef.create((int)0);
        IntRef validBytesCount = IntRef.create((int)0);
        scala.runtime.LongRef firstOffset = scala.runtime.LongRef.create((long)-1L);
        scala.runtime.LongRef lastOffset = scala.runtime.LongRef.create((long)-1L);
        ObjectRef sourceCodec = ObjectRef.create((Object)NoCompressionCodec$.MODULE$);
        BooleanRef monotonic = BooleanRef.create((boolean)true);
        scala.runtime.LongRef maxTimestamp = scala.runtime.LongRef.create((long)Message$.MODULE$.NoTimestamp());
        scala.runtime.LongRef offsetOfMaxTimestamp = scala.runtime.LongRef.create((long)-1L);
        messages.shallowIterator().foreach((Function1 & Serializable & scala.Serializable)messageAndOffset -> {
            Log.$anonfun$analyzeAndValidateMessageSet$1(this, messages, shallowMessageCount, validBytesCount, firstOffset, lastOffset, sourceCodec, monotonic, maxTimestamp, offsetOfMaxTimestamp, messageAndOffset);
            return BoxedUnit.UNIT;
        });
        CompressionCodec targetCodec = BrokerCompressionCodec$.MODULE$.getTargetCompressionCodec(this.config().compressionType(), (CompressionCodec)sourceCodec.elem);
        return new LogAppendInfo(firstOffset.elem, lastOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, Message$.MODULE$.NoTimestamp(), (CompressionCodec)sourceCodec.elem, targetCodec, shallowMessageCount.elem, validBytesCount.elem, monotonic.elem);
    }

    private ByteBufferMessageSet trimInvalidBytes(ByteBufferMessageSet messages, LogAppendInfo info) {
        ByteBufferMessageSet byteBufferMessageSet;
        int messageSetValidBytes = info.validBytes();
        if (messageSetValidBytes < 0) {
            throw new CorruptRecordException("Illegal length of message set " + messageSetValidBytes + " Message set cannot be appended to log. Possible causes are corrupted produce requests");
        }
        if (messageSetValidBytes == messages.sizeInBytes()) {
            byteBufferMessageSet = messages;
        } else {
            ByteBuffer validByteBuffer = messages.buffer().duplicate();
            validByteBuffer.limit(messageSetValidBytes);
            byteBufferMessageSet = new ByteBufferMessageSet(validByteBuffer);
        }
        return byteBufferMessageSet;
    }

    public FetchDataInfo read(long startOffset, int maxLength, Option<Object> maxOffset, boolean minOneMessage) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Reading %d bytes from offset %d in log %s of length %d bytes")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxLength), BoxesRunTime.boxToLong((long)startOffset), this.name(), BoxesRunTime.boxToLong((long)this.size())})));
        LogOffsetMetadata currentNextOffsetMetadata = this.nextOffsetMetadata();
        long next = currentNextOffsetMetadata.messageOffset();
        if (startOffset == next) {
            return new FetchDataInfo(currentNextOffsetMetadata, MessageSet$.MODULE$.Empty(), FetchDataInfo$.MODULE$.apply$default$3());
        }
        Map.Entry entry = this.segments().floorEntry(Predef$.MODULE$.long2Long(startOffset));
        if (startOffset > next || entry == null) {
            throw new OffsetOutOfRangeException(new StringOps(Predef$.MODULE$.augmentString("Request for offset %d but we only have log segments in the range %d to %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startOffset), this.segments().firstKey(), BoxesRunTime.boxToLong((long)next)})));
        }
        while (entry != null) {
            long l;
            Map.Entry entry2 = entry;
            Map.Entry entry3 = this.segments().lastEntry();
            if (!(entry2 != null ? !((Object)entry2).equals(entry3) : entry3 != null)) {
                long exposedPos = this.nextOffsetMetadata().relativePositionInSegment();
                Map.Entry entry4 = entry;
                Map.Entry entry5 = this.segments().lastEntry();
                l = (entry4 == null ? entry5 != null : !((Object)entry4).equals(entry5)) ? ((LogSegment)entry.getValue()).size() : exposedPos;
            } else {
                l = ((LogSegment)entry.getValue()).size();
            }
            long maxPosition = l;
            FetchDataInfo fetchInfo = ((LogSegment)entry.getValue()).read(startOffset, maxOffset, maxLength, maxPosition, minOneMessage);
            if (fetchInfo == null) {
                entry = this.segments().higherEntry(entry.getKey());
                continue;
            }
            return fetchInfo;
        }
        return new FetchDataInfo(this.nextOffsetMetadata(), MessageSet$.MODULE$.Empty(), FetchDataInfo$.MODULE$.apply$default$3());
    }

    public Option<Object> read$default$3() {
        return None$.MODULE$;
    }

    public boolean read$default$4() {
        return false;
    }

    public Option<TimestampOffset> fetchOffsetsByTimestamp(long targetTimestamp) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching offset for timestamp ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)targetTimestamp)})));
        if (this.config().messageFormatVersion().$less(KAFKA_0_10_0_IV0$.MODULE$) && targetTimestamp != -2L && targetTimestamp != -1L) {
            throw new UnsupportedForMessageFormatException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot search offsets based on timestamp because message format version "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for partition ", " is ", " which is earlier than the minimum "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition(), this.config().messageFormatVersion()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"required version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KAFKA_0_10_0_IV0$.MODULE$})));
        }
        Buffer segmentsCopy = this.logSegments().toBuffer();
        if (targetTimestamp == -2L) {
            return new Some((Object)new TimestampOffset(Message$.MODULE$.NoTimestamp(), ((LogSegment)segmentsCopy.head()).baseOffset()));
        }
        if (targetTimestamp == -1L) {
            return new Some((Object)new TimestampOffset(Message$.MODULE$.NoTimestamp(), this.logEndOffset()));
        }
        Buffer earlierSegs = (Buffer)segmentsCopy.takeWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Log.$anonfun$fetchOffsetsByTimestamp$2(targetTimestamp, x$2)));
        None$ targetSeg = earlierSegs.length() < segmentsCopy.length() ? new Some(segmentsCopy.apply(earlierSegs.length())) : None$.MODULE$;
        return targetSeg.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.findOffsetByTimestamp(targetTimestamp));
    }

    public LogOffsetMetadata convertToOffsetMetadata(long offset) {
        LogOffsetMetadata logOffsetMetadata;
        try {
            FetchDataInfo fetchDataInfo = this.read(offset, 1, this.read$default$3(), this.read$default$4());
            logOffsetMetadata = fetchDataInfo.fetchOffsetMetadata();
        }
        catch (OffsetOutOfRangeException e) {
            logOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        }
        return logOffsetMetadata;
    }

    private int deleteOldSegments(Function1<LogSegment, Object> predicate) {
        int n;
        Object object = this.lock();
        synchronized (object) {
            Iterable<LogSegment> deletable = this.deletableSegments(predicate);
            int numToDelete = deletable.size();
            if (numToDelete > 0) {
                Object object2 = this.segments().size() == numToDelete ? this.roll() : BoxedUnit.UNIT;
                deletable.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    this.deleteSegment(x$4);
                    return BoxedUnit.UNIT;
                });
            }
            n = numToDelete;
        }
        return n;
    }

    private Iterable<LogSegment> deletableSegments(Function1<LogSegment, Object> predicate) {
        Map.Entry lastEntry = this.segments().lastEntry();
        return lastEntry == null ? (Iterable)Seq$.MODULE$.empty() : (Iterable)this.logSegments().takeWhile((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Log.$anonfun$deletableSegments$1(predicate, lastEntry, s)));
    }

    public int deleteOldSegments() {
        if (!this.config().delete()) {
            return 0;
        }
        return this.deleteRetenionMsBreachedSegments() + this.deleteRetentionSizeBreachedSegments();
    }

    private int deleteRetenionMsBreachedSegments() {
        if (Predef$.MODULE$.Long2long(this.config().retentionMs()) < 0L) {
            return 0;
        }
        long startMs = this.time.milliseconds();
        return this.deleteOldSegments((Function1<LogSegment, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Log.$anonfun$deleteRetenionMsBreachedSegments$1(this, startMs, x$5)));
    }

    private int deleteRetentionSizeBreachedSegments() {
        if (Predef$.MODULE$.Long2long(this.config().retentionSize()) < 0L || this.size() < Predef$.MODULE$.Long2long(this.config().retentionSize())) {
            return 0;
        }
        scala.runtime.LongRef diff = scala.runtime.LongRef.create((long)(this.size() - Predef$.MODULE$.Long2long(this.config().retentionSize())));
        return this.deleteOldSegments((Function1<LogSegment, Object>)(Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)Log.shouldDelete$1(segment, diff)));
    }

    public long size() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.logSegments().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long logStartOffset() {
        return ((LogSegment)this.logSegments().head()).baseOffset();
    }

    public LogOffsetMetadata logEndOffsetMetadata() {
        return this.nextOffsetMetadata();
    }

    public long logEndOffset() {
        return this.nextOffsetMetadata().messageOffset();
    }

    private LogSegment maybeRoll(int messagesSize, long maxTimestampInMessages) {
        LogSegment logSegment;
        long now;
        boolean reachedRollMs;
        LogSegment segment = this.activeSegment();
        boolean bl = reachedRollMs = segment.timeWaitedForRoll(now = this.time.milliseconds(), maxTimestampInMessages) > Predef$.MODULE$.Long2long(this.config().segmentMs()) - segment.rollJitterMs();
        if (segment.size() > (long)(Predef$.MODULE$.Integer2int(this.config().segmentSize()) - messagesSize) || segment.size() > 0L && reachedRollMs || segment.index().isFull() || segment.timeIndex().isFull()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling new log segment in ", " (log_size = ", "/", "}, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToLong((long)segment.size()), this.config().segmentSize()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"index_size = ", "/", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)segment.index().entries()), BoxesRunTime.boxToInteger((int)segment.index().maxEntries())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time_index_size = ", "/", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)segment.timeIndex().entries()), BoxesRunTime.boxToInteger((int)segment.timeIndex().maxEntries())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inactive_time_ms = ", "/", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)segment.timeWaitedForRoll(now, maxTimestampInMessages)), BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(this.config().segmentMs()) - segment.rollJitterMs()))})));
            logSegment = this.roll();
        } else {
            logSegment = segment;
        }
        return logSegment;
    }

    public LogSegment roll() {
        LogSegment logSegment;
        long start = this.time.nanoseconds();
        Object object = this.lock();
        synchronized (object) {
            long newOffset = this.logEndOffset();
            File logFile = Log$.MODULE$.logFilename(this.dir(), newOffset);
            File indexFile = Log$.MODULE$.indexFilename(this.dir(), newOffset);
            File timeIndexFile = Log$.MODULE$.timeIndexFilename(this.dir(), newOffset);
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{logFile, indexFile, timeIndexFile})).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.exists())).foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Log.$anonfun$roll$2(this, file)));
            Map.Entry entry = this.segments().lastEntry();
            if (entry == null) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                LogSegment seg = (LogSegment)entry.getValue();
                seg.onBecomeInactiveSegment();
                seg.index().trimToValidSize();
                seg.timeIndex().trimToValidSize();
                seg.log().trim();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            LogSegment segment = new LogSegment(this.dir(), newOffset, Predef$.MODULE$.Integer2int(this.config().indexInterval()), Predef$.MODULE$.Integer2int(this.config().maxIndexSize()), this.config().randomSegmentJitter(), this.time, false, this.initFileSize(), Predef$.MODULE$.Boolean2boolean(this.config().preallocate()));
            LogSegment prev = this.addSegment(segment);
            if (prev != null) {
                throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Trying to roll a new log segment for topic partition %s with start offset %d while it already exists.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToLong((long)newOffset)})));
            }
            this.updateLogEndOffset(this.nextOffsetMetadata().messageOffset());
            this.scheduler.schedule("flush-log", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.flush(newOffset), 0L, this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Rolled new log segment for '" + this.name() + new StringOps(Predef$.MODULE$.augmentString("' in %.0f ms.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)(System.nanoTime() - start) / 1000000.0))})));
            logSegment = segment;
        }
        return logSegment;
    }

    public long unflushedMessages() {
        return this.logEndOffset() - this.recoveryPoint();
    }

    public void flush() {
        this.flush(this.logEndOffset());
    }

    public void flush(long offset) {
        if (offset <= this.recoveryPoint()) {
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Flushing log '" + this.name() + " up to offset " + offset + ", last flushed: " + this.lastFlushTime() + " current time: " + $this.time.milliseconds() + " unflushed = " + this.unflushedMessages());
        this.logSegments(this.recoveryPoint(), offset).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            segment.flush();
            return BoxedUnit.UNIT;
        });
        Object object = this.lock();
        synchronized (object) {
            if (offset > this.recoveryPoint()) {
                this.recoveryPoint_$eq(offset);
                this.lastflushedTime().set(this.time.milliseconds());
            }
        }
    }

    public void delete() {
        Object object = this.lock();
        synchronized (object) {
            this.removeLogMetrics();
            this.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.delete();
                return BoxedUnit.UNIT;
            });
            this.segments().clear();
            Utils.delete((File)this.dir());
        }
    }

    public void truncateTo(long targetOffset) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Truncating log %s to offset %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToLong((long)targetOffset)})));
        if (targetOffset < 0L) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Cannot truncate to a negative offset (%d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)targetOffset)})));
        }
        if (targetOffset > this.logEndOffset()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Truncating %s to %d has no effect as the largest offset in the log is %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToLong((long)targetOffset), BoxesRunTime.boxToLong((long)(this.logEndOffset() - 1L))})));
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            if (((LogSegment)this.segments().firstEntry().getValue()).baseOffset() > targetOffset) {
                this.truncateFullyAndStartAt(targetOffset);
            } else {
                Iterable deletable = (Iterable)this.logSegments().filter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)Log.$anonfun$truncateTo$3(targetOffset, segment)));
                deletable.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                    this.deleteSegment(x$8);
                    return BoxedUnit.UNIT;
                });
                this.activeSegment().truncateTo(targetOffset);
                this.updateLogEndOffset(targetOffset);
                this.recoveryPoint_$eq(package$.MODULE$.min(targetOffset, this.recoveryPoint()));
            }
        }
    }

    public void truncateFullyAndStartAt(long newOffset) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Truncate and start log '" + this.name() + "' to " + newOffset);
        Object object = this.lock();
        synchronized (object) {
            List segmentsToDelete = this.logSegments().toList();
            segmentsToDelete.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                this.deleteSegment(x$9);
                return BoxedUnit.UNIT;
            });
            this.addSegment(new LogSegment(this.dir(), newOffset, Predef$.MODULE$.Integer2int(this.config().indexInterval()), Predef$.MODULE$.Integer2int(this.config().maxIndexSize()), this.config().randomSegmentJitter(), this.time, false, this.initFileSize(), Predef$.MODULE$.Boolean2boolean(this.config().preallocate())));
            this.updateLogEndOffset(newOffset);
            this.recoveryPoint_$eq(package$.MODULE$.min(newOffset, this.recoveryPoint()));
        }
    }

    public long lastFlushTime() {
        return this.lastflushedTime().get();
    }

    public LogSegment activeSegment() {
        return (LogSegment)this.segments().lastEntry().getValue();
    }

    public Iterable<LogSegment> logSegments() {
        return JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(this.segments().values());
    }

    public Iterable<LogSegment> logSegments(long from, long to) {
        Iterable iterable;
        Object object = this.lock();
        synchronized (object) {
            Long floor = this.segments().floorKey(Predef$.MODULE$.long2Long(from));
            iterable = floor == null ? JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(this.segments().headMap((Object)Predef$.MODULE$.long2Long(to)).values()) : JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(this.segments().subMap((Object)floor, true, (Object)Predef$.MODULE$.long2Long(to), false).values());
        }
        return iterable;
    }

    public String toString() {
        return "Log(" + this.dir() + ")";
    }

    private void deleteSegment(LogSegment segment) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Scheduling log segment %d for log %s for deletion.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)segment.baseOffset()), this.name()})));
        Object object = this.lock();
        synchronized (object) {
            this.segments().remove(BoxesRunTime.boxToLong((long)segment.baseOffset()));
            this.asyncDeleteSegment(segment);
        }
    }

    private void asyncDeleteSegment(LogSegment segment) {
        segment.changeFileSuffixes("", Log$.MODULE$.DeletedFileSuffix());
        this.scheduler.schedule("delete-file", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.deleteSeg$1(segment), Predef$.MODULE$.Long2long(this.config().fileDeleteDelayMs()), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void replaceSegments(LogSegment newSegment, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile) {
        Object object = this.lock();
        synchronized (object) {
            if (!isRecoveredSwapFile) {
                newSegment.changeFileSuffixes(Log$.MODULE$.CleanedFileSuffix(), Log$.MODULE$.SwapFileSuffix());
            }
            this.addSegment(newSegment);
            oldSegments.foreach((Function1 & Serializable & scala.Serializable)seg -> {
                Log.$anonfun$replaceSegments$1(this, newSegment, seg);
                return BoxedUnit.UNIT;
            });
            newSegment.changeFileSuffixes(Log$.MODULE$.SwapFileSuffix(), "");
        }
    }

    public boolean replaceSegments$default$3() {
        return false;
    }

    public void removeLogMetrics() {
        this.removeMetric("NumLogSegments", (Map<String, String>)this.tags());
        this.removeMetric("LogStartOffset", (Map<String, String>)this.tags());
        this.removeMetric("LogEndOffset", (Map<String, String>)this.tags());
        this.removeMetric("Size", (Map<String, String>)this.tags());
    }

    public LogSegment addSegment(LogSegment segment) {
        return this.segments().put(Predef$.MODULE$.long2Long(segment.baseOffset()), segment);
    }

    public static final /* synthetic */ void $anonfun$loadSegments$8(Log $this, File swapFile) {
        File logFile = new File(CoreUtils$.MODULE$.replaceSuffix(swapFile.getPath(), Log$.MODULE$.SwapFileSuffix(), ""));
        String fileName = logFile.getName();
        long startOffset = new StringOps(Predef$.MODULE$.augmentString(fileName.substring(0, fileName.length() - Log$.MODULE$.LogFileSuffix().length()))).toLong();
        File indexFile = new File(CoreUtils$.MODULE$.replaceSuffix(logFile.getPath(), Log$.MODULE$.LogFileSuffix(), Log$.MODULE$.IndexFileSuffix()) + Log$.MODULE$.SwapFileSuffix());
        OffsetIndex index = new OffsetIndex(indexFile, startOffset, Predef$.MODULE$.Integer2int($this.config().maxIndexSize()));
        File timeIndexFile = new File(CoreUtils$.MODULE$.replaceSuffix(logFile.getPath(), Log$.MODULE$.LogFileSuffix(), Log$.MODULE$.TimeIndexFileSuffix()) + Log$.MODULE$.SwapFileSuffix());
        TimeIndex timeIndex = new TimeIndex(timeIndexFile, startOffset, Predef$.MODULE$.Integer2int($this.config().maxIndexSize()));
        LogSegment swapSegment = new LogSegment(new FileMessageSet(swapFile), index, timeIndex, startOffset, Predef$.MODULE$.Integer2int($this.config().indexInterval()), $this.config().randomSegmentJitter(), $this.time);
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Found log file %s from interrupted swap operation, repairing.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{swapFile.getPath()})));
        swapSegment.recover(Predef$.MODULE$.Integer2int($this.config().maxMessageSize()));
        Iterable<LogSegment> oldSegments = $this.logSegments(swapSegment.baseOffset(), swapSegment.nextOffset());
        $this.replaceSegments(swapSegment, (Seq<LogSegment>)oldSegments.toSeq(), true);
    }

    private final ValidationAndOffsetAssignResult liftedTree1$1(LogAppendInfo appendInfo$1, ObjectRef validMessages$1, LongRef offset$1, long now$1) {
        ValidationAndOffsetAssignResult validationAndOffsetAssignResult;
        try {
            validationAndOffsetAssignResult = ((ByteBufferMessageSet)validMessages$1.elem).validateMessagesAndAssignOffsets(offset$1, now$1, appendInfo$1.sourceCodec(), appendInfo$1.targetCodec(), this.config().compact(), this.config().messageFormatVersion().messageFormatVersion(), this.config().messageTimestampType(), this.config().messageTimestampDifferenceMaxMs());
        }
        catch (IOException e) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Error in validating messages while appending to log '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})), e);
        }
        return validationAndOffsetAssignResult;
    }

    public static final /* synthetic */ void $anonfun$append$1(Log $this, ByteBufferMessageSet messages$1, MessageAndOffset messageAndOffset) {
        if (MessageSet$.MODULE$.entrySize(messageAndOffset.message()) > Predef$.MODULE$.Integer2int($this.config().maxMessageSize())) {
            BrokerTopicStats$.MODULE$.getBrokerTopicStats($this.topicAndPartition().topic()).bytesRejectedRate().mark((long)messages$1.sizeInBytes());
            BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesRejectedRate().mark((long)messages$1.sizeInBytes());
            throw new RecordTooLargeException(new StringOps(Predef$.MODULE$.augmentString("Message size is %d bytes which exceeds the maximum configured message size of %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)MessageSet$.MODULE$.entrySize(messageAndOffset.message())), $this.config().maxMessageSize()})));
        }
    }

    public static final /* synthetic */ void $anonfun$analyzeAndValidateMessageSet$1(Log $this, ByteBufferMessageSet messages$2, IntRef shallowMessageCount$1, IntRef validBytesCount$1, scala.runtime.LongRef firstOffset$1, scala.runtime.LongRef lastOffset$1, ObjectRef sourceCodec$1, BooleanRef monotonic$1, scala.runtime.LongRef maxTimestamp$1, scala.runtime.LongRef offsetOfMaxTimestamp$1, MessageAndOffset messageAndOffset) {
        block4: {
            CompressionCodec messageCodec;
            if (firstOffset$1.elem < 0L) {
                firstOffset$1.elem = messageAndOffset.offset();
            }
            if (lastOffset$1.elem >= messageAndOffset.offset()) {
                monotonic$1.elem = false;
            }
            lastOffset$1.elem = messageAndOffset.offset();
            Message m = messageAndOffset.message();
            int messageSize = MessageSet$.MODULE$.entrySize(m);
            if (messageSize > Predef$.MODULE$.Integer2int($this.config().maxMessageSize())) {
                BrokerTopicStats$.MODULE$.getBrokerTopicStats($this.topicAndPartition().topic()).bytesRejectedRate().mark((long)messages$2.sizeInBytes());
                BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesRejectedRate().mark((long)messages$2.sizeInBytes());
                throw new RecordTooLargeException(new StringOps(Predef$.MODULE$.augmentString("Message size is %d bytes which exceeds the maximum configured message size of %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messageSize), $this.config().maxMessageSize()})));
            }
            m.ensureValid();
            if (m.timestamp() > maxTimestamp$1.elem) {
                maxTimestamp$1.elem = m.timestamp();
                offsetOfMaxTimestamp$1.elem = lastOffset$1.elem;
            }
            ++shallowMessageCount$1.elem;
            validBytesCount$1.elem += messageSize;
            CompressionCodec compressionCodec = messageCodec = m.compressionCodec();
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$))) break block4;
            sourceCodec$1.elem = messageCodec;
        }
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetsByTimestamp$2(long targetTimestamp$1, LogSegment x$2) {
        return x$2.largestTimestamp() < targetTimestamp$1;
    }

    public static final /* synthetic */ boolean $anonfun$deletableSegments$1(Function1 predicate$1, Map.Entry lastEntry$1, LogSegment s) {
        return BoxesRunTime.unboxToBoolean((Object)predicate$1.apply((Object)s)) && (s.baseOffset() != ((LogSegment)lastEntry$1.getValue()).baseOffset() || s.size() > 0L);
    }

    public static final /* synthetic */ boolean $anonfun$deleteRetenionMsBreachedSegments$1(Log $this, long startMs$1, LogSegment x$5) {
        return startMs$1 - x$5.largestTimestamp() > Predef$.MODULE$.Long2long($this.config().retentionMs());
    }

    private static final boolean shouldDelete$1(LogSegment segment, scala.runtime.LongRef diff$1) {
        boolean bl;
        if (diff$1.elem - segment.size() >= 0L) {
            diff$1.elem -= segment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$roll$2(Log $this, File file) {
        $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Newly rolled segment file " + file.getName() + " already exists; deleting it first");
        return file.delete();
    }

    public static final /* synthetic */ boolean $anonfun$truncateTo$3(long targetOffset$1, LogSegment segment) {
        return segment.baseOffset() > targetOffset$1;
    }

    private final void deleteSeg$1(LogSegment segment$4) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deleting segment %d from log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)segment$4.baseOffset()), this.name()})));
        segment$4.delete();
    }

    public static final /* synthetic */ void $anonfun$replaceSegments$1(Log $this, LogSegment newSegment$1, LogSegment seg) {
        Object object = seg.baseOffset() != newSegment$1.baseOffset() ? $this.segments().remove(BoxesRunTime.boxToLong((long)seg.baseOffset())) : BoxedUnit.UNIT;
        $this.asyncDeleteSegment(seg);
    }

    public Log(File dir, LogConfig config, long recoveryPoint, Scheduler scheduler, Time time) {
        this.dir = dir;
        this.config = config;
        this.recoveryPoint = recoveryPoint;
        this.scheduler = scheduler;
        this.time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.lock = new Object();
        this.lastflushedTime = new AtomicLong(time.milliseconds());
        this.t = time.milliseconds();
        this.segments = new ConcurrentSkipListMap<Long, LogSegment>();
        this.loadSegments();
        this.nextOffsetMetadata = new LogOffsetMetadata(this.activeSegment().nextOffset(), this.activeSegment().baseOffset(), (int)this.activeSegment().size());
        this.topicAndPartition = Log$.MODULE$.parseTopicPartitionName(dir);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Completed load of log %s with %d log segments and log end offset %d in %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToInteger((int)this.segments().size()), BoxesRunTime.boxToLong((long)this.logEndOffset()), BoxesRunTime.boxToLong((long)($this.time.milliseconds() - this.t()))})));
        this.tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.topicAndPartition().topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.topicAndPartition().partition())).toString())}));
        this.newGauge("NumLogSegments", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public int value() {
                return this.$outer.numberOfSegments();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("LogStartOffset", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public long value() {
                return this.$outer.logStartOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("LogEndOffset", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public long value() {
                return this.$outer.logEndOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("Size", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public long value() {
                return this.$outer.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
    }
}

