/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tEb\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u001diW\r\u001e:jGNL!!\u0007\f\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\u0019\u0019wN\u001c4jOV\tQ\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\ti1\t\\3b]\u0016\u00148i\u001c8gS\u001eD\u0001B\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\bG>tg-[4!\u0011!!\u0003A!b\u0001\n\u0003)\u0013a\u00027pO\u0012K'o]\u000b\u0002MA\u0019\u0011bJ\u0015\n\u0005!R!!B!se\u0006L\bC\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\tIwNC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#\u0001\u0002$jY\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\tY><G)\u001b:tA!AA\u0007\u0001BC\u0002\u0013\u0005Q'\u0001\u0003m_\u001e\u001cX#\u0001\u001c\u0011\t=9\u0014hP\u0005\u0003qA\u0011A\u0001U8pYB\u0011!(P\u0007\u0002w)\u0011A\bB\u0001\u0007G>lWn\u001c8\n\u0005yZ$!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011a\u0004Q\u0005\u0003\u0003\n\u00111\u0001T8h\u0011!\u0019\u0005A!A!\u0002\u00131\u0014!\u00027pON\u0004\u0003\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\tQLW.\u001a\t\u0003\u001f\u001dK!\u0001\u0013\t\u0003\tQKW.\u001a\u0005\u0006\u0015\u0002!\taS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b1kej\u0014)\u0011\u0005y\u0001\u0001\"B\u000eJ\u0001\u0004i\u0002\"\u0002\u0013J\u0001\u00041\u0003\"\u0002\u001bJ\u0001\u00041\u0004bB#J!\u0003\u0005\rA\u0012\u0005\t%\u0002\u0011\r\u0011\"\u0001\u0003'\u0006q1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014X#\u0001+\u0011\u0005y)\u0016B\u0001,\u0003\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0005\u00071\u0002\u0001\u000b\u0011\u0002+\u0002\u001f\rdW-\u00198fe6\u000bg.Y4fe\u0002BqA\u0017\u0001C\u0002\u0013%1,A\u0005uQJ|G\u000f\u001e7feV\tA\f\u0005\u0002\u0010;&\u0011a\f\u0005\u0002\n)\"\u0014x\u000e\u001e;mKJDa\u0001\u0019\u0001!\u0002\u0013a\u0016A\u0003;ie>$H\u000f\\3sA!9!\r\u0001b\u0001\n\u0013\u0019\u0017\u0001C2mK\u0006tWM]:\u0016\u0003\u0011\u00042!\u001a6m\u001b\u00051'BA4i\u0003%IW.\\;uC\ndWM\u0003\u0002j\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005-4'AC%oI\u0016DX\rZ*fcB\u0011QN\\\u0007\u0002\u0001\u0019!q\u000e\u0001\u0003q\u00055\u0019E.Z1oKJ$\u0006N]3bIN\u0011a.\u001d\t\u0003\u001fIL!a\u001d\t\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\tk:\u0014\t\u0011)A\u0005m\u0006AA\u000f\u001b:fC\u0012LE\r\u0005\u0002\no&\u0011\u0001P\u0003\u0002\u0004\u0013:$\b\"\u0002&o\t\u0003QHC\u00017|\u0011\u0015)\u0018\u00101\u0001w\u0011\u001dihN1A\u0005By\f!\u0002\\8hO\u0016\u0014h*Y7f+\u0005y\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015Q&\u0001\u0003mC:<\u0017\u0002BA\u0005\u0003\u0007\u0011aa\u0015;sS:<\u0007bBA\u0007]\u0002\u0006Ia`\u0001\fY><w-\u001a:OC6,\u0007\u0005C\u0005\u0002\u00129\u0014\r\u0011\"\u0001\u0002\u0014\u000591\r\\3b]\u0016\u0014XCAA\u000b!\rq\u0012qC\u0005\u0004\u00033\u0011!aB\"mK\u0006tWM\u001d\u0005\t\u0003;q\u0007\u0015!\u0003\u0002\u0016\u0005A1\r\\3b]\u0016\u0014\b\u0005C\u0005\u0002\"9\u0004\r\u0011\"\u0001\u0002$\u0005IA.Y:u'R\fGo]\u000b\u0003\u0003K\u00012AHA\u0014\u0013\r\tIC\u0001\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\n\u0003[q\u0007\u0019!C\u0001\u0003_\tQ\u0002\\1tiN#\u0018\r^:`I\u0015\fH\u0003BA\u0019\u0003o\u00012!CA\u001a\u0013\r\t)D\u0003\u0002\u0005+:LG\u000f\u0003\u0006\u0002:\u0005-\u0012\u0011!a\u0001\u0003K\t1\u0001\u001f\u00132\u0011!\tiD\u001cQ!\n\u0005\u0015\u0012A\u00037bgR\u001cF/\u0019;tA!\"\u00111HA!!\rI\u00111I\u0005\u0004\u0003\u000bR!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005%cN1A\u0005\n\u0005-\u0013\u0001\u00052bG.|eMZ,bSRd\u0015\r^2i+\t\ti\u0005\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002X5\nA!\u001e;jY&!\u00111LA)\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0001\"a\u0018oA\u0003%\u0011QJ\u0001\u0012E\u0006\u001c7n\u00144g/\u0006LG\u000fT1uG\"\u0004\u0003bBA2]\u0012%\u0011QM\u0001\nG\",7m\u001b#p]\u0016$B!!\r\u0002h!9\u0011\u0011NA1\u0001\u0004I\u0014!\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"9\u0011Q\u000e8\u0005B\u0005=\u0014A\u00023p/>\u00148\u000e\u0006\u0002\u00022!9\u00111\u000f8\u0005B\u0005=\u0014\u0001C:ikR$wn\u001e8\t\u000f\u0005]d\u000e\"\u0003\u0002p\u0005a1\r\\3b]>\u00138\u000b\\3fa\"9\u00111\u00108\u0005\u0002\u0005u\u0014a\u0003:fG>\u0014Hm\u0015;biN$B\"!\r\u0002\u0000\u0005\r\u00151TAS\u0003SCq!!!\u0002z\u0001\u0007a/\u0001\u0002jI\"A\u0011QQA=\u0001\u0004\t9)\u0001\u0003oC6,\u0007\u0003BAE\u0003/sA!a#\u0002\u0014B\u0019\u0011Q\u0012\u0006\u000e\u0005\u0005=%bAAI\r\u00051AH]8pizJ1!!&\u000b\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BAM\u0015\r\t)J\u0003\u0005\t\u0003;\u000bI\b1\u0001\u0002 \u0006!aM]8n!\rI\u0011\u0011U\u0005\u0004\u0003GS!\u0001\u0002'p]\u001eD\u0001\"a*\u0002z\u0001\u0007\u0011qT\u0001\u0003i>D\u0001\"a+\u0002z\u0001\u0007\u0011QE\u0001\u0006gR\fGo\u001d\u0005\b\u0003_\u0003\u0001\u0015!\u0003e\u0003%\u0019G.Z1oKJ\u001c\b\u0005C\u0004\u00024\u0002!\t!a\u001c\u0002\u000fM$\u0018M\u001d;va\"9\u00111\u000f\u0001\u0005\u0002\u0005=\u0004bBA]\u0001\u0011\u0005\u00111X\u0001\u000eC\n|'\u000f^\"mK\u0006t\u0017N\\4\u0015\t\u0005E\u0012Q\u0018\u0005\b\u0003S\n9\f1\u0001:\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007\f\u0011#\u001e9eCR,7\t[3dWB|\u0017N\u001c;t)\u0011\t\t$!2\t\u000f\u0005\u001d\u0017q\u0018a\u0001S\u00059A-\u0019;b\t&\u0014\bbBAf\u0001\u0011\u0005\u0011QZ\u0001\u0018[\u0006L(-\u001a+sk:\u001c\u0017\r^3DQ\u0016\u001c7\u000e]8j]R$\u0002\"!\r\u0002P\u0006E\u00171\u001b\u0005\b\u0003\u000f\fI\r1\u0001*\u0011\u001d\tI'!3A\u0002eB\u0001\"!6\u0002J\u0002\u0007\u0011qT\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\u0006)\u0012MY8si\u0006sG\rU1vg\u0016\u001cE.Z1oS:<G\u0003BA\u0019\u0003;Dq!!\u001b\u0002X\u0002\u0007\u0011\bC\u0004\u0002b\u0002!\t!a9\u0002\u001dI,7/^7f\u00072,\u0017M\\5oOR!\u0011\u0011GAs\u0011\u001d\tI'a8A\u0002eBq!!;\u0001\t\u0003\tY/\u0001\u0007bo\u0006LGo\u00117fC:,G\r\u0006\u0006\u0002n\u0006M\u0018q_A~\u0003{\u00042!CAx\u0013\r\t\tP\u0003\u0002\b\u0005>|G.Z1o\u0011!\t)0a:A\u0002\u0005\u001d\u0015!\u0002;pa&\u001c\u0007bBA}\u0003O\u0004\rA^\u0001\u0005a\u0006\u0014H\u000f\u0003\u0005\u0002V\u0006\u001d\b\u0019AAP\u0011)\ty0a:\u0011\u0002\u0003\u0007\u0011qT\u0001\n[\u0006Dx+Y5u\u001bND\u0011Ba\u0001\u0001#\u0003%\tA!\u0002\u0002-\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3%I\u00164\u0017-\u001e7uIQ*\"Aa\u0002+\t\u0005}%\u0011B\u0016\u0003\u0005\u0017\u0001BA!\u0004\u0003\u00185\u0011!q\u0002\u0006\u0005\u0005#\u0011\u0019\"A\u0005v]\u000eDWmY6fI*\u0019!Q\u0003\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u001a\t=!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001eI!Q\u0004\u0002\u0002\u0002#\u0005!qD\u0001\u000b\u0019><7\t\\3b]\u0016\u0014\bc\u0001\u0010\u0003\"\u0019A\u0011AAA\u0001\u0012\u0003\u0011\u0019cE\u0002\u0003\"!AqA\u0013B\u0011\t\u0003\u00119\u0003\u0006\u0002\u0003 !Q!1\u0006B\u0011#\u0003%\tA!\f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011yCK\u0002G\u0005\u0013\u0001")
public class LogCleaner
implements KafkaMetricsGroup {
    private final CleanerConfig config;
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$4() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public CleanerConfig config() {
        return this.config;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.start();
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        this.cleanerManager().abortCleaning(topicAndPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicAndPartition, Object>>)None$.MODULE$);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicAndPartition topicAndPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicAndPartition, offset);
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicAndPartition);
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        this.cleanerManager().resumeCleaning(topicAndPartition);
    }

    public boolean awaitCleaned(String topic, int part, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topic, part, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topic, part, offset);
    }

    public long awaitCleaned$default$4() {
        return 60000L;
    }

    public static final /* synthetic */ CleanerThread $anonfun$cleaners$1(LogCleaner $this, int x$1) {
        return $this.new CleanerThread(x$1);
    }

    private final boolean isCleaned$1(String topic$1, int part$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)new TopicAndPartition(topic$1, part$1)).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 >= offset$1));
    }

    public LogCleaner(CleanerConfig config, File[] logDirs, Pool<TopicAndPartition, Log> logs, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.cleanerManager = new LogCleanerManager(logDirs, logs);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.numThreads()).map((Function1 & Serializable & scala.Serializable)x$1 -> LogCleaner.$anonfun$cleaners$1(this, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.lastStats(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$2(x$3)), IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$2(CleanerStats x$3) {
                return (double)100 * x$3.bufferUtilization();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$2$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                IndexedSeq stats = (IndexedSeq)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.lastStats(), IndexedSeq$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$4(x$5)), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$5(x$6)), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }

            public static final /* synthetic */ long $anonfun$value$4(CleanerStats x$5) {
                return x$5.bytesWritten();
            }

            public static final /* synthetic */ long $anonfun$value$5(CleanerStats x$6) {
                return x$6.bytesRead();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$4$adapted(kafka.log.CleanerStats ), $anonfun$value$5$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.lastStats(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)$anon$3.$anonfun$value$7(x$8)), IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$7(CleanerStats x$8) {
                return x$8.elapsedSecs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$6(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$7$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final String loggerName;
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private final CountDownLatch backOffWaitLatch;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        private CountDownLatch backOffWaitLatch() {
            return this.backOffWaitLatch;
        }

        private void checkDone(TopicAndPartition topicAndPartition) {
            if (!this.isRunning().get()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicAndPartition);
        }

        @Override
        public void doWork() {
            this.cleanOrSleep();
        }

        @Override
        public void shutdown() {
            this.initiateShutdown();
            this.backOffWaitLatch().countDown();
            this.awaitShutdown();
        }

        private void cleanOrSleep() {
            block10: {
                boolean bl;
                Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time);
                if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    LogToClean cleanable = (LogToClean)some.value();
                    long endOffset = cleanable.firstDirtyOffset();
                    try {
                        try {
                            endOffset = this.cleaner().clean(cleanable);
                            this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, this.cleaner().stats());
                        }
                        catch (LogCleaningAbortedException pe) {}
                    }
                    finally {
                        this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
                    }
                    bl = true;
                } else {
                    throw new MatchError(option);
                }
                boolean cleaned = bl;
                Iterable<Tuple2<TopicAndPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
                deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanOrSleep$1(this, x0$1)));
                if (cleaned) break block10;
                this.backOffWaitLatch().await(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            block0: {
                this.lastStats_$eq(stats);
                this.cleaner().statsUnderlying().swap();
                String message = new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)})) + new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))})) + new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))})) + new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))})) + new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))})) + new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())})) + new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())})) + new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}));
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                if (stats.invalidMessagesRead() <= 0L) break block0;
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanOrSleep$1(CleanerThread $this, Tuple2 x0$1) {
            int n;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
                Log log = (Log)tuple2._2();
                try {
                    n = log.deleteOldSegments();
                }
                finally {
                    $this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting(topicPartition);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            int n2 = n;
            return n2;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super("kafka-log-cleaner-thread-" + threadId, false);
            this.loggerName = LogCleaner.class.getName();
            if (LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.config().hashAlgorithm()), LogCleaner.this.config().ioBufferSize() / LogCleaner.this.config().numThreads() / 2, LogCleaner.this.config().maxMessageSize(), LogCleaner.this.config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicAndPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicAndPartition -> {
                this.checkDone(topicAndPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.backOffWaitLatch = new CountDownLatch(1);
        }
    }
}

