/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogSegment;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class LogCleanerManager$
implements Logging {
    public static LogCleanerManager$ MODULE$;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new LogCleanerManager$();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleanerManager$ logCleanerManager$ = this;
        synchronized (logCleanerManager$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public boolean isCompactAndDelete(Log log) {
        return log.config().compact() && log.config().delete();
    }

    public Tuple2<Object, Object> cleanableOffsets(Log log, TopicAndPartition topicAndPartition, Map<TopicAndPartition, Object> lastClean, long now) {
        long l;
        long logStartOffset;
        Option lastCleanOffset = lastClean.get((Object)topicAndPartition);
        long offset = BoxesRunTime.unboxToLong((Object)lastCleanOffset.getOrElse((Function0)((JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> LogCleanerManager$.$anonfun$cleanableOffsets$1(logStartOffset = ((LogSegment)log.logSegments().head()).baseOffset()))));
        if (offset < logStartOffset) {
            if (!this.isCompactAndDelete(log)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resetting first dirty offset to log start offset ", " since the checkpointed offset ", " is invalid."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)logStartOffset), BoxesRunTime.boxToLong((long)offset)})));
            }
            l = logStartOffset;
        } else {
            l = offset;
        }
        long firstDirtyOffset = l;
        Iterable<LogSegment> dirtyNonActiveSegments = log.logSegments(firstDirtyOffset, log.activeSegment().baseOffset());
        long compactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().compactionLagMs()), 0L);
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)log.activeSegment().baseOffset())), compactionLagMs > 0L ? dirtyNonActiveSegments.find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager$.$anonfun$cleanableOffsets$3(this, log, now, compactionLagMs, s))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.baseOffset())) : None$.MODULE$})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).min((Ordering)Ordering.Long$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finding range of cleanable offsets for log=", " topicAndPartition=", ". Last clean offset=", " now=", " => firstDirtyOffset=", " firstUncleanableOffset=", " activeSegment.baseOffset=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), topicAndPartition, lastCleanOffset, BoxesRunTime.boxToLong((long)now), BoxesRunTime.boxToLong((long)firstDirtyOffset), BoxesRunTime.boxToLong((long)firstUncleanableDirtyOffset), BoxesRunTime.boxToLong((long)log.activeSegment().baseOffset())})));
        return new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
    }

    public static final /* synthetic */ long $anonfun$cleanableOffsets$1(long logStartOffset$1) {
        return logStartOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$cleanableOffsets$3(LogCleanerManager$ $this, Log log$1, long now$2, long compactionLagMs$1, LogSegment s) {
        boolean isUncleanable = s.largestTimestamp() > now$2 - compactionLagMs$1;
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking if log segment may be cleaned: log='", "' segment.baseOffset=", " segment.largestTimestamp=", "; now - compactionLag=", "; is uncleanable=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log$1.name(), BoxesRunTime.boxToLong((long)s.baseOffset()), BoxesRunTime.boxToLong((long)s.largestTimestamp()), BoxesRunTime.boxToLong((long)(now$2 - compactionLagMs$1)), BoxesRunTime.boxToBoolean((boolean)isUncleanable)})));
        return isUncleanable;
    }

    private LogCleanerManager$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

