/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.OffsetCheckpoint;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t-b!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007!q\u0002%\u0003\u0002 \u0013\t)\u0011I\u001d:bsB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0003S>T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t!a)\u001b7f\u0011!I\u0003A!A!\u0002\u0013i\u0012\u0001\u00037pO\u0012K'o\u001d\u0011\t\u0011-\u0002!Q1A\u0005\u00021\nA\u0001\\8hgV\tQ\u0006\u0005\u0003\u000f]A2\u0014BA\u0018\u0010\u0005\u0011\u0001vn\u001c7\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M\"\u0011AB2p[6|g.\u0003\u00026e\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0011\u0005]BT\"\u0001\u0002\n\u0005e\u0012!a\u0001'pO\"A1\b\u0001B\u0001B\u0003%Q&A\u0003m_\u001e\u001c\b\u0005C\u0003>\u0001\u0011\u0005a(\u0001\u0004=S:LGO\u0010\u000b\u0004\u007f\u0001\u000b\u0005CA\u001c\u0001\u0011\u0015QB\b1\u0001\u001e\u0011\u0015YC\b1\u0001.\u0011\u001d\u0019\u0005A1A\u0005B\u0011\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%%\u0003\u0011a\u0017M\\4\n\u0005);%AB*ue&tw\r\u0003\u0004M\u0001\u0001\u0006I!R\u0001\fY><w-\u001a:OC6,\u0007\u0005\u0003\u0005O\u0001\t\u0007I\u0011\u0001\u0002E\u0003QygMZ:fi\u000eCWmY6q_&tGOR5mK\"1\u0001\u000b\u0001Q\u0001\n\u0015\u000bQc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0007\u0005C\u0004S\u0001\t\u0007I\u0011B*\u0002\u0017\rDWmY6q_&tGo]\u000b\u0002)B!QK\u0017\u0011]\u001b\u00051&BA,Y\u0003%IW.\\;uC\ndWM\u0003\u0002Z\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005m3&aA'baB\u0011Q\fY\u0007\u0002=*\u0011q\fB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0005t&\u0001E(gMN,Go\u00115fG.\u0004x.\u001b8u\u0011\u0019\u0019\u0007\u0001)A\u0005)\u0006a1\r[3dWB|\u0017N\u001c;tA!9Q\r\u0001b\u0001\n\u00131\u0017AC5o!J|wM]3tgV\tq\r\u0005\u0003iWBjW\"A5\u000b\u0005)D\u0016aB7vi\u0006\u0014G.Z\u0005\u0003Y&\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u00028]&\u0011qN\u0001\u0002\u0011\u0019><7\t\\3b]&twm\u0015;bi\u0016Da!\u001d\u0001!\u0002\u00139\u0017aC5o!J|wM]3tg\u0002Bqa\u001d\u0001C\u0002\u0013%A/\u0001\u0003m_\u000e\\W#A;\u0011\u0005YlX\"A<\u000b\u0005aL\u0018!\u00027pG.\u001c(B\u0001>|\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003y\u0012\nA!\u001e;jY&\u0011ap\u001e\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\t\u000f\u0005\u0005\u0001\u0001)A\u0005k\u0006)An\\2lA!I\u0011Q\u0001\u0001C\u0002\u0013%\u0011qA\u0001\u0013a\u0006,8/\u001a3DY\u0016\fg.\u001b8h\u0007>tG-\u0006\u0002\u0002\nA\u0019a/a\u0003\n\u0007\u00055qOA\u0005D_:$\u0017\u000e^5p]\"A\u0011\u0011\u0003\u0001!\u0002\u0013\tI!A\nqCV\u001cX\rZ\"mK\u0006t\u0017N\\4D_:$\u0007\u0005C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018\u0005IB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p+\t\tI\u0002E\u0002\t\u00037I1!!\b\n\u0005\u0019!u.\u001e2mK\"I\u0011\u0011\u0005\u0001A\u0002\u0013%\u00111E\u0001\u001eI&\u0014H/[3ti2{wm\u00117fC:\f'\r\\3SCRLwn\u0018\u0013fcR!\u0011QEA\u0016!\rA\u0011qE\u0005\u0004\u0003SI!\u0001B+oSRD!\"!\f\u0002 \u0005\u0005\t\u0019AA\r\u0003\rAH%\r\u0005\t\u0003c\u0001\u0001\u0015)\u0003\u0002\u001a\u0005QB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5pA!\"\u0011qFA\u001b!\rA\u0011qG\u0005\u0004\u0003sI!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005)\u0012\r\u001c7DY\u0016\fg.\u001a:DQ\u0016\u001c7\u000e]8j]R\u001cXCAA!!\u001d\t\u0019%!\u00151\u0003+rA!!\u0012\u0002NA\u0019\u0011qI\u0005\u000e\u0005\u0005%#bAA&7\u00051AH]8pizJ1!a\u0014\n\u0003\u0019\u0001&/\u001a3fM&\u00191,a\u0015\u000b\u0007\u0005=\u0013\u0002E\u0002\t\u0003/J1!!\u0017\n\u0005\u0011auN\\4\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`\u0005IrM]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h)\u0011\t\t'!\u001c\u0011\u000b!\t\u0019'a\u001a\n\u0007\u0005\u0015\u0014B\u0001\u0004PaRLwN\u001c\t\u0004o\u0005%\u0014bAA6\u0005\tQAj\\4U_\u000ecW-\u00198\t\u0011\u0005=\u00141\fa\u0001\u0003c\nA\u0001^5nKB\u0019a\"a\u001d\n\u0007\u0005UtB\u0001\u0003US6,\u0007bBA=\u0001\u0011\u0005\u00111P\u0001\u000eI\u0016dW\r^1cY\u0016dunZ:\u0015\u0005\u0005u\u0004CBA@\u0003\u0013\u000byI\u0004\u0003\u0002\u0002\u0006\u0015e\u0002BA$\u0003\u0007K\u0011AC\u0005\u0004\u0003\u000fK\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\u000biI\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t9)\u0003\t\u0006\u0011\u0005E\u0005GN\u0005\u0004\u0003'K!A\u0002+va2,'\u0007C\u0004\u0002\u0018\u0002!\t!!'\u0002\u001b\u0005\u0014wN\u001d;DY\u0016\fg.\u001b8h)\u0011\t)#a'\t\u000f\u0005u\u0015Q\u0013a\u0001a\u0005\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\u0006)\u0012MY8si\u0006sG\rU1vg\u0016\u001cE.Z1oS:<G\u0003BA\u0013\u0003KCq!!(\u0002 \u0002\u0007\u0001\u0007C\u0004\u0002*\u0002!\t!a+\u0002\u001dI,7/^7f\u00072,\u0017M\\5oOR!\u0011QEAW\u0011\u001d\ti*a*A\u0002ABq!!-\u0001\t\u0013\t\u0019,A\tjg\u000ecW-\u00198j]\u001eLen\u0015;bi\u0016$b!!.\u0002<\u0006u\u0006c\u0001\u0005\u00028&\u0019\u0011\u0011X\u0005\u0003\u000f\t{w\u000e\\3b]\"9\u0011QTAX\u0001\u0004\u0001\u0004bBA`\u0003_\u0003\r!\\\u0001\u000eKb\u0004Xm\u0019;fIN#\u0018\r^3\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\u0006!2\r[3dW\u000ecW-\u00198j]\u001e\f%m\u001c:uK\u0012$B!!\n\u0002H\"9\u0011QTAa\u0001\u0004\u0001\u0004bBAf\u0001\u0011\u0005\u0011QZ\u0001\u0012kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cHCBA\u0013\u0003\u001f\f\u0019\u000eC\u0004\u0002R\u0006%\u0007\u0019\u0001\u0011\u0002\u000f\u0011\fG/\u0019#je\"A\u0011Q[Ae\u0001\u0004\t9.\u0001\u0004va\u0012\fG/\u001a\t\u0006\u0011\u0005\r\u0014\u0011\u001c\t\u0007\u0011\u0005E\u0005'!\u0016\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\u00069R.Y=cKR\u0013XO\\2bi\u0016\u001c\u0005.Z2la>Lg\u000e\u001e\u000b\t\u0003K\t\t/a9\u0002f\"9\u0011\u0011[An\u0001\u0004\u0001\u0003bBAO\u00037\u0004\r\u0001\r\u0005\t\u0003O\fY\u000e1\u0001\u0002V\u00051qN\u001a4tKRDq!a;\u0001\t\u0003\ti/\u0001\u0007e_:,7\t\\3b]&tw\r\u0006\u0005\u0002&\u0005=\u0018\u0011_Az\u0011\u001d\ti*!;A\u0002ABq!!5\u0002j\u0002\u0007\u0001\u0005\u0003\u0005\u0002v\u0006%\b\u0019AA+\u0003%)g\u000eZ(gMN,G\u000fC\u0004\u0002z\u0002!\t!a?\u0002\u0019\u0011|g.\u001a#fY\u0016$\u0018N\\4\u0015\t\u0005\u0015\u0012Q \u0005\b\u0003;\u000b9\u00101\u00011\u000f!\u0011\tA\u0001E\u0001\u0005\t\r\u0011!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4feB\u0019qG!\u0002\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u0003\bM!!QA\u0004\u000e\u0011\u001di$Q\u0001C\u0001\u0005\u0017!\"Aa\u0001\t\u0011\t=!Q\u0001C\u0001\u0005#\t!#[:D_6\u0004\u0018m\u0019;B]\u0012$U\r\\3uKR!\u0011Q\u0017B\n\u0011\u0019\u0019!Q\u0002a\u0001m!A!q\u0003B\u0003\t\u0003\u0011I\"\u0001\tdY\u0016\fg.\u00192mK>3gm]3ugRQ!1\u0004B\u000f\u0005?\u0011\tCa\n\u0011\u000f!\t\t*!\u0016\u0002V!11A!\u0006A\u0002YBq!!(\u0003\u0016\u0001\u0007\u0001\u0007\u0003\u0005\u0003$\tU\u0001\u0019\u0001B\u0013\u0003%a\u0017m\u001d;DY\u0016\fg\u000eE\u0003V5B\n)\u0006\u0003\u0005\u0003*\tU\u0001\u0019AA+\u0003\rqwn\u001e")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    private final String loggerName;
    private final String offsetCheckpointFile;
    private final scala.collection.immutable.Map<File, OffsetCheckpoint> checkpoints;
    private final HashMap<TopicAndPartition, LogCleaningState> inProgress;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicAndPartition topicAndPartition, scala.collection.immutable.Map<TopicAndPartition, Object> map, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicAndPartition, map, l);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpoint> checkpoints() {
        return this.checkpoints;
    }

    private HashMap<TopicAndPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    private void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public scala.collection.immutable.Map<TopicAndPartition, Object> allCleanerCheckpoints() {
        return ((TraversableOnce)this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.read(), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            long now = time.milliseconds();
            scala.collection.immutable.Map<TopicAndPartition, Object> lastClean = this.allCleanerCheckpoints();
            Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3(this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2.mcJJ.sp sp2;
                Log log;
                TopicAndPartition topicAndPartition;
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    topicAndPartition = (TopicAndPartition)tuple2._1();
                    log = (Log)tuple2._2();
                    Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicAndPartition, lastClean, now);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    long firstDirtyOffset = tuple22._1$mcJ$sp();
                    long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                    sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcJJ.sp sp3 = sp2;
                long firstDirtyOffset = sp3._1$mcJ$sp();
                long firstUncleanableDirtyOffset = sp3._2$mcJ$sp();
                LogToClean logToClean = new LogToClean(topicAndPartition, log, firstDirtyOffset, firstUncleanableDirtyOffset);
                return logToClean;
            }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
            this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
            Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
            if (cleanableLogs.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
                none$ = new Some((Object)filthiest);
            }
            return none$;
        });
    }

    public Iterable<Tuple2<TopicAndPartition, Log>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Iterable toClean = (Iterable)((TraversableLike)this.logs().filterNot((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2(this, x0$4)))).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$3(x0$5)));
            toClean.foreach((Function1 & Serializable & scala.Serializable)x -> this.inProgress().put(x._1(), (Object)LogCleaningInProgress$.MODULE$));
            return var1_1;
        });
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.abortAndPauseCleaning(topicAndPartition);
            this.resumeCleaning(topicAndPartition);
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})));
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option option;
            Option option2 = this.inProgress().get((Object)topicAndPartition);
            if (None$.MODULE$.equals(option2)) {
                option = this.inProgress().put((Object)topicAndPartition, (Object)LogCleaningPaused$.MODULE$);
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                LogCleaningState state = (LogCleaningState)some.value();
                LogCleaningState logCleaningState = state;
                if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be aborted and paused since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, logCleaningState})));
                }
                Option option3 = this.inProgress().put((Object)topicAndPartition, (Object)LogCleaningAborted$.MODULE$);
                option = option3;
            } else {
                throw new MatchError((Object)option2);
            }
            while (!this.isCleaningInState(topicAndPartition, LogCleaningPaused$.MODULE$)) {
                this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
            }
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted and paused"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})));
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Option option;
            Option option2 = this.inProgress().get((Object)topicAndPartition);
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is not paused."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})));
            }
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LogCleaningState state = (LogCleaningState)some.value();
                LogCleaningState logCleaningState = state;
                if (!LogCleaningPaused$.MODULE$.equals(logCleaningState)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, logCleaningState})));
                }
                option = this.inProgress().remove((Object)topicAndPartition);
            } else {
                throw new MatchError((Object)option2);
            }
            Option option3 = option;
            return option3;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " is resumed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})));
    }

    private boolean isCleaningInState(TopicAndPartition topicAndPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicAndPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState state;
            Some some = (Some)option;
            LogCleaningState logCleaningState = state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState2 = expectedState;
            bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void checkCleaningAborted(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.isCleaningInState(topicAndPartition, LogCleaningAborted$.MODULE$)) {
                throw new LogCleaningAbortedException();
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicAndPartition, Object>> update) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            OffsetCheckpoint checkpoint = (OffsetCheckpoint)this.checkpoints().apply((Object)dataDir);
            Map existing = checkpoint.read().filterKeys(this.logs().keys()).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(update));
            checkpoint.write((Map<TopicAndPartition, Object>)existing);
        });
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicAndPartition topicAndPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                OffsetCheckpoint checkpoint;
                Map<TopicAndPartition, Object> existing;
                if (!this.logs().get(topicAndPartition).config().compact() || BoxesRunTime.unboxToLong((Object)(existing = (checkpoint = (OffsetCheckpoint)this.checkpoints().apply((Object)dataDir)).read()).getOrElse((Object)topicAndPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) <= offset) break block0;
                checkpoint.write((Map<TopicAndPartition, Object>)existing.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)BoxesRunTime.boxToLong((long)offset))));
            }
        });
    }

    public void doneCleaning(TopicAndPartition topicAndPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Option option;
            LogCleaningState logCleaningState = (LogCleaningState)this.inProgress().apply((Object)topicAndPartition);
            if (LogCleaningInProgress$.MODULE$.equals(logCleaningState)) {
                this.updateCheckpoints(dataDir, (Option<Tuple2<TopicAndPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicAndPartition, (Object)BoxesRunTime.boxToLong((long)endOffset))));
                option = this.inProgress().remove((Object)topicAndPartition);
            } else if (LogCleaningAborted$.MODULE$.equals(logCleaningState)) {
                this.inProgress().put((Object)topicAndPartition, (Object)LogCleaningPaused$.MODULE$);
                this.pausedCleaningCond().signalAll();
                option = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In-progress partition ", " cannot be in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, logCleaningState})));
            }
            return option;
        });
    }

    public void doneDeleting(TopicAndPartition topicAndPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().remove((Object)topicAndPartition));
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = log.config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
        boolean bl = $this.inProgress().contains((Object)topicAndPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
        boolean bl = $this.inProgress().contains((Object)topicAndPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$3(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = LogCleanerManager$.MODULE$.isCompactAndDelete(log);
        return bl;
    }

    public LogCleanerManager(File[] logDirs, Pool<TopicAndPartition, Log> logs) {
        this.logDirs = logDirs;
        this.logs = logs;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDirs)).map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpoint(new File((File)dir, this.offsetCheckpointFile()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

