/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.server.BrokerState;
import kafka.server.OffsetCheckpoint;
import kafka.server.RecoveringFromUncleanShutdown$;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001\"\u0006\u0001\u0003\u0006\u0004%\tAF\u0001\bY><G)\u001b:t+\u00059\u0002cA\u0005\u00195%\u0011\u0011D\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003\u0018\u0003!awn\u001a#jeN\u0004\u0003\u0002C\u0013\u0001\u0005\u000b\u0007I\u0011\u0001\u0014\u0002\u0019Q|\u0007/[2D_:4\u0017nZ:\u0016\u0003\u001d\u0002B\u0001K\u0016.q5\t\u0011F\u0003\u0002+\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00051J#aA'baB\u0011a&\u000e\b\u0003_M\u0002\"\u0001\r\u0006\u000e\u0003ER!A\r\u0004\u0002\rq\u0012xn\u001c;?\u0013\t!$\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b\u000b!\tI$(D\u0001\u0003\u0013\tY$AA\u0005M_\u001e\u001cuN\u001c4jO\"AQ\b\u0001B\u0001B\u0003%q%A\u0007u_BL7mQ8oM&<7\u000f\t\u0005\t\u007f\u0001\u0011)\u0019!C\u0001\u0001\u0006iA-\u001a4bk2$8i\u001c8gS\u001e,\u0012\u0001\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005q\u0005qA-\u001a4bk2$8i\u001c8gS\u001e\u0004\u0003\u0002\u0003#\u0001\u0005\u000b\u0007I\u0011A#\u0002\u001b\rdW-\u00198fe\u000e{gNZ5h+\u00051\u0005CA\u001dH\u0013\tA%AA\u0007DY\u0016\fg.\u001a:D_:4\u0017n\u001a\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\r\u0006q1\r\\3b]\u0016\u00148i\u001c8gS\u001e\u0004\u0003\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\u0002\u0013%|G\u000b\u001b:fC\u0012\u001c\bCA\u0005O\u0013\ty%BA\u0002J]RD\u0001\"\u0015\u0001\u0003\u0006\u0004%\tAU\u0001\rM2,8\u000f[\"iK\u000e\\Wj]\u000b\u0002'B\u0011\u0011\u0002V\u0005\u0003+*\u0011A\u0001T8oO\"Aq\u000b\u0001B\u0001B\u0003%1+A\u0007gYV\u001c\bn\u00115fG.l5\u000f\t\u0005\t3\u0002\u0011)\u0019!C\u0001%\u0006\tb\r\\;tQ\u000eCWmY6q_&tG/T:\t\u0011m\u0003!\u0011!Q\u0001\nM\u000b!C\u001a7vg\"\u001c\u0005.Z2la>Lg\u000e^'tA!AQ\f\u0001BC\u0002\u0013\u0005!+\u0001\tsKR,g\u000e^5p]\u000eCWmY6Ng\"Aq\f\u0001B\u0001B\u0003%1+A\tsKR,g\u000e^5p]\u000eCWmY6Ng\u0002B\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IAY\u0001\ng\u000eDW\rZ;mKJ\u0004\"aD2\n\u0005\u0011\u0004\"!C*dQ\u0016$W\u000f\\3s\u0011!1\u0007A!b\u0001\n\u00039\u0017a\u00032s_.,'o\u0015;bi\u0016,\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003W\u0012\taa]3sm\u0016\u0014\u0018BA7k\u0005-\u0011%o\\6feN#\u0018\r^3\t\u0011=\u0004!\u0011!Q\u0001\n!\fAB\u0019:pW\u0016\u00148\u000b^1uK\u0002B\u0001\"\u001d\u0001\u0003\u0006\u0004%IA]\u0001\u0005i&lW-F\u0001t!\tyA/\u0003\u0002v!\t!A+[7f\u0011!9\bA!A!\u0002\u0013\u0019\u0018!\u0002;j[\u0016\u0004\u0003\"B=\u0001\t\u0003Q\u0018A\u0002\u001fj]&$h\bF\n|yvtx0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti\u0001\u0005\u0002:\u0001!)Q\u0003\u001fa\u0001/!)Q\u0005\u001fa\u0001O!)q\b\u001fa\u0001q!)A\t\u001fa\u0001\r\")A\n\u001fa\u0001\u001b\")\u0011\u000b\u001fa\u0001'\")\u0011\f\u001fa\u0001'\")Q\f\u001fa\u0001'\")\u0011\r\u001fa\u0001E\")a\r\u001fa\u0001Q\")\u0011\u000f\u001fa\u0001g\"I\u0011\u0011\u0003\u0001C\u0002\u0013\u0005\u00111C\u0001\u001c%\u0016\u001cwN^3ssB{\u0017N\u001c;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\u0016\u0005\u0005U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005ma$\u0001\u0003mC:<\u0017b\u0001\u001c\u0002\u001a!A\u0011\u0011\u0005\u0001!\u0002\u0013\t)\"\u0001\u000fSK\u000e|g/\u001a:z!>Lg\u000e^\"iK\u000e\\\u0007o\\5oi\u001aKG.\u001a\u0011\t\u0013\u0005\u0015\u0002A1A\u0005\u0002\u0005M\u0011\u0001\u0003'pG.4\u0015\u000e\\3\t\u0011\u0005%\u0002\u0001)A\u0005\u0003+\t\u0011\u0002T8dW\u001aKG.\u001a\u0011\t\u0013\u00055\u0002A1A\u0005\u0002\u0005=\u0012AE%oSRL\u0017\r\u001c+bg.$U\r\\1z\u001bN,\u0012!\u0014\u0005\b\u0003g\u0001\u0001\u0015!\u0003N\u0003MIe.\u001b;jC2$\u0016m]6EK2\f\u00170T:!\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI$A\rm_\u001e\u001c%/Z1uS>twJ\u001d#fY\u0016$\u0018n\u001c8M_\u000e\\WCAA\u001e!\u0011\t9\"!\u0010\n\t\u0005}\u0012\u0011\u0004\u0002\u0007\u001f\nTWm\u0019;\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003w\t!\u0004\\8h\u0007J,\u0017\r^5p]>\u0013H)\u001a7fi&|g\u000eT8dW\u0002B\u0011\"a\u0012\u0001\u0005\u0004%I!!\u0013\u0002\t1|wm]\u000b\u0003\u0003\u0017\u0002raDA'\u0003#\ni&C\u0002\u0002PA\u0011A\u0001U8pYB!\u00111KA-\u001b\t\t)FC\u0002\u0002X\u0011\taaY8n[>t\u0017\u0002BA.\u0003+\u0012\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\rI\u0014qL\u0005\u0004\u0003C\u0012!a\u0001'pO\"A\u0011Q\r\u0001!\u0002\u0013\tY%A\u0003m_\u001e\u001c\b\u0005C\u0005\u0002j\u0001\u0011\r\u0011\"\u0003\u0002l\u0005AA-\u001b:M_\u000e\\7/\u0006\u0002\u0002nA)\u0001&a\u001c\u0002t%\u0019\u0011\u0011O\u0015\u0003\u0007M+\u0017\u000fE\u0002\u0010\u0003kJ1!a\u001e\u0011\u0005!1\u0015\u000e\\3M_\u000e\\\u0007\u0002CA>\u0001\u0001\u0006I!!\u001c\u0002\u0013\u0011L'\u000fT8dWN\u0004\u0003\"CA@\u0001\t\u0007I\u0011BAA\u0003a\u0011XmY8wKJL\bk\\5oi\u000eCWmY6q_&tGo]\u000b\u0003\u0003\u0007\u0003r!!\"\u0002\fj\ti)\u0004\u0002\u0002\b*\u0019\u0011\u0011R\u0015\u0002\u0013%lW.\u001e;bE2,\u0017b\u0001\u0017\u0002\bB\u0019\u0011.a$\n\u0007\u0005E%N\u0001\tPM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oi\"A\u0011Q\u0013\u0001!\u0002\u0013\t\u0019)A\rsK\u000e|g/\u001a:z!>Lg\u000e^\"iK\u000e\\\u0007o\\5oiN\u0004\u0003\"CAM\u0001\t\u0007I\u0011AAN\u0003\u001d\u0019G.Z1oKJ,\"!!(\u0011\u0007e\ny*C\u0002\u0002\"\n\u0011!\u0002T8h\u00072,\u0017M\\3s\u0011!\t)\u000b\u0001Q\u0001\n\u0005u\u0015\u0001C2mK\u0006tWM\u001d\u0011\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\u0006A2M]3bi\u0016\fe\u000e\u001a,bY&$\u0017\r^3M_\u001e$\u0015N]:\u0015\t\u00055\u00161\u0017\t\u0004\u0013\u0005=\u0016bAAY\u0015\t!QK\\5u\u0011!\t),a*A\u0002\u0005]\u0016\u0001\u00023jeN\u0004B\u0001KA85!9\u00111\u0018\u0001\u0005\n\u0005u\u0016a\u00037pG.dun\u001a#jeN$B!!\u001c\u0002@\"A\u0011QWA]\u0001\u0004\t9\fC\u0004\u0002D\u0002!I!!2\u0002\u00111|\u0017\r\u001a'pON$\"!!,\t\u000f\u0005%\u0007\u0001\"\u0001\u0002F\u000691\u000f^1siV\u0004\bbBAg\u0001\u0011\u0005\u0011QY\u0001\tg\",H\u000fZ8x]\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0017A\u0003;sk:\u001c\u0017\r^3U_R!\u0011QVAk\u0011!\t9.a4A\u0002\u0005e\u0017a\u00059beRLG/[8o\u0003:$wJ\u001a4tKR\u001c\b#\u0002\u0015,\u0003#\u001a\u0006bBAo\u0001\u0011\u0005\u0011q\\\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$b!!,\u0002b\u0006\u0015\b\u0002CAr\u00037\u0004\r!!\u0015\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002h\u0006m\u0007\u0019A*\u0002\u00139,wo\u00144gg\u0016$\bbBAv\u0001\u0011\u0005\u0011QY\u0001\u001fG\",7m\u001b9pS:$(+Z2pm\u0016\u0014\u0018\u0010U8j]R|eMZ:fiNDq!a<\u0001\t\u0013\t\t0A\ndQ\u0016\u001c7\u000e]8j]RdunZ:J]\u0012K'\u000f\u0006\u0003\u0002.\u0006M\bbBA{\u0003[\u0004\rAG\u0001\u0004I&\u0014\bbBA}\u0001\u0011\u0005\u00111`\u0001\u0007O\u0016$Hj\\4\u0015\t\u0005u(1\u0001\t\u0006\u0013\u0005}\u0018QL\u0005\u0004\u0005\u0003Q!AB(qi&|g\u000e\u0003\u0005\u0002d\u0006]\b\u0019AA)\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u0013\t\u0011b\u0019:fCR,Gj\\4\u0015\r\u0005u#1\u0002B\u0007\u0011!\t\u0019O!\u0002A\u0002\u0005E\u0003b\u0002B\b\u0005\u000b\u0001\r\u0001O\u0001\u0007G>tg-[4\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016\u0005IA-\u001a7fi\u0016dun\u001a\u000b\u0005\u0003[\u00139\u0002\u0003\u0005\u0002d\nE\u0001\u0019AA)\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;\t!B\\3yi2{w\rR5s)\u0005Q\u0002b\u0002B\u0011\u0001\u0011\u0005\u0011QY\u0001\fG2,\u0017M\\;q\u0019><7\u000fC\u0004\u0003&\u0001!\tAa\n\u0002\u000f\u0005dG\u000eT8hgR\u0011!\u0011\u0006\t\u0006Q\t-\u0012QL\u0005\u0004\u0005[I#\u0001C%uKJ\f'\r\\3\t\u000f\tE\u0002\u0001\"\u0001\u00034\u0005!Bn\\4t\u0005f$v\u000e]5d!\u0006\u0014H/\u001b;j_:,\"A!\u000e\u0011\r!Z\u0013\u0011KA/\u0011\u001d\u0011I\u0004\u0001C\u0005\u0005w\t\u0011\u0002\\8hg\nKH)\u001b:\u0016\u0005\tu\u0002\u0003CAC\u0003\u0017\u000b)B!\u000e\t\u000f\t\u0005\u0003\u0001\"\u0003\u0002F\u0006qa\r\\;tQ\u0012K'\u000f^=M_\u001e\u001c\bf\u0001\u0001\u0003FA\u0019qBa\u0012\n\u0007\t%\u0003C\u0001\u0006uQJ,\u0017\rZ:bM\u0016\u0004")
public class LogManager
implements Logging {
    private final File[] logDirs;
    private final Map<String, LogConfig> topicConfigs;
    private final LogConfig defaultConfig;
    private final CleanerConfig cleanerConfig;
    private final int ioThreads;
    private final long flushCheckMs;
    private final long flushCheckpointMs;
    private final long retentionCheckMs;
    private final Scheduler scheduler;
    private final BrokerState brokerState;
    private final Time time;
    private final String RecoveryPointCheckpointFile;
    private final String LockFile;
    private final int InitialTaskDelayMs;
    private final Object logCreationOrDeletionLock;
    private final Pool<TopicAndPartition, Log> logs;
    private final Seq<FileLock> dirLocks;
    private final scala.collection.immutable.Map<File, OffsetCheckpoint> recoveryPointCheckpoints;
    private final LogCleaner cleaner;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogManager logManager = this;
        synchronized (logManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Map<String, LogConfig> topicConfigs() {
        return this.topicConfigs;
    }

    public LogConfig defaultConfig() {
        return this.defaultConfig;
    }

    public CleanerConfig cleanerConfig() {
        return this.cleanerConfig;
    }

    public long flushCheckMs() {
        return this.flushCheckMs;
    }

    public long flushCheckpointMs() {
        return this.flushCheckpointMs;
    }

    public long retentionCheckMs() {
        return this.retentionCheckMs;
    }

    public BrokerState brokerState() {
        return this.brokerState;
    }

    private Time time() {
        return this.time;
    }

    public String RecoveryPointCheckpointFile() {
        return this.RecoveryPointCheckpointFile;
    }

    public String LockFile() {
        return this.LockFile;
    }

    public int InitialTaskDelayMs() {
        return this.InitialTaskDelayMs;
    }

    private Object logCreationOrDeletionLock() {
        return this.logCreationOrDeletionLock;
    }

    private Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    private Seq<FileLock> dirLocks() {
        return this.dirLocks;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpoint> recoveryPointCheckpoints() {
        return this.recoveryPointCheckpoints;
    }

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    private void createAndValidateLogDirs(Seq<File> dirs) {
        if (((TraversableOnce)dirs.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getCanonicalPath(), Seq$.MODULE$.canBuildFrom())).toSet().size() < dirs.size()) {
            throw new KafkaException("Duplicate log directory found: " + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).mkString(", "));
        }
        dirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            LogManager.$anonfun$createAndValidateLogDirs$2(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<FileLock> lockLogDirs(Seq<File> dirs) {
        return (Seq)dirs.map((Function1 & Serializable & scala.Serializable)dir -> {
            void var2_2;
            FileLock lock = new FileLock(new File((File)dir, this.LockFile()));
            if (!lock.tryLock()) {
                throw new KafkaException("Failed to acquire lock on file .lock in " + lock.file().getParentFile().getAbsolutePath() + ". A Kafka instance in another process or thread is using this directory.");
            }
            return var2_2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void loadLogs() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Loading logs.");
        long startMs = this.time().milliseconds();
        ArrayBuffer threadPools = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        scala.collection.mutable.Map jobs = Map$.MODULE$.empty();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            LogManager.$anonfun$loadLogs$2(this, threadPools, jobs, dir);
            return BoxedUnit.UNIT;
        });
        try {
            try {
                jobs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$loadLogs$15(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$loadLogs$16(x$3)));
            }
            catch (ExecutionException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There was an error in one of the threads during logs loading: " + e.getCause());
                throw e.getCause();
            }
        }
        finally {
            threadPools.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.shutdown();
                return BoxedUnit.UNIT;
            });
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Logs loading complete in ", " ms."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.time().milliseconds() - startMs))})));
    }

    public void startup() {
        block1: {
            if (this.scheduler != null) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Starting log cleanup with a period of %d ms.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.retentionCheckMs())})));
                this.scheduler.schedule("kafka-log-retention", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.cleanupLogs(), this.InitialTaskDelayMs(), this.retentionCheckMs(), TimeUnit.MILLISECONDS);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Starting log flusher with a default period of %d ms.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.flushCheckMs())})));
                this.scheduler.schedule("kafka-log-flusher", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.flushDirtyLogs(), this.InitialTaskDelayMs(), this.flushCheckMs(), TimeUnit.MILLISECONDS);
                this.scheduler.schedule("kafka-recovery-point-checkpoint", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkpointRecoveryPointOffsets(), this.InitialTaskDelayMs(), this.flushCheckpointMs(), TimeUnit.MILLISECONDS);
            }
            if (!this.cleanerConfig().enableCleaner()) break block1;
            this.cleaner().startup();
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        ArrayBuffer threadPools = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        scala.collection.mutable.Map jobs = Map$.MODULE$.empty();
        if (this.cleaner() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.cleaner().shutdown());
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            LogManager.$anonfun$shutdown$3(this, threadPools, jobs, dir);
            return BoxedUnit.UNIT;
        });
        try {
            try {
                jobs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$shutdown$9(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                    LogManager.$anonfun$shutdown$10(this, x$6);
                    return BoxedUnit.UNIT;
                });
            }
            catch (ExecutionException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There was an error in one of the threads during LogManager shutdown: " + e.getCause());
                throw e.getCause();
            }
        }
        finally {
            threadPools.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.shutdown();
                return BoxedUnit.UNIT;
            });
            this.dirLocks().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.destroy();
                return BoxedUnit.UNIT;
            });
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    public void truncateTo(Map<TopicAndPartition, Object> partitionAndOffsets) {
        partitionAndOffsets.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$truncateTo$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            LogManager.$anonfun$truncateTo$2(this, x$9);
            return BoxedUnit.UNIT;
        });
        this.checkpointRecoveryPointOffsets();
    }

    public void truncateFullyAndStartAt(TopicAndPartition topicAndPartition, long newOffset) {
        Log log = this.logs().get(topicAndPartition);
        if (log != null) {
            if (this.cleaner() != null) {
                this.cleaner().abortAndPauseCleaning(topicAndPartition);
            }
            log.truncateFullyAndStartAt(newOffset);
            if (this.cleaner() != null) {
                this.cleaner().maybeTruncateCheckpoint(log.dir().getParentFile(), topicAndPartition, log.activeSegment().baseOffset());
                this.cleaner().resumeCleaning(topicAndPartition);
            }
        }
        this.checkpointRecoveryPointOffsets();
    }

    public void checkpointRecoveryPointOffsets() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.checkpointLogsInDir(dir);
            return BoxedUnit.UNIT;
        });
    }

    private void checkpointLogsInDir(File dir) {
        block0: {
            Option recoveryPoints = this.logsByDir().get((Object)dir.toString());
            if (!recoveryPoints.isDefined()) break block0;
            ((OffsetCheckpoint)this.recoveryPointCheckpoints().apply((Object)dir)).write((Map<TopicAndPartition, Object>)((MapLike)recoveryPoints.get()).mapValues((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.recoveryPoint())));
        }
    }

    public Option<Log> getLog(TopicAndPartition topicAndPartition) {
        Log log = this.logs().get(topicAndPartition);
        return log == null ? None$.MODULE$ : new Some((Object)log);
    }

    public Log createLog(TopicAndPartition topicAndPartition, LogConfig config) {
        Log log;
        block5: {
            Object object = this.logCreationOrDeletionLock();
            synchronized (object) {
                Log log2;
                block4: {
                    Log log3 = this.logs().get(topicAndPartition);
                    if (log3 != null) {
                        log2 = log3;
                        break block4;
                    }
                    File dataDir = this.nextLogDir();
                    File dir = new File(dataDir, topicAndPartition.topic() + "-" + topicAndPartition.partition());
                    dir.mkdirs();
                    log3 = new Log(dir, config, 0L, this.scheduler, this.time());
                    this.logs().put(topicAndPartition, log3);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Created log for partition [%s,%d] in %s with properties {%s}.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition.topic(), BoxesRunTime.boxToInteger((int)topicAndPartition.partition()), dataDir.getAbsolutePath(), JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(config.originals()).mkString(", ")})));
                    log = log3;
                    break block5;
                }
                return log2;
            }
        }
        return log;
    }

    public void deleteLog(TopicAndPartition topicAndPartition) {
        block4: {
            ObjectRef removedLog = ObjectRef.create(null);
            Object object = this.logCreationOrDeletionLock();
            synchronized (object) {
                removedLog.elem = this.logs().remove(topicAndPartition);
            }
            if ((Log)removedLog.elem == null) break block4;
            if (this.cleaner() != null) {
                this.cleaner().abortCleaning(topicAndPartition);
                this.cleaner().updateCheckpoints(((Log)removedLog.elem).dir().getParentFile());
            }
            ((Log)removedLog.elem).delete();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deleted log for partition [%s,%d] in %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition.topic(), BoxesRunTime.boxToInteger((int)topicAndPartition.partition()), ((Log)removedLog$1.elem).dir().getAbsolutePath()})));
        }
    }

    private File nextLogDir() {
        File file;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).size() == 1) {
            file = this.logDirs()[0];
        } else {
            scala.collection.immutable.Map logCounts = this.allLogs().groupBy((Function1 & Serializable & scala.Serializable)x$11 -> x$11.dir().getParent()).mapValues((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.size()));
            scala.collection.immutable.Map zeros = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDirs())).map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2((Object)dir.getPath(), (Object)BoxesRunTime.boxToInteger((int)0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            Buffer dirCounts = zeros.$plus$plus((GenTraversableOnce)logCounts).toBuffer();
            Tuple2 leastLoaded = (Tuple2)((IterableLike)dirCounts.sortBy((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).head();
            file = new File((String)leastLoaded._1());
        }
        return file;
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Beginning log cleanup...");
        IntRef total = IntRef.create((int)0);
        long startMs = this.time().milliseconds();
        this.allLogs().withFilter((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$cleanupLogs$2(log))).foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManager.$anonfun$cleanupLogs$3(this, total, log);
            return BoxedUnit.UNIT;
        });
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Log cleanup completed. " + total$1.elem + " files deleted in " + (this.time().milliseconds() - startMs) / 1000L + " seconds");
    }

    public Iterable<Log> allLogs() {
        return this.logs().values();
    }

    public Map<TopicAndPartition, Log> logsByTopicPartition() {
        return this.logs().toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, Map<TopicAndPartition, Log>> logsByDir() {
        return this.logsByTopicPartition().groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Log log = (Log)tuple2._2();
            String string = log.dir().getParent();
            return string;
        });
    }

    private void flushDirtyLogs() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Checking for dirty logs to flush...");
        this.logs().withFilter((Function1<Tuple2<TopicAndPartition, Log>, Object>)(Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)LogManager.$anonfun$flushDirtyLogs$2(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            LogManager.$anonfun$flushDirtyLogs$3(this, x$14);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$createAndValidateLogDirs$2(LogManager $this, File dir) {
        if (!dir.exists()) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Log directory '" + dir.getAbsolutePath() + "' not found, creating it.");
            boolean created = dir.mkdirs();
            if (!created) {
                throw new KafkaException("Failed to create data directory " + dir.getAbsolutePath());
            }
        }
        if (!dir.isDirectory() || !dir.canRead()) {
            throw new KafkaException(dir.getAbsolutePath() + " is not a readable log directory.");
        }
    }

    public static final /* synthetic */ void $anonfun$loadLogs$2(LogManager $this, ArrayBuffer threadPools$1, scala.collection.mutable.Map jobs$1, File dir) {
        ExecutorService pool = Executors.newFixedThreadPool($this.ioThreads);
        threadPools$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorService[]{pool}));
        File cleanShutdownFile = new File(dir, Log$.MODULE$.CleanShutdownFile());
        if (cleanShutdownFile.exists()) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Found clean shutdown file. Skipping recovery for all logs in data directory: " + dir.getAbsolutePath());
        } else {
            $this.brokerState().newState(RecoveringFromUncleanShutdown$.MODULE$);
        }
        ObjectRef recoveryPoints = ObjectRef.create((Object)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        try {
            recoveryPoints.elem = ((OffsetCheckpoint)$this.recoveryPointCheckpoints().apply((Object)dir)).read();
        }
        catch (Exception e) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occured while reading recovery-point-offset-checkpoint file of directory " + dir, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Resetting the recovery checkpoint to 0");
        }
        List jobsForDir = (List)Option$.MODULE$.apply((Object)dir.listFiles()).toList().flatMap((Function1 & Serializable & scala.Serializable)dirContent -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirContent)).withFilter((Function1 & Serializable & scala.Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)logDir.isDirectory())).map((Function1 & Serializable & scala.Serializable)logDir -> CoreUtils$.MODULE$.runnable((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Loading log '" + logDir.getName() + "'");
            TopicAndPartition topicPartition = Log$.MODULE$.parseTopicPartitionName((File)logDir);
            LogConfig config = (LogConfig)((Object)((Object)((Object)$this.topicConfigs().getOrElse((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> $this.defaultConfig()))));
            long logRecoveryPoint = BoxesRunTime.unboxToLong((Object)((Map)recoveryPoints$1.elem).getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            Log current = new Log((File)logDir, config, logRecoveryPoint, $this.scheduler, $this.time());
            Log previous = $this.logs().put(topicPartition, current);
            if (previous != null) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Duplicate log directories found: %s, %s!")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{current.dir().getAbsolutePath(), previous.dir().getAbsolutePath()})));
            }
        }), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Runnable.class))))), List$.MODULE$.canBuildFrom());
        jobs$1.update((Object)cleanShutdownFile, (Object)((scala.collection.immutable.Seq)jobsForDir.map((Function1 & Serializable & scala.Serializable)x$1 -> pool.submit((Runnable)x$1), List$.MODULE$.canBuildFrom())).toSeq());
    }

    public static final /* synthetic */ boolean $anonfun$loadLogs$15(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$loadLogs$16(Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File cleanShutdownFile = (File)tuple2._1();
        Seq dirJobs = (Seq)tuple2._2();
        dirJobs.foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get());
        boolean bl = cleanShutdownFile.delete();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$shutdown$3(LogManager $this, ArrayBuffer threadPools$2, scala.collection.mutable.Map jobs$2, File dir) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Flushing and closing logs at " + dir);
        ExecutorService pool = Executors.newFixedThreadPool($this.ioThreads);
        threadPools$2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorService[]{pool}));
        Iterable logsInDir = ((MapLike)$this.logsByDir().getOrElse((Object)dir.toString(), (Function0 & Serializable & scala.Serializable)() -> (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$))).values();
        Iterable jobsForDir = (Iterable)logsInDir.map((Function1 & Serializable & scala.Serializable)log -> CoreUtils$.MODULE$.runnable((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            log.flush();
            log.close();
        }), Iterable$.MODULE$.canBuildFrom());
        jobs$2.update((Object)dir, (Object)((TraversableOnce)jobsForDir.map((Function1 & Serializable & scala.Serializable)x$1 -> pool.submit((Runnable)x$1), Iterable$.MODULE$.canBuildFrom())).toSeq());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$9(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$shutdown$10(LogManager $this, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        Seq dirJobs = (Seq)tuple2._2();
        dirJobs.foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.get());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating recovery points at " + dir);
        $this.checkpointLogsInDir(dir);
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Writing clean shutdown marker at " + dir);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new File(dir, Log$.MODULE$.CleanShutdownFile()).createNewFile());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$truncateTo$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$truncateTo$2(LogManager $this, Tuple2 x$9) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
            long truncateOffset = tuple2._2$mcJ$sp();
            Log log = $this.logs().get(topicAndPartition);
            if (log != null) {
                boolean needToStopCleaner;
                boolean bl = needToStopCleaner = truncateOffset < log.activeSegment().baseOffset();
                if (needToStopCleaner && $this.cleaner() != null) {
                    $this.cleaner().abortAndPauseCleaning(topicAndPartition);
                }
                log.truncateTo(truncateOffset);
                if (needToStopCleaner && $this.cleaner() != null) {
                    $this.cleaner().maybeTruncateCheckpoint(log.dir().getParentFile(), topicAndPartition, log.activeSegment().baseOffset());
                    $this.cleaner().resumeCleaning(topicAndPartition);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$cleanupLogs$2(Log log) {
        return !log.config().compact();
    }

    public static final /* synthetic */ void $anonfun$cleanupLogs$3(LogManager $this, IntRef total$1, Log log) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Garbage collecting '" + log.name() + "'");
        total$1.elem += log.deleteOldSegments();
    }

    public static final /* synthetic */ boolean $anonfun$flushDirtyLogs$2(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$flushDirtyLogs$3(LogManager $this, Tuple2 x$14) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$14;
        if (tuple2 != null) {
            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
            Log log = (Log)tuple2._2();
            try {
                long timeSinceLastFlush = $this.time().milliseconds() - log.lastFlushTime();
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Checking if flush is needed on " + topicAndPartition.topic() + " flush interval  " + log.config().flushMs() + " last flushed " + log.lastFlushTime() + " time since last flush: " + timeSinceLastFlush);
                if (timeSinceLastFlush >= Predef$.MODULE$.Long2long(log.config().flushMs())) {
                    log.flush();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error flushing topic " + topicAndPartition.topic(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public LogManager(File[] logDirs, Map<String, LogConfig> topicConfigs, LogConfig defaultConfig, CleanerConfig cleanerConfig, int ioThreads, long flushCheckMs, long flushCheckpointMs, long retentionCheckMs, Scheduler scheduler, BrokerState brokerState, Time time) {
        this.logDirs = logDirs;
        this.topicConfigs = topicConfigs;
        this.defaultConfig = defaultConfig;
        this.cleanerConfig = cleanerConfig;
        this.ioThreads = ioThreads;
        this.flushCheckMs = flushCheckMs;
        this.flushCheckpointMs = flushCheckpointMs;
        this.retentionCheckMs = retentionCheckMs;
        this.scheduler = scheduler;
        this.brokerState = brokerState;
        this.time = time;
        Logging.$init$(this);
        this.RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
        this.LockFile = ".lock";
        this.InitialTaskDelayMs = 30000;
        this.logCreationOrDeletionLock = new Object();
        this.logs = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.createAndValidateLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.dirLocks = this.lockLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.recoveryPointCheckpoints = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDirs)).map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpoint(new File((File)dir, this.RecoveryPointCheckpointFile()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        this.loadLogs();
        this.cleaner = cleanerConfig.enableCleaner() ? new LogCleaner(cleanerConfig, logDirs, this.logs(), time) : null;
    }
}

