/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import kafka.common.KafkaStorageException;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Time;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u000f\r&dW-T3tg\u0006<WmU3u\u0011!Y\u0002A!A!\u0002\u00131\u0012\u0001\u00027pO\u0002B\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0006S:$W\r_\u000b\u0002?A\u0011q\u0003I\u0005\u0003C\t\u00111b\u00144gg\u0016$\u0018J\u001c3fq\"A1\u0005\u0001B\u0001B\u0003%q$\u0001\u0004j]\u0012,\u0007\u0010\t\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005IA/[7f\u0013:$W\r_\u000b\u0002OA\u0011q\u0003K\u0005\u0003S\t\u0011\u0011\u0002V5nK&sG-\u001a=\t\u0011-\u0002!\u0011!Q\u0001\n\u001d\n!\u0002^5nK&sG-\u001a=!\u0011!i\u0003A!b\u0001\n\u0003q\u0013A\u00032bg\u0016|eMZ:fiV\tq\u0006\u0005\u0002\na%\u0011\u0011G\u0003\u0002\u0005\u0019>tw\r\u0003\u00054\u0001\t\u0005\t\u0015!\u00030\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\t\u0011U\u0002!Q1A\u0005\u0002Y\n!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgV\tq\u0007\u0005\u0002\nq%\u0011\u0011H\u0003\u0002\u0004\u0013:$\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002'%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\u0011\t\u0011u\u0002!Q1A\u0005\u00029\nAB]8mY*KG\u000f^3s\u001bND\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IaL\u0001\u000ee>dGNS5ui\u0016\u0014Xj\u001d\u0011\t\u0011\u0005\u0003!\u0011!Q\u0001\n\t\u000bA\u0001^5nKB\u0011qbQ\u0005\u0003\tB\u0011A\u0001V5nK\")a\t\u0001C\u0001\u000f\u00061A(\u001b8jiz\"\u0002\u0002S%K\u00172kej\u0014\t\u0003/\u0001AQaA#A\u0002YAQ!H#A\u0002}AQ!J#A\u0002\u001dBQ!L#A\u0002=BQ!N#A\u0002]BQ!P#A\u0002=BQ!Q#A\u0002\tCq!\u0015\u0001A\u0002\u0013\u0005a&A\u0004de\u0016\fG/\u001a3\t\u000fM\u0003\u0001\u0019!C\u0001)\u0006Y1M]3bi\u0016$w\fJ3r)\t)\u0006\f\u0005\u0002\n-&\u0011qK\u0003\u0002\u0005+:LG\u000fC\u0004Z%\u0006\u0005\t\u0019A\u0018\u0002\u0007a$\u0013\u0007\u0003\u0004\\\u0001\u0001\u0006KaL\u0001\tGJ,\u0017\r^3eA!9Q\f\u0001a\u0001\n\u00131\u0014\u0001\u00072zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss\"9q\f\u0001a\u0001\n\u0013\u0001\u0017\u0001\b2zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss~#S-\u001d\u000b\u0003+\u0006Dq!\u00170\u0002\u0002\u0003\u0007q\u0007\u0003\u0004d\u0001\u0001\u0006KaN\u0001\u001aEf$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJL\b\u0005C\u0004f\u0001\u0001\u0007I\u0011\u00024\u0002+I|G\u000e\\5oO\n\u000b7/\u001a3US6,7\u000f^1naV\tq\rE\u0002\nQ>J!!\u001b\u0006\u0003\r=\u0003H/[8o\u0011\u001dY\u0007\u00011A\u0005\n1\f\u0011D]8mY&twMQ1tK\u0012$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR\u0011Q+\u001c\u0005\b3*\f\t\u00111\u0001h\u0011\u0019y\u0007\u0001)Q\u0005O\u00061\"o\u001c7mS:<')Y:fIRKW.Z:uC6\u0004\b\u0005C\u0004r\u0001\u0001\u0007I\u0011\u0002\u0018\u0002#5\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'\u000fC\u0004t\u0001\u0001\u0007I\u0011\u0002;\u0002+5\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'o\u0018\u0013fcR\u0011Q+\u001e\u0005\b3J\f\t\u00111\u00010\u0011\u00199\b\u0001)Q\u0005_\u0005\u0011R.\u0019=US6,7\u000f^1naN{g)\u0019:!Q\t1\u0018\u0010\u0005\u0002\nu&\u00111P\u0003\u0002\tm>d\u0017\r^5mK\"9Q\u0010\u0001a\u0001\n\u0013q\u0013\u0001F8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0000\u0001\u0001\u0007I\u0011BA\u0001\u0003aygMZ:fi>3W*\u0019=US6,7\u000f^1na~#S-\u001d\u000b\u0004+\u0006\r\u0001bB-\u007f\u0003\u0003\u0005\ra\f\u0005\b\u0003\u000f\u0001\u0001\u0015)\u00030\u0003UygMZ:fi>3W*\u0019=US6,7\u000f^1na\u0002B3!!\u0002z\u0011\u00191\u0005\u0001\"\u0001\u0002\u000eQ\u0019\u0002*a\u0004\u0002$\u0005\u001d\u0012\u0011FA\u0017\u0003_\t\t$a\u000f\u0002@!A\u0011\u0011CA\u0006\u0001\u0004\t\u0019\"A\u0002eSJ\u0004B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0002j_*\u0011\u0011QD\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\"\u0005]!\u0001\u0002$jY\u0016Dq!!\n\u0002\f\u0001\u0007q&A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bBB\u001b\u0002\f\u0001\u0007q\u0007C\u0004\u0002,\u0005-\u0001\u0019A\u001c\u0002\u00195\f\u00070\u00138eKb\u001c\u0016N_3\t\ru\nY\u00011\u00010\u0011\u0019\t\u00151\u0002a\u0001\u0005\"Q\u00111GA\u0006!\u0003\u0005\r!!\u000e\u0002#\u0019LG.Z!me\u0016\fG-_#ySN$8\u000fE\u0002\n\u0003oI1!!\u000f\u000b\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0010\u0002\fA\u0005\t\u0019A\u001c\u0002\u0019%t\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3\t\u0015\u0005\u0005\u00131\u0002I\u0001\u0002\u0004\t)$A\u0006qe\u0016\fG\u000e\\8dCR,\u0007BBA#\u0001\u0011\u0005a&\u0001\u0003tSj,\u0007bBA%\u0001\u0011\u0005\u00111J\u0001\u0007CB\u0004XM\u001c3\u0015\u0013U\u000bi%!\u0015\u0002V\u0005e\u0003bBA(\u0003\u000f\u0002\raL\u0001\fM&\u00148\u000f^(gMN,G\u000fC\u0004\u0002T\u0005\u001d\u0003\u0019A\u0018\u0002!1\f'oZ3tiRKW.Z:uC6\u0004\bbBA,\u0003\u000f\u0002\raL\u0001\u0019_\u001a47/\u001a;PM2\u000b'oZ3tiRKW.Z:uC6\u0004\b\u0002CA.\u0003\u000f\u0002\r!!\u0018\u0002\u00115,7o]1hKN\u0004B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G\"\u0011aB7fgN\fw-Z\u0005\u0005\u0003O\n\tG\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\u0015\u0005\u0003\u000f\nY\u0007E\u0002\u0010\u0003[J1!a\u001c\u0011\u00055qwN\u001c;ie\u0016\fGm]1gK\"A\u00111\u000f\u0001\u0005\u0002\t\t)(A\bue\u0006t7\u000f\\1uK>3gm]3u)\u0019\t9(a!\u0002\bB1\u0011\"!\u001f\u0002~]J1!a\u001f\u000b\u0005\u0019!V\u000f\u001d7feA\u0019q#a \n\u0007\u0005\u0005%A\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\t\u000f\u0005\u0015\u0015\u0011\u000fa\u0001_\u00051qN\u001a4tKRD\u0011\"!#\u0002rA\u0005\t\u0019A\u001c\u0002)M$\u0018M\u001d;j]\u001e4\u0015\u000e\\3Q_NLG/[8oQ\u0011\t\t(!$\u0011\u0007=\ty)C\u0002\u0002\u0012B\u0011!\u0002\u001e5sK\u0006$7/\u00194f\u0011\u001d\t)\n\u0001C\u0001\u0003/\u000bAA]3bIRa\u0011\u0011TAS\u0003O\u000bY+a,\u00024B!\u00111TAQ\u001b\t\tiJC\u0002\u0002 \u0012\taa]3sm\u0016\u0014\u0018\u0002BAR\u0003;\u0013QBR3uG\"$\u0015\r^1J]\u001a|\u0007bBA\u0013\u0003'\u0003\ra\f\u0005\b\u0003S\u000b\u0019\n1\u0001h\u0003%i\u0017\r_(gMN,G\u000fC\u0004\u0002.\u0006M\u0005\u0019A\u001c\u0002\u000f5\f\u0007pU5{K\"I\u0011\u0011WAJ!\u0003\u0005\raL\u0001\f[\u0006D\bk\\:ji&|g\u000e\u0003\u0006\u00026\u0006M\u0005\u0013!a\u0001\u0003k\tQ\"\\5o\u001f:,W*Z:tC\u001e,\u0007\u0006BAJ\u0003\u001bCq!a/\u0001\t\u0003\ti,A\u0004sK\u000e|g/\u001a:\u0015\u0007]\ny\fC\u0004\u0002B\u0006e\u0006\u0019A\u001c\u0002\u001d5\f\u00070T3tg\u0006<WmU5{K\"\"\u0011\u0011XA6\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013\fA\u0003\\8bI2\u000b'oZ3tiRKW.Z:uC6\u0004HcA+\u0002L\"Q\u0011QZAc!\u0003\u0005\r!!\u000e\u0002\u0019I,\u0017\r\u001a+p\u0019><WI\u001c3\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\u0006AAo\\*ue&tw\r\u0006\u0002\u0002VB!\u0011q[Ao\u001b\t\tIN\u0003\u0003\u0002\\\u0006m\u0011\u0001\u00027b]\u001eLA!a8\u0002Z\n11\u000b\u001e:j]\u001eDq!a9\u0001\t\u0003\t)/\u0001\u0006ueVt7-\u0019;f)>$2aNAt\u0011\u001d\t))!9A\u0002=BC!!9\u0002l!9\u0011Q\u001e\u0001\u0005\u0002\u0005=\u0018A\u00038fqR|eMZ:fiR\tq\u0006\u000b\u0003\u0002l\u00065\u0005bBA{\u0001\u0011\u0005\u0011q_\u0001\u0006M2,8\u000f\u001b\u000b\u0002+\"\"\u00111_AG\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u007f\f!c\u00195b]\u001e,g)\u001b7f'V4g-\u001b=fgR)QK!\u0001\u0003\u001a!A!1AA~\u0001\u0004\u0011)!A\u0005pY\u0012\u001cVO\u001a4jqB!!q\u0001B\u000b\u001d\u0011\u0011IA!\u0005\u0011\u0007\t-!\"\u0004\u0002\u0003\u000e)\u0019!q\u0002\u0004\u0002\rq\u0012xn\u001c;?\u0013\r\u0011\u0019BC\u0001\u0007!J,G-\u001a4\n\t\u0005}'q\u0003\u0006\u0004\u0005'Q\u0001\u0002\u0003B\u000e\u0003w\u0004\rA!\u0002\u0002\u00139,woU;gM&D\bb\u0002B\u0010\u0001\u0011\u0005\u0011q_\u0001\u0018_:\u0014UmY8nK&s\u0017m\u0019;jm\u0016\u001cVmZ7f]RDqAa\t\u0001\t\u0003\u0011)#A\tuS6,w+Y5uK\u00124uN\u001d*pY2$Ra\fB\u0014\u0005WAqA!\u000b\u0003\"\u0001\u0007q&A\u0002o_^DqA!\f\u0003\"\u0001\u0007q&\u0001\tnKN\u001c\u0018mZ3US6,7\u000f^1na\"9!\u0011\u0007\u0001\u0005\u0002\tM\u0012!\u00064j]\u0012|eMZ:fi\nKH+[7fgR\fW\u000e\u001d\u000b\u0005\u0005k\u0011i\u0004\u0005\u0003\nQ\n]\u0002cA\f\u0003:%\u0019!1\b\u0002\u0003\u001fQKW.Z:uC6\u0004xJ\u001a4tKRDqAa\u0010\u00030\u0001\u0007q&A\u0005uS6,7\u000f^1na\"9!1\t\u0001\u0005\u0002\u0005]\u0018!B2m_N,\u0007b\u0002B$\u0001\u0011\u0005\u0011q_\u0001\u0007I\u0016dW\r^3\t\r\t-\u0003\u0001\"\u0001/\u00031a\u0017m\u001d;N_\u0012Lg-[3e\u0011\u0019\t\u0019\u0006\u0001C\u0001]!9!\u0011\u000b\u0001\u0005\u0002\tM\u0013\u0001\u00057bgRlu\u000eZ5gS\u0016$w\fJ3r)\u0011\t)D!\u0016\t\u000f\t]#q\na\u0001_\u0005\u0011Qn\u001d\u0005\n\u00057\u0002\u0011\u0013!C\u0001\u0005;\naB]3bI\u0012\"WMZ1vYR$C'\u0006\u0002\u0003`)\u001aqF!\u0019,\u0005\t\r\u0004\u0003\u0002B3\u0005_j!Aa\u001a\u000b\t\t%$1N\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u001c\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005c\u00129GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011B!\u001e\u0001#\u0003%\tAa\u001e\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!\u0011\u0010\u0016\u0005\u0003k\u0011\t\u0007\u0003\u0006\u0003~\u0001\t\n\u0011\"\u0001\u0003\u0005\u007f\n\u0011\u0004\u001e:b]Nd\u0017\r^3PM\u001a\u001cX\r\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0011\u0016\u0004o\t\u0005\u0004\"\u0003BC\u0001E\u0005I\u0011\u0001B<\u0003yaw.\u00193MCJ<Wm\u001d;US6,7\u000f^1na\u0012\"WMZ1vYR$\u0013\u0007K\u0002\u0001\u0003W:\u0011Ba#\u0003\u0003\u0003E\tA!$\u0002\u00151{wmU3h[\u0016tG\u000fE\u0002\u0018\u0005\u001f3\u0001\"\u0001\u0002\u0002\u0002#\u0005!\u0011S\n\u0004\u0005\u001fC\u0001b\u0002$\u0003\u0010\u0012\u0005!Q\u0013\u000b\u0003\u0005\u001bC!B!'\u0003\u0010F\u0005I\u0011\u0001B<\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%o!Q!Q\u0014BH#\u0003%\tAa \u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139\u0011)\u0011\tKa$\u0012\u0002\u0013\u0005!qO\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d")
public class LogSegment
implements Logging {
    private final FileMessageSet log;
    private final OffsetIndex index;
    private final TimeIndex timeIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private Option<Object> rollingBasedTimestamp;
    private volatile long maxTimestampSoFar;
    private volatile long offsetOfMaxTimestamp;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$9() {
        return LogSegment$.MODULE$.$lessinit$greater$default$9();
    }

    public static int $lessinit$greater$default$8() {
        return LogSegment$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$7() {
        return LogSegment$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public FileMessageSet log() {
        return this.log;
    }

    public OffsetIndex index() {
        return this.index;
    }

    public TimeIndex timeIndex() {
        return this.timeIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public long created() {
        return this.created;
    }

    public void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private long maxTimestampSoFar() {
        return this.maxTimestampSoFar;
    }

    private void maxTimestampSoFar_$eq(long x$1) {
        this.maxTimestampSoFar = x$1;
    }

    private long offsetOfMaxTimestamp() {
        return this.offsetOfMaxTimestamp;
    }

    private void offsetOfMaxTimestamp_$eq(long x$1) {
        this.offsetOfMaxTimestamp = x$1;
    }

    public long size() {
        return this.log().sizeInBytes();
    }

    public void append(long firstOffset, long largestTimestamp, long offsetOfLargestTimestamp, ByteBufferMessageSet messages) {
        block3: {
            if (messages.sizeInBytes() <= 0) break block3;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d with largest timestamp %d at offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messages.sizeInBytes()), BoxesRunTime.boxToLong((long)firstOffset), BoxesRunTime.boxToInteger((int)this.log().sizeInBytes()), BoxesRunTime.boxToLong((long)largestTimestamp), BoxesRunTime.boxToLong((long)offsetOfLargestTimestamp)})));
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.log().append(messages);
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampSoFar_$eq(largestTimestamp);
                this.offsetOfMaxTimestamp_$eq(offsetOfLargestTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(firstOffset, physicalPosition);
                this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), this.timeIndex().maybeAppend$default$3());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + messages.sizeInBytes());
        }
    }

    public Tuple2<OffsetPosition, Object> translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.index().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int n;
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize)})));
        }
        int logSize = this.log().sizeInBytes();
        Tuple2<OffsetPosition, Object> startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        Tuple2<OffsetPosition, Object> tuple2 = startOffsetAndSize;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        OffsetPosition startPosition = (OffsetPosition)tuple2._1();
        int messageSetSize = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)startPosition, (Object)BoxesRunTime.boxToInteger((int)messageSetSize));
        Tuple2 tuple23 = tuple22;
        OffsetPosition startPosition2 = (OffsetPosition)tuple23._1();
        int messageSetSize2 = tuple23._2$mcI$sp();
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition2.position());
        int n2 = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, messageSetSize2) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, MessageSet$.MODULE$.Empty(), FetchDataInfo$.MODULE$.apply$default$3());
        }
        Option<Object> option = maxOffset;
        if (None$.MODULE$.equals(option)) {
            n = package$.MODULE$.min((int)(maxPosition - (long)startPosition2.position()), adjustedMaxSize);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long offset = BoxesRunTime.unboxToLong((Object)some.value());
            if (offset < startOffset) {
                return new FetchDataInfo(offsetMetadata, MessageSet$.MODULE$.Empty(), false);
            }
            Tuple2<OffsetPosition, Object> mapping = this.translateOffset(offset, startPosition2.position());
            int endPosition = mapping == null ? logSize : ((OffsetPosition)mapping._1()).position();
            n = (int)package$.MODULE$.min(package$.MODULE$.min(maxPosition, (long)endPosition) - (long)startPosition2.position(), (long)adjustedMaxSize);
        } else {
            throw new MatchError(option);
        }
        int length = n;
        return new FetchDataInfo(offsetMetadata, this.log().read(startPosition2.position(), length), adjustedMaxSize < messageSetSize2);
    }

    public long read$default$4() {
        return this.size();
    }

    public boolean read$default$5() {
        return false;
    }

    public int recover(int maxMessageSize) {
        this.index().truncate();
        this.index().resize(this.index().maxIndexSize());
        this.timeIndex().truncate();
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int validBytes = 0;
        int lastIndexEntry = 0;
        Iterator<MessageAndOffset> iter = this.log().iterator(maxMessageSize);
        this.maxTimestampSoFar_$eq(Message$.MODULE$.NoTimestamp());
        try {
            while (iter.hasNext()) {
                MessageAndOffset entry = (MessageAndOffset)iter.next();
                entry.message().ensureValid();
                if (entry.message().timestamp() > this.maxTimestampSoFar()) {
                    this.maxTimestampSoFar_$eq(entry.message().timestamp());
                    this.offsetOfMaxTimestamp_$eq(entry.offset());
                }
                if (validBytes - lastIndexEntry > this.indexIntervalBytes()) {
                    long startOffset = entry.firstOffset();
                    this.index().append(startOffset, validBytes);
                    this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), this.timeIndex().maybeAppend$default$3());
                    lastIndexEntry = validBytes;
                }
                validBytes += MessageSet$.MODULE$.entrySize(entry.message());
            }
        }
        catch (CorruptRecordException e) {
            this.logger().warn((Object)new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes), e.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes;
        this.log().truncateTo(validBytes);
        this.index().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public void loadLargestTimestamp(boolean readToLogEnd) {
        block1: {
            TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
            this.maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
            this.offsetOfMaxTimestamp_$eq(lastTimeIndexEntry.offset());
            if (!readToLogEnd) break block1;
            OffsetPosition offsetPosition = this.index().lookup(lastTimeIndexEntry.offset());
            TimestampOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
            if (maxTimestampOffsetAfterLastEntry.timestamp() > lastTimeIndexEntry.timestamp()) {
                this.maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp());
                this.offsetOfMaxTimestamp_$eq(maxTimestampOffsetAfterLastEntry.offset());
            }
        }
    }

    public boolean loadLargestTimestamp$default$1() {
        return false;
    }

    public String toString() {
        return "LogSegment(baseOffset=" + this.baseOffset() + ", size=" + this.size() + ")";
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        block3: {
            OffsetPosition offsetPosition;
            Tuple2<OffsetPosition, Object> mapping = this.translateOffset(offset, this.translateOffset$default$2());
            if (mapping == null) {
                return 0;
            }
            this.index().truncateTo(offset);
            this.timeIndex().truncateTo(offset);
            this.index().resize(this.index().maxIndexSize());
            this.timeIndex().resize(this.timeIndex().maxIndexSize());
            Tuple2<OffsetPosition, Object> tuple2 = mapping;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            OffsetPosition offsetPosition2 = offsetPosition = (OffsetPosition)tuple2._1();
            OffsetPosition offsetPosition3 = offsetPosition2;
            bytesTruncated = this.log().truncateTo(offsetPosition3.position());
            if (this.log().sizeInBytes() == 0) {
                this.created_$eq(this.time.milliseconds());
                this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
            }
            this.bytesSinceLastIndexEntry_$eq(0);
            if (this.maxTimestampSoFar() < 0L) break block3;
            this.loadLargestTimestamp(true);
        }
        return bytesTruncated;
    }

    public long nextOffset() {
        long l;
        FetchDataInfo ms = this.read(this.index().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes(), this.read$default$4(), this.read$default$5());
        if (ms == null) {
            l = this.baseOffset();
        } else {
            long l2;
            Option<MessageAndOffset> option = ms.messageSet().lastOption();
            if (None$.MODULE$.equals(option)) {
                l2 = this.baseOffset();
            } else if (option instanceof Some) {
                Some some = (Some)option;
                MessageAndOffset last = (MessageAndOffset)some.value();
                l2 = last.nextOffset();
            } else {
                throw new MatchError(option);
            }
            l = l2;
        }
        return l;
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.log().flush();
            this.index().flush();
            this.timeIndex().flush();
        });
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        try {
            this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        }
        catch (IOException e) {
            throw this.kafkaStorageException$1("log", e, oldSuffix, newSuffix);
        }
        try {
            this.index().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.index().file().getPath(), oldSuffix, newSuffix)));
        }
        catch (IOException e) {
            throw this.kafkaStorageException$1("index", e, oldSuffix, newSuffix);
        }
        try {
            this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.timeIndex().file().getPath(), oldSuffix, newSuffix)));
        }
        catch (IOException e) {
            throw this.kafkaStorageException$1("timeindex", e, oldSuffix, newSuffix);
        }
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true);
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        Some some;
        long t;
        Option<Object> option;
        Iterator<MessageAndOffset> iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((MessageAndOffset)iter.next()).message().timestamp())));
        }
        long l = (option = this.rollingBasedTimestamp()) instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public Option<TimestampOffset> findOffsetByTimestamp(long timestamp) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.index().lookup(timestampOffset.offset()).position();
        return this.log().searchForTimestamp(timestamp, position);
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true));
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.index().close());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().close());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().close());
    }

    public void delete() {
        boolean deletedLog = this.log().delete();
        boolean deletedIndex = this.index().delete();
        boolean deletedTimeIndex = this.timeIndex().delete();
        if (!deletedLog && this.log().file().exists()) {
            throw new KafkaStorageException("Delete of log " + this.log().file().getName() + " failed.");
        }
        if (!deletedIndex && this.index().file().exists()) {
            throw new KafkaStorageException("Delete of index " + this.index().file().getName() + " failed.");
        }
        if (!deletedTimeIndex && this.timeIndex().file().exists()) {
            throw new KafkaStorageException("Delete of time index " + this.timeIndex().file().getName() + " failed.");
        }
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        return this.maxTimestampSoFar() >= 0L ? this.maxTimestampSoFar() : this.lastModified();
    }

    public boolean lastModified_$eq(long ms) {
        this.log().file().setLastModified(ms);
        this.index().file().setLastModified(ms);
        return this.timeIndex().file().setLastModified(ms);
    }

    private final KafkaStorageException kafkaStorageException$1(String fileType, IOException e, String oldSuffix$1, String newSuffix$1) {
        return new KafkaStorageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to change the ", " file suffix from ", " to ", " for log segment ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileType, oldSuffix$1, newSuffix$1, BoxesRunTime.boxToLong((long)this.baseOffset())})), e);
    }

    public LogSegment(FileMessageSet log, OffsetIndex index, TimeIndex timeIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.index = index;
        this.timeIndex = timeIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this.maxTimestampSoFar = timeIndex.lastEntry().timestamp();
        this.offsetOfMaxTimestamp = timeIndex.lastEntry().offset();
    }

    public LogSegment(File dir, long startOffset, int indexIntervalBytes, int maxIndexSize, long rollJitterMs, Time time, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        this(new FileMessageSet(Log$.MODULE$.logFilename(dir, startOffset), fileAlreadyExists, initFileSize, preallocate), new OffsetIndex(Log$.MODULE$.indexFilename(dir, startOffset), startOffset, maxIndexSize), new TimeIndex(Log$.MODULE$.timeIndexFilename(dir, startOffset), startOffset, maxIndexSize), startOffset, indexIntervalBytes, rollJitterMs, time);
    }
}

