/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import kafka.common.KafkaException;
import kafka.message.ByteBufferBackedInputStream;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.InvalidMessageException;
import kafka.message.MagicAndTimestamp;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.MessageWriter;
import kafka.message.NoCompressionCodec$;
import kafka.message.OffsetAssigner;
import kafka.utils.CoreUtils$;
import kafka.utils.IteratorTemplate;
import org.apache.kafka.common.record.TimestampType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

public final class ByteBufferMessageSet$ {
    public static ByteBufferMessageSet$ MODULE$;

    static {
        new ByteBufferMessageSet$();
    }

    public ByteBuffer kafka$message$ByteBufferMessageSet$$create(OffsetAssigner offsetAssigner, CompressionCodec compressionCodec, Option<Object> wrapperMessageTimestamp, TimestampType timestampType, Seq<Message> messages) {
        ByteBuffer byteBuffer;
        if (messages.isEmpty()) {
            byteBuffer = MessageSet$.MODULE$.Empty().buffer();
        } else {
            CompressionCodec compressionCodec2 = compressionCodec;
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
                ByteBuffer buffer = ByteBuffer.allocate(MessageSet$.MODULE$.messageSetSize((Iterable<Message>)messages));
                messages.foreach((Function1 & Serializable & scala.Serializable)message -> {
                    this.writeMessage(buffer, message, offsetAssigner.nextAbsoluteOffset());
                    return BoxedUnit.UNIT;
                });
                buffer.rewind();
                byteBuffer = buffer;
            } else {
                MagicAndTimestamp magicAndTimestamp;
                Option<Object> option = wrapperMessageTimestamp;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    long ts = BoxesRunTime.unboxToLong((Object)some.value());
                    magicAndTimestamp = new MagicAndTimestamp(((Message)messages.head()).magic(), ts);
                } else if (None$.MODULE$.equals(option)) {
                    magicAndTimestamp = MessageSet$.MODULE$.magicAndLargestTimestamp(messages);
                } else {
                    throw new MatchError(option);
                }
                MagicAndTimestamp magicAndTimestamp2 = magicAndTimestamp;
                LongRef offset = LongRef.create((long)-1L);
                MessageWriter messageWriter = new MessageWriter(package$.MODULE$.min(package$.MODULE$.max(MessageSet$.MODULE$.messageSetSize((Iterable<Message>)messages) / 2, 1024), 65536));
                CompressionCodec x$4 = compressionCodec;
                long x$5 = magicAndTimestamp2.timestamp();
                TimestampType x$6 = timestampType;
                byte x$7 = magicAndTimestamp2.magic();
                byte[] x$8 = messageWriter.write$default$1();
                Function1 & Serializable & scala.Serializable x$9 = (Function1 & Serializable & scala.Serializable)outputStream -> {
                    ByteBufferMessageSet$.$anonfun$create$2(offsetAssigner, compressionCodec, messages, magicAndTimestamp2, offset, outputStream);
                    return BoxedUnit.UNIT;
                };
                messageWriter.write(x$8, x$4, x$5, x$6, x$7, (Function1<OutputStream, BoxedUnit>)x$9);
                ByteBuffer buffer = ByteBuffer.allocate(messageWriter.size() + MessageSet$.MODULE$.LogOverhead());
                this.writeMessage(buffer, messageWriter, offset.elem);
                buffer.rewind();
                byteBuffer = buffer;
            }
        }
        return byteBuffer;
    }

    public Iterator<MessageAndOffset> deepIterator(MessageAndOffset wrapperMessageAndOffset, boolean ensureMatchingMagic) {
        return new IteratorTemplate<MessageAndOffset>(wrapperMessageAndOffset, ensureMatchingMagic){
            private final /* synthetic */ Tuple2 x$1;
            private final Message wrapperMessage;
            private final long wrapperMessageOffset;
            private final Option<Object> wrapperMessageTimestampOpt;
            private final Option<TimestampType> wrapperMessageTimestampTypeOpt;
            private long lastInnerOffset;
            private final ArrayDeque<MessageAndOffset> messageAndOffsets;
            private final boolean ensureMatchingMagic$1;

            private Message wrapperMessage() {
                return this.wrapperMessage;
            }

            private long wrapperMessageOffset() {
                return this.wrapperMessageOffset;
            }

            private Option<Object> wrapperMessageTimestampOpt() {
                return this.wrapperMessageTimestampOpt;
            }

            private Option<TimestampType> wrapperMessageTimestampTypeOpt() {
                return this.wrapperMessageTimestampTypeOpt;
            }

            private long lastInnerOffset() {
                return this.lastInnerOffset;
            }

            private void lastInnerOffset_$eq(long x$1) {
                this.lastInnerOffset = x$1;
            }

            private ArrayDeque<MessageAndOffset> messageAndOffsets() {
                return this.messageAndOffsets;
            }

            private MessageAndOffset readMessageFromStream(DataInputStream compressed) {
                long innerOffset = compressed.readLong();
                int recordSize = compressed.readInt();
                if (recordSize < Message$.MODULE$.MinMessageOverhead()) {
                    throw new InvalidMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message found with corrupt size `", "` in deep iterator"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)recordSize)})));
                }
                byte[] bufferArray = new byte[recordSize];
                compressed.readFully(bufferArray, 0, recordSize);
                ByteBuffer buffer = ByteBuffer.wrap(bufferArray);
                Message newMessage = new Message(buffer, this.wrapperMessageTimestampOpt(), this.wrapperMessageTimestampTypeOpt());
                if (this.ensureMatchingMagic$1 && newMessage.magic() != this.wrapperMessage().magic()) {
                    throw new InvalidMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compressed message has magic value ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)this.wrapperMessage().magic())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but inner message has magic value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)newMessage.magic())})));
                }
                this.lastInnerOffset_$eq(innerOffset);
                return new MessageAndOffset(newMessage, innerOffset);
            }

            public MessageAndOffset makeNext() {
                MessageAndOffset messageAndOffset;
                MessageAndOffset messageAndOffset2 = this.messageAndOffsets().pollFirst();
                if (messageAndOffset2 == null) {
                    messageAndOffset = (MessageAndOffset)this.allDone();
                } else if (messageAndOffset2 != null) {
                    MessageAndOffset messageAndOffset3;
                    Message message = messageAndOffset2.message();
                    long offset = messageAndOffset2.offset();
                    if (this.wrapperMessage().magic() > Message$.MODULE$.MagicValue_V0()) {
                        long relativeOffset = offset - this.lastInnerOffset();
                        long absoluteOffset = this.wrapperMessageOffset() + relativeOffset;
                        messageAndOffset3 = new MessageAndOffset(message, absoluteOffset);
                    } else {
                        messageAndOffset3 = messageAndOffset2;
                    }
                    messageAndOffset = messageAndOffset3;
                } else {
                    throw new MatchError((Object)messageAndOffset2);
                }
                return messageAndOffset;
            }

            private final DataInputStream liftedTree1$1(ByteBufferBackedInputStream inputStream$1) {
                DataInputStream dataInputStream;
                try {
                    dataInputStream = new DataInputStream(CompressionFactory$.MODULE$.apply(this.wrapperMessage().compressionCodec(), this.wrapperMessage().magic(), inputStream$1));
                }
                catch (IOException ioe) {
                    throw new InvalidMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to instantiate input stream compressed with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.wrapperMessage().compressionCodec()})), ioe);
                }
                return dataInputStream;
            }

            private final void liftedTree2$1(DataInputStream compressed$1, ArrayDeque innerMessageAndOffsets$1) {
                try {
                    try {
                        while (true) {
                            innerMessageAndOffsets$1.add(this.readMessageFromStream(compressed$1));
                        }
                    }
                    catch (EOFException eOFException) {
                    }
                    catch (IOException ioe) {
                        throw new InvalidMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while reading message from stream compressed with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.wrapperMessage().compressionCodec()})), ioe);
                    }
                }
                finally {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> compressed$1.close());
                }
            }
            {
                this.ensureMatchingMagic$1 = ensureMatchingMagic$1;
                MessageAndOffset messageAndOffset = wrapperMessageAndOffset$1;
                if (messageAndOffset == null) {
                    throw new MatchError((Object)messageAndOffset);
                }
                Message wrapperMessage = messageAndOffset.message();
                long wrapperMessageOffset = messageAndOffset.offset();
                Tuple2 tuple2 = new Tuple2((Object)wrapperMessage, (Object)BoxesRunTime.boxToLong((long)wrapperMessageOffset));
                this.x$1 = tuple2;
                this.wrapperMessage = (Message)this.x$1._1();
                this.wrapperMessageOffset = this.x$1._2$mcJ$sp();
                if (this.wrapperMessage().payload() == null) {
                    throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message payload is null: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.wrapperMessage()})));
                }
                this.wrapperMessageTimestampOpt = this.wrapperMessage().magic() > Message$.MODULE$.MagicValue_V0() ? new Some((Object)BoxesRunTime.boxToLong((long)this.wrapperMessage().timestamp())) : None$.MODULE$;
                this.wrapperMessageTimestampTypeOpt = this.wrapperMessage().magic() > Message$.MODULE$.MagicValue_V0() ? new Some((Object)this.wrapperMessage().timestampType()) : None$.MODULE$;
                this.lastInnerOffset = -1L;
                ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(this.wrapperMessage().payload());
                DataInputStream compressed = this.liftedTree1$1(inputStream);
                ArrayDeque<E> innerMessageAndOffsets = new ArrayDeque<E>();
                this.liftedTree2$1(compressed, innerMessageAndOffsets);
                this.messageAndOffsets = innerMessageAndOffsets;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$messageAndOffsets$1(java.io.DataInputStream )}, serializedLambda);
            }
        };
    }

    public boolean deepIterator$default$2() {
        return false;
    }

    public void writeMessage(ByteBuffer buffer, Message message, long offset) {
        buffer.putLong(offset);
        buffer.putInt(message.size());
        buffer.put(message.buffer());
        message.buffer().rewind();
    }

    public void writeMessage(ByteBuffer buffer, MessageWriter messageWriter, long offset) {
        buffer.putLong(offset);
        buffer.putInt(messageWriter.size());
        messageWriter.writeTo(buffer);
    }

    public static final /* synthetic */ void $anonfun$create$3(OffsetAssigner offsetAssigner$1, MagicAndTimestamp magicAndTimestamp$1, LongRef offset$1, DataOutputStream output$1, Message message) {
        offset$1.elem = offsetAssigner$1.nextAbsoluteOffset();
        if (message.magic() != magicAndTimestamp$1.magic()) {
            throw new IllegalArgumentException("Messages in the message set must have same magic value");
        }
        if (magicAndTimestamp$1.magic() > Message$.MODULE$.MagicValue_V0()) {
            output$1.writeLong(offsetAssigner$1.toInnerOffset(offset$1.elem));
        } else {
            output$1.writeLong(offset$1.elem);
        }
        output$1.writeInt(message.size());
        output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
    }

    public static final /* synthetic */ void $anonfun$create$2(OffsetAssigner offsetAssigner$1, CompressionCodec compressionCodec$1, Seq messages$1, MagicAndTimestamp magicAndTimestamp$1, LongRef offset$1, OutputStream outputStream) {
        try (DataOutputStream output = new DataOutputStream(CompressionFactory$.MODULE$.apply(compressionCodec$1, magicAndTimestamp$1.magic(), outputStream));){
            messages$1.foreach((Function1 & Serializable & scala.Serializable)message -> {
                ByteBufferMessageSet$.$anonfun$create$3(offsetAssigner$1, magicAndTimestamp$1, offset$1, output, message);
                return BoxedUnit.UNIT;
            });
        }
    }

    private ByteBufferMessageSet$() {
        MODULE$ = this;
    }
}

