/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$CloseConnectionAction$;
import kafka.network.RequestChannel$NoOpAction$;
import kafka.network.RequestChannel$SendAction$;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.LoginType;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t5g!B\u0001\u0003\u0001\u00111!!\u0003)s_\u000e,7o]8s\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0003\u0015\tQa[1gW\u0006\u001c2\u0001A\u0004\f!\tA\u0011\"D\u0001\u0003\u0013\tQ!A\u0001\u000bBEN$(/Y2u'\u0016\u0014h/\u001a:UQJ,\u0017\r\u001a\t\u0003\u0019=i\u0011!\u0004\u0006\u0003\u001d\u0011\tq!\\3ue&\u001c7/\u0003\u0002\u0011\u001b\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\t\u0011I\u0001!Q1A\u0005\u0002Q\t!!\u001b3\u0004\u0001U\tQ\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrCA\u0002J]RD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0004S\u0012\u0004\u0003\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\tQLW.\u001a\t\u0003A)j\u0011!\t\u0006\u0003E\r\nQ!\u001e;jYNT!\u0001J\u0013\u0002\r\r|W.\\8o\u0015\t)aE\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<\u0017BA\u0016\"\u0005\u0011!\u0016.\\3\t\u00115\u0002!\u0011!Q\u0001\nU\ta\"\\1y%\u0016\fX/Z:u'&TX\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\"\u0001C\u0019\n\u0005I\u0012!A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0005\ti\u0001\u0011\t\u0011)A\u0005k\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\t\u0003\u0011YJ!a\u000e\u0002\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\b\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002)\r|gN\\3di&|gn]'bq&#G.Z't!\t12(\u0003\u0002=/\t!Aj\u001c8h\u0011!q\u0004A!A!\u0002\u0013y\u0014\u0001\u00039s_R|7m\u001c7\u0011\u0005\u0001\u0013U\"A!\u000b\u0005y\u001a\u0013BA\"B\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G\u000e\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u00039\u0019\u0007.\u00198oK2\u001cuN\u001c4jON\u0004$a\u0012/\u0011\t!kuJW\u0007\u0002\u0013*\u0011!jS\u0001\u0005kRLGNC\u0001M\u0003\u0011Q\u0017M^1\n\u00059K%aA'baB\u0011\u0001k\u0016\b\u0003#V\u0003\"AU\f\u000e\u0003MS!\u0001V\n\u0002\rq\u0012xn\u001c;?\u0013\t1v#\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,\u0018!\tYF\f\u0004\u0001\u0005\u0013u#\u0015\u0011!A\u0001\u0006\u0003q&aA0%cE\u0011qL\u0019\t\u0003-\u0001L!!Y\f\u0003\u000f9{G\u000f[5oOB\u0011acY\u0005\u0003I^\u00111!\u00118z\u0011!q\u0001A!A!\u0002\u00131\u0007CA4j\u001b\u0005A'B\u0001\b$\u0013\tQ\u0007NA\u0004NKR\u0014\u0018nY:\t\u000b1\u0004A\u0011A7\u0002\rqJg.\u001b;?))qw\u000e]9sgR,ho\u001f\t\u0003\u0011\u0001AQAE6A\u0002UAQAH6A\u0002}AQ!L6A\u0002UAQaL6A\u0002ABQ\u0001N6A\u0002UBQ!O6A\u0002iBQAP6A\u0002}BQ!R6A\u0002]\u0004$\u0001\u001f>\u0011\t!ku*\u001f\t\u00037j$\u0011\"\u0018<\u0002\u0002\u0003\u0005)\u0011\u00010\t\u000b9Y\u0007\u0019\u00014\b\u000bu\u0004\u0001\u0012\u0002@\u0002\u0019\r{gN\\3di&|g.\u00133\u0011\u0007}\f\t!D\u0001\u0001\r\u001d\t\u0019\u0001\u0001E\u0005\u0003\u000b\u0011AbQ8o]\u0016\u001cG/[8o\u0013\u0012\u001cb!!\u0001\u0002\b\u00055\u0001c\u0001\f\u0002\n%\u0019\u00111B\f\u0003\r\u0005s\u0017PU3g!\r1\u0012qB\u0005\u0004\u0003#9\"\u0001D*fe&\fG.\u001b>bE2,\u0007b\u00027\u0002\u0002\u0011\u0005\u0011Q\u0003\u000b\u0002}\"A\u0011\u0011DA\u0001\t\u0003\tY\"\u0001\u0006ge>l7\u000b\u001e:j]\u001e$B!!\b\u0002hB)a#a\b\u0002$%\u0019\u0011\u0011E\f\u0003\r=\u0003H/[8o!\ry\u0018Q\u0005\u0004\u0007\u0003\u0007\u0001A)a\n\u0014\u0011\u0005\u0015\u0012qAA\u0015\u0003\u001b\u00012AFA\u0016\u0013\r\tic\u0006\u0002\b!J|G-^2u\u0011-\t\t$!\n\u0003\u0016\u0004%\t!a\r\u0002\u00131|7-\u00197I_N$X#A(\t\u0015\u0005]\u0012Q\u0005B\tB\u0003%q*\u0001\u0006m_\u000e\fG\u000eS8ti\u0002B!\"a\u000f\u0002&\tU\r\u0011\"\u0001\u0015\u0003%awnY1m!>\u0014H\u000f\u0003\u0006\u0002@\u0005\u0015\"\u0011#Q\u0001\nU\t!\u0002\\8dC2\u0004vN\u001d;!\u0011-\t\u0019%!\n\u0003\u0016\u0004%\t!a\r\u0002\u0015I,Wn\u001c;f\u0011>\u001cH\u000f\u0003\u0006\u0002H\u0005\u0015\"\u0011#Q\u0001\n=\u000b1B]3n_R,\u0007j\\:uA!Q\u00111JA\u0013\u0005+\u0007I\u0011\u0001\u000b\u0002\u0015I,Wn\u001c;f!>\u0014H\u000f\u0003\u0006\u0002P\u0005\u0015\"\u0011#Q\u0001\nU\t1B]3n_R,\u0007k\u001c:uA!9A.!\n\u0005\u0002\u0005MCCCA\u0012\u0003+\n9&!\u0017\u0002\\!9\u0011\u0011GA)\u0001\u0004y\u0005bBA\u001e\u0003#\u0002\r!\u0006\u0005\b\u0003\u0007\n\t\u00061\u0001P\u0011\u001d\tY%!\u0015A\u0002UA\u0001\"a\u0018\u0002&\u0011\u0005\u0013\u0011M\u0001\ti>\u001cFO]5oOR\tq\n\u0003\u0006\u0002f\u0005\u0015\u0012\u0011!C\u0001\u0003O\nAaY8qsRQ\u00111EA5\u0003W\ni'a\u001c\t\u0013\u0005E\u00121\rI\u0001\u0002\u0004y\u0005\"CA\u001e\u0003G\u0002\n\u00111\u0001\u0016\u0011%\t\u0019%a\u0019\u0011\u0002\u0003\u0007q\nC\u0005\u0002L\u0005\r\u0004\u0013!a\u0001+!Q\u00111OA\u0013#\u0003%\t!!\u001e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u000f\u0016\u0004\u001f\u0006e4FAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015u#\u0001\u0006b]:|G/\u0019;j_:LA!!#\u0002\u0000\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u00055\u0015QEI\u0001\n\u0003\ty)\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E%fA\u000b\u0002z!Q\u0011QSA\u0013#\u0003%\t!!\u001e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q\u0011\u0011TA\u0013#\u0003%\t!a$\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i!Q\u0011QTA\u0013\u0003\u0003%\t%a(\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u000b\u0005\u0003\u0002$\u0006%VBAAS\u0015\r\t9kS\u0001\u0005Y\u0006tw-C\u0002Y\u0003KC\u0011\"!,\u0002&\u0005\u0005I\u0011\u0001\u000b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\u0005E\u0016QEA\u0001\n\u0003\t\u0019,\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\t\f)\fC\u0005\u00028\u0006=\u0016\u0011!a\u0001+\u0005\u0019\u0001\u0010J\u0019\t\u0015\u0005m\u0016QEA\u0001\n\u0003\ni,A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\fE\u0003\u0002B\u0006\u001d'-\u0004\u0002\u0002D*\u0019\u0011QY\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002J\u0006\r'\u0001C%uKJ\fGo\u001c:\t\u0015\u00055\u0017QEA\u0001\n\u0003\ty-\u0001\u0005dC:,\u0015/^1m)\u0011\t\t.a6\u0011\u0007Y\t\u0019.C\u0002\u0002V^\u0011qAQ8pY\u0016\fg\u000eC\u0005\u00028\u0006-\u0017\u0011!a\u0001E\"Q\u00111\\A\u0013\u0003\u0003%\t%!8\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\u0006\u0005\u000b\u0003C\f)#!A\u0005B\u0005\r\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002R\u0006\u0015\b\"CA\\\u0003?\f\t\u00111\u0001c\u0011\u001d\tI/a\u0006A\u0002=\u000b\u0011a\u001d\u0005\u000b\u0003[\f\t!!A\u0005\u0002\u0006=\u0018!B1qa2LHCCA\u0012\u0003c\f\u00190!>\u0002x\"9\u0011\u0011GAv\u0001\u0004y\u0005bBA\u001e\u0003W\u0004\r!\u0006\u0005\b\u0003\u0007\nY\u000f1\u0001P\u0011\u001d\tY%a;A\u0002UA!\"a?\u0002\u0002\u0005\u0005I\u0011QA\u007f\u0003\u001d)h.\u00199qYf$B!a@\u0003\bA)a#a\b\u0003\u0002A9aCa\u0001P+=+\u0012b\u0001B\u0003/\t1A+\u001e9mKRB!B!\u0003\u0002z\u0006\u0005\t\u0019AA\u0012\u0003\rAH\u0005\r\u0005\n\u0005\u001b\u0001!\u0019!C\u0005\u0005\u001f\taB\\3x\u0007>tg.Z2uS>t7/\u0006\u0002\u0003\u0012A1!1\u0003B\r\u0005;i!A!\u0006\u000b\u0007\t]\u0011*\u0001\u0006d_:\u001cWO\u001d:f]RLAAa\u0007\u0003\u0016\t)2i\u001c8dkJ\u0014XM\u001c;MS:\\W\rZ)vKV,\u0007\u0003\u0002B\u0010\u0005Si!A!\t\u000b\t\t\r\"QE\u0001\tG\"\fgN\\3mg*\u0019!qE&\u0002\u00079Lw.\u0003\u0003\u0003,\t\u0005\"!D*pG.,Go\u00115b]:,G\u000e\u0003\u0005\u00030\u0001\u0001\u000b\u0011\u0002B\t\u0003=qWm^\"p]:,7\r^5p]N\u0004\u0003\"\u0003B\u001a\u0001\t\u0007I\u0011\u0002B\u001b\u0003EIgN\u001a7jO\"$(+Z:q_:\u001cXm]\u000b\u0003\u0005o\u0001rA!\u000f\u0003@=\u0013\t%\u0004\u0002\u0003<)!!QHAb\u0003\u001diW\u000f^1cY\u0016L1A\u0014B\u001e!\u0011\u0011\u0019E!\u0013\u000f\u0007!\u0011)%C\u0002\u0003H\t\taBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0003\u0003L\t5#\u0001\u0003*fgB|gn]3\u000b\u0007\t\u001d#\u0001\u0003\u0005\u0003R\u0001\u0001\u000b\u0011\u0002B\u001c\u0003IIgN\u001a7jO\"$(+Z:q_:\u001cXm\u001d\u0011\t\u0013\tU\u0003A1A\u0005\n\t]\u0013AC7fiJL7\rV1hgV\u0011!\u0011\f\t\u0007\u00116\u000b\t+!)\t\u0011\tu\u0003\u0001)A\u0005\u00053\n1\"\\3ue&\u001cG+Y4tA!I!\u0011\r\u0001C\u0002\u0013%!1M\u0001\tg\u0016dWm\u0019;peV\u0011!Q\r\t\u0005\u0005O\u0012Y'\u0004\u0002\u0003j)\u00111aI\u0005\u0005\u0005[\u0012IG\u0001\u0005TK2,7\r^8s\u0011!\u0011\t\b\u0001Q\u0001\n\t\u0015\u0014!C:fY\u0016\u001cGo\u001c:!\u0011\u001d\u0011)\b\u0001C!\u0005o\n1A];o)\t\u0011I\bE\u0002\u0017\u0005wJ1A! \u0018\u0005\u0011)f.\u001b;\t\u000f\t\u0005\u0005\u0001\"\u0003\u0003x\u0005\u0019\u0002O]8dKN\u001ch*Z<SKN\u0004xN\\:fg\"A!Q\u0011\u0001\u0005\u0012\t\u00119)\u0001\u0007tK:$'+Z:q_:\u001cX\r\u0006\u0003\u0003z\t%\u0005\u0002\u0003BF\u0005\u0007\u0003\rA!\u0011\u0002\u0011I,7\u000f]8og\u0016DqAa$\u0001\t\u0013\u00119(\u0001\u0003q_2d\u0007b\u0002BJ\u0001\u0011%!qO\u0001\u0019aJ|7-Z:t\u0007>l\u0007\u000f\\3uK\u0012\u0014VmY3jm\u0016\u001c\bb\u0002BL\u0001\u0011%!qO\u0001\u0016aJ|7-Z:t\u0007>l\u0007\u000f\\3uK\u0012\u001cVM\u001c3t\u0011\u001d\u0011Y\n\u0001C\u0005\u0005o\n1\u0003\u001d:pG\u0016\u001c8\u000fR5tG>tg.Z2uK\u0012DqAa(\u0001\t\u0003\u0011\t+\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0005\u0005s\u0012\u0019\u000b\u0003\u0005\u0003&\nu\u0005\u0019\u0001B\u000f\u00035\u0019xnY6fi\u000eC\u0017M\u001c8fY\"9!\u0011\u0016\u0001\u0005\n\t]\u0014aF2p]\u001aLw-\u001e:f\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t\u0011\u001d\u0011i\u000b\u0001C\u0005\u0005o\n\u0001b\u00197pg\u0016\fE\u000e\u001c\u0005\t\u0005c\u0003A\u0011\u0001\u0002\u00034\u000691\r[1o]\u0016dG\u0003\u0002B[\u0005{\u0003RAFA\u0010\u0005o\u0003BAa\u001a\u0003:&!!1\u0018B5\u00051Y\u0015MZ6b\u0007\"\fgN\\3m\u0011\u001d\u0011yLa,A\u0002=\u000bAbY8o]\u0016\u001cG/[8o\u0013\u0012DqAa1\u0001\t\u0003\u00119(\u0001\u0004xC.,W\u000f\u001d\u0015\u0005\u0005\u0003\u00149\r\u0005\u0003\u0002$\n%\u0017\u0002\u0002Bf\u0003K\u0013\u0001b\u0014<feJLG-\u001a")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final SecurityProtocol protocol;
    public final Metrics kafka$network$Processor$$metrics;
    private final ConcurrentLinkedQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final java.util.Map<String, String> kafka$network$Processor$$metricTags;
    private final Selector selector;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ConcurrentLinkedQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    public java.util.Map<String, String> kafka$network$Processor$$metricTags() {
        return this.kafka$network$Processor$$metricTags;
    }

    private Selector selector() {
        return this.selector;
    }

    @Override
    public void run() {
        this.startupComplete();
        while (this.isRunning()) {
            try {
                this.configureNewConnections();
                this.processNewResponses();
                this.poll();
                this.processCompletedReceives();
                this.processCompletedSends();
                this.processDisconnected();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                    throw (Throwable)controlThrowable;
                }
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Processor got uncaught exception.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing selector - processor " + this.id());
        this.swallowError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll());
        this.shutdownComplete();
    }

    private void processNewResponses() {
        ObjectRef curr = ObjectRef.create((Object)this.requestChannel.receiveResponse(this.id()));
        while ((RequestChannel.Response)curr.elem != null) {
            try {
                BoxedUnit boxedUnit;
                RequestChannel.ResponseAction responseAction = ((RequestChannel.Response)curr.elem).responseAction();
                if (RequestChannel$NoOpAction$.MODULE$.equals(responseAction)) {
                    ((RequestChannel.Response)curr.elem).request().updateRequestMetrics();
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Socket server received empty response to send, registering for read: " + (RequestChannel.Response)curr$1.elem);
                    this.selector().unmute(((RequestChannel.Response)curr.elem).request().connectionId());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (RequestChannel$SendAction$.MODULE$.equals(responseAction)) {
                    this.sendResponse((RequestChannel.Response)curr.elem);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (RequestChannel$CloseConnectionAction$.MODULE$.equals(responseAction)) {
                    ((RequestChannel.Response)curr.elem).request().updateRequestMetrics();
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(this.selector(), ((RequestChannel.Response)curr.elem).request().connectionId());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)responseAction);
            }
            finally {
                curr.elem = this.requestChannel.receiveResponse(this.id());
            }
        }
    }

    public void sendResponse(RequestChannel.Response response) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Socket server received response to send, registering for write and sending data: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response})));
        KafkaChannel channel = this.selector().channel(response.responseSend().destination());
        if (channel == null) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to send response via channel for which there is no open connection, connection id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())})));
            response.request().updateRequestMetrics();
        } else {
            this.selector().send(response.responseSend());
            this.inflightResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.request().connectionId()), (Object)response));
        }
    }

    private void poll() {
        try {
            this.selector().poll(300L);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalStateException ? true : throwable2 instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing processor ", " due to illegal state or IO exception"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())})));
                this.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll());
                this.shutdownComplete();
                throw throwable2;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedReceives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)receive -> {
            Processor.$anonfun$processCompletedReceives$1(this, receive);
            return BoxedUnit.UNIT;
        });
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedSends()).asScala()).foreach((Function1 & Serializable & scala.Serializable)send -> {
            Processor.$anonfun$processCompletedSends$1(this, send);
            return BoxedUnit.UNIT;
        });
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().disconnected()).asScala()).foreach((Function1 & Serializable & scala.Serializable)connectionId -> {
            Processor.$anonfun$processDisconnected$1(this, connectionId);
            return BoxedUnit.UNIT;
        });
    }

    public void accept(SocketChannel socketChannel) {
        this.newConnections().add(socketChannel);
        this.wakeup();
    }

    private void configureNewConnections() {
        while (!this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " listening to new connection from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id()), channel.socket().getRemoteSocketAddress()})));
                String localHost = channel.socket().getLocalAddress().getHostAddress();
                int localPort = channel.socket().getLocalPort();
                String remoteHost = channel.socket().getInetAddress().getHostAddress();
                int remotePort = channel.socket().getPort();
                String connectionId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort).toString();
                this.selector().register(connectionId, channel);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    SocketAddress remoteAddress = channel.getRemoteAddress();
                    this.close(channel);
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " closed connection from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id()), remoteAddress})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
    }

    private void closeAll() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().channels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            this.close(this.selector(), channel.id());
            return BoxedUnit.UNIT;
        });
        this.selector().close();
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    private final void ConnectionId$lzycompute$1() {
        Processor processor = this;
        synchronized (processor) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedReceives$1(Processor $this, NetworkReceive receive) {
        try {
            KafkaChannel channel = $this.selector().channel(receive.source());
            RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", channel.principal().getName()), channel.socketAddress());
            RequestChannel.Request req = new RequestChannel.Request($this.id(), receive.source(), session, receive.payload(), $this.time.milliseconds(), $this.protocol);
            $this.requestChannel.sendRequest(req);
            $this.selector().mute(receive.source());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof InvalidRequestException ? true : throwable2 instanceof SchemaException;
            if (bl) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing socket for ", " because of error"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{receive.source()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
                $this.close($this.selector(), receive.source());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$1(Processor $this, Send send) {
        RequestChannel.Response resp = (RequestChannel.Response)$this.inflightResponses().remove((Object)send.destination()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Send for ", " completed, but not in `inflightResponses`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{send.destination()})));
        });
        resp.request().updateRequestMetrics();
        $this.selector().unmute(send.destination());
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$3(RequestChannel.Response x$4) {
        x$4.request().updateRequestMetrics();
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$1(Processor $this, String connectionId) {
        String remoteHost = ((ConnectionId)$this.ConnectionId().fromString(connectionId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connectionId has unexpected format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionId})));
        })).remoteHost();
        $this.inflightResponses().remove((Object)connectionId).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Processor.$anonfun$processDisconnected$3(x$4);
            return BoxedUnit.UNIT;
        });
        $this.connectionQuotas.dec(InetAddress.getByName(remoteHost));
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, SecurityProtocol protocol, java.util.Map<String, ?> channelConfigs, Metrics metrics) {
        this.id = id;
        this.time = time;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.protocol = protocol;
        this.kafka$network$Processor$$metrics = metrics;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ConcurrentLinkedQueue();
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$network$Processor$$metricTags = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))).asJava();
        this.newGauge("IdlePercent", new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public double value() {
                return ((KafkaMetric)this.$outer.kafka$network$Processor$$metrics.metrics().get(this.$outer.kafka$network$Processor$$metrics.metricName("io-wait-ratio", "socket-server-metrics", this.$outer.kafka$network$Processor$$metricTags()))).value();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.kafka$network$Processor$$metricTags()).asScala()));
        this.selector = new Selector(maxRequestSize, connectionsMaxIdleMs, metrics, time, "socket-server", this.kafka$network$Processor$$metricTags(), false, ChannelBuilders.create((SecurityProtocol)protocol, (Mode)Mode.SERVER, (LoginType)LoginType.SERVER, channelConfigs, null, (boolean)true));
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public String toString() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "-", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.localHost(), BoxesRunTime.boxToInteger((int)this.localPort()), this.remoteHost(), BoxesRunTime.boxToInteger((int)this.remotePort())}));
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.localHost();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.localPort());
                    break;
                }
                case 2: {
                    object = this.remoteHost();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.remotePort());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.localHost()));
            n = Statics.mix((int)n, (int)this.localPort());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteHost()));
            n = Statics.mix((int)n, (int)this.remotePort());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConnectionId)) return false;
            if (((ConnectionId)object).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

