/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.common.KafkaException;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.server.KafkaConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u0001\u0003\u0001\u001d\u0011AbU8dW\u0016$8+\u001a:wKJT!a\u0001\u0003\u0002\u000f9,Go^8sW*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Aa\u0002\u0006\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001e\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0011D\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\r\r|gNZ5h+\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!e\b\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001b\u0006\u0001\u0003\u0006\u0004%\tAJ\u000b\u0002OA\u0011\u0001&M\u0007\u0002S)\u0011qC\u000b\u0006\u0003W1\naaY8n[>t'BA\u0003.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IJ#aB'fiJL7m\u001d\u0005\ti\u0001\u0011\t\u0011)A\u0005O\u0005AQ.\u001a;sS\u000e\u001c\b\u0005\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u0003\u0011!\u0018.\\3\u0016\u0003a\u0002\"!O\u001e\u000e\u0003iR!!\u0005\u0016\n\u0005qR$\u0001\u0002+j[\u0016D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u0006i&lW\r\t\u0005\u0006\u0001\u0002!\t!Q\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\t#UI\u0012\t\u0003\u0007\u0002i\u0011A\u0001\u0005\u00067}\u0002\r!\b\u0005\u0006/}\u0002\ra\n\u0005\u0006m}\u0002\r\u0001\u000f\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0003%)g\u000e\u001a9pS:$8/F\u0001K!\u0011Y\u0005K\u0015-\u000e\u00031S!!\u0014(\u0002\u0013%lW.\u001e;bE2,'BA(\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003#2\u00131!T1q!\t\u0019f+D\u0001U\u0015\t)&&\u0001\u0005qe>$xnY8m\u0013\t9FK\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pYB\u0011\u0011\fX\u0007\u00025*\u00111\fB\u0001\bG2,8\u000f^3s\u0013\ti&L\u0001\u0005F]\u0012\u0004v.\u001b8u\u0011\u0019y\u0006\u0001)A\u0005\u0015\u0006QQM\u001c3q_&tGo\u001d\u0011\t\u000f\u0005\u0004!\u0019!C\u0005E\u0006\u0019b.^7Qe>\u001cWm]:peRC'/Z1egV\t1\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006!A.\u00198h\u0015\u0005A\u0017\u0001\u00026bm\u0006L!A[3\u0003\u000f%sG/Z4fe\"1A\u000e\u0001Q\u0001\n\r\fAC\\;n!J|7-Z:t_J$\u0006N]3bIN\u0004\u0003b\u00028\u0001\u0005\u0004%IAY\u0001\u0012[\u0006D\u0018+^3vK\u0012\u0014V-];fgR\u001c\bB\u00029\u0001A\u0003%1-\u0001\nnCb\fV/Z;fIJ+\u0017/^3tiN\u0004\u0003b\u0002:\u0001\u0005\u0004%Ia]\u0001\u0016i>$\u0018\r\u001c)s_\u000e,7o]8s)\"\u0014X-\u00193t+\u0005!\bCA\u0005v\u0013\t1(BA\u0002J]RDa\u0001\u001f\u0001!\u0002\u0013!\u0018A\u0006;pi\u0006d\u0007K]8dKN\u001cxN\u001d+ie\u0016\fGm\u001d\u0011\t\u000fi\u0004!\u0019!C\u0005E\u0006\u0019R.\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja\"1A\u0010\u0001Q\u0001\n\r\fA#\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0013B\u0004\u0003b\u0002@\u0001\u0005\u0004%Ia`\u0001\u001d[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014\u0018\n](wKJ\u0014\u0018\u000eZ3t+\t\t\t\u0001E\u0004\u0002\u0004\u0005\u0015\u0011q\u0001;\u000e\u00039K!!\u0015(\u0011\t\u0005%\u0011q\u0003\b\u0005\u0003\u0017\t\u0019\u0002E\u0002\u0002\u000e)i!!a\u0004\u000b\u0007\u0005Ea!\u0001\u0004=e>|GOP\u0005\u0004\u0003+Q\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\u0005m!AB*ue&twMC\u0002\u0002\u0016)A\u0001\"a\b\u0001A\u0003%\u0011\u0011A\u0001\u001e[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014\u0018\n](wKJ\u0014\u0018\u000eZ3tA!I\u00111\u0005\u0001C\u0002\u0013\u0005\u0011QE\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m+\t\t9\u0003E\u0002D\u0003SI1!a\u000b\u0003\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2D\u0001\"a\f\u0001A\u0003%\u0011qE\u0001\u0010e\u0016\fX/Z:u\u0007\"\fgN\\3mA!I\u00111\u0007\u0001C\u0002\u0013%\u0011QG\u0001\u000baJ|7-Z:t_J\u001cXCAA\u001c!\u0015I\u0011\u0011HA\u001f\u0013\r\tYD\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0007\u0006}\u0012bAA!\u0005\tI\u0001K]8dKN\u001cxN\u001d\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u00028\u0005Y\u0001O]8dKN\u001cxN]:!\u0011)\tI\u0005\u0001b\u0001\n\u0003\u0011\u00111J\u0001\nC\u000e\u001cW\r\u001d;peN,\"!!\u0014\u0011\u000f\u0005=\u0013Q\u000b-\u0002X5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'r\u0015aB7vi\u0006\u0014G.Z\u0005\u0004#\u0006E\u0003cA\"\u0002Z%\u0019\u00111\f\u0002\u0003\u0011\u0005\u001b7-\u001a9u_JD\u0001\"a\u0018\u0001A\u0003%\u0011QJ\u0001\u000bC\u000e\u001cW\r\u001d;peN\u0004\u0003bCA2\u0001\u0001\u0007\t\u0019!C\u0005\u0003K\n\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0016\u0005\u0005\u001d\u0004cA\"\u0002j%\u0019\u00111\u000e\u0002\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\bbCA8\u0001\u0001\u0007\t\u0019!C\u0005\u0003c\nAcY8o]\u0016\u001cG/[8o#V|G/Y:`I\u0015\fH\u0003BA:\u0003s\u00022!CA;\u0013\r\t9H\u0003\u0002\u0005+:LG\u000f\u0003\u0006\u0002|\u00055\u0014\u0011!a\u0001\u0003O\n1\u0001\u001f\u00132\u0011!\ty\b\u0001Q!\n\u0005\u001d\u0014!E2p]:,7\r^5p]F+x\u000e^1tA!I\u00111\u0011\u0001C\u0002\u0013%\u0011QQ\u0001\u000fC2dW*\u001a;sS\u000et\u0015-\\3t+\t\t9\tE\u0003L\u0003\u0013\u000bi)C\u0002\u0002\f2\u0013!\"\u00138eKb,GmU3r!\u0011\ty)!%\u000e\u0003)J1!a%+\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\t\u0003/\u0003\u0001\u0015!\u0003\u0002\b\u0006y\u0011\r\u001c7NKR\u0014\u0018n\u0019(b[\u0016\u001c\b\u0005C\u0004\u0002\u001c\u0002!\t!!(\u0002\u000fM$\u0018M\u001d;vaR\u0011\u00111\u000f\u0005\b\u0003C\u0003A\u0011AAO\u0003!\u0019\b.\u001e;e_^t\u0007bBAS\u0001\u0011\u0005\u0011qU\u0001\nE>,h\u000e\u001a)peR$2\u0001^AU\u0011!)\u00161\u0015I\u0001\u0002\u0004\u0011\u0006\u0002CAW\u0001\u0011E!!a,\u0002\u00199,w\u000f\u0015:pG\u0016\u001c8o\u001c:\u0015\u0011\u0005u\u0012\u0011WA[\u0003oCq!a-\u0002,\u0002\u0007A/\u0001\u0002jI\"A\u00111MAV\u0001\u0004\t9\u0007\u0003\u0004V\u0003W\u0003\rA\u0015\u0005\t\u0003w\u0003A\u0011\u0001\u0002\u0002>\u0006y1m\u001c8oK\u000e$\u0018n\u001c8D_VtG\u000fF\u0002u\u0003\u007fC\u0001\"!1\u0002:\u0002\u0007\u00111Y\u0001\bC\u0012$'/Z:t!\u0011\t)-a3\u000e\u0005\u0005\u001d'bAAeO\u0006\u0019a.\u001a;\n\t\u00055\u0017q\u0019\u0002\f\u0013:,G/\u00113ee\u0016\u001c8\u000f\u0003\u0005\u0002R\u0002!\tAAAj\u0003%\u0001(o\\2fgN|'\u000f\u0006\u0003\u0002>\u0005U\u0007bBAl\u0003\u001f\u0004\r\u0001^\u0001\u0006S:$W\r\u001f\u0005\n\u00037\u0004\u0011\u0013!C\u0001\u0003;\f1CY8v]\u0012\u0004vN\u001d;%I\u00164\u0017-\u001e7uIE*\"!a8+\u0007I\u000b\to\u000b\u0002\u0002dB!\u0011Q]Ax\u001b\t\t9O\u0003\u0003\u0002j\u0006-\u0018!C;oG\",7m[3e\u0015\r\tiOC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAy\u0003O\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class SocketServer
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final scala.collection.immutable.Map<SecurityProtocol, EndPoint> endpoints;
    private final Integer numProcessorThreads;
    private final Integer maxQueuedRequests;
    private final int kafka$network$SocketServer$$totalProcessorThreads;
    private final Integer maxConnectionsPerIp;
    private final Map<String, Object> maxConnectionsPerIpOverrides;
    private final RequestChannel requestChannel;
    private final Processor[] processors;
    private final scala.collection.mutable.Map<EndPoint, Acceptor> acceptors;
    private ConnectionQuotas connectionQuotas;
    private final IndexedSeq<MetricName> kafka$network$SocketServer$$allMetricNames;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Time time() {
        return this.time;
    }

    private scala.collection.immutable.Map<SecurityProtocol, EndPoint> endpoints() {
        return this.endpoints;
    }

    private Integer numProcessorThreads() {
        return this.numProcessorThreads;
    }

    private Integer maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public int kafka$network$SocketServer$$totalProcessorThreads() {
        return this.kafka$network$SocketServer$$totalProcessorThreads;
    }

    private Integer maxConnectionsPerIp() {
        return this.maxConnectionsPerIp;
    }

    private Map<String, Object> maxConnectionsPerIpOverrides() {
        return this.maxConnectionsPerIpOverrides;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private Processor[] processors() {
        return this.processors;
    }

    public scala.collection.mutable.Map<EndPoint, Acceptor> acceptors() {
        return this.acceptors;
    }

    private ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private void connectionQuotas_$eq(ConnectionQuotas x$1) {
        this.connectionQuotas = x$1;
    }

    public IndexedSeq<MetricName> kafka$network$SocketServer$$allMetricNames() {
        return this.kafka$network$SocketServer$$allMetricNames;
    }

    public void startup() {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            this.connectionQuotas_$eq(new ConnectionQuotas(Predef$.MODULE$.Integer2int(this.maxConnectionsPerIp()), this.maxConnectionsPerIpOverrides()));
            Integer sendBufferSize = this.config().socketSendBufferBytes();
            Integer recvBufferSize = this.config().socketReceiveBufferBytes();
            int brokerId = this.config().brokerId();
            IntRef processorBeginIndex = IntRef.create((int)0);
            this.endpoints().values().foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
                SocketServer.$anonfun$startup$1(this, sendBufferSize, recvBufferSize, brokerId, processorBeginIndex, endpoint);
                return BoxedUnit.UNIT;
            });
        }
        this.newGauge("NetworkProcessorAvgIdlePercent", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public double value() {
                return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)this.$outer.kafka$network$SocketServer$$allMetricNames().map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$1(this, metricName)), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.$outer.kafka$network$SocketServer$$totalProcessorThreads();
            }

            public static final /* synthetic */ double $anonfun$value$1($anon$1 $this, MetricName metricName) {
                return ((KafkaMetric)$this.$outer.metrics().metrics().get(metricName)).value();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.network.SocketServer$$anon$1 org.apache.kafka.common.MetricName )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started " + this.acceptors().size() + " acceptor threads");
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down");
        SocketServer socketServer = this;
        synchronized (socketServer) {
            this.acceptors().values().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.shutdown();
                return BoxedUnit.UNIT;
            });
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.processors())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown completed");
    }

    public int boundPort(SecurityProtocol protocol) {
        int n;
        try {
            n = ((Acceptor)this.acceptors().apply(this.endpoints().apply((Object)protocol))).serverChannel().socket().getLocalPort();
        }
        catch (Exception e) {
            throw new KafkaException("Tried to check server's port before server was started or checked for port of non-existing protocol", e);
        }
        return n;
    }

    public SecurityProtocol boundPort$default$1() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Processor newProcessor(int id, ConnectionQuotas connectionQuotas, SecurityProtocol protocol) {
        return new Processor(id, this.time(), Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel(), connectionQuotas, Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), protocol, this.config().values(), this.metrics());
    }

    public int connectionCount(InetAddress address) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.connectionQuotas()).fold((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.get(address))));
    }

    public Processor processor(int index) {
        return this.processors()[index];
    }

    public static final /* synthetic */ MetricName $anonfun$allMetricNames$1(SocketServer $this, int i) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("networkProcessor", ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
        return $this.metrics().metricName("io-wait-ratio", "socket-server-metrics", tags);
    }

    public static final /* synthetic */ void $anonfun$startup$1(SocketServer $this, Integer sendBufferSize$1, Integer recvBufferSize$1, int brokerId$1, IntRef processorBeginIndex$1, EndPoint endpoint) {
        SecurityProtocol protocol = endpoint.protocolType();
        int processorEndIndex = processorBeginIndex$1.elem + Predef$.MODULE$.Integer2int($this.numProcessorThreads());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(processorBeginIndex$1.elem), processorEndIndex).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            $this.processors()[i] = $this.newProcessor(i, $this.connectionQuotas(), protocol);
        });
        Acceptor acceptor = new Acceptor(endpoint, Predef$.MODULE$.Integer2int(sendBufferSize$1), Predef$.MODULE$.Integer2int(recvBufferSize$1), brokerId$1, (Processor[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.processors())).slice(processorBeginIndex$1.elem, processorEndIndex), $this.connectionQuotas());
        $this.acceptors().put((Object)endpoint, (Object)acceptor);
        Utils.newThread((String)new StringOps(Predef$.MODULE$.augmentString("kafka-socket-acceptor-%s-%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{protocol.toString(), BoxesRunTime.boxToInteger((int)endpoint.port())})), (Runnable)acceptor, (boolean)false).start();
        acceptor.awaitStartup();
        processorBeginIndex$1.elem = processorEndIndex;
    }

    public SocketServer(KafkaConfig config, Metrics metrics, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.endpoints = config.listeners();
        this.numProcessorThreads = config.numNetworkThreads();
        this.maxQueuedRequests = config.queuedMaxRequests();
        this.kafka$network$SocketServer$$totalProcessorThreads = Predef$.MODULE$.Integer2int(this.numProcessorThreads()) * this.endpoints().size();
        this.maxConnectionsPerIp = config.maxConnectionsPerIp();
        this.maxConnectionsPerIpOverrides = config.maxConnectionsPerIpOverrides();
        this.logIdent_$eq("[Socket Server on Broker " + config.brokerId() + "], ");
        this.requestChannel = new RequestChannel(this.kafka$network$SocketServer$$totalProcessorThreads(), Predef$.MODULE$.Integer2int(this.maxQueuedRequests()));
        this.processors = new Processor[this.kafka$network$SocketServer$$totalProcessorThreads()];
        this.acceptors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$network$SocketServer$$allMetricNames = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$network$SocketServer$$totalProcessorThreads()).map((Function1 & Serializable & scala.Serializable)i -> SocketServer.$anonfun$allMetricNames$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.requestChannel().addResponseListener((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.processors()[id].wakeup());
    }
}

