/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer.async;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.ProducerRequest;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponseStatus;
import kafka.api.TopicMetadata;
import kafka.common.FailedToSendMessageException;
import kafka.common.KafkaException;
import kafka.common.NoBrokersForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.NoCompressionCodec$;
import kafka.producer.BrokerPartitionInfo;
import kafka.producer.KeyedMessage;
import kafka.producer.PartitionAndLeader;
import kafka.producer.Partitioner;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.ProducerStats;
import kafka.producer.ProducerStatsRegistry$;
import kafka.producer.ProducerTopicStats;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.producer.SyncProducer;
import kafka.producer.async.DefaultEventHandler$;
import kafka.producer.async.EventHandler;
import kafka.serializer.Encoder;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.SystemTime$;
import kafka.utils.Time;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t-f\u0001B\u0001\u0003\u0001%\u00111\u0003R3gCVdG/\u0012<f]RD\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u000b\u0005\u001c\u0018P\\2\u000b\u0005\u00151\u0011\u0001\u00039s_\u0012,8-\u001a:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001!F\u0002\u000b/\u0005\u001aB\u0001A\u0006\u0012GA\u0011AbD\u0007\u0002\u001b)\ta\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0011\u001b\t1\u0011I\\=SK\u001a\u0004BAE\n\u0016A5\t!!\u0003\u0002\u0015\u0005\taQI^3oi\"\u000bg\u000e\u001a7feB\u0011ac\u0006\u0007\u0001\t\u0015A\u0002A1\u0001\u001a\u0005\u0005Y\u0015C\u0001\u000e\u001e!\ta1$\u0003\u0002\u001d\u001b\t9aj\u001c;iS:<\u0007C\u0001\u0007\u001f\u0013\tyRBA\u0002B]f\u0004\"AF\u0011\u0005\u000b\t\u0002!\u0019A\r\u0003\u0003Y\u0003\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005!*#a\u0002'pO\u001eLgn\u001a\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u000511m\u001c8gS\u001e\u0004\"\u0001L\u0017\u000e\u0003\u0011I!A\f\u0003\u0003\u001dA\u0013x\u000eZ;dKJ\u001cuN\u001c4jO\"A\u0001\u0007\u0001BC\u0002\u0013%\u0011'A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014X#\u0001\u001a\u0011\u00051\u001a\u0014B\u0001\u001b\u0005\u0005-\u0001\u0016M\u001d;ji&|g.\u001a:\t\u0011Y\u0002!\u0011!Q\u0001\nI\nA\u0002]1si&$\u0018n\u001c8fe\u0002B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%I!O\u0001\bK:\u001cw\u000eZ3s+\u0005Q\u0004cA\u001e?A5\tAH\u0003\u0002>\r\u0005Q1/\u001a:jC2L'0\u001a:\n\u0005}b$aB#oG>$WM\u001d\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005u\u0005AQM\\2pI\u0016\u0014\b\u0005\u0003\u0005D\u0001\t\u0015\r\u0011\"\u0003E\u0003)YW-_#oG>$WM]\u000b\u0002\u000bB\u00191HP\u000b\t\u0011\u001d\u0003!\u0011!Q\u0001\n\u0015\u000b1b[3z\u000b:\u001cw\u000eZ3sA!A\u0011\n\u0001BC\u0002\u0013%!*\u0001\u0007qe>$WoY3s!>|G.F\u0001L!\taC*\u0003\u0002N\t\ta\u0001K]8ek\u000e,'\u000fU8pY\"Aq\n\u0001B\u0001B\u0003%1*A\u0007qe>$WoY3s!>|G\u000e\t\u0005\t#\u0002\u0011)\u0019!C\u0005%\u0006\u0019Bo\u001c9jGB\u000b'\u000f^5uS>t\u0017J\u001c4pgV\t1\u000b\u0005\u0003U3n3W\"A+\u000b\u0005Y;\u0016aB7vi\u0006\u0014G.\u001a\u0006\u000316\t!bY8mY\u0016\u001cG/[8o\u0013\tQVKA\u0004ICNDW*\u00199\u0011\u0005q\u001bgBA/b!\tqV\"D\u0001`\u0015\t\u0001\u0007\"\u0001\u0004=e>|GOP\u0005\u0003E6\ta\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\u0019\u0019FO]5oO*\u0011!-\u0004\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u001a\t1!\u00199j\u0013\tY\u0007NA\u0007U_BL7-T3uC\u0012\fG/\u0019\u0005\t[\u0002\u0011\t\u0011)A\u0005'\u0006!Bo\u001c9jGB\u000b'\u000f^5uS>t\u0017J\u001c4pg\u0002B\u0001b\u001c\u0001\u0003\u0006\u0004%I\u0001]\u0001\u0005i&lW-F\u0001r!\t!#/\u0003\u0002tK\t!A+[7f\u0011!)\bA!A!\u0002\u0013\t\u0018!\u0002;j[\u0016\u0004\u0003\"B<\u0001\t\u0003A\u0018A\u0002\u001fj]&$h\bF\u0005zundXP`@\u0002\u0002A!!\u0003A\u000b!\u0011\u0015Qc\u000f1\u0001,\u0011\u0015\u0001d\u000f1\u00013\u0011\u0015Ad\u000f1\u0001;\u0011\u0015\u0019e\u000f1\u0001F\u0011\u0015Ie\u000f1\u0001L\u0011\u001d\tf\u000f%AA\u0002MCqa\u001c<\u0011\u0002\u0003\u0007\u0011\u000fC\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001\u0002\b\u00051\u0011n]*z]\u000e,\"!!\u0003\u0011\u00071\tY!C\u0002\u0002\u000e5\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0005\u0003\u001dI7oU=oG\u0002B\u0011\"!\u0006\u0001\u0005\u0004%\t!a\u0006\u0002\u001b\r|'O]3mCRLwN\\%e+\t\tI\u0002\u0005\u0003\u0002\u001c\u00055RBAA\u000f\u0015\u0011\ty\"!\t\u0002\r\u0005$x.\\5d\u0015\u0011\t\u0019#!\n\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002(\u0005%\u0012\u0001B;uS2T!!a\u000b\u0002\t)\fg/Y\u0005\u0005\u0003_\tiBA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002\u001a\u0005q1m\u001c:sK2\fG/[8o\u0013\u0012\u0004\u0003\"CA\u001c\u0001\t\u0007I\u0011AA\u001d\u0003M\u0011'o\\6feB\u000b'\u000f^5uS>t\u0017J\u001c4p+\t\tY\u0004E\u0002-\u0003{I1!a\u0010\u0005\u0005M\u0011%o\\6feB\u000b'\u000f^5uS>t\u0017J\u001c4p\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005m\u0012\u0001\u00062s_.,'\u000fU1si&$\u0018n\u001c8J]\u001a|\u0007\u0005C\u0005\u0002H\u0001\u0011\r\u0011\"\u0003\u0002J\u0005aBo\u001c9jG6+G/\u00193bi\u0006\u0014VM\u001a:fg\"Le\u000e^3sm\u0006dWCAA&!\ra\u0011QJ\u0005\u0004\u0003\u001fj!aA%oi\"A\u00111\u000b\u0001!\u0002\u0013\tY%A\u000fu_BL7-T3uC\u0012\fG/\u0019*fMJ,7\u000f[%oi\u0016\u0014h/\u00197!\u0011%\t9\u0006\u0001a\u0001\n\u0013\tI&\u0001\u000fmCN$Hk\u001c9jG6+G/\u00193bi\u0006\u0014VM\u001a:fg\"$\u0016.\\3\u0016\u0005\u0005m\u0003c\u0001\u0007\u0002^%\u0019\u0011qL\u0007\u0003\t1{gn\u001a\u0005\n\u0003G\u0002\u0001\u0019!C\u0005\u0003K\n\u0001\u0005\\1tiR{\u0007/[2NKR\fG-\u0019;b%\u00164'/Z:i)&lWm\u0018\u0013fcR!\u0011qMA7!\ra\u0011\u0011N\u0005\u0004\u0003Wj!\u0001B+oSRD!\"a\u001c\u0002b\u0005\u0005\t\u0019AA.\u0003\rAH%\r\u0005\t\u0003g\u0002\u0001\u0015)\u0003\u0002\\\u0005iB.Y:u)>\u0004\u0018nY'fi\u0006$\u0017\r^1SK\u001a\u0014Xm\u001d5US6,\u0007\u0005C\u0005\u0002x\u0001\u0011\r\u0011\"\u0003\u0002z\u00051Bo\u001c9jG6+G/\u00193bi\u0006$vNU3ge\u0016\u001c\b.\u0006\u0002\u0002|A!A+! \\\u0013\r\ty(\u0016\u0002\u0004'\u0016$\b\u0002CAB\u0001\u0001\u0006I!a\u001f\u0002/Q|\u0007/[2NKR\fG-\u0019;b)>\u0014VM\u001a:fg\"\u0004\u0003\"CAD\u0001\t\u0007I\u0011BAE\u0003i\u0019XM\u001c3QCJ$\u0018\u000e^5p]B+'\u000fV8qS\u000e\u001c\u0015m\u00195f+\t\tY\tE\u0003U3n\u000bY\u0005\u0003\u0005\u0002\u0010\u0002\u0001\u000b\u0011BAF\u0003m\u0019XM\u001c3QCJ$\u0018\u000e^5p]B+'\u000fV8qS\u000e\u001c\u0015m\u00195fA!I\u00111\u0013\u0001C\u0002\u0013%\u0011QS\u0001\u000eaJ|G-^2feN#\u0018\r^:\u0016\u0005\u0005]\u0005c\u0001\u0017\u0002\u001a&\u0019\u00111\u0014\u0003\u0003\u001bA\u0013x\u000eZ;dKJ\u001cF/\u0019;t\u0011!\ty\n\u0001Q\u0001\n\u0005]\u0015A\u00049s_\u0012,8-\u001a:Ti\u0006$8\u000f\t\u0005\n\u0003G\u0003!\u0019!C\u0005\u0003K\u000b!\u0003\u001d:pIV\u001cWM\u001d+pa&\u001c7\u000b^1ugV\u0011\u0011q\u0015\t\u0004Y\u0005%\u0016bAAV\t\t\u0011\u0002K]8ek\u000e,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011!\ty\u000b\u0001Q\u0001\n\u0005\u001d\u0016a\u00059s_\u0012,8-\u001a:U_BL7m\u0015;biN\u0004\u0003bBAZ\u0001\u0011\u0005\u0011QW\u0001\u0007Q\u0006tG\r\\3\u0015\t\u0005\u001d\u0014q\u0017\u0005\t\u0003s\u000b\t\f1\u0001\u0002<\u00061QM^3oiN\u0004b!!0\u0002@\u0006\rW\"A,\n\u0007\u0005\u0005wKA\u0002TKF\u0004R\u0001LAc+\u0001J1!a2\u0005\u00051YU-_3e\u001b\u0016\u001c8/Y4f\u0011\u001d\tY\r\u0001C\u0005\u0003\u001b\fa\u0003Z5ta\u0006$8\r[*fe&\fG.\u001b>fI\u0012\u000bG/\u0019\u000b\u0005\u0003\u001f\fy\u000e\u0005\u0004\u0002>\u0006}\u0016\u0011\u001b\t\u0007Y\u0005\u0015W#a5\u0011\t\u0005U\u00171\\\u0007\u0003\u0003/T1!!7\u0007\u0003\u001diWm]:bO\u0016LA!!8\u0002X\n9Q*Z:tC\u001e,\u0007\u0002CAq\u0003\u0013\u0004\r!a4\u0002\u00115,7o]1hKNDq!!:\u0001\t\u0003\t9/A\u0005tKJL\u0017\r\\5{KR!\u0011qZAu\u0011!\tI,a9A\u0002\u0005m\u0006bBAw\u0001\u0011\u0005\u0011q^\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000eZ\"pY2\fG/\u001a\u000b\u0005\u0003c\u0014i\u0001E\u0003\r\u0003g\f90C\u0002\u0002v6\u0011aa\u00149uS>t\u0007\u0003CA_\u0003s\fY%!@\n\u0007\u0005mxKA\u0002NCB\u0004r\u0001VA\u0000\u0005\u0003\ty-C\u0002\u0002|V\u0003BAa\u0001\u0003\n5\u0011!Q\u0001\u0006\u0004\u0005\u000f1\u0011AB2p[6|g.\u0003\u0003\u0003\f\t\u0015!!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"A\u0011\u0011]Av\u0001\u0004\ty\rC\u0004\u0003\u0012\u0001!IAa\u0005\u00021\u001d,G\u000fU1si&$\u0018n\u001c8MSN$hi\u001c:U_BL7\r\u0006\u0003\u0003\u0016\tu\u0001CBA_\u0003\u007f\u00139\u0002E\u0002-\u00053I1Aa\u0007\u0005\u0005I\u0001\u0016M\u001d;ji&|g.\u00118e\u0019\u0016\fG-\u001a:\t\u0011\t}!q\u0002a\u0001\u0003#\f\u0011!\u001c\u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u000319W\r\u001e)beRLG/[8o)!\tYEa\n\u0003,\t=\u0002b\u0002B\u0015\u0005C\u0001\raW\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0005[\u0011\t\u00031\u0001\u001e\u0003\rYW-\u001f\u0005\t\u0005c\u0011\t\u00031\u0001\u0003\u0016\u0005\u0011Bo\u001c9jGB\u000b'\u000f^5uS>tG*[:u\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005o\tAa]3oIR1!\u0011\bB\u001e\u0005\u007f\u0001b!!0\u0002@\n\u0005\u0001\u0002\u0003B\u001f\u0005g\u0001\r!a\u0013\u0002\u0011\t\u0014xn[3s\u0013\u0012D\u0001B!\u0011\u00034\u0001\u0007!1I\u0001\u0011[\u0016\u001c8/Y4fgB+'\u000fV8qS\u000e\u0004r\u0001VA\u0000\u0005\u0003\u0011)\u0005\u0005\u0003\u0002V\n\u001d\u0013\u0002\u0002B%\u0003/\u0014ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\bb\u0002B'\u0001\u0011%!qJ\u0001\u0013OJ|W\u000f]'fgN\fw-Z:U_N+G\u000f\u0006\u0003\u0003R\tM\u0003#\u0002\u0007\u0002t\n\r\u0003\u0002\u0003B+\u0005\u0017\u0002\r!!@\u000295,7o]1hKN\u0004VM\u001d+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"9!\u0011\f\u0001\u0005\u0002\tm\u0013!B2m_N,GCAA4Q\u001d\u0001!q\fB3\u0005S\u00022\u0001\u0004B1\u0013\r\u0011\u0019'\u0004\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017E\u0001B4\u0003\u001d#\u0006.[:!G2\f7o\u001d\u0011iCN\u0004#-Z3oA\u0011,\u0007O]3dCR,G\rI1oI\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/Z7pm\u0016$\u0007%\u001b8!C\u00022W\u000f^;sK\u0002\u0012X\r\\3bg\u0016t\u0013E\u0001B6\u0003!\u0001d&\r\u0019/a9\u0002t!\u0003B8\u0005\u0005\u0005\t\u0012\u0001B9\u0003M!UMZ1vYR,e/\u001a8u\u0011\u0006tG\r\\3s!\r\u0011\"1\u000f\u0004\t\u0003\t\t\t\u0011#\u0001\u0003vM\u0019!1O\u0006\t\u000f]\u0014\u0019\b\"\u0001\u0003zQ\u0011!\u0011\u000f\u0005\u000b\u0005{\u0012\u0019(%A\u0005\u0002\t}\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0004\u0003\u0002\n]%\u0011T\u000b\u0003\u0005\u0007S3a\u0015BCW\t\u00119\t\u0005\u0003\u0003\n\nMUB\u0001BF\u0015\u0011\u0011iIa$\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BI\u001b\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU%1\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u0002\r\u0003|\t\u0007\u0011\u0004\u0002\u0004#\u0005w\u0012\r!\u0007\u0005\u000b\u0005;\u0013\u0019(%A\u0005\u0002\t}\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0004\u0003\"\n\u0015&qU\u000b\u0003\u0005GS3!\u001dBC\t\u0019A\"1\u0014b\u00013\u00111!Ea'C\u0002eA\u0003Ba\u001d\u0003`\t\u0015$\u0011\u000e")
public class DefaultEventHandler<K, V>
implements EventHandler<K, V>,
Logging {
    private final ProducerConfig config;
    private final Partitioner partitioner;
    private final Encoder<V> encoder;
    private final Encoder<K> keyEncoder;
    private final ProducerPool producerPool;
    private final HashMap<String, TopicMetadata> topicPartitionInfos;
    private final Time time;
    private final boolean isSync;
    private final AtomicInteger correlationId;
    private final BrokerPartitionInfo brokerPartitionInfo;
    private final int topicMetadataRefreshInterval;
    private long lastTopicMetadataRefreshTime;
    private final Set<String> topicMetadataToRefresh;
    private final HashMap<String, Object> sendPartitionPerTopicCache;
    private final ProducerStats producerStats;
    private final ProducerTopicStats producerTopicStats;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static <K, V> Time $lessinit$greater$default$7() {
        return DefaultEventHandler$.MODULE$.$lessinit$greater$default$7();
    }

    public static <K, V> HashMap<String, TopicMetadata> $lessinit$greater$default$6() {
        return DefaultEventHandler$.MODULE$.$lessinit$greater$default$6();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        DefaultEventHandler defaultEventHandler = this;
        synchronized (defaultEventHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private Partitioner partitioner() {
        return this.partitioner;
    }

    private Encoder<V> encoder() {
        return this.encoder;
    }

    private Encoder<K> keyEncoder() {
        return this.keyEncoder;
    }

    private ProducerPool producerPool() {
        return this.producerPool;
    }

    private HashMap<String, TopicMetadata> topicPartitionInfos() {
        return this.topicPartitionInfos;
    }

    private Time time() {
        return this.time;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public AtomicInteger correlationId() {
        return this.correlationId;
    }

    public BrokerPartitionInfo brokerPartitionInfo() {
        return this.brokerPartitionInfo;
    }

    private int topicMetadataRefreshInterval() {
        return this.topicMetadataRefreshInterval;
    }

    private long lastTopicMetadataRefreshTime() {
        return this.lastTopicMetadataRefreshTime;
    }

    private void lastTopicMetadataRefreshTime_$eq(long x$1) {
        this.lastTopicMetadataRefreshTime = x$1;
    }

    private Set<String> topicMetadataToRefresh() {
        return this.topicMetadataToRefresh;
    }

    private HashMap<String, Object> sendPartitionPerTopicCache() {
        return this.sendPartitionPerTopicCache;
    }

    private ProducerStats producerStats() {
        return this.producerStats;
    }

    private ProducerTopicStats producerTopicStats() {
        return this.producerTopicStats;
    }

    @Override
    public void handle(Seq<KeyedMessage<K, V>> events) {
        Seq<KeyedMessage<K, Message>> serializedData = this.serialize(events);
        serializedData.foreach((Function1 & Serializable & scala.Serializable)keyed -> {
            DefaultEventHandler.$anonfun$handle$1(this, keyed);
            return BoxedUnit.UNIT;
        });
        ObjectRef outstandingProduceRequests = ObjectRef.create(serializedData);
        IntRef remainingRetries = IntRef.create((int)(this.config.messageSendMaxRetries() + 1));
        int correlationIdStart = this.correlationId().get();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Handling %d events")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)events.size())})));
        while (remainingRetries.elem > 0 && ((Seq)outstandingProduceRequests.elem).nonEmpty()) {
            this.topicMetadataToRefresh().$plus$plus$eq((TraversableOnce)((Seq)outstandingProduceRequests.elem).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Seq$.MODULE$.canBuildFrom()));
            if (this.topicMetadataRefreshInterval() >= 0 && SystemTime$.MODULE$.milliseconds() - this.lastTopicMetadataRefreshTime() > (long)this.topicMetadataRefreshInterval()) {
                CoreUtils$.MODULE$.swallowError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.brokerPartitionInfo().updateInfo((scala.collection.immutable.Set<String>)this.topicMetadataToRefresh().toSet(), this.correlationId().getAndIncrement()));
                this.sendPartitionPerTopicCache().clear();
                this.topicMetadataToRefresh().clear();
                this.lastTopicMetadataRefreshTime_$eq(SystemTime$.MODULE$.milliseconds());
            }
            outstandingProduceRequests.elem = this.dispatchSerializedData((Seq)outstandingProduceRequests.elem);
            if (!((Seq)outstandingProduceRequests.elem).nonEmpty()) continue;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Back off for %d ms before retrying send. Remaining retries = %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.config.retryBackoffMs()), BoxesRunTime.boxToInteger((int)(remainingRetries$1.elem - 1))})));
            Thread.sleep(this.config.retryBackoffMs());
            CoreUtils$.MODULE$.swallowError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.brokerPartitionInfo().updateInfo((scala.collection.immutable.Set<String>)((TraversableOnce)((Seq)outstandingProduceRequests$1.elem).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topic(), Seq$.MODULE$.canBuildFrom())).toSet(), this.correlationId().getAndIncrement()));
            this.sendPartitionPerTopicCache().clear();
            --remainingRetries.elem;
            this.producerStats().resendRate().mark();
        }
        if (((Seq)outstandingProduceRequests.elem).nonEmpty()) {
            this.producerStats().failedSendRate().mark();
            int correlationIdEnd = this.correlationId().get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to send requests for topics %s with correlation ids in [%d,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((Seq)outstandingProduceRequests$1.elem).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topic(), Seq$.MODULE$.canBuildFrom())).toSet().mkString(","), BoxesRunTime.boxToInteger((int)correlationIdStart), BoxesRunTime.boxToInteger((int)(correlationIdEnd - 1))})));
            throw new FailedToSendMessageException("Failed to send messages after " + this.config.messageSendMaxRetries() + " tries.", null);
        }
    }

    private Seq<KeyedMessage<K, Message>> dispatchSerializedData(Seq<KeyedMessage<K, Message>> messages) {
        ArrayBuffer arrayBuffer;
        Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> partitionedDataOpt = this.partitionAndCollate((Seq<KeyedMessage<K, Message>>)messages);
        Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> option = partitionedDataOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Map partitionedData = (Map)some.value();
            ArrayBuffer failedProduceRequests = new ArrayBuffer();
            partitionedData.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultEventHandler.$anonfun$dispatchSerializedData$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                DefaultEventHandler.$anonfun$dispatchSerializedData$2(this, failedProduceRequests, x$4);
                return BoxedUnit.UNIT;
            });
            arrayBuffer = failedProduceRequests;
        } else if (None$.MODULE$.equals(option)) {
            arrayBuffer = messages;
        } else {
            throw new MatchError(option);
        }
        return arrayBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<KeyedMessage<K, Message>> serialize(Seq<KeyedMessage<K, V>> events) {
        void var2_2;
        ArrayBuffer serializedMessages = new ArrayBuffer(events.size());
        events.foreach((Function1 & Serializable & scala.Serializable)e -> {
            BoxedUnit boxedUnit;
            block4: {
                try {
                    if (e.hasKey()) {
                        byte[] x$9 = this.keyEncoder().toBytes(e.key());
                        byte[] x$10 = this.encoder().toBytes(e.message());
                        long x$11 = this.time().milliseconds();
                        byte x$12 = Message$.MODULE$.MagicValue_V1();
                        boxedUnit = serializedMessages.$plus$eq(new KeyedMessage(e.topic(), e.key(), e.partKey(), new Message(x$10, x$9, x$11, x$12)));
                        break block4;
                    }
                    boxedUnit = serializedMessages.$plus$eq(new KeyedMessage(e.topic(), e.key(), e.partKey(), new Message(this.encoder().toBytes(e.message()), this.time().milliseconds(), Message$.MODULE$.MagicValue_V1())));
                }
                catch (Throwable t) {
                    this.producerStats().serializationErrorRate().mark();
                    if (this.isSync()) {
                        throw t;
                    }
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error serializing message for topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.topic()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        });
        return var2_2;
    }

    public Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> partitionAndCollate(Seq<KeyedMessage<K, Message>> messages) {
        Some some;
        HashMap ret = new HashMap();
        try {
            messages.foreach((Function1 & Serializable & scala.Serializable)message -> {
                DefaultEventHandler.$anonfun$partitionAndCollate$1(this, ret, message);
                return BoxedUnit.UNIT;
            });
            some = new Some((Object)ret);
        }
        catch (UnknownTopicOrPartitionException ute) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to collate messages by topic,partition due to: " + ute.getMessage());
            some = None$.MODULE$;
        }
        catch (LeaderNotAvailableException lnae) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to collate messages by topic,partition due to: " + lnae.getMessage());
            some = None$.MODULE$;
        }
        catch (Throwable oe) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to collate messages by topic, partition due to: " + oe.getMessage());
            some = None$.MODULE$;
        }
        return some;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<PartitionAndLeader> getPartitionListForTopic(KeyedMessage<K, Message> m) {
        void var2_2;
        Seq<PartitionAndLeader> topicPartitionsList = this.brokerPartitionInfo().getBrokerPartitionInfo(m.topic(), this.correlationId().getAndIncrement());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Broker partitions registered for topic: %s are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m.topic(), ((TraversableOnce)topicPartitionsList.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)p.partitionId()), Seq$.MODULE$.canBuildFrom())).mkString(",")})));
        int totalNumPartitions = topicPartitionsList.length();
        if (totalNumPartitions == 0) {
            throw new NoBrokersForPartitionException("Partition key = " + m.key());
        }
        return var2_2;
    }

    private int getPartition(String topic, Object key, Seq<PartitionAndLeader> topicPartitionList) {
        int partition;
        int n;
        int numPartitions = topicPartitionList.size();
        if (numPartitions <= 0) {
            throw new UnknownTopicOrPartitionException("Topic " + topic + " doesn't exist");
        }
        if (key == null) {
            int n2;
            Option id = this.sendPartitionPerTopicCache().get((Object)topic);
            Option option = id;
            if (option instanceof Some) {
                int partitionId;
                Some some = (Some)option;
                n2 = partitionId = BoxesRunTime.unboxToInt((Object)some.value());
            } else if (None$.MODULE$.equals(option)) {
                Seq availablePartitions = (Seq)topicPartitionList.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DefaultEventHandler.$anonfun$getPartition$1(x$5)));
                if (availablePartitions.isEmpty()) {
                    throw new LeaderNotAvailableException("No leader for any partition in topic " + topic);
                }
                int index = Utils.abs((int)Random$.MODULE$.nextInt()) % availablePartitions.size();
                int partitionId = ((PartitionAndLeader)availablePartitions.apply(index)).partitionId();
                this.sendPartitionPerTopicCache().put((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId));
                n2 = partitionId;
            } else {
                throw new MatchError((Object)option);
            }
            n = n2;
        } else {
            n = partition = this.partitioner().partition(key, numPartitions);
        }
        if (partition < 0 || partition >= numPartitions) {
            throw new UnknownTopicOrPartitionException("Invalid partition id: " + partition + " for topic " + topic + "; Valid values are in the inclusive range of [0, " + (numPartitions - 1) + "]");
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Assigning message of topic %s and key %s to a selected partition %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, key == null ? "[none]" : key.toString(), BoxesRunTime.boxToInteger((int)partition)})));
        return partition;
    }

    private Seq<TopicAndPartition> send(int brokerId, scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet> messagesPerTopic) {
        List list;
        block10: {
            if (brokerId < 0) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to send data since partitions %s don't have a leader")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{messagesPerTopic.keys().mkString(",")})));
                list = messagesPerTopic.keys().toSeq();
            } else if (messagesPerTopic.nonEmpty()) {
                int currentCorrelationId = this.correlationId().getAndIncrement();
                ProducerRequest producerRequest = new ProducerRequest(currentCorrelationId, this.config.clientId(), this.config.requestRequiredAcks(), this.config.requestTimeoutMs(), messagesPerTopic);
                Seq failedTopicPartitions = (Seq)Seq$.MODULE$.empty();
                try {
                    SyncProducer syncProducer = this.producerPool().getProducer(brokerId);
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Producer sending messages with correlation id %d for topics %s to broker %d on %s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentCorrelationId), messagesPerTopic.keySet().mkString(","), BoxesRunTime.boxToInteger((int)brokerId), syncProducer.config().host(), BoxesRunTime.boxToInteger((int)syncProducer.config().port())})));
                    ProducerResponse response = syncProducer.send(producerRequest);
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Producer sent messages with correlation id %d for topics %s to broker %d on %s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentCorrelationId), messagesPerTopic.keySet().mkString(","), BoxesRunTime.boxToInteger((int)brokerId), syncProducer.config().host(), BoxesRunTime.boxToInteger((int)syncProducer.config().port())})));
                    if (response != null) {
                        Seq failedPartitionsAndStatus;
                        if (response.status().size() != producerRequest.data().size()) {
                            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Incomplete response (%s) for producer request (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response, producerRequest})));
                        }
                        if (this.logger().isTraceEnabled()) {
                            Map successfullySentData = (Map)response.status().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DefaultEventHandler.$anonfun$send$4(x$6)));
                            successfullySentData.foreach((Function1 & Serializable & scala.Serializable)m -> {
                                DefaultEventHandler.$anonfun$send$5(this, messagesPerTopic, m);
                                return BoxedUnit.UNIT;
                            });
                        }
                        if ((failedTopicPartitions = (Seq)(failedPartitionsAndStatus = ((MapLike)response.status().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DefaultEventHandler.$anonfun$send$8(x$7)))).toSeq()).map((Function1 & Serializable & scala.Serializable)partitionStatus -> (TopicAndPartition)partitionStatus._1(), Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
                            String errorString = ((TraversableOnce)((TraversableLike)failedPartitionsAndStatus.sortWith((Function2 & Serializable & scala.Serializable)(p1, p2) -> BoxesRunTime.boxToBoolean((boolean)DefaultEventHandler.$anonfun$send$10(p1, p2)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                                ProducerResponseStatus status = (ProducerResponseStatus)tuple2._2();
                                String string = topicAndPartition.toString() + ": " + Errors.forCode((short)status.error()).exceptionName();
                                return string;
                            }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Produce request with correlation id %d failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentCorrelationId), errorString})));
                        }
                        list = failedTopicPartitions;
                        break block10;
                    }
                    list = (Seq)Seq$.MODULE$.empty();
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to send producer request with correlation id %d to broker %d with data for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentCorrelationId), BoxesRunTime.boxToInteger((int)brokerId), messagesPerTopic.keys().mkString(",")})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    list = messagesPerTopic.keys().toSeq();
                }
            } else {
                list = List$.MODULE$.empty();
            }
        }
        return list;
    }

    private Option<scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet>> groupMessagesToSet(scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>> messagesPerTopicAndPartition) {
        None$ none$;
        try {
            scala.collection.mutable.Map messagesPerTopicPartition = (scala.collection.mutable.Map)messagesPerTopicAndPartition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ByteBufferMessageSet byteBufferMessageSet;
                TopicAndPartition topicAndPartition;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    topicAndPartition = (TopicAndPartition)tuple2._1();
                    Seq messages = (Seq)tuple2._2();
                    Seq rawMessages = (Seq)messages.map((Function1 & Serializable & scala.Serializable)x$8 -> (Message)x$8.message(), Seq$.MODULE$.canBuildFrom());
                    CompressionCodec compressionCodec = $this.config.compressionCodec();
                    if (NoCompressionCodec$.MODULE$.equals(compressionCodec)) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending %d messages with no compression to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messages.size()), topicAndPartition})));
                        byteBufferMessageSet = new ByteBufferMessageSet(NoCompressionCodec$.MODULE$, (Seq<Message>)rawMessages);
                    } else {
                        ByteBufferMessageSet byteBufferMessageSet2;
                        int n = $this.config.compressedTopics().size();
                        switch (n) {
                            case 0: {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending %d messages with compression codec %d to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messages.size()), BoxesRunTime.boxToInteger((int)$this.config.compressionCodec().codec()), topicAndPartition})));
                                byteBufferMessageSet2 = new ByteBufferMessageSet($this.config.compressionCodec(), (Seq<Message>)rawMessages);
                                break;
                            }
                            default: {
                                if ($this.config.compressedTopics().contains((Object)topicAndPartition.topic())) {
                                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending %d messages with compression codec %d to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messages.size()), BoxesRunTime.boxToInteger((int)$this.config.compressionCodec().codec()), topicAndPartition})));
                                    byteBufferMessageSet2 = new ByteBufferMessageSet($this.config.compressionCodec(), (Seq<Message>)rawMessages);
                                    break;
                                }
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending %d messages to %s with no compression as it is not in compressed.topics - %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messages.size()), topicAndPartition, $this.config.compressedTopics().toString()})));
                                byteBufferMessageSet2 = new ByteBufferMessageSet(NoCompressionCodec$.MODULE$, (Seq<Message>)rawMessages);
                                break;
                            }
                        }
                        byteBufferMessageSet = byteBufferMessageSet2;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 tuple22 = new Tuple2((Object)topicAndPartition, (Object)byteBufferMessageSet);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            none$ = new Some((Object)messagesPerTopicPartition);
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to group messages", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public void close() {
        block0: {
            if (this.producerPool() == null) break block0;
            this.producerPool().close();
        }
    }

    public static final /* synthetic */ void $anonfun$handle$1(DefaultEventHandler $this, KeyedMessage keyed) {
        int dataSize = ((Message)keyed.message()).payloadSize();
        $this.producerTopicStats().getProducerTopicStats(keyed.topic()).byteRate().mark((long)dataSize);
        $this.producerTopicStats().getProducerAllTopicsStats().byteRate().mark((long)dataSize);
    }

    public static final /* synthetic */ boolean $anonfun$dispatchSerializedData$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$dispatchSerializedData$5(ArrayBuffer failedProduceRequests$1, scala.collection.mutable.Map messagesPerBrokerMap$1, TopicAndPartition topicPartition) {
        Option option = messagesPerBrokerMap$1.get((Object)topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq data = (Seq)some.value();
            failedProduceRequests$1.appendAll((TraversableOnce)data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$dispatchSerializedData$2(DefaultEventHandler $this, ArrayBuffer failedProduceRequests$1, Tuple2 x$4) {
        Option<scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet>> messageSetPerBrokerOpt;
        Option<scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet>> option;
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int brokerid = tuple2._1$mcI$sp();
        scala.collection.mutable.Map messagesPerBrokerMap = (scala.collection.mutable.Map)tuple2._2();
        if ($this.logger().isTraceEnabled()) {
            messagesPerBrokerMap.foreach((Function1 & Serializable & scala.Serializable)partitionAndEvent -> {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Handling event for Topic: %s, Broker: %d, Partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionAndEvent._1(), BoxesRunTime.boxToInteger((int)brokerid$1), partitionAndEvent._2()})));
                return BoxedUnit.UNIT;
            });
        }
        if ((option = (messageSetPerBrokerOpt = $this.groupMessagesToSet(messagesPerBrokerMap))) instanceof Some) {
            Some some = (Some)option;
            scala.collection.mutable.Map messageSetPerBroker = (scala.collection.mutable.Map)some.value();
            Seq<TopicAndPartition> failedTopicPartitions = $this.send(brokerid, (scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet>)messageSetPerBroker);
            failedTopicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                DefaultEventHandler.$anonfun$dispatchSerializedData$5(failedProduceRequests$1, messagesPerBrokerMap, topicPartition);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            messagesPerBrokerMap.values().foreach((Function1 & Serializable & scala.Serializable)m -> {
                failedProduceRequests$1.appendAll((TraversableOnce)m);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$partitionAndCollate$1(DefaultEventHandler $this, HashMap ret$1, KeyedMessage message) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Seq<PartitionAndLeader> topicPartitionsList = $this.getPartitionListForTopic(message);
        int partitionIndex = $this.getPartition(message.topic(), message.partitionKey(), topicPartitionsList);
        PartitionAndLeader brokerPartition = (PartitionAndLeader)topicPartitionsList.apply(partitionIndex);
        int leaderBrokerId = BoxesRunTime.unboxToInt((Object)brokerPartition.leaderBrokerIdOpt().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        HashMap dataPerBroker = null;
        Option option = ret$1.get((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId));
        if (option instanceof Some) {
            Some some = (Some)option;
            scala.collection.mutable.Map element = (scala.collection.mutable.Map)some.value();
            dataPerBroker = (HashMap)element;
            boxedUnit2 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            dataPerBroker = new HashMap();
            boxedUnit2 = ret$1.put((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId), (Object)dataPerBroker);
        } else {
            throw new MatchError((Object)option);
        }
        TopicAndPartition topicAndPartition = new TopicAndPartition(message.topic(), brokerPartition.partitionId());
        ArrayBuffer dataPerTopicPartition = null;
        Option option2 = dataPerBroker.get((Object)topicAndPartition);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Seq element = (Seq)some.value();
            dataPerTopicPartition = (ArrayBuffer)element;
            boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            dataPerTopicPartition = new ArrayBuffer();
            boxedUnit = dataPerBroker.put((Object)topicAndPartition, (Object)dataPerTopicPartition);
        } else {
            throw new MatchError((Object)option2);
        }
        dataPerTopicPartition.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{message}));
    }

    public static final /* synthetic */ boolean $anonfun$getPartition$1(PartitionAndLeader x$5) {
        return x$5.leaderBrokerIdOpt().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$send$4(Tuple2 x$6) {
        return ((ProducerResponseStatus)x$6._2()).error() == Errors.NONE.code();
    }

    public static final /* synthetic */ void $anonfun$send$5(DefaultEventHandler $this, scala.collection.mutable.Map messagesPerTopic$1, Tuple2 m) {
        ((IterableLike)messagesPerTopic$1.apply(m._1())).foreach((Function1 & Serializable & scala.Serializable)message -> {
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Successfully sent message: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.message().isNull() ? null : message.message().toString()})));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$send$8(Tuple2 x$7) {
        return ((ProducerResponseStatus)x$7._2()).error() != Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$send$10(Tuple2 p1, Tuple2 p2) {
        return ((TopicAndPartition)p1._1()).topic().compareTo(((TopicAndPartition)p2._1()).topic()) < 0 || ((TopicAndPartition)p1._1()).topic().compareTo(((TopicAndPartition)p2._1()).topic()) == 0 && ((TopicAndPartition)p1._1()).partition() < ((TopicAndPartition)p2._1()).partition();
    }

    public DefaultEventHandler(ProducerConfig config, Partitioner partitioner, Encoder<V> encoder, Encoder<K> keyEncoder, ProducerPool producerPool, HashMap<String, TopicMetadata> topicPartitionInfos, Time time) {
        this.config = config;
        this.partitioner = partitioner;
        this.encoder = encoder;
        this.keyEncoder = keyEncoder;
        this.producerPool = producerPool;
        this.topicPartitionInfos = topicPartitionInfos;
        this.time = time;
        Logging.$init$(this);
        this.isSync = "sync".equals(config.producerType());
        this.correlationId = new AtomicInteger(0);
        this.brokerPartitionInfo = new BrokerPartitionInfo(config, producerPool, topicPartitionInfos);
        this.topicMetadataRefreshInterval = config.topicMetadataRefreshIntervalMs();
        this.lastTopicMetadataRefreshTime = 0L;
        this.topicMetadataToRefresh = Set$.MODULE$.empty();
        this.sendPartitionPerTopicCache = HashMap$.MODULE$.empty();
        this.producerStats = ProducerStatsRegistry$.MODULE$.getProducerStats(config.clientId());
        this.producerTopicStats = ProducerTopicStatsRegistry$.MODULE$.getProducerTopicStats(config.clientId());
    }
}

