/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.CreateTopicMetadata;
import kafka.server.DelayedCreateTopics;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001\u001d\u0011A\"\u00113nS:l\u0015M\\1hKJT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!qA\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oOB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\b[\u0016$(/[2t\u0013\tIbCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0007G>tg-[4\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005;\u000591m\u001c8gS\u001e\u0004\u0003\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0016\u0003\u0015\u0002\"AJ\u0018\u000e\u0003\u001dR!a\u0006\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0006W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001tEA\u0004NKR\u0014\u0018nY:\t\u0011I\u0002!\u0011!Q\u0001\n\u0015\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u000e\t\u0003=]J!\u0001\u000f\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Q\u0004A!A!\u0002\u00131\u0014AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u00059!p[+uS2\u001cX#\u0001 \u0011\u0005=y\u0014B\u0001!\u0011\u0005\u001dQ6.\u0016;jYND\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAP\u0001\tu.,F/\u001b7tA!)A\t\u0001C\u0001\u000b\u00061A(\u001b8jiz\"RAR$I\u0013*\u0003\"A\b\u0001\t\u000bm\u0019\u0005\u0019A\u000f\t\u000b]\u0019\u0005\u0019A\u0013\t\u000bQ\u001a\u0005\u0019\u0001\u001c\t\u000bq\u001a\u0005\u0019\u0001 \t\u000f1\u0003!\u0019!C\u0001\u001b\u0006qAo\u001c9jGB+(oZ1u_JLX#\u0001(\u0011\u0007yy\u0015+\u0003\u0002Q\u0005\tIB)\u001a7bs\u0016$w\n]3sCRLwN\u001c)ve\u001e\fGo\u001c:z!\tq\"+\u0003\u0002T\u0005\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\u001c\u0005\u0007+\u0002\u0001\u000b\u0011\u0002(\u0002\u001fQ|\u0007/[2QkJ<\u0017\r^8ss\u0002BQa\u0016\u0001\u0005\u0002a\u000b\u0011\u0004[1t\t\u0016d\u0017-_3e)>\u0004\u0018nY(qKJ\fG/[8ogV\t\u0011\f\u0005\u0002\n5&\u00111L\u0003\u0002\b\u0005>|G.Z1o\u0011\u0015i\u0006\u0001\"\u0001_\u0003\u0005\"(/_\"p[BdW\r^3EK2\f\u00170\u001a3U_BL7m\u00149fe\u0006$\u0018n\u001c8t)\ty&\r\u0005\u0002\nA&\u0011\u0011M\u0003\u0002\u0005+:LG\u000fC\u0003d9\u0002\u0007A-A\u0003u_BL7\r\u0005\u0002fY:\u0011aM\u001b\t\u0003O*i\u0011\u0001\u001b\u0006\u0003S\u001a\ta\u0001\u0010:p_Rt\u0014BA6\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011QN\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-T\u0001\"\u00029\u0001\t\u0003\t\u0018\u0001D2sK\u0006$X\rV8qS\u000e\u001cH#B0so\u0006\u0015\u0002\"B:p\u0001\u0004!\u0018a\u0002;j[\u0016|W\u000f\u001e\t\u0003\u0013UL!A\u001e\u0006\u0003\u0007%sG\u000fC\u0003y_\u0002\u0007\u00110\u0001\u0006de\u0016\fG/Z%oM>\u0004BA_?e\u007f6\t1P\u0003\u0002}\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005y\\(aA'baB!\u0011\u0011AA\u0010\u001d\u0011\t\u0019!!\u0007\u000f\t\u0005\u0015\u0011Q\u0003\b\u0005\u0003\u000f\t\u0019B\u0004\u0003\u0002\n\u0005Ea\u0002BA\u0006\u0003\u001fq1aZA\u0007\u0013\u0005q\u0013B\u0001\u0017.\u0013\t)1&\u0003\u0002*U%\u0019\u0011q\u0003\u0015\u0002\u0011I,\u0017/^3tiNLA!a\u0007\u0002\u001e\u0005\u00192I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti*\u0019\u0011q\u0003\u0015\n\t\u0005\u0005\u00121\u0005\u0002\r)>\u0004\u0018n\u0019#fi\u0006LGn\u001d\u0006\u0005\u00037\ti\u0002C\u0004\u0002(=\u0004\r!!\u000b\u0002!I,7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007CB\u0005\u0002,\u0005=r,C\u0002\u0002.)\u0011\u0011BR;oGRLwN\\\u0019\u0011\u000bilH-!\r\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e)\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA\u001e\u0003k\u0011a!\u0012:s_J\u001c\bbBA \u0001\u0011\u0005\u0011\u0011I\u0001\rI\u0016dW\r^3U_BL7m\u001d\u000b\b?\u0006\r\u0013QIA(\u0011\u0019\u0019\u0018Q\ba\u0001i\"A\u0011qIA\u001f\u0001\u0004\tI%\u0001\u0004u_BL7m\u001d\t\u0005u\u0006-C-C\u0002\u0002Nm\u00141aU3u\u0011!\t9#!\u0010A\u0002\u0005%\u0002bBA*\u0001\u0011\u0005\u0011QK\u0001\tg\",H\u000fZ8x]R\tq\f")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final ZkUtils zkUtils;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request key ", " unblocked ", " topic requests."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.keyLabel(), BoxesRunTime.boxToInteger((int)completed)})));
    }

    public void createTopics(int timeout, Map<String, CreateTopicsRequest.TopicDetails> createInfo, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)createInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CreateTopicMetadata createTopicMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                CreateTopicsRequest.TopicDetails arguments = (CreateTopicsRequest.TopicDetails)tuple2._2();
                try {
                    Properties configs = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.configs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        Object object = configs.setProperty(key, value);
                        return object;
                    });
                    LogConfig$.MODULE$.validate(configs);
                    if (!(arguments.numPartitions == -1 && arguments.replicationFactor == -1 || arguments.replicasAssignments.isEmpty())) {
                        throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                    }
                    Map<Object, Seq<Object>> assignments = !arguments.replicasAssignments.isEmpty() ? (Map<Object, Seq<Object>>)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.replicasAssignments).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Integer partitionId = (Integer)tuple2._1();
                        List replicas = (List)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1), Buffer$.MODULE$.canBuildFrom()));
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom()) : AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)brokers, arguments.numPartitions, arguments.replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignments for topic ", " are ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, assignments})));
                    AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, assignments, configs, false);
                    createTopicMetadata = new CreateTopicMetadata(topic, assignments, Errors.NONE);
                }
                catch (Throwable e) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, arguments})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    createTopicMetadata = new CreateTopicMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), Errors.forException((Throwable)e));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CreateTopicMetadata createTopicMetadata2 = createTopicMetadata;
            return createTopicMetadata2;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || !metadata.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$9(x$2)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createTopicMetadata -> {
                Errors errors = createTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)createTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error());
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedCreateTopics delayedCreate = new DelayedCreateTopics(timeout, (Seq<CreateTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedCreateKeys = ((TraversableOnce)createInfo.keys().map((Function1 & Serializable & scala.Serializable)x$3 -> new TopicKey((String)x$3), Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> {
            DeleteTopicMetadata deleteTopicMetadata;
            try {
                AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), (String)topic);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (TopicAlreadyMarkedForDeletionException e) {
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing delete topic request for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.forException((Throwable)e));
            }
            return deleteTopicMetadata;
        }, Set$.MODULE$.canBuildFrom());
        if (timeout <= 0 || !metadata.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$deleteTopics$4(x$4)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)deleteTopicMetadata -> {
                Errors errors = deleteTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedDeleteKeys = ((SetLike)topics.map((Function1 & Serializable & scala.Serializable)x$5 -> new TopicKey((String)x$5), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
        }
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$9(CreateTopicMetadata x$2) {
        Errors errors = x$2.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopics$4(DeleteTopicMetadata x$4) {
        Errors errors = x$4.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, ZkUtils zkUtils) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkUtils = zkUtils;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq("[Admin Manager on Broker " + config.brokerId() + "]: ");
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3());
    }
}

