/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientSensors;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaEntity;
import kafka.server.QuotaId;
import kafka.server.QuotaId$;
import kafka.server.QuotaType;
import kafka.server.QuotaTypes$;
import kafka.server.SensorAccess;
import kafka.server.ThrottledResponse;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\rc\u0001B\u0001\u0003\u0001\u001d\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\taaY8oM&<W#A\f\u0011\u0005aIR\"\u0001\u0002\n\u0005i\u0011!\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\"AA\u0004\u0001B\u0001B\u0003%q#A\u0004d_:4\u0017n\u001a\u0011\t\u0011y\u0001!Q1A\u0005\n}\tq!\\3ue&\u001c7/F\u0001!!\t\t#&D\u0001#\u0015\tq2E\u0003\u0002%K\u000511m\\7n_:T!!\u0002\u0014\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012q!T3ue&\u001c7\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003!\u0003!iW\r\u001e:jGN\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0002\u0019\u0002\r\u0005\u0004\u0018nS3z+\u0005\t\u0004C\u0001\r3\u0013\t\u0019$AA\u0005Rk>$\u0018\rV=qK\"AQ\u0007\u0001B\u0001B\u0003%\u0011'A\u0004ba&\\U-\u001f\u0011\t\u0011]\u0002!Q1A\u0005\na\nA\u0001^5nKV\t\u0011\b\u0005\u0002;y5\t1H\u0003\u0002\u0012G%\u0011Qh\u000f\u0002\u0005)&lW\r\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003:\u0003\u0015!\u0018.\\3!\u0011\u0015\t\u0005\u0001\"\u0001C\u0003\u0019a\u0014N\\5u}Q)1\tR#G\u000fB\u0011\u0001\u0004\u0001\u0005\u0006+\u0001\u0003\ra\u0006\u0005\u0006=\u0001\u0003\r\u0001\t\u0005\u0006_\u0001\u0003\r!\r\u0005\u0006o\u0001\u0003\r!\u000f\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0003=yg/\u001a:sS\u0012$WM\\)v_R\fW#A&\u0011\t1\u001bV\u000bW\u0007\u0002\u001b*\u0011ajT\u0001\u000bG>t7-\u001e:sK:$(B\u0001)R\u0003\u0011)H/\u001b7\u000b\u0003I\u000bAA[1wC&\u0011A+\u0014\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001\rW\u0013\t9&AA\u0004Rk>$\u0018-\u00133\u0011\u0005\u0005J\u0016B\u0001.#\u0005\u0015\tVo\u001c;b\u0011\u0019a\u0006\u0001)A\u0005\u0017\u0006\u0001rN^3se&$G-\u001a8Rk>$\u0018\r\t\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0003e\u0019H/\u0019;jG\u000e{gNZ5h\u00072LWM\u001c;JIF+x\u000e^1\u0016\u0003aCa!\u0019\u0001!\u0002\u0013A\u0016AG:uCRL7mQ8oM&<7\t\\5f]RLE-U;pi\u0006\u0004\u0003bB2\u0001\u0001\u0004%I\u0001Z\u0001\u0012cV|G/\u0019+za\u0016\u001cXI\\1cY\u0016$W#A3\u0011\u0005%1\u0017BA4\u000b\u0005\rIe\u000e\u001e\u0005\bS\u0002\u0001\r\u0011\"\u0003k\u0003U\tXo\u001c;b)f\u0004Xm]#oC\ndW\rZ0%KF$\"a\u001b8\u0011\u0005%a\u0017BA7\u000b\u0005\u0011)f.\u001b;\t\u000f=D\u0017\u0011!a\u0001K\u0006\u0019\u0001\u0010J\u0019\t\rE\u0004\u0001\u0015)\u0003f\u0003I\tXo\u001c;b)f\u0004Xm]#oC\ndW\r\u001a\u0011\t\u000fM\u0004!\u0019!C\u0005i\u0006!An\\2l+\u0005)\bC\u0001<z\u001b\u00059(B\u0001=N\u0003\u0015awnY6t\u0013\tQxO\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0011\u0019a\b\u0001)A\u0005k\u0006)An\\2lA!9a\u0010\u0001b\u0001\n\u0013y\u0018A\u00033fY\u0006L\u0018+^3vKV\u0011\u0011\u0011\u0001\t\u0006\u0019\u0006\r\u0011qA\u0005\u0004\u0003\u000bi%A\u0003#fY\u0006L\u0018+^3vKB\u0019\u0001$!\u0003\n\u0007\u0005-!AA\tUQJ|G\u000f\u001e7fIJ+7\u000f]8og\u0016D\u0001\"a\u0004\u0001A\u0003%\u0011\u0011A\u0001\fI\u0016d\u0017-_)vKV,\u0007\u0005C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016\u0005q1/\u001a8t_J\f5mY3tg>\u0014XCAA\f!\rA\u0012\u0011D\u0005\u0004\u00037\u0011!\u0001D*f]N|'/Q2dKN\u001c\b\u0002CA\u0010\u0001\u0001\u0006I!a\u0006\u0002\u001fM,gn]8s\u0003\u000e\u001cWm]:pe\u0002B\u0011\"a\t\u0001\u0005\u0004%\t!!\n\u0002-QD'o\u001c;uY\u0016$'+Z9vKN$(+Z1qKJ,\"!a\n\u0011\t\u0005%\u00121F\u0007\u0002\u0001\u00191\u0011Q\u0006\u0001\u0001\u0003_\u0011a\u0003\u00165s_R$H.\u001a3SKF,Xm\u001d;SK\u0006\u0004XM]\n\u0005\u0003W\t\t\u0004E\u0002\u0010\u0003gI1!!\u000e\u0011\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\t\u0015y\fYC!A!\u0002\u0013\t\t\u0001C\u0004B\u0003W!\t!a\u000f\u0015\t\u0005\u001d\u0012Q\b\u0005\b}\u0006e\u0002\u0019AA\u0001\u0011!\t\t%a\u000b\u0005B\u0005\r\u0013A\u00023p/>\u00148\u000eF\u0001l\u0011!\t9\u0005\u0001Q\u0001\n\u0005\u001d\u0012a\u0006;ie>$H\u000f\\3e%\u0016\fX/Z:u%\u0016\f\u0007/\u001a:!\u0011%\tY\u0005\u0001b\u0001\n\u0013\ti%\u0001\teK2\f\u00170U;fk\u0016\u001cVM\\:peV\u0011\u0011q\n\t\u0004C\u0005E\u0013bAA*E\t11+\u001a8t_JD\u0001\"a\u0016\u0001A\u0003%\u0011qJ\u0001\u0012I\u0016d\u0017-_)vKV,7+\u001a8t_J\u0004\u0003bBA.\u0001\u0011\u0005\u0011QL\u0001\u0017e\u0016\u001cwN\u001d3B]\u0012l\u0015-\u001f2f)\"\u0014x\u000e\u001e;mKRIQ-a\u0018\u0002z\u0005u\u0014\u0011\u0011\u0005\t\u0003C\nI\u00061\u0001\u0002d\u0005i1/\u00198ji&TX\rZ+tKJ\u0004B!!\u001a\u0002t9!\u0011qMA8!\r\tIGC\u0007\u0003\u0003WR1!!\u001c\u0007\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u000f\u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\t)(a\u001e\u0003\rM#(/\u001b8h\u0015\r\t\tH\u0003\u0005\t\u0003w\nI\u00061\u0001\u0002d\u0005A1\r\\5f]RLE\rC\u0004\u0002\u0000\u0005e\u0003\u0019A3\u0002\u000bY\fG.^3\t\u0011\u0005\r\u0015\u0011\fa\u0001\u0003\u000b\u000b\u0001bY1mY\n\f7m\u001b\t\u0006\u0013\u0005\u001dUm[\u0005\u0004\u0003\u0013S!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\ti\t\u0001C\u0005\u0003\u001f\u000b1\"];pi\u0006,e\u000e^5usR1\u0011\u0011SAL\u00033\u00032\u0001GAJ\u0013\r\t)J\u0001\u0002\f#V|G/Y#oi&$\u0018\u0010\u0003\u0005\u0002b\u0005-\u0005\u0019AA2\u0011!\tY(a#A\u0002\u0005\r\u0004bBAO\u0001\u0011%\u0011qT\u0001#cV|G/Y#oi&$\u0018pV5uQ6+H\u000e^5qY\u0016\fVo\u001c;b\u0019\u00164X\r\\:\u0015\r\u0005E\u0015\u0011UAR\u0011!\t\t'a'A\u0002\u0005\r\u0004\u0002CA>\u00037\u0003\r!a\u0019\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u0006)\u0011/^8uCR)\u0001,a+\u00020\"A\u0011QVAS\u0001\u0004\t\u0019'\u0001\u0003vg\u0016\u0014\b\u0002CA>\u0003K\u0003\r!a\u0019\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\u0006aA\u000f\u001b:piRdW\rV5nKR)Q-a.\u0002B\"A\u0011\u0011XAY\u0001\u0004\tY,\u0001\u0007dY&,g\u000e^'fiJL7\rE\u0002\"\u0003{K1!a0#\u0005-Y\u0015MZ6b\u001b\u0016$(/[2\t\u000fU\t\t\f1\u0001\u0002DB\u0019\u0011%!2\n\u0007\u0005\u001d'E\u0001\u0007NKR\u0014\u0018nY\"p]\u001aLw\rC\u0004\u0002L\u0002!I!!4\u0002!5,\u0017m];sC\ndW-Q:SCR,GCBAh\u00037\f9\u000f\u0005\u0003\u0002R\u0006]WBAAj\u0015\r\t)NI\u0001\u0006gR\fGo]\u0005\u0005\u00033\f\u0019N\u0001\u0003SCR,\u0007\u0002CAo\u0003\u0013\u0004\r!a8\u0002\t9\fW.\u001a\t\u0005\u0003C\f\u0019/D\u0001$\u0013\r\t)o\t\u0002\u000b\u001b\u0016$(/[2OC6,\u0007\u0002CAu\u0003\u0013\u0004\r!a;\u0002\u00155,\u0017m];sC\ndW\rE\u0002\"\u0003[L1!a<#\u0005)iU-Y:ve\u0006\u0014G.\u001a\u0005\b\u0003g\u0004A\u0011BA{\u0003]9W\r^(s\u0007J,\u0017\r^3Rk>$\u0018mU3og>\u00148\u000f\u0006\u0003\u0002x\u0006u\bc\u0001\r\u0002z&\u0019\u00111 \u0002\u0003\u001b\rc\u0017.\u001a8u'\u0016t7o\u001c:t\u0011!\ti)!=A\u0002\u0005E\u0005b\u0002B\u0001\u0001\u0011%!1A\u0001\u001aO\u0016$H\u000b\u001b:piRdW\rV5nKN+gn]8s\u001d\u0006lW\r\u0006\u0003\u0002d\t\u0015\u0001b\u0002B\u0004\u0003\u007f\u0004\r!V\u0001\bcV|G/Y%e\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005\u001b\t!cZ3u#V|G/Y*f]N|'OT1nKR!\u00111\rB\b\u0011\u001d\u00119A!\u0003A\u0002UCqAa\u0005\u0001\t\u0013\u0011)\"\u0001\u000bhKR\fVo\u001c;b\u001b\u0016$(/[2D_:4\u0017n\u001a\u000b\u0005\u0003\u0007\u00149\u0002C\u0004\u0002(\nE\u0001\u0019\u0001-\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e\u0005YQ\u000f\u001d3bi\u0016\fVo\u001c;b)\u001dY'q\u0004B\u0014\u0005SA\u0001\"!\u0019\u0003\u001a\u0001\u0007!\u0011\u0005\t\u0006\u0013\t\r\u00121M\u0005\u0004\u0005KQ!AB(qi&|g\u000e\u0003\u0005\u0002|\te\u0001\u0019\u0001B\u0011\u0011!\t9K!\u0007A\u0002\t-\u0002\u0003B\u0005\u0003$aCqAa\f\u0001\t\u0013\u0011\t$\u0001\u000bdY&,g\u000e\u001e*bi\u0016lU\r\u001e:jG:\u000bW.\u001a\u000b\u0007\u0003?\u0014\u0019D!\u000e\t\u0011\u0005\u0005$Q\u0006a\u0001\u0003GB\u0001\"a\u001f\u0003.\u0001\u0007\u00111\r\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\u0003I!\bN]8ui2,W*\u001a;sS\u000et\u0015-\\3\u0015\t\u0005}'Q\b\u0005\t\u0003\u001b\u00139\u00041\u0001\u0002\u0012\"9!\u0011\t\u0001\u0005\u0002\u0005\r\u0013\u0001C:ikR$wn\u001e8")
public class ClientQuotaManager
implements Logging {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType kafka$server$ClientQuotaManager$$apiKey;
    private final Time time;
    private final ConcurrentHashMap<QuotaId, Quota> overriddenQuota;
    private final Quota staticConfigClientIdQuota;
    private int quotaTypesEnabled;
    private final ReentrantReadWriteLock lock;
    private final DelayQueue<ThrottledResponse> delayQueue;
    private final SensorAccess sensorAccessor;
    private final ThrottledRequestReaper throttledRequestReaper;
    private final Sensor kafka$server$ClientQuotaManager$$delayQueueSensor;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientQuotaManager clientQuotaManager = this;
        synchronized (clientQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public QuotaType kafka$server$ClientQuotaManager$$apiKey() {
        return this.kafka$server$ClientQuotaManager$$apiKey;
    }

    private Time time() {
        return this.time;
    }

    private ConcurrentHashMap<QuotaId, Quota> overriddenQuota() {
        return this.overriddenQuota;
    }

    private Quota staticConfigClientIdQuota() {
        return this.staticConfigClientIdQuota;
    }

    private int quotaTypesEnabled() {
        return this.quotaTypesEnabled;
    }

    private void quotaTypesEnabled_$eq(int x$1) {
        this.quotaTypesEnabled = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private DelayQueue<ThrottledResponse> delayQueue() {
        return this.delayQueue;
    }

    private SensorAccess sensorAccessor() {
        return this.sensorAccessor;
    }

    public ThrottledRequestReaper throttledRequestReaper() {
        return this.throttledRequestReaper;
    }

    public Sensor kafka$server$ClientQuotaManager$$delayQueueSensor() {
        return this.kafka$server$ClientQuotaManager$$delayQueueSensor;
    }

    public int recordAndMaybeThrottle(String sanitizedUser, String clientId, int value, Function1<Object, BoxedUnit> callback) {
        QuotaEntity clientQuotaEntity = this.quotaEntity(sanitizedUser, clientId);
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(clientQuotaEntity);
        int throttleTimeMs = 0;
        try {
            clientSensors.quotaSensor().record((double)value);
            callback.apply$mcVI$sp(0);
        }
        catch (QuotaViolationException qve) {
            KafkaMetric clientMetric = (KafkaMetric)this.metrics().metrics().get(this.clientRateMetricName(clientQuotaEntity.sanitizedUser(), clientQuotaEntity.clientId()));
            throttleTimeMs = this.throttleTime(clientMetric, this.getQuotaMetricConfig(clientQuotaEntity.quota()));
            clientSensors.throttleTimeSensor().record((double)throttleTimeMs);
            this.delayQueue().add(new ThrottledResponse(this.time(), throttleTimeMs, callback));
            this.kafka$server$ClientQuotaManager$$delayQueueSensor().record();
            this.logger().debug((Object)new StringOps(Predef$.MODULE$.augmentString("Quota violated for sensor (%s). Delay time: (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientSensors.quotaSensor().name(), BoxesRunTime.boxToInteger((int)throttleTimeMs)})));
        }
        return throttleTimeMs;
    }

    private QuotaEntity quotaEntity(String sanitizedUser, String clientId) {
        QuotaEntity quotaEntity;
        int n = this.quotaTypesEnabled();
        boolean bl = QuotaTypes$.MODULE$.NoQuotas() == n ? true : QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == n;
        if (bl) {
            QuotaId quotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultClientIdQuotaId())) == null) {
                quota = this.staticConfigClientIdQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, "", clientId, quota);
        } else if (QuotaTypes$.MODULE$.UserQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$);
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, "", quota);
        } else if (QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default())))) == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId)))) == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserClientIdQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, clientId, quota);
        } else {
            quotaEntity = this.quotaEntityWithMultipleQuotaLevels(sanitizedUser, clientId);
        }
        return quotaEntity;
    }

    private QuotaEntity quotaEntityWithMultipleQuotaLevels(String sanitizedUser, String clientId) {
        QuotaId userClientQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId));
        QuotaId userQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$);
        QuotaId clientQuotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
        QuotaId quotaId = userClientQuotaId;
        QuotaId quotaConfigId = userClientQuotaId;
        Quota quota = this.overriddenQuota().get(quotaConfigId);
        if (quota == null) {
            quotaId = userClientQuotaId;
            quotaConfigId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
            quota = this.overriddenQuota().get(quotaConfigId);
            if (quota == null) {
                quotaConfigId = quotaId = userQuotaId;
                quota = this.overriddenQuota().get(quotaConfigId);
                if (quota == null) {
                    quotaId = userClientQuotaId;
                    quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId));
                    quota = this.overriddenQuota().get(quotaConfigId);
                    if (quota == null) {
                        quotaId = userClientQuotaId;
                        quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                        quota = this.overriddenQuota().get(quotaConfigId);
                        if (quota == null) {
                            quotaId = userQuotaId;
                            quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
                            quota = this.overriddenQuota().get(quotaConfigId);
                            if (quota == null) {
                                quotaId = clientQuotaId;
                                quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
                                quota = this.overriddenQuota().get(quotaConfigId);
                                if (quota == null) {
                                    quotaId = clientQuotaId;
                                    quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                                    quota = this.overriddenQuota().get(quotaConfigId);
                                    if (quota == null) {
                                        quotaId = clientQuotaId;
                                        quotaConfigId = null;
                                        quota = this.staticConfigClientIdQuota();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        QuotaId quotaId2 = quotaId;
        QuotaId quotaId3 = clientQuotaId;
        String quotaUser = !(quotaId2 != null ? !((Object)quotaId2).equals(quotaId3) : quotaId3 != null) ? "" : sanitizedUser;
        QuotaId quotaId4 = quotaId;
        QuotaId quotaId5 = userQuotaId;
        String quotaClientId = !(quotaId4 != null ? !((Object)quotaId4).equals(quotaId5) : quotaId5 != null) ? "" : clientId;
        return new QuotaEntity(quotaId, quotaUser, quotaClientId, quota);
    }

    public Quota quota(String user, String clientId) {
        return this.quotaEntity(QuotaId$.MODULE$.sanitize(user), clientId).quota();
    }

    private int throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        Rate rateMetric = this.measurableAsRate(clientMetric.metricName(), clientMetric.measurable());
        Quota quota = config.quota();
        double difference = clientMetric.value() - quota.bound();
        double throttleTimeMs = difference / quota.bound() * (double)rateMetric.windowSize(config, this.time().milliseconds());
        return (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(throttleTimeMs));
    }

    private Rate measurableAsRate(MetricName name, Measurable measurable) {
        Rate rate;
        Measurable measurable2 = measurable;
        if (!(measurable2 instanceof Rate)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric ", " is not a Rate metric, value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, measurable})));
        }
        Rate rate2 = rate = (Rate)measurable2;
        return rate2;
    }

    private ClientSensors getOrCreateQuotaSensors(QuotaEntity quotaEntity) {
        return new ClientSensors(this.sensorAccessor().getOrCreate(this.getQuotaSensorName(quotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)(Function0 & Serializable & scala.Serializable)() -> this.clientRateMetricName(quotaEntity.sanitizedUser(), quotaEntity.clientId()), (Function0<MetricConfig>)(Function0 & Serializable & scala.Serializable)() -> this.getQuotaMetricConfig(quotaEntity.quota()), (Function0<MeasurableStat>)(Function0 & Serializable & scala.Serializable)() -> new Rate()), this.sensorAccessor().getOrCreate(this.getThrottleTimeSensorName(quotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)(Function0 & Serializable & scala.Serializable)() -> this.throttleMetricName(quotaEntity), (Function0<MetricConfig>)(Function0 & Serializable & scala.Serializable)() -> null, (Function0<MeasurableStat>)(Function0 & Serializable & scala.Serializable)() -> new Avg()));
    }

    private String getThrottleTimeSensorName(QuotaId quotaId) {
        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$apiKey()), "ThrottleTime-") + quotaId.sanitizedUser().getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + ':' + quotaId.clientId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    private String getQuotaSensorName(QuotaId quotaId) {
        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$apiKey()), "-") + quotaId.sanitizedUser().getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + ':' + quotaId.clientId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    private MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    /*
     * Unable to fully structure code
     */
    public void updateQuota(Option<String> sanitizedUser, Option<String> clientId, Option<Quota> quota) {
        this.lock().writeLock().lock();
        try {
            block28: {
                block23: {
                    block25: {
                        block27: {
                            block26: {
                                block24: {
                                    quotaId = new QuotaId(sanitizedUser, clientId);
                                    var12_5 = false;
                                    var13_6 = null;
                                    var14_7 = sanitizedUser;
                                    if (!(var14_7 instanceof Some)) ** GOTO lbl-1000
                                    var12_5 = true;
                                    var13_6 = (Some)var14_7;
                                    var15_8 = (String)var13_6.value();
                                    v0 = ConfigEntityName$.MODULE$.Default();
                                    var16_9 = var15_8;
                                    if (!(v0 != null ? v0.equals(var16_9) == false : var16_9 != null)) {
                                        var9_10 = "default user ";
                                    } else if (var12_5) {
                                        user = (String)var13_6.value();
                                        var9_10 = "user " + user + " ";
                                    } else if (None$.MODULE$.equals(var14_7)) {
                                        var9_10 = "";
                                    } else {
                                        throw new MatchError(var14_7);
                                    }
                                    userInfo = var9_10;
                                    var19_13 = false;
                                    var20_14 = null;
                                    var21_15 = clientId;
                                    if (!(var21_15 instanceof Some)) ** GOTO lbl-1000
                                    var19_13 = true;
                                    var20_14 = (Some)var21_15;
                                    var22_16 = (String)var20_14.value();
                                    v1 = ConfigEntityName$.MODULE$.Default();
                                    var23_17 = var22_16;
                                    if (!(v1 != null ? v1.equals(var23_17) == false : var23_17 != null)) {
                                        var8_18 = "default client-id";
                                    } else if (var19_13) {
                                        id = (String)var20_14.value();
                                        var8_18 = "client-id " + id;
                                    } else if (None$.MODULE$.equals(var21_15)) {
                                        var8_18 = "";
                                    } else {
                                        throw new MatchError(var21_15);
                                    }
                                    clientIdInfo = var8_18;
                                    var25_21 = quota;
                                    if (!(var25_21 instanceof Some)) break block23;
                                    var26_22 = (Some)var25_21;
                                    newQuota = (Quota)var26_22.value();
                                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changing ", " quota for ", "", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$apiKey(), userInfo, clientIdInfo, BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                                    this.overriddenQuota().put(quotaId, newQuota);
                                    var28_24 = new Tuple2(sanitizedUser, clientId);
                                    if (var28_24 == null) break block24;
                                    var29_25 = (Option)var28_24._1();
                                    var30_26 = (Option)var28_24._2();
                                    if (!(var29_25 instanceof Some) || !(var30_26 instanceof Some)) break block24;
                                    this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserClientIdQuotaEnabled());
                                    var7_27 = BoxedUnit.UNIT;
                                    break block25;
                                }
                                if (var28_24 == null) break block26;
                                var31_31 = (Option)var28_24._1();
                                var32_32 = (Option)var28_24._2();
                                if (!(var31_31 instanceof Some) || !None$.MODULE$.equals(var32_32)) break block26;
                                this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserQuotaEnabled());
                                var7_28 = BoxedUnit.UNIT;
                                break block25;
                            }
                            if (var28_24 == null) break block27;
                            var33_33 = (Option)var28_24._1();
                            var34_34 = (Option)var28_24._2();
                            if (!None$.MODULE$.equals(var33_33) || !(var34_34 instanceof Some)) break block27;
                            this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.ClientIdQuotaEnabled());
                            var7_29 = BoxedUnit.UNIT;
                            break block25;
                        }
                        if (var28_24 == null) ** GOTO lbl-1000
                        var35_35 = (Option)var28_24._1();
                        var36_36 = (Option)var28_24._2();
                        if (None$.MODULE$.equals(var35_35) && None$.MODULE$.equals(var36_36)) {
                            var7_30 = BoxedUnit.UNIT;
                        } else lbl-1000:
                        // 2 sources

                        {
                            throw new MatchError((Object)var28_24);
                        }
                    }
                    var6_37 = BoxedUnit.UNIT;
                    break block28;
                }
                if (None$.MODULE$.equals(var25_21)) {
                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " quota for ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$apiKey(), userInfo, clientIdInfo})));
                    var6_37 = this.overriddenQuota().remove(quotaId);
                } else {
                    throw new MatchError(var25_21);
                }
            }
            quotaMetricName = this.clientRateMetricName((String)sanitizedUser.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$1(), ()Ljava/lang/String;)()), (String)clientId.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$2(), ()Ljava/lang/String;)()));
            allMetrics = this.metrics().metrics();
            var40_40 = this.quotaTypesEnabled();
            var5_41 = QuotaTypes$.MODULE$.NoQuotas() == var40_40 ? true : (QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == var40_40 ? true : (QuotaTypes$.MODULE$.UserQuotaEnabled() == var40_40 ? true : QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == var40_40));
            var4_42 = var5_41 != false ? sanitizedUser.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$3$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()).isDefined() == false && clientId.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$4$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()).isDefined() == false : false;
            singleUpdate = var4_42;
            if (singleUpdate) {
                metric = (KafkaMetric)allMetrics.get(quotaMetricName);
                if (metric != null) {
                    metricConfigEntity = this.quotaEntity((String)sanitizedUser.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$5(), ()Ljava/lang/String;)()), (String)clientId.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$6(), ()Ljava/lang/String;)()));
                    newQuota = metricConfigEntity.quota();
                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for ", "", " already exists. Changing quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userInfo, clientIdInfo, BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                    metric.config(this.getQuotaMetricConfig(newQuota));
                }
            } else {
                JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(allMetrics).filterKeys((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$7$adapted(org.apache.kafka.common.MetricName org.apache.kafka.common.MetricName ), (Lorg/apache/kafka/common/MetricName;)Ljava/lang/Object;)((MetricName)quotaMetricName)).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$8$adapted(kafka.server.ClientQuotaManager scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ClientQuotaManager)this));
            }
        }
        finally {
            this.lock().writeLock().unlock();
        }
    }

    private MetricName clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("byte-rate", this.kafka$server$ClientQuotaManager$$apiKey().toString(), "Tracking byte-rate per user/client-id", new String[]{"user", sanitizedUser, "client-id", clientId});
    }

    private MetricName throttleMetricName(QuotaEntity quotaEntity) {
        return this.metrics().metricName("throttle-time", this.kafka$server$ClientQuotaManager$$apiKey().toString(), "Tracking average throttle-time per user/client-id", new String[]{"user", quotaEntity.sanitizedUser(), "client-id", quotaEntity.clientId()});
    }

    public void shutdown() {
        this.throttledRequestReaper().shutdown();
    }

    public static final /* synthetic */ String $anonfun$updateQuota$1() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$updateQuota$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$updateQuota$3(String x$1) {
        String string = x$1;
        String string2 = ConfigEntityName$.MODULE$.Default();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateQuota$4(String x$2) {
        String string = x$2;
        String string2 = ConfigEntityName$.MODULE$.Default();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$updateQuota$5() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$updateQuota$6() {
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$updateQuota$7(MetricName quotaMetricName$1, MetricName n) {
        String string = n.name();
        String string2 = quotaMetricName$1.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = n.group();
        String string4 = quotaMetricName$1.group();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ void $anonfun$updateQuota$8(ClientQuotaManager $this, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            MetricName metricName = (MetricName)tuple2._1();
            KafkaMetric metric = (KafkaMetric)tuple2._2();
            String userTag = metricName.tags().containsKey("user") ? (String)metricName.tags().get("user") : "";
            String clientIdTag = metricName.tags().containsKey("client-id") ? (String)metricName.tags().get("client-id") : "";
            QuotaEntity metricConfigEntity = $this.quotaEntity(userTag, clientIdTag);
            Quota quota = metricConfigEntity.quota();
            Quota quota2 = metric.config().quota();
            if (quota == null ? quota2 != null : !quota.equals(quota2)) {
                Quota newQuota = metricConfigEntity.quota();
                $this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for quota-id ", " already exists. Setting quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricConfigEntity.quotaId(), BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                metric.config($this.getQuotaMetricConfig(newQuota));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public ClientQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, QuotaType apiKey, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.kafka$server$ClientQuotaManager$$apiKey = apiKey;
        this.time = time;
        Logging.$init$(this);
        this.overriddenQuota = new ConcurrentHashMap();
        this.staticConfigClientIdQuota = Quota.upperBound((double)config.quotaBytesPerSecondDefault());
        this.quotaTypesEnabled = config.quotaBytesPerSecondDefault() == Long.MAX_VALUE ? QuotaTypes$.MODULE$.NoQuotas() : QuotaTypes$.MODULE$.ClientIdQuotaEnabled();
        this.lock = new ReentrantReadWriteLock();
        this.delayQueue = new DelayQueue();
        this.sensorAccessor = new SensorAccess();
        this.throttledRequestReaper = new ThrottledRequestReaper(this, this.delayQueue());
        this.throttledRequestReaper().start();
        this.kafka$server$ClientQuotaManager$$delayQueueSensor = metrics.sensor(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)apiKey), "-delayQueue"));
        this.kafka$server$ClientQuotaManager$$delayQueueSensor().add(metrics.metricName("queue-size", apiKey.toString(), "Tracks the size of the delay queue"), (MeasurableStat)new Total());
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$3$adapted(String x$1) {
        return BoxesRunTime.boxToBoolean((boolean)ClientQuotaManager.$anonfun$updateQuota$3(x$1));
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$4$adapted(String x$2) {
        return BoxesRunTime.boxToBoolean((boolean)ClientQuotaManager.$anonfun$updateQuota$4(x$2));
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$7$adapted(MetricName quotaMetricName$1, MetricName n) {
        return BoxesRunTime.boxToBoolean((boolean)ClientQuotaManager.$anonfun$updateQuota$7(quotaMetricName$1, n));
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$8$adapted(ClientQuotaManager $this, Tuple2 x0$1) {
        ClientQuotaManager.$anonfun$updateQuota$8($this, x0$1);
        return BoxedUnit.UNIT;
    }

    public class ThrottledRequestReaper
    extends ShutdownableThread {
        private final DelayQueue<ThrottledResponse> delayQueue;
        public final /* synthetic */ ClientQuotaManager $outer;

        @Override
        public void doWork() {
            block0: {
                ThrottledResponse response = (ThrottledResponse)this.delayQueue.poll(1L, TimeUnit.SECONDS);
                if (response == null) break block0;
                this.kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer().kafka$server$ClientQuotaManager$$delayQueueSensor().record(-1.0);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Response throttled for: " + response.throttleTimeMs() + " ms");
                response.execute();
            }
        }

        public /* synthetic */ ClientQuotaManager kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer() {
            return this.$outer;
        }

        public ThrottledRequestReaper(ClientQuotaManager $outer, DelayQueue<ThrottledResponse> delayQueue) {
            this.delayQueue = delayQueue;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(new StringOps(Predef$.MODULE$.augmentString("ThrottledRequestReaper-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.kafka$server$ClientQuotaManager$$apiKey()})), false);
        }
    }
}

