/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.server.AdminManager;
import kafka.server.CreateTopicMetadata;
import kafka.server.DelayedOperation;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u000f\t\u0019B)\u001a7bs\u0016$7I]3bi\u0016$v\u000e]5dg*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\u000b\u0002\u000f\u0011,G.Y=NgB\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t!Aj\u001c8h\u0013\ti!\u0002\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0018\u00039\u0019'/Z1uK6+G/\u00193bi\u0006\u00042\u0001G\u000e\u001e\u001b\u0005I\"B\u0001\u000e\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00039e\u00111aU3r!\tIa$\u0003\u0002 \u0005\t\u00192I]3bi\u0016$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u0007bI6Lg.T1oC\u001e,'\u000f\u0005\u0002\nG%\u0011AE\u0001\u0002\r\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\u0005\u001f!RS)\u0003\u0002*!\tIa)\u001e8di&|g.\r\t\u00051-j\u0003(\u0003\u0002-3\t\u0019Q*\u00199\u0011\u00059*dBA\u00184!\t\u0001\u0004#D\u00012\u0015\t\u0011d!\u0001\u0004=e>|GOP\u0005\u0003iA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011A\u0007\u0005\t\u0003s\rk\u0011A\u000f\u0006\u0003wq\n\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u0003{y\naaY8n[>t'BA\u0003@\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011S$AB#se>\u00148\u000f\u0005\u0002\u0010\r&\u0011q\t\u0005\u0002\u0005+:LG\u000fC\u0003J\u0001\u0011\u0005!*\u0001\u0004=S:LGO\u0010\u000b\u0006\u00172kej\u0014\t\u0003\u0013\u0001AQ!\u0004%A\u00029AQA\u0006%A\u0002]AQ!\t%A\u0002\tBQA\n%A\u0002\u001dBQ!\u0015\u0001\u0005BI\u000b1\u0002\u001e:z\u0007>l\u0007\u000f\\3uKR\t1\u000b\u0005\u0002\u0010)&\u0011Q\u000b\u0005\u0002\b\u0005>|G.Z1o\u0011\u00159\u0006\u0001\"\u0011Y\u0003)ygnQ8na2,G/\u001a\u000b\u0002\u000b\")!\f\u0001C!1\u0006aqN\\#ya&\u0014\u0018\r^5p]\")A\f\u0001C\u0005;\u0006\u0011R.[:tS:<G*Z1eKJ\u001cu.\u001e8u)\rq\u0016m\u0019\t\u0003\u001f}K!\u0001\u0019\t\u0003\u0007%sG\u000fC\u0003c7\u0002\u0007Q&A\u0003u_BL7\rC\u0003e7\u0002\u0007Q-\u0001\u0006qCJ$\u0018\u000e^5p]N\u00042\u0001\u00074_\u0013\t9\u0017DA\u0002TKRDQ!\u001b\u0001\u0005\n)\fq\"[:NSN\u001c\u0018N\\4MK\u0006$WM\u001d\u000b\u0004'.d\u0007\"\u00022i\u0001\u0004i\u0003\"B7i\u0001\u0004q\u0016!\u00039beRLG/[8o\u0001")
public class DelayedCreateTopics
extends DelayedOperation {
    private final Seq<CreateTopicMetadata> createMetadata;
    private final AdminManager adminManager;
    private final Function1<Map<String, Errors>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        boolean bl;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to complete operation for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.createMetadata})));
        int leaderlessPartitionCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.createMetadata.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedCreateTopics.$anonfun$tryComplete$2(x$1)))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)DelayedCreateTopics.$anonfun$tryComplete$3(this, BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
        if (leaderlessPartitionCount == 0) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "All partitions have a leader, completing the delayed operation");
            bl = this.forceComplete();
        } else {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " partitions do not have a leader, not completing the delayed operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderlessPartitionCount)})));
            bl = false;
        }
        return bl;
    }

    @Override
    public void onComplete() {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completing operation for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.createMetadata})));
        scala.collection.immutable.Map results = ((TraversableOnce)this.createMetadata.map((Function1 & Serializable & scala.Serializable)metadata -> {
            Errors errors = metadata.error();
            Errors errors2 = Errors.NONE;
            return !(errors != null ? !errors.equals(errors2) : errors2 != null) && this.missingLeaderCount(metadata.topic(), (Set<Object>)metadata.replicaAssignments().keySet()) > 0 ? new Tuple2((Object)metadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)metadata.topic(), (Object)metadata.error());
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.responseCallback.apply((Object)results);
    }

    @Override
    public void onExpiration() {
    }

    private int missingLeaderCount(String topic, Set<Object> partitions) {
        return BoxesRunTime.unboxToInt((Object)partitions.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$2, x1$2);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int counter = sp2._1$mcI$sp();
            int partition = sp2._2$mcI$sp();
            int n = this.isMissingLeader(topic, partition) ? counter + 1 : counter;
            return n;
        }));
    }

    private boolean isMissingLeader(String topic, int partition) {
        Option<PartitionStateInfo> partitionInfo = this.adminManager.metadataCache().getPartitionInfo(topic, partition);
        return partitionInfo.isEmpty() || ((PartitionStateInfo)partitionInfo.get()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == LeaderAndIsr$.MODULE$.NoLeader();
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$2(CreateTopicMetadata x$1) {
        Errors errors = x$1.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ int $anonfun$tryComplete$3(DelayedCreateTopics $this, int x0$1, CreateTopicMetadata x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int topicCounter = tuple2._1$mcI$sp();
        CreateTopicMetadata metadata = (CreateTopicMetadata)tuple2._2();
        int n = topicCounter + $this.missingLeaderCount(metadata.topic(), (Set<Object>)metadata.replicaAssignments().keySet());
        return n;
    }

    public DelayedCreateTopics(long delayMs, Seq<CreateTopicMetadata> createMetadata, AdminManager adminManager, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        this.createMetadata = createMetadata;
        this.adminManager = adminManager;
        this.responseCallback = responseCallback;
        super(delayMs);
    }
}

