/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.api.ControlledShutdownRequest;
import kafka.api.ControlledShutdownResponse;
import kafka.api.FetchRequest;
import kafka.api.FetchRequest$;
import kafka.api.FetchResponse;
import kafka.api.FetchResponse$;
import kafka.api.FetchResponsePartitionData;
import kafka.api.FetchResponseSend;
import kafka.api.PartitionFetchInfo;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetMetadata;
import kafka.common.OffsetMetadata$;
import kafka.common.Topic$;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController;
import kafka.coordinator.GroupCoordinator;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.JoinGroupResult;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.TimestampOffset;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message$;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.network.RequestChannel;
import kafka.network.RequestOrResponseSend;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.Write$;
import kafka.server.AdminManager;
import kafka.server.BecomeLeaderOrFollowerResult;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.SystemTime$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Protocol;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.GroupCoordinatorRequest;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.ResponseSend;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r%g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011bS1gW\u0006\f\u0005/[:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0017\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012a\u0006\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\tqA\\3uo>\u00148.\u0003\u0002\u001d3\tq!+Z9vKN$8\t[1o]\u0016d\u0007\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u001fI,\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002B\u0001\u0002\t\u0001\u0003\u0006\u0004%\t!I\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005\u0011\u0003CA\u0012%\u001b\u0005\u0011\u0011BA\u0013\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0001b\n\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&\u0001\u0007bI6Lg.T1oC\u001e,'/F\u0001,!\t\u0019C&\u0003\u0002.\u0005\ta\u0011\tZ7j]6\u000bg.Y4fe\"Aq\u0006\u0001B\u0001B\u0003%1&A\u0007bI6Lg.T1oC\u001e,'\u000f\t\u0005\tc\u0001\u0011)\u0019!C\u0001e\u0005Y1m\\8sI&t\u0017\r^8s+\u0005\u0019\u0004C\u0001\u001b7\u001b\u0005)$BA\u0019\u0005\u0013\t9TG\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\"A\u0011\b\u0001B\u0001B\u0003%1'\u0001\u0007d_>\u0014H-\u001b8bi>\u0014\b\u0005\u0003\u0005<\u0001\t\u0015\r\u0011\"\u0001=\u0003)\u0019wN\u001c;s_2dWM]\u000b\u0002{A\u0011a\bQ\u0007\u0002\u007f)\u00111\bB\u0005\u0003\u0003~\u0012qbS1gW\u0006\u001cuN\u001c;s_2dWM\u001d\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005{\u0005Y1m\u001c8ue>dG.\u001a:!\u0011!)\u0005A!b\u0001\n\u00031\u0015a\u0002>l+RLGn]\u000b\u0002\u000fB\u0011q\u0002S\u0005\u0003\u0013B\u0011qAW6Vi&d7\u000f\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003H\u0003!Q8.\u0016;jYN\u0004\u0003\u0002C'\u0001\u0005\u000b\u0007I\u0011\u0001(\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0014\t\u0003\u0013AK!!\u0015\u0006\u0003\u0007%sG\u000f\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003P\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005V\u0001\t\u0015\r\u0011\"\u0001W\u0003\u0019\u0019wN\u001c4jOV\tq\u000b\u0005\u0002$1&\u0011\u0011L\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003X\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001\"\u0018\u0001\u0003\u0006\u0004%\tAX\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003}\u0003\"a\t1\n\u0005\u0005\u0014!!D'fi\u0006$\u0017\r^1DC\u000eDW\r\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003`\u00039iW\r^1eCR\f7)Y2iK\u0002B\u0001\"\u001a\u0001\u0003\u0006\u0004%\tAZ\u0001\b[\u0016$(/[2t+\u00059\u0007C\u00015r\u001b\u0005I'BA3k\u0015\tYG.\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b5T!A\\8\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0018aA8sO&\u0011!/\u001b\u0002\b\u001b\u0016$(/[2t\u0011!!\bA!A!\u0002\u00139\u0017\u0001C7fiJL7m\u001d\u0011\t\u0011Y\u0004!Q1A\u0005\u0002]\f!\"Y;uQ>\u0014\u0018N_3s+\u0005A\bcA\u0005zw&\u0011!P\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0\u0001\u0003bkRD'bAA\u0001\t\u0005A1/Z2ve&$\u00180C\u0002\u0002\u0006u\u0014!\"Q;uQ>\u0014\u0018N_3s\u0011%\tI\u0001\u0001B\u0001B\u0003%\u00010A\u0006bkRDwN]5{KJ\u0004\u0003BCA\u0007\u0001\t\u0015\r\u0011\"\u0001\u0002\u0010\u00051\u0011/^8uCN,\"!!\u0005\u0011\t\u0005M\u0011q\u0005\b\u0005\u0003+\t\u0019C\u0004\u0003\u0002\u0018\u0005\u0005b\u0002BA\r\u0003?i!!a\u0007\u000b\u0007\u0005ua!\u0001\u0004=e>|GOP\u0005\u0002\u000b%\u00111\u0001B\u0005\u0004\u0003K\u0011\u0011\u0001D)v_R\fg)Y2u_JL\u0018\u0002BA\u0015\u0003W\u0011Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(bAA\u0013\u0005!Q\u0011q\u0006\u0001\u0003\u0002\u0003\u0006I!!\u0005\u0002\u000fE,x\u000e^1tA!Q\u00111\u0007\u0001\u0003\u0006\u0004%\t!!\u000e\u0002\u0013\rdWo\u001d;fe&#WCAA\u001c!\u0011\tI$!\u0011\u000f\t\u0005m\u0012Q\b\t\u0004\u00033Q\u0011bAA \u0015\u00051\u0001K]3eK\u001aLA!a\u0011\u0002F\t11\u000b\u001e:j]\u001eT1!a\u0010\u000b\u0011)\tI\u0005\u0001B\u0001B\u0003%\u0011qG\u0001\u000bG2,8\u000f^3s\u0013\u0012\u0004\u0003bBA'\u0001\u0011\u0005\u0011qJ\u0001\u0007y%t\u0017\u000e\u001e \u00159\u0005E\u00131KA+\u0003/\nI&a\u0017\u0002^\u0005}\u0013\u0011MA2\u0003K\n9'!\u001b\u0002lA\u00111\u0005\u0001\u0005\u0007+\u0005-\u0003\u0019A\f\t\r\u0001\nY\u00051\u0001#\u0011\u0019I\u00131\na\u0001W!1\u0011'a\u0013A\u0002MBaaOA&\u0001\u0004i\u0004BB#\u0002L\u0001\u0007q\t\u0003\u0004N\u0003\u0017\u0002\ra\u0014\u0005\u0007+\u0006-\u0003\u0019A,\t\ru\u000bY\u00051\u0001`\u0011\u0019)\u00171\na\u0001O\"1a/a\u0013A\u0002aD\u0001\"!\u0004\u0002L\u0001\u0007\u0011\u0011\u0003\u0005\t\u0003g\tY\u00051\u0001\u00028!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0014A\u00025b]\u0012dW\r\u0006\u0003\u0002t\u0005e\u0004cA\u0005\u0002v%\u0019\u0011q\u000f\u0006\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003w\ni\u00071\u0001\u0002~\u00059!/Z9vKN$\b\u0003BA@\u0003\u000bs1\u0001GAA\u0013\r\t\u0019)G\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\t9)!#\u0003\u000fI+\u0017/^3ti*\u0019\u00111Q\r\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\u0006I\u0002.\u00198eY\u0016dU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u)\u0011\t\u0019(!%\t\u0011\u0005m\u00141\u0012a\u0001\u0003{Bq!!&\u0001\t\u0003\t9*\u0001\riC:$G.Z*u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgR$B!a\u001d\u0002\u001a\"A\u00111PAJ\u0001\u0004\ti\bC\u0004\u0002\u001e\u0002!\t!a(\u00027!\fg\u000e\u001a7f+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u)\u0011\t\u0019(!)\t\u0011\u0005m\u00141\u0014a\u0001\u0003{Bq!!*\u0001\t\u0003\t9+A\u0010iC:$G.Z\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:\u0014V-];fgR$B!a\u001d\u0002*\"A\u00111PAR\u0001\u0004\ti\bC\u0004\u0002.\u0002!\t!a,\u00023!\fg\u000e\u001a7f\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e*fcV,7\u000f\u001e\u000b\u0005\u0003g\n\t\f\u0003\u0005\u0002|\u0005-\u0006\u0019AA?\u0011\u001d\t)\f\u0001C\u0005\u0003o\u000b\u0011\"Y;uQ>\u0014\u0018N_3\u0015\u0011\u0005e\u0016qXAh\u00033\u00042!CA^\u0013\r\tiL\u0003\u0002\b\u0005>|G.Z1o\u0011!\t\t-a-A\u0002\u0005\r\u0017aB:fgNLwN\u001c\t\u0005\u0003\u000b\fYM\u0004\u0003\u0002H\u0006\u0005e\u0002BA\f\u0003\u0013L!A\u0007\u0003\n\t\u00055\u0017\u0011\u0012\u0002\b'\u0016\u001c8/[8o\u0011!\t\t.a-A\u0002\u0005M\u0017!C8qKJ\fG/[8o!\ra\u0018Q[\u0005\u0004\u0003/l(!C(qKJ\fG/[8o\u0011!\tY.a-A\u0002\u0005u\u0017\u0001\u0003:fg>,(oY3\u0011\u0007q\fy.C\u0002\u0002bv\u0014\u0001BU3t_V\u00148-\u001a\u0005\b\u0003K\u0004A\u0011AAt\u0003UA\u0017M\u001c3mKB\u0013x\u000eZ;dKJ\u0014V-];fgR$B!a\u001d\u0002j\"A\u00111PAr\u0001\u0004\ti\bC\u0004\u0002n\u0002!\t!a<\u0002%!\fg\u000e\u001a7f\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u0005\u0003g\n\t\u0010\u0003\u0005\u0002|\u0005-\b\u0019AA?\u0011\u001d\t)\u0010\u0001C\u0005\u0003o\f\u0011d]5{K>3G\u000b\u001b:piRdW\r\u001a)beRLG/[8ogR9q*!?\u0003\n\t=\u0002\u0002CA~\u0003g\u0004\r!!@\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\u0005}(QA\u0007\u0003\u0005\u0003Q1Aa\u0001\u0005\u0003\r\t\u0007/[\u0005\u0005\u0005\u000f\u0011\tA\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0003\u0005\u0003\f\u0005M\b\u0019\u0001B\u0007\u0003MiWM]4fIB\u000b'\u000f^5uS>tG)\u0019;b!\u0019\u0011yA!\u0006\u0003\u001a5\u0011!\u0011\u0003\u0006\u0004\u0005'Q\u0011AC2pY2,7\r^5p]&!!q\u0003B\t\u0005\r\u0019V-\u001d\t\b\u0013\tm!q\u0004B\u0015\u0013\r\u0011iB\u0003\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\t\u0005\"QE\u0007\u0003\u0005GQ!a\u001b\u0003\n\t\t\u001d\"1\u0005\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\u0003BA\u0000\u0005WIAA!\f\u0003\u0002\tQb)\u001a;dQJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|g\u000eR1uC\"A!\u0011GAz\u0001\u0004\u0011\u0019$A\u0003rk>$\u0018\rE\u0002$\u0005kI1Aa\u000e\u0003\u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'\u000fC\u0004\u0003<\u0001!\tA!\u0010\u0002!I,\u0007\u000f\\5dCRLwN\\)v_R\fG\u0003\u0002B \u0005\u000b\u00022a\tB!\u0013\r\u0011\u0019E\u0001\u0002\r%\u0016\u0004H.[2b#V|G/\u0019\u0005\t\u0003w\u0014I\u00041\u0001\u0002~\"9!\u0011\n\u0001\u0005\u0002\t-\u0013a\u00055b]\u0012dWm\u00144gg\u0016$(+Z9vKN$H\u0003BA:\u0005\u001bB\u0001\"a\u001f\u0003H\u0001\u0007\u0011Q\u0010\u0005\b\u0005#\u0002A\u0011\u0002B*\u0003UA\u0017M\u001c3mK>3gm]3u%\u0016\fX/Z:u-B\"BA!\u0016\u0003xAA!q\u0002B,\u00057\u0012\u0019'\u0003\u0003\u0003Z\tE!aA'baB!!Q\fB0\u001b\u0005Q\u0017b\u0001B1U\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003\u0002B3\u0005crAAa\u001a\u0003n5\u0011!\u0011\u000e\u0006\u0004\u0005WR\u0017\u0001\u0003:fcV,7\u000f^:\n\t\t=$\u0011N\u0001\u0013\u0019&\u001cHo\u00144gg\u0016$(+Z:q_:\u001cX-\u0003\u0003\u0003t\tU$!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0003\u0003p\t%\u0004\u0002CA>\u0005\u001f\u0002\r!! \t\u000f\tm\u0004\u0001\"\u0003\u0003~\u0005)\u0002.\u00198eY\u0016|eMZ:fiJ+\u0017/^3tiZ\u000bD\u0003\u0002B+\u0005\u007fB\u0001\"a\u001f\u0003z\u0001\u0007\u0011Q\u0010\u0005\b\u0005\u0007\u0003A\u0011\u0001BC\u000311W\r^2i\u001f\u001a47/\u001a;t))\u00119Ia$\u0003 \n\r&q\u0015\t\u0007\u0005\u001f\u0011)B!#\u0011\u0007%\u0011Y)C\u0002\u0003\u000e*\u0011A\u0001T8oO\"A!\u0011\u0013BA\u0001\u0004\u0011\u0019*\u0001\u0006m_\u001el\u0015M\\1hKJ\u0004BA!&\u0003\u001c6\u0011!q\u0013\u0006\u0004\u00053#\u0011a\u00017pO&!!Q\u0014BL\u0005)aunZ'b]\u0006<WM\u001d\u0005\t\u0005C\u0013\t\t1\u0001\u0003\\\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0002\u0003BS\u0005\u0003\u0003\rA!#\u0002\u0013QLW.Z:uC6\u0004\bb\u0002BU\u0005\u0003\u0003\raT\u0001\u000e[\u0006Dh*^7PM\u001a\u001cX\r^:\t\u000f\t5\u0006\u0001\"\u0003\u00030\u00069b-\u001a;dQ>3gm]3u\r>\u0014H+[7fgR\fW\u000e\u001d\u000b\t\u0005c\u0013ILa/\u0003>B!\u0011\"\u001fBZ!\u0011\u0011)J!.\n\t\t]&q\u0013\u0002\u0010)&lWm\u001d;b[B|eMZ:fi\"A!\u0011\u0013BV\u0001\u0004\u0011\u0019\n\u0003\u0005\u0003\"\n-\u0006\u0019\u0001B.\u0011!\u0011)Ka+A\u0002\t%\u0005\u0002\u0003Ba\u0001\u0011\u0005!Aa1\u0002%\u0019,Go\u00195PM\u001a\u001cX\r^:CK\u001a|'/\u001a\u000b\t\u0005\u000f\u0013)M!4\u0003P\"A!\u0011\u0014B`\u0001\u0004\u00119\r\u0005\u0003\u0003\u0016\n%\u0017\u0002\u0002Bf\u0005/\u00131\u0001T8h\u0011!\u0011)Ka0A\u0002\t%\u0005b\u0002BU\u0005\u007f\u0003\ra\u0014\u0005\b\u0005'\u0004A\u0011\u0002Bk\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u0015\t]'Q\u001dBu\u0005[\u0014\t\u0010\u0005\u0003\u0003Z\n}g\u0002\u0002B4\u00057LAA!8\u0003j\u0005\u0001R*\u001a;bI\u0006$\u0018MU3ta>t7/Z\u0005\u0005\u0005C\u0014\u0019OA\u0007U_BL7-T3uC\u0012\fG/\u0019\u0006\u0005\u0005;\u0014I\u0007\u0003\u0005\u0003h\nE\u0007\u0019AA\u001c\u0003\u0015!x\u000e]5d\u0011\u001d\u0011YO!5A\u0002=\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bb\u0002Bx\u0005#\u0004\raT\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\bB\u0003Bz\u0005#\u0004\n\u00111\u0001\u0003v\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\t\t]8\u0011A\u0007\u0003\u0005sTAAa?\u0003~\u0006!Q\u000f^5m\u0015\t\u0011y0\u0001\u0003kCZ\f\u0017\u0002BB\u0002\u0005s\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u00199\u0001\u0001C\u0005\u0007\u0013\t\u0001d\u0019:fCR,wI]8va6+G/\u00193bi\u0006$v\u000e]5d)\t\u00119\u000eC\u0004\u0004\u000e\u0001!Iaa\u0004\u0002;\u001d,Go\u0014:De\u0016\fG/Z$s_V\u0004X*\u001a;bI\u0006$\u0018\rV8qS\u000e$BAa6\u0004\u0012!A11CB\u0006\u0001\u0004\u0019)\"\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYB!1qCB\u000f\u001b\t\u0019IBC\u0002\u0004\u001c)\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0007?\u0019IB\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"911\u0005\u0001\u0005\n\r\u0015\u0012\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b)!\u00199c!\u000b\u00044\rU\u0002C\u0002B\b\u0005+\u00119\u000e\u0003\u0005\u0004,\r\u0005\u0002\u0019AB\u0017\u0003\u0019!x\u000e]5dgB1!qBB\u0018\u0003oIAa!\r\u0003\u0012\t\u00191+\u001a;\t\u0011\rM1\u0011\u0005a\u0001\u0007+A\u0001ba\u000e\u0004\"\u0001\u0007\u0011\u0011X\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016,e\u000e\u001a9pS:$8\u000fC\u0004\u0004<\u0001!\ta!\u0010\u00025!\fg\u000e\u001a7f)>\u0004\u0018nY'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0015\t\u0005M4q\b\u0005\t\u0003w\u001aI\u00041\u0001\u0002~!911\t\u0001\u0005\u0002\r\u0015\u0013\u0001\u00075b]\u0012dWm\u00144gg\u0016$h)\u001a;dQJ+\u0017/^3tiR!\u00111OB$\u0011!\tYh!\u0011A\u0002\u0005u\u0004bBB&\u0001\u0011\u00051QJ\u0001\u001eQ\u0006tG\r\\3He>,\boQ8pe\u0012Lg.\u0019;peJ+\u0017/^3tiR!\u00111OB(\u0011!\tYh!\u0013A\u0002\u0005u\u0004bBB*\u0001\u0011\u00051QK\u0001\u001bQ\u0006tG\r\\3EKN\u001c'/\u001b2f\u000fJ|W\u000f\u001d*fcV,7\u000f\u001e\u000b\u0005\u0003g\u001a9\u0006\u0003\u0005\u0002|\rE\u0003\u0019AA?\u0011\u001d\u0019Y\u0006\u0001C\u0001\u0007;\nq\u0003[1oI2,G*[:u\u000fJ|W\u000f]:SKF,Xm\u001d;\u0015\t\u0005M4q\f\u0005\t\u0003w\u001aI\u00061\u0001\u0002~!911\r\u0001\u0005\u0002\r\u0015\u0014A\u00065b]\u0012dWMS8j]\u001e\u0013x.\u001e9SKF,Xm\u001d;\u0015\t\u0005M4q\r\u0005\t\u0003w\u001a\t\u00071\u0001\u0002~!911\u000e\u0001\u0005\u0002\r5\u0014A\u00065b]\u0012dWmU=oG\u001e\u0013x.\u001e9SKF,Xm\u001d;\u0015\t\u0005M4q\u000e\u0005\t\u0003w\u001aI\u00071\u0001\u0002~!911\u000f\u0001\u0005\u0002\rU\u0014A\u00065b]\u0012dW\rS3beR\u0014W-\u0019;SKF,Xm\u001d;\u0015\t\u0005M4q\u000f\u0005\t\u0003w\u001a\t\b1\u0001\u0002~!911\u0010\u0001\u0005\u0002\ru\u0014a\u00065b]\u0012dW\rT3bm\u0016<%o\\;q%\u0016\fX/Z:u)\u0011\t\u0019ha \t\u0011\u0005m4\u0011\u0010a\u0001\u0003{Bqaa!\u0001\t\u0003\u0019))\u0001\u000eiC:$G.Z*bg2D\u0015M\u001c3tQ\u0006\\WMU3rk\u0016\u001cH\u000f\u0006\u0003\u0002t\r\u001d\u0005\u0002CA>\u0007\u0003\u0003\r!! \t\u000f\r-\u0005\u0001\"\u0001\u0004\u000e\u0006A\u0002.\u00198eY\u0016\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;\u0015\t\u0005M4q\u0012\u0005\t\u0003w\u001aI\t1\u0001\u0002~!911\u0013\u0001\u0005\u0002\rU\u0015!B2m_N,GCAA:\u0011\u001d\u0019I\n\u0001C\u0001\u00077\u000b\u0011\u0004[1oI2,7I]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiR!\u00111OBO\u0011!\tYha&A\u0002\u0005u\u0004bBBQ\u0001\u0011\u000511U\u0001\u001aQ\u0006tG\r\\3EK2,G/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000f\u0006\u0003\u0002t\r\u0015\u0006\u0002CA>\u0007?\u0003\r!! \t\u000f\r%\u0006\u0001\"\u0001\u0004,\u00061\u0012-\u001e;i_JL'0Z\"mkN$XM]!di&|g\u000e\u0006\u0003\u0002t\r5\u0006\u0002CA>\u0007O\u0003\r!! \t\u0013\rE\u0006!%A\u0005\n\rM\u0016!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007kSCA!>\u00048.\u00121\u0011\u0018\t\u0005\u0007w\u001b)-\u0004\u0002\u0004>*!1qXBa\u0003%)hn\u00195fG.,GMC\u0002\u0004D*\t!\"\u00198o_R\fG/[8o\u0013\u0011\u00199m!0\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class KafkaApis
implements Logging {
    private final RequestChannel requestChannel;
    private final ReplicaManager replicaManager;
    private final AdminManager adminManager;
    private final GroupCoordinator coordinator;
    private final KafkaController controller;
    private final ZkUtils zkUtils;
    private final int brokerId;
    private final KafkaConfig config;
    private final MetadataCache metadataCache;
    private final Metrics metrics;
    private final Option<Authorizer> authorizer;
    private final QuotaFactory.QuotaManagers quotas;
    private final String clusterId;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaApis kafkaApis = this;
        synchronized (kafkaApis) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public AdminManager adminManager() {
        return this.adminManager;
    }

    public GroupCoordinator coordinator() {
        return this.coordinator;
    }

    public KafkaController controller() {
        return this.controller;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public void handle(RequestChannel.Request request) {
        block29: {
            try {
                try {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Handling request:%s from connection %s;securityProtocol:%s,principal:%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.requestDesc(true), request.connectionId(), request.securityProtocol(), request.session().principal()})));
                    ApiKeys apiKeys = ApiKeys.forId((int)request.requestId());
                    if (ApiKeys.PRODUCE.equals(apiKeys)) {
                        this.handleProducerRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.FETCH.equals(apiKeys)) {
                        this.handleFetchRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.LIST_OFFSETS.equals(apiKeys)) {
                        this.handleOffsetRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.METADATA.equals(apiKeys)) {
                        this.handleTopicMetadataRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.LEADER_AND_ISR.equals(apiKeys)) {
                        this.handleLeaderAndIsrRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.STOP_REPLICA.equals(apiKeys)) {
                        this.handleStopReplicaRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.UPDATE_METADATA_KEY.equals(apiKeys)) {
                        this.handleUpdateMetadataRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.CONTROLLED_SHUTDOWN_KEY.equals(apiKeys)) {
                        this.handleControlledShutdownRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.OFFSET_COMMIT.equals(apiKeys)) {
                        this.handleOffsetCommitRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.OFFSET_FETCH.equals(apiKeys)) {
                        this.handleOffsetFetchRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.GROUP_COORDINATOR.equals(apiKeys)) {
                        this.handleGroupCoordinatorRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.JOIN_GROUP.equals(apiKeys)) {
                        this.handleJoinGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.HEARTBEAT.equals(apiKeys)) {
                        this.handleHeartbeatRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.LEAVE_GROUP.equals(apiKeys)) {
                        this.handleLeaveGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.SYNC_GROUP.equals(apiKeys)) {
                        this.handleSyncGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.DESCRIBE_GROUPS.equals(apiKeys)) {
                        this.handleDescribeGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.LIST_GROUPS.equals(apiKeys)) {
                        this.handleListGroupsRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.SASL_HANDSHAKE.equals(apiKeys)) {
                        this.handleSaslHandshakeRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                        this.handleApiVersionsRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
                        this.handleCreateTopicsRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
                        this.handleDeleteTopicsRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    throw new KafkaException("Unknown api code " + apiKeys);
                }
                catch (Throwable e) {
                    if (request.requestObj() != null) {
                        request.requestObj().handleError(e, this.requestChannel(), request);
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error when handling request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.requestObj()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        break block29;
                    }
                    AbstractRequestResponse response = request.body().getErrorResponse((int)request.header().apiVersion(), e);
                    ResponseHeader respHeader = new ResponseHeader(request.header().correlationId());
                    if (response == null) {
                        this.requestChannel().closeConnection(request.processor(), request);
                    } else {
                        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), respHeader, response)));
                    }
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error when handling request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.body()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            finally {
                request.apiLocalCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
            }
        }
    }

    public void handleLeaderAndIsrRequest(RequestChannel.Request request) {
        int correlationId = request.header().correlationId();
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)request.body();
        try {
            LeaderAndIsrResponse leaderAndIsrResponse;
            ResponseHeader responseHeader = new ResponseHeader(correlationId);
            if (this.authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
                BecomeLeaderOrFollowerResult result = this.replicaManager().becomeLeaderOrFollower(correlationId, leaderAndIsrRequest, this.metadataCache(), (Function2<Iterable<Partition>, Iterable<Partition>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(updatedLeaders, updatedFollowers) -> {
                    this.onLeadershipChange$1(updatedLeaders, updatedFollowers);
                    return BoxedUnit.UNIT;
                });
                leaderAndIsrResponse = new LeaderAndIsrResponse(result.errorCode(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(result.responseMap().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> KafkaApis.$anonfun$handleLeaderAndIsrRequest$4(BoxesRunTime.unboxToShort((Object)x$1)))).asJava());
            } else {
                scala.collection.immutable.Map result = ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(leaderAndIsrRequest.partitionStates()).asScala()).keys().map((Function1 & Serializable & scala.Serializable)x$2 -> new Tuple2(x$2, (Object)new Short(Errors.CLUSTER_AUTHORIZATION_FAILED.code())), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                leaderAndIsrResponse = new LeaderAndIsrResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result).asJava());
            }
            LeaderAndIsrResponse leaderAndIsrResponse2 = leaderAndIsrResponse;
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)leaderAndIsrResponse2)));
        }
        catch (KafkaStorageException e) {
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disk error during leadership change.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            Runtime.getRuntime().halt(1);
        }
    }

    public void handleStopReplicaRequest(RequestChannel.Request request) {
        StopReplicaResponse stopReplicaResponse;
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (this.authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            Tuple2<scala.collection.mutable.Map<TopicPartition, Object>, Object> tuple2 = this.replicaManager().stopReplicas(stopReplicaRequest);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.mutable.Map result = (scala.collection.mutable.Map)tuple2._1();
            short error = BoxesRunTime.unboxToShort((Object)tuple2._2());
            Tuple2 tuple22 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToShort((short)error));
            Tuple2 tuple23 = tuple22;
            scala.collection.mutable.Map result2 = (scala.collection.mutable.Map)tuple23._1();
            short error2 = BoxesRunTime.unboxToShort((Object)tuple23._2());
            result2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KafkaApis.$anonfun$handleStopReplicaRequest$1(this, stopReplicaRequest, x0$1);
                return BoxedUnit.UNIT;
            });
            stopReplicaResponse = new StopReplicaResponse(error2, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result2).asJava());
        } else {
            scala.collection.immutable.Map result = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(stopReplicaRequest.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> new Tuple2(x$4, (Object)new Short(Errors.CLUSTER_AUTHORIZATION_FAILED.code())), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            stopReplicaResponse = new StopReplicaResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result).asJava());
        }
        StopReplicaResponse response = stopReplicaResponse;
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)response)));
        this.replicaManager().replicaFetcherManager().shutdownIdleFetcherThreads();
    }

    public void handleUpdateMetadataRequest(RequestChannel.Request request) {
        UpdateMetadataResponse updateMetadataResponse;
        int correlationId = request.header().correlationId();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)request.body();
        if (this.authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            this.replicaManager().maybeUpdateMetadataCache(correlationId, updateMetadataRequest, this.metadataCache());
            if (this.adminManager().hasDelayedTopicOperations()) {
                ((IterableLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.partitionStates().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.topic(), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                    KafkaApis.$anonfun$handleUpdateMetadataRequest$2(this, topic);
                    return BoxedUnit.UNIT;
                });
            }
            updateMetadataResponse = new UpdateMetadataResponse(Errors.NONE.code());
        } else {
            updateMetadataResponse = new UpdateMetadataResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code());
        }
        UpdateMetadataResponse updateMetadataResponse2 = updateMetadataResponse;
        ResponseHeader responseHeader = new ResponseHeader(correlationId);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)updateMetadataResponse2)));
    }

    public void handleControlledShutdownRequest(RequestChannel.Request request) {
        ControlledShutdownRequest controlledShutdownRequest = (ControlledShutdownRequest)request.requestObj();
        this.authorizeClusterAction(request);
        scala.collection.Set<TopicAndPartition> partitionsRemaining = this.controller().shutdownBroker(controlledShutdownRequest.brokerId());
        ControlledShutdownResponse controlledShutdownResponse = new ControlledShutdownResponse(controlledShutdownRequest.correlationId(), Errors.NONE.code(), partitionsRemaining);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new RequestOrResponseSend(request.connectionId(), controlledShutdownResponse)));
    }

    public void handleOffsetCommitRequest(RequestChannel.Request request) {
        RequestHeader header = request.header();
        OffsetCommitRequest offsetCommitRequest = (OffsetCommitRequest)request.body();
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, offsetCommitRequest.groupId()))) {
            Short errorCode = new Short(Errors.GROUP_AUTHORIZATION_FAILED.code());
            scala.collection.immutable.Map results = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(offsetCommitRequest.offsetData().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)topicPartition -> new Tuple2(topicPartition, (Object)errorCode), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            ResponseHeader responseHeader = new ResponseHeader(header.correlationId());
            OffsetCommitResponse responseBody = new OffsetCommitResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)results).asJava());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
        } else {
            Tuple2 tuple2 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetCommitRequest.offsetData()).asScala()).toMap(Predef$.MODULE$.$conforms()).partition((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleOffsetCommitRequest$2(this, request, header, x0$2)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map existingAndAuthorizedForDescribeTopics = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map nonExistingOrUnauthorizedForDescribeTopics = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)existingAndAuthorizedForDescribeTopics, (Object)nonExistingOrUnauthorizedForDescribeTopics);
            Tuple2 tuple23 = tuple22;
            scala.collection.immutable.Map existingAndAuthorizedForDescribeTopics2 = (scala.collection.immutable.Map)tuple23._1();
            scala.collection.immutable.Map nonExistingOrUnauthorizedForDescribeTopics2 = (scala.collection.immutable.Map)tuple23._2();
            Tuple2 tuple24 = existingAndAuthorizedForDescribeTopics2.partition((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleOffsetCommitRequest$4(this, request, x0$3)));
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            scala.collection.immutable.Map authorizedTopics = (scala.collection.immutable.Map)tuple24._1();
            scala.collection.immutable.Map unauthorizedForReadTopics = (scala.collection.immutable.Map)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)authorizedTopics, (Object)unauthorizedForReadTopics);
            Tuple2 tuple26 = tuple25;
            scala.collection.immutable.Map authorizedTopics2 = (scala.collection.immutable.Map)tuple26._1();
            scala.collection.immutable.Map unauthorizedForReadTopics2 = (scala.collection.immutable.Map)tuple26._2();
            if (authorizedTopics2.isEmpty()) {
                this.sendResponseCallback$1(scala.collection.Map$.MODULE$.empty(), request, header, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForReadTopics2);
            } else if (header.apiVersion() == 0) {
                scala.collection.immutable.Map responseInfo = (scala.collection.immutable.Map)authorizedTopics2.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = x0$5;
                    if (tuple22 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple22._1();
                        OffsetCommitRequest.PartitionData partitionData = (OffsetCommitRequest.PartitionData)tuple22._2();
                        ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(offsetCommitRequest.groupId(), topicPartition.topic());
                        try {
                            if (partitionData.metadata != null && partitionData.metadata.length() > Predef$.MODULE$.Integer2int(this.config().offsetMetadataMaxSize())) {
                                tuple2 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToShort((short)Errors.OFFSET_METADATA_TOO_LARGE.code()));
                            } else {
                                this.zkUtils().updatePersistentPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicDirs.consumerOffsetDir(), BoxesRunTime.boxToInteger((int)topicPartition.partition())})), ((Object)BoxesRunTime.boxToLong((long)partitionData.offset)).toString(), this.zkUtils().updatePersistentPath$default$3());
                                tuple2 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()));
                            }
                        }
                        catch (Throwable e) {
                            tuple2 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToShort((short)Errors.forException((Throwable)e).code()));
                        }
                    } else {
                        throw new MatchError((Object)tuple22);
                    }
                    Tuple2 tuple23 = tuple2;
                    return tuple23;
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                this.sendResponseCallback$1(responseInfo, request, header, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForReadTopics2);
            } else {
                long offsetRetention = header.apiVersion() <= 1 || offsetCommitRequest.retentionTime() == -1L ? this.coordinator().offsetConfig().offsetsRetentionMs() : offsetCommitRequest.retentionTime();
                long currentTimestamp = SystemTime$.MODULE$.milliseconds();
                long defaultExpireTimestamp = offsetRetention + currentTimestamp;
                scala.collection.immutable.Map partitionData2 = authorizedTopics2.mapValues((Function1 & Serializable & scala.Serializable)partitionData -> {
                    String metadata = partitionData.metadata == null ? OffsetMetadata$.MODULE$.NoMetadata() : partitionData.metadata;
                    return new OffsetAndMetadata(new OffsetMetadata(partitionData.offset, metadata), currentTimestamp, partitionData.timestamp == -1L ? defaultExpireTimestamp : offsetRetention + partitionData.timestamp);
                });
                this.coordinator().handleCommitOffsets(offsetCommitRequest.groupId(), offsetCommitRequest.memberId(), offsetCommitRequest.generationId(), (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)partitionData2, (Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)commitStatus -> {
                    this.sendResponseCallback$1(commitStatus, request, header, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForReadTopics2);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    private boolean authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        return BoxesRunTime.unboxToBoolean((Object)this.authorizer().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.authorize(session, operation, resource))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    public void handleProducerRequest(RequestChannel.Request request) {
        ProduceRequest produceRequest = (ProduceRequest)request.body();
        int numBytesAppended = request.header().sizeOf() + produceRequest.sizeOf();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceRequest.partitionRecords()).asScala()).partition((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleProducerRequest$1(this, request, x0$6)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.mutable.Map existingAndAuthorizedForDescribeTopics = (scala.collection.mutable.Map)tuple2._1();
        scala.collection.mutable.Map nonExistingOrUnauthorizedForDescribeTopics = (scala.collection.mutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingAndAuthorizedForDescribeTopics, (Object)nonExistingOrUnauthorizedForDescribeTopics);
        Tuple2 tuple23 = tuple22;
        scala.collection.mutable.Map existingAndAuthorizedForDescribeTopics2 = (scala.collection.mutable.Map)tuple23._1();
        scala.collection.mutable.Map nonExistingOrUnauthorizedForDescribeTopics2 = (scala.collection.mutable.Map)tuple23._2();
        Tuple2 tuple24 = existingAndAuthorizedForDescribeTopics2.partition((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleProducerRequest$2(this, request, x0$7)));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        scala.collection.mutable.Map authorizedRequestInfo = (scala.collection.mutable.Map)tuple24._1();
        scala.collection.mutable.Map unauthorizedForWriteRequestInfo = (scala.collection.mutable.Map)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedForWriteRequestInfo);
        Tuple2 tuple26 = tuple25;
        scala.collection.mutable.Map authorizedRequestInfo2 = (scala.collection.mutable.Map)tuple26._1();
        scala.collection.mutable.Map unauthorizedForWriteRequestInfo2 = (scala.collection.mutable.Map)tuple26._2();
        if (authorizedRequestInfo2.isEmpty()) {
            this.sendResponseCallback$2((Map)scala.collection.Map$.MODULE$.empty(), request, produceRequest, numBytesAppended, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForWriteRequestInfo2);
        } else {
            String string = request.header().clientId();
            String string2 = AdminUtils$.MODULE$.AdminClientId();
            boolean internalTopicsAllowed = !(string != null ? !string.equals(string2) : string2 != null);
            scala.collection.mutable.Map authorizedMessagesPerPartition = (scala.collection.mutable.Map)authorizedRequestInfo2.map((Function1 & Serializable & scala.Serializable)x0$10 -> {
                Tuple2 tuple2 = x0$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                ByteBuffer buffer = (ByteBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)new ByteBufferMessageSet(buffer));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            this.replicaManager().appendMessages(produceRequest.timeout(), produceRequest.acks(), internalTopicsAllowed, (Map<TopicPartition, MessageSet>)authorizedMessagesPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responseStatus -> {
                this.sendResponseCallback$2(responseStatus, request, produceRequest, numBytesAppended, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForWriteRequestInfo2);
                return BoxedUnit.UNIT;
            });
            produceRequest.clearPartitionRecords();
        }
    }

    public void handleFetchRequest(RequestChannel.Request request) {
        FetchRequest fetchRequest = (FetchRequest)request.requestObj();
        Tuple2 tuple2 = fetchRequest.requestInfo().partition((Function1 & Serializable & scala.Serializable)x0$11 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleFetchRequest$1(this, request, x0$11)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq existingAndAuthorizedForDescribeTopics = (Seq)tuple2._1();
        Seq nonExistingOrUnauthorizedForDescribeTopics = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingAndAuthorizedForDescribeTopics, (Object)nonExistingOrUnauthorizedForDescribeTopics);
        Tuple2 tuple23 = tuple22;
        Seq existingAndAuthorizedForDescribeTopics2 = (Seq)tuple23._1();
        Seq nonExistingOrUnauthorizedForDescribeTopics2 = (Seq)tuple23._2();
        Tuple2 tuple24 = existingAndAuthorizedForDescribeTopics2.partition((Function1 & Serializable & scala.Serializable)x0$12 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleFetchRequest$2(this, request, x0$12)));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Seq authorizedRequestInfo = (Seq)tuple24._1();
        Seq unauthorizedForReadRequestInfo = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedForReadRequestInfo);
        Tuple2 tuple26 = tuple25;
        Seq authorizedRequestInfo2 = (Seq)tuple26._1();
        Seq unauthorizedForReadRequestInfo2 = (Seq)tuple26._2();
        Seq nonExistingOrUnauthorizedForDescribePartitionData = (Seq)nonExistingOrUnauthorizedForDescribeTopics2.map((Function1 & Serializable & scala.Serializable)x0$13 -> {
            Tuple2 tuple2 = x0$13;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)tp, (Object)new FetchResponsePartitionData(Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), -1L, MessageSet$.MODULE$.Empty()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        Seq unauthorizedForReadPartitionData = (Seq)unauthorizedForReadRequestInfo2.map((Function1 & Serializable & scala.Serializable)x0$14 -> {
            Tuple2 tuple2 = x0$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)tp, (Object)new FetchResponsePartitionData(Errors.TOPIC_AUTHORIZATION_FAILED.code(), -1L, MessageSet$.MODULE$.Empty()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        if (authorizedRequestInfo2.isEmpty()) {
            this.sendResponseCallback$3((Seq)Seq$.MODULE$.empty(), request, fetchRequest, nonExistingOrUnauthorizedForDescribePartitionData, unauthorizedForReadPartitionData);
        } else {
            this.replicaManager().fetchMessages(fetchRequest.maxWait(), fetchRequest.replicaId(), fetchRequest.minBytes(), fetchRequest.maxBytes(), fetchRequest.versionId() <= 2, (Seq<Tuple2<TopicAndPartition, PartitionFetchInfo>>)authorizedRequestInfo2, this.replicationQuota(fetchRequest), (Function1<Seq<Tuple2<TopicAndPartition, FetchResponsePartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
                this.sendResponseCallback$3(responsePartitionData, request, fetchRequest, nonExistingOrUnauthorizedForDescribePartitionData, unauthorizedForReadPartitionData);
                return BoxedUnit.UNIT;
            });
        }
    }

    private int sizeOfThrottledPartitions(FetchRequest fetchRequest, Seq<Tuple2<TopicAndPartition, FetchResponsePartitionData>> mergedPartitionData, ReplicationQuotaManager quota) {
        Seq throttledPartitions = (Seq)mergedPartitionData.filter((Function1 & Serializable & scala.Serializable)x0$18 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$sizeOfThrottledPartitions$1(quota, x0$18)));
        return FetchResponse$.MODULE$.responseSize(FetchRequest$.MODULE$.batchByTopic(throttledPartitions), fetchRequest.versionId());
    }

    public ReplicaQuota replicationQuota(FetchRequest fetchRequest) {
        return fetchRequest.isFromFollower() ? this.quotas().leader() : QuotaFactory$UnboundedQuota$.MODULE$;
    }

    public void handleOffsetRequest(RequestChannel.Request request) {
        int correlationId = request.header().correlationId();
        short version = request.header().apiVersion();
        Map<TopicPartition, ListOffsetResponse.PartitionData> mergedResponseMap = version == 0 ? this.handleOffsetRequestV0(request) : this.handleOffsetRequestV1(request);
        ResponseHeader responseHeader = new ResponseHeader(correlationId);
        ListOffsetResponse response = new ListOffsetResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(mergedResponseMap).asJava(), (int)version);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)response)));
    }

    private Map<TopicPartition, ListOffsetResponse.PartitionData> handleOffsetRequestV0(RequestChannel.Request request) {
        int correlationId = request.header().correlationId();
        String clientId = request.header().clientId();
        ListOffsetRequest offsetRequest = (ListOffsetRequest)request.body();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetRequest.offsetData()).asScala()).partition((Function1 & Serializable & scala.Serializable)x0$19 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleOffsetRequestV0$1(this, request, x0$19)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.mutable.Map authorizedRequestInfo = (scala.collection.mutable.Map)tuple2._1();
        scala.collection.mutable.Map unauthorizedRequestInfo = (scala.collection.mutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
        Tuple2 tuple23 = tuple22;
        scala.collection.mutable.Map authorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._1();
        scala.collection.mutable.Map unauthorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._2();
        Map unauthorizedResponseStatus = unauthorizedRequestInfo2.mapValues((Function1 & Serializable & scala.Serializable)x$20 -> new ListOffsetResponse.PartitionData(Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
        scala.collection.mutable.Map responseMap = (scala.collection.mutable.Map)authorizedRequestInfo2.map((Function1 & Serializable & scala.Serializable)x0$20 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$20;
            if (tuple22 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple22._1();
                ListOffsetRequest.PartitionData partitionData = (ListOffsetRequest.PartitionData)tuple22._2();
                try {
                    Seq seq;
                    Replica localReplica = offsetRequest.replicaId() != -2 ? this.replicaManager().getLeaderReplicaIfLocal(topicPartition.topic(), topicPartition.partition()) : this.replicaManager().getReplicaOrException(topicPartition.topic(), topicPartition.partition());
                    Seq allOffsets = this.fetchOffsets(this.replicaManager().logManager(), topicPartition, partitionData.timestamp, partitionData.maxNumOffsets);
                    if (offsetRequest.replicaId() != -1) {
                        seq = allOffsets;
                    } else {
                        long hw = localReplica.highWatermark().messageOffset();
                        if (allOffsets.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$21 -> x$21 > hw)) {
                            long l = hw;
                            seq = (Seq)((SeqLike)allOffsets.dropWhile((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$22 -> x$22 > hw)).$plus$colon((Object)BoxesRunTime.boxToLong((long)l), Seq$.MODULE$.canBuildFrom());
                        } else {
                            seq = allOffsets;
                        }
                    }
                    Seq offsets = seq;
                    tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.NONE.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)offsets.map((Function1 & Serializable & scala.Serializable)x$24 -> KafkaApis.$anonfun$handleOffsetRequestV0$6(BoxesRunTime.unboxToLong((Object)x$24)), Seq$.MODULE$.canBuildFrom())).asJava()));
                }
                catch (Throwable throwable) {
                    Tuple2 tuple23;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof UnknownTopicOrPartitionException ? true : throwable2 instanceof NotLeaderForPartitionException;
                    if (bl) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)correlationId), clientId, topicPartition, throwable2.getMessage()})));
                        tuple23 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)throwable2).code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
                    } else if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while responding to offset request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        tuple23 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)throwable3).code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
                    } else {
                        throw throwable;
                    }
                    tuple2 = tuple23;
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            return tuple24;
        }, Map$.MODULE$.canBuildFrom());
        return responseMap.$plus$plus((GenTraversableOnce)unauthorizedResponseStatus);
    }

    private Map<TopicPartition, ListOffsetResponse.PartitionData> handleOffsetRequestV1(RequestChannel.Request request) {
        int correlationId = request.header().correlationId();
        String clientId = request.header().clientId();
        ListOffsetRequest offsetRequest = (ListOffsetRequest)request.body();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetRequest.partitionTimestamps()).asScala()).partition((Function1 & Serializable & scala.Serializable)x0$21 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleOffsetRequestV1$1(this, request, x0$21)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.mutable.Map authorizedRequestInfo = (scala.collection.mutable.Map)tuple2._1();
        scala.collection.mutable.Map unauthorizedRequestInfo = (scala.collection.mutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
        Tuple2 tuple23 = tuple22;
        scala.collection.mutable.Map authorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._1();
        scala.collection.mutable.Map unauthorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._2();
        Map unauthorizedResponseStatus = unauthorizedRequestInfo2.mapValues((Function1 & Serializable & scala.Serializable)x$26 -> new ListOffsetResponse.PartitionData(Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), -1L, -1L));
        scala.collection.mutable.Map responseMap = (scala.collection.mutable.Map)authorizedRequestInfo2.map((Function1 & Serializable & scala.Serializable)x0$22 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$22;
            if (tuple22 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple22._1();
                Long timestamp = (Long)tuple22._2();
                if (offsetRequest.duplicatePartitions().contains(topicPartition)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OffsetRequest with correlation id ", " from client ", " on partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)correlationId), clientId, topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed because the partition is duplicated in the request."})).s((Seq)Nil$.MODULE$));
                    tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.INVALID_REQUEST.code(), -1L, -1L));
                } else {
                    try {
                        TimestampOffset timestampOffset;
                        Replica localReplica;
                        boolean fromConsumer = offsetRequest.replicaId() == -1;
                        Replica replica = localReplica = offsetRequest.replicaId() != -2 ? this.replicaManager().getLeaderReplicaIfLocal(topicPartition.topic(), topicPartition.partition()) : this.replicaManager().getReplicaOrException(topicPartition.topic(), topicPartition.partition());
                        if (fromConsumer && BoxesRunTime.equalsNumObject((Number)timestamp, (Object)BoxesRunTime.boxToLong((long)-1L))) {
                            timestampOffset = new TimestampOffset(Message$.MODULE$.NoTimestamp(), localReplica.highWatermark().messageOffset());
                        } else {
                            Some some;
                            TimestampOffset timestampOffset2;
                            Option<TimestampOffset> option = this.fetchOffsetForTimestamp(this.replicaManager().logManager(), topicPartition, Predef$.MODULE$.Long2long(timestamp));
                            TimestampOffset timestampOffset3 = option instanceof Some && KafkaApis.allowed$1(timestampOffset2 = (TimestampOffset)(some = (Some)option).value(), fromConsumer, localReplica) ? timestampOffset2 : new TimestampOffset(-1L, -1L);
                            timestampOffset = timestampOffset3;
                        }
                        TimestampOffset found = timestampOffset;
                        tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.NONE.code(), found.timestamp(), found.offset()));
                    }
                    catch (Throwable throwable) {
                        Tuple2 tuple23;
                        Throwable throwable2 = throwable;
                        boolean bl = throwable2 instanceof UnknownTopicOrPartitionException ? true : (throwable2 instanceof NotLeaderForPartitionException ? true : throwable2 instanceof UnsupportedForMessageFormatException);
                        if (bl) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset request with correlation id ", " from client ", " on "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)correlationId), clientId})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, throwable2.getMessage()})));
                            tuple23 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)throwable2).code(), -1L, -1L));
                        } else if (throwable2 != null) {
                            Throwable throwable3 = throwable2;
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while responding to offset request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                            tuple23 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)throwable3).code(), -1L, -1L));
                        } else {
                            throw throwable;
                        }
                        tuple2 = tuple23;
                    }
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            return tuple24;
        }, Map$.MODULE$.canBuildFrom());
        return responseMap.$plus$plus((GenTraversableOnce)unauthorizedResponseStatus);
    }

    public Seq<Object> fetchOffsets(LogManager logManager, TopicPartition topicPartition, long timestamp, int maxNumOffsets) {
        Nil$ nil$;
        Option<Log> option = logManager.getLog(new TopicAndPartition(topicPartition.topic(), topicPartition.partition()));
        if (option instanceof Some) {
            Some some = (Some)option;
            Log log = (Log)some.value();
            nil$ = this.fetchOffsetsBefore(log, timestamp, maxNumOffsets);
        } else if (None$.MODULE$.equals(option)) {
            nil$ = timestamp == -1L || timestamp == -2L ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})) : Nil$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return nil$;
    }

    private Option<TimestampOffset> fetchOffsetForTimestamp(LogManager logManager, TopicPartition topicPartition, long timestamp) {
        Option<Log> option = logManager.getLog(new TopicAndPartition(topicPartition.topic(), topicPartition.partition()));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new UnknownTopicOrPartitionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist on the broker."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Log log = (Log)some.value();
        Option<TimestampOffset> option2 = log.fetchOffsetsByTimestamp(timestamp);
        return option2;
    }

    public Seq<Object> fetchOffsetsBefore(Log log, long timestamp, int maxNumOffsets) {
        Buffer segments = log.logSegments().toBuffer();
        boolean lastSegmentHasSize = ((LogSegment)segments.last()).size() > 0L;
        Tuple2[] offsetTimeArray = lastSegmentHasSize ? new Tuple2[segments.length() + 1] : new Tuple2[segments.length()];
        segments.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            offsetTimeArray$1[i] = new Tuple2.mcJJ.sp(((LogSegment)segments.apply(i)).baseOffset(), ((LogSegment)segments.apply(i)).lastModified());
        });
        if (lastSegmentHasSize) {
            offsetTimeArray[segments.length()] = new Tuple2.mcJJ.sp(log.logEndOffset(), SystemTime$.MODULE$.milliseconds());
        }
        IntRef startIndex = IntRef.create((int)-1);
        long l = timestamp;
        if (-1L == l) {
            startIndex.elem = offsetTimeArray.length - 1;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (-2L == l) {
            startIndex.elem = 0;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean isFound = false;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                StringBuilder stringBuilder = new StringBuilder().append("Offset time array = ");
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])offsetTimeArray)).foreach((Function1 & Serializable & scala.Serializable)o -> new StringOps(Predef$.MODULE$.augmentString("%d, %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)o._1$mcJ$sp()), BoxesRunTime.boxToLong((long)o._2$mcJ$sp())})));
                return stringBuilder.append(BoxedUnit.UNIT).toString();
            });
            startIndex.elem = offsetTimeArray.length - 1;
            while (startIndex.elem >= 0 && !isFound) {
                if (offsetTimeArray[startIndex.elem]._2$mcJ$sp() <= timestamp) {
                    isFound = true;
                    continue;
                }
                --startIndex.elem;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        int retSize = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(maxNumOffsets), startIndex.elem + 1);
        long[] ret = new long[retSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), retSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            ret$1[j] = offsetTimeArray[startIndex$1.elem]._1$mcJ$sp();
            --startIndex$1.elem;
        });
        return (Seq)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(ret)).toSeq().sortBy((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$27 -> -x$27, (Ordering)Ordering.Long$.MODULE$);
    }

    private MetadataResponse.TopicMetadata createTopic(String topic, int numPartitions, int replicationFactor, Properties properties) {
        MetadataResponse.TopicMetadata topicMetadata;
        try {
            AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, numPartitions, replicationFactor, properties, RackAwareMode$Safe$.MODULE$);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Auto creation of topic %s with %d partitions and replication factor %d is successful")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)numPartitions), BoxesRunTime.boxToInteger((int)replicationFactor)})));
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.LEADER_NOT_AVAILABLE, topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
        }
        catch (TopicExistsException e) {
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.LEADER_NOT_AVAILABLE, topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
        }
        catch (Throwable ex) {
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.forException((Throwable)ex), topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
        }
        return topicMetadata;
    }

    private Properties createTopic$default$4() {
        return new Properties();
    }

    private MetadataResponse.TopicMetadata createGroupMetadataTopic() {
        Seq<Broker> aliveBrokers = this.metadataCache().getAliveBrokers();
        int offsetsTopicReplicationFactor = aliveBrokers.nonEmpty() ? Math.min(Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor()), aliveBrokers.length()) : Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor());
        return this.createTopic(Topic$.MODULE$.GroupMetadataTopicName(), Predef$.MODULE$.Integer2int(this.config().offsetsTopicPartitions()), offsetsTopicReplicationFactor, this.coordinator().offsetsTopicConfigs());
    }

    private MetadataResponse.TopicMetadata getOrCreateGroupMetadataTopic(SecurityProtocol securityProtocol) {
        Seq<MetadataResponse.TopicMetadata> topicMetadata = this.metadataCache().getTopicMetadata((scala.collection.Set<String>)((scala.collection.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Topic$.MODULE$.GroupMetadataTopicName()}))), securityProtocol, this.metadataCache().getTopicMetadata$default$3());
        return (MetadataResponse.TopicMetadata)topicMetadata.headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.createGroupMetadataTopic());
    }

    private Seq<MetadataResponse.TopicMetadata> getTopicMetadata(scala.collection.Set<String> topics, SecurityProtocol securityProtocol, boolean errorUnavailableEndpoints) {
        Seq seq;
        Seq topicResponses = this.metadataCache().getTopicMetadata(topics, securityProtocol, errorUnavailableEndpoints);
        if (topics.isEmpty() || topicResponses.size() == topics.size()) {
            seq = topicResponses;
        } else {
            scala.collection.Set nonExistentTopics = (scala.collection.Set)topics.$minus$minus((GenTraversableOnce)((TraversableOnce)topicResponses.map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.topic(), Seq$.MODULE$.canBuildFrom())).toSet());
            scala.collection.Set responsesForNonExistentTopics = (scala.collection.Set)nonExistentTopics.map((Function1 & Serializable & scala.Serializable)topic -> {
                String string = topic;
                String string2 = Topic$.MODULE$.GroupMetadataTopicName();
                return !(string != null ? !string.equals(string2) : string2 != null) ? this.createGroupMetadataTopic() : (Predef$.MODULE$.Boolean2boolean(this.config().autoCreateTopicsEnable()) ? this.createTopic((String)topic, Predef$.MODULE$.Integer2int(this.config().numPartitions()), this.config().defaultReplicationFactor(), this.createTopic$default$4()) : new MetadataResponse.TopicMetadata(Errors.UNKNOWN_TOPIC_OR_PARTITION, topic, false, Collections.emptyList()));
            }, Set$.MODULE$.canBuildFrom());
            seq = (Seq)topicResponses.$plus$plus((GenTraversableOnce)responsesForNonExistentTopics, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public void handleTopicMetadataRequest(RequestChannel.Request request) {
        MetadataRequest metadataRequest = (MetadataRequest)request.body();
        short requestVersion = request.header().apiVersion();
        scala.collection.immutable.Set topics = requestVersion == 0 ? (metadataRequest.topics() == null || metadataRequest.topics().isEmpty() ? this.metadataCache().getAllTopics() : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(metadataRequest.topics()).asScala()).toSet()) : (metadataRequest.isAllTopics() ? this.metadataCache().getAllTopics() : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(metadataRequest.topics()).asScala()).toSet());
        Tuple2 tuple2 = topics.partition((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)this.authorize(request.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topic))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.Set authorizedTopics = (scala.collection.Set)tuple2._1();
        scala.collection.Set unauthorizedForDescribeTopics = (scala.collection.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)authorizedTopics, (Object)unauthorizedForDescribeTopics);
        Tuple2 tuple23 = tuple22;
        scala.collection.Set authorizedTopics2 = (scala.collection.Set)tuple23._1();
        scala.collection.Set unauthorizedForDescribeTopics2 = (scala.collection.Set)tuple23._2();
        scala.collection.Set unauthorizedForCreateTopics = (scala.collection.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (authorizedTopics2.nonEmpty()) {
            scala.collection.Set<String> nonExistingTopics = this.metadataCache().getNonExistingTopics((scala.collection.Set<String>)authorizedTopics2);
            if (Predef$.MODULE$.Boolean2boolean(this.config().autoCreateTopicsEnable()) && nonExistingTopics.nonEmpty() && !this.authorize(request.session(), Create$.MODULE$, Resource$.MODULE$.ClusterResource())) {
                authorizedTopics2 = (scala.collection.Set)authorizedTopics2.$minus$minus(nonExistingTopics);
                unauthorizedForCreateTopics = unauthorizedForCreateTopics.$plus$plus(nonExistingTopics);
            }
        }
        scala.collection.Set unauthorizedForCreateTopicMetadata = (scala.collection.Set)unauthorizedForCreateTopics.map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponse.TopicMetadata(Errors.TOPIC_AUTHORIZATION_FAILED, topic, Topic$.MODULE$.isInternal((String)topic), Collections.emptyList()), Set$.MODULE$.canBuildFrom());
        scala.collection.Set unauthorizedForDescribeTopicMetadata = requestVersion == 0 && (metadataRequest.topics() == null || metadataRequest.topics().isEmpty()) || metadataRequest.isAllTopics() ? Set$.MODULE$.empty() : (scala.collection.Set)unauthorizedForDescribeTopics2.map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponse.TopicMetadata(Errors.UNKNOWN_TOPIC_OR_PARTITION, topic, false, Collections.emptyList()), Set$.MODULE$.canBuildFrom());
        boolean errorUnavailableEndpoints = requestVersion == 0;
        Seq<MetadataResponse.TopicMetadata> topicMetadata = authorizedTopics2.isEmpty() ? (Seq<MetadataResponse.TopicMetadata>)Seq$.MODULE$.empty() : this.getTopicMetadata((scala.collection.Set<String>)authorizedTopics2, request.securityProtocol(), errorUnavailableEndpoints);
        Seq completeTopicMetadata = (Seq)((TraversableLike)topicMetadata.$plus$plus((GenTraversableOnce)unauthorizedForCreateTopicMetadata, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)unauthorizedForDescribeTopicMetadata, Seq$.MODULE$.canBuildFrom());
        Seq<Broker> brokers = this.metadataCache().getAliveBrokers();
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending topic metadata %s and brokers %s for correlation id %d to client %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{completeTopicMetadata.mkString(","), brokers.mkString(","), BoxesRunTime.boxToInteger((int)request.header().correlationId()), request.header().clientId()})));
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        MetadataResponse responseBody = new MetadataResponse((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers.map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.getNode(request.securityProtocol()), Seq$.MODULE$.canBuildFrom())).asJava(), this.clusterId(), BoxesRunTime.unboxToInt((Object)this.metadataCache().getControllerId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(completeTopicMetadata).asJava(), (int)requestVersion);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    public void handleOffsetFetchRequest(RequestChannel.Request request) {
        OffsetFetchResponse offsetFetchResponse;
        RequestHeader header = request.header();
        OffsetFetchRequest offsetFetchRequest = (OffsetFetchRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(header.correlationId());
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, offsetFetchRequest.groupId()))) {
            OffsetFetchResponse.PartitionData unauthorizedGroupResponse = new OffsetFetchResponse.PartitionData(-1L, "", Errors.GROUP_AUTHORIZATION_FAILED.code());
            scala.collection.immutable.Map results = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(offsetFetchRequest.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)topicPartition -> new Tuple2(topicPartition, (Object)unauthorizedGroupResponse), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            offsetFetchResponse = new OffsetFetchResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)results).asJava());
        } else {
            Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(offsetFetchRequest.partitions()).asScala()).partition((Function1 & Serializable & scala.Serializable)topicPartition -> BoxesRunTime.boxToBoolean((boolean)this.authorize(request.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()))));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer authorizedTopicPartitions = (Buffer)tuple2._1();
            Buffer unauthorizedTopicPartitions = (Buffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)authorizedTopicPartitions, (Object)unauthorizedTopicPartitions);
            Tuple2 tuple23 = tuple22;
            Buffer authorizedTopicPartitions2 = (Buffer)tuple23._1();
            Buffer unauthorizedTopicPartitions2 = (Buffer)tuple23._2();
            OffsetFetchResponse.PartitionData unknownTopicPartitionResponse = new OffsetFetchResponse.PartitionData(-1L, "", Errors.UNKNOWN_TOPIC_OR_PARTITION.code());
            scala.collection.immutable.Map unauthorizedStatus = ((TraversableOnce)unauthorizedTopicPartitions2.map((Function1 & Serializable & scala.Serializable)topicPartition -> new Tuple2(topicPartition, (Object)unknownTopicPartitionResponse), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (header.apiVersion() == 0) {
                scala.collection.immutable.Map responseInfo = ((TraversableOnce)authorizedTopicPartitions2.map((Function1 & Serializable & scala.Serializable)topicPartition -> {
                    Tuple2 tuple2;
                    block7: {
                        ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(offsetFetchRequest.groupId(), topicPartition.topic());
                        try {
                            Tuple2 tuple22;
                            if (!this.metadataCache().contains(topicPartition.topic())) {
                                tuple2 = new Tuple2(topicPartition, (Object)unknownTopicPartitionResponse);
                                break block7;
                            }
                            Option payloadOpt = (Option)this.zkUtils().readDataMaybeNull(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicDirs.consumerOffsetDir(), BoxesRunTime.boxToInteger((int)topicPartition.partition())})))._1();
                            Option option = payloadOpt;
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                String payload = (String)some.value();
                                tuple22 = new Tuple2(topicPartition, (Object)new OffsetFetchResponse.PartitionData(new StringOps(Predef$.MODULE$.augmentString(payload)).toLong(), "", Errors.NONE.code()));
                            } else if (None$.MODULE$.equals(option)) {
                                tuple22 = new Tuple2(topicPartition, (Object)unknownTopicPartitionResponse);
                            } else {
                                throw new MatchError((Object)option);
                            }
                            tuple2 = tuple22;
                        }
                        catch (Throwable e) {
                            tuple2 = new Tuple2(topicPartition, (Object)new OffsetFetchResponse.PartitionData(-1L, "", Errors.forException((Throwable)e).code()));
                        }
                    }
                    return tuple2;
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                offsetFetchResponse = new OffsetFetchResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)responseInfo.$plus$plus((GenTraversableOnce)unauthorizedStatus)).asJava());
            } else {
                scala.collection.immutable.Map offsets = this.coordinator().handleFetchOffsets(offsetFetchRequest.groupId(), (Seq<TopicPartition>)authorizedTopicPartitions2).toMap(Predef$.MODULE$.$conforms());
                offsetFetchResponse = new OffsetFetchResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets.$plus$plus((GenTraversableOnce)unauthorizedStatus)).asJava());
            }
        }
        OffsetFetchResponse offsetFetchResponse2 = offsetFetchResponse;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending offset fetch response ", " for correlation id ", " to client ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offsetFetchResponse2, BoxesRunTime.boxToInteger((int)header.correlationId()), header.clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)offsetFetchResponse2)));
    }

    public void handleGroupCoordinatorRequest(RequestChannel.Request request) {
        GroupCoordinatorRequest groupCoordinatorRequest = (GroupCoordinatorRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (!this.authorize(request.session(), Describe$.MODULE$, new Resource(Group$.MODULE$, groupCoordinatorRequest.groupId()))) {
            GroupCoordinatorResponse responseBody = new GroupCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED.code(), Node.noNode());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
        } else {
            GroupCoordinatorResponse groupCoordinatorResponse;
            int partition = this.coordinator().partitionFor(groupCoordinatorRequest.groupId());
            MetadataResponse.TopicMetadata offsetsTopicMetadata = this.getOrCreateGroupMetadataTopic(request.securityProtocol());
            Errors errors = offsetsTopicMetadata.error();
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                groupCoordinatorResponse = new GroupCoordinatorResponse(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code(), Node.noNode());
            } else {
                Some some;
                Node endpoint;
                Option coordinatorEndpoint = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(offsetsTopicMetadata.partitionMetadata()).asScala()).find((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleGroupCoordinatorRequest$1(partition, x$32))).map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.leader());
                Option option = coordinatorEndpoint;
                GroupCoordinatorResponse groupCoordinatorResponse2 = option instanceof Some && !(endpoint = (Node)(some = (Some)option).value()).isEmpty() ? new GroupCoordinatorResponse(Errors.NONE.code(), endpoint) : new GroupCoordinatorResponse(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code(), Node.noNode());
                groupCoordinatorResponse = groupCoordinatorResponse2;
            }
            GroupCoordinatorResponse responseBody = groupCoordinatorResponse;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending consumer metadata %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseBody, BoxesRunTime.boxToInteger((int)request.header().correlationId()), request.header().clientId()})));
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
        }
    }

    public void handleDescribeGroupRequest(RequestChannel.Request request) {
        DescribeGroupsRequest describeRequest = (DescribeGroupsRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        scala.collection.immutable.Map groups = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(describeRequest.groupIds()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$23 -> {
            Tuple2 tuple2;
            String string = x0$23;
            if (!this.authorize(request.session(), Describe$.MODULE$, new Resource(Group$.MODULE$, string))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), (Object)DescribeGroupsResponse.GroupMetadata.forError((Errors)Errors.GROUP_AUTHORIZATION_FAILED));
            } else {
                Tuple2<Errors, GroupSummary> tuple22 = this.coordinator().handleDescribeGroup(string);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                Errors error = (Errors)tuple22._1();
                GroupSummary summary = (GroupSummary)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)error, (Object)summary);
                Tuple2 tuple24 = tuple23;
                Errors error2 = (Errors)tuple24._1();
                GroupSummary summary2 = (GroupSummary)tuple24._2();
                List members = (List)summary2.members().map((Function1 & Serializable & scala.Serializable)member -> {
                    ByteBuffer metadata = ByteBuffer.wrap(member.metadata());
                    ByteBuffer assignment = ByteBuffer.wrap(member.assignment());
                    return new DescribeGroupsResponse.GroupMember(member.memberId(), member.clientId(), member.clientHost(), metadata, assignment);
                }, List$.MODULE$.canBuildFrom());
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), (Object)new DescribeGroupsResponse.GroupMetadata(error2.code(), summary2.state(), summary2.protocolType(), summary2.protocol(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)members).asJava()));
            }
            Tuple2 tuple25 = tuple2;
            return tuple25;
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        DescribeGroupsResponse responseBody = new DescribeGroupsResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)groups).asJava());
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    public void handleListGroupsRequest(RequestChannel.Request request) {
        ListGroupsResponse listGroupsResponse;
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (!this.authorize(request.session(), Describe$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            listGroupsResponse = ListGroupsResponse.fromError((Errors)Errors.CLUSTER_AUTHORIZATION_FAILED);
        } else {
            Tuple2<Errors, List<GroupOverview>> tuple2 = this.coordinator().handleListGroups();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Errors error = (Errors)tuple2._1();
            List groups = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)error, (Object)groups);
            Tuple2 tuple23 = tuple22;
            Errors error2 = (Errors)tuple23._1();
            List groups2 = (List)tuple23._2();
            List allGroups = (List)groups2.map((Function1 & Serializable & scala.Serializable)group -> new ListGroupsResponse.Group(group.groupId(), group.protocolType()), List$.MODULE$.canBuildFrom());
            listGroupsResponse = new ListGroupsResponse(error2.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allGroups).asJava());
        }
        ListGroupsResponse responseBody = listGroupsResponse;
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    public void handleJoinGroupRequest(RequestChannel.Request request) {
        JoinGroupRequest joinGroupRequest = (JoinGroupRequest)request.body();
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, joinGroupRequest.groupId()))) {
            JoinGroupResponse responseBody = new JoinGroupResponse((int)request.header().apiVersion(), Errors.GROUP_AUTHORIZATION_FAILED.code(), -1, "", "", "", JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)scala.collection.Map$.MODULE$.empty()));
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
        } else {
            List protocols = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(joinGroupRequest.groupProtocols()).map((Function1 & Serializable & scala.Serializable)protocol -> new Tuple2((Object)protocol.name(), (Object)Utils.toArray((ByteBuffer)protocol.metadata())), Buffer$.MODULE$.canBuildFrom())).toList();
            this.coordinator().handleJoinGroup(joinGroupRequest.groupId(), joinGroupRequest.memberId(), request.header().clientId(), request.session().clientAddress().toString(), joinGroupRequest.rebalanceTimeout(), joinGroupRequest.sessionTimeout(), joinGroupRequest.protocolType(), (List<Tuple2<String, byte[]>>)protocols, (Function1<JoinGroupResult, BoxedUnit>)(Function1 & Serializable & scala.Serializable)joinResult -> {
                this.sendResponseCallback$4(joinResult, request, responseHeader);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void handleSyncGroupRequest(RequestChannel.Request request) {
        SyncGroupRequest syncGroupRequest = (SyncGroupRequest)request.body();
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, syncGroupRequest.groupId()))) {
            this.sendResponseCallback$5((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Errors.GROUP_AUTHORIZATION_FAILED.code(), request);
        } else {
            this.coordinator().handleSyncGroup(syncGroupRequest.groupId(), syncGroupRequest.generationId(), syncGroupRequest.memberId(), (Map<String, byte[]>)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(syncGroupRequest.groupAssignment()).mapValues((Function1 & Serializable & scala.Serializable)x$36 -> Utils.toArray((ByteBuffer)x$36)), (Function2<byte[], Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(memberState, errorCode) -> {
                this.sendResponseCallback$5(memberState, BoxesRunTime.unboxToShort((Object)errorCode), request);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void handleHeartbeatRequest(RequestChannel.Request request) {
        HeartbeatRequest heartbeatRequest = (HeartbeatRequest)request.body();
        ResponseHeader respHeader = new ResponseHeader(request.header().correlationId());
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, heartbeatRequest.groupId()))) {
            HeartbeatResponse heartbeatResponse = new HeartbeatResponse(Errors.GROUP_AUTHORIZATION_FAILED.code());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), respHeader, (AbstractRequestResponse)heartbeatResponse)));
        } else {
            this.coordinator().handleHeartbeat(heartbeatRequest.groupId(), heartbeatRequest.memberId(), heartbeatRequest.groupGenerationId(), (Function1<Object, BoxedUnit>)(Function1 & Serializable & scala.Serializable)errorCode -> {
                this.sendResponseCallback$6(BoxesRunTime.unboxToShort((Object)errorCode), request, respHeader);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void handleLeaveGroupRequest(RequestChannel.Request request) {
        LeaveGroupRequest leaveGroupRequest = (LeaveGroupRequest)request.body();
        ResponseHeader respHeader = new ResponseHeader(request.header().correlationId());
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, leaveGroupRequest.groupId()))) {
            LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(Errors.GROUP_AUTHORIZATION_FAILED.code());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), respHeader, (AbstractRequestResponse)leaveGroupResponse)));
        } else {
            this.coordinator().handleLeaveGroup(leaveGroupRequest.groupId(), leaveGroupRequest.memberId(), (Function1<Object, BoxedUnit>)(Function1 & Serializable & scala.Serializable)errorCode -> {
                this.sendResponseCallback$7(BoxesRunTime.unboxToShort((Object)errorCode), request, respHeader);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void handleSaslHandshakeRequest(RequestChannel.Request request) {
        ResponseHeader respHeader = new ResponseHeader(request.header().correlationId());
        SaslHandshakeResponse response = new SaslHandshakeResponse(Errors.ILLEGAL_SASL_STATE.code(), this.config().saslEnabledMechanisms());
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), respHeader, (AbstractRequestResponse)response)));
    }

    public void handleApiVersionsRequest(RequestChannel.Request request) {
        ResponseHeader responseHeader = new ResponseHeader(request.header().correlationId());
        ApiVersionsResponse responseBody = Protocol.apiVersionSupported((short)ApiKeys.API_VERSIONS.id, (short)request.header().apiVersion()) ? ApiVersionsResponse.apiVersionsResponse() : ApiVersionsResponse.fromError((Errors)Errors.UNSUPPORTED_VERSION);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new ResponseSend(request.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    public void close() {
        this.quotas().shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    public void handleCreateTopicsRequest(RequestChannel.Request request) {
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)request.body();
        if (!this.controller().isActive()) {
            scala.collection.mutable.Map results2 = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(createTopicsRequest.topics()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$25 -> {
                Tuple2 tuple2 = x0$25;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String topic = (String)tuple2._1();
                Tuple2 tuple22 = new Tuple2((Object)topic, (Object)Errors.NOT_CONTROLLER);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            this.sendResponseCallback$8((Map)results2, request);
        } else if (!this.authorize(request.session(), Create$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            scala.collection.mutable.Map results3 = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(createTopicsRequest.topics()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$26 -> {
                Tuple2 tuple2 = x0$26;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String topic = (String)tuple2._1();
                Tuple2 tuple22 = new Tuple2((Object)topic, (Object)Errors.CLUSTER_AUTHORIZATION_FAILED);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            this.sendResponseCallback$8((Map)results3, request);
        } else {
            Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(createTopicsRequest.topics()).asScala()).partition((Function1 & Serializable & scala.Serializable)x0$27 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleCreateTopicsRequest$4(createTopicsRequest, x0$27)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.mutable.Map validTopics = (scala.collection.mutable.Map)tuple2._1();
            scala.collection.mutable.Map duplicateTopics = (scala.collection.mutable.Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)validTopics, (Object)duplicateTopics);
            Tuple2 tuple23 = tuple22;
            scala.collection.mutable.Map validTopics2 = (scala.collection.mutable.Map)tuple23._1();
            scala.collection.mutable.Map duplicateTopics2 = (scala.collection.mutable.Map)tuple23._2();
            this.adminManager().createTopics(Predef$.MODULE$.Integer2int(createTopicsRequest.timeout()), (Map<String, CreateTopicsRequest.TopicDetails>)validTopics2, (Function1<Map<String, Errors>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)results -> {
                this.sendResponseWithDuplicatesCallback$1(results, request, duplicateTopics2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void handleDeleteTopicsRequest(RequestChannel.Request request) {
        DeleteTopicsRequest deleteTopicRequest = (DeleteTopicsRequest)request.body();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(deleteTopicRequest.topics()).asScala()).partition((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleDeleteTopicsRequest$1(this, request, topic)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set existingAndAuthorizedForDescribeTopics = (Set)tuple2._1();
        Set nonExistingOrUnauthorizedForDescribeTopics = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingAndAuthorizedForDescribeTopics, (Object)nonExistingOrUnauthorizedForDescribeTopics);
        Tuple2 tuple23 = tuple22;
        Set existingAndAuthorizedForDescribeTopics2 = (Set)tuple23._1();
        Set nonExistingOrUnauthorizedForDescribeTopics2 = (Set)tuple23._2();
        Tuple2 tuple24 = existingAndAuthorizedForDescribeTopics2.partition((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)this.authorize(request.session(), Delete$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topic))));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Set authorizedTopics = (Set)tuple24._1();
        Set unauthorizedForDeleteTopics = (Set)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)authorizedTopics, (Object)unauthorizedForDeleteTopics);
        Tuple2 tuple26 = tuple25;
        Set authorizedTopics2 = (Set)tuple26._1();
        Set unauthorizedForDeleteTopics2 = (Set)tuple26._2();
        if (!this.controller().isActive()) {
            scala.collection.immutable.Map results2 = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(deleteTopicRequest.topics()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$28 -> {
                String string = x0$28;
                Tuple2 tuple2 = new Tuple2((Object)string, (Object)Errors.NOT_CONTROLLER);
                return tuple2;
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.sendResponseCallback$9((Map)results2, request, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForDeleteTopics2);
        } else if (authorizedTopics2.isEmpty()) {
            this.sendResponseCallback$9((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$), request, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForDeleteTopics2);
        } else {
            this.adminManager().deleteTopics(Predef$.MODULE$.Integer2int(deleteTopicRequest.timeout()), (scala.collection.Set<String>)authorizedTopics2, (Function1<Map<String, Errors>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)results -> {
                this.sendResponseCallback$9(results, request, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForDeleteTopics2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void authorizeClusterAction(RequestChannel.Request request) {
        if (!this.authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            throw new ClusterAuthorizationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " is not authorized."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request})));
        }
    }

    public static final /* synthetic */ void $anonfun$handleLeaderAndIsrRequest$1(KafkaApis $this, Partition partition) {
        block0: {
            String string = partition.topic();
            String string2 = Topic$.MODULE$.GroupMetadataTopicName();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            $this.coordinator().handleGroupImmigration(partition.partitionId());
        }
    }

    public static final /* synthetic */ void $anonfun$handleLeaderAndIsrRequest$2(KafkaApis $this, Partition partition) {
        block0: {
            String string = partition.topic();
            String string2 = Topic$.MODULE$.GroupMetadataTopicName();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            $this.coordinator().handleGroupEmigration(partition.partitionId());
        }
    }

    private final void onLeadershipChange$1(Iterable updatedLeaders, Iterable updatedFollowers) {
        updatedLeaders.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            KafkaApis.$anonfun$handleLeaderAndIsrRequest$1(this, partition);
            return BoxedUnit.UNIT;
        });
        updatedFollowers.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            KafkaApis.$anonfun$handleLeaderAndIsrRequest$2(this, partition);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Short $anonfun$handleLeaderAndIsrRequest$4(short x$1) {
        return new Short(x$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$handleStopReplicaRequest$1(KafkaApis $this, StopReplicaRequest stopReplicaRequest$1, Tuple2 x0$1) {
        block3: {
            block2: {
                var4_3 = x0$1;
                if (var4_3 == null) break block2;
                topicPartition = (TopicPartition)var4_3._1();
                errorCode = BoxesRunTime.unboxToShort((Object)var4_3._2());
                if (errorCode != Errors.NONE.code() || !stopReplicaRequest$1.deletePartitions()) ** GOTO lbl-1000
                v0 = topicPartition.topic();
                var7_6 = Topic$.MODULE$.GroupMetadataTopicName();
                if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                    $this.coordinator().handleGroupEmigration(topicPartition.partition());
                    v1 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = BoxedUnit.UNIT;
                }
                break block3;
            }
            throw new MatchError((Object)var4_3);
        }
        var3_7 = v1;
    }

    public static final /* synthetic */ void $anonfun$handleUpdateMetadataRequest$2(KafkaApis $this, String topic) {
        $this.adminManager().tryCompleteDelayedTopicOperations(topic);
    }

    public static final /* synthetic */ boolean $anonfun$handleOffsetCommitRequest$2(KafkaApis $this, RequestChannel.Request request$5, RequestHeader header$1, Tuple2 x0$2) {
        boolean exists;
        boolean authorizedForDescribe;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            authorizedForDescribe = $this.authorize(request$5.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
            exists = $this.metadataCache().contains(topicPartition.topic());
            if (!authorizedForDescribe && exists) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset commit request with correlation id ", " from client ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)header$1.correlationId()), header$1.clientId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on partition ", " failing due to user not having DESCRIBE authorization, but returning UNKNOWN_TOPIC_OR_PARTITION"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = authorizedForDescribe && exists;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleOffsetCommitRequest$4(KafkaApis $this, RequestChannel.Request request$5, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$5.session(), Read$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
        return bl;
    }

    public static final /* synthetic */ Short $anonfun$handleOffsetCommitRequest$5(short x$8) {
        return new Short(x$8);
    }

    public static final /* synthetic */ void $anonfun$handleOffsetCommitRequest$8(KafkaApis $this, RequestHeader header$1, Tuple2 x0$4) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            Short errorCode = (Short)tuple2._2();
            if (!BoxesRunTime.equalsNumObject((Number)errorCode, (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()))) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset commit request with correlation id ", " from client ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)header$1.correlationId()), header$1.clientId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on partition ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, Errors.forCode((short)Predef$.MODULE$.Short2short(errorCode)).exceptionName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final void sendResponseCallback$1(scala.collection.immutable.Map commitStatus, RequestChannel.Request request$5, RequestHeader header$1, scala.collection.immutable.Map nonExistingOrUnauthorizedForDescribeTopics$1, scala.collection.immutable.Map unauthorizedForReadTopics$1) {
        scala.collection.immutable.Map combinedCommitStatus = commitStatus.mapValues((Function1 & Serializable & scala.Serializable)x$8 -> KafkaApis.$anonfun$handleOffsetCommitRequest$5(BoxesRunTime.unboxToShort((Object)x$8))).$plus$plus((GenTraversableOnce)unauthorizedForReadTopics$1.mapValues((Function1 & Serializable & scala.Serializable)x$9 -> new Short(Errors.TOPIC_AUTHORIZATION_FAILED.code()))).$plus$plus((GenTraversableOnce)nonExistingOrUnauthorizedForDescribeTopics$1.mapValues((Function1 & Serializable & scala.Serializable)x$10 -> new Short(Errors.UNKNOWN_TOPIC_OR_PARTITION.code())));
        if (this.isDebugEnabled()) {
            combinedCommitStatus.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                KafkaApis.$anonfun$handleOffsetCommitRequest$8(this, header$1, x0$4);
                return BoxedUnit.UNIT;
            });
        }
        ResponseHeader responseHeader = new ResponseHeader(header$1.correlationId());
        OffsetCommitResponse responseBody = new OffsetCommitResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)combinedCommitStatus).asJava());
        this.requestChannel().sendResponse(new RequestChannel.Response(request$5, (Send)new ResponseSend(request$5.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    public static final /* synthetic */ boolean $anonfun$handleProducerRequest$1(KafkaApis $this, RequestChannel.Request request$2, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$2.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic())) && $this.metadataCache().contains(topicPartition.topic());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleProducerRequest$2(KafkaApis $this, RequestChannel.Request request$2, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$2.session(), Write$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$handleProducerRequest$5(KafkaApis $this, RequestChannel.Request request$2, BooleanRef errorInResponse$1, Tuple2 x0$8) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$8;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            ProduceResponse.PartitionResponse status = (ProduceResponse.PartitionResponse)tuple2._2();
            if (status.errorCode != Errors.NONE.code()) {
                errorInResponse$1.elem = true;
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Produce request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)request$2.header().correlationId()), request$2.header().clientId(), topicPartition, Errors.forCode((short)status$1.errorCode).exceptionName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final void produceResponseCallback$1(int delayTimeMs, RequestChannel.Request request$2, ProduceRequest produceRequest$1, Map mergedResponseStatus$1, BooleanRef errorInResponse$1) {
        if (produceRequest$1.acks() == 0) {
            if (errorInResponse$1.elem) {
                String exceptionsSummary = ((TraversableOnce)mergedResponseStatus$1.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
                    Tuple2 tuple2 = x0$9;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    ProduceResponse.PartitionResponse status = (ProduceResponse.PartitionResponse)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.forCode((short)status.errorCode).exceptionName());
                    return tuple22;
                }, scala.collection.Map$.MODULE$.canBuildFrom())).mkString(", ");
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing connection due to error during produce request with correlation id ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)request$2.header().correlationId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from client id ", " with ack=0\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request$2.header().clientId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic and partition to exceptions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exceptionsSummary})));
                this.requestChannel().closeConnection(request$2.processor(), request$2);
            } else {
                this.requestChannel().noOperation(request$2.processor(), request$2);
            }
        } else {
            ProduceResponse produceResponse;
            ResponseHeader respHeader = new ResponseHeader(request$2.header().correlationId());
            short s = request$2.header().apiVersion();
            switch (s) {
                case 0: {
                    produceResponse = new ProduceResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(mergedResponseStatus$1).asJava());
                    break;
                }
                case 1: 
                case 2: {
                    produceResponse = new ProduceResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(mergedResponseStatus$1).asJava(), delayTimeMs, (int)s);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Version `", "` of ProduceRequest is not handled. Code must be updated."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)s)})));
                }
            }
            ProduceResponse respBody = produceResponse;
            this.requestChannel().sendResponse(new RequestChannel.Response(request$2, (Send)new ResponseSend(request$2.connectionId(), respHeader, (AbstractRequestResponse)respBody)));
        }
    }

    private final void sendResponseCallback$2(Map responseStatus, RequestChannel.Request request$2, ProduceRequest produceRequest$1, int numBytesAppended$1, scala.collection.mutable.Map nonExistingOrUnauthorizedForDescribeTopics$2, scala.collection.mutable.Map unauthorizedForWriteRequestInfo$1) {
        Map mergedResponseStatus = responseStatus.$plus$plus((GenTraversableOnce)unauthorizedForWriteRequestInfo$1.mapValues((Function1 & Serializable & scala.Serializable)x$14 -> new ProduceResponse.PartitionResponse(Errors.TOPIC_AUTHORIZATION_FAILED.code(), -1L, Message$.MODULE$.NoTimestamp()))).$plus$plus((GenTraversableOnce)nonExistingOrUnauthorizedForDescribeTopics$2.mapValues((Function1 & Serializable & scala.Serializable)x$15 -> new ProduceResponse.PartitionResponse(Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), -1L, Message$.MODULE$.NoTimestamp())));
        BooleanRef errorInResponse = BooleanRef.create((boolean)false);
        mergedResponseStatus.foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
            KafkaApis.$anonfun$handleProducerRequest$5(this, request$2, errorInResponse, x0$8);
            return BoxedUnit.UNIT;
        });
        request$2.apiRemoteCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
        this.quotas().produce().recordAndMaybeThrottle(request$2.session().sanitizedUser(), request$2.header().clientId(), numBytesAppended$1, (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.produceResponseCallback$1(delayTimeMs, request$2, produceRequest$1, mergedResponseStatus, errorInResponse));
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchRequest$1(KafkaApis $this, RequestChannel.Request request$3, Tuple2 x0$11) {
        Tuple2 tuple2 = x0$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
        boolean bl = $this.authorize(request$3.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicAndPartition.topic())) && $this.metadataCache().contains(topicAndPartition.topic());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchRequest$2(KafkaApis $this, RequestChannel.Request request$3, Tuple2 x0$12) {
        Tuple2 tuple2 = x0$12;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
        boolean bl = $this.authorize(request$3.session(), Read$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicAndPartition.topic()));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchRequest$6(byte x$18) {
        return x$18 > Message$.MODULE$.MagicValue_V0();
    }

    public static final /* synthetic */ void $anonfun$handleFetchRequest$8(KafkaApis $this, FetchRequest fetchRequest$1, Tuple2 x0$16) {
        FetchResponsePartitionData data;
        TopicAndPartition topicAndPartition;
        Tuple2 tuple2 = x0$16;
        if (tuple2 != null) {
            topicAndPartition = (TopicAndPartition)tuple2._1();
            data = (FetchResponsePartitionData)tuple2._2();
            if (data.error() != Errors.NONE.code()) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetch request with correlation id ", " from client ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fetchRequest$1.correlationId()), fetchRequest$1.clientId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on partition ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, Errors.forCode((short)data.error()).exceptionName()})));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BrokerTopicStats$.MODULE$.getBrokerTopicStats(topicAndPartition.topic()).bytesOutRate().mark((long)data.messages().sizeInBytes());
        BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesOutRate().mark((long)data.messages().sizeInBytes());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$handleFetchRequest$11(Tuple2 x0$17) {
        Tuple2 tuple2 = x0$17;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FetchResponsePartitionData v = (FetchResponsePartitionData)tuple2._2();
        int n = v.messages().sizeInBytes();
        return n;
    }

    private final void fetchResponseCallback$1(int delayTimeMs, RequestChannel.Request request$3, FetchRequest fetchRequest$1, Seq convertedPartitionData$1, Seq mergedPartitionData$1) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending fetch response to client ", " of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fetchRequest$1.clientId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)convertedPartitionData$1.map((Function1 & Serializable & scala.Serializable)x0$17 -> BoxesRunTime.boxToInteger((int)KafkaApis.$anonfun$handleFetchRequest$11(x0$17)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)})));
        FetchResponse response = new FetchResponse(fetchRequest$1.correlationId(), (Seq<Tuple2<TopicAndPartition, FetchResponsePartitionData>>)mergedPartitionData$1.toSeq(), fetchRequest$1.versionId(), delayTimeMs);
        this.requestChannel().sendResponse(new RequestChannel.Response(request$3, new FetchResponseSend(request$3.connectionId(), response)));
    }

    private final void sendResponseCallback$3(Seq responsePartitionData, RequestChannel.Request request$3, FetchRequest fetchRequest$1, Seq nonExistingOrUnauthorizedForDescribePartitionData$1, Seq unauthorizedForReadPartitionData$1) {
        Seq convertedPartitionData = fetchRequest$1.versionId() <= 1 ? (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$15 -> {
            FetchResponsePartitionData fetchResponsePartitionData;
            TopicAndPartition tp;
            Tuple2 tuple2 = x0$15;
            if (tuple2 != null) {
                tp = (TopicAndPartition)tuple2._1();
                FetchResponsePartitionData data = (FetchResponsePartitionData)tuple2._2();
                if (this.replicaManager().getMessageFormatVersion(tp).exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleFetchRequest$6(BoxesRunTime.unboxToByte((Object)x$18)))) && !data.messages().isMagicValueInAllWrapperMessages(Message$.MODULE$.MagicValue_V0())) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Down converting message to V0 for fetch request from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fetchRequest$1.clientId()})));
                    fetchResponsePartitionData = new FetchResponsePartitionData(data.error(), data.hw(), ((FileMessageSet)data.messages()).toMessageFormat(Message$.MODULE$.MagicValue_V0()));
                } else {
                    fetchResponsePartitionData = data;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            FetchResponsePartitionData convertedData = fetchResponsePartitionData;
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)convertedData);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom()) : responsePartitionData;
        Seq mergedPartitionData = (Seq)((TraversableLike)convertedPartitionData.$plus$plus((GenTraversableOnce)unauthorizedForReadPartitionData$1, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)nonExistingOrUnauthorizedForDescribePartitionData$1, Seq$.MODULE$.canBuildFrom());
        mergedPartitionData.foreach((Function1 & Serializable & scala.Serializable)x0$16 -> {
            KafkaApis.$anonfun$handleFetchRequest$8(this, fetchRequest$1, x0$16);
            return BoxedUnit.UNIT;
        });
        request$3.apiRemoteCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
        if (fetchRequest$1.isFromFollower()) {
            int responseSize = this.sizeOfThrottledPartitions(fetchRequest$1, (Seq<Tuple2<TopicAndPartition, FetchResponsePartitionData>>)mergedPartitionData, this.quotas().leader());
            this.quotas().leader().record(responseSize);
            this.fetchResponseCallback$1(0, request$3, fetchRequest$1, convertedPartitionData, mergedPartitionData);
        } else {
            int responseSize = FetchResponse$.MODULE$.responseSize(FetchResponse$.MODULE$.batchByTopic((Seq<Tuple2<TopicAndPartition, FetchResponsePartitionData>>)mergedPartitionData), fetchRequest$1.versionId());
            this.quotas().fetch().recordAndMaybeThrottle(request$3.session().sanitizedUser(), fetchRequest$1.clientId(), responseSize, (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.fetchResponseCallback$1(delayTimeMs, request$3, fetchRequest$1, convertedPartitionData, mergedPartitionData));
        }
    }

    public static final /* synthetic */ boolean $anonfun$sizeOfThrottledPartitions$1(ReplicationQuotaManager quota$1, Tuple2 x0$18) {
        Tuple2 tuple2 = x0$18;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition partition = (TopicAndPartition)tuple2._1();
        boolean bl = quota$1.isThrottled(partition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleOffsetRequestV0$1(KafkaApis $this, RequestChannel.Request request$15, Tuple2 x0$19) {
        Tuple2 tuple2 = x0$19;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$15.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
        return bl;
    }

    public static final /* synthetic */ Long $anonfun$handleOffsetRequestV0$6(long x$24) {
        return new Long(x$24);
    }

    public static final /* synthetic */ boolean $anonfun$handleOffsetRequestV1$1(KafkaApis $this, RequestChannel.Request request$16, Tuple2 x0$21) {
        Tuple2 tuple2 = x0$21;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$16.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
        return bl;
    }

    private static final boolean allowed$1(TimestampOffset timestampOffset, boolean fromConsumer$1, Replica localReplica$1) {
        return !fromConsumer$1 || timestampOffset.offset() <= localReplica$1.highWatermark().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$handleGroupCoordinatorRequest$1(int partition$1, MetadataResponse.PartitionMetadata x$32) {
        return x$32.partition() == partition$1;
    }

    private final void sendResponseCallback$4(JoinGroupResult joinResult, RequestChannel.Request request$8, ResponseHeader responseHeader$1) {
        Map members = (Map)joinResult.members().map((Function1 & Serializable & scala.Serializable)x0$24 -> {
            Tuple2 tuple2 = x0$24;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String memberId = (String)tuple2._1();
            byte[] metadataArray = (byte[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)memberId, (Object)ByteBuffer.wrap(metadataArray));
            return tuple22;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        JoinGroupResponse responseBody = new JoinGroupResponse((int)request$8.header().apiVersion(), joinResult.errorCode(), joinResult.generationId(), joinResult.subProtocol(), joinResult.memberId(), joinResult.leaderId(), JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(members));
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending join group response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseBody, BoxesRunTime.boxToInteger((int)request$8.header().correlationId()), request$8.header().clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request$8, (Send)new ResponseSend(request$8.connectionId(), responseHeader$1, (AbstractRequestResponse)responseBody)));
    }

    private final void sendResponseCallback$5(byte[] memberState, short errorCode, RequestChannel.Request request$11) {
        SyncGroupResponse responseBody = new SyncGroupResponse(errorCode, ByteBuffer.wrap(memberState));
        ResponseHeader responseHeader = new ResponseHeader(request$11.header().correlationId());
        this.requestChannel().sendResponse(new RequestChannel.Response(request$11, (Send)new ResponseSend(request$11.connectionId(), responseHeader, (AbstractRequestResponse)responseBody)));
    }

    private final void sendResponseCallback$6(short errorCode, RequestChannel.Request request$9, ResponseHeader respHeader$1) {
        HeartbeatResponse response = new HeartbeatResponse(errorCode);
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending heartbeat response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response, BoxesRunTime.boxToInteger((int)request$9.header().correlationId()), request$9.header().clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request$9, (Send)new ResponseSend(request$9.connectionId(), respHeader$1, (AbstractRequestResponse)response)));
    }

    private final void sendResponseCallback$7(short errorCode, RequestChannel.Request request$10, ResponseHeader respHeader$2) {
        LeaveGroupResponse response = new LeaveGroupResponse(errorCode);
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending leave group response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response, BoxesRunTime.boxToInteger((int)request$10.header().correlationId()), request$10.header().clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request$10, (Send)new ResponseSend(request$10.connectionId(), respHeader$2, (AbstractRequestResponse)response)));
    }

    private final void sendResponseCallback$8(Map results, RequestChannel.Request request$13) {
        ResponseHeader respHeader = new ResponseHeader(request$13.header().correlationId());
        CreateTopicsResponse responseBody = new CreateTopicsResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(results).asJava());
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending create topics response ", " for correlation id ", " to client ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseBody, BoxesRunTime.boxToInteger((int)request$13.header().correlationId()), request$13.header().clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request$13, (Send)new ResponseSend(request$13.connectionId(), respHeader, (AbstractRequestResponse)responseBody)));
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$4(CreateTopicsRequest createTopicsRequest$1, Tuple2 x0$27) {
        Tuple2 tuple2 = x0$27;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String topic = (String)tuple2._1();
        boolean bl = !createTopicsRequest$1.duplicateTopics().contains(topic);
        return bl;
    }

    private final void sendResponseWithDuplicatesCallback$1(Map results, RequestChannel.Request request$13, scala.collection.mutable.Map duplicateTopics$1) {
        if (duplicateTopics$1.nonEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Create topics request from client ", " contains multiple entries for the following topics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request$13.header().clientId(), duplicateTopics$1.keySet().mkString(",")})));
        }
        Map completeResults = results.$plus$plus((GenTraversableOnce)((TraversableOnce)duplicateTopics$1.keySet().map((Function1 & Serializable & scala.Serializable)x$38 -> new Tuple2(x$38, (Object)Errors.INVALID_REQUEST), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        this.sendResponseCallback$8(completeResults, request$13);
    }

    public static final /* synthetic */ boolean $anonfun$handleDeleteTopicsRequest$1(KafkaApis $this, RequestChannel.Request request$14, String topic) {
        return $this.authorize(request$14.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topic)) && $this.metadataCache().contains(topic);
    }

    private final void sendResponseCallback$9(Map results, RequestChannel.Request request$14, Set nonExistingOrUnauthorizedForDescribeTopics$3, Set unauthorizedForDeleteTopics$1) {
        scala.collection.immutable.Map completeResults = ((TraversableOnce)nonExistingOrUnauthorizedForDescribeTopics$3.map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)unauthorizedForDeleteTopics$1.map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)Errors.TOPIC_AUTHORIZATION_FAILED), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)results);
        ResponseHeader respHeader = new ResponseHeader(request$14.header().correlationId());
        DeleteTopicsResponse responseBody = new DeleteTopicsResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)completeResults).asJava());
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending delete topics response ", " for correlation id ", " to client ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseBody, BoxesRunTime.boxToInteger((int)request$14.header().correlationId()), request$14.header().clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request$14, (Send)new ResponseSend(request$14.connectionId(), respHeader, (AbstractRequestResponse)responseBody)));
    }

    public KafkaApis(RequestChannel requestChannel, ReplicaManager replicaManager, AdminManager adminManager, GroupCoordinator coordinator, KafkaController controller, ZkUtils zkUtils, int brokerId, KafkaConfig config, MetadataCache metadataCache, Metrics metrics, Option<Authorizer> authorizer, QuotaFactory.QuotaManagers quotas, String clusterId) {
        this.requestChannel = requestChannel;
        this.replicaManager = replicaManager;
        this.adminManager = adminManager;
        this.coordinator = coordinator;
        this.controller = controller;
        this.zkUtils = zkUtils;
        this.brokerId = brokerId;
        this.config = config;
        this.metadataCache = metadataCache;
        this.metrics = metrics;
        this.authorizer = authorizer;
        this.quotas = quotas;
        this.clusterId = clusterId;
        Logging.$init$(this);
        this.logIdent_$eq(new StringOps(Predef$.MODULE$.augmentString("[KafkaApi-%d] ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
    }
}

