/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.RequestChannel;
import kafka.server.KafkaApis;
import kafka.server.KafkaRequestHandler;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u000f\t92*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7feB{w\u000e\u001c\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\b\u0015!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u00059Q.\u001a;sS\u000e\u001c\u0018BA\r\u0017\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\u0005\t7\u0001\u0011)\u0019!C\u00019\u0005A!M]8lKJLE-F\u0001\u001e!\tIa$\u0003\u0002 \u0015\t\u0019\u0011J\u001c;\t\u0011\u0005\u0002!\u0011!Q\u0001\nu\t\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\naB]3rk\u0016\u001cHo\u00115b]:,G.F\u0001&!\t1\u0013&D\u0001(\u0015\tAC!A\u0004oKR<xN]6\n\u0005):#A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0005\tY\u0001\u0011\t\u0011)A\u0005K\u0005y!/Z9vKN$8\t[1o]\u0016d\u0007\u0005\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00010\u0003\u0011\t\u0007/[:\u0016\u0003A\u0002\"!\r\u001a\u000e\u0003\tI!a\r\u0002\u0003\u0013-\u000bgm[1Ba&\u001c\b\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u000b\u0005\u0004\u0018n\u001d\u0011\t\u0011]\u0002!\u0011!Q\u0001\nu\t!B\\;n)\"\u0014X-\u00193t\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u0019a\u0014N\\5u}Q)1\bP\u001f?\u007fA\u0011\u0011\u0007\u0001\u0005\u00067a\u0002\r!\b\u0005\u0006Ga\u0002\r!\n\u0005\u0006]a\u0002\r\u0001\r\u0005\u0006oa\u0002\r!\b\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0003I\twm\u001a:fO\u0006$X-\u00133mK6+G/\u001a:\u0016\u0003\r\u0003\"\u0001\u0012'\u000e\u0003\u0015S!AR$\u0002\t\r|'/\u001a\u0006\u0003/!S!!\u0013&\u0002\re\fW.\\3s\u0015\u0005Y\u0015aA2p[&\u0011Q*\u0012\u0002\u0006\u001b\u0016$XM\u001d\u0005\u0007\u001f\u0002\u0001\u000b\u0011B\"\u0002'\u0005<wM]3hCR,\u0017\n\u001a7f\u001b\u0016$XM\u001d\u0011\t\u000fE\u0003!\u0019!C\u0001%\u00069A\u000f\u001b:fC\u0012\u001cX#A*\u0011\u0007%!f+\u0003\u0002V\u0015\t)\u0011I\u001d:bsB\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0005Y\u0006twMC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&A\u0002+ie\u0016\fG\r\u0003\u0004`\u0001\u0001\u0006IaU\u0001\ti\"\u0014X-\u00193tA!9\u0011\r\u0001b\u0001\n\u0003\u0011\u0017!\u0003:v]:\f'\r\\3t+\u0005\u0019\u0007cA\u0005UIB\u0011\u0011'Z\u0005\u0003M\n\u00111cS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJDa\u0001\u001b\u0001!\u0002\u0013\u0019\u0017A\u0003:v]:\f'\r\\3tA!)!\u000e\u0001C\u0001W\u0006A1\u000f[;uI><h\u000eF\u0001m!\tIQ.\u0003\u0002o\u0015\t!QK\\5u\u0001")
public class KafkaRequestHandlerPool
implements KafkaMetricsGroup {
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final KafkaApis apis;
    private final int numThreads;
    private final Meter aggregateIdleMeter;
    private final Thread[] threads;
    private final KafkaRequestHandler[] runnables;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaRequestHandlerPool kafkaRequestHandlerPool = this;
        synchronized (kafkaRequestHandlerPool) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public KafkaApis apis() {
        return this.apis;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public Thread[] threads() {
        return this.threads;
    }

    public KafkaRequestHandler[] runnables() {
        return this.runnables;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.runnables())).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.shutdown();
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.threads())).foreach((Function1 & Serializable & scala.Serializable)thread -> {
            thread.join();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shut down completely");
    }

    public KafkaRequestHandlerPool(int brokerId, RequestChannel requestChannel, KafkaApis apis, int numThreads) {
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.numThreads = numThreads;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.aggregateIdleMeter = this.newMeter("RequestHandlerAvgIdlePercent", "percent", TimeUnit.NANOSECONDS, this.newMeter$default$4());
        this.logIdent_$eq("[Kafka Request Handler on Broker " + brokerId + "], ");
        this.threads = new Thread[numThreads];
        this.runnables = new KafkaRequestHandler[numThreads];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            $this.runnables()[i] = new KafkaRequestHandler(i, this.brokerId(), this.aggregateIdleMeter(), $this.numThreads, this.requestChannel(), this.apis());
            $this.threads()[i] = Utils.daemonThread((String)("kafka-request-handler-" + i), (Runnable)this.runnables()[i]);
            this.threads()[i].start();
        });
    }
}

