/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.common.Topic$;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5b!B\u0001\u0003\u0001\t1!!D'fi\u0006$\u0017\r^1DC\u000eDWM\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\n\u0004\u0001\u001di\u0001C\u0001\u0005\f\u001b\u0005I!\"\u0001\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00051I!AB!osJ+g\r\u0005\u0002\u000f#5\tqB\u0003\u0002\u0011\t\u0005)Q\u000f^5mg&\u0011!c\u0004\u0002\b\u0019><w-\u001b8h\u0011!!\u0002A!A!\u0002\u00131\u0012\u0001\u00032s_.,'/\u00133\u0004\u0001A\u0011\u0001bF\u0005\u00031%\u00111!\u00138u\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\u0011AD\b\t\u0003;\u0001i\u0011A\u0001\u0005\u0006)e\u0001\rA\u0006\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0002EA\u00111%\u000b\b\u0003I\u001dj\u0011!\n\u0006\u0003M\u0011\t!bY8oiJ|G\u000e\\3s\u0013\tAS%A\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0013\tQ3FA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJT!\u0001K\u0013\t\r5\u0002\u0001\u0015!\u0003#\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\t\u000f=\u0002!\u0019!C\u0005a\u0005)1-Y2iKV\t\u0011\u0007\u0005\u00033oe\"U\"A\u001a\u000b\u0005Q*\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003m%\t!bY8mY\u0016\u001cG/[8o\u0013\tA4GA\u0002NCB\u0004\"AO!\u000f\u0005mz\u0004C\u0001\u001f\n\u001b\u0005i$B\u0001 \u0016\u0003\u0019a$o\\8u}%\u0011\u0001)C\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002A\u0013A!!g\u000e\fF!\t1\u0015*D\u0001H\u0015\tAE!A\u0002ba&L!AS$\u0003%A\u000b'\u000f^5uS>t7\u000b^1uK&sgm\u001c\u0005\u0007\u0019\u0002\u0001\u000b\u0011B\u0019\u0002\r\r\f7\r[3!\u0011\u001dq\u0005\u00011A\u0005\n=\u000bAbY8oiJ|G\u000e\\3s\u0013\u0012,\u0012\u0001\u0015\t\u0004\u0011E3\u0012B\u0001*\n\u0005\u0019y\u0005\u000f^5p]\"9A\u000b\u0001a\u0001\n\u0013)\u0016\u0001E2p]R\u0014x\u000e\u001c7fe&#w\fJ3r)\t1\u0016\f\u0005\u0002\t/&\u0011\u0001,\u0003\u0002\u0005+:LG\u000fC\u0004['\u0006\u0005\t\u0019\u0001)\u0002\u0007a$\u0013\u0007\u0003\u0004]\u0001\u0001\u0006K\u0001U\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\t\u000fy\u0003!\u0019!C\u0005?\u0006a\u0011\r\\5wK\n\u0013xn[3sgV\t\u0001\r\u0005\u00033oY\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013\u0005\u0003\u001d\u0019G.^:uKJL!AZ2\u0003\r\t\u0013xn[3s\u0011\u0019A\u0007\u0001)A\u0005A\u0006i\u0011\r\\5wK\n\u0013xn[3sg\u0002BqA\u001b\u0001C\u0002\u0013%1.\u0001\u0006bY&4XMT8eKN,\u0012\u0001\u001c\t\u0005e]2R\u000e\u0005\u0003o_BlX\"A\u001b\n\u0005a*\u0004CA9|\u001b\u0005\u0011(BA:u\u0003!\u0001(o\u001c;pG>d'BA;w\u0003\u0019\u0019w.\\7p]*\u0011Qa\u001e\u0006\u0003qf\fa!\u00199bG\",'\"\u0001>\u0002\u0007=\u0014x-\u0003\u0002}e\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\t\u0003}~l\u0011\u0001^\u0005\u0004\u0003\u0003!(\u0001\u0002(pI\u0016Dq!!\u0002\u0001A\u0003%A.A\u0006bY&4XMT8eKN\u0004\u0003\"CA\u0005\u0001\t\u0007I\u0011BA\u0006\u0003U\u0001\u0018M\u001d;ji&|g.T3uC\u0012\fG/\u0019'pG.,\"!!\u0004\u0011\t\u0005=\u0011\u0011E\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005)An\\2lg*!\u0011qCA\r\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u00037\ti\"\u0001\u0003vi&d'BAA\u0010\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0012\u0011\u0003\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\"A\u0011q\u0005\u0001!\u0002\u0013\ti!\u0001\fqCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006dunY6!\u0011\u001d\tY\u0003\u0001C\u0005\u0003[\tAbZ3u\u000b:$\u0007o\\5oiN$\u0002\"a\f\u00026\u0005-\u0013Q\n\t\u0005]\u0006ER0C\u0002\u00024U\u00121aU3r\u0011!\t9$!\u000bA\u0002\u0005e\u0012a\u00022s_.,'o\u001d\t\u0006\u0003w\t)E\u0006\b\u0005\u0003{\t\tED\u0002=\u0003\u007fI\u0011AC\u0005\u0004\u0003\u0007J\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\nIE\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t\u0019%\u0003\u0005\u0007g\u0006%\u0002\u0019\u00019\t\u0011\u0005=\u0013\u0011\u0006a\u0001\u0003#\n!DZ5mi\u0016\u0014XK\\1wC&d\u0017M\u00197f\u000b:$\u0007o\\5oiN\u00042\u0001CA*\u0013\r\t)&\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\tI\u0006\u0001C\u0005\u00037\n\u0001cZ3u\u00032Lg/Z#oIB|\u0017N\u001c;\u0015\r\u0005u\u0013qLA1!\rA\u0011+ \u0005\u0007)\u0005]\u0003\u0019\u0001\f\t\rM\f9\u00061\u0001q\u0011\u001d\t)\u0007\u0001C\u0005\u0003O\nAcZ3u!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fG\u0003CA5\u0003\u0003\u000b))a\"\u0011\t!\t\u00161\u000e\t\u0007\u0003w\t)%!\u001c\u0011\t\u0005=\u00141\u0010\b\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011Q\u000f;\u0002\u0011I,\u0017/^3tiNLA!!\u001f\u0002t\u0005\u0001R*\u001a;bI\u0006$\u0018MU3ta>t7/Z\u0005\u0005\u0003{\nyHA\tQCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006TA!!\u001f\u0002t!9\u00111QA2\u0001\u0004I\u0014!\u0002;pa&\u001c\u0007BB:\u0002d\u0001\u0007\u0001\u000f\u0003\u0005\u0002\n\u0006\r\u0004\u0019AA)\u0003e)'O]8s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\u0006\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\t\u0003#\u000bI*a)\u0002&B)a.!\r\u0002\u0014B!\u0011qNAK\u0013\u0011\t9*a \u0003\u001bQ{\u0007/[2NKR\fG-\u0019;b\u0011!\tY*a#A\u0002\u0005u\u0015A\u0002;pa&\u001c7\u000f\u0005\u0003o\u0003?K\u0014bAAQk\t\u00191+\u001a;\t\rM\fY\t1\u0001q\u0011)\tI)a#\u0011\u0002\u0003\u0007\u0011\u0011\u000b\u0005\b\u0003S\u0003A\u0011AAV\u000319W\r^!mYR{\u0007/[2t)\t\ti\nC\u0004\u00020\u0002!\t!!-\u0002)\u001d,GOT8o\u000bbL7\u000f^5oOR{\u0007/[2t)\u0011\ti*a-\t\u0011\u0005m\u0015Q\u0016a\u0001\u0003;Cq!a.\u0001\t\u0003\tI,A\bhKR\fE.\u001b<f\u0005J|7.\u001a:t+\t\tY\f\u0005\u0003o\u0003c\t\u0007bBA`\u0001\u0011%\u0011\u0011Y\u0001\u0019C\u0012$wJ]+qI\u0006$X\rU1si&$\u0018n\u001c8J]\u001a|Gc\u0002,\u0002D\u0006\u0015\u0017\u0011\u001a\u0005\b\u0003\u0007\u000bi\f1\u0001:\u0011\u001d\t9-!0A\u0002Y\t1\u0002]1si&$\u0018n\u001c8JI\"9\u00111ZA_\u0001\u0004)\u0015!C:uCR,\u0017J\u001c4p\u0011\u001d\ty\r\u0001C\u0001\u0003#\f\u0001cZ3u!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\r\u0005M\u0017Q[Al!\rA\u0011+\u0012\u0005\b\u0003\u0007\u000bi\r1\u0001:\u0011\u001d\t9-!4A\u0002YAa!a7\u0001\t\u0003y\u0015aD4fi\u000e{g\u000e\u001e:pY2,'/\u00133\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\u0006YQ\u000f\u001d3bi\u0016\u001c\u0015m\u00195f)\u00151\u00161]At\u0011\u001d\t)/!8A\u0002Y\tQbY8se\u0016d\u0017\r^5p]&#\u0007\u0002CAu\u0003;\u0004\r!a;\u0002+U\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiB!\u0011\u0011OAw\u0013\u0011\ty/a\u001d\u0003+U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\"9\u00111\u001f\u0001\u0005\n\u0005U\u0018A\t9beRLG/[8o'R\fG/\u001a+p!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0013:4w\u000eF\u0002F\u0003oD\u0001\"!?\u0002r\u0002\u0007\u00111`\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f!\u0011\t\t(!@\n\t\u0005}\u00181\u000f\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000b\t\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u0003#\u00129\u0001C\u0004\u0002\u0004\n\u0005\u0001\u0019A\u001d\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e\u0005\u0019\"/Z7pm\u0016\u0004\u0016M\u001d;ji&|g.\u00138g_R1\u0011\u0011\u000bB\b\u0005#Aq!a!\u0003\n\u0001\u0007\u0011\bC\u0004\u0002H\n%\u0001\u0019\u0001\f\t\u0013\tU\u0001!%A\u0005\u0002\t]\u0011AG4fiR{\u0007/[2NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\u001aTC\u0001B\rU\u0011\t\tFa\u0007,\u0005\tu\u0001\u0003\u0002B\u0010\u0005Si!A!\t\u000b\t\t\r\"QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\n\n\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005W\u0011\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class MetadataCache
implements Logging {
    private final int brokerId;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, PartitionStateInfo>> cache;
    private Option<Object> controllerId;
    private final scala.collection.mutable.Map<Object, Broker> aliveBrokers;
    private final scala.collection.mutable.Map<Object, Map<SecurityProtocol, Node>> aliveNodes;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, PartitionStateInfo>> cache() {
        return this.cache;
    }

    private Option<Object> controllerId() {
        return this.controllerId;
    }

    private void controllerId_$eq(Option<Object> x$1) {
        this.controllerId = x$1;
    }

    private scala.collection.mutable.Map<Object, Broker> aliveBrokers() {
        return this.aliveBrokers;
    }

    private scala.collection.mutable.Map<Object, Map<SecurityProtocol, Node>> aliveNodes() {
        return this.aliveNodes;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private Seq<Node> getEndpoints(Iterable<Object> brokers, SecurityProtocol protocol, boolean filterUnavailableEndpoints) {
        ArrayBuffer result = new ArrayBuffer(package$.MODULE$.min(this.aliveBrokers().size(), brokers.size()));
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            None$ none$;
            Option<Node> option = this.getAliveEndpoint(brokerId, protocol);
            if (None$.MODULE$.equals(option)) {
                none$ = !filterUnavailableEndpoints ? new Some((Object)new Node(brokerId, "", -1)) : None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Node node = (Node)some.value();
                none$ = new Some((Object)node);
            } else {
                throw new MatchError(option);
            }
            None$ endpoint = none$;
            endpoint.foreach((Function1 & Serializable & scala.Serializable)elem -> result.$plus$eq(elem));
        });
        return result;
    }

    private Option<Node> getAliveEndpoint(int brokerId, SecurityProtocol protocol) {
        return this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)brokerId)).map((Function1 & Serializable & scala.Serializable)nodeMap -> (Node)nodeMap.getOrElse((Object)protocol, (Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker `", "` does not support security protocol `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId), protocol})));
        }));
    }

    private Option<Iterable<MetadataResponse.PartitionMetadata>> getPartitionMetadata(String topic, SecurityProtocol protocol, boolean errorUnavailableEndpoints) {
        return this.cache().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataResponse.PartitionMetadata partitionMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int partitionId = tuple2._1$mcI$sp();
            PartitionStateInfo partitionState = (PartitionStateInfo)tuple2._2();
            TopicAndPartition topicPartition = new TopicAndPartition(topic, partitionId);
            LeaderAndIsr leaderAndIsr = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            Option<Node> maybeLeader = this.getAliveEndpoint(leaderAndIsr.leader(), protocol);
            Set<Object> replicas = partitionState.allReplicas();
            Seq<Node> replicaInfo = this.getEndpoints((Iterable<Object>)replicas, protocol, errorUnavailableEndpoints);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": leader not available"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.LEADER_NOT_AVAILABLE, partitionId, Node.noNode(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), Collections.emptyList());
                return partitionMetadata;
            } else {
                MetadataResponse.PartitionMetadata partitionMetadata2;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Node leader = (Node)some.value();
                List<Object> isr = leaderAndIsr.isr();
                Seq<Node> isrInfo = this.getEndpoints((Iterable<Object>)isr, protocol, errorUnavailableEndpoints);
                if (replicaInfo.size() < replicas.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Object[] objectArray = new Object[1];
                        Seq seq = (Seq)replicaInfo.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Seq$.MODULE$.canBuildFrom());
                        objectArray[0] = ((TraversableOnce)replicas.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",");
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": replica information not available for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"following brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava());
                } else if (isrInfo.size() < isr.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Object[] objectArray = new Object[1];
                        Seq seq = (Seq)isrInfo.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom());
                        objectArray[0] = ((TraversableOnce)isr.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",");
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": in sync replica information not available for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"following brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava());
                } else {
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, partitionId, leader, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava());
                }
                partitionMetadata = partitionMetadata2;
            }
            return partitionMetadata;
        }, Iterable$.MODULE$.canBuildFrom()));
    }

    public Seq<MetadataResponse.TopicMetadata> getTopicMetadata(Set<String> topics, SecurityProtocol protocol, boolean errorUnavailableEndpoints) {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata((String)topic, protocol, errorUnavailableEndpoints).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic$.MODULE$.isInternal((String)topic), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom()));
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public Set<String> getAllTopics() {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().keySet().toSet());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Set)topics.$minus$minus((GenTraversableOnce)this.cache().keySet()));
    }

    public Seq<Broker> getAliveBrokers() {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.aliveBrokers().values().toBuffer());
    }

    private void addOrUpdatePartitionInfo(String topic, int partitionId, PartitionStateInfo stateInfo) {
        CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map infos = (scala.collection.mutable.Map)this.cache().getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
            infos.update((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)stateInfo);
        });
    }

    public Option<PartitionStateInfo> getPartitionInfo(String topic, int partitionId) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get((Object)BoxesRunTime.boxToInteger((int)partitionId))));
    }

    public Option<Object> getControllerId() {
        return this.controllerId();
    }

    public void updateCache(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            this.controllerId_$eq((Option<Object>)(n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n))));
            this.aliveNodes().clear();
            this.aliveBrokers().clear();
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)broker -> {
                MetadataCache.$anonfun$updateCache$2(this, broker);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                MetadataCache.$anonfun$updateCache$4(this, correlationId, updateMetadataRequest, x0$3);
                return BoxedUnit.UNIT;
            });
        });
    }

    private PartitionStateInfo partitionStateToPartitionStateInfo(PartitionState partitionState) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(partitionState.leader, partitionState.leaderEpoch, (List<Object>)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$4)), Buffer$.MODULE$.canBuildFrom())).toList(), partitionState.zkVersion);
        LeaderIsrAndControllerEpoch leaderInfo = new LeaderIsrAndControllerEpoch(leaderAndIsr, partitionState.controllerEpoch);
        return new PartitionStateInfo(leaderInfo, (Set<Object>)((Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$5)), Set$.MODULE$.canBuildFrom())));
    }

    public boolean contains(String topic) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.cache().contains((Object)topic)));
    }

    private boolean removePartitionInfo(String topic, int partitionId) {
        return BoxesRunTime.unboxToBoolean((Object)this.cache().get((Object)topic).map((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$removePartitionInfo$1(this, topic, partitionId, infos))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public static final /* synthetic */ void $anonfun$updateCache$2(MetadataCache $this, UpdateMetadataRequest.Broker broker) {
        EnumMap nodes = new EnumMap(SecurityProtocol.class);
        EnumMap endPoints = new EnumMap(SecurityProtocol.class);
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.endPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
            UpdateMetadataRequest.EndPoint ep = (UpdateMetadataRequest.EndPoint)tuple2._2();
            endPoints.put(protocol, new EndPoint(ep.host, ep.port, protocol));
            Node node = nodes.put(protocol, new Node(broker$1.id, ep.host, ep.port));
            return node;
        });
        $this.aliveBrokers().update((Object)BoxesRunTime.boxToInteger((int)broker.id), (Object)new Broker(broker.id, (Map<SecurityProtocol, EndPoint>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(endPoints).asScala()), (Option<String>)Option$.MODULE$.apply((Object)broker.rack)));
        $this.aliveNodes().update((Object)BoxesRunTime.boxToInteger((int)broker.id), JavaConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
    }

    public static final /* synthetic */ void $anonfun$updateCache$4(MetadataCache $this, int correlationId$1, UpdateMetadataRequest updateMetadataRequest$1, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionState info = (PartitionState)tuple2._2();
            int controllerId = updateMetadataRequest$1.controllerId();
            int controllerEpoch = updateMetadataRequest$1.controllerEpoch();
            if (info.leader == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                $this.removePartitionInfo(tp.topic(), tp.partition());
                $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker ", " deleted partition ", " from metadata cache in response to UpdateMetadata "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.brokerId), tp})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request sent by controller ", " epoch ", " with correlation id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)controllerEpoch), BoxesRunTime.boxToInteger((int)correlationId$1)})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                PartitionStateInfo partitionInfo = $this.partitionStateToPartitionStateInfo(info);
                $this.addOrUpdatePartitionInfo(tp.topic(), tp.partition(), partitionInfo);
                $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker ", " cached leader info ", " for partition ", " in response to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.brokerId), partitionInfo, tp})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UpdateMetadata request sent by controller ", " epoch ", " with correlation id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)controllerEpoch), BoxesRunTime.boxToInteger((int)correlationId$1)})));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(MetadataCache $this, String topic$5, int partitionId$3, scala.collection.mutable.Map infos) {
        infos.remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3));
        Object object = infos.isEmpty() ? $this.cache().remove((Object)topic$5) : BoxedUnit.UNIT;
        return true;
    }

    public MetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.cache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.controllerId = None$.MODULE$;
        this.aliveBrokers = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.aliveNodes = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Kafka Metadata Cache on broker ", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
    }
}

