/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController$;
import kafka.server.LeaderElector;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.SystemTime$;
import kafka.utils.ZKCheckedEphemeral;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001\u001d\u0011aCW8pW\u0016,\u0007/\u001a:MK\u0006$WM]#mK\u000e$xN\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\b\u0013!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u000e\u0019\u0016\fG-\u001a:FY\u0016\u001cGo\u001c:\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011!B;uS2\u001c\u0018BA\f\u0015\u0005\u001daunZ4j]\u001eD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$\bCA\u000e\u001f\u001b\u0005a\"BA\u000f\u0005\u0003)\u0019wN\u001c;s_2dWM]\u0005\u0003?q\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013\u0001D3mK\u000e$\u0018n\u001c8QCRD\u0007CA\u0012+\u001d\t!\u0003\u0006\u0005\u0002&\u00155\taE\u0003\u0002(\r\u00051AH]8pizJ!!\u000b\u0006\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003S)A\u0001B\f\u0001\u0003\u0002\u0003\u0006IaL\u0001\u0011_:\u0014UmY8nS:<G*Z1eKJ\u00042!\u0003\u00193\u0013\t\t$BA\u0005Gk:\u001cG/[8oaA\u0011\u0011bM\u0005\u0003i)\u0011A!\u00168ji\"Aa\u0007\u0001B\u0001B\u0003%q&A\np]J+7/[4oS:<\u0017i\u001d'fC\u0012,'\u000f\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0003!\u0011'o\\6fe&#\u0007CA\u0005;\u0013\tY$BA\u0002J]RDQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtDCB A\u0003\n\u001bE\t\u0005\u0002\u0010\u0001!)\u0011\u0004\u0010a\u00015!)\u0011\u0005\u0010a\u0001E!)a\u0006\u0010a\u0001_!)a\u0007\u0010a\u0001_!)\u0001\b\u0010a\u0001s!9a\t\u0001a\u0001\n\u00039\u0015\u0001\u00037fC\u0012,'/\u00133\u0016\u0003eBq!\u0013\u0001A\u0002\u0013\u0005!*\u0001\u0007mK\u0006$WM]%e?\u0012*\u0017\u000f\u0006\u00023\u0017\"9A\nSA\u0001\u0002\u0004I\u0014a\u0001=%c!1a\n\u0001Q!\ne\n\u0011\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0011\t\u000fA\u0003!\u0019!C\u0001\u000f\u0006)\u0011N\u001c3fq\"1!\u000b\u0001Q\u0001\ne\na!\u001b8eKb\u0004\u0003b\u0002+\u0001\u0005\u0004%\t!V\u0001\u0015Y\u0016\fG-\u001a:DQ\u0006tw-\u001a'jgR,g.\u001a:\u0016\u0003Y\u0003\"a\u0016-\u000e\u0003\u00011A!\u0017\u0001\u00015\n!B*Z1eKJ\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u001cB\u0001W.d%A\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0005Y\u0006twMC\u0001a\u0003\u0011Q\u0017M^1\n\u0005\tl&AB(cU\u0016\u001cG\u000f\u0005\u0002eW6\tQM\u0003\u0002gO\u0006A!p[2mS\u0016tGO\u0003\u0002iS\u00061\u0011\nM%uK\u000eT\u0011A[\u0001\u0004_J<\u0017B\u00017f\u0005=I%l\u001b#bi\u0006d\u0015n\u001d;f]\u0016\u0014\b\"B\u001fY\t\u0003qG#\u0001,\t\u000bADF\u0011A9\u0002!!\fg\u000e\u001a7f\t\u0006$\u0018m\u00115b]\u001e,Gc\u0001\u001asi\")1o\u001ca\u0001E\u0005AA-\u0019;b!\u0006$\b\u000eC\u0003v_\u0002\u00071,\u0001\u0003eCR\f\u0007\u0006B8x\u0003\u000f\u00012!\u0003={\u0013\tI(B\u0001\u0004uQJ|wo\u001d\t\u0004w\u0006\u0005aB\u0001?\u007f\u001d\t)S0C\u0001\f\u0013\ty(\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0011Q\u0001\u0002\n\u000bb\u001cW\r\u001d;j_:T!a \u0006$\u0003iDq!a\u0003Y\t\u0003\ti!A\tiC:$G.\u001a#bi\u0006$U\r\\3uK\u0012$2AMA\b\u0011\u0019\u0019\u0018\u0011\u0002a\u0001E!*\u0011\u0011B<\u0002\b!9\u0011Q\u0003\u0001!\u0002\u00131\u0016!\u00067fC\u0012,'o\u00115b]\u001e,G*[:uK:,'\u000f\t\u0005\b\u00033\u0001A\u0011AA\u000e\u0003\u001d\u0019H/\u0019:ukB,\u0012A\r\u0005\b\u0003?\u0001A\u0011BA\u0011\u0003=9W\r^\"p]R\u0014x\u000e\u001c7fe&#E#A\u001d\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(\u0005)Q\r\\3diV\u0011\u0011\u0011\u0006\t\u0004\u0013\u0005-\u0012bAA\u0017\u0015\t9!i\\8mK\u0006t\u0007bBA\u0019\u0001\u0011\u0005\u00111D\u0001\u0006G2|7/\u001a\u0005\b\u0003k\u0001A\u0011AA\u0014\u0003%\tW.\u0013'fC\u0012,'\u000fC\u0004\u0002:\u0001!\t!a\u000f\u0002\rI,7/[4o)\t\tI\u0003")
public class ZookeeperLeaderElector
implements LeaderElector {
    public final ControllerContext kafka$server$ZookeeperLeaderElector$$controllerContext;
    private final String electionPath;
    private final Function0<BoxedUnit> onBecomingLeader;
    public final Function0<BoxedUnit> kafka$server$ZookeeperLeaderElector$$onResigningAsLeader;
    public final int kafka$server$ZookeeperLeaderElector$$brokerId;
    private int leaderId;
    private final int index;
    private final LeaderChangeListener leaderChangeListener;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZookeeperLeaderElector zookeeperLeaderElector = this;
        synchronized (zookeeperLeaderElector) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int leaderId() {
        return this.leaderId;
    }

    public void leaderId_$eq(int x$1) {
        this.leaderId = x$1;
    }

    public int index() {
        return this.index;
    }

    public LeaderChangeListener leaderChangeListener() {
        return this.leaderChangeListener;
    }

    @Override
    public void startup() {
        CoreUtils$.MODULE$.inLock(this.kafka$server$ZookeeperLeaderElector$$controllerContext.controllerLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.kafka$server$ZookeeperLeaderElector$$controllerContext.zkUtils().zkClient().subscribeDataChanges($this.electionPath, (IZkDataListener)this.leaderChangeListener());
            return this.elect();
        });
    }

    private int getControllerID() {
        int n;
        Option option = (Option)this.kafka$server$ZookeeperLeaderElector$$controllerContext.zkUtils().readDataMaybeNull(this.electionPath)._1();
        if (option instanceof Some) {
            Some some = (Some)option;
            String controller = (String)some.value();
            n = KafkaController$.MODULE$.parseControllerId(controller);
        } else if (None$.MODULE$.equals(option)) {
            n = -1;
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    @Override
    public boolean elect() {
        Boolean bl;
        String timestamp = ((Object)BoxesRunTime.boxToLong((long)SystemTime$.MODULE$.milliseconds())).toString();
        String electString = Json$.MODULE$.encode(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"brokerid"), (Object)BoxesRunTime.boxToInteger((int)this.kafka$server$ZookeeperLeaderElector$$brokerId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp"), (Object)timestamp)})));
        this.leaderId_$eq(this.getControllerID());
        if (this.leaderId() != -1) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Broker %d has been elected as leader, so stopping the election process.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId())})));
            return this.amILeader();
        }
        try {
            ZKCheckedEphemeral zkCheckedEphemeral = new ZKCheckedEphemeral(this.electionPath, electString, this.kafka$server$ZookeeperLeaderElector$$controllerContext.zkUtils().zkConnection().getZookeeper(), JaasUtils.isZkSecurityEnabled());
            zkCheckedEphemeral.create();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> $this.kafka$server$ZookeeperLeaderElector$$brokerId + " successfully elected as leader");
            this.leaderId_$eq(this.kafka$server$ZookeeperLeaderElector$$brokerId);
            this.onBecomingLeader.apply$mcV$sp();
            bl = BoxedUnit.UNIT;
        }
        catch (ZkNodeExistsException e) {
            this.leaderId_$eq(this.getControllerID());
            if (this.leaderId() != -1) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Broker %d was elected as leader instead of broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId()), BoxesRunTime.boxToInteger((int)$this.kafka$server$ZookeeperLeaderElector$$brokerId)})));
            } else {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "A leader has been elected but just resigned, this will result in another round of election");
            }
            bl = BoxedUnit.UNIT;
        }
        catch (Throwable e2) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while electing or becoming leader on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.kafka$server$ZookeeperLeaderElector$$brokerId)})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e2);
            bl = BoxesRunTime.boxToBoolean((boolean)this.resign());
        }
        return this.amILeader();
    }

    @Override
    public void close() {
        this.leaderId_$eq(-1);
    }

    @Override
    public boolean amILeader() {
        return this.leaderId() == this.kafka$server$ZookeeperLeaderElector$$brokerId;
    }

    public boolean resign() {
        this.leaderId_$eq(-1);
        return this.kafka$server$ZookeeperLeaderElector$$controllerContext.zkUtils().deletePath(this.electionPath);
    }

    public ZookeeperLeaderElector(ControllerContext controllerContext, String electionPath, Function0<BoxedUnit> onBecomingLeader, Function0<BoxedUnit> onResigningAsLeader, int brokerId) {
        this.kafka$server$ZookeeperLeaderElector$$controllerContext = controllerContext;
        this.electionPath = electionPath;
        this.onBecomingLeader = onBecomingLeader;
        this.kafka$server$ZookeeperLeaderElector$$onResigningAsLeader = onResigningAsLeader;
        this.kafka$server$ZookeeperLeaderElector$$brokerId = brokerId;
        Logging.$init$(this);
        this.leaderId = -1;
        this.index = electionPath.lastIndexOf("/");
        if (this.index() > 0) {
            controllerContext.zkUtils().makeSurePersistentPathExists(electionPath.substring(0, this.index()), controllerContext.zkUtils().makeSurePersistentPathExists$default$2());
        }
        this.leaderChangeListener = new LeaderChangeListener();
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class LeaderChangeListener
    implements IZkDataListener,
    Logging {
        private final String loggerName;
        private Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging.trace$(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging.swallowTrace$(this, action);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging.debug$(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging.swallowDebug$(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging.info$(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging.swallowInfo$(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging.warn$(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging.swallowWarn$(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging.swallow$(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging.error$(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging.swallowError$(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging.fatal$(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            LeaderChangeListener leaderChangeListener = this;
            synchronized (leaderChangeListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        public void handleDataChange(String dataPath, Object data) throws Exception {
            CoreUtils$.MODULE$.inLock(this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().kafka$server$ZookeeperLeaderElector$$controllerContext.controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                block0: {
                    boolean amILeaderBeforeDataChange = this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().amILeader();
                    this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().leaderId_$eq(KafkaController$.MODULE$.parseControllerId(data.toString()));
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("New leader is %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().leaderId())})));
                    if (!amILeaderBeforeDataChange || this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().amILeader()) break block0;
                    $this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().kafka$server$ZookeeperLeaderElector$$onResigningAsLeader.apply$mcV$sp();
                }
            });
        }

        public void handleDataDeleted(String dataPath) throws Exception {
            CoreUtils$.MODULE$.inLock(this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().kafka$server$ZookeeperLeaderElector$$controllerContext.controllerLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                block0: {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("%s leader change listener fired for path %s to handle data deleted: trying to elect as a leader")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().kafka$server$ZookeeperLeaderElector$$brokerId), dataPath})));
                    if (!this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().amILeader()) break block0;
                    $this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().kafka$server$ZookeeperLeaderElector$$onResigningAsLeader.apply$mcV$sp();
                }
                return this.kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer().elect();
            });
        }

        public /* synthetic */ ZookeeperLeaderElector kafka$server$ZookeeperLeaderElector$LeaderChangeListener$$$outer() {
            return ZookeeperLeaderElector.this;
        }

        public LeaderChangeListener() {
            if (ZookeeperLeaderElector.this == null) {
                throw null;
            }
            Logging.$init$(this);
        }
    }
}

