/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.OffsetFetchRequest;
import kafka.api.OffsetFetchRequest$;
import kafka.api.OffsetFetchResponse;
import kafka.api.OffsetFetchResponse$;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.client.ClientUtils$;
import kafka.common.OffsetMetadataAndError;
import kafka.common.OffsetMetadataAndError$;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.network.BlockingChannel;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerOffsetChecker$
implements Logging {
    public static ConsumerOffsetChecker$ MODULE$;
    private final Map<Object, Option<SimpleConsumer>> consumerMap;
    private final Map<TopicAndPartition, Object> offsetMap;
    private scala.collection.immutable.Map<String, Seq<Object>> topicPidMap;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ConsumerOffsetChecker$();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConsumerOffsetChecker$ consumerOffsetChecker$ = this;
        synchronized (consumerOffsetChecker$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private Map<Object, Option<SimpleConsumer>> consumerMap() {
        return this.consumerMap;
    }

    private Map<TopicAndPartition, Object> offsetMap() {
        return this.offsetMap;
    }

    private scala.collection.immutable.Map<String, Seq<Object>> topicPidMap() {
        return this.topicPidMap;
    }

    private void topicPidMap_$eq(scala.collection.immutable.Map<String, Seq<Object>> x$1) {
        this.topicPidMap = x$1;
    }

    private Option<SimpleConsumer> getConsumer(ZkUtils zkUtils, int bid) {
        Option option;
        try {
            option = zkUtils.getBrokerInfo(bid).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getBrokerEndPoint(SecurityProtocol.PLAINTEXT)).map((Function1 & Serializable & scala.Serializable)endPoint -> new SimpleConsumer(endPoint.host(), endPoint.port(), 10000, 100000, "ConsumerOffsetChecker")).orElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bid)})));
            });
        }
        catch (Throwable t) {
            Predef$.MODULE$.println((Object)("Could not parse broker info due to " + t.getCause()));
            option = None$.MODULE$;
        }
        return option;
    }

    private void processPartition(ZkUtils zkUtils, String group, String topic, int pid) {
        TopicAndPartition topicPartition = new TopicAndPartition(topic, pid);
        Option offsetOpt = this.offsetMap().get((Object)topicPartition);
        ZKGroupTopicDirs groupDirs = new ZKGroupTopicDirs(group, topic);
        Option owner = (Option)zkUtils.readDataMaybeNull(groupDirs.consumerOwnerDir() + new StringOps(Predef$.MODULE$.augmentString("/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)pid)})))._1();
        Option<Object> option = zkUtils.getLeaderForPartition(topic, pid);
        if (option instanceof Some) {
            Some some = (Some)option;
            int bid = BoxesRunTime.unboxToInt((Object)some.value());
            Option consumerOpt = (Option)this.consumerMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)bid), (Function0 & Serializable & scala.Serializable)() -> this.getConsumer(zkUtils, bid));
            Option option2 = consumerOpt;
            if (option2 instanceof Some) {
                String string;
                Some some2 = (Some)option2;
                SimpleConsumer consumer = (SimpleConsumer)some2.value();
                TopicAndPartition topicAndPartition = new TopicAndPartition(topic, pid);
                OffsetRequest request = new OffsetRequest((scala.collection.immutable.Map<TopicAndPartition, PartitionOffsetRequestInfo>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 1))}))), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                long logSize = BoxesRunTime.unboxToLong((Object)((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets().head());
                Option lagString = offsetOpt.map((Function1 & Serializable & scala.Serializable)o -> ConsumerOffsetChecker$.$anonfun$processPartition$2(logSize, BoxesRunTime.unboxToLong((Object)o)));
                StringOps stringOps = new StringOps(Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s"));
                Object[] objectArray = new Object[7];
                objectArray[0] = group;
                objectArray[1] = topic;
                objectArray[2] = BoxesRunTime.boxToInteger((int)pid);
                objectArray[3] = offsetOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown");
                objectArray[4] = BoxesRunTime.boxToLong((long)logSize);
                objectArray[5] = lagString.getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown");
                Option option3 = owner;
                if (option3 instanceof Some) {
                    String ownerStr;
                    Some some3 = (Some)option3;
                    string = ownerStr = (String)some3.value();
                } else if (None$.MODULE$.equals(option3)) {
                    string = "none";
                } else {
                    throw new MatchError((Object)option3);
                }
                objectArray[6] = string;
                Predef$.MODULE$.println((Object)stringOps.format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option2)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("No broker for partition %s - %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)pid)})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private void processTopic(ZkUtils zkUtils, String group, String topic) {
        Option option = this.topicPidMap().get((Object)topic);
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq pids = (Seq)some.value();
            ((IterableLike)pids.sorted((Ordering)Ordering.Int$.MODULE$)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pid -> this.processPartition(zkUtils, group, topic, pid));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void printBrokerInfo() {
        Predef$.MODULE$.println((Object)"BROKER INFO");
        this.consumerMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ConsumerOffsetChecker$.$anonfun$printBrokerInfo$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            ConsumerOffsetChecker$.$anonfun$printBrokerInfo$2(x$2);
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "WARNING: ConsumerOffsetChecker is deprecated and will be dropped in releases following 0.9.0. Use ConsumerGroupCommand instead.");
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zookeeper", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec topicsOpt = parser.accepts("topic", "Comma-separated list of consumer topics (all topics if absent).").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec groupOpt = parser.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec channelSocketTimeoutMsOpt = parser.accepts("socket.timeout.ms", "Socket timeout to use when querying for offsets.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(6000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec channelRetryBackoffMsOpt = parser.accepts("retry.backoff.ms", "Retry back-off to use for failed offset queries.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(3000), (Object[])new Integer[0]);
        parser.accepts("broker-info", "Print broker info");
        parser.accepts("help", "Print this message.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Check the offset of your consumers.");
        }
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{groupOpt, zkConnectOpt}));
        String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
        String group = (String)options.valueOf((OptionSpec)groupOpt);
        ZKGroupDirs groupDirs = new ZKGroupDirs(group);
        int channelSocketTimeoutMs = (Integer)options.valueOf((OptionSpec)channelSocketTimeoutMsOpt);
        int channelRetryBackoffMs = (Integer)options.valueOf((OptionSpec)channelRetryBackoffMsOpt);
        None$ topics = options.has((OptionSpec)topicsOpt) ? new Some(options.valueOf((OptionSpec)topicsOpt)) : None$.MODULE$;
        ObjectRef zkUtils = ObjectRef.create(null);
        BlockingChannel channel = null;
        try {
            try {
                List list;
                zkUtils.elem = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());
                None$ none$ = topics;
                if (none$ instanceof Some) {
                    Some some = (Some)none$;
                    String x = (String)some.value();
                    list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x.split(","))).view().toList();
                } else if (None$.MODULE$.equals(none$)) {
                    list = ((ZkUtils)zkUtils.elem).getChildren(groupDirs.consumerGroupDir() + "/owners").toList();
                } else {
                    throw new MatchError((Object)none$);
                }
                List topicList = list;
                this.topicPidMap_$eq((scala.collection.immutable.Map<String, Seq<Object>>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply(((ZkUtils)zkUtils.elem).getPartitionsForTopics((Seq<String>)topicList).toSeq())));
                Seq topicPartitions = ((TraversableOnce)this.topicPidMap().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String topic = (String)tuple2._1();
                    Seq partitionSeq = (Seq)tuple2._2();
                    Seq seq = (Seq)partitionSeq.map((Function1 & Serializable & scala.Serializable)x$3 -> ConsumerOffsetChecker$.$anonfun$main$3(topic, BoxesRunTime.unboxToInt((Object)x$3)), Seq$.MODULE$.canBuildFrom());
                    return seq;
                }, Iterable$.MODULE$.canBuildFrom())).toSeq();
                BlockingChannel channel2 = ClientUtils$.MODULE$.channelToOffsetManager(group, (ZkUtils)zkUtils.elem, channelSocketTimeoutMs, channelRetryBackoffMs);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending offset fetch request to coordinator %s:%d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{channel2.host(), BoxesRunTime.boxToInteger((int)channel2.port())})));
                channel2.send(new OffsetFetchRequest(group, (Seq<TopicAndPartition>)topicPartitions, OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5()));
                OffsetFetchResponse offsetFetchResponse = OffsetFetchResponse$.MODULE$.readFrom(channel2.receive().payload());
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Received offset fetch response %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offsetFetchResponse})));
                offsetFetchResponse.requestInfo().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Option option;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        OffsetMetadataAndError offsetAndMetadata;
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                        OffsetMetadataAndError offsetMetadataAndError = offsetAndMetadata = (OffsetMetadataAndError)tuple2._2();
                        OffsetMetadataAndError offsetMetadataAndError2 = OffsetMetadataAndError$.MODULE$.NoOffset();
                        if (!(offsetMetadataAndError != null ? !((Object)offsetMetadataAndError).equals(offsetMetadataAndError2) : offsetMetadataAndError2 != null)) {
                            ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(group, topicAndPartition.topic());
                            try {
                                long offset = new StringOps(Predef$.MODULE$.augmentString((String)((ZkUtils)zkUtils$3.elem).readData(topicDirs.consumerOffsetDir() + new StringOps(Predef$.MODULE$.augmentString("/%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)topicAndPartition.partition())})))._1())).toLong();
                                option = this.offsetMap().put((Object)topicAndPartition, (Object)BoxesRunTime.boxToLong((long)offset));
                            }
                            catch (ZkNoNodeException z) {
                                if (((ZkUtils)zkUtils$3.elem).pathExists(topicDirs.consumerOffsetDir())) {
                                    option = this.offsetMap().put((Object)topicAndPartition, (Object)BoxesRunTime.boxToLong((long)-1L));
                                }
                                throw z;
                            }
                        } else if (offsetAndMetadata.error() == Errors.NONE.code()) {
                            option = this.offsetMap().put((Object)topicAndPartition, (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
                        } else {
                            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Could not fetch offset for %s due to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, Errors.forCode((short)offsetAndMetadata.error()).exception()})));
                            option = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Option option2 = option;
                    return option2;
                });
                channel2.disconnect();
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Group", "Topic", "Pid", "Offset", "logSize", "Lag", "Owner"})));
                ((List)topicList.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                    this.processTopic((ZkUtils)zkUtils.elem, group, topic);
                    return BoxedUnit.UNIT;
                });
                if (options.has("broker-info")) {
                    this.printBrokerInfo();
                }
                this.consumerMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ConsumerOffsetChecker$.$anonfun$main$8(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    ConsumerOffsetChecker$.$anonfun$main$9(x$4);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable t) {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Exiting due to: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getMessage()})));
            }
        }
        finally {
            this.consumerMap().values().foreach((Function1 & Serializable & scala.Serializable)consumerOpt -> {
                ConsumerOffsetChecker$.$anonfun$main$10(consumerOpt);
                return BoxedUnit.UNIT;
            });
            if ((ZkUtils)zkUtils.elem != null) {
                ((ZkUtils)zkUtils.elem).close();
            }
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    public static final /* synthetic */ String $anonfun$processPartition$2(long logSize$1, long o) {
        return o == -1L ? "unknown" : ((Object)BoxesRunTime.boxToLong((long)(logSize$1 - o))).toString();
    }

    public static final /* synthetic */ boolean $anonfun$printBrokerInfo$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$printBrokerInfo$2(Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int bid = tuple2._1$mcI$sp();
        Option consumerOpt = (Option)tuple2._2();
        Option option = consumerOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            SimpleConsumer consumer = (SimpleConsumer)some.value();
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s -> %s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bid), consumer.host(), BoxesRunTime.boxToInteger((int)consumer.port())})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ TopicAndPartition $anonfun$main$3(String topic$2, int x$3) {
        return new TopicAndPartition(topic$2, x$3);
    }

    public static final /* synthetic */ boolean $anonfun$main$8(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$main$9(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option consumerOpt = (Option)tuple2._2();
        Option option = consumerOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            SimpleConsumer consumer = (SimpleConsumer)some.value();
            consumer.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$main$10(Option consumerOpt) {
        Option option = consumerOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            SimpleConsumer consumer = (SimpleConsumer)some.value();
            consumer.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private ConsumerOffsetChecker$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.consumerMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.offsetMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.topicPidMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

