/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.IteratorTemplate;
import kafka.utils.VerifiableProperties;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DumpLogSegments$ {
    public static DumpLogSegments$ MODULE$;

    static {
        new DumpLogSegments$();
    }

    public void main(String[] args) {
        DumpLogSegments.MessageParser<String, String> messageParser;
        OptionParser parser = new OptionParser();
        OptionSpecBuilder printOpt = parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        OptionSpecBuilder verifyOpt = parser.accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        OptionSpecBuilder indexSanityOpt = parser.accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        ArgumentAcceptingOptionSpec filesOpt = parser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        ArgumentAcceptingOptionSpec maxMessageSizeOpt = parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        OptionSpecBuilder deepIterationOpt = parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration.");
        ArgumentAcceptingOptionSpec valueDecoderOpt = parser.accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec keyDecoderOpt = parser.accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        OptionSpecBuilder offsetsOpt = parser.accepts("offsets-decoder", "if set, log data will be parsed as offset data from __consumer_offsets topic.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{filesOpt}));
        boolean printDataLog = options.has((OptionSpec)printOpt) || options.has((OptionSpec)offsetsOpt) || options.has((OptionSpec)valueDecoderOpt) || options.has((OptionSpec)keyDecoderOpt);
        boolean verifyOnly = options.has((OptionSpec)verifyOpt);
        boolean indexSanityOnly = options.has((OptionSpec)indexSanityOpt);
        String[] files = ((String)options.valueOf((OptionSpec)filesOpt)).split(",");
        int maxMessageSize = (Integer)options.valueOf((OptionSpec)maxMessageSizeOpt);
        boolean isDeepIteration = options.has((OptionSpec)deepIterationOpt);
        if (options.has((OptionSpec)offsetsOpt)) {
            messageParser = new DumpLogSegments.OffsetsMessageParser();
        } else {
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)options.valueOf((OptionSpec)valueDecoderOpt), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)options.valueOf((OptionSpec)keyDecoderOpt), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            messageParser = new DumpLogSegments.DecoderMessageParser(keyDecoder, valueDecoder);
        }
        DumpLogSegments.OffsetsMessageParser messageParser2 = messageParser;
        HashMap misMatchesForIndexFilesMap = new HashMap();
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        HashMap nonConsecutivePairsForLogFilesMap = new HashMap();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).foreach((Function1 & Serializable & scala.Serializable)arg -> {
            DumpLogSegments$.$anonfun$main$1(this, printDataLog, verifyOnly, indexSanityOnly, maxMessageSize, isDeepIteration, messageParser2, misMatchesForIndexFilesMap, timeIndexDumpErrors, nonConsecutivePairsForLogFilesMap, arg);
            return BoxedUnit.UNIT;
        });
        misMatchesForIndexFilesMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DumpLogSegments$.$anonfun$main$2(x0$1);
            return BoxedUnit.UNIT;
        });
        timeIndexDumpErrors.printErrors();
        nonConsecutivePairsForLogFilesMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DumpLogSegments$.$anonfun$main$4(x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private void dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, HashMap<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        Object object = new Object();
        try {
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            File logFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + Log$.MODULE$.LogFileSuffix());
            FileMessageSet messageSet = new FileMessageSet(logFile, false);
            OffsetIndex index = new OffsetIndex(file, startOffset, OffsetIndex$.MODULE$.$lessinit$greater$default$3());
            if (indexSanityOnly) {
                index.sanityCheck();
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                return;
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index.entries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                block3: {
                    BoxedUnit boxedUnit;
                    OffsetPosition entry = index.entry(i);
                    FileMessageSet partialFileMessageSet = messageSet.read(entry.position(), maxMessageSize);
                    MessageAndOffset messageAndOffset = (MessageAndOffset)this.getIterator((MessageAndOffset)partialFileMessageSet.head(), true).next();
                    if (messageAndOffset.offset() != entry.offset() + index.baseOffset()) {
                        List misMatchesSeq = (List)misMatchesForIndexFilesMap.getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                        misMatchesSeq = misMatchesSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(entry.offset() + index.baseOffset(), messageAndOffset.offset()));
                        boxedUnit = misMatchesForIndexFilesMap.put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    if (entry.offset() == 0L && i > 0) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    if (verifyOnly) break block3;
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("offset: %d position: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(entry.offset() + index.baseOffset())), BoxesRunTime.boxToInteger((int)entry.position())})));
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors, int maxMessageSize) {
        Object object = new Object();
        try {
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            File logFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + Log$.MODULE$.LogFileSuffix());
            FileMessageSet messageSet = new FileMessageSet(logFile, false);
            File indexFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + Log$.MODULE$.IndexFileSuffix());
            OffsetIndex index = new OffsetIndex(indexFile, startOffset, OffsetIndex$.MODULE$.$lessinit$greater$default$3());
            TimeIndex timeIndex = new TimeIndex(file, startOffset, TimeIndex$.MODULE$.$lessinit$greater$default$3());
            if (indexSanityOnly) {
                timeIndex.sanityCheck();
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                return;
            }
            LongRef prevTimestamp = LongRef.create((long)Message$.MODULE$.NoTimestamp());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), timeIndex.entries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                TimestampOffset entry = timeIndex.entry(i);
                int position = index.lookup(entry.offset() + timeIndex.baseOffset()).position();
                FileMessageSet partialFileMessageSet = messageSet.read(position, Integer.MAX_VALUE);
                Iterator<MessageAndOffset> shallowIter = partialFileMessageSet.iterator();
                LongRef maxTimestamp = LongRef.create((long)Message$.MODULE$.NoTimestamp());
                Option wrapperMessageOpt = shallowIter.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegments$.$anonfun$dumpTimeIndex$2(timeIndex, entry, x$1)));
                if (!wrapperMessageOpt.isDefined() || ((MessageAndOffset)wrapperMessageOpt.get()).offset() != entry.offset() + timeIndex.baseOffset()) {
                    timeIndexDumpErrors.recordShallowOffsetNotFound(file, entry.offset() + timeIndex.baseOffset(), wrapperMessageOpt.isDefined() ? ((MessageAndOffset)wrapperMessageOpt.get()).offset() : -1L);
                } else {
                    Iterator<MessageAndOffset> deepIter = this.getIterator((MessageAndOffset)wrapperMessageOpt.get(), true);
                    deepIter.foreach((Function1 & Serializable & scala.Serializable)messageAndOffset -> {
                        maxTimestamp.elem = package$.MODULE$.max(maxTimestamp.elem, messageAndOffset.message().timestamp());
                        return BoxedUnit.UNIT;
                    });
                    if (maxTimestamp.elem != entry.timestamp()) {
                        timeIndexDumpErrors.recordMismatchTimeIndex(file, entry.timestamp(), maxTimestamp.elem);
                    }
                    if (prevTimestamp$1.elem >= entry.timestamp()) {
                        timeIndexDumpErrors.recordOutOfOrderIndexTimestamp(file, entry.timestamp(), prevTimestamp$1.elem);
                    }
                    if (entry.offset() == 0L && i > 0) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                }
                if (!verifyOnly) {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("timestamp: %s offset: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)entry.timestamp()), BoxesRunTime.boxToLong((long)(timeIndex.baseOffset() + entry.offset()))})));
                }
                prevTimestamp$1.elem = entry.timestamp();
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void dumpLog(File file, boolean printContents, HashMap<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, DumpLogSegments.MessageParser<?, ?> parser) {
        block0: {
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            Predef$.MODULE$.println((Object)("Starting offset: " + startOffset));
            FileMessageSet messageSet = new FileMessageSet(file, false);
            LongRef validBytes = LongRef.create((long)0L);
            LongRef lastOffset = LongRef.create((long)-1L);
            Iterator<MessageAndOffset> shallowIterator = messageSet.iterator(maxMessageSize);
            shallowIterator.foreach((Function1 & Serializable & scala.Serializable)shallowMessageAndOffset -> {
                DumpLogSegments$.$anonfun$dumpLog$1(this, file, printContents, nonConsecutivePairsForLogFilesMap, isDeepIteration, parser, validBytes, lastOffset, shallowMessageAndOffset);
                return BoxedUnit.UNIT;
            });
            long trailingBytes = (long)messageSet.sizeInBytes() - validBytes.elem;
            if (trailingBytes <= 0L) break block0;
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Found %d invalid bytes at the end of %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)trailingBytes), file.getName()})));
        }
    }

    private Iterator<MessageAndOffset> getIterator(MessageAndOffset messageAndOffset, boolean isDeepIteration) {
        IteratorTemplate<MessageAndOffset> iteratorTemplate;
        if (isDeepIteration) {
            Message message = messageAndOffset.message();
            CompressionCodec compressionCodec = message.compressionCodec();
            IteratorTemplate<MessageAndOffset> iteratorTemplate2 = NoCompressionCodec$.MODULE$.equals(compressionCodec) ? this.getSingleMessageIterator(messageAndOffset) : ByteBufferMessageSet$.MODULE$.deepIterator(messageAndOffset, ByteBufferMessageSet$.MODULE$.deepIterator$default$2());
            iteratorTemplate = iteratorTemplate2;
        } else {
            iteratorTemplate = this.getSingleMessageIterator(messageAndOffset);
        }
        return iteratorTemplate;
    }

    private IteratorTemplate<MessageAndOffset> getSingleMessageIterator(MessageAndOffset messageAndOffset) {
        return new IteratorTemplate<MessageAndOffset>(messageAndOffset){
            private boolean messageIterated;
            private final MessageAndOffset messageAndOffset$1;

            public boolean messageIterated() {
                return this.messageIterated;
            }

            public void messageIterated_$eq(boolean x$1) {
                this.messageIterated = x$1;
            }

            public MessageAndOffset makeNext() {
                MessageAndOffset messageAndOffset;
                if (!this.messageIterated()) {
                    this.messageIterated_$eq(true);
                    messageAndOffset = this.messageAndOffset$1;
                } else {
                    messageAndOffset = (MessageAndOffset)this.allDone();
                }
                return messageAndOffset;
            }
            {
                this.messageAndOffset$1 = messageAndOffset$1;
                this.messageIterated = false;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$main$1(DumpLogSegments$ $this, boolean printDataLog$1, boolean verifyOnly$1, boolean indexSanityOnly$1, int maxMessageSize$1, boolean isDeepIteration$1, DumpLogSegments.MessageParser messageParser$1, HashMap misMatchesForIndexFilesMap$1, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1, HashMap nonConsecutivePairsForLogFilesMap$1, String arg) {
        block1: {
            File file;
            block2: {
                block0: {
                    file = new File(arg);
                    if (!file.getName().endsWith(Log$.MODULE$.LogFileSuffix())) break block0;
                    Predef$.MODULE$.println((Object)("Dumping " + file));
                    $this.dumpLog(file, printDataLog$1, (HashMap<String, List<Tuple2<Object, Object>>>)nonConsecutivePairsForLogFilesMap$1, isDeepIteration$1, maxMessageSize$1, messageParser$1);
                    break block1;
                }
                if (!file.getName().endsWith(Log$.MODULE$.IndexFileSuffix())) break block2;
                Predef$.MODULE$.println((Object)("Dumping " + file));
                $this.dumpIndex(file, indexSanityOnly$1, verifyOnly$1, (HashMap<String, List<Tuple2<Object, Object>>>)misMatchesForIndexFilesMap$1, maxMessageSize$1);
                break block1;
            }
            if (!file.getName().endsWith(Log$.MODULE$.TimeIndexFileSuffix())) break block1;
            Predef$.MODULE$.println((Object)("Dumping " + file));
            $this.dumpTimeIndex(file, indexSanityOnly$1, verifyOnly$1, timeIndexDumpErrors$1, maxMessageSize$1);
        }
    }

    public static final /* synthetic */ void $anonfun$main$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String fileName = (String)tuple2._1();
        List listOfMismatches = (List)tuple2._2();
        System.err.println("Mismatches in :" + fileName);
        listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index offset: %d, log offset: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$main$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String fileName = (String)tuple2._1();
        List listOfNonConsecutivePairs = (List)tuple2._2();
        System.err.println("Non-secutive offsets in :" + fileName);
        listOfNonConsecutivePairs.foreach((Function1 & Serializable & scala.Serializable)m -> {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  %d is followed by %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$dumpTimeIndex$2(TimeIndex timeIndex$1, TimestampOffset entry$1, MessageAndOffset x$1) {
        return x$1.offset() >= entry$1.offset() + timeIndex$1.baseOffset();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$2(File file$1, boolean printContents$1, HashMap nonConsecutivePairsForLogFilesMap$2, DumpLogSegments.MessageParser parser$1, LongRef validBytes$1, LongRef lastOffset$1, MessageAndOffset messageAndOffset) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Message msg = messageAndOffset.message();
        if (lastOffset$1.elem == -1L) {
            lastOffset$1.elem = messageAndOffset.offset();
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            CompressionCodec compressionCodec = msg.compressionCodec();
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) && messageAndOffset.offset() != lastOffset$1.elem + 1L) {
                List nonConsecutivePairsSeq = (List)nonConsecutivePairsForLogFilesMap$2.getOrElse((Object)file$1.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(lastOffset$1.elem, messageAndOffset.offset()));
                boxedUnit2 = nonConsecutivePairsForLogFilesMap$2.put((Object)file$1.getAbsolutePath(), (Object)nonConsecutivePairsSeq);
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        }
        lastOffset$1.elem = messageAndOffset.offset();
        Predef$.MODULE$.print((Object)("offset: " + messageAndOffset.offset() + " position: " + validBytes$1.elem + " " + msg.timestampType() + ": " + msg.timestamp() + " isvalid: " + msg.isValid() + " payloadsize: " + msg.payloadSize() + " magic: " + msg.magic() + " compresscodec: " + msg.compressionCodec() + " crc: " + msg.checksum()));
        if (msg.hasKey()) {
            Predef$.MODULE$.print((Object)(" keysize: " + msg.keySize()));
        }
        if (printContents$1) {
            Tuple2 tuple2 = parser$1.parse(msg);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option key2 = (Option)tuple2._1();
            Option payload2 = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key2, (Object)payload2);
            Tuple2 tuple23 = tuple22;
            Option key3 = (Option)tuple23._1();
            Option payload3 = (Option)tuple23._2();
            key3.map((Function1 & Serializable & scala.Serializable)key -> {
                Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
                return BoxedUnit.UNIT;
            });
            boxedUnit = payload3.map((Function1 & Serializable & scala.Serializable)payload -> {
                Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" payload: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{payload})));
                return BoxedUnit.UNIT;
            });
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$1(DumpLogSegments$ $this, File file$1, boolean printContents$1, HashMap nonConsecutivePairsForLogFilesMap$2, boolean isDeepIteration$2, DumpLogSegments.MessageParser parser$1, LongRef validBytes$1, LongRef lastOffset$1, MessageAndOffset shallowMessageAndOffset) {
        Iterator<MessageAndOffset> itr = $this.getIterator(shallowMessageAndOffset, isDeepIteration$2);
        itr.foreach((Function1 & Serializable & scala.Serializable)messageAndOffset -> {
            DumpLogSegments$.$anonfun$dumpLog$2(file$1, printContents$1, nonConsecutivePairsForLogFilesMap$2, parser$1, validBytes$1, lastOffset$1, messageAndOffset);
            return BoxedUnit.UNIT;
        });
        validBytes$1.elem += (long)MessageSet$.MODULE$.entrySize(shallowMessageAndOffset.message());
    }

    private DumpLogSegments$() {
        MODULE$ = this;
    }
}

