/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.metrics.KafkaMetricsReporter;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.producer.BaseProducer;
import kafka.producer.NewShinyProducer;
import kafka.producer.OldProducer;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.NullEncoder;
import kafka.tools.PerfConfig;
import kafka.tools.ProducerPerformance$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.ToolsUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rUt!B\u0001\u0003\u0011\u00039\u0011a\u0005)s_\u0012,8-\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014!J|G-^2feB+'OZ8s[\u0006t7-Z\n\u0004\u00131\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002\b\u0019><w-\u001b8h\u0011\u0015I\u0012\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0003\u001d\u0013\u0011\u0005Q$\u0001\u0003nC&tGC\u0001\u0010\"!\tiq$\u0003\u0002!\u001d\t!QK\\5u\u0011\u0015\u00113\u00041\u0001$\u0003\u0011\t'oZ:\u0011\u00075!c%\u0003\u0002&\u001d\t)\u0011I\u001d:bsB\u0011qE\f\b\u0003Q1\u0002\"!\u000b\b\u000e\u0003)R!a\u000b\u0004\u0002\rq\u0012xn\u001c;?\u0013\tic\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017\u000f\r\u0011\u0011\u0014\u0002A\u001a\u0003%A\u0013x\u000eZ;dKJ\u0004VM\u001d4D_:4\u0017nZ\n\u0003cQ\u0002\"\u0001C\u001b\n\u0005Y\u0012!A\u0003)fe\u001a\u001cuN\u001c4jO\"A!%\rB\u0001B\u0003%1\u0005C\u0003\u001ac\u0011\u0005\u0011\b\u0006\u0002;yA\u00111(M\u0007\u0002\u0013!)!\u0005\u000fa\u0001G!9a(\rb\u0001\n\u0003y\u0014!\u00042s_.,'\u000fT5ti>\u0003H/F\u0001A!\r\tEIJ\u0007\u0002\u0005*\t1)\u0001\u0006k_B$8/[7qY\u0016L!!\u0012\"\u00037\u0005\u0013x-^7f]R\f5mY3qi&twm\u00149uS>t7\u000b]3d\u0011\u00199\u0015\u0007)A\u0005\u0001\u0006q!M]8lKJd\u0015n\u001d;PaR\u0004\u0003bB%2\u0005\u0004%\taP\u0001\u0012aJ|G-^2fe\u000e{gNZ5h\u001fB$\bBB&2A\u0003%\u0001)\u0001\nqe>$WoY3s\u0007>tg-[4PaR\u0004\u0003bB'2\u0005\u0004%\taP\u0001\ni>\u0004\u0018nY:PaRDaaT\u0019!\u0002\u0013\u0001\u0015A\u0003;pa&\u001c7o\u00149uA!9\u0011+\rb\u0001\n\u0003\u0011\u0016a\u00079s_\u0012,8-\u001a:SKF,Xm\u001d;US6,w.\u001e;Ng>\u0003H/F\u0001T!\r\tE\t\u0016\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bA\u0001\\1oO*\t\u0011,\u0001\u0003kCZ\f\u0017BA.W\u0005\u001dIe\u000e^3hKJDa!X\u0019!\u0002\u0013\u0019\u0016\u0001\b9s_\u0012,8-\u001a:SKF,Xm\u001d;US6,w.\u001e;Ng>\u0003H\u000f\t\u0005\b?F\u0012\r\u0011\"\u0001S\u0003U\u0001(o\u001c3vG\u0016\u0014h*^7SKR\u0014\u0018.Z:PaRDa!Y\u0019!\u0002\u0013\u0019\u0016A\u00069s_\u0012,8-\u001a:Ok6\u0014V\r\u001e:jKN|\u0005\u000f\u001e\u0011\t\u000f\r\f$\u0019!C\u0001%\u0006I\u0002O]8ek\u000e,'OU3uef\u0014\u0015mY6PM\u001al5o\u00149u\u0011\u0019)\u0017\u0007)A\u0005'\u0006Q\u0002O]8ek\u000e,'OU3uef\u0014\u0015mY6PM\u001al5o\u00149uA!9q-\rb\u0001\n\u0003\u0011\u0016A\b9s_\u0012,8-\u001a:SKF,Xm\u001d;SKF,\u0018N]3e\u0003\u000e\\7o\u00149u\u0011\u0019I\u0017\u0007)A\u0005'\u0006y\u0002O]8ek\u000e,'OU3rk\u0016\u001cHOU3rk&\u0014X\rZ!dWN|\u0005\u000f\u001e\u0011\t\u000f-\f$\u0019!C\u0001Y\u0006\u0011b/\u0019:z\u001b\u0016\u001c8/Y4f'&TXm\u00149u+\u0005i\u0007CA!o\u0013\ty'IA\tPaRLwN\\*qK\u000e\u0014U/\u001b7eKJDa!]\u0019!\u0002\u0013i\u0017a\u0005<beflUm]:bO\u0016\u001c\u0016N_3PaR\u0004\u0003bB:2\u0005\u0004%\t\u0001\\\u0001\bgft7m\u00149u\u0011\u0019)\u0018\u0007)A\u0005[\u0006A1/\u001f8d\u001fB$\b\u0005C\u0004xc\t\u0007I\u0011\u0001*\u0002\u001b9,X\u000e\u00165sK\u0006$7o\u00149u\u0011\u0019I\u0018\u0007)A\u0005'\u0006qa.^7UQJ,\u0017\rZ:PaR\u0004\u0003bB>2\u0005\u0004%\tAU\u0001\u0014S:LG/[1m\u001b\u0016\u001c8/Y4f\u0013\u0012|\u0005\u000f\u001e\u0005\u0007{F\u0002\u000b\u0011B*\u0002)%t\u0017\u000e^5bY6+7o]1hK&#w\n\u001d;!\u0011\u001dy\u0018G1A\u0005\u0002I\u000b1#\\3tg\u0006<WmU3oI\u001e\u000b\u0007/T:PaRDq!a\u00012A\u0003%1+\u0001\u000bnKN\u001c\u0018mZ3TK:$w)\u00199Ng>\u0003H\u000f\t\u0005\t\u0003\u000f\t$\u0019!C\u0001Y\u0006a2m\u001d<NKR\u0014\u0018nY:SKB|'\u000f^3s\u000b:\f'\r\\3e\u001fB$\bbBA\u0006c\u0001\u0006I!\\\u0001\u001eGN4X*\u001a;sS\u000e\u001c(+\u001a9peR,'/\u00128bE2,Gm\u00149uA!I\u0011qB\u0019C\u0002\u0013\u0005\u0011\u0011C\u0001\u0014[\u0016$(/[2t\t&\u0014Xm\u0019;pef|\u0005\u000f^\u000b\u0003\u0003'\u0001B!\u0011#\u0002\u0016A\u0019Q+a\u0006\n\u0005=2\u0006\u0002CA\u000ec\u0001\u0006I!a\u0005\u0002)5,GO]5dg\u0012K'/Z2u_JLx\n\u001d;!\u0011!\ty\"\rb\u0001\n\u0003a\u0017!E;tK:+w\u000f\u0015:pIV\u001cWM](qi\"9\u00111E\u0019!\u0002\u0013i\u0017AE;tK:+w\u000f\u0015:pIV\u001cWM](qi\u0002B\u0011\"a\n2\u0005\u0004%\t!!\u000b\u0002\u000f=\u0004H/[8ogV\u0011\u00111\u0006\t\u0004\u0003\u00065\u0012bAA\u0018\u0005\nIq\n\u001d;j_:\u001cV\r\u001e\u0005\t\u0003g\t\u0004\u0015!\u0003\u0002,\u0005Aq\u000e\u001d;j_:\u001c\b\u0005C\u0005\u00028E\u0012\r\u0011\"\u0001\u0002:\u0005IAo\u001c9jGN\u001cFO]\u000b\u0002M!9\u0011QH\u0019!\u0002\u00131\u0013A\u0003;pa&\u001c7o\u0015;sA!I\u0011\u0011I\u0019C\u0002\u0013\u0005\u00111I\u0001\u0007i>\u0004\u0018nY:\u0016\u0005\u0005\u0015\u0003\u0003B\u0007%\u0003+A\u0001\"!\u00132A\u0003%\u0011QI\u0001\bi>\u0004\u0018nY:!\u0011%\ti%\rb\u0001\n\u0003\ty%A\u0006ok6lUm]:bO\u0016\u001cXCAA)!\ri\u00111K\u0005\u0004\u0003+r!\u0001\u0002'p]\u001eD\u0001\"!\u00172A\u0003%\u0011\u0011K\u0001\r]VlW*Z:tC\u001e,7\u000f\t\u0005\n\u0003;\n$\u0019!C\u0001\u0003?\n\u0011C]3q_J$\u0018N\\4J]R,'O^1m+\t\t\t\u0007E\u0002\u000e\u0003GJ1!!\u001a\u000f\u0005\rIe\u000e\u001e\u0005\t\u0003S\n\u0004\u0015!\u0003\u0002b\u0005\u0011\"/\u001a9peRLgnZ%oi\u0016\u0014h/\u00197!\u0011%\ti'\rb\u0001\n\u0003\ty'\u0001\u0006eCR,gi\u001c:nCR,\"!!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001eY\u0003\u0011!X\r\u001f;\n\t\u0005m\u0014Q\u000f\u0002\u0011'&l\u0007\u000f\\3ECR,gi\u001c:nCRD\u0001\"a 2A\u0003%\u0011\u0011O\u0001\fI\u0006$XMR8s[\u0006$\b\u0005C\u0005\u0002\u0004F\u0012\r\u0011\"\u0001\u0002\u0006\u0006Q\u0001.\u001b3f\u0011\u0016\fG-\u001a:\u0016\u0005\u0005\u001d\u0005cA\u0007\u0002\n&\u0019\u00111\u0012\b\u0003\u000f\t{w\u000e\\3b]\"A\u0011qR\u0019!\u0002\u0013\t9)A\u0006iS\u0012,\u0007*Z1eKJ\u0004\u0003\"CAJc\t\u0007I\u0011AA\u001d\u0003)\u0011'o\\6fe2K7\u000f\u001e\u0005\b\u0003/\u000b\u0004\u0015!\u0003'\u0003-\u0011'o\\6fe2K7\u000f\u001e\u0011\t\u0013\u0005m\u0015G1A\u0005\u0002\u0005}\u0013aC7fgN\fw-Z*ju\u0016D\u0001\"a(2A\u0003%\u0011\u0011M\u0001\r[\u0016\u001c8/Y4f'&TX\r\t\u0005\n\u0003G\u000b\u0004\u0019!C\u0001\u0003\u000b\u000b1\"[:GSb,GmU5{K\"I\u0011qU\u0019A\u0002\u0013\u0005\u0011\u0011V\u0001\u0010SN4\u0015\u000e_3e'&TXm\u0018\u0013fcR\u0019a$a+\t\u0015\u00055\u0016QUA\u0001\u0002\u0004\t9)A\u0002yIEB\u0001\"!-2A\u0003&\u0011qQ\u0001\rSN4\u0015\u000e_3e'&TX\r\t\u0005\n\u0003k\u000b\u0004\u0019!C\u0001\u0003\u000b\u000ba![:Ts:\u001c\u0007\"CA]c\u0001\u0007I\u0011AA^\u0003)I7oU=oG~#S-\u001d\u000b\u0004=\u0005u\u0006BCAW\u0003o\u000b\t\u00111\u0001\u0002\b\"A\u0011\u0011Y\u0019!B\u0013\t9)A\u0004jgNKhn\u0019\u0011\t\u0013\u0005\u0015\u0017\u00071A\u0005\u0002\u0005}\u0013!\u00032bi\u000eD7+\u001b>f\u0011%\tI-\ra\u0001\n\u0003\tY-A\u0007cCR\u001c\u0007nU5{K~#S-\u001d\u000b\u0004=\u00055\u0007BCAW\u0003\u000f\f\t\u00111\u0001\u0002b!A\u0011\u0011[\u0019!B\u0013\t\t'\u0001\u0006cCR\u001c\u0007nU5{K\u0002B\u0011\"!62\u0001\u0004%\t!a\u0018\u0002\u00159,X\u000e\u00165sK\u0006$7\u000fC\u0005\u0002ZF\u0002\r\u0011\"\u0001\u0002\\\u0006qa.^7UQJ,\u0017\rZ:`I\u0015\fHc\u0001\u0010\u0002^\"Q\u0011QVAl\u0003\u0003\u0005\r!!\u0019\t\u0011\u0005\u0005\u0018\u0007)Q\u0005\u0003C\n1B\\;n)\"\u0014X-\u00193tA!I\u0011Q]\u0019C\u0002\u0013\u0005\u0011q]\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e,\"!!;\u0011\t\u0005-\u0018\u0011_\u0007\u0003\u0003[T1!a<\u0005\u0003\u001diWm]:bO\u0016LA!a=\u0002n\n\u00012i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0005\t\u0003o\f\u0004\u0015!\u0003\u0002j\u0006\t2m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0011\t\u0013\u0005m\u0018G1A\u0005\u0002\u0005\u0015\u0015!C:fc&#Wj\u001c3f\u0011!\ty0\rQ\u0001\n\u0005\u001d\u0015AC:fc&#Wj\u001c3fA!I!1A\u0019A\u0002\u0013\u0005\u0011qL\u0001\u0011S:LG/[1m\u001b\u0016\u001c8/Y4f\u0013\u0012D\u0011Ba\u00022\u0001\u0004%\tA!\u0003\u0002)%t\u0017\u000e^5bY6+7o]1hK&#w\fJ3r)\rq\"1\u0002\u0005\u000b\u0003[\u0013)!!AA\u0002\u0005\u0005\u0004\u0002\u0003B\bc\u0001\u0006K!!\u0019\u0002#%t\u0017\u000e^5bY6+7o]1hK&#\u0007\u0005C\u0005\u0003\u0014E\u0012\r\u0011\"\u0001\u0002`\u0005A\u0002O]8ek\u000e,'OU3rk\u0016\u001cH\u000fV5nK>,H/T:\t\u0011\t]\u0011\u0007)A\u0005\u0003C\n\u0011\u0004\u001d:pIV\u001cWM\u001d*fcV,7\u000f\u001e+j[\u0016|W\u000f^'tA!I!1D\u0019C\u0002\u0013\u0005\u0011qL\u0001\u001caJ|G-^2feJ+\u0017/^3tiJ+\u0017/^5sK\u0012\f5m[:\t\u0011\t}\u0011\u0007)A\u0005\u0003C\nA\u0004\u001d:pIV\u001cWM\u001d*fcV,7\u000f\u001e*fcVL'/\u001a3BG.\u001c\b\u0005C\u0005\u0003$E\u0012\r\u0011\"\u0001\u0002`\u0005\u0011\u0002O]8ek\u000e,'OT;n%\u0016$(/[3t\u0011!\u00119#\rQ\u0001\n\u0005\u0005\u0014a\u00059s_\u0012,8-\u001a:Ok6\u0014V\r\u001e:jKN\u0004\u0003\"\u0003B\u0016c\t\u0007I\u0011AA0\u0003Y\u0001(o\u001c3vG\u0016\u0014(+\u001a;ss\n\u000b7m[8gM6\u001b\b\u0002\u0003B\u0018c\u0001\u0006I!!\u0019\u0002/A\u0014x\u000eZ;dKJ\u0014V\r\u001e:z\u0005\u0006\u001c7n\u001c4g\u001bN\u0004\u0003\"\u0003B\u001ac\t\u0007I\u0011AAC\u00039)8/\u001a(foB\u0013x\u000eZ;dKJD\u0001Ba\u000e2A\u0003%\u0011qQ\u0001\u0010kN,g*Z<Qe>$WoY3sA!I!1H\u0019C\u0002\u0013\u0005\u0011QQ\u0001\u001aGN4X*\u001a;sS\u000e\u001c(+\u001a9peR,'/\u00128bE2,G\r\u0003\u0005\u0003@E\u0002\u000b\u0011BAD\u0003i\u00197O^'fiJL7m\u001d*fa>\u0014H/\u001a:F]\u0006\u0014G.\u001a3!\u0011%\u0011\u0019%\rb\u0001\n\u0003\u0011)%A\u0007qe>$WoY3s!J|\u0007o]\u000b\u0003\u0005\u000f\u0002BA!\u0013\u0003P5\u0011!1\n\u0006\u0004\u0005\u001bB\u0016\u0001B;uS2LAA!\u0015\u0003L\tQ\u0001K]8qKJ$\u0018.Z:\t\u0011\tU\u0013\u0007)A\u0005\u0005\u000f\na\u0002\u001d:pIV\u001cWM\u001d)s_B\u001c\b\u0005C\u0005\u0003ZE\u0012\r\u0011\"\u0001\u0002`\u0005\u0001R.Z:tC\u001e,7+\u001a8e\u000f\u0006\u0004Xj\u001d\u0005\t\u0005;\n\u0004\u0015!\u0003\u0002b\u0005\tR.Z:tC\u001e,7+\u001a8e\u000f\u0006\u0004Xj\u001d\u0011\u0007\r\t\u0005\u0014\u0002\u0001B2\u00059\u0001&o\u001c3vG\u0016\u0014H\u000b\u001b:fC\u0012\u001cbAa\u0018\u0003f\t-\u0004cA+\u0003h%\u0019!\u0011\u000e,\u0003\r=\u0013'.Z2u!\r)&QN\u0005\u0004\u0005_2&\u0001\u0003*v]:\f'\r\\3\t\u0017\tM$q\fBC\u0002\u0013\u0005\u0011qL\u0001\ti\"\u0014X-\u00193JI\"Y!q\u000fB0\u0005\u0003\u0005\u000b\u0011BA1\u0003%!\bN]3bI&#\u0007\u0005C\u0006\u0003|\t}#Q1A\u0005\u0002\tu\u0014AB2p]\u001aLw-F\u0001;\u0011)\u0011\tIa\u0018\u0003\u0002\u0003\u0006IAO\u0001\bG>tg-[4!\u0011-\u0011)Ia\u0018\u0003\u0006\u0004%\tAa\"\u0002\u001dQ|G/\u00197CsR,7oU3oiV\u0011!\u0011\u0012\t\u0005\u0005\u0017\u0013)*\u0004\u0002\u0003\u000e*!!q\u0012BI\u0003\u0019\tGo\\7jG*!!1\u0013B&\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005/\u0013iI\u0001\u0006Bi>l\u0017n\u0019'p]\u001eD1Ba'\u0003`\t\u0005\t\u0015!\u0003\u0003\n\u0006yAo\u001c;bY\nKH/Z:TK:$\b\u0005C\u0006\u0003 \n}#Q1A\u0005\u0002\t\u001d\u0015!\u0005;pi\u0006dW*Z:tC\u001e,7oU3oi\"Y!1\u0015B0\u0005\u0003\u0005\u000b\u0011\u0002BE\u0003I!x\u000e^1m\u001b\u0016\u001c8/Y4fgN+g\u000e\u001e\u0011\t\u0017\t\u001d&q\fBC\u0002\u0013\u0005!\u0011V\u0001\bC2dGi\u001c8f+\t\u0011Y\u000b\u0005\u0003\u0003.\n=VB\u0001BI\u0013\u0011\u0011\tL!%\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\"Y!Q\u0017B0\u0005\u0003\u0005\u000b\u0011\u0002BV\u0003!\tG\u000e\u001c#p]\u0016\u0004\u0003b\u0003B]\u0005?\u0012)\u0019!C\u0001\u0005w\u000bAA]1oIV\u0011!Q\u0018\t\u0005\u0005\u0013\u0012y,\u0003\u0003\u0003B\n-#A\u0002*b]\u0012|W\u000eC\u0006\u0003F\n}#\u0011!Q\u0001\n\tu\u0016!\u0002:b]\u0012\u0004\u0003bB\r\u0003`\u0011\u0005!\u0011\u001a\u000b\u000f\u0005\u0017\u0014iMa4\u0003R\nM'Q\u001bBl!\rY$q\f\u0005\t\u0005g\u00129\r1\u0001\u0002b!9!1\u0010Bd\u0001\u0004Q\u0004\u0002\u0003BC\u0005\u000f\u0004\rA!#\t\u0011\t}%q\u0019a\u0001\u0005\u0013C\u0001Ba*\u0003H\u0002\u0007!1\u0016\u0005\t\u0005s\u00139\r1\u0001\u0003>\"Q!1\u001cB0\u0005\u0004%\t!a\u0018\u0002\u001bM,\u0017/\u00133Ok6$\u0015nZ5u\u0011%\u0011yNa\u0018!\u0002\u0013\t\t'\u0001\btKFLEMT;n\t&<\u0017\u000e\u001e\u0011\t\u0015\t\r(q\fb\u0001\n\u0003\ty%A\tnKN\u001c\u0018mZ3t!\u0016\u0014H\u000b\u001b:fC\u0012D\u0011Ba:\u0003`\u0001\u0006I!!\u0015\u0002%5,7o]1hKN\u0004VM\u001d+ie\u0016\fG\r\t\u0005\u000b\u0005W\u0014yF1A\u0005\u0002\t\u0015\u0013!\u00029s_B\u001c\b\"\u0003Bx\u0005?\u0002\u000b\u0011\u0002B$\u0003\u0019\u0001(o\u001c9tA!Q!1\u001fB0\u0005\u0004%\tA!>\u0002\u0011A\u0014x\u000eZ;dKJ,\"Aa>\u0011\t\te(Q`\u0007\u0003\u0005wT1Aa=\u0005\u0013\u0011\u0011yPa?\u0003\u0019\t\u000b7/\u001a)s_\u0012,8-\u001a:\t\u0013\r\r!q\fQ\u0001\n\t]\u0018!\u00039s_\u0012,8-\u001a:!\u0011)\u00199Aa\u0018C\u0002\u0013%1\u0011B\u0001\u0004'\u0016\u0003VCAA\u000b\u0011%\u0019iAa\u0018!\u0002\u0013\t)\"\u0001\u0003T\u000bB\u0003\u0003BCB\t\u0005?\u0012\r\u0011\"\u0003\u0004\n\u0005qQ.Z:tC\u001e,\u0017\n\u001a'bE\u0016d\u0007\"CB\u000b\u0005?\u0002\u000b\u0011BA\u000b\u0003=iWm]:bO\u0016LE\rT1cK2\u0004\u0003BCB\r\u0005?\u0012\r\u0011\"\u0003\u0004\n\u0005iA\u000f\u001b:fC\u0012LE\rT1cK2D\u0011b!\b\u0003`\u0001\u0006I!!\u0006\u0002\u001dQD'/Z1e\u0013\u0012d\u0015MY3mA!Q1\u0011\u0005B0\u0005\u0004%Ia!\u0003\u0002\u0015Q|\u0007/[2MC\n,G\u000eC\u0005\u0004&\t}\u0003\u0015!\u0003\u0002\u0016\u0005YAo\u001c9jG2\u000b'-\u001a7!\u0011)\u0019ICa\u0018A\u0002\u0013%\u0011\u0011H\u0001\u0010Y\u00164G\u000fU1eI\u0016$7+Z9JI\"Q1Q\u0006B0\u0001\u0004%Iaa\f\u0002'1,g\r\u001e)bI\u0012,GmU3r\u0013\u0012|F%Z9\u0015\u0007y\u0019\t\u0004C\u0005\u0002.\u000e-\u0012\u0011!a\u0001M!A1Q\u0007B0A\u0003&a%\u0001\tmK\u001a$\b+\u00193eK\u0012\u001cV-]%eA!A1\u0011\bB0\t\u0013\u0019Y$\u0001\rhK:,'/\u0019;f\u001b\u0016\u001c8/Y4f/&$\bnU3r\u0013\u0012$\u0002b!\u0010\u0004F\r%3Q\n\t\u0005\u001b\u0011\u001ay\u0004E\u0002\u000e\u0007\u0003J1aa\u0011\u000f\u0005\u0011\u0011\u0015\u0010^3\t\u000f\r\u001d3q\u0007a\u0001M\u0005)Ao\u001c9jG\"A11JB\u001c\u0001\u0004\t\t&A\u0003ng\u001eLE\r\u0003\u0005\u0004P\r]\u0002\u0019AA1\u0003\u001di7oZ*ju\u0016D\u0001ba\u0015\u0003`\u0011%1QK\u0001\u0015O\u0016tWM]1uKB\u0013x\u000eZ;dKJ$\u0015\r^1\u0015\r\ru2qKB-\u0011\u001d\u00199e!\u0015A\u0002\u0019B\u0001ba\u0017\u0004R\u0001\u0007\u0011\u0011K\u0001\n[\u0016\u001c8/Y4f\u0013\u0012D\u0001ba\u0018\u0003`\u0011\u00053\u0011M\u0001\u0004eVtG#\u0001\u0010)\u000f%\u0019)ga\u001b\u0004pA\u0019Qba\u001a\n\u0007\r%dB\u0001\u0006eKB\u0014XmY1uK\u0012\f#a!\u001c\u0002eRC\u0017n\u001d\u0011dY\u0006\u001c8\u000fI<jY2\u0004#-\u001a\u0011sKBd\u0017mY3eA\tL\be\u001c:h]\u0005\u0004\u0018m\u00195f]-\fgm[1/i>|Gn\u001d\u0018Qe>$WoY3s!\u0016\u0014hm\u001c:nC:\u001cW\rI1gi\u0016\u0014\b\u0005\u001e5fA=dG\r\t9s_\u0012,8-\u001a:!G2LWM\u001c;!SN\u0004#/Z7pm\u0016$\u0017EAB9\u0003\u001d\u0001d&\u000f\u00181]ABs\u0001AB3\u0007W\u001ay\u0007")
public final class ProducerPerformance {
    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.fatal(function0, function02);
    }

    public static Object fatal(Function0<Throwable> function0) {
        return ProducerPerformance$.MODULE$.fatal(function0);
    }

    public static void fatal(Function0<String> function0) {
        ProducerPerformance$.MODULE$.fatal(function0);
    }

    public static void swallowError(Function0<BoxedUnit> function0) {
        ProducerPerformance$.MODULE$.swallowError(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.error(function0, function02);
    }

    public static Object error(Function0<Throwable> function0) {
        return ProducerPerformance$.MODULE$.error(function0);
    }

    public static void error(Function0<String> function0) {
        ProducerPerformance$.MODULE$.error(function0);
    }

    public static void swallow(Function0<BoxedUnit> function0) {
        ProducerPerformance$.MODULE$.swallow(function0);
    }

    public static void swallowWarn(Function0<BoxedUnit> function0) {
        ProducerPerformance$.MODULE$.swallowWarn(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.warn(function0, function02);
    }

    public static Object warn(Function0<Throwable> function0) {
        return ProducerPerformance$.MODULE$.warn(function0);
    }

    public static void warn(Function0<String> function0) {
        ProducerPerformance$.MODULE$.warn(function0);
    }

    public static void swallowInfo(Function0<BoxedUnit> function0) {
        ProducerPerformance$.MODULE$.swallowInfo(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.info(function0, function02);
    }

    public static Object info(Function0<Throwable> function0) {
        return ProducerPerformance$.MODULE$.info(function0);
    }

    public static void info(Function0<String> function0) {
        ProducerPerformance$.MODULE$.info(function0);
    }

    public static void swallowDebug(Function0<BoxedUnit> function0) {
        ProducerPerformance$.MODULE$.swallowDebug(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.debug(function0, function02);
    }

    public static Object debug(Function0<Throwable> function0) {
        return ProducerPerformance$.MODULE$.debug(function0);
    }

    public static void debug(Function0<String> function0) {
        ProducerPerformance$.MODULE$.debug(function0);
    }

    public static boolean isDebugEnabled() {
        return ProducerPerformance$.MODULE$.isDebugEnabled();
    }

    public static void swallowTrace(Function0<BoxedUnit> function0) {
        ProducerPerformance$.MODULE$.swallowTrace(function0);
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.trace(function0, function02);
    }

    public static Object trace(Function0<Throwable> function0) {
        return ProducerPerformance$.MODULE$.trace(function0);
    }

    public static void trace(Function0<String> function0) {
        ProducerPerformance$.MODULE$.trace(function0);
    }

    public static Logger logger() {
        return ProducerPerformance$.MODULE$.logger();
    }

    public static String loggerName() {
        return ProducerPerformance$.MODULE$.loggerName();
    }

    public static void main(String[] stringArray) {
        ProducerPerformance$.MODULE$.main(stringArray);
    }

    public static String logIdent() {
        return ProducerPerformance$.MODULE$.logIdent();
    }

    public static class ProducerPerfConfig
    extends PerfConfig {
        private final ArgumentAcceptingOptionSpec<String> brokerListOpt = this.parser().accepts("broker-list", "REQUIRED: broker info the list of broker host and port for bootstrap.").withRequiredArg().describedAs("hostname:port,..,hostname:port").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> producerConfigOpt = this.parser().accepts("producer.config", "Producer config properties file.").withRequiredArg().describedAs("config file").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicsOpt = this.parser().accepts("topics", "REQUIRED: The comma separated list of topics to produce to").withRequiredArg().describedAs("topic1,topic2..").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> producerRequestTimeoutMsOpt = this.parser().accepts("request-timeout-ms", "The producer request timeout in ms").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(3000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> producerNumRetriesOpt = this.parser().accepts("producer-num-retries", "The producer retries number").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(3), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> producerRetryBackOffMsOpt = this.parser().accepts("producer-retry-backoff-ms", "The producer retry backoff time in milliseconds").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> producerRequestRequiredAcksOpt = this.parser().accepts("request-num-acks", "Number of acks required for producer request to complete").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(-1), (Object[])new Integer[0]);
        private final OptionSpecBuilder varyMessageSizeOpt = this.parser().accepts("vary-message-size", "If set, message size will vary up to the given maximum.");
        private final OptionSpecBuilder syncOpt = this.parser().accepts("sync", "If set, messages are sent synchronously.");
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of sending threads.").withRequiredArg().describedAs("number of threads").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> initialMessageIdOpt = this.parser().accepts("initial-message-id", "The is used for generating test data, If set, messages will be tagged with an ID and sent by producer starting from this ID sequentially. Message content will be String type and in the form of 'Message:000...1:xxx...'").withRequiredArg().describedAs("initial message id").ofType(Integer.class);
        private final ArgumentAcceptingOptionSpec<Integer> messageSendGapMsOpt = this.parser().accepts("message-send-gap-ms", "If set, the send thread will wait for specified time between two sends").withRequiredArg().describedAs("message send time gap").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
        private final OptionSpecBuilder csvMetricsReporterEnabledOpt = this.parser().accepts("csv-reporter-enabled", "If set, the CSV metrics reporter will be enabled");
        private final ArgumentAcceptingOptionSpec<String> metricsDirectoryOpt = this.parser().accepts("metrics-dir", "If csv-reporter-enable is set, and this parameter isset, the csv metrics will be outputted here").withRequiredArg().describedAs("metrics directory").ofType(String.class);
        private final OptionSpecBuilder useNewProducerOpt = this.parser().accepts("new-producer", "Use the new producer implementation.");
        private final OptionSet options;
        private final String topicsStr;
        private final String[] topics;
        private final long numMessages;
        private final int reportingInterval;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;
        private final String brokerList;
        private final int messageSize;
        private boolean isFixedSize;
        private boolean isSync;
        private int batchSize;
        private int numThreads;
        private final CompressionCodec compressionCodec;
        private final boolean seqIdMode;
        private int initialMessageId;
        private final int producerRequestTimeoutMs;
        private final int producerRequestRequiredAcks;
        private final int producerNumRetries;
        private final int producerRetryBackoffMs;
        private final boolean useNewProducer;
        private final boolean csvMetricsReporterEnabled;
        private final Properties producerProps;
        private final int messageSendGapMs;

        public ArgumentAcceptingOptionSpec<String> brokerListOpt() {
            return this.brokerListOpt;
        }

        public ArgumentAcceptingOptionSpec<String> producerConfigOpt() {
            return this.producerConfigOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicsOpt() {
            return this.topicsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> producerRequestTimeoutMsOpt() {
            return this.producerRequestTimeoutMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> producerNumRetriesOpt() {
            return this.producerNumRetriesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> producerRetryBackOffMsOpt() {
            return this.producerRetryBackOffMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> producerRequestRequiredAcksOpt() {
            return this.producerRequestRequiredAcksOpt;
        }

        public OptionSpecBuilder varyMessageSizeOpt() {
            return this.varyMessageSizeOpt;
        }

        public OptionSpecBuilder syncOpt() {
            return this.syncOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> initialMessageIdOpt() {
            return this.initialMessageIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> messageSendGapMsOpt() {
            return this.messageSendGapMsOpt;
        }

        public OptionSpecBuilder csvMetricsReporterEnabledOpt() {
            return this.csvMetricsReporterEnabledOpt;
        }

        public ArgumentAcceptingOptionSpec<String> metricsDirectoryOpt() {
            return this.metricsDirectoryOpt;
        }

        public OptionSpecBuilder useNewProducerOpt() {
            return this.useNewProducerOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public String topicsStr() {
            return this.topicsStr;
        }

        public String[] topics() {
            return this.topics;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public String brokerList() {
            return this.brokerList;
        }

        public int messageSize() {
            return this.messageSize;
        }

        public boolean isFixedSize() {
            return this.isFixedSize;
        }

        public void isFixedSize_$eq(boolean x$1) {
            this.isFixedSize = x$1;
        }

        public boolean isSync() {
            return this.isSync;
        }

        public void isSync_$eq(boolean x$1) {
            this.isSync = x$1;
        }

        public int batchSize() {
            return this.batchSize;
        }

        public void batchSize_$eq(int x$1) {
            this.batchSize = x$1;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public void numThreads_$eq(int x$1) {
            this.numThreads = x$1;
        }

        public CompressionCodec compressionCodec() {
            return this.compressionCodec;
        }

        public boolean seqIdMode() {
            return this.seqIdMode;
        }

        public int initialMessageId() {
            return this.initialMessageId;
        }

        public void initialMessageId_$eq(int x$1) {
            this.initialMessageId = x$1;
        }

        public int producerRequestTimeoutMs() {
            return this.producerRequestTimeoutMs;
        }

        public int producerRequestRequiredAcks() {
            return this.producerRequestRequiredAcks;
        }

        public int producerNumRetries() {
            return this.producerNumRetries;
        }

        public int producerRetryBackoffMs() {
            return this.producerRetryBackoffMs;
        }

        public boolean useNewProducer() {
            return this.useNewProducer;
        }

        public boolean csvMetricsReporterEnabled() {
            return this.csvMetricsReporterEnabled;
        }

        public Properties producerProps() {
            return this.producerProps;
        }

        public int messageSendGapMs() {
            return this.messageSendGapMs;
        }

        public ProducerPerfConfig(String[] args) {
            super(args);
            Seq<KafkaMetricsReporter> seq;
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicsOpt(), this.brokerListOpt(), this.numMessagesOpt()}));
            this.topicsStr = (String)this.options().valueOf(this.topicsOpt());
            this.topics = this.topicsStr().split(",");
            this.numMessages = (Long)this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            this.dateFormat = new SimpleDateFormat((String)this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has((OptionSpec)this.hideHeaderOpt());
            this.brokerList = (String)this.options().valueOf(this.brokerListOpt());
            ToolsUtils$.MODULE$.validatePortOrDie(this.parser(), this.brokerList());
            this.messageSize = (Integer)this.options().valueOf(this.messageSizeOpt());
            this.isFixedSize = !this.options().has((OptionSpec)this.varyMessageSizeOpt());
            this.isSync = this.options().has((OptionSpec)this.syncOpt());
            this.batchSize = (Integer)this.options().valueOf(this.batchSizeOpt());
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.compressionCodec = CompressionCodec$.MODULE$.getCompressionCodec((Integer)this.options().valueOf(this.compressionCodecOpt()));
            this.seqIdMode = this.options().has(this.initialMessageIdOpt());
            this.initialMessageId = 0;
            if (this.seqIdMode()) {
                this.initialMessageId_$eq((Integer)this.options().valueOf(this.initialMessageIdOpt()));
            }
            this.producerRequestTimeoutMs = (Integer)this.options().valueOf(this.producerRequestTimeoutMsOpt());
            this.producerRequestRequiredAcks = (Integer)this.options().valueOf(this.producerRequestRequiredAcksOpt());
            this.producerNumRetries = (Integer)this.options().valueOf(this.producerNumRetriesOpt());
            this.producerRetryBackoffMs = (Integer)this.options().valueOf(this.producerRetryBackOffMsOpt());
            this.useNewProducer = this.options().has((OptionSpec)this.useNewProducerOpt());
            this.csvMetricsReporterEnabled = this.options().has((OptionSpec)this.csvMetricsReporterEnabledOpt());
            Properties properties = this.producerProps = this.options().has(this.producerConfigOpt()) ? Utils.loadProps((String)((String)this.options().valueOf(this.producerConfigOpt()))) : new Properties();
            if (this.csvMetricsReporterEnabled()) {
                Properties props = new Properties();
                props.put("kafka.metrics.polling.interval.secs", "1");
                props.put("kafka.metrics.reporters", "kafka.metrics.KafkaCSVMetricsReporter");
                Object object = this.options().has(this.metricsDirectoryOpt()) ? props.put("kafka.csv.metrics.dir", this.options().valueOf(this.metricsDirectoryOpt())) : props.put("kafka.csv.metrics.dir", "kafka_metrics");
                props.put("kafka.csv.metrics.reporter.enabled", "true");
                VerifiableProperties verifiableProps = new VerifiableProperties(props);
                seq = KafkaMetricsReporter$.MODULE$.startReporters(verifiableProps);
            } else {
                seq = BoxedUnit.UNIT;
            }
            this.messageSendGapMs = (Integer)this.options().valueOf(this.messageSendGapMsOpt());
        }
    }

    public static class ProducerThread
    implements Runnable {
        private final int threadId;
        private final ProducerPerfConfig config;
        private final AtomicLong totalBytesSent;
        private final AtomicLong totalMessagesSent;
        private final CountDownLatch allDone;
        private final Random rand;
        private final int seqIdNumDigit;
        private final long messagesPerThread;
        private final Properties props;
        private final BaseProducer producer;
        private final String SEP;
        private final String messageIdLabel;
        private final String threadIdLabel;
        private final String topicLabel;
        private String leftPaddedSeqId;

        public int threadId() {
            return this.threadId;
        }

        public ProducerPerfConfig config() {
            return this.config;
        }

        public AtomicLong totalBytesSent() {
            return this.totalBytesSent;
        }

        public AtomicLong totalMessagesSent() {
            return this.totalMessagesSent;
        }

        public CountDownLatch allDone() {
            return this.allDone;
        }

        public Random rand() {
            return this.rand;
        }

        public int seqIdNumDigit() {
            return this.seqIdNumDigit;
        }

        public long messagesPerThread() {
            return this.messagesPerThread;
        }

        public Properties props() {
            return this.props;
        }

        public BaseProducer producer() {
            return this.producer;
        }

        private String SEP() {
            return this.SEP;
        }

        private String messageIdLabel() {
            return this.messageIdLabel;
        }

        private String threadIdLabel() {
            return this.threadIdLabel;
        }

        private String topicLabel() {
            return this.topicLabel;
        }

        private String leftPaddedSeqId() {
            return this.leftPaddedSeqId;
        }

        private void leftPaddedSeqId_$eq(String x$1) {
            this.leftPaddedSeqId = x$1;
        }

        private byte[] generateMessageWithSeqId(String topic, long msgId, int msgSize) {
            this.leftPaddedSeqId_$eq(String.format("%0" + this.seqIdNumDigit() + "d", Predef$.MODULE$.long2Long(msgId)));
            String msgHeader = this.topicLabel() + this.SEP() + topic + this.SEP() + this.threadIdLabel() + this.SEP() + this.threadId() + this.SEP() + this.messageIdLabel() + this.SEP() + this.leftPaddedSeqId() + this.SEP();
            String seqMsgString = String.format("%1$-" + msgSize + "s", msgHeader).replace(' ', 'x');
            ProducerPerformance$.MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> seqMsgString);
            return seqMsgString.getBytes();
        }

        private byte[] generateProducerData(String topic, long messageId) {
            byte[] byArray;
            int msgSize;
            int n = msgSize = this.config().isFixedSize() ? this.config().messageSize() : 1 + this.rand().nextInt(this.config().messageSize());
            if (this.config().seqIdMode()) {
                long seqId = (long)this.config().initialMessageId() + this.messagesPerThread() * (long)this.threadId() + messageId;
                byArray = this.generateMessageWithSeqId(topic, seqId, msgSize);
            } else {
                byArray = new byte[msgSize];
            }
            return byArray;
        }

        @Override
        public void run() {
            LongRef bytesSent = LongRef.create((long)0L);
            IntRef nSends = IntRef.create((int)0);
            LongRef i = LongRef.create((long)0L);
            ObjectRef message = ObjectRef.create(null);
            while (i.elem < this.messagesPerThread()) {
                try {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.config().topics())).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                        ProducerThread.$anonfun$run$1(this, bytesSent, nSends, i, message, topic);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable e) {
                    ProducerPerformance$.MODULE$.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error when sending message " + new String((byte[])message$1.elem), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                ++i.elem;
            }
            try {
                this.producer().close();
            }
            catch (Throwable e) {
                ProducerPerformance$.MODULE$.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error when closing producer", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
            this.totalBytesSent().addAndGet(bytesSent.elem);
            this.totalMessagesSent().addAndGet(nSends.elem);
            this.allDone().countDown();
        }

        public static final /* synthetic */ void $anonfun$run$1(ProducerThread $this, LongRef bytesSent$1, IntRef nSends$1, LongRef i$1, ObjectRef message$1, String topic) {
            block0: {
                message$1.elem = $this.generateProducerData(topic, i$1.elem);
                $this.producer().send(topic, BigInteger.valueOf(i$1.elem).toByteArray(), (byte[])message$1.elem);
                bytesSent$1.elem += (long)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])message$1.elem)).size();
                ++nSends$1.elem;
                if ($this.config().messageSendGapMs() <= 0) break block0;
                Thread.sleep($this.config().messageSendGapMs());
            }
        }

        public ProducerThread(int threadId, ProducerPerfConfig config, AtomicLong totalBytesSent, AtomicLong totalMessagesSent, CountDownLatch allDone, Random rand) {
            BaseProducer baseProducer;
            this.threadId = threadId;
            this.config = config;
            this.totalBytesSent = totalBytesSent;
            this.totalMessagesSent = totalMessagesSent;
            this.allDone = allDone;
            this.rand = rand;
            this.seqIdNumDigit = 10;
            this.messagesPerThread = config.numMessages() / (long)config.numThreads();
            ProducerPerformance$.MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Messages per thread = " + this.messagesPerThread());
            this.props = new Properties();
            if (config.useNewProducer()) {
                this.props().putAll((Map<?, ?>)config.producerProps());
                this.props().put("bootstrap.servers", config.brokerList());
                this.props().put("send.buffer.bytes", ((Object)BoxesRunTime.boxToInteger((int)65536)).toString());
                this.props().put("client.id", "producer-performance");
                this.props().put("acks", ((Object)BoxesRunTime.boxToInteger((int)config.producerRequestRequiredAcks())).toString());
                this.props().put("retries", ((Object)BoxesRunTime.boxToInteger((int)config.producerNumRetries())).toString());
                this.props().put("retry.backoff.ms", ((Object)BoxesRunTime.boxToInteger((int)config.producerRetryBackoffMs())).toString());
                this.props().put("compression.type", config.compressionCodec().name());
                this.props().put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
                this.props().put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
                baseProducer = new NewShinyProducer(this.props());
            } else {
                Object object;
                this.props().putAll((Map<?, ?>)config.producerProps());
                this.props().put("metadata.broker.list", config.brokerList());
                this.props().put("compression.codec", ((Object)BoxesRunTime.boxToInteger((int)config.compressionCodec().codec())).toString());
                this.props().put("send.buffer.bytes", ((Object)BoxesRunTime.boxToInteger((int)65536)).toString());
                if (!config.isSync()) {
                    this.props().put("producer.type", "async");
                    this.props().put("batch.num.messages", ((Object)BoxesRunTime.boxToInteger((int)config.batchSize())).toString());
                    object = this.props().put("queue.enqueue.timeout.ms", "-1");
                } else {
                    object = BoxedUnit.UNIT;
                }
                this.props().put("client.id", "producer-performance");
                this.props().put("request.required.acks", ((Object)BoxesRunTime.boxToInteger((int)config.producerRequestRequiredAcks())).toString());
                this.props().put("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)config.producerRequestTimeoutMs())).toString());
                this.props().put("message.send.max.retries", ((Object)BoxesRunTime.boxToInteger((int)config.producerNumRetries())).toString());
                this.props().put("retry.backoff.ms", ((Object)BoxesRunTime.boxToInteger((int)config.producerRetryBackoffMs())).toString());
                this.props().put("serializer.class", DefaultEncoder.class.getName());
                this.props().put("key.serializer.class", NullEncoder.class.getName());
                baseProducer = new OldProducer(this.props());
            }
            this.producer = baseProducer;
            this.SEP = ":";
            this.messageIdLabel = "MessageID";
            this.threadIdLabel = "ThreadID";
            this.topicLabel = "Topic";
            this.leftPaddedSeqId = "";
        }
    }
}

