/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.WeightedVector;
import org.apache.mahout.math.function.Functions;

public class Centroid
extends WeightedVector {
    public Centroid(WeightedVector original) {
        super(original.getVector().like().assign(original), original.getWeight(), original.getIndex());
    }

    public Centroid(int key, Vector initialValue) {
        super(initialValue, 1.0, key);
    }

    public Centroid(int key, Vector initialValue, double weight) {
        super(initialValue, weight, key);
    }

    public static Centroid create(int key, Vector initialValue) {
        if (initialValue instanceof WeightedVector) {
            return new Centroid(key, (Vector)new DenseVector(initialValue), ((WeightedVector)initialValue).getWeight());
        }
        return new Centroid(key, (Vector)new DenseVector(initialValue), 1.0);
    }

    public void update(Vector v) {
        if (v instanceof Centroid) {
            Centroid c = (Centroid)v;
            this.update(c.delegate, c.getWeight());
        } else {
            this.update(v, 1.0);
        }
    }

    public void update(Vector other, double wy) {
        double wx = this.getWeight();
        this.delegate.assign(other, Functions.reweigh(wx, wy));
        this.setWeight(wx + wy);
    }

    @Override
    public Centroid like() {
        return new Centroid(this.getIndex(), this.getVector().like(), this.getWeight());
    }

    @Deprecated
    public int getKey() {
        return this.getIndex();
    }

    public void addWeight(double newWeight) {
        this.setWeight(this.getWeight() + newWeight);
    }

    @Override
    public String toString() {
        return String.format("key = %d, weight = %.2f, vector = %s", this.getIndex(), this.getWeight(), this.delegate);
    }

    @Override
    public Centroid clone() {
        return new Centroid(this);
    }
}

