/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

final class DeltaList<E extends Comparable<E>> {
    private final Set<E> added = new TreeSet();
    private final Set<E> removed = new TreeSet();
    private final boolean hasChanged;

    DeltaList(Collection<E> oldList, Collection<E> newList) {
        for (Comparable newListItem : newList) {
            if (oldList.contains(newListItem)) continue;
            this.added.add(newListItem);
        }
        for (Comparable oldListItem : oldList) {
            if (newList.contains(oldListItem)) continue;
            this.removed.add(oldListItem);
        }
        this.hasChanged = !this.added.isEmpty() || !this.removed.isEmpty();
    }

    Collection<E> getAdded() {
        return Collections.unmodifiableCollection(this.added);
    }

    Collection<E> getRemoved() {
        return Collections.unmodifiableCollection(this.removed);
    }

    boolean hasChanged() {
        return this.hasChanged;
    }
}

