/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.checksum.DefaultChecksumAlgorithmFactorySelector;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named(value="maven2")
public final class Maven2RepositoryLayoutFactory
implements RepositoryLayoutFactory {
    public static final String NAME = "maven2";
    public static final String CONFIG_PROP_CHECKSUMS_ALGORITHMS = "aether.checksums.algorithms";
    private static final String DEFAULT_CHECKSUMS_ALGORITHMS = "SHA-1,MD5";
    public static final String CONFIG_PROP_OMIT_CHECKSUMS_FOR_EXTENSIONS = "aether.checksums.omitChecksumsForExtensions";
    private static final String DEFAULT_OMIT_CHECKSUMS_FOR_EXTENSIONS = ".asc,.sigstore";
    private float priority;
    private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;

    public float getPriority() {
        return this.priority;
    }

    @Deprecated
    public Maven2RepositoryLayoutFactory() {
        this(new DefaultChecksumAlgorithmFactorySelector());
    }

    @Inject
    public Maven2RepositoryLayoutFactory(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector) {
        this.checksumAlgorithmFactorySelector = Objects.requireNonNull(checksumAlgorithmFactorySelector);
    }

    public Maven2RepositoryLayoutFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public RepositoryLayout newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryLayoutException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryLayoutException(repository);
        }
        List checksumsAlgorithms = this.checksumAlgorithmFactorySelector.selectList((Collection)ConfigUtils.parseCommaSeparatedUniqueNames((String)ConfigUtils.getString((RepositorySystemSession)session, (String)DEFAULT_CHECKSUMS_ALGORITHMS, (String[])new String[]{"aether.checksums.algorithms." + repository.getId(), CONFIG_PROP_CHECKSUMS_ALGORITHMS})));
        Set omitChecksumsForExtensions = Arrays.stream(ConfigUtils.getString((RepositorySystemSession)session, (String)DEFAULT_OMIT_CHECKSUMS_FOR_EXTENSIONS, (String[])new String[]{CONFIG_PROP_OMIT_CHECKSUMS_FOR_EXTENSIONS}).split(",")).filter(s -> s != null && !s.trim().isEmpty()).collect(Collectors.toSet());
        if (omitChecksumsForExtensions.stream().anyMatch(s -> !s.startsWith("."))) {
            throw new IllegalArgumentException(String.format("The configuration %s contains illegal values: %s (all entries must start with '.' (dot))", CONFIG_PROP_OMIT_CHECKSUMS_FOR_EXTENSIONS, omitChecksumsForExtensions));
        }
        return new Maven2RepositoryLayout(this.checksumAlgorithmFactorySelector, checksumsAlgorithms, omitChecksumsForExtensions);
    }

    private static class Maven2RepositoryLayout
    implements RepositoryLayout {
        private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;
        private final List<ChecksumAlgorithmFactory> configuredChecksumAlgorithms;
        private final Set<String> extensionsWithoutChecksums;

        private Maven2RepositoryLayout(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector, List<ChecksumAlgorithmFactory> configuredChecksumAlgorithms, Set<String> extensionsWithoutChecksums) {
            this.checksumAlgorithmFactorySelector = Objects.requireNonNull(checksumAlgorithmFactorySelector);
            this.configuredChecksumAlgorithms = Collections.unmodifiableList(configuredChecksumAlgorithms);
            this.extensionsWithoutChecksums = Objects.requireNonNull(extensionsWithoutChecksums);
        }

        private URI toUri(String path) {
            try {
                return new URI(null, null, path, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        public List<ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
            return this.configuredChecksumAlgorithms;
        }

        public boolean hasChecksums(Artifact artifact) {
            String artifactExtension = artifact.getExtension();
            for (String extensionWithoutChecksums : this.extensionsWithoutChecksums) {
                if (!artifactExtension.endsWith(extensionWithoutChecksums)) continue;
                return false;
            }
            return true;
        }

        public URI getLocation(Artifact artifact, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            path.append(artifact.getGroupId().replace('.', '/')).append('/');
            path.append(artifact.getArtifactId()).append('/');
            path.append(artifact.getBaseVersion()).append('/');
            path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
            if (artifact.getClassifier().length() > 0) {
                path.append('-').append(artifact.getClassifier());
            }
            if (artifact.getExtension().length() > 0) {
                path.append('.').append(artifact.getExtension());
            }
            return this.toUri(path.toString());
        }

        public URI getLocation(Metadata metadata, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            if (metadata.getGroupId().length() > 0) {
                path.append(metadata.getGroupId().replace('.', '/')).append('/');
                if (metadata.getArtifactId().length() > 0) {
                    path.append(metadata.getArtifactId()).append('/');
                    if (metadata.getVersion().length() > 0) {
                        path.append(metadata.getVersion()).append('/');
                    }
                }
            }
            path.append(metadata.getType());
            return this.toUri(path.toString());
        }

        public List<RepositoryLayout.ChecksumLocation> getChecksumLocations(Artifact artifact, boolean upload, URI location) {
            if (!this.hasChecksums(artifact) || this.isChecksum(artifact.getExtension())) {
                return Collections.emptyList();
            }
            return this.getChecksumLocations(location);
        }

        public List<RepositoryLayout.ChecksumLocation> getChecksumLocations(Metadata metadata, boolean upload, URI location) {
            return this.getChecksumLocations(location);
        }

        private List<RepositoryLayout.ChecksumLocation> getChecksumLocations(URI location) {
            ArrayList<RepositoryLayout.ChecksumLocation> checksumLocations = new ArrayList<RepositoryLayout.ChecksumLocation>(this.configuredChecksumAlgorithms.size());
            for (ChecksumAlgorithmFactory checksumAlgorithmFactory : this.configuredChecksumAlgorithms) {
                checksumLocations.add(RepositoryLayout.ChecksumLocation.forLocation((URI)location, (ChecksumAlgorithmFactory)checksumAlgorithmFactory));
            }
            return checksumLocations;
        }

        private boolean isChecksum(String extension) {
            return this.checksumAlgorithmFactorySelector.isChecksumExtension(extension);
        }
    }
}

