/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.security.util.KeyDerivationFunction;
import org.apache.nifi.security.util.crypto.AESKeyedCipherProvider;
import org.apache.nifi.security.util.crypto.BcryptCipherProvider;
import org.apache.nifi.security.util.crypto.CipherProvider;
import org.apache.nifi.security.util.crypto.NiFiLegacyCipherProvider;
import org.apache.nifi.security.util.crypto.OpenSSLPKCS5CipherProvider;
import org.apache.nifi.security.util.crypto.PBKDF2CipherProvider;
import org.apache.nifi.security.util.crypto.ScryptCipherProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(CipherProviderFactory.class);
    private static Map<KeyDerivationFunction, Class<? extends CipherProvider>> registeredCipherProviders = new HashMap<KeyDerivationFunction, Class<? extends CipherProvider>>();

    public static CipherProvider getCipherProvider(KeyDerivationFunction kdf) {
        logger.debug("{} KDFs registered", (Object)registeredCipherProviders.size());
        if (registeredCipherProviders.containsKey((Object)kdf)) {
            Class<? extends CipherProvider> clazz = registeredCipherProviders.get((Object)kdf);
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                logger.error("Error instantiating new {} with default parameters for {}", (Object)clazz.getName(), (Object)kdf.getName());
                throw new ProcessException("Error instantiating cipher provider");
            }
        }
        throw new IllegalArgumentException("No cipher provider registered for " + kdf.getName());
    }

    static {
        registeredCipherProviders.put(KeyDerivationFunction.NIFI_LEGACY, NiFiLegacyCipherProvider.class);
        registeredCipherProviders.put(KeyDerivationFunction.OPENSSL_EVP_BYTES_TO_KEY, OpenSSLPKCS5CipherProvider.class);
        registeredCipherProviders.put(KeyDerivationFunction.PBKDF2, PBKDF2CipherProvider.class);
        registeredCipherProviders.put(KeyDerivationFunction.BCRYPT, BcryptCipherProvider.class);
        registeredCipherProviders.put(KeyDerivationFunction.SCRYPT, ScryptCipherProvider.class);
        registeredCipherProviders.put(KeyDerivationFunction.NONE, AESKeyedCipherProvider.class);
    }
}

