/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.AuthenticationUtil;
import org.apache.pulsar.client.impl.auth.AuthenticationDataTls;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AuthenticationTls
implements Authentication,
EncodedAuthenticationParameterSupport {
    private static final long serialVersionUID = 1L;
    private String certFilePath;
    private String keyFilePath;

    public AuthenticationTls() {
    }

    public AuthenticationTls(String certFilePath, String keyFilePath) {
        this.certFilePath = certFilePath;
        this.keyFilePath = keyFilePath;
    }

    public void close() throws IOException {
    }

    public String getAuthMethodName() {
        return "tls";
    }

    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        try {
            return new AuthenticationDataTls(this.certFilePath, this.keyFilePath);
        }
        catch (Exception e) {
            throw new PulsarClientException((Throwable)e);
        }
    }

    public void configure(String encodedAuthParamString) {
        Map<String, String> authParamsMap = null;
        try {
            authParamsMap = AuthenticationUtil.configureFromJsonString(encodedAuthParamString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        authParamsMap = authParamsMap == null || authParamsMap.isEmpty() ? AuthenticationUtil.configureFromPulsar1AuthParamString(encodedAuthParamString) : authParamsMap;
        this.setAuthParams(authParamsMap);
    }

    @Deprecated
    public void configure(Map<String, String> authParams) {
        this.setAuthParams(authParams);
    }

    public void start() throws PulsarClientException {
    }

    private void setAuthParams(Map<String, String> authParams) {
        this.certFilePath = authParams.get("tlsCertFile");
        this.keyFilePath = authParams.get("tlsKeyFile");
    }

    @VisibleForTesting
    public String getCertFilePath() {
        return this.certFilePath;
    }

    @VisibleForTesting
    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

