/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaDefinitionBuilder;
import org.apache.pulsar.client.impl.schema.SchemaDefinitionImpl;

public class SchemaDefinitionBuilderImpl<T>
implements SchemaDefinitionBuilder<T> {
    public static final String ALWAYS_ALLOW_NULL = "__alwaysAllowNull";
    private Class<T> clazz;
    private boolean alwaysAllowNull = true;
    private Map<String, String> properties = new HashMap<String, String>();
    private String jsonDef;
    private boolean supportSchemaVersioning = false;

    public SchemaDefinitionBuilder<T> withAlwaysAllowNull(boolean alwaysAllowNull) {
        this.alwaysAllowNull = alwaysAllowNull;
        return this;
    }

    public SchemaDefinitionBuilder<T> addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public SchemaDefinitionBuilder<T> withPojo(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public SchemaDefinitionBuilder<T> withJsonDef(String jsonDef) {
        this.jsonDef = jsonDef;
        return this;
    }

    public SchemaDefinitionBuilder<T> withSupportSchemaVersioning(boolean supportSchemaVersioning) {
        this.supportSchemaVersioning = supportSchemaVersioning;
        return this;
    }

    public SchemaDefinitionBuilder<T> withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public SchemaDefinition<T> build() {
        this.properties.put(ALWAYS_ALLOW_NULL, this.alwaysAllowNull ? "true" : "false");
        return new SchemaDefinitionImpl<T>(this.clazz, this.jsonDef, this.alwaysAllowNull, this.properties, this.supportSchemaVersioning);
    }
}

