/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.reader;

import java.io.IOException;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class JsonReader<T>
implements SchemaReader<T> {
    private final Class<T> pojo;
    private final ObjectMapper objectMapper;

    public JsonReader(ObjectMapper objectMapper, Class<T> pojo) {
        this.pojo = pojo;
        this.objectMapper = objectMapper;
    }

    public T read(byte[] bytes) {
        try {
            return this.objectMapper.readValue(bytes, this.pojo);
        }
        catch (IOException e) {
            throw new SchemaSerializationException((Throwable)e);
        }
    }
}

